/*
 Generate a pretty coordinate system for illustrations and so on.
*/
/*
    Size: length of the CS arrows
    Thickness: Thickness of arrow shaft
    Polar: if 'true' the Y-axis is not displayed
    Points: units, point(s) portion(s) of arrows.
    * Points.y endpoint-point
    * Points.x set to '0' (no point at the origin side)
    * Points.z if 'undef' Points values are absolute, if '!undef' Points values are interpreted as fractions of the vector's length by 'Arrow()'.
*/

module CoordinateSystem(Size=1,Thickness=0.05,Points=[0,0.4,1],Polar=false,Alpha=1){

_Points=undef==Points.z
?   [0,Points.y]
:   [0,Points.y,Points.z];

color("blue",Alpha)
Arrow([0,0,Size],Base=[0,0,0],Points=_Points,Thickness=Thickness);
if(!Polar)color("green",Alpha)
Arrow([0,Size,0],Base=[0,0,0],Points=_Points,Thickness=Thickness);
color("red",Alpha)
Arrow([Size,0,0],Base=[0,0,0],Points=_Points,Thickness=Thickness);

}

