/*
  Generate a cylinder between two points.
  Used by 'ShowCurve()' to visualise a curve...
 */
module CylinderBetween(Point1,Point2,Radius=0.1)
{
    $fn=Segments(Radius);
    Height=Modulus(Point2-Point1);
    // Roll=90 places flat side of $fn=(n*2)-sided cylinders 'on top'.
    Position(Point2-Point1,Point1,Roll=90)
    cylinder(h=Height,r=Radius);
}

