/*
  Generate graph paper on Z=0. Or just below it...
  NOTE :    'AutoThickness' needs Preview or Render after zooming in or out
  to recalculate grid-line thickness based on $vpd (View-Point Distance).
*/
module GraphPaper(Major=1.0,Minor=0.1,Size=[[0,0],[1,1]],LineFactor=100,
                  Color=GPG,Alpha=0.5,AutoThickness=true,2D=true)
{
    R=AutoThickness
        ?   2/LineFactor*pow($vpd,0.3)
        :   4/LineFactor;

    MajVerMin=ceil((Size.x.x+Tad)/Major);
    MajVerMax=floor((Size.y.x-Tad)/Major);
    MajHorMin=ceil((Size.x.y+Tad)/Major);
    MajHorMax=floor((Size.y.y-Tad)/Major);
    MinVerMin=ceil((Size.x.x+Tad)/Minor);
    MinVerMax=floor((Size.y.x-Tad)/Minor);
    MinHorMin=ceil((Size.x.y+Tad)/Minor);
    MinHorMax=floor((Size.y.y-Tad)/Minor);

    color(Color,Alpha){
        // Major verticals
        for(Index=[MajVerMin:MajVerMax])
            translate([Index*Major,0,0])
            Line([0,Size.x.y],[0,Size.y.y],Thickness=R,2D=2D);
        // Major horizontals
        for(Index=[MajHorMin:MajHorMax])
            translate([0,Index*Major,0])
            Line([Size.x.x,0],[Size.y.x,0],Thickness=R,2D=2D);
        // Minor verticals
        for(Index=[MinVerMin:MinVerMax])
            translate([Index*Minor,0,0])
            Line([0,Size.x.y],[0,Size.y.y],Thickness=R/2,2D=2D);
        // Minor horizontals
        for(Index=[MinHorMin:MinHorMax])
            translate([0,Index*Minor,0])
            Line([Size.x.x,0],[Size.y.x,0],Thickness=R/2,2D=2D);
    }
}
