/* TODO: Inward arrows at cardinal points.
  Generate a protractor rosette for measuring rotation angles.
*/
module Protractor(Radius=100,Scales=[1,10,45,90,60],Center=false)
{
    ScaleStep=GCD(Scales);
    Width=3;
    Len=len(Scales);
    Step=min(1,ScaleStep);

    TMM=5; // Text minimum mark size.
    SMW=3; // Standard mark width.

    // Set radial dimensions of the marks.
    Dims =[for (I=[0:len(Scales)-1]) min(Scales[I]*Radius*Tau/360,SMW)];
    // Generate a list of radial mark positions.
    Radii=[Radius, for (I=[0:len(Dims)-1])
            Radius-ArraySum([for (J=[I:-1:0]) Dims[J] ])
        ];

    Marks=
    [ for(I=[0:Len-1])
        let(
            Foo=(360/Scales[I])%2!=0?Error("Scales must be an even divisor of 360, not ",Scales[I]):undef,
            OD=Radii[I],
            ID=Radii[I+1]
        )
        // Staggered start.
        for(Angle=[Scales[I]*(I%2):Scales[I]*2:360-Scales[I]*(2-(I%2))])
        // Solid start.
//        for(Angle=[Scales[I]:Scales[I]*2:360-Scales[I]])
        [for(Bngle=[0:Step:Scales[I]])
        [cos(Angle+Bngle)*ID,sin(Angle+Bngle)*ID],
        for(Cngle=[Scales[I]:-Step:0])
        [cos(Angle+Cngle)*OD,sin(Angle+Cngle)*OD]]
    ];

    Middle=
    [ for(Angle=[Scales[Len-1]*(Len%2):Scales[Len-1]*2:360-Scales[Len-1]*(2-(Len%2))])
        [for(Bngle=[0:Step:Scales[Len-1]])
        [cos(Angle+Bngle)*Radii[len(Radii)-1],sin(Angle+Bngle)*Radii[len(Radii)-1]],[0,0]]
    ];

    Polygons=Center
    ?   concat(Marks,Middle)
    :   Marks;

    color(OSG)
    Ring(Radius+Smidge,Center?(Radius-Smidge):(Radius-Radii[len(Radii)-1]+Smidge));

    translate([0,0,Smidge])
    color(BLK)
    for(Polygon=Polygons)
    polygon(Polygon);

}

