/*
  TODO: -Centered ruler, marks from center both ways, text both ways.
        -Cylindrical ruler, rotatable, marked around circumference.

  Don't you hate it when you zoom in and the axis and scale disappear?
  Here's a ruler to check your dimensions.
  The ruler is created below the positive X-axis, 'R' and 'T' are a rotation
  and translation vector to move the ruler where you need it to be.

  NOTE: Text on a long ruler can slow things down a little...
*/
module Ruler(Length=100,Divisions=[1,5,10,50],Text=false,Alpha=1,MaxMkHeight=1)
{
    MinMkText=1; /* Text minimum mark size. */

    /* Set height dimensions of the marks. The marks have width and height identical to their *Divisions* unit, up to a maximum of MaxMkHeight, beyond which they become rectangular, with MaxMkHeight as their height; their width (obviously) remains equal to their *Divisions* unit.. */
    MarkHeight =[for (I=[0:Len(Divisions)]) min(Divisions[I],MaxMkHeight)];
    /* Generate a list of mark-to-edge distances, larger marks are farther from the edge. */
    EdgeDistance=[0, for (I=[0:Len(MarkHeight)])
            ArraySum([for (J=[I:-1:0]) MarkHeight[J] ])
        ];
    /* Ruler lateral dimension. */
    Width=max(EdgeDistance[Len(EdgeDistance)],1);

    /* Generate the polygons for the marks. */
    Polygons=
    [ for(I=[0:Len(Divisions)])
        for(X=[Divisions[I]*(I%2):Divisions[I]*2:Length-Divisions[I]*(2-(I%2))])
        [
            [X,-EdgeDistance[I+1]],[X+Divisions[I],-EdgeDistance[I+1]],
            [X+Divisions[I],-EdgeDistance[I]],[X,-EdgeDistance[I]]
        ]
    ];

    if(Text){
        Color=[YLW,BLK];
        /* Find first scale larger than or equal to MinMkText, numbering lesser scales isn't too useful. Probably. */
        Index=FindGTE(MinMkText,Divisions);
        /* Locations for text. */
        Locations=
        [
            for(X=[0:Divisions[Index]:Length-Divisions[Index]])
                [X,-EdgeDistance[Index]-(EdgeDistance[Index+1]-EdgeDistance[Index])/2]
        ];
        /* Text on topside. */
        for (I=[0:Len(Locations)]){
            color(Color[I%2+Index%2],Alpha)
            translate([0.1+Locations[I].x,Locations[I].y,0])
            linear_extrude(Hint*2)
            text(text=str(Locations[I].x),font="Liberation Sans",
                size=min(Divisions[Index]/3,0.8*MaxMkHeight),
                halign="left",valign="center"
            );
        }
        /* Text on flipside. */
        for (I=[0:Len(Locations)]){
            color(Color[I%2+Index%2],Alpha)
            translate([0.1+Locations[I].x,Locations[I].y,0])
            rotate([0,180,0])
            linear_extrude(Hint*2)
            text(text=str(Locations[I].x),font="Liberation Sans",
                size=min(Divisions[Index]/3,0.8*MaxMkHeight),
                halign="right",valign="center"
            );
        }
    }

    // The ruler.
    color(YLW,Alpha)
    translate([0,-Width-Thought,-Hint/2])
    linear_extrude(Hint)
    square([Length,Width+Thought*2]);
    // The marks, they protrude through the ruler, top and bottom.
    color(BLK,Alpha)
    translate([0,0,-Hint*1.5])
    for(Polygon=Polygons)
    linear_extrude(Hint*3)
    polygon(Polygon);
}

