module SimpleGauge(Min,Max,Indicated,Diameter,Text){

    scale([Diameter/100,Diameter/100,1]){
        /* Scale. */
        color(WHT)
        translate([0,0,0])
        GaugeScale(-150,150,0,100,0,10,1,45,4,0,"rounded","rounded",1,6,0,0,0);

        /* Face plate. */
        color(DSG)
        linear_extrude(0.5)
        circle(r=50);

        /* Hand. */
        rotate([0,0,-Indicated/(Max-Min)*300+150])
        translate([0,0,1.5])
        SimpleHand(40,3,1,"orange",CHK);

        /* Text. */
        rotate([0,0,-90])
        color("orange")
        SimpleCircleText(Text,4,45,Thickness=1,Center=true,CW=false,Font="Noto Mono",Spacing=0.9);
    }

}
