module StarCap(Points,Radius,Schlaefli,Height){
    Vertices=   concat(
                    /* The points. */
                    PadArray(
                        Star(Points,Radius,Schlaefli)[0]
                    ),
                    /* The peak. */
                    [[0,0,Height]]
                );
    Peak=len(Vertices)-1;
    Faces=  [
                for (I=[0:Points-1]) [I,I+Points,Peak],
                /* %Points makes reference cyclic on *Vertices*. */
                for (I=[0:Points-1]) [I+Points,(I+1)%Points,Peak],
                /* Turn the two *Faces* arrays into one. */
                FlattenArray(
                    [ for (I=[0:Points-1]) [I,I+Points] ]
                )
            ];
    /* Make the cap. */
    polyhedron(Vertices,Faces,10);
}
