R=IsOdd(floor($t*10))?50:0;

module ToonCar(Color=CPR){

LeftTurn=[255/255,(165+R)/255,0];
RightTurn="orange";
LeftTail=[(205+R)/255,0/255,0];
RightTail="red";

// Wheels
translate([-7.5,-5,0])
LinearArray(Spacing=[15,10,0],Number=[2,2,1])
union(){
    color("black")
    rotate([90,0,0])
    ChamferedCylinder(2.5,2,0.2,ChamferAngle=90);
    color("silver")
    rotate([90,0,0])
    cylinder(r=1,h=2.5,center=true);
}

// Body
color(Color)
translate([0,0,1])
rotate([0,90,0])
linear_extrude(24,center=true)
RectangularProfile(5,11,0.5,1,Centered=true);

// Front panel
color("darkslategrey")
translate([11,0,1])
rotate([0,90,0])
linear_extrude(1,center=true)
RadiusedRectangle(5-Smidge,11-Smidge,1,Centered=true);

// Rear panel
color(CPR)
translate([-11,0,1])
rotate([0,90,0])
linear_extrude(1,center=true)
RadiusedRectangle(5-Smidge,11-Smidge,1,Centered=true);

// Headlights
color("white")
translate([11.7,4.5,2.5])
rotate([0,90,0])
ChamferedCylinder(1-Smidge,1.5,0.3,ChamferAngle=90);
color("white")
translate([11.7,-4.5,2.5])
rotate([0,90,0])
ChamferedCylinder(1-Smidge,1.5,0.3,ChamferAngle=90);

// Indicators
color(LeftTurn)
translate([11.5,5.25,0.8])
rotate([0,90,0])
ChamferedCylinder(0.5,1.5,0.2,ChamferAngle=90);
color(RightTurn)
translate([11.5,-5.25,0.8])
rotate([0,90,0])
ChamferedCylinder(0.5,1.5,0.2,ChamferAngle=90);

// Taillights
color(LeftTail)
translate([-11.7,4.5,2.5])
rotate([0,90,0])
ChamferedCylinder(1-Smidge,1.5,0.3,ChamferAngle=90);
color(RightTail)
translate([-11.7,-4.5,2.5])
rotate([0,90,0])
ChamferedCylinder(1-Smidge,1.5,0.3,ChamferAngle=90);

// Bumpers
color("silver")
translate([12,0,-0.7])
BallCylinderBetween([0,-5.5,0],[0,5.5,0],Radius=0.8,Ends="Both");
color("silver")
translate([-12,0,-0.7])
BallCylinderBetween([0,-5.5,0],[0,5.5,0],Radius=0.8,Ends="Both");

// Grille
color("silver")
translate([11.5,-2.25,0])
LinearArray(Spacing=[1,1.5,1],Number=[1,4,1])
BallCylinderBetween([0,0,-1],[0,0,2],Radius=0.5,Ends="Both");

// Roof
color(Color)
translate([0,0,4])
difference(){
    rotate([0,90,0])
    linear_extrude(12,center=true,convexity=10)
    RectangularProfile(7,10,0.5,1,Centered=true);

    translate([2.8,0,0])
    rotate([0,90,90])
    linear_extrude(12,center=true,convexity=10)
    RadiusedRectangle(5,4.5,1,Centered=true);
    translate([-2.8,0,0])
    rotate([0,90,90])
    linear_extrude(12,center=true,convexity=10)
    RadiusedRectangle(5,4.5,1,Centered=true);
    }

// Steering wheel
color("black")
translate([3,2,3.5])
rotate([0,120,0])
Torus(1.5)
circle(r=0.2);

// Glass
color("silver",0.3)
translate([0,0,4])
rotate([0,90,0])
linear_extrude(12-Smidge,center=true)
RadiusedRectangle(7-Smidge,10-Smidge,1,Centered=true);

}

