/*
  Create a water surface effect for floating objects (i.e. boats etc.).

  PlaneAngle:   Negative-Y Rotate children() (positive x-axis goes 'up')
                to simulate planing, the boat's stern must be on the origin and the bow on the positive x-axis.
  Depth:        Lower children() deeper into the 'water'.
  Color:        Well...
  Alpha:        You know.
  Horizon:      The size of the puddle your boat floats in.

  Waterline() is just a thin sheet of blue, transparent, and created after its children() so we can see the underwater-ship through it. It looks pretty good for such a simple thing--if I say so myself... Have a look at TheGHOUL/Demofiles/Demo_Boat.scad if you fancy.
*/
module Waterline(PlaneAngle=0,Depth=0,Color=BLU,Alpha=0.3,Horizon=10000)
{
    rotate([0,-PlaneAngle,0])
    translate([0,0,-Depth])
    children(); // (Women and) chidren() first. -- So we can see 'below water'.
    color(Color,Alpha)
    cube([Horizon,Horizon,0.010],center=true); // The 'water'.
}

