
/*
  See ./Documents/'BeltDimensions.jpg' in this directory for a legend
  of the dimension nomenclature.
*/

/*
  Belt data 'database' function.
  Add additional type data here.
*/
function BeltData(Type="GT3-2")=
    Type=="GT3-2"
    ?   [
        2.0, // Pitch                                                   P
        0.555, // TipRadius                                             R3
        1.0, // FlankRadius                                             R2
        0.15, //RootRadius                                              R1
        1.38, // HBelt, total height of belt and tooth                  H
        0.75, // HTooth, height of tooth                                h
        0.63, // IBelt, thickness (height) of belt                      i
        0.254, // PLD, pitch Line location                              PLD
        0.4 // FlankRadiusOffsetY, The flank radii are offset to +/- Y  b
    ]
    :
    Type=="GT3-3"
    ?   [
        3, // Pitch
        0.85, // TipRadius
        1.52, // FlankRadius
        0.25, //RootRadius
        2.4, // HBelt, total height of belt and tooth
        1.14, // HTooth, height of tooth
        1.26, // IBelt, thickness (height) of belt
        0.381, // PLD, pitch Line location
        0.61 // FlankRadiusOffsetY, The flank radii are offset to +/- Y
    ]
    :
    undef
;

// EOF =========================================================================
