/*
  *Thickness*, black hole.
*/
function CamWheel(OD=10,Cams=1,Step=3,ID=1,Rake=0,Thickness)=
    let(
        A=OD/2-Step, // Inner dimension.
        B=OD/2,
        CamAngle=360/Cams-Rake,
        Steps=ceil(Segments(B)*CamAngle/360),
        RInc=Step/Steps,
        AInc=CamAngle/Steps,
        Bore=(undef==ID||0==ID)
        ?   []
        :   Circle(ID/2),
        Points=[
            for(Idex=[0:Cams-1])
            for(Jdex=[0:Steps])
            PolarToVector([OD/2-Jdex*RInc,Jdex*AInc+Idex*360/Cams])
        ]
    )
    [
        concat(Points,Bore),
        [
            RangeToTuple([0:Len(Points)]),
            Bore==[]?Bore:RangeToTuple([len(Points):len(Points)+Len(Bore)])
        ]
    ]
;

module CamWheel(OD=10,Cams=1,Step=3,ID=1,Rake=0,Thickness=1){

    CW=CamWheel(OD,Cams,Step,ID,Rake);
    linear_extrude(Thickness)
    polygon(CW[0],CW[1]);

}

