/*
 Span is given in tooth-pitches to fit between pallets. Escapement is constructed around an (imaginary) escape wheel with it's arbor centered on the origin.
 Equidistand impulse (Circular=true) or locks (Circular=false).
 Rotation is pallet rotation, from design stage.
*/
module DeadBeatEscapement(NTeeth=15,ToothW=3,PalW=3,Span=undef,Circular=true,Drop=1,Lock=1,Lift=2,RadPalLgt=15,Rotation=0){


    TipRadius=NTeeth*(2*PalW+2*ToothW)/(Tau*(360-NTeeth*Drop)/360);
    Print(["Tip Circle Dia. = ",TipRadius*2]);
    PitchAngle=360/NTeeth;
    SP=undef==Span
        ?   round(1/4+NTeeth/4) // Rounding 'weighted upwards' by 1/4.
        :   Span;
    Print(["Span = ",SP+1," teeth."]);
    SpanAngle=SP*PitchAngle;
    Print(["Span angle = ",SpanAngle," degrees."]);
    /* A couple radial dimensions (in degrees, obvs.). */
    ToothRadDim=2*atan(ToothW/2/TipRadius);
    PalletRadialDim=2*atan(PalW/2/TipRadius);
    Embrace=(SpanAngle+ToothRadDim+PalletRadialDim+Drop)/2;
    /* Tanpoint is the center of the palate on the pin PCD. */
    YTanPoint=sin(Embrace)*TipRadius;
    XTanPoint=cos(Embrace)*TipRadius;
    /* Leg is line from TanPoint to pallet rotation center. */
    XLeg=YTanPoint/tan(90-Embrace);
    /* CD is center distance between escapewheel and pallet rotation center. */
    CD=XTanPoint+XLeg;
    Print(["CD = ",CD,"."]);
    Leg=sqrt(Pow2(YTanPoint)+Pow2(XLeg));
    /* Pallet radii. */
    RMinPal=Leg-PalW/2;
    RMaxPal=Leg+PalW/2;
    /* Im-po-tant for pallet construction. */
    PalAngle=90-Embrace;

    End=180-PalAngle-RadPalLgt;
    PalMid=180-PalAngle;
    EpEc=PalMid-(Lift-Lock)/2;
    EpDc=PalMid+(Lift+Lock)/2;
    XpEc=PalMid-(Lift-Lock)/2;
    XpDc=PalMid+(Lift+Lock)/2;

    /* Entry pallet polygon. */
    EPallet=concat(
        Arc(End,EpEc-End,RMaxPal),
        Arc(EpDc,End-EpDc,RMinPal)
    );

    /* Exit pallet polygon. */
    XPallet=AffineScale(Vector=[1,-1,1],
    concat(
        Arc(End,XpDc-End,RMaxPal),
        Arc(XpEc,End-XpEc,RMinPal)
    ));

    /* Circular arm polygon. */
    PalletArmC=concat(
        Arc(-Embrace,Embrace*2,TipRadius+9),
        Arc(Embrace,-Embrace*2,TipRadius+6)
    );

    /* Circular arm polygon. */
    PalletArmS=[
        PolarToVector([TipRadius+9,-Embrace-2]),
        PolarToVector([CD+4,0]),
        PolarToVector([TipRadius+9,Embrace+2]),
        PolarToVector([TipRadius+6,Embrace+2]),
        PolarToVector([CD-4,0]),
        PolarToVector([TipRadius+6,-Embrace-2])
    ];

    /* The pallets. */
    color(BLU)
    translate([CD,0,-PalW/2])
    rotate([0,0,Rotation]){
        linear_extrude(PalW)
        polygon(EPallet);
        linear_extrude(PalW)
        polygon(XPallet);
    }

    /* Arms, circular. */
*    color(DSG){
        translate([CD,0,0]){
            rotate([0,0,Rotation]){
                translate([-CD,0,-2])
                linear_extrude(4)
                polygon(PalletArmC);
                translate([-(CD-TipRadius-8)/2,0,0])
                cube([CD-TipRadius-8,3,4],center=true);
            }
            cylinder(r=4,h=4,center=true);
        }
    }

    /* Arms, straight. */
    color(DSG){
        translate([CD,0,0]){
            rotate([0,0,Rotation]){
                translate([-CD,0,-2])
                linear_extrude(4)
                polygon(PalletArmS);
            }
            cylinder(r=4,h=4,center=true);
        }
    }

}


