/*
  Rim is part outside pins.
*/
module LanternGearFlange(PinCD=undef,NPins=10,PinD=2,Rim=2,Width=10,Flange=2,ID=5,PalW=2,Drop=1,Single=false,Interference=0)
{
    PCD=undef==PinCD
    // Drop is in degrees, should this become a dimension instead?
        ?   NPins*(2*PalW+PinD)/PI*360/(360-NPins*Drop)
        :   PinCD;

    Print(["Lantern PCD ",PCD," circular pitch ",PCD*PI/NPins,"."]);

/* TODO: MAJOR TODO */
//    PinHole=Circle(r=PinD/2);

    color(CPR){
        translate([0,0,-(Width+Flange)/2])
        cylinder(r=(PCD+PinD+Rim*2)/2,h=Flange,center=true);
        if(!Single)
        translate([0,0,(Width+Flange)/2])
        cylinder(r=(PCD+PinD+Rim*2)/2,h=Flange,center=true);
    }

}

module LanternGear(PinCD=undef,NPins=10,PinD=2,Rim=2,Width=10,Flange=2,ID=5,PalW=2,Drop=1,Single=false,Interference=0.05)
{
    PCD=undef==PinCD
    // Drop is in degrees, should this become a dimension instead?
        ?   NPins*(2*PalW+PinD)/PI*360/(360-NPins*Drop)
        :   PinCD;

    Print(["Lantern PCD ",PCD," circular pitch ",PCD*PI/NPins,"."]);


    color(DSG)
    CircularArray(PCD/2,360,NPins)
    cylinder(r=PinD/2,h=Width+Flange*2+Tad,center=true);

    color(CPR){
        translate([0,0,-(Width+Flange)/2])
        cylinder(r=(PCD+PinD+Rim*2)/2,h=Flange,center=true);
        if(!Single)
        translate([0,0,(Width+Flange)/2])
        cylinder(r=(PCD+PinD+Rim*2)/2,h=Flange,center=true);
    }

}
