function Snail(OD=80,Steps=12,Drop=2,ID=10)=
    let(
        Angle=360/Steps,
        Points= FlattenArray([
            for(Sdex=[0:Steps-1])
                AffineRotate([0,0,Sdex*Angle],
                    Arc(0,Angle,OD/2-Sdex*Drop))
        ]),
        Bore=0==ID
            ?   []
            :   Circle(ID/2)
    )
    [
        concat(Points,Bore),
        [
            RangeToTuple([0:Len(Points)]),
            Bore==[]?Bore:RangeToTuple([len(Points):len(Points)+Len(Bore)])
        ]
    ]
;

module Snail(OD=80,Steps=12,Drop=2,ID=10,Thickness=10){

    P=Snail(OD,Steps,Drop,ID);
    translate([0,0,-Thickness/2])
    linear_extrude(Thickness)
    polygon(P[0],P[1]);

}

