/*
  Generate involute gears. Returns a set of 2D vertices, ready to turn into a polygon.

  I'm getting lazy; if you don't know what the terms below mean, go to TheGHOUL's documentation, I'm not doing it all twice...

  Module,       scalar,     teeth dimension.
  Teeth,        integer,    number of teeth.
  Addendum,     scalar,     value in Modules, mostly 1.
  Dedendum,     scalar,     value in Modules, mostly 1.25.
  Shift,        scalar,     value in Modules
  PressureAngle,scalar,     usually 20, sometimes 14.5.
  Allowance,    scalar,     value in native units, probably mm.
  Title,        string,     identifier for this gear.
  Work,
*/
function InvoluteGear(Module,Teeth,Addendum=1,Dedendum=1.25,Shift=0,PressureAngle=20,Allowance=0,Title="",Work=undef)=
    let(
        PitchRadius=Module*Teeth/2,
        TipRadius=PitchRadius+Module*(Addendum+Shift),
        Tooth=InvoluteGearTooth(Module,Teeth,Addendum,Dedendum,Shift,PressureAngle,Allowance,Title,Work)
    )
    CropArray(FlattenArray(
        [
            for(Idex=[1:Teeth])
                AffineRotate([0,0,360*Idex/Teeth],Tooth)
        ]
    ))
;

/*
  Gets vertices from the InvoluteGear() function and generates a polygon. See above.
*/
module InvoluteGear(Module,Teeth,Addendum=1,Dedendum=1.25,Shift=0,PressureAngle=20,Allowance=0,Title="u",Work=undef){

    polygon(
        InvoluteGear(Module,Teeth,Addendum,Dedendum,Shift,PressureAngle,Allowance,Title,Work)
    );
}

/*
  To make life easy for the peeps between CAN and MEX.
  Works in any unit, even fathoms... Them's mighty big gears, matey! Arrrr!
*/
function InvoluteGearDP(DiametralPitch,Teeth,Addendum=1,Dedendum=1.25,Shift=0,PressureAngle=20,Allowance=0,Title="",Work=undef)=
    InvoluteGear(1/DiametralPitch,Teeth,Addendum,Dedendum,Shift,PressureAngle,Allowance,Title,Work)
;

module InvoluteGearDP(DiametralPitch,Teeth,Addendum=1,Dedendum=1.25,Shift=0,PressureAngle=20,Allowance=0,Title="",Work=undef){

    polygon(
        InvoluteGear(1/DiametralPitch,Teeth,Addendum,Dedendum,Shift,PressureAngle,Allowance,Title,Work)
    );
}

/*
  If you _really_ want to specify Circular Pitch.
  Why?
*/
function InvoluteGearCP(CircularPitch,Teeth,Addendum=1,Dedendum=1.25,Shift=0,PressureAngle=20,Allowance=0,Title="",Work=undef)=
    InvoluteGear(CircularPitch/PI,Teeth,Addendum,Dedendum,Shift,PressureAngle,Allowance,Title,Work)
;

module InvoluteGearCP(CircularPitch,Teeth,Addendum=1,Dedendum=1.25,Shift=0,PressureAngle=20,Allowance=0,Title="",Work=undef){

    polygon(
        InvoluteGear(CircularPitch/PI,Teeth,Addendum,Dedendum,Shift,PressureAngle,Allowance,Title,Work)
    );
}

/*
  If you just want a certain Pitch Radius.
  Here there be dragons!
*/
function InvoluteGearPR(PitchRadius,Teeth,Addendum=1,Dedendum=1.25,Shift=0,PressureAngle=20,Allowance=0,Title="",Work=undef)=
    InvoluteGear(PitchRadius/Teeth,Teeth,Addendum,Dedendum,Shift,PressureAngle,Allowance,Title,Work)
;

module InvoluteGearPR(PitchRadius,Teeth,Addendum=1,Dedendum=1.25,Shift=0,PressureAngle=20,Allowance=0,Title="",Work=undef){

    polygon(
        InvoluteGear(PitchRadius/Teeth,Teeth,Addendum,Dedendum,Shift,PressureAngle,Allowance,Title,Work)
    );
}

/* Some miscellaneous notes ====================================================

  LineOfContact=
    Sqrt(Pow2(OutsideRadiusPinion)-Pow2(BaseRadiusPinion))
    +Sqrt(Pow2(OutsideRadiusGear)-Pow2(BaseRadiusGear))
    -Sqrt(Pow2(CenterDistance)-Pow2(BaseRadiusPinion+BaseRadiusGear))

  CircularPitch=
    Pi/DiametralPitch
    Pi*Module

  BasePitch=
    CircularPitch*cos(PressureAngle)

  ContactRatio=
    LineOfAction/BasePitch

GearModules=
    [
        [
            0.1,0.2,0.3,0.4,0.5,0.6,0.8,1,   // Instrumentation
            1.25,1.5,2,2.5,3,                // Fractional horsepower
            4,5,6,8,10,12,16,20,25,32,40,50  // Multi horsepower
        ],
        [
            0.15,0.25,0.35,0.45,0.55,0.7,0.75,0.9,1.125,1.375,1.75,2.25,2.75,3.5,4.5,5.5,6.5,7,9,11,14,18,22,28,36,45 // Non preferred series.
        ]
    ];

DiametralPiches= // For the peeps between CAN and MEX.
    [
        [
            2,4,5,6,8,          // Multi horsepower
            10,12,16,20,        // Fractional horsepower
            24,32,48,64,96,120  // Instrumentation
        ]
    ];

============================================================================= */
