/*
  You will probably never use this function, but as they say; never say never...
*/
/*
  I'm getting lazy; if you don't know what the terms below mean, go to TheGHOUL's documentation, I'm not doing it all twice...

  PitchRadius,  scalar,     radius of the pitch circle.
  Teeth,        integer,    number of teeth.
  PressureAngle,scalar,     usually 20, sometimes 14.5.
  Addendum,     scalar,     value in Modules, mostly 1.
  Dedendum,     scalar,     value in Modules, mostly 1.25.
  Allowance,    scalar,     value in native units, probably mm.
  Title,        string,     identifier for this gear.
*/
function InvoluteGearTooth(Module,Teeth,Addendum=1,Dedendum=1.25,Shift=0,PressureAngle=20,Allowance=0,Title="",Work=undef)=
    let(
        PitchRadius=Module*Teeth/2,
        BaseRadius=PitchRadius*cos(PressureAngle),
        RootRadius=PitchRadius+Module*(Shift-Dedendum),
        TipRadius=PitchRadius+Module*(Shift+Addendum),
        // Angular pitch.
        PitchAngle=360/Teeth,
        // Profile shift 'compensation' angle.
        ShiftAngle=Deg(Shift*Module*tan(PressureAngle)/PitchRadius),
        // *Work* is not a recognised gear term. I use it for the distance the mating gear tip protrudes past the pitch radius (i.e., the mating gear's addendum) as a coefficient of the Module; it's part of the working depth (the 'tip-to-tip' overlap of the teeth on the centreline), hence the name.
/* HERE Check with negative shift. */
        _WorkRadius=Work==undef
        // Mating gear Addendum is not specified; assume same as this gear.
        ?   PitchRadius+Module*(Shift-Addendum)
        // Mating gear Addendum is specified.
        :   PitchRadius-Module*Work,
/* HERE This can be optimised using *ContactPoint* --see InvoluteInfo.scad-- but for now this will work just fine (working tooth is shorter than rack after all).*/
        WorkRadius=_WorkRadius+(_WorkRadius-RootRadius)*0.2,
        // The involute must not extend below:
        InvoluteStartRadius=max(
            BaseRadius,
            WorkRadius
        ),
// INVOLUTE ====================================================================
        Involute=
            AffineRotate(
                [0,0,
                    // Move pitch-point onto X-axis.
                    InvoluteVertexAngle(BaseRadius,PitchRadius)
                    // Center tooth gap on X-axis with compensation for profile shift.
                    -PitchAngle/4+ShiftAngle
                ],
                Involute(BaseRadius,TipRadius,InvoluteStartRadius)
            ),
        InvoluteStartAngle=atan(Involute[0].y/Involute[0].x),
        // Believe it or not, there's no 'standard' tooth-shape below the involute, frankly, gear manufacturers do whatever they please. Usually it's simply the result of whatever the (radiused) tip of the cutting tool (rack or hob) leaves behind.
        // The only time there are true _limits_ is when there is natural undercut, and a trochoid shape has to be used to prevent interference. Of course, this situation is to be avoided--probably by employing profile shift--but needs must where the devil drives, and all that. When a trochoid _is_ used, we only use the part between the Base- and 'Work' radii, below the 'Work' radius, we simply use a radiused fillet. There are long-winded and complex articles available on the interwebs, dealing with this matter, and--frankly--none of it matters in this context.
        // Other than that, the only consideration is durability, so--generally--a nice radius to prevent stress risers while preserving tooth strength is what we're after.
        // Here, we use the biggest radius to fit the clearance (Dedendum-Addendum), tangential to both the rootcircle and the tooth-flank, or--if FullRoot is _true_--we use the biggest radius that fits between and is tangential to the two tooth flanks; this will likely (read: certainly) descend below the RootCircle!
        // All this rigmarole provides us with the largest possible radii, hopefully reducing any stress, and making for the strongest possible teeth. Perhaps. If you'd like to GTS and get thoroughly confused; like I already mentioned, there's a plethora of information on the interwebs.
// TROCHOID ====================================================================
        UnderCut=BaseRadius>WorkRadius+$fs
        // There is undercut. We need a trochoid extension to the flank.
        ?   let(
                    TV=UnderCut(BaseRadius,RootRadius,PitchRadius),
                    TVEnd=TV[Len(TV)],
                    // In a moment we're going to trim and rotate the trochoid, but we're basing the rotation on the _untrimmed_ end of the curve.
                    UnderCutEndAngle=atan(TVEnd.y/TVEnd.x),
                    // Radii of the vertices, to help us find our trim-point.
                    TR=[for(V=TV)Modulus(V)]
                )
                // Lose everything below the _WorkRadius, as well as the last vertex, which 'overlaps' the start of the involute. Then rotate to match up with the involute.
            AffineRotate(
                [0,0,InvoluteStartAngle-UnderCutEndAngle],
                SubArray(TV,FindGTE(WorkRadius,TR),-2)
            )
        // Not sufficient (at least $fs) undercut to justify a trochoid...

        :   [],
        Flank=concat(UnderCut,Involute),
        // We now have a tooth flank, all that remains is the fillet below the 'Work' radius.
        FlankStartAngle=atan(Flank[0].y/Flank[0].x),
        // StartDirection() provides a polar, [2] is the azimuth.
        FlankStartDirection=StartDirection(Flank)[2],

        Alpha=-FlankStartDirection,
        C=FindCentre(RootRadius,Flank[0],Alpha),
        R=Modulus(C)-RootRadius,
        Beta=atan(C.y/C.x),
        Gamma=270-Alpha-Beta,
// ROOT FILLET =================================================================
        Fillet=SubArray(AffineTranslate(C,Arc(180,Gamma,R),true),0,-2),

/*
Delta=atan(Fillet[0].y/Fillet[0].x),
Foo=Alert(["Fillet overlap"],0,Delta>0),
Daz=Print(["Delta= ",Delta]),
Dd=atan($fs/2/Fillet[0].x),

(-Fillet[0].y<$fs
?   []
:   SubArray(Arc(-Delta,Delta-Dd,Modulus(Fillet[0])),1),
*/

// ROOT RADIUS =================================================================
        Floor=[[RootRadius,0]],

// THE TOOTH ===================================================================
        // One side...
        Shape=AffineRotate([0,0,PitchAngle/2],concat(Floor,Fillet,Flank),Output2D=true),
        // Mirror and add second side, after dropping the first vertex.
        Tooth=concat(AffineScale([1,-1,1],Shape,Output2D=false),ReverseArray(RightArray(Shape,1))),

        // Inform the user, only when a name for the gear has been provided.
        Bar=Print([Title," has OD ",TipRadius*2," and PCD ",PitchRadius*2],0,""!=Title)
    )
    Tooth
;

function FindCentre(RootRadius,Start,Alpha)=
    _FindCentre(RootRadius,Start,[sin(Alpha),cos(Alpha)],Modulus(Start)-RootRadius)
;

function _FindCentre(RootRadius,S,V,R,Res=0.001)=
    (RootRadius+R)>=Modulus(S+R*V)
    ?   S+R*V
    :   _FindCentre(RootRadius,S,V,R+Res,Res)
;

