/*
  Teeth are formed symmetrically around the positive X-axis with the pitch circle tangent to the Y-axis.
  Cutter is really only used for demo purposes/explanatory images.
  * Allowance makes the *Cutter* tooth GROW.
*/
function RackTooth(Module,Addendum=1,Dedendum=1.25,Shift=0,PressureAngle=20,Allowance=0,Title="",Tip=0.2,Root=0.2)=
    let(
        Pitch=Pi*Module,
        TanPA=tan(PressureAngle),
        CosPA=cos(PressureAngle),
        /* Array with the 4 tooth vertices, defined with the tooth center-line and the pitch-cicle on the origin . */
        /* Find corners, or corner radii centers. */
        RootCenter=
                [
                    -Module*(Dedendum-Root)
                    -Allowance,
                    -Pitch*1/4
                    -TanPA*Module*(Dedendum-Root)
                    -Module*Root/CosPA
                    +Allowance*(1/CosPA-TanPA)
                ],
        TipCenter=
               [
                    Module*(Addendum-Tip)
                    -Allowance,
                    -Pitch*1/4
                    +TanPA*Module*(Addendum-Tip)
                    +Module*Tip/CosPA
                    +Allowance*(1/CosPA-TanPA)
                ],
        /* The corners are either a vertex (radius=0) or an arc. */
        RootCorner=Root==0
            ?   [RootCenter]
                /* Add radius center, i.e., move arc to it's center-point. */
            :   ArrayAdd(
                    /* Mirror arc in Y-axis. */
                    ScaleArray(
                        /* The arc vertices. */
                        Arc(
                            0,
                            90-PressureAngle,
                            Module*Root
                        ),
                        [-1,1]
                    ),
                    RootCenter
                ),
        /* See comments at 'RootCorner'. */
        TipCorner=Tip==0
            ?   [TipCenter]
            :   ArrayAdd(
                    /* Mirroring below puts the vertices in the wrong order, fix that. */
                    ReverseArray(
                        /* Flip in X-axis. */
                        ScaleArray(
                            Arc(
                                0,
                                90-PressureAngle,
                                Module*Tip
                            ),
                            [1,-1]
                        )
                    ),
                    TipCenter
                ),
        /* Form flank from two corners. */
        Flank=concat(RootCorner,TipCorner)
    )
    /* Profile shift. */
    ArrayAdd(
        /* Copy the flank (mirror in X-axis) and pair the flanks. */
        concat(
            Flank,
            /* Mirroring puts the vertices in the wrong order, this fixes that. */
            ReverseArray(
                /* Mirror in X-axis. */
                ScaleArray(
                    Flank, /* The original flank. */
                    [1,-1]
                )
            )
        ),
        [Shift*Module,0]
    )
;

