/*
  I'm getting lazy; if you don't know what the terms below mean, go to TheGHOUL's documentation, I'm not doing it all twice...

  PitchRadius,  scalar,     radius of the pitch circle.
  Teeth,        integer,    number of teeth.
  PressureAngle,scalar,     usually 20, sometimes 14.5, possibly any value.
  Addendum,     scalar,     value in Modules, mostly 1.
  Dedendum,     scalar,     value in Modules, mostly 1.25.
  Allowance,    scalar,     value in native units, probably mm.
*/
/*
  Trochoidal gear fillet curve, for full rack compatible gears with natural undercut. This is the full Trochoid, starting at the Root circle ending at the Base circle.

  * Important enough to have its own file, but it's not in the Geany setup.
*/
function UnderCut(BaseRadius,RootRadius,PitchRadius)=
        // If there's not _at least_ $fs of trochoid, we're not bothering.
    (BaseRadius-$fs)<RootRadius
    ?   undef
    :   [
            let(
                // Generating angle; how far the generating 'Rack' rolls over the pitch circle.
                GenAngle=sqrt(Pow2(BaseRadius)-Pow2(RootRadius))/PitchRadius/PI*180,
                // SWAG-helper, not an actual radius or real dimension.
                GenRad=(PitchRadius-RootRadius),
                Steps=Sequence(0,GenAngle,min(GenAngle/5,$fa))
//                Steps=Sequence(0,GenAngle,GenAngle/Segments(GenRad))
            )
            for(Alpha=Steps)
                RootRadius*[cos(Alpha),sin(Alpha)]+
                PitchRadius*Alpha*PI/180*[sin(Alpha),-cos(Alpha)]
        ]
;

// Trochoid vertex Alpha at Radius
// sqrt(Pow2(Radius)-Pow2(RootRadius))/Pitchradius/Pi*180

/*
  Total generating angle of trochoid between RootRadius and Radius.
*/
function RootTrochoidGenAngle(Radius,RootRadius,PitchRadius)=
    sqrt(Pow2(Radius)-Pow2(RootRadius))/PitchRadius/PI*180
;

/*
  Including angle ('width') of trochoid between RootRadius and Radius. Radius is probably the BaseRadius of the gear, where the involute starts.
*/
function RootTrochoidVertexAngle(Radius,RootRadius,PitchRadius)=
    let(
        GenAngle=RootTrochoidGenAngle(Radius,RootRadius,PitchRadius)
    )
    atan(GenAngle*PI/180*PitchRadius/RootRadius)-GenAngle
;

