// TODO: first groove positions "HalfRib" and "Centered".

// Both modules use these parameters.

    // Base dimensions.
    PR_BaseWidth=15.6; // Max standard is 15.6, may be less.
    PR_Baseradius=1.5; // Max standard is 1.5, may be less.
    PR_BaseToTop=9.4; // Min standard is 9.4, may be more.

    // Rail dimensions.
    PR_Pitch=10;
    PR_GrooveWidth=5.2;
    PR_RibWidth=PR_Pitch-PR_GrooveWidth;
    PR_GrooveDepth=3;
    RailWidth=21.2;

    // The 'Guide' is the reference rectangle that defines the location of the tapers as per the NATO standard.
    PR_GuideWidth=19;
    PR_GuideHeight=2.74;
    PR_GuideBottomToTopRail=4.17;

    // Helper dimensions
    CutSquare=20;

/*
 Generate a section of Picatinny rail according to the NATO standard (metric).
 Dimensions in mm.
 First groove position options are: "HalfSlot" "Slot" "Rib".
 Cutter: clearance on taper apex to use rail to cut attachments, 0.27 Max.
         recommended is 0.15, too great a clearance creates a stress riser
         in the clamping groove.
 */
module PicatinnyRail(Length=95,Grooves=9,GroovePosition="Rib",Cutter=0.15){

    Start=GroovePosition=="HalfSlot"
    ?   0.5*PR_GrooveWidth-10
    :   GroovePosition=="Slot"
        ?   -PR_RibWidth
        :   0
    ;

    difference(){

        linear_extrude(height = Length, convexity = 2)
        RailSection(Cutter);

        if(Grooves>0)
        for(Index=[1:Grooves]){
            Shift=
            Start+
            -PR_GrooveWidth
            +Index*10
            ;
            translate([-0.5*RailWidth-Cutter-HalfCut,-PR_GrooveDepth,Shift])
            cube([RailWidth+2*Cutter+Cut,PR_GrooveDepth+HalfCut,PR_GrooveWidth]);
        }

    }
}

/*
  No direct calls. Only called by 'Rail' module
*/
module RailSection(Cutter=0){

    difference(){

        translate([-0.5*RailWidth-Cutter,-1*PR_BaseToTop])
        square([RailWidth+2*Cutter,PR_BaseToTop]);

        translate([0.5*PR_GuideWidth,-1*PR_GuideBottomToTopRail+1*PR_GuideHeight])
        rotate([0,0,45])
        translate([0,-0.5*CutSquare])
        square([CutSquare,CutSquare]);

        translate([0.5*PR_GuideWidth,-1*PR_GuideBottomToTopRail])
        rotate([0,0,-45])
        translate([0,-0.5*CutSquare])
        square([CutSquare,CutSquare]);

        translate([-0.5*PR_GuideWidth,-1*PR_GuideBottomToTopRail+1*PR_GuideHeight])
        rotate([0,0,-45])
        translate([-1*CutSquare,-0.5*CutSquare])
        square([CutSquare,CutSquare]);

        translate([-0.5*PR_GuideWidth,-1*PR_GuideBottomToTopRail])
        rotate([0,0,45])
        translate([-1*CutSquare,-0.5*CutSquare])
        square([CutSquare,CutSquare]);

    }
}

// EOF =========================================================================
