/*  TODO implement diameter and pitch lookup capacity for metric and unc threads.
 *  Take into consideration that most bolt-threads are impractical as well as silly in 3D printing. Closures etc. are more likely to be printed; if you want an M10 bolt, why not pull one from the bolt-bin? It's quicker and superior...


*  Leaving this here for now, may implement this later
SimplePitch=[ //UNC and Metric lookup table.
    ["#1",0.073,1/64],["#2",0.086,1/56],["#3",0.099,1/48],["#4",0.112,1/40],["#5",0.125,1/40],["#6",0.138,1/32],["#8",0.164,1/32],["#10",0.19,1/24],["#12",0.216,1/24],[1/4,1/4,1/20],[5/16,5/16,1/18],[3/8,3/8,1/16],[7/16,7/16,1/14],[1/2,1/2,1/13],[9/16,9/16,1/12],[5/8,5/8,1/11],[3/4,3/4,1/10],[7/8,7/8,1/9],[1,1,1/8],[1+1/8,1+1/8,1/7],[1+1/4,1+1/4,1/7],[1+3/8,1+3/8,1/6],[1+1/2,1+1/2,1/6]
    ,
    [2,2,0.4],[3,3,0.5],[4,4,0.7],[5,5,0.8],[6,6,1],[8,8,1.25],[10,10,1.5],[12,12,1.75],[14,14,2],[16,16,2],[18,18,2.5],[20,20,2.5],[22,22,2.5],[24,24,3],[27,27,3],[30,30,3.5],[33,33,3.5],[36,36,4],[39,39,4],[42,42,4.5],[45,45,4.5],[48,48,5],[52,52,5],[56,56,5.5],[60,60,5.5],[64,64,6],[68,68,6],[72,72,6],[80,80,6],[90,90,6],[100,100,6]
];

    _Diameter=undef==GetValue(Diameter,SimplePitch,0)
    ?   Diameter
    :   GetValue(Diameter,SimplePitch,0);
    _Pitch=undef==Pitch
    ?   GetValue(Diameter,SimplePitch,1)
    :   Pitch;
    Echo(["Pitch= ",_Pitch,"."]);
    Echo(["Diameter= ",_Diameter,"."]);

*/

module SimpleThread(Turns=4,Diameter=20,Pitch=4,Internal=false,Angle=60,Root=1/4,Crest=1/8,LeftHanded=false,BeginHigbee=0.25,EndHigbee=0.25,HigbeePower=0.5,Correction=0,_ProductionTolerance=-0.01){

    /* Create the profile. */
    Radius=Diameter/2;
    /* Circle segments, like $fn... */
    Segs=Segments(Radius);
    /* Calculate height. */
    Height=Pitch/2/tan(Angle/2);
    /* Calculate the profile root-radius offset*/
    _Radius=Radius+(Internal
    ?   Height*Crest
    :   Height*(Crest-1));
    /* Profiles _must_ be defined in CW order. */
    Profile=Internal
    /* Internal thread. */
    ?   [
            [0,-Pitch/2],
            [Height*(Root-1),-Pitch/2*Root],
            [Height*(Root-1),Pitch/2*Root],
            [0,Pitch/2]
        ]
    /* External thread. */
    :   [
            [0,Pitch/2],
            [Height*(1-Crest),Pitch/2*Crest],
            [Height*(1-Crest),-Pitch/2*Crest],
            [0,-Pitch/2]
        ];

    /* Calculate total correction and tolerance. */
    _Correction=Correction+_ProductionTolerance;

    /* Calculate diameters for internal and external support surfaces. */
    IntHole=Radius+Crest*Height/pow(cos(Angle/2),2)*(sin(Angle/2)-pow(sin(Angle/2),2));
    ExtCylr=Radius-(1-Crest-Root)*Height-Root*Height/pow(cos(Angle/2),2)*(sin(Angle/2)-pow(sin(Angle/2),2));
    CylRad=Internal?IntHole:ExtCylr;

    /* Publish support surface diameter. */
    Echo([
            Internal==true
            ?   "Internal thread hole dimension:\n"
            :   "External thread shank dimension:\n"
            ,   "\ncylinder(r="
            ,   Internal==true
                ?   IntHole-_Correction
                :   ExtCylr+_Correction
            ,   ", h=",(Turns+1)*Pitch,");\n\n"
    ]);

    /* Calculate 'length' of the helix. */
    Steps=Turns*Segs;

    /* The 'VertexCloud' is all the 'Profiles' together in a helical arrangement. */
    VertexCloud=[for(Index=[0:Steps])
        /* Calculate amount of scaling we need (only in Higbee domain). */
        let(
            /* Turns made so far. */
            Turned=Index/Segs,
            HigbeeScale=
                min(
                    /* Maximum scale is '1' -- obviously. */
                     1
                    // Turned<BeginHigbee
                    ,BeginHigbee>0
                    ?   pow(Turned/BeginHigbee,HigbeePower)
                    :   1
                    // (Turns-Turned)<EndHigbee
                    ,EndHigbee>0
                    ?   pow((Turns-Turned)/EndHigbee,HigbeePower)
                    :   1
                ),
            /* Compile scaling vector: Prevent '0' values that break the polygon, and include production tolerance as well as user correction. */
            _HigbeeScale=[
                 ZeroFallback(HigbeeScale+_Correction/Height,Hint)
                ,ZeroFallback(HigbeeScale+_Correction/Pitch,Hint)
                ,1
            ]
        )
        /* Scale and translate/rotate Profile. Affine transformations are performed 'last-first'. */
        AffineTransform(
            /* Rotate to position. */
            RotationMatrix([0,0,360*Index/Segs*(LeftHanded?-1:1)])*
            /* Translate to radius and height. */
            TranslationMatrix([
                _Radius
                ,0
                ,Pitch/2+Pitch*Index/Segs
            ])*
            /* Rotate into the vertical. */
            RotationMatrix([90,0,0])*
            /* Scale for Higbee and tolerance. */
            ScalingMatrix(_HigbeeScale),
            /* The Profile, it needs to be 3D. */
            PadArray(Profile)
        )
    ];

    /* Cover the VertexCloud. */
    CoverMesh(VertexCloud,Endcaps=true);
}

/* The following routines were written in a bit of a rush... They may need a little clean-up. */

module SimpleThreadedHole(Depth=20,Diameter=10,Pitch=1.5,Angle=60,Root=1/4,Crest=1/8,LeftHanded=false,BeginHigbee=0.2,HigbeePower=0.2,CounterSink=true,Correction=0,_ProductionTolerance=-0.01){

    Radius=Diameter/2;

    /* Calculate height. */
    Height=Pitch/2/tan(Angle/2);

    /* Calculate total correction and tolerance. */
    _Correction=Correction+_ProductionTolerance;

    /* Calculate diameter for internal support surface. */
    IntHole=Radius+Crest*Height/pow(cos(Angle/2),2)*(sin(Angle/2)-pow(sin(Angle/2),2));

    /* Avoid coinciding faces. */
    translate([0,0,-Smidge])
    difference(){
        /* The hole and countersink. */
        union(){
            cylinder(r=IntHole,h=Depth+Smidge);
            if(CounterSink)cylinder(r1=IntHole+Pitch/2,r2=IntHole,h=Pitch/2);
        }
        /* Get out of the way of countersink. */
        translate([0,0,CounterSink?Pitch/2:0])
        /* Compensate for the above 'countersink evasion' to keep thread engagement with --potentially-- keyed external threads. */
        rotate([0,0,CounterSink?180:0])
        /* The threads. */
        SimpleThread(Depth/Pitch,Diameter,Pitch,true,Angle,Root,Crest,LeftHanded,BeginHigbee,0,HigbeePower,Correction,_ProductionTolerance);

    }


}

/* TODO This needs an L/R threaded stud option (make half the stud and mirror in the normal plane). */
module SimpleThreadedRod(Length=60,Threads=10,Diameter=10,Pitch=1.5,Angle=60,Root=1/4,Crest=1/8,LeftHanded=false,BeginHigbee=0.2,HigbeePower=0.2,StartTaper=true,Stud=false,Correction=0,_ProductionTolerance=-0.01){

    Radius=Diameter/2;

    _Length=Length-(StartTaper?Pitch/2:0)*(Stud?2:1);

Echo(["_L",_Length,"."]);
    Turns=_Length/Pitch-1;

//    Shank=max(_Length-(Threads+Pitch/2)*(Stud?2:1),0);
    Shank=max(Length-(Threads+Pitch/2)*(Stud?2:1),0);
    Threaded=(_Length-Shank)/(Stud?2:1);

    /* Calculate height. */
    Height=Pitch/2/tan(Angle/2);

    /* Calculate total correction and tolerance. */
    _Correction=Correction+_ProductionTolerance;

    /* Calculate diameter for external support surface. */
    ExtCylr=Radius-(1-Crest-Root)*Height-Root*Height/pow(cos(Angle/2),2)*(sin(Angle/2)-pow(sin(Angle/2),2));

    /* The rod and taper. */
    if(StartTaper)cylinder(r1=ExtCylr-Pitch/2,r2=ExtCylr,h=Pitch/2);
    translate([0,0,StartTaper?Pitch/2:0])
    cylinder(r=ExtCylr,h=_Length);
    if(Stud&&StartTaper){translate([0,0,_Length+Pitch/2])cylinder(r1=ExtCylr,r2=ExtCylr-Pitch/2,h=Pitch/2);}
    /* The shank. */
    translate([0,0,Threaded+(StartTaper?Pitch/2:0)])
    if(Shank>0){
        translate([0,0,-Pitch/2])
        cylinder(r1=ExtCylr,r2=Diameter/2,h=Pitch/2);
        cylinder(r=Diameter/2,h=Shank);
        if(Stud){
            translate([0,0,Shank])
            cylinder(r1=Diameter/2,r2=ExtCylr,h=Pitch/2);}
    }
    /* Get out of the way of countersink. */
    translate([0,0,StartTaper?Pitch/2:0])
    /* Compensate for the above 'countersink evasion' to keep thread engagement with --potentially-- keyed external threads. */
    rotate([0,0,StartTaper?180:0])
    /* The threads. */
    SimpleThread(Turns=Turns,Diameter=Diameter,Pitch=Pitch,Internal=false,Angle=Angle,Root=Root,Crest=Crest,LeftHanded=LeftHanded,BeginHigbee=BeginHigbee,EndHigbee=BeginHigbee,HigbeePower=HigbeePower,Correction=Correction);



}

module SimpleBolt(Size=10,Head=5,Sides=6,Length=60,Threads=10,Diameter=10,Pitch=1.5,Angle=60,Root=1/4,Crest=1/8,LeftHanded=false,BeginHigbee=0.2,HigbeePower=0.2,StartTaper=true,Correction=0,_ProductionTolerance=-0.01,TopChamfer=true,BottomChamfer=false){

    /* The threaded shank. */
    SimpleThreadedRod(Length,Threads,Diameter,Pitch,Angle,Root,Crest,LeftHanded,BeginHigbee,HigbeePower,StartTaper,false,Correction,_ProductionTolerance);

    Radius=Size/2;

    /* The head. */
    translate([0,0,Length])
    intersection(){

        cylinder(r=Radius/cos(180/Sides),h=Head,$fn=Sides);
        if(BottomChamfer)cylinder(r1=Radius,r2=Radius+Head,h=Head);
        if(TopChamfer)cylinder(r1=Radius+Head,r2=Radius,h=Head);

    }

}

/* TODO: This needs a knurled version. */
module SimpleNut(Size=10,Height=5,Sides=6,Diameter=10,Pitch=1.5,Angle=60,Root=1/4,Crest=1/8,LeftHanded=false,BeginHigbee=0.2,HigbeePower=0.2,Correction=0,_ProductionTolerance=-0.01,TopChamfer=true,BottomChamfer=true,InChamfer=0.25){

    Radius=Size/2;

    /* Calculate height. */
    PHeight=Pitch/2/tan(Angle/2);

    /* Calculate diameter for internal support surface. */
    IntHole=Diameter/2+Crest*PHeight/pow(cos(Angle/2),2)*(sin(Angle/2)-pow(sin(Angle/2),2));

    /* The threads. */
    SimpleThread(Height/Pitch-1,Diameter,Pitch,true,Angle,Root,Crest,LeftHanded,BeginHigbee,BeginHigbee,HigbeePower,Correction,_ProductionTolerance);

    Cham=Pitch*InChamfer;

    /* The body. */
    difference(){
        intersection(){
            cylinder(r=Radius/cos(180/Sides),h=Height,$fn=Sides);
            if(BottomChamfer)cylinder(r1=Radius,r2=Radius+Height,h=Height);
            if(TopChamfer)cylinder(r1=Radius+Height,r2=Radius,h=Height);
        }
        color(OSG){
        translate([0,0,-HalfCut])
        cylinder(r=IntHole,h=Height+Cut);
        translate([0,0,-Smidge])
        cylinder(r1=IntHole+Cham+Smidge,r2=IntHole-Smidge,h=Cham/2+Smidge*2);
        translate([0,0,Height-Cham/2-Smidge])
        cylinder(r1=IntHole-Smidge,r2=IntHole+Cham+Smidge,h=Cham/2+Smidge*2);
        }
    }

}


