/*
  This file, ONLY serves to make it easier to integrate kerning lists into The GHOUL's SVG font format. The routines below are dedicated to that purpose, and form no part of The GHOUL.

  Read 'KernList_README' for help on how to use this file.
*/

include<TheGHOUL/Config.scad>

KernList=[ //--- START OF KERNLIST - DO NOT TOUCH THIS LINE --------------------
// -----------------------------------------------------------------------------

["Y","123"],
["W","123"],
["V","123"],
["U","41"],
["T","143"],
["Q","102"],
["O","102"],
["G","102"],
["C","102"],


// -----------------------------------------------------------------------------
]; //--- END OF KERNLIST - DO NOT TOUCH THIS LINE OR BELOW ---------------------

/*
  The routines below ONLY SERVE THIS FILE, they perform no (other) function in The GHOUL than to make integrating SVG kern-lists a little easier.

  Emphasis on 'little'... =/
*/

Echo(["KernList output:\n\n",GatherKernList(SortKernList(ParseKernList(KernList))),"\n\n"]);

function ParseKernList(List)=
    [
        for(Item=List)
            [StringToDecimal(Item[1]),
                len(Item[0])==1
                ?   Prefix(DecToHex(AsciiMapString(Item[0])[0]))
                :   Prefix(LeftString(RightString(Item[0],3),-1))
            ]
    ]
;

function SortKernList(List)=
    len(List)<2
    ?   List
    :   let(
            Center=List[floor(len(List)/2)][0],
            Less=[for(Item=List)
                        if(Item[0]<Center) Item
                    ],
            Equal=[for(Item=List)
                        if(Item[0]==Center) Item
                    ],
            Greater=[for(Item=List)
                        if(Item[0]>Center) Item
                    ]
        )
        concat(SortKernList(Less),Equal,SortKernList(Greater))
;

function NextKern(List,OldKern,Idex=0)=
    Idex==len(List)
    ?   undef
    :   List[Idex][0]>OldKern
        ?   Idex
        :   NextKern(List,OldKern,Idex+1)
;

function GatherKernList(List,Idex=0,NewList=[])=
    Idex==undef
    ?   NewList
    :   let(
            Kern=List[Idex][0],
            KernMembers=search(Kern,List,0,0)
        )
        GatherKernList(List,NextKern(List,Kern),
            concat(NewList,
                [[
                    Kern,
                    for(Item=KernMembers)
                        List[Item][1]
                ]]
            )
        )
;

