/*
  This file, ONLY serves to make it easier to integrate kerning lists into The GHOUL's SVG font format. The routines below are dedicated to that purpose, and form no part of The GHOUL.

  Read 'KernList_README' for help on how to use this file.
*/

include<TheGHOUL/Config.scad>

/*
  The routines below ONLY SERVE THIS FILE, they perform no (other) function in The GHOUL than to make integrating SVG kern-lists a little easier.

  Emphasis on 'little'... =/
*/

Echo(["KernList output:\n\n",GatherKernList(SortKernList(ParseKernList(KernList))),"\n\n"]);

function ParseKernList(List,Idex,Result)=
    [
        for(Item=List)
            [StringToDecimal(Item[2]),
                len(Item[0])==1
                ?   Prefix(DecToHex(AsciiMapString(Item[0])[0]))
                :   Prefix(LeftString(RightString(Item[0],3),-1))
            ]
    ]
;

function SortKernList(List)=
    len(List)<2
    ?   List
    :   let(
            Center=List[floor(len(List)/2)][0],
            Less=[for(Item=List)
                        if(Item[0]<Center) Item
                    ],
            Equal=[for(Item=List)
                        if(Item[0]==Center) Item
                    ],
            Greater=[for(Item=List)
                        if(Item[0]>Center) Item
                    ]
        )
        concat(SortKernList(Less),Equal,SortKernList(Greater))
;

function NextKern(List,OldKern,Idex=0)=
    Idex==len(List)
    ?   undef
    :   List[Idex][0]>OldKern
        ?   Idex
        :   NextKern(List,OldKern,Idex+1)
;

function GatherKernList(List,Idex=0,NewList=[])=
    Idex==undef
    ?   NewList
    :   let(
            Kern=List[Idex][0],
            KernMembers=search(Kern,List,0,0)
        )
        GatherKernList(List,NextKern(List,Kern),
            concat(NewList,
                [[
                    Kern,
                    for(Item=KernMembers)
                        List[Item][1]
                ]]
            )
        )
;

KernList=[
["&#x22;","&#x162;","-41"],
["&#x22;","&#x1ef8;","-20"],
["&#x22;","&#x1ef6;","-20"],
["&#x22;","&#x1ef4;","-20"],
["&#x22;","&#x1ef1;","61"],
["&#x22;","&#x1eef;","61"],
["&#x22;","&#x1eed;","61"],
["&#x22;","&#x1eeb;","61"],
["&#x22;","&#x1ee9;","61"],
["&#x22;","&#x1ee7;","61"],
["&#x22;","&#x1ee5;","61"],
["&#x22;","&#x1ee3;","123"],
["&#x22;","&#x1ee1;","123"],
["&#x22;","&#x1edf;","123"],
["&#x22;","&#x1edd;","123"],
["&#x22;","&#x1edb;","123"],
["&#x22;","&#x1ed9;","123"],
["&#x22;","&#x1ed7;","123"],
["&#x22;","&#x1ed5;","123"],
["&#x22;","&#x1ed1;","123"],
["&#x22;","&#x1ecf;","123"],
["&#x22;","&#x1ecd;","123"],
["&#x22;","&#x1ec7;","123"],
["&#x22;","&#x1ec5;","123"],
["&#x22;","&#x1ec3;","123"],
["&#x22;","&#x1ebf;","123"],
["&#x22;","&#x1ebd;","123"],
["&#x22;","&#x1ebb;","123"],
["&#x22;","&#x1eb9;","123"],
["&#x22;","&#x1eb7;","82"],
["&#x22;","&#x1eb6;","143"],
["&#x22;","&#x1eb5;","82"],
["&#x22;","&#x1eb4;","143"],
["&#x22;","&#x1eb3;","82"],
["&#x22;","&#x1eb2;","143"],
["&#x22;","&#x1eb1;","82"],
["&#x22;","&#x1eb0;","143"],
["&#x22;","&#x1eaf;","82"],
["&#x22;","&#x1eae;","143"],
["&#x22;","&#x1ead;","82"],
["&#x22;","&#x1eac;","143"],
["&#x22;","&#x1eab;","82"],
["&#x22;","&#x1eaa;","143"],
["&#x22;","&#x1ea9;","82"],
["&#x22;","&#x1ea8;","143"],
["&#x22;","&#x1ea6;","143"],
["&#x22;","&#x1ea5;","82"],
["&#x22;","&#x1ea4;","143"],
["&#x22;","&#x1ea3;","82"],
["&#x22;","&#x1ea2;","143"],
["&#x22;","&#x1ea1;","82"],
["&#x22;","&#x1ea0;","143"],
["&#x22;","&#x513;","143"],
["&#x22;","&#x512;","123"],
["&#x22;","&#x511;","123"],
["&#x22;","&#x50d;","123"],
["&#x22;","&#x509;","143"],
["&#x22;","&#x508;","123"],
["&#x22;","&#x503;","123"],
["&#x22;","&#x502;","143"],
["&#x22;","&#x501;","123"],
["&#x22;","&#x500;","143"],
["&#x22;","&#x4eb;","123"],
["&#x22;","&#x4e9;","123"],
["&#x22;","&#x4e7;","123"],
["&#x22;","&#x4db;","41"],
["&#x22;","&#x4d9;","41"],
["&#x22;","&#x4d7;","123"],
["&#x22;","&#x4d5;","41"],
["&#x22;","&#x4d4;","143"],
["&#x22;","&#x4d3;","41"],
["&#x22;","&#x4d2;","143"],
["&#x22;","&#x4d1;","41"],
["&#x22;","&#x4d0;","143"],
["&#x22;","&#x4c6;","143"],
["&#x22;","&#x4c5;","123"],
["&#x22;","&#x4ab;","123"],
["&#x22;","&#x4a9;","123"],
["&#x22;","&#x481;","123"],
["&#x22;","&#x47d;","123"],
["&#x22;","&#x47b;","123"],
["&#x22;","&#x479;","123"],
["&#x22;","&#x473;","123"],
["&#x22;","&#x471;","20"],
["&#x22;","&#x467;","143"],
["&#x22;","&#x466;","143"],
["&#x22;","&#x450;","123"],
["&#x22;","&#x1b0;","61"],
["&#x22;","&#x1a1;","123"],
["&#x22;","&#x1e01;","82"],
["&#x22;","&#x1e00;","143"],
["&#x22;","&#x1e3f;","61"],
["&#x22;","&#x1ef2;","-20"],
["&#x22;","&#x1e84;","-41"],
["&#x22;","&#x1e82;","-41"],
["&#x22;","&#x1e80;","-41"],
["&#x22;","&#x459;","143"],
["&#x22;","&#x455;","61"],
["&#x22;","&#x454;","123"],
["&#x22;","&#x451;","123"],
["&#x22;","&#x444;","123"],
["&#x22;","&#x441;","123"],
["&#x22;","&#x43e;","123"],
["&#x22;","&#x43b;","143"],
["&#x22;","&#x435;","123"],
["&#x22;","&#x434;","143"],
["&#x22;","&#x430;","41"],
["&#x22;","&#x41b;","123"],
["&#x22;","&#x414;","123"],
["&#x22;","&#x410;","143"],
["&#x22;","&#x409;","123"],
["&#x22;","&#x3cc;","82"],
["&#x22;","&#x3c6;","82"],
["&#x22;","&#x3c3;","82"],
["&#x22;","&#x3c2;","82"],
["&#x22;","&#x3c1;","61"],
["&#x22;","&#x3bf;","82"],
["&#x22;","&#x3bc;","41"],
["&#x22;","&#x3ba;","41"],
["&#x22;","&#x3b7;","41"],
["&#x22;","&#x3b6;","41"],
["&#x22;","&#x3b5;","41"],
["&#x22;","&#x3b4;","61"],
["&#x22;","&#x3b1;","82"],
["&#x22;","&#x3ae;","41"],
["&#x22;","&#x3ad;","41"],
["&#x22;","&#x3ac;","82"],
["&#x22;","&#x39b;","143"],
["&#x22;","&#x394;","143"],
["&#x22;","&#x391;","143"],
["&#x22;","&#x386;","143"],
["&#x22;","&#x219;","61"],
["&#x22;","&#x1ff;","123"],
["&#x22;","&#x1fd;","82"],
["&#x22;","&#x1fb;","82"],
["&#x22;","&#x1fa;","143"],
["&#x22;","&#x178;","-20"],
["&#x22;","&#x176;","-20"],
["&#x22;","&#x174;","-41"],
["&#x22;","&#x173;","61"],
["&#x22;","&#x171;","61"],
["&#x22;","&#x16f;","61"],
["&#x22;","&#x16d;","61"],
["&#x22;","&#x16b;","61"],
["&#x22;","&#x169;","61"],
["&#x22;","&#x164;","-41"],
["&#x22;","&#x21a;","-41"],
["&#x22;","&#x15f;","61"],
["&#x22;","&#x15b;","61"],
["&#x22;","&#x157;","61"],
["&#x22;","&#x155;","61"],
["&#x22;","&#x153;","123"],
["&#x22;","&#x151;","123"],
["&#x22;","&#x14f;","123"],
["&#x22;","&#x14d;","123"],
["&#x22;","&#x14b;","61"],
["&#x22;","&#x146;","61"],
["&#x22;","&#x144;","61"],
["&#x22;","&#x138;","61"],
["&#x22;","&#x123;","61"],
["&#x22;","&#x121;","61"],
["&#x22;","&#x11f;","61"],
["&#x22;","&#x11d;","61"],
["&#x22;","&#x11b;","123"],
["&#x22;","&#x119;","123"],
["&#x22;","&#x117;","123"],
["&#x22;","&#x115;","123"],
["&#x22;","&#x113;","123"],
["&#x22;","&#x111;","123"],
["&#x22;","&#x10f;","123"],
["&#x22;","&#x10d;","123"],
["&#x22;","&#x10b;","123"],
["&#x22;","&#x109;","123"],
["&#x22;","&#x107;","123"],
["&#x22;","&#x105;","82"],
["&#x22;","&#x104;","143"],
["&#x22;","&#x103;","82"],
["&#x22;","&#x102;","143"],
["&#x22;","&#x101;","82"],
["&#x22;","&#x100;","143"],
["&#x22;","&#xfc;","61"],
["&#x22;","&#xfb;","61"],
["&#x22;","&#xfa;","61"],
["&#x22;","&#xf9;","61"],
["&#x22;","&#xf8;","123"],
["&#x22;","&#xf6;","123"],
["&#x22;","&#xf5;","123"],
["&#x22;","&#xf4;","123"],
["&#x22;","&#xf3;","123"],
["&#x22;","&#xf2;","123"],
["&#x22;","&#xeb;","123"],
["&#x22;","&#xea;","123"],
["&#x22;","&#xe9;","123"],
["&#x22;","&#xe8;","123"],
["&#x22;","&#xe7;","123"],
["&#x22;","&#xe6;","82"],
["&#x22;","&#xe5;","82"],
["&#x22;","&#xe4;","82"],
["&#x22;","&#xe3;","82"],
["&#x22;","&#xe2;","82"],
["&#x22;","&#xe1;","82"],
["&#x22;","&#xe0;","123"],
["&#x22;","&#xdd;","-20"],
["&#x22;","&#xc5;","143"],
["&#x22;","&#xc4;","143"],
["&#x22;","&#xc3;","143"],
["&#x22;","&#xc2;","143"],
["&#x22;","&#xc1;","143"],
["&#x22;","&#xc0;","143"],
["&#x22;","u","61"],
["&#x22;","s","61"],
["&#x22;","r","61"],
["&#x22;","q","123"],
["&#x22;","p","61"],
["&#x22;","o","123"],
["&#x22;","n","61"],
["&#x22;","m","61"],
["&#x22;","g","61"],
["&#x22;","e","123"],
["&#x22;","d","123"],
["&#x22;","c","123"],
["&#x22;","a","82"],
["&#x22;","Y","-20"],
["&#x22;","W","-41"],
["&#x22;","V","-41"],
["&#x22;","T","-41"],
["&#x22;","A","143"],
["&#x27;","&#x162;","-41"],
["&#x27;","&#x1ef8;","-20"],
["&#x27;","&#x1ef6;","-20"],
["&#x27;","&#x1ef4;","-20"],
["&#x27;","&#x1ef1;","61"],
["&#x27;","&#x1eef;","61"],
["&#x27;","&#x1eed;","61"],
["&#x27;","&#x1eeb;","61"],
["&#x27;","&#x1ee9;","61"],
["&#x27;","&#x1ee7;","61"],
["&#x27;","&#x1ee5;","61"],
["&#x27;","&#x1ee3;","123"],
["&#x27;","&#x1ee1;","123"],
["&#x27;","&#x1edf;","123"],
["&#x27;","&#x1edd;","123"],
["&#x27;","&#x1edb;","123"],
["&#x27;","&#x1ed9;","123"],
["&#x27;","&#x1ed7;","123"],
["&#x27;","&#x1ed5;","123"],
["&#x27;","&#x1ed1;","123"],
["&#x27;","&#x1ecf;","123"],
["&#x27;","&#x1ecd;","123"],
["&#x27;","&#x1ec7;","123"],
["&#x27;","&#x1ec5;","123"],
["&#x27;","&#x1ec3;","123"],
["&#x27;","&#x1ebf;","123"],
["&#x27;","&#x1ebd;","123"],
["&#x27;","&#x1ebb;","123"],
["&#x27;","&#x1eb9;","123"],
["&#x27;","&#x1eb7;","82"],
["&#x27;","&#x1eb6;","143"],
["&#x27;","&#x1eb5;","82"],
["&#x27;","&#x1eb4;","143"],
["&#x27;","&#x1eb3;","82"],
["&#x27;","&#x1eb2;","143"],
["&#x27;","&#x1eb1;","82"],
["&#x27;","&#x1eb0;","143"],
["&#x27;","&#x1eaf;","82"],
["&#x27;","&#x1eae;","143"],
["&#x27;","&#x1ead;","82"],
["&#x27;","&#x1eac;","143"],
["&#x27;","&#x1eab;","82"],
["&#x27;","&#x1eaa;","143"],
["&#x27;","&#x1ea9;","82"],
["&#x27;","&#x1ea8;","143"],
["&#x27;","&#x1ea6;","143"],
["&#x27;","&#x1ea5;","82"],
["&#x27;","&#x1ea4;","143"],
["&#x27;","&#x1ea3;","82"],
["&#x27;","&#x1ea2;","143"],
["&#x27;","&#x1ea1;","82"],
["&#x27;","&#x1ea0;","143"],
["&#x27;","&#x513;","143"],
["&#x27;","&#x512;","123"],
["&#x27;","&#x511;","123"],
["&#x27;","&#x50d;","123"],
["&#x27;","&#x509;","143"],
["&#x27;","&#x508;","123"],
["&#x27;","&#x503;","123"],
["&#x27;","&#x502;","143"],
["&#x27;","&#x501;","123"],
["&#x27;","&#x500;","143"],
["&#x27;","&#x4eb;","123"],
["&#x27;","&#x4e9;","123"],
["&#x27;","&#x4e7;","123"],
["&#x27;","&#x4db;","41"],
["&#x27;","&#x4d9;","41"],
["&#x27;","&#x4d7;","123"],
["&#x27;","&#x4d5;","41"],
["&#x27;","&#x4d4;","143"],
["&#x27;","&#x4d3;","41"],
["&#x27;","&#x4d2;","143"],
["&#x27;","&#x4d1;","41"],
["&#x27;","&#x4d0;","143"],
["&#x27;","&#x4c6;","143"],
["&#x27;","&#x4c5;","123"],
["&#x27;","&#x4ab;","123"],
["&#x27;","&#x4a9;","123"],
["&#x27;","&#x481;","123"],
["&#x27;","&#x47d;","123"],
["&#x27;","&#x47b;","123"],
["&#x27;","&#x479;","123"],
["&#x27;","&#x473;","123"],
["&#x27;","&#x471;","20"],
["&#x27;","&#x467;","143"],
["&#x27;","&#x466;","143"],
["&#x27;","&#x450;","123"],
["&#x27;","&#x1b0;","61"],
["&#x27;","&#x1a1;","123"],
["&#x27;","&#x1e01;","82"],
["&#x27;","&#x1e00;","143"],
["&#x27;","&#x1e3f;","61"],
["&#x27;","&#x1ef2;","-20"],
["&#x27;","&#x1e84;","-41"],
["&#x27;","&#x1e82;","-41"],
["&#x27;","&#x1e80;","-41"],
["&#x27;","&#x459;","143"],
["&#x27;","&#x455;","61"],
["&#x27;","&#x454;","123"],
["&#x27;","&#x451;","123"],
["&#x27;","&#x444;","123"],
["&#x27;","&#x441;","123"],
["&#x27;","&#x43e;","123"],
["&#x27;","&#x43b;","143"],
["&#x27;","&#x435;","123"],
["&#x27;","&#x434;","143"],
["&#x27;","&#x430;","41"],
["&#x27;","&#x41b;","123"],
["&#x27;","&#x414;","123"],
["&#x27;","&#x410;","143"],
["&#x27;","&#x409;","123"],
["&#x27;","&#x3cc;","82"],
["&#x27;","&#x3c6;","82"],
["&#x27;","&#x3c3;","82"],
["&#x27;","&#x3c2;","82"],
["&#x27;","&#x3c1;","61"],
["&#x27;","&#x3bf;","82"],
["&#x27;","&#x3bc;","41"],
["&#x27;","&#x3ba;","41"],
["&#x27;","&#x3b7;","41"],
["&#x27;","&#x3b6;","41"],
["&#x27;","&#x3b5;","41"],
["&#x27;","&#x3b4;","61"],
["&#x27;","&#x3b1;","82"],
["&#x27;","&#x3ae;","41"],
["&#x27;","&#x3ad;","41"],
["&#x27;","&#x3ac;","82"],
["&#x27;","&#x39b;","143"],
["&#x27;","&#x394;","143"],
["&#x27;","&#x391;","143"],
["&#x27;","&#x386;","143"],
["&#x27;","&#x219;","61"],
["&#x27;","&#x1ff;","123"],
["&#x27;","&#x1fd;","82"],
["&#x27;","&#x1fb;","82"],
["&#x27;","&#x1fa;","143"],
["&#x27;","&#x178;","-20"],
["&#x27;","&#x176;","-20"],
["&#x27;","&#x174;","-41"],
["&#x27;","&#x173;","61"],
["&#x27;","&#x171;","61"],
["&#x27;","&#x16f;","61"],
["&#x27;","&#x16d;","61"],
["&#x27;","&#x16b;","61"],
["&#x27;","&#x169;","61"],
["&#x27;","&#x164;","-41"],
["&#x27;","&#x21a;","-41"],
["&#x27;","&#x15f;","61"],
["&#x27;","&#x15b;","61"],
["&#x27;","&#x157;","61"],
["&#x27;","&#x155;","61"],
["&#x27;","&#x153;","123"],
["&#x27;","&#x151;","123"],
["&#x27;","&#x14f;","123"],
["&#x27;","&#x14d;","123"],
["&#x27;","&#x14b;","61"],
["&#x27;","&#x146;","61"],
["&#x27;","&#x144;","61"],
["&#x27;","&#x138;","61"],
["&#x27;","&#x123;","61"],
["&#x27;","&#x121;","61"],
["&#x27;","&#x11f;","61"],
["&#x27;","&#x11d;","61"],
["&#x27;","&#x11b;","123"],
["&#x27;","&#x119;","123"],
["&#x27;","&#x117;","123"],
["&#x27;","&#x115;","123"],
["&#x27;","&#x113;","123"],
["&#x27;","&#x111;","123"],
["&#x27;","&#x10f;","123"],
["&#x27;","&#x10d;","123"],
["&#x27;","&#x10b;","123"],
["&#x27;","&#x109;","123"],
["&#x27;","&#x107;","123"],
["&#x27;","&#x105;","82"],
["&#x27;","&#x104;","143"],
["&#x27;","&#x103;","82"],
["&#x27;","&#x102;","143"],
["&#x27;","&#x101;","82"],
["&#x27;","&#x100;","143"],
["&#x27;","&#xfc;","61"],
["&#x27;","&#xfb;","61"],
["&#x27;","&#xfa;","61"],
["&#x27;","&#xf9;","61"],
["&#x27;","&#xf8;","123"],
["&#x27;","&#xf6;","123"],
["&#x27;","&#xf5;","123"],
["&#x27;","&#xf4;","123"],
["&#x27;","&#xf3;","123"],
["&#x27;","&#xf2;","123"],
["&#x27;","&#xeb;","123"],
["&#x27;","&#xea;","123"],
["&#x27;","&#xe9;","123"],
["&#x27;","&#xe8;","123"],
["&#x27;","&#xe7;","123"],
["&#x27;","&#xe6;","82"],
["&#x27;","&#xe5;","82"],
["&#x27;","&#xe4;","82"],
["&#x27;","&#xe3;","82"],
["&#x27;","&#xe2;","82"],
["&#x27;","&#xe1;","82"],
["&#x27;","&#xe0;","123"],
["&#x27;","&#xdd;","-20"],
["&#x27;","&#xc5;","143"],
["&#x27;","&#xc4;","143"],
["&#x27;","&#xc3;","143"],
["&#x27;","&#xc2;","143"],
["&#x27;","&#xc1;","143"],
["&#x27;","&#xc0;","143"],
["&#x27;","u","61"],
["&#x27;","s","61"],
["&#x27;","r","61"],
["&#x27;","q","123"],
["&#x27;","p","61"],
["&#x27;","o","123"],
["&#x27;","n","61"],
["&#x27;","m","61"],
["&#x27;","g","61"],
["&#x27;","e","123"],
["&#x27;","d","123"],
["&#x27;","c","123"],
["&#x27;","a","82"],
["&#x27;","Y","-20"],
["&#x27;","W","-41"],
["&#x27;","V","-41"],
["&#x27;","T","-41"],
["&#x27;","A","143"],
["&#x28;","J","-184"],
["&#x2c;","&#x162;","143"],
["&#x2c;","&#x1ef8;","123"],
["&#x2c;","&#x1ef6;","123"],
["&#x2c;","&#x1ef4;","123"],
["&#x2c;","&#x1ef0;","41"],
["&#x2c;","&#x1eee;","41"],
["&#x2c;","&#x1eec;","41"],
["&#x2c;","&#x1eea;","41"],
["&#x2c;","&#x1ee8;","41"],
["&#x2c;","&#x1ee6;","41"],
["&#x2c;","&#x1ee4;","41"],
["&#x2c;","&#x1ee2;","102"],
["&#x2c;","&#x1ee0;","102"],
["&#x2c;","&#x1ede;","102"],
["&#x2c;","&#x1edc;","102"],
["&#x2c;","&#x1eda;","102"],
["&#x2c;","&#x1ed8;","102"],
["&#x2c;","&#x1ed6;","102"],
["&#x2c;","&#x1ed4;","102"],
["&#x2c;","&#x1ed2;","102"],
["&#x2c;","&#x1ed0;","102"],
["&#x2c;","&#x1ece;","102"],
["&#x2c;","&#x1ecc;","102"],
["&#x2c;","&#x50f;","102"],
["&#x2c;","&#x50e;","143"],
["&#x2c;","&#x50c;","102"],
["&#x2c;","&#x507;","102"],
["&#x2c;","&#x506;","123"],
["&#x2c;","&#x505;","102"],
["&#x2c;","&#x504;","123"],
["&#x2c;","&#x4f5;","123"],
["&#x2c;","&#x4f4;","164"],
["&#x2c;","&#x4ea;","102"],
["&#x2c;","&#x4e8;","102"],
["&#x2c;","&#x4e6;","102"],
["&#x2c;","&#x4cc;","123"],
["&#x2c;","&#x4cb;","164"],
["&#x2c;","&#x4be;","123"],
["&#x2c;","&#x4bc;","123"],
["&#x2c;","&#x4b9;","123"],
["&#x2c;","&#x4b8;","164"],
["&#x2c;","&#x4b7;","123"],
["&#x2c;","&#x4b6;","164"],
["&#x2c;","&#x4b5;","102"],
["&#x2c;","&#x4b4;","143"],
["&#x2c;","&#x4b0;","123"],
["&#x2c;","&#x4ae;","123"],
["&#x2c;","&#x4ad;","102"],
["&#x2c;","&#x4ac;","143"],
["&#x2c;","&#x4aa;","102"],
["&#x2c;","&#x4a8;","102"],
["&#x2c;","&#x4a1;","102"],
["&#x2c;","&#x4a0;","143"],
["&#x2c;","&#x480;","102"],
["&#x2c;","&#x47e;","102"],
["&#x2c;","&#x47c;","102"],
["&#x2c;","&#x47a;","102"],
["&#x2c;","&#x478;","102"],
["&#x2c;","&#x476;","123"],
["&#x2c;","&#x474;","123"],
["&#x2c;","&#x472;","102"],
["&#x2c;","&#x470;","164"],
["&#x2c;","&#x460;","102"],
["&#x2c;","&#x1af;","41"],
["&#x2c;","&#x1a0;","102"],
["&#x2c;","&#x3d2;","123"],
["&#x2c;","&#x1ef2;","123"],
["&#x2c;","&#x1e84;","123"],
["&#x2c;","&#x1e82;","123"],
["&#x2c;","&#x1e80;","123"],
["&#x2c;","&#x44a;","102"],
["&#x2c;","&#x447;","123"],
["&#x2c;","&#x442;","102"],
["&#x2c;","&#x42a;","143"],
["&#x2c;","&#x427;","164"],
["&#x2c;","&#x424;","82"],
["&#x2c;","&#x422;","143"],
["&#x2c;","&#x421;","102"],
["&#x2c;","&#x41e;","102"],
["&#x2c;","&#x40b;","143"],
["&#x2c;","&#x404;","102"],
["&#x2c;","&#x402;","143"],
["&#x2c;","&#x3b8;","41"],
["&#x2c;","&#x3ab;","123"],
["&#x2c;","&#x3a8;","123"],
["&#x2c;","&#x3a6;","102"],
["&#x2c;","&#x3a5;","123"],
["&#x2c;","&#x3a4;","143"],
["&#x2c;","&#x39f;","82"],
["&#x2c;","&#x398;","82"],
["&#x2c;","&#x1fe;","102"],
["&#x2c;","&#x178;","123"],
["&#x2c;","&#x176;","123"],
["&#x2c;","&#x174;","123"],
["&#x2c;","&#x172;","41"],
["&#x2c;","&#x170;","41"],
["&#x2c;","&#x16e;","41"],
["&#x2c;","&#x16c;","41"],
["&#x2c;","&#x16a;","41"],
["&#x2c;","&#x168;","41"],
["&#x2c;","&#x164;","143"],
["&#x2c;","&#x21a;","143"],
["&#x2c;","&#x152;","102"],
["&#x2c;","&#x150;","102"],
["&#x2c;","&#x14e;","102"],
["&#x2c;","&#x14c;","102"],
["&#x2c;","&#x122;","102"],
["&#x2c;","&#x120;","102"],
["&#x2c;","&#x11e;","102"],
["&#x2c;","&#x11c;","102"],
["&#x2c;","&#x10c;","102"],
["&#x2c;","&#x10a;","102"],
["&#x2c;","&#x108;","102"],
["&#x2c;","&#x106;","102"],
["&#x2c;","&#xdd;","123"],
["&#x2c;","&#xdc;","41"],
["&#x2c;","&#xdb;","41"],
["&#x2c;","&#xda;","41"],
["&#x2c;","&#xd9;","41"],
["&#x2c;","&#xd8;","102"],
["&#x2c;","&#xd6;","102"],
["&#x2c;","&#xd5;","102"],
["&#x2c;","&#xd4;","102"],
["&#x2c;","&#xd3;","102"],
["&#x2c;","&#xd2;","102"],
["&#x2c;","&#xc7;","102"],
["&#x2c;","Y","123"],
["&#x2c;","W","123"],
["&#x2c;","V","123"],
["&#x2c;","U","41"],
["&#x2c;","T","143"],
["&#x2c;","Q","102"],
["&#x2c;","O","102"],
["&#x2c;","G","102"],
["&#x2c;","C","102"],
["&#x2d;","&#x162;","82"],
["&#x2d;","&#x50f;","41"],
["&#x2d;","&#x50e;","82"],
["&#x2d;","&#x4b5;","41"],
["&#x2d;","&#x4b4;","82"],
["&#x2d;","&#x4ad;","41"],
["&#x2d;","&#x4ac;","82"],
["&#x2d;","&#x4a1;","41"],
["&#x2d;","&#x4a0;","82"],
["&#x2d;","&#x44a;","41"],
["&#x2d;","&#x442;","41"],
["&#x2d;","&#x42a;","82"],
["&#x2d;","&#x422;","82"],
["&#x2d;","&#x40b;","82"],
["&#x2d;","&#x402;","82"],
["&#x2d;","&#x3a4;","82"],
["&#x2d;","&#x164;","82"],
["&#x2d;","&#x21a;","82"],
["&#x2d;","T","82"],
["&#x2e;","&#x162;","143"],
["&#x2e;","&#x1ef8;","123"],
["&#x2e;","&#x1ef6;","123"],
["&#x2e;","&#x1ef4;","123"],
["&#x2e;","&#x1ef0;","41"],
["&#x2e;","&#x1eee;","41"],
["&#x2e;","&#x1eec;","41"],
["&#x2e;","&#x1eea;","41"],
["&#x2e;","&#x1ee8;","41"],
["&#x2e;","&#x1ee6;","41"],
["&#x2e;","&#x1ee4;","41"],
["&#x2e;","&#x1ee2;","102"],
["&#x2e;","&#x1ee0;","102"],
["&#x2e;","&#x1ede;","102"],
["&#x2e;","&#x1edc;","102"],
["&#x2e;","&#x1eda;","102"],
["&#x2e;","&#x1ed8;","102"],
["&#x2e;","&#x1ed6;","102"],
["&#x2e;","&#x1ed4;","102"],
["&#x2e;","&#x1ed2;","102"],
["&#x2e;","&#x1ed0;","102"],
["&#x2e;","&#x1ece;","102"],
["&#x2e;","&#x1ecc;","102"],
["&#x2e;","&#x50f;","102"],
["&#x2e;","&#x50e;","143"],
["&#x2e;","&#x50c;","102"],
["&#x2e;","&#x507;","102"],
["&#x2e;","&#x506;","123"],
["&#x2e;","&#x505;","102"],
["&#x2e;","&#x504;","123"],
["&#x2e;","&#x4f5;","123"],
["&#x2e;","&#x4f4;","164"],
["&#x2e;","&#x4ea;","102"],
["&#x2e;","&#x4e8;","102"],
["&#x2e;","&#x4e6;","102"],
["&#x2e;","&#x4cc;","123"],
["&#x2e;","&#x4cb;","164"],
["&#x2e;","&#x4be;","123"],
["&#x2e;","&#x4bc;","123"],
["&#x2e;","&#x4b9;","123"],
["&#x2e;","&#x4b8;","164"],
["&#x2e;","&#x4b7;","123"],
["&#x2e;","&#x4b6;","164"],
["&#x2e;","&#x4b5;","102"],
["&#x2e;","&#x4b4;","143"],
["&#x2e;","&#x4b0;","123"],
["&#x2e;","&#x4ae;","123"],
["&#x2e;","&#x4ad;","102"],
["&#x2e;","&#x4ac;","143"],
["&#x2e;","&#x4aa;","102"],
["&#x2e;","&#x4a8;","102"],
["&#x2e;","&#x4a1;","102"],
["&#x2e;","&#x4a0;","143"],
["&#x2e;","&#x480;","102"],
["&#x2e;","&#x47e;","102"],
["&#x2e;","&#x47c;","102"],
["&#x2e;","&#x47a;","102"],
["&#x2e;","&#x478;","102"],
["&#x2e;","&#x476;","123"],
["&#x2e;","&#x474;","123"],
["&#x2e;","&#x472;","102"],
["&#x2e;","&#x470;","164"],
["&#x2e;","&#x460;","102"],
["&#x2e;","&#x1af;","41"],
["&#x2e;","&#x1a0;","102"],
["&#x2e;","&#x3d2;","123"],
["&#x2e;","&#x1ef2;","123"],
["&#x2e;","&#x1e84;","123"],
["&#x2e;","&#x1e82;","123"],
["&#x2e;","&#x1e80;","123"],
["&#x2e;","&#x44a;","102"],
["&#x2e;","&#x447;","123"],
["&#x2e;","&#x442;","102"],
["&#x2e;","&#x42a;","143"],
["&#x2e;","&#x427;","164"],
["&#x2e;","&#x424;","82"],
["&#x2e;","&#x422;","143"],
["&#x2e;","&#x421;","102"],
["&#x2e;","&#x41e;","102"],
["&#x2e;","&#x40b;","143"],
["&#x2e;","&#x404;","102"],
["&#x2e;","&#x402;","143"],
["&#x2e;","&#x3b8;","41"],
["&#x2e;","&#x3ab;","123"],
["&#x2e;","&#x3a8;","123"],
["&#x2e;","&#x3a6;","102"],
["&#x2e;","&#x3a5;","123"],
["&#x2e;","&#x3a4;","143"],
["&#x2e;","&#x39f;","82"],
["&#x2e;","&#x398;","82"],
["&#x2e;","&#x1fe;","102"],
["&#x2e;","&#x178;","123"],
["&#x2e;","&#x176;","123"],
["&#x2e;","&#x174;","123"],
["&#x2e;","&#x172;","41"],
["&#x2e;","&#x170;","41"],
["&#x2e;","&#x16e;","41"],
["&#x2e;","&#x16c;","41"],
["&#x2e;","&#x16a;","41"],
["&#x2e;","&#x168;","41"],
["&#x2e;","&#x164;","143"],
["&#x2e;","&#x21a;","143"],
["&#x2e;","&#x152;","102"],
["&#x2e;","&#x150;","102"],
["&#x2e;","&#x14e;","102"],
["&#x2e;","&#x14c;","102"],
["&#x2e;","&#x122;","102"],
["&#x2e;","&#x120;","102"],
["&#x2e;","&#x11e;","102"],
["&#x2e;","&#x11c;","102"],
["&#x2e;","&#x10c;","102"],
["&#x2e;","&#x10a;","102"],
["&#x2e;","&#x108;","102"],
["&#x2e;","&#x106;","102"],
["&#x2e;","&#xdd;","123"],
["&#x2e;","&#xdc;","41"],
["&#x2e;","&#xdb;","41"],
["&#x2e;","&#xda;","41"],
["&#x2e;","&#xd9;","41"],
["&#x2e;","&#xd8;","102"],
["&#x2e;","&#xd6;","102"],
["&#x2e;","&#xd5;","102"],
["&#x2e;","&#xd4;","102"],
["&#x2e;","&#xd3;","102"],
["&#x2e;","&#xd2;","102"],
["&#x2e;","&#xc7;","102"],
["&#x2e;","Y","123"],
["&#x2e;","W","123"],
["&#x2e;","V","123"],
["&#x2e;","U","41"],
["&#x2e;","T","143"],
["&#x2e;","Q","102"],
["&#x2e;","O","102"],
["&#x2e;","G","102"],
["&#x2e;","C","102"],
["A","&#x162;","143"],
["A","&#x1ef8;","123"],
["A","&#x1ef6;","123"],
["A","&#x1ef4;","123"],
["A","&#x1ee2;","41"],
["A","&#x1ee0;","41"],
["A","&#x1ede;","41"],
["A","&#x1edc;","41"],
["A","&#x1eda;","41"],
["A","&#x1ed8;","41"],
["A","&#x1ed6;","41"],
["A","&#x1ed4;","41"],
["A","&#x1ed2;","41"],
["A","&#x1ed0;","41"],
["A","&#x1ece;","41"],
["A","&#x1ecc;","41"],
["A","&#x1a0;","41"],
["A","&#x201d;","143"],
["A","&#x2019;","143"],
["A","&#x1ef2;","123"],
["A","&#x1e84;","82"],
["A","&#x1e82;","82"],
["A","&#x1e80;","82"],
["A","&#x1fe;","41"],
["A","&#x178;","123"],
["A","&#x176;","123"],
["A","&#x174;","82"],
["A","&#x164;","143"],
["A","&#x21a;","143"],
["A","&#x152;","41"],
["A","&#x150;","41"],
["A","&#x14e;","41"],
["A","&#x14c;","41"],
["A","&#x122;","41"],
["A","&#x120;","41"],
["A","&#x11e;","41"],
["A","&#x11c;","41"],
["A","&#x10c;","41"],
["A","&#x10a;","41"],
["A","&#x108;","41"],
["A","&#x106;","41"],
["A","&#xdd;","123"],
["A","&#xd8;","41"],
["A","&#xd6;","41"],
["A","&#xd5;","41"],
["A","&#xd4;","41"],
["A","&#xd3;","41"],
["A","&#xd2;","41"],
["A","&#xc7;","41"],
["A","Y","123"],
["A","W","82"],
["A","V","82"],
["A","T","143"],
["A","Q","41"],
["A","O","41"],
["A","J","-266"],
["A","G","41"],
["A","C","41"],
["A","&#x27;","143"],
["A","&#x22;","143"],
["B","&#x162;","61"],
["B","&#x1ef8;","20"],
["B","&#x1ef6;","20"],
["B","&#x1ef4;","20"],
["B","&#x1eb6;","41"],
["B","&#x1eb4;","41"],
["B","&#x1eb2;","41"],
["B","&#x1eb0;","41"],
["B","&#x1eae;","41"],
["B","&#x1eac;","41"],
["B","&#x1eaa;","41"],
["B","&#x1ea8;","41"],
["B","&#x1ea6;","41"],
["B","&#x1ea4;","41"],
["B","&#x1ea2;","41"],
["B","&#x1ea0;","41"],
["B","&#x1e00;","41"],
["B","&#x201e;","82"],
["B","&#x201a;","82"],
["B","&#x1ef2;","20"],
["B","&#x1e84;","20"],
["B","&#x1e82;","20"],
["B","&#x1e80;","20"],
["B","&#x405;","20"],
["B","&#x1fa;","41"],
["B","&#x17d;","20"],
["B","&#x17b;","20"],
["B","&#x179;","20"],
["B","&#x178;","20"],
["B","&#x176;","20"],
["B","&#x174;","20"],
["B","&#x164;","61"],
["B","&#x21a;","61"],
["B","&#x104;","41"],
["B","&#x102;","41"],
["B","&#x100;","41"],
["B","&#xdd;","20"],
["B","&#xc5;","41"],
["B","&#xc4;","41"],
["B","&#xc3;","41"],
["B","&#xc2;","41"],
["B","&#xc1;","41"],
["B","&#xc0;","41"],
["B","Z","20"],
["B","Y","20"],
["B","X","41"],
["B","W","20"],
["B","V","20"],
["B","T","61"],
["B","A","41"],
["B","&#x2e;","82"],
["B","&#x2c;","82"],
["C","&#x1ee2;","41"],
["C","&#x1ee0;","41"],
["C","&#x1ede;","41"],
["C","&#x1edc;","41"],
["C","&#x1eda;","41"],
["C","&#x1ed8;","41"],
["C","&#x1ed6;","41"],
["C","&#x1ed4;","41"],
["C","&#x1ed2;","41"],
["C","&#x1ed0;","41"],
["C","&#x1ece;","41"],
["C","&#x1ecc;","41"],
["C","&#x1a0;","41"],
["C","&#x1fe;","41"],
["C","&#x152;","41"],
["C","&#x150;","41"],
["C","&#x14e;","41"],
["C","&#x14c;","41"],
["C","&#x122;","41"],
["C","&#x120;","41"],
["C","&#x11e;","41"],
["C","&#x11c;","41"],
["C","&#x10c;","41"],
["C","&#x10a;","41"],
["C","&#x108;","41"],
["C","&#x106;","41"],
["C","&#xd8;","41"],
["C","&#xd6;","41"],
["C","&#xd5;","41"],
["C","&#xd4;","41"],
["C","&#xd3;","41"],
["C","&#xd2;","41"],
["C","&#xc7;","41"],
["C","Q","41"],
["C","O","41"],
["C","G","41"],
["C","C","41"],
["D","&#x162;","61"],
["D","&#x1ef8;","20"],
["D","&#x1ef6;","20"],
["D","&#x1ef4;","20"],
["D","&#x1eb6;","41"],
["D","&#x1eb4;","41"],
["D","&#x1eb2;","41"],
["D","&#x1eb0;","41"],
["D","&#x1eae;","41"],
["D","&#x1eac;","41"],
["D","&#x1eaa;","41"],
["D","&#x1ea8;","41"],
["D","&#x1ea6;","41"],
["D","&#x1ea4;","41"],
["D","&#x1ea2;","41"],
["D","&#x1ea0;","41"],
["D","&#x1e00;","41"],
["D","&#x201e;","82"],
["D","&#x201a;","82"],
["D","&#x1ef2;","20"],
["D","&#x1e84;","20"],
["D","&#x1e82;","20"],
["D","&#x1e80;","20"],
["D","&#x405;","20"],
["D","&#x1fa;","41"],
["D","&#x17d;","20"],
["D","&#x17b;","20"],
["D","&#x179;","20"],
["D","&#x178;","20"],
["D","&#x176;","20"],
["D","&#x174;","20"],
["D","&#x164;","61"],
["D","&#x21a;","61"],
["D","&#x104;","41"],
["D","&#x102;","41"],
["D","&#x100;","41"],
["D","&#xdd;","20"],
["D","&#xc5;","41"],
["D","&#xc4;","41"],
["D","&#xc3;","41"],
["D","&#xc2;","41"],
["D","&#xc1;","41"],
["D","&#xc0;","41"],
["D","Z","20"],
["D","Y","20"],
["D","X","41"],
["D","W","20"],
["D","V","20"],
["D","T","61"],
["D","A","41"],
["D","&#x2e;","82"],
["D","&#x2c;","82"],
["E","J","-123"],
["F","&#x1eb6;","41"],
["F","&#x1eb4;","41"],
["F","&#x1eb2;","41"],
["F","&#x1eb0;","41"],
["F","&#x1eae;","41"],
["F","&#x1eac;","41"],
["F","&#x1eaa;","41"],
["F","&#x1ea8;","41"],
["F","&#x1ea6;","41"],
["F","&#x1ea4;","41"],
["F","&#x1ea2;","41"],
["F","&#x1ea0;","41"],
["F","&#x1e00;","41"],
["F","&#x201e;","123"],
["F","&#x201a;","123"],
["F","&#x1fa;","41"],
["F","&#x104;","41"],
["F","&#x102;","41"],
["F","&#x100;","41"],
["F","&#xc5;","41"],
["F","&#xc4;","41"],
["F","&#xc3;","41"],
["F","&#xc2;","41"],
["F","&#xc1;","41"],
["F","&#xc0;","41"],
["F","A","41"],
["F","&#x3f;","-41"],
["F","&#x2e;","123"],
["F","&#x2c;","123"],
["K","&#x1ee2;","41"],
["K","&#x1ee0;","41"],
["K","&#x1ede;","41"],
["K","&#x1edc;","41"],
["K","&#x1eda;","41"],
["K","&#x1ed8;","41"],
["K","&#x1ed6;","41"],
["K","&#x1ed4;","41"],
["K","&#x1ed2;","41"],
["K","&#x1ed0;","41"],
["K","&#x1ece;","41"],
["K","&#x1ecc;","41"],
["K","&#x1a0;","41"],
["K","&#x1fe;","41"],
["K","&#x152;","41"],
["K","&#x150;","41"],
["K","&#x14e;","41"],
["K","&#x14c;","41"],
["K","&#x122;","41"],
["K","&#x120;","41"],
["K","&#x11e;","41"],
["K","&#x11c;","41"],
["K","&#x10c;","41"],
["K","&#x10a;","41"],
["K","&#x108;","41"],
["K","&#x106;","41"],
["K","&#xd8;","41"],
["K","&#xd6;","41"],
["K","&#xd5;","41"],
["K","&#xd4;","41"],
["K","&#xd3;","41"],
["K","&#xd2;","41"],
["K","&#xc7;","41"],
["K","Q","41"],
["K","O","41"],
["K","G","41"],
["K","C","41"],
["L","&#x162;","41"],
["L","&#x1ef8;","61"],
["L","&#x1ef6;","61"],
["L","&#x1ef4;","61"],
["L","&#x1ef0;","20"],
["L","&#x1eee;","20"],
["L","&#x1eec;","20"],
["L","&#x1eea;","20"],
["L","&#x1ee8;","20"],
["L","&#x1ee6;","20"],
["L","&#x1ee4;","20"],
["L","&#x1ee2;","41"],
["L","&#x1ee0;","41"],
["L","&#x1ede;","41"],
["L","&#x1edc;","41"],
["L","&#x1eda;","41"],
["L","&#x1ed8;","41"],
["L","&#x1ed6;","41"],
["L","&#x1ed4;","41"],
["L","&#x1ed2;","41"],
["L","&#x1ed0;","41"],
["L","&#x1ece;","41"],
["L","&#x1ecc;","41"],
["L","&#x1af;","20"],
["L","&#x1a0;","41"],
["L","&#x201d;","164"],
["L","&#x2019;","164"],
["L","&#x1ef2;","61"],
["L","&#x1e84;","41"],
["L","&#x1e82;","41"],
["L","&#x1e80;","41"],
["L","&#x1fe;","41"],
["L","&#x178;","61"],
["L","&#x176;","61"],
["L","&#x174;","41"],
["L","&#x172;","20"],
["L","&#x170;","20"],
["L","&#x16e;","20"],
["L","&#x16c;","20"],
["L","&#x16a;","20"],
["L","&#x168;","20"],
["L","&#x164;","41"],
["L","&#x21a;","41"],
["L","&#x152;","41"],
["L","&#x150;","41"],
["L","&#x14e;","41"],
["L","&#x14c;","41"],
["L","&#x122;","41"],
["L","&#x120;","41"],
["L","&#x11e;","41"],
["L","&#x11c;","41"],
["L","&#x10c;","41"],
["L","&#x10a;","41"],
["L","&#x108;","41"],
["L","&#x106;","41"],
["L","&#xdd;","61"],
["L","&#xdc;","20"],
["L","&#xdb;","20"],
["L","&#xda;","20"],
["L","&#xd9;","20"],
["L","&#xd8;","41"],
["L","&#xd6;","41"],
["L","&#xd5;","41"],
["L","&#xd4;","41"],
["L","&#xd3;","41"],
["L","&#xd2;","41"],
["L","&#xc7;","41"],
["L","Y","61"],
["L","W","41"],
["L","V","41"],
["L","U","20"],
["L","T","41"],
["L","Q","41"],
["L","O","41"],
["L","G","41"],
["L","C","41"],
["L","&#x27;","164"],
["L","&#x22;","164"],
["O","&#x162;","61"],
["O","&#x1ef8;","20"],
["O","&#x1ef6;","20"],
["O","&#x1ef4;","20"],
["O","&#x1eb6;","41"],
["O","&#x1eb4;","41"],
["O","&#x1eb2;","41"],
["O","&#x1eb0;","41"],
["O","&#x1eae;","41"],
["O","&#x1eac;","41"],
["O","&#x1eaa;","41"],
["O","&#x1ea8;","41"],
["O","&#x1ea6;","41"],
["O","&#x1ea4;","41"],
["O","&#x1ea2;","41"],
["O","&#x1ea0;","41"],
["O","&#x1e00;","41"],
["O","&#x201e;","82"],
["O","&#x201a;","82"],
["O","&#x1ef2;","20"],
["O","&#x1e84;","20"],
["O","&#x1e82;","20"],
["O","&#x1e80;","20"],
["O","&#x405;","20"],
["O","&#x1fa;","41"],
["O","&#x17d;","20"],
["O","&#x17b;","20"],
["O","&#x179;","20"],
["O","&#x178;","20"],
["O","&#x176;","20"],
["O","&#x174;","20"],
["O","&#x164;","61"],
["O","&#x21a;","61"],
["O","&#x104;","41"],
["O","&#x102;","41"],
["O","&#x100;","41"],
["O","&#xdd;","20"],
["O","&#xc5;","41"],
["O","&#xc4;","41"],
["O","&#xc3;","41"],
["O","&#xc2;","41"],
["O","&#xc1;","41"],
["O","&#xc0;","41"],
["O","Z","20"],
["O","Y","20"],
["O","X","41"],
["O","W","20"],
["O","V","20"],
["O","T","61"],
["O","A","41"],
["O","&#x2e;","82"],
["O","&#x2c;","82"],
["P","&#x1eb6;","102"],
["P","&#x1eb4;","102"],
["P","&#x1eb2;","102"],
["P","&#x1eb0;","102"],
["P","&#x1eae;","102"],
["P","&#x1eac;","102"],
["P","&#x1eaa;","102"],
["P","&#x1ea8;","102"],
["P","&#x1ea6;","102"],
["P","&#x1ea4;","102"],
["P","&#x1ea2;","102"],
["P","&#x1ea0;","102"],
["P","&#x1e00;","102"],
["P","&#x201e;","266"],
["P","&#x201a;","266"],
["P","&#x1fa;","102"],
["P","&#x17d;","20"],
["P","&#x17b;","20"],
["P","&#x179;","20"],
["P","&#x104;","102"],
["P","&#x102;","102"],
["P","&#x100;","102"],
["P","&#xc5;","102"],
["P","&#xc4;","102"],
["P","&#xc3;","102"],
["P","&#xc2;","102"],
["P","&#xc1;","102"],
["P","&#xc0;","102"],
["P","Z","20"],
["P","X","41"],
["P","A","102"],
["P","&#x2e;","266"],
["P","&#x2c;","266"],
["Q","&#x162;","61"],
["Q","&#x1ef8;","20"],
["Q","&#x1ef6;","20"],
["Q","&#x1ef4;","20"],
["Q","&#x1eb6;","41"],
["Q","&#x1eb4;","41"],
["Q","&#x1eb2;","41"],
["Q","&#x1eb0;","41"],
["Q","&#x1eae;","41"],
["Q","&#x1eac;","41"],
["Q","&#x1eaa;","41"],
["Q","&#x1ea8;","41"],
["Q","&#x1ea6;","41"],
["Q","&#x1ea4;","41"],
["Q","&#x1ea2;","41"],
["Q","&#x1ea0;","41"],
["Q","&#x1e00;","41"],
["Q","&#x201e;","82"],
["Q","&#x201a;","82"],
["Q","&#x1ef2;","20"],
["Q","&#x1e84;","20"],
["Q","&#x1e82;","20"],
["Q","&#x1e80;","20"],
["Q","&#x405;","20"],
["Q","&#x1fa;","41"],
["Q","&#x17d;","20"],
["Q","&#x17b;","20"],
["Q","&#x179;","20"],
["Q","&#x178;","20"],
["Q","&#x176;","20"],
["Q","&#x174;","20"],
["Q","&#x164;","61"],
["Q","&#x21a;","61"],
["Q","&#x104;","41"],
["Q","&#x102;","41"],
["Q","&#x100;","41"],
["Q","&#xdd;","20"],
["Q","&#xc5;","41"],
["Q","&#xc4;","41"],
["Q","&#xc3;","41"],
["Q","&#xc2;","41"],
["Q","&#xc1;","41"],
["Q","&#xc0;","41"],
["Q","Z","20"],
["Q","Y","20"],
["Q","X","41"],
["Q","W","20"],
["Q","V","20"],
["Q","T","61"],
["Q","A","41"],
["Q","&#x2e;","82"],
["Q","&#x2c;","82"],
["T","&#x162;","-41"],
["T","&#x1ef5;","41"],
["T","&#x1ef1;","102"],
["T","&#x1eef;","102"],
["T","&#x1eed;","102"],
["T","&#x1eeb;","102"],
["T","&#x1ee9;","102"],
["T","&#x1ee7;","102"],
["T","&#x1ee5;","102"],
["T","&#x1ee3;","143"],
["T","&#x1ee2;","41"],
["T","&#x1ee1;","143"],
["T","&#x1ee0;","41"],
["T","&#x1edf;","143"],
["T","&#x1ede;","41"],
["T","&#x1edd;","143"],
["T","&#x1edc;","41"],
["T","&#x1edb;","143"],
["T","&#x1eda;","41"],
["T","&#x1ed9;","143"],
["T","&#x1ed8;","41"],
["T","&#x1ed7;","143"],
["T","&#x1ed6;","41"],
["T","&#x1ed5;","143"],
["T","&#x1ed4;","41"],
["T","&#x1ed2;","41"],
["T","&#x1ed1;","143"],
["T","&#x1ed0;","41"],
["T","&#x1ecf;","143"],
["T","&#x1ece;","41"],
["T","&#x1ecd;","143"],
["T","&#x1ecc;","41"],
["T","&#x1ec7;","143"],
["T","&#x1ec5;","143"],
["T","&#x1ec3;","143"],
["T","&#x1ebf;","143"],
["T","&#x1ebd;","143"],
["T","&#x1ebb;","143"],
["T","&#x1eb9;","143"],
["T","&#x1eb7;","164"],
["T","&#x1eb6;","143"],
["T","&#x1eb5;","164"],
["T","&#x1eb4;","143"],
["T","&#x1eb3;","164"],
["T","&#x1eb2;","143"],
["T","&#x1eb1;","164"],
["T","&#x1eb0;","143"],
["T","&#x1eaf;","164"],
["T","&#x1eae;","143"],
["T","&#x1ead;","164"],
["T","&#x1eac;","143"],
["T","&#x1eab;","164"],
["T","&#x1eaa;","143"],
["T","&#x1ea9;","164"],
["T","&#x1ea8;","143"],
["T","&#x1ea6;","143"],
["T","&#x1ea5;","164"],
["T","&#x1ea4;","143"],
["T","&#x1ea3;","164"],
["T","&#x1ea2;","143"],
["T","&#x1ea1;","164"],
["T","&#x1ea0;","143"],
["T","&#x1b0;","102"],
["T","&#x1a1;","143"],
["T","&#x1a0;","41"],
["T","&#x1e01;","164"],
["T","&#x1e00;","143"],
["T","&#x1e3f;","102"],
["T","&#x201e;","123"],
["T","&#x201a;","123"],
["T","&#x2015;","82"],
["T","&#x2014;","82"],
["T","&#x2013;","82"],
["T","&#x1e83;","41"],
["T","&#x1e81;","41"],
["T","&#x219;","123"],
["T","&#x1ff;","143"],
["T","&#x1fe;","41"],
["T","&#x1fd;","164"],
["T","&#x1fb;","164"],
["T","&#x1fa;","143"],
["T","&#x17e;","82"],
["T","&#x17c;","82"],
["T","&#x17a;","82"],
["T","&#x175;","41"],
["T","&#x173;","102"],
["T","&#x171;","102"],
["T","&#x16f;","102"],
["T","&#x16d;","102"],
["T","&#x16b;","102"],
["T","&#x169;","102"],
["T","&#x164;","-41"],
["T","&#x21a;","-41"],
["T","&#x15f;","123"],
["T","&#x15b;","123"],
["T","&#x157;","102"],
["T","&#x155;","102"],
["T","&#x153;","143"],
["T","&#x152;","41"],
["T","&#x151;","143"],
["T","&#x150;","41"],
["T","&#x14f;","143"],
["T","&#x14e;","41"],
["T","&#x14d;","143"],
["T","&#x14c;","41"],
["T","&#x14b;","102"],
["T","&#x146;","102"],
["T","&#x144;","102"],
["T","&#x138;","102"],
["T","&#x123;","143"],
["T","&#x122;","41"],
["T","&#x121;","143"],
["T","&#x120;","41"],
["T","&#x11f;","143"],
["T","&#x11e;","41"],
["T","&#x11d;","143"],
["T","&#x11c;","41"],
["T","&#x11b;","143"],
["T","&#x119;","143"],
["T","&#x117;","143"],
["T","&#x115;","143"],
["T","&#x113;","143"],
["T","&#x111;","143"],
["T","&#x10f;","143"],
["T","&#x10d;","143"],
["T","&#x10c;","41"],
["T","&#x10b;","143"],
["T","&#x10a;","41"],
["T","&#x109;","143"],
["T","&#x108;","41"],
["T","&#x107;","143"],
["T","&#x106;","41"],
["T","&#x105;","164"],
["T","&#x104;","143"],
["T","&#x103;","164"],
["T","&#x102;","143"],
["T","&#x101;","164"],
["T","&#x100;","143"],
["T","&#xfd;","41"],
["T","&#xfc;","102"],
["T","&#xfb;","102"],
["T","&#xfa;","102"],
["T","&#xf9;","102"],
["T","&#xf8;","143"],
["T","&#xf6;","143"],
["T","&#xf5;","143"],
["T","&#xf4;","143"],
["T","&#xf3;","143"],
["T","&#xf2;","143"],
["T","&#xeb;","143"],
["T","&#xea;","143"],
["T","&#xe9;","143"],
["T","&#xe8;","143"],
["T","&#xe7;","143"],
["T","&#xe6;","164"],
["T","&#xe5;","164"],
["T","&#xe4;","164"],
["T","&#xe3;","164"],
["T","&#xe2;","164"],
["T","&#xe1;","164"],
["T","&#xe0;","143"],
["T","&#xd8;","41"],
["T","&#xd6;","41"],
["T","&#xd5;","41"],
["T","&#xd4;","41"],
["T","&#xd3;","41"],
["T","&#xd2;","41"],
["T","&#xc7;","41"],
["T","&#xc5;","143"],
["T","&#xc4;","143"],
["T","&#xc3;","143"],
["T","&#xc2;","143"],
["T","&#xc1;","143"],
["T","&#xc0;","143"],
["T","z","82"],
["T","y","41"],
["T","x","41"],
["T","w","41"],
["T","v","41"],
["T","u","102"],
["T","s","123"],
["T","r","102"],
["T","q","143"],
["T","p","102"],
["T","o","143"],
["T","n","102"],
["T","m","102"],
["T","g","143"],
["T","e","143"],
["T","d","143"],
["T","c","143"],
["T","a","164"],
["T","T","-41"],
["T","Q","41"],
["T","O","41"],
["T","G","41"],
["T","C","41"],
["T","A","143"],
["T","&#x3f;","-41"],
["T","&#x2e;","123"],
["T","&#x2d;","82"],
["T","&#x2c;","123"],
["U","&#x1eb6;","20"],
["U","&#x1eb4;","20"],
["U","&#x1eb2;","20"],
["U","&#x1eb0;","20"],
["U","&#x1eae;","20"],
["U","&#x1eac;","20"],
["U","&#x1eaa;","20"],
["U","&#x1ea8;","20"],
["U","&#x1ea6;","20"],
["U","&#x1ea4;","20"],
["U","&#x1ea2;","20"],
["U","&#x1ea0;","20"],
["U","&#x1e00;","20"],
["U","&#x201e;","41"],
["U","&#x201a;","41"],
["U","&#x1fa;","20"],
["U","&#x104;","20"],
["U","&#x102;","20"],
["U","&#x100;","20"],
["U","&#xc5;","20"],
["U","&#xc4;","20"],
["U","&#xc3;","20"],
["U","&#xc2;","20"],
["U","&#xc1;","20"],
["U","&#xc0;","20"],
["U","A","20"],
["U","&#x2e;","41"],
["U","&#x2c;","41"],
["V","&#x1ef1;","20"],
["V","&#x1eef;","20"],
["V","&#x1eed;","20"],
["V","&#x1eeb;","20"],
["V","&#x1ee9;","20"],
["V","&#x1ee7;","20"],
["V","&#x1ee5;","20"],
["V","&#x1ee3;","41"],
["V","&#x1ee2;","20"],
["V","&#x1ee1;","41"],
["V","&#x1ee0;","20"],
["V","&#x1edf;","41"],
["V","&#x1ede;","20"],
["V","&#x1edd;","41"],
["V","&#x1edc;","20"],
["V","&#x1edb;","41"],
["V","&#x1eda;","20"],
["V","&#x1ed9;","41"],
["V","&#x1ed8;","20"],
["V","&#x1ed7;","41"],
["V","&#x1ed6;","20"],
["V","&#x1ed5;","41"],
["V","&#x1ed4;","20"],
["V","&#x1ed2;","20"],
["V","&#x1ed1;","41"],
["V","&#x1ed0;","20"],
["V","&#x1ecf;","41"],
["V","&#x1ece;","20"],
["V","&#x1ecd;","41"],
["V","&#x1ecc;","20"],
["V","&#x1ec7;","41"],
["V","&#x1ec5;","41"],
["V","&#x1ec3;","41"],
["V","&#x1ebf;","41"],
["V","&#x1ebd;","41"],
["V","&#x1ebb;","41"],
["V","&#x1eb9;","41"],
["V","&#x1eb7;","41"],
["V","&#x1eb6;","82"],
["V","&#x1eb5;","41"],
["V","&#x1eb4;","82"],
["V","&#x1eb3;","41"],
["V","&#x1eb2;","82"],
["V","&#x1eb1;","41"],
["V","&#x1eb0;","82"],
["V","&#x1eaf;","41"],
["V","&#x1eae;","82"],
["V","&#x1ead;","41"],
["V","&#x1eac;","82"],
["V","&#x1eab;","41"],
["V","&#x1eaa;","82"],
["V","&#x1ea9;","41"],
["V","&#x1ea8;","82"],
["V","&#x1ea6;","82"],
["V","&#x1ea5;","41"],
["V","&#x1ea4;","82"],
["V","&#x1ea3;","41"],
["V","&#x1ea2;","82"],
["V","&#x1ea1;","41"],
["V","&#x1ea0;","82"],
["V","&#x1b0;","20"],
["V","&#x1a1;","41"],
["V","&#x1a0;","20"],
["V","&#x1e01;","41"],
["V","&#x1e00;","82"],
["V","&#x1e3f;","20"],
["V","&#x201e;","102"],
["V","&#x201a;","102"],
["V","&#x219;","20"],
["V","&#x1ff;","41"],
["V","&#x1fe;","20"],
["V","&#x1fd;","41"],
["V","&#x1fb;","41"],
["V","&#x1fa;","82"],
["V","&#x173;","20"],
["V","&#x171;","20"],
["V","&#x16f;","20"],
["V","&#x16d;","20"],
["V","&#x16b;","20"],
["V","&#x169;","20"],
["V","&#x15f;","20"],
["V","&#x15b;","20"],
["V","&#x157;","20"],
["V","&#x155;","20"],
["V","&#x153;","41"],
["V","&#x152;","20"],
["V","&#x151;","41"],
["V","&#x150;","20"],
["V","&#x14f;","41"],
["V","&#x14e;","20"],
["V","&#x14d;","41"],
["V","&#x14c;","20"],
["V","&#x14b;","20"],
["V","&#x146;","20"],
["V","&#x144;","20"],
["V","&#x138;","20"],
["V","&#x123;","20"],
["V","&#x122;","20"],
["V","&#x121;","20"],
["V","&#x120;","20"],
["V","&#x11f;","20"],
["V","&#x11e;","20"],
["V","&#x11d;","20"],
["V","&#x11c;","20"],
["V","&#x11b;","41"],
["V","&#x119;","41"],
["V","&#x117;","41"],
["V","&#x115;","41"],
["V","&#x113;","41"],
["V","&#x111;","41"],
["V","&#x10f;","41"],
["V","&#x10d;","41"],
["V","&#x10c;","20"],
["V","&#x10b;","41"],
["V","&#x10a;","20"],
["V","&#x109;","41"],
["V","&#x108;","20"],
["V","&#x107;","41"],
["V","&#x106;","20"],
["V","&#x105;","41"],
["V","&#x104;","82"],
["V","&#x103;","41"],
["V","&#x102;","82"],
["V","&#x101;","41"],
["V","&#x100;","82"],
["V","&#xfc;","20"],
["V","&#xfb;","20"],
["V","&#xfa;","20"],
["V","&#xf9;","20"],
["V","&#xf8;","41"],
["V","&#xf6;","41"],
["V","&#xf5;","41"],
["V","&#xf4;","41"],
["V","&#xf3;","41"],
["V","&#xf2;","41"],
["V","&#xeb;","41"],
["V","&#xea;","41"],
["V","&#xe9;","41"],
["V","&#xe8;","41"],
["V","&#xe7;","41"],
["V","&#xe6;","41"],
["V","&#xe5;","41"],
["V","&#xe4;","41"],
["V","&#xe3;","41"],
["V","&#xe2;","41"],
["V","&#xe1;","41"],
["V","&#xe0;","41"],
["V","&#xd8;","20"],
["V","&#xd6;","20"],
["V","&#xd5;","20"],
["V","&#xd4;","20"],
["V","&#xd3;","20"],
["V","&#xd2;","20"],
["V","&#xc7;","20"],
["V","&#xc5;","82"],
["V","&#xc4;","82"],
["V","&#xc3;","82"],
["V","&#xc2;","82"],
["V","&#xc1;","82"],
["V","&#xc0;","82"],
["V","u","20"],
["V","s","20"],
["V","r","20"],
["V","q","41"],
["V","p","20"],
["V","o","41"],
["V","n","20"],
["V","m","20"],
["V","g","20"],
["V","e","41"],
["V","d","41"],
["V","c","41"],
["V","a","41"],
["V","Q","20"],
["V","O","20"],
["V","G","20"],
["V","C","20"],
["V","A","82"],
["V","&#x3f;","-41"],
["V","&#x2e;","102"],
["V","&#x2c;","102"],
["W","&#x1ef1;","20"],
["W","&#x1eef;","20"],
["W","&#x1eed;","20"],
["W","&#x1eeb;","20"],
["W","&#x1ee9;","20"],
["W","&#x1ee7;","20"],
["W","&#x1ee5;","20"],
["W","&#x1ee3;","41"],
["W","&#x1ee2;","20"],
["W","&#x1ee1;","41"],
["W","&#x1ee0;","20"],
["W","&#x1edf;","41"],
["W","&#x1ede;","20"],
["W","&#x1edd;","41"],
["W","&#x1edc;","20"],
["W","&#x1edb;","41"],
["W","&#x1eda;","20"],
["W","&#x1ed9;","41"],
["W","&#x1ed8;","20"],
["W","&#x1ed7;","41"],
["W","&#x1ed6;","20"],
["W","&#x1ed5;","41"],
["W","&#x1ed4;","20"],
["W","&#x1ed2;","20"],
["W","&#x1ed1;","41"],
["W","&#x1ed0;","20"],
["W","&#x1ecf;","41"],
["W","&#x1ece;","20"],
["W","&#x1ecd;","41"],
["W","&#x1ecc;","20"],
["W","&#x1ec7;","41"],
["W","&#x1ec5;","41"],
["W","&#x1ec3;","41"],
["W","&#x1ebf;","41"],
["W","&#x1ebd;","41"],
["W","&#x1ebb;","41"],
["W","&#x1eb9;","41"],
["W","&#x1eb7;","41"],
["W","&#x1eb6;","82"],
["W","&#x1eb5;","41"],
["W","&#x1eb4;","82"],
["W","&#x1eb3;","41"],
["W","&#x1eb2;","82"],
["W","&#x1eb1;","41"],
["W","&#x1eb0;","82"],
["W","&#x1eaf;","41"],
["W","&#x1eae;","82"],
["W","&#x1ead;","41"],
["W","&#x1eac;","82"],
["W","&#x1eab;","41"],
["W","&#x1eaa;","82"],
["W","&#x1ea9;","41"],
["W","&#x1ea8;","82"],
["W","&#x1ea6;","82"],
["W","&#x1ea5;","41"],
["W","&#x1ea4;","82"],
["W","&#x1ea3;","41"],
["W","&#x1ea2;","82"],
["W","&#x1ea1;","41"],
["W","&#x1ea0;","82"],
["W","&#x1b0;","20"],
["W","&#x1a1;","41"],
["W","&#x1a0;","20"],
["W","&#x1e01;","41"],
["W","&#x1e00;","82"],
["W","&#x1e3f;","20"],
["W","&#x201e;","102"],
["W","&#x201a;","102"],
["W","&#x219;","20"],
["W","&#x1ff;","41"],
["W","&#x1fe;","20"],
["W","&#x1fd;","41"],
["W","&#x1fb;","41"],
["W","&#x1fa;","82"],
["W","&#x173;","20"],
["W","&#x171;","20"],
["W","&#x16f;","20"],
["W","&#x16d;","20"],
["W","&#x16b;","20"],
["W","&#x169;","20"],
["W","&#x15f;","20"],
["W","&#x15b;","20"],
["W","&#x157;","20"],
["W","&#x155;","20"],
["W","&#x153;","41"],
["W","&#x152;","20"],
["W","&#x151;","41"],
["W","&#x150;","20"],
["W","&#x14f;","41"],
["W","&#x14e;","20"],
["W","&#x14d;","41"],
["W","&#x14c;","20"],
["W","&#x14b;","20"],
["W","&#x146;","20"],
["W","&#x144;","20"],
["W","&#x138;","20"],
["W","&#x123;","20"],
["W","&#x122;","20"],
["W","&#x121;","20"],
["W","&#x120;","20"],
["W","&#x11f;","20"],
["W","&#x11e;","20"],
["W","&#x11d;","20"],
["W","&#x11c;","20"],
["W","&#x11b;","41"],
["W","&#x119;","41"],
["W","&#x117;","41"],
["W","&#x115;","41"],
["W","&#x113;","41"],
["W","&#x111;","41"],
["W","&#x10f;","41"],
["W","&#x10d;","41"],
["W","&#x10c;","20"],
["W","&#x10b;","41"],
["W","&#x10a;","20"],
["W","&#x109;","41"],
["W","&#x108;","20"],
["W","&#x107;","41"],
["W","&#x106;","20"],
["W","&#x105;","41"],
["W","&#x104;","82"],
["W","&#x103;","41"],
["W","&#x102;","82"],
["W","&#x101;","41"],
["W","&#x100;","82"],
["W","&#xfc;","20"],
["W","&#xfb;","20"],
["W","&#xfa;","20"],
["W","&#xf9;","20"],
["W","&#xf8;","41"],
["W","&#xf6;","41"],
["W","&#xf5;","41"],
["W","&#xf4;","41"],
["W","&#xf3;","41"],
["W","&#xf2;","41"],
["W","&#xeb;","41"],
["W","&#xea;","41"],
["W","&#xe9;","41"],
["W","&#xe8;","41"],
["W","&#xe7;","41"],
["W","&#xe6;","41"],
["W","&#xe5;","41"],
["W","&#xe4;","41"],
["W","&#xe3;","41"],
["W","&#xe2;","41"],
["W","&#xe1;","41"],
["W","&#xe0;","41"],
["W","&#xd8;","20"],
["W","&#xd6;","20"],
["W","&#xd5;","20"],
["W","&#xd4;","20"],
["W","&#xd3;","20"],
["W","&#xd2;","20"],
["W","&#xc7;","20"],
["W","&#xc5;","82"],
["W","&#xc4;","82"],
["W","&#xc3;","82"],
["W","&#xc2;","82"],
["W","&#xc1;","82"],
["W","&#xc0;","82"],
["W","u","20"],
["W","s","20"],
["W","r","20"],
["W","q","41"],
["W","p","20"],
["W","o","41"],
["W","n","20"],
["W","m","20"],
["W","g","20"],
["W","e","41"],
["W","d","41"],
["W","c","41"],
["W","a","41"],
["W","Q","20"],
["W","O","20"],
["W","G","20"],
["W","C","20"],
["W","A","82"],
["W","&#x3f;","-41"],
["W","&#x2e;","102"],
["W","&#x2c;","102"],
["X","&#x1ee2;","41"],
["X","&#x1ee0;","41"],
["X","&#x1ede;","41"],
["X","&#x1edc;","41"],
["X","&#x1eda;","41"],
["X","&#x1ed8;","41"],
["X","&#x1ed6;","41"],
["X","&#x1ed4;","41"],
["X","&#x1ed2;","41"],
["X","&#x1ed0;","41"],
["X","&#x1ece;","41"],
["X","&#x1ecc;","41"],
["X","&#x1a0;","41"],
["X","&#x1fe;","41"],
["X","&#x152;","41"],
["X","&#x150;","41"],
["X","&#x14e;","41"],
["X","&#x14c;","41"],
["X","&#x122;","41"],
["X","&#x120;","41"],
["X","&#x11e;","41"],
["X","&#x11c;","41"],
["X","&#x10c;","41"],
["X","&#x10a;","41"],
["X","&#x108;","41"],
["X","&#x106;","41"],
["X","&#xd8;","41"],
["X","&#xd6;","41"],
["X","&#xd5;","41"],
["X","&#xd4;","41"],
["X","&#xd3;","41"],
["X","&#xd2;","41"],
["X","&#xc7;","41"],
["X","Q","41"],
["X","O","41"],
["X","G","41"],
["X","C","41"],
["Y","&#x1ef1;","61"],
["Y","&#x1eef;","61"],
["Y","&#x1eed;","61"],
["Y","&#x1eeb;","61"],
["Y","&#x1ee9;","61"],
["Y","&#x1ee7;","61"],
["Y","&#x1ee5;","61"],
["Y","&#x1ee3;","102"],
["Y","&#x1ee2;","41"],
["Y","&#x1ee1;","102"],
["Y","&#x1ee0;","41"],
["Y","&#x1edf;","102"],
["Y","&#x1ede;","41"],
["Y","&#x1edd;","102"],
["Y","&#x1edc;","41"],
["Y","&#x1edb;","102"],
["Y","&#x1eda;","41"],
["Y","&#x1ed9;","102"],
["Y","&#x1ed8;","41"],
["Y","&#x1ed7;","102"],
["Y","&#x1ed6;","41"],
["Y","&#x1ed5;","102"],
["Y","&#x1ed4;","41"],
["Y","&#x1ed2;","41"],
["Y","&#x1ed1;","102"],
["Y","&#x1ed0;","41"],
["Y","&#x1ecf;","102"],
["Y","&#x1ece;","41"],
["Y","&#x1ecd;","102"],
["Y","&#x1ecc;","41"],
["Y","&#x1ec7;","102"],
["Y","&#x1ec5;","102"],
["Y","&#x1ec3;","102"],
["Y","&#x1ebf;","102"],
["Y","&#x1ebd;","102"],
["Y","&#x1ebb;","102"],
["Y","&#x1eb9;","102"],
["Y","&#x1eb7;","102"],
["Y","&#x1eb6;","123"],
["Y","&#x1eb5;","102"],
["Y","&#x1eb4;","123"],
["Y","&#x1eb3;","102"],
["Y","&#x1eb2;","123"],
["Y","&#x1eb1;","102"],
["Y","&#x1eb0;","123"],
["Y","&#x1eaf;","102"],
["Y","&#x1eae;","123"],
["Y","&#x1ead;","102"],
["Y","&#x1eac;","123"],
["Y","&#x1eab;","102"],
["Y","&#x1eaa;","123"],
["Y","&#x1ea9;","102"],
["Y","&#x1ea8;","123"],
["Y","&#x1ea6;","123"],
["Y","&#x1ea5;","102"],
["Y","&#x1ea4;","123"],
["Y","&#x1ea3;","102"],
["Y","&#x1ea2;","123"],
["Y","&#x1ea1;","102"],
["Y","&#x1ea0;","123"],
["Y","&#x1b0;","61"],
["Y","&#x1a1;","102"],
["Y","&#x1a0;","41"],
["Y","&#x1e01;","102"],
["Y","&#x1e00;","123"],
["Y","&#x1e3f;","61"],
["Y","&#x201e;","123"],
["Y","&#x201a;","123"],
["Y","&#x219;","82"],
["Y","&#x1ff;","102"],
["Y","&#x1fe;","41"],
["Y","&#x1fd;","102"],
["Y","&#x1fb;","102"],
["Y","&#x1fa;","123"],
["Y","&#x17e;","41"],
["Y","&#x17c;","41"],
["Y","&#x17a;","41"],
["Y","&#x173;","61"],
["Y","&#x171;","61"],
["Y","&#x16f;","61"],
["Y","&#x16d;","61"],
["Y","&#x16b;","61"],
["Y","&#x169;","61"],
["Y","&#x15f;","82"],
["Y","&#x15b;","82"],
["Y","&#x157;","61"],
["Y","&#x155;","61"],
["Y","&#x153;","102"],
["Y","&#x152;","41"],
["Y","&#x151;","102"],
["Y","&#x150;","41"],
["Y","&#x14f;","102"],
["Y","&#x14e;","41"],
["Y","&#x14d;","102"],
["Y","&#x14c;","41"],
["Y","&#x14b;","61"],
["Y","&#x146;","61"],
["Y","&#x144;","61"],
["Y","&#x138;","61"],
["Y","&#x123;","41"],
["Y","&#x122;","41"],
["Y","&#x121;","41"],
["Y","&#x120;","41"],
["Y","&#x11f;","41"],
["Y","&#x11e;","41"],
["Y","&#x11d;","41"],
["Y","&#x11c;","41"],
["Y","&#x11b;","102"],
["Y","&#x119;","102"],
["Y","&#x117;","102"],
["Y","&#x115;","102"],
["Y","&#x113;","102"],
["Y","&#x111;","102"],
["Y","&#x10f;","102"],
["Y","&#x10d;","102"],
["Y","&#x10c;","41"],
["Y","&#x10b;","102"],
["Y","&#x10a;","41"],
["Y","&#x109;","102"],
["Y","&#x108;","41"],
["Y","&#x107;","102"],
["Y","&#x106;","41"],
["Y","&#x105;","102"],
["Y","&#x104;","123"],
["Y","&#x103;","102"],
["Y","&#x102;","123"],
["Y","&#x101;","102"],
["Y","&#x100;","123"],
["Y","&#xfc;","61"],
["Y","&#xfb;","61"],
["Y","&#xfa;","61"],
["Y","&#xf9;","61"],
["Y","&#xf8;","102"],
["Y","&#xf6;","102"],
["Y","&#xf5;","102"],
["Y","&#xf4;","102"],
["Y","&#xf3;","102"],
["Y","&#xf2;","102"],
["Y","&#xeb;","102"],
["Y","&#xea;","102"],
["Y","&#xe9;","102"],
["Y","&#xe8;","102"],
["Y","&#xe7;","102"],
["Y","&#xe6;","102"],
["Y","&#xe5;","102"],
["Y","&#xe4;","102"],
["Y","&#xe3;","102"],
["Y","&#xe2;","102"],
["Y","&#xe1;","102"],
["Y","&#xe0;","102"],
["Y","&#xd8;","41"],
["Y","&#xd6;","41"],
["Y","&#xd5;","41"],
["Y","&#xd4;","41"],
["Y","&#xd3;","41"],
["Y","&#xd2;","41"],
["Y","&#xc7;","41"],
["Y","&#xc5;","123"],
["Y","&#xc4;","123"],
["Y","&#xc3;","123"],
["Y","&#xc2;","123"],
["Y","&#xc1;","123"],
["Y","&#xc0;","123"],
["Y","z","41"],
["Y","u","61"],
["Y","s","82"],
["Y","r","61"],
["Y","q","102"],
["Y","p","61"],
["Y","o","102"],
["Y","n","61"],
["Y","m","61"],
["Y","g","41"],
["Y","e","102"],
["Y","d","102"],
["Y","c","102"],
["Y","a","102"],
["Y","Q","41"],
["Y","O","41"],
["Y","G","41"],
["Y","C","41"],
["Y","A","123"],
["Y","&#x3f;","-41"],
["Y","&#x2e;","123"],
["Y","&#x2c;","123"],
["Z","&#x1ee2;","20"],
["Z","&#x1ee0;","20"],
["Z","&#x1ede;","20"],
["Z","&#x1edc;","20"],
["Z","&#x1eda;","20"],
["Z","&#x1ed8;","20"],
["Z","&#x1ed6;","20"],
["Z","&#x1ed4;","20"],
["Z","&#x1ed2;","20"],
["Z","&#x1ed0;","20"],
["Z","&#x1ece;","20"],
["Z","&#x1ecc;","20"],
["Z","&#x1a0;","20"],
["Z","&#x1fe;","20"],
["Z","&#x152;","20"],
["Z","&#x150;","20"],
["Z","&#x14e;","20"],
["Z","&#x14c;","20"],
["Z","&#x122;","20"],
["Z","&#x120;","20"],
["Z","&#x11e;","20"],
["Z","&#x11c;","20"],
["Z","&#x10c;","20"],
["Z","&#x10a;","20"],
["Z","&#x108;","20"],
["Z","&#x106;","20"],
["Z","&#xd8;","20"],
["Z","&#xd6;","20"],
["Z","&#xd5;","20"],
["Z","&#xd4;","20"],
["Z","&#xd3;","20"],
["Z","&#xd2;","20"],
["Z","&#xc7;","20"],
["Z","Q","20"],
["Z","O","20"],
["Z","G","20"],
["Z","C","20"],
["[","J","-184"],
["a","&#x201d;","20"],
["a","&#x2019;","20"],
["a","&#x27;","20"],
["a","&#x22;","20"],
["b","&#x1ef5;","41"],
["b","&#x201d;","20"],
["b","&#x2019;","20"],
["b","&#x1e83;","41"],
["b","&#x1e81;","41"],
["b","&#x17e;","20"],
["b","&#x17c;","20"],
["b","&#x17a;","20"],
["b","&#x175;","41"],
["b","&#xfd;","41"],
["b","z","20"],
["b","y","41"],
["b","x","41"],
["b","w","41"],
["b","v","41"],
["b","&#x27;","20"],
["b","&#x22;","20"],
["c","&#x201d;","-41"],
["c","&#x2019;","-41"],
["c","&#x27;","-41"],
["c","&#x22;","-41"],
["e","&#x1ef5;","41"],
["e","&#x201d;","20"],
["e","&#x2019;","20"],
["e","&#x1e83;","41"],
["e","&#x1e81;","41"],
["e","&#x17e;","20"],
["e","&#x17c;","20"],
["e","&#x17a;","20"],
["e","&#x175;","41"],
["e","&#xfd;","41"],
["e","z","20"],
["e","y","41"],
["e","x","41"],
["e","w","41"],
["e","v","41"],
["e","&#x27;","20"],
["e","&#x22;","20"],
["f","&#x201d;","-123"],
["f","&#x2019;","-123"],
["f","&#x27;","-123"],
["f","&#x22;","-123"],
["h","&#x201d;","20"],
["h","&#x2019;","20"],
["h","&#x27;","20"],
["h","&#x22;","20"],
["k","&#x1ee3;","41"],
["k","&#x1ee1;","41"],
["k","&#x1edf;","41"],
["k","&#x1edd;","41"],
["k","&#x1edb;","41"],
["k","&#x1ed9;","41"],
["k","&#x1ed7;","41"],
["k","&#x1ed5;","41"],
["k","&#x1ed1;","41"],
["k","&#x1ecf;","41"],
["k","&#x1ecd;","41"],
["k","&#x1ec7;","41"],
["k","&#x1ec5;","41"],
["k","&#x1ec3;","41"],
["k","&#x1ebf;","41"],
["k","&#x1ebd;","41"],
["k","&#x1ebb;","41"],
["k","&#x1eb9;","41"],
["k","&#x1a1;","41"],
["k","&#x1ff;","41"],
["k","&#x153;","41"],
["k","&#x151;","41"],
["k","&#x14f;","41"],
["k","&#x14d;","41"],
["k","&#x11b;","41"],
["k","&#x119;","41"],
["k","&#x117;","41"],
["k","&#x115;","41"],
["k","&#x113;","41"],
["k","&#x111;","41"],
["k","&#x10f;","41"],
["k","&#x10d;","41"],
["k","&#x10b;","41"],
["k","&#x109;","41"],
["k","&#x107;","41"],
["k","&#xf8;","41"],
["k","&#xf6;","41"],
["k","&#xf5;","41"],
["k","&#xf4;","41"],
["k","&#xf3;","41"],
["k","&#xf2;","41"],
["k","&#xeb;","41"],
["k","&#xea;","41"],
["k","&#xe9;","41"],
["k","&#xe8;","41"],
["k","&#xe7;","41"],
["k","&#xe0;","41"],
["k","q","41"],
["k","o","41"],
["k","e","41"],
["k","d","41"],
["k","c","41"],
["m","&#x201d;","20"],
["m","&#x2019;","20"],
["m","&#x27;","20"],
["m","&#x22;","20"],
["n","&#x201d;","20"],
["n","&#x2019;","20"],
["n","&#x27;","20"],
["n","&#x22;","20"],
["o","&#x1ef5;","41"],
["o","&#x201d;","20"],
["o","&#x2019;","20"],
["o","&#x1e83;","41"],
["o","&#x1e81;","41"],
["o","&#x17e;","20"],
["o","&#x17c;","20"],
["o","&#x17a;","20"],
["o","&#x175;","41"],
["o","&#xfd;","41"],
["o","z","20"],
["o","y","41"],
["o","x","41"],
["o","w","41"],
["o","v","41"],
["o","&#x27;","20"],
["o","&#x22;","20"],
["p","&#x1ef5;","41"],
["p","&#x201d;","20"],
["p","&#x2019;","20"],
["p","&#x1e83;","41"],
["p","&#x1e81;","41"],
["p","&#x17e;","20"],
["p","&#x17c;","20"],
["p","&#x17a;","20"],
["p","&#x175;","41"],
["p","&#xfd;","41"],
["p","z","20"],
["p","y","41"],
["p","x","41"],
["p","w","41"],
["p","v","41"],
["p","&#x27;","20"],
["p","&#x22;","20"],
["r","&#x1ee3;","41"],
["r","&#x1ee1;","41"],
["r","&#x1edf;","41"],
["r","&#x1edd;","41"],
["r","&#x1edb;","41"],
["r","&#x1ed9;","41"],
["r","&#x1ed7;","41"],
["r","&#x1ed5;","41"],
["r","&#x1ed1;","41"],
["r","&#x1ecf;","41"],
["r","&#x1ecd;","41"],
["r","&#x1ec7;","41"],
["r","&#x1ec5;","41"],
["r","&#x1ec3;","41"],
["r","&#x1ebf;","41"],
["r","&#x1ebd;","41"],
["r","&#x1ebb;","41"],
["r","&#x1eb9;","41"],
["r","&#x1eb7;","41"],
["r","&#x1eb5;","41"],
["r","&#x1eb3;","41"],
["r","&#x1eb1;","41"],
["r","&#x1eaf;","41"],
["r","&#x1ead;","41"],
["r","&#x1eab;","41"],
["r","&#x1ea9;","41"],
["r","&#x1ea5;","41"],
["r","&#x1ea3;","41"],
["r","&#x1ea1;","41"],
["r","&#x1a1;","41"],
["r","&#x1e01;","41"],
["r","&#x201d;","-82"],
["r","&#x2019;","-82"],
["r","&#x1ff;","41"],
["r","&#x1fd;","41"],
["r","&#x1fb;","41"],
["r","&#x153;","41"],
["r","&#x151;","41"],
["r","&#x14f;","41"],
["r","&#x14d;","41"],
["r","&#x123;","20"],
["r","&#x121;","20"],
["r","&#x11f;","20"],
["r","&#x11d;","20"],
["r","&#x11b;","41"],
["r","&#x119;","41"],
["r","&#x117;","41"],
["r","&#x115;","41"],
["r","&#x113;","41"],
["r","&#x111;","41"],
["r","&#x10f;","41"],
["r","&#x10d;","41"],
["r","&#x10b;","41"],
["r","&#x109;","41"],
["r","&#x107;","41"],
["r","&#x105;","41"],
["r","&#x103;","41"],
["r","&#x101;","41"],
["r","&#xf8;","41"],
["r","&#xf6;","41"],
["r","&#xf5;","41"],
["r","&#xf4;","41"],
["r","&#xf3;","41"],
["r","&#xf2;","41"],
["r","&#xeb;","41"],
["r","&#xea;","41"],
["r","&#xe9;","41"],
["r","&#xe8;","41"],
["r","&#xe7;","41"],
["r","&#xe6;","41"],
["r","&#xe5;","41"],
["r","&#xe4;","41"],
["r","&#xe3;","41"],
["r","&#xe2;","41"],
["r","&#xe1;","41"],
["r","&#xe0;","41"],
["r","q","41"],
["r","o","41"],
["r","g","20"],
["r","e","41"],
["r","d","41"],
["r","c","41"],
["r","a","41"],
["r","&#x27;","-82"],
["r","&#x22;","-82"],
["t","&#x201d;","-41"],
["t","&#x2019;","-41"],
["t","&#x27;","-41"],
["t","&#x22;","-41"],
["v","&#x201e;","82"],
["v","&#x201d;","-82"],
["v","&#x201a;","82"],
["v","&#x2019;","-82"],
["v","&#x3f;","-41"],
["v","&#x2e;","82"],
["v","&#x2c;","82"],
["v","&#x27;","-82"],
["v","&#x22;","-82"],
["w","&#x201e;","82"],
["w","&#x201d;","-82"],
["w","&#x201a;","82"],
["w","&#x2019;","-82"],
["w","&#x3f;","-41"],
["w","&#x2e;","82"],
["w","&#x2c;","82"],
["w","&#x27;","-82"],
["w","&#x22;","-82"],
["x","&#x1ee3;","41"],
["x","&#x1ee1;","41"],
["x","&#x1edf;","41"],
["x","&#x1edd;","41"],
["x","&#x1edb;","41"],
["x","&#x1ed9;","41"],
["x","&#x1ed7;","41"],
["x","&#x1ed5;","41"],
["x","&#x1ed1;","41"],
["x","&#x1ecf;","41"],
["x","&#x1ecd;","41"],
["x","&#x1ec7;","41"],
["x","&#x1ec5;","41"],
["x","&#x1ec3;","41"],
["x","&#x1ebf;","41"],
["x","&#x1ebd;","41"],
["x","&#x1ebb;","41"],
["x","&#x1eb9;","41"],
["x","&#x1a1;","41"],
["x","&#x1ff;","41"],
["x","&#x153;","41"],
["x","&#x151;","41"],
["x","&#x14f;","41"],
["x","&#x14d;","41"],
["x","&#x11b;","41"],
["x","&#x119;","41"],
["x","&#x117;","41"],
["x","&#x115;","41"],
["x","&#x113;","41"],
["x","&#x111;","41"],
["x","&#x10f;","41"],
["x","&#x10d;","41"],
["x","&#x10b;","41"],
["x","&#x109;","41"],
["x","&#x107;","41"],
["x","&#xf8;","41"],
["x","&#xf6;","41"],
["x","&#xf5;","41"],
["x","&#xf4;","41"],
["x","&#xf3;","41"],
["x","&#xf2;","41"],
["x","&#xeb;","41"],
["x","&#xea;","41"],
["x","&#xe9;","41"],
["x","&#xe8;","41"],
["x","&#xe7;","41"],
["x","&#xe0;","41"],
["x","q","41"],
["x","o","41"],
["x","e","41"],
["x","d","41"],
["x","c","41"],
["y","&#x201e;","82"],
["y","&#x201d;","-82"],
["y","&#x201a;","82"],
["y","&#x2019;","-82"],
["y","&#x3f;","-41"],
["y","&#x2e;","82"],
["y","&#x2c;","82"],
["y","&#x27;","-82"],
["y","&#x22;","-82"],
["&#x7b;","J","-184"],
["&#xc0;","&#x162;","143"],
["&#xc0;","&#x1ef8;","123"],
["&#xc0;","&#x1ef6;","123"],
["&#xc0;","&#x1ef4;","123"],
["&#xc0;","&#x1ee2;","41"],
["&#xc0;","&#x1ee0;","41"],
["&#xc0;","&#x1ede;","41"],
["&#xc0;","&#x1edc;","41"],
["&#xc0;","&#x1eda;","41"],
["&#xc0;","&#x1ed8;","41"],
["&#xc0;","&#x1ed6;","41"],
["&#xc0;","&#x1ed4;","41"],
["&#xc0;","&#x1ed2;","41"],
["&#xc0;","&#x1ed0;","41"],
["&#xc0;","&#x1ece;","41"],
["&#xc0;","&#x1ecc;","41"],
["&#xc0;","&#x1a0;","41"],
["&#xc0;","&#x201d;","143"],
["&#xc0;","&#x2019;","143"],
["&#xc0;","&#x1ef2;","123"],
["&#xc0;","&#x1e84;","82"],
["&#xc0;","&#x1e82;","82"],
["&#xc0;","&#x1e80;","82"],
["&#xc0;","&#x1fe;","41"],
["&#xc0;","&#x178;","123"],
["&#xc0;","&#x176;","123"],
["&#xc0;","&#x174;","82"],
["&#xc0;","&#x164;","143"],
["&#xc0;","&#x21a;","143"],
["&#xc0;","&#x152;","41"],
["&#xc0;","&#x150;","41"],
["&#xc0;","&#x14e;","41"],
["&#xc0;","&#x14c;","41"],
["&#xc0;","&#x122;","41"],
["&#xc0;","&#x120;","41"],
["&#xc0;","&#x11e;","41"],
["&#xc0;","&#x11c;","41"],
["&#xc0;","&#x10c;","41"],
["&#xc0;","&#x10a;","41"],
["&#xc0;","&#x108;","41"],
["&#xc0;","&#x106;","41"],
["&#xc0;","&#xdd;","123"],
["&#xc0;","&#xd8;","41"],
["&#xc0;","&#xd6;","41"],
["&#xc0;","&#xd5;","41"],
["&#xc0;","&#xd4;","41"],
["&#xc0;","&#xd3;","41"],
["&#xc0;","&#xd2;","41"],
["&#xc0;","&#xc7;","41"],
["&#xc0;","Y","123"],
["&#xc0;","W","82"],
["&#xc0;","V","82"],
["&#xc0;","T","143"],
["&#xc0;","Q","41"],
["&#xc0;","O","41"],
["&#xc0;","J","-266"],
["&#xc0;","G","41"],
["&#xc0;","C","41"],
["&#xc0;","&#x27;","143"],
["&#xc0;","&#x22;","143"],
["&#xc1;","&#x162;","143"],
["&#xc1;","&#x1ef8;","123"],
["&#xc1;","&#x1ef6;","123"],
["&#xc1;","&#x1ef4;","123"],
["&#xc1;","&#x1ee2;","41"],
["&#xc1;","&#x1ee0;","41"],
["&#xc1;","&#x1ede;","41"],
["&#xc1;","&#x1edc;","41"],
["&#xc1;","&#x1eda;","41"],
["&#xc1;","&#x1ed8;","41"],
["&#xc1;","&#x1ed6;","41"],
["&#xc1;","&#x1ed4;","41"],
["&#xc1;","&#x1ed2;","41"],
["&#xc1;","&#x1ed0;","41"],
["&#xc1;","&#x1ece;","41"],
["&#xc1;","&#x1ecc;","41"],
["&#xc1;","&#x1a0;","41"],
["&#xc1;","&#x201d;","143"],
["&#xc1;","&#x2019;","143"],
["&#xc1;","&#x1ef2;","123"],
["&#xc1;","&#x1e84;","82"],
["&#xc1;","&#x1e82;","82"],
["&#xc1;","&#x1e80;","82"],
["&#xc1;","&#x1fe;","41"],
["&#xc1;","&#x178;","123"],
["&#xc1;","&#x176;","123"],
["&#xc1;","&#x174;","82"],
["&#xc1;","&#x164;","143"],
["&#xc1;","&#x21a;","143"],
["&#xc1;","&#x152;","41"],
["&#xc1;","&#x150;","41"],
["&#xc1;","&#x14e;","41"],
["&#xc1;","&#x14c;","41"],
["&#xc1;","&#x122;","41"],
["&#xc1;","&#x120;","41"],
["&#xc1;","&#x11e;","41"],
["&#xc1;","&#x11c;","41"],
["&#xc1;","&#x10c;","41"],
["&#xc1;","&#x10a;","41"],
["&#xc1;","&#x108;","41"],
["&#xc1;","&#x106;","41"],
["&#xc1;","&#xdd;","123"],
["&#xc1;","&#xd8;","41"],
["&#xc1;","&#xd6;","41"],
["&#xc1;","&#xd5;","41"],
["&#xc1;","&#xd4;","41"],
["&#xc1;","&#xd3;","41"],
["&#xc1;","&#xd2;","41"],
["&#xc1;","&#xc7;","41"],
["&#xc1;","Y","123"],
["&#xc1;","W","82"],
["&#xc1;","V","82"],
["&#xc1;","T","143"],
["&#xc1;","Q","41"],
["&#xc1;","O","41"],
["&#xc1;","J","-266"],
["&#xc1;","G","41"],
["&#xc1;","C","41"],
["&#xc1;","&#x27;","143"],
["&#xc1;","&#x22;","143"],
["&#xc2;","&#x162;","143"],
["&#xc2;","&#x1ef8;","123"],
["&#xc2;","&#x1ef6;","123"],
["&#xc2;","&#x1ef4;","123"],
["&#xc2;","&#x1ee2;","41"],
["&#xc2;","&#x1ee0;","41"],
["&#xc2;","&#x1ede;","41"],
["&#xc2;","&#x1edc;","41"],
["&#xc2;","&#x1eda;","41"],
["&#xc2;","&#x1ed8;","41"],
["&#xc2;","&#x1ed6;","41"],
["&#xc2;","&#x1ed4;","41"],
["&#xc2;","&#x1ed2;","41"],
["&#xc2;","&#x1ed0;","41"],
["&#xc2;","&#x1ece;","41"],
["&#xc2;","&#x1ecc;","41"],
["&#xc2;","&#x1a0;","41"],
["&#xc2;","&#x201d;","143"],
["&#xc2;","&#x2019;","143"],
["&#xc2;","&#x1ef2;","123"],
["&#xc2;","&#x1e84;","82"],
["&#xc2;","&#x1e82;","82"],
["&#xc2;","&#x1e80;","82"],
["&#xc2;","&#x1fe;","41"],
["&#xc2;","&#x178;","123"],
["&#xc2;","&#x176;","123"],
["&#xc2;","&#x174;","82"],
["&#xc2;","&#x164;","143"],
["&#xc2;","&#x21a;","143"],
["&#xc2;","&#x152;","41"],
["&#xc2;","&#x150;","41"],
["&#xc2;","&#x14e;","41"],
["&#xc2;","&#x14c;","41"],
["&#xc2;","&#x122;","41"],
["&#xc2;","&#x120;","41"],
["&#xc2;","&#x11e;","41"],
["&#xc2;","&#x11c;","41"],
["&#xc2;","&#x10c;","41"],
["&#xc2;","&#x10a;","41"],
["&#xc2;","&#x108;","41"],
["&#xc2;","&#x106;","41"],
["&#xc2;","&#xdd;","123"],
["&#xc2;","&#xd8;","41"],
["&#xc2;","&#xd6;","41"],
["&#xc2;","&#xd5;","41"],
["&#xc2;","&#xd4;","41"],
["&#xc2;","&#xd3;","41"],
["&#xc2;","&#xd2;","41"],
["&#xc2;","&#xc7;","41"],
["&#xc2;","Y","123"],
["&#xc2;","W","82"],
["&#xc2;","V","82"],
["&#xc2;","T","143"],
["&#xc2;","Q","41"],
["&#xc2;","O","41"],
["&#xc2;","J","-266"],
["&#xc2;","G","41"],
["&#xc2;","C","41"],
["&#xc2;","&#x27;","143"],
["&#xc2;","&#x22;","143"],
["&#xc3;","&#x162;","143"],
["&#xc3;","&#x1ef8;","123"],
["&#xc3;","&#x1ef6;","123"],
["&#xc3;","&#x1ef4;","123"],
["&#xc3;","&#x1ee2;","41"],
["&#xc3;","&#x1ee0;","41"],
["&#xc3;","&#x1ede;","41"],
["&#xc3;","&#x1edc;","41"],
["&#xc3;","&#x1eda;","41"],
["&#xc3;","&#x1ed8;","41"],
["&#xc3;","&#x1ed6;","41"],
["&#xc3;","&#x1ed4;","41"],
["&#xc3;","&#x1ed2;","41"],
["&#xc3;","&#x1ed0;","41"],
["&#xc3;","&#x1ece;","41"],
["&#xc3;","&#x1ecc;","41"],
["&#xc3;","&#x1a0;","41"],
["&#xc3;","&#x201d;","143"],
["&#xc3;","&#x2019;","143"],
["&#xc3;","&#x1ef2;","123"],
["&#xc3;","&#x1e84;","82"],
["&#xc3;","&#x1e82;","82"],
["&#xc3;","&#x1e80;","82"],
["&#xc3;","&#x1fe;","41"],
["&#xc3;","&#x178;","123"],
["&#xc3;","&#x176;","123"],
["&#xc3;","&#x174;","82"],
["&#xc3;","&#x164;","143"],
["&#xc3;","&#x21a;","143"],
["&#xc3;","&#x152;","41"],
["&#xc3;","&#x150;","41"],
["&#xc3;","&#x14e;","41"],
["&#xc3;","&#x14c;","41"],
["&#xc3;","&#x122;","41"],
["&#xc3;","&#x120;","41"],
["&#xc3;","&#x11e;","41"],
["&#xc3;","&#x11c;","41"],
["&#xc3;","&#x10c;","41"],
["&#xc3;","&#x10a;","41"],
["&#xc3;","&#x108;","41"],
["&#xc3;","&#x106;","41"],
["&#xc3;","&#xdd;","123"],
["&#xc3;","&#xd8;","41"],
["&#xc3;","&#xd6;","41"],
["&#xc3;","&#xd5;","41"],
["&#xc3;","&#xd4;","41"],
["&#xc3;","&#xd3;","41"],
["&#xc3;","&#xd2;","41"],
["&#xc3;","&#xc7;","41"],
["&#xc3;","Y","123"],
["&#xc3;","W","82"],
["&#xc3;","V","82"],
["&#xc3;","T","143"],
["&#xc3;","Q","41"],
["&#xc3;","O","41"],
["&#xc3;","J","-266"],
["&#xc3;","G","41"],
["&#xc3;","C","41"],
["&#xc3;","&#x27;","143"],
["&#xc3;","&#x22;","143"],
["&#xc4;","&#x162;","143"],
["&#xc4;","&#x1ef8;","123"],
["&#xc4;","&#x1ef6;","123"],
["&#xc4;","&#x1ef4;","123"],
["&#xc4;","&#x1ee2;","41"],
["&#xc4;","&#x1ee0;","41"],
["&#xc4;","&#x1ede;","41"],
["&#xc4;","&#x1edc;","41"],
["&#xc4;","&#x1eda;","41"],
["&#xc4;","&#x1ed8;","41"],
["&#xc4;","&#x1ed6;","41"],
["&#xc4;","&#x1ed4;","41"],
["&#xc4;","&#x1ed2;","41"],
["&#xc4;","&#x1ed0;","41"],
["&#xc4;","&#x1ece;","41"],
["&#xc4;","&#x1ecc;","41"],
["&#xc4;","&#x1a0;","41"],
["&#xc4;","&#x201d;","143"],
["&#xc4;","&#x2019;","143"],
["&#xc4;","&#x1ef2;","123"],
["&#xc4;","&#x1e84;","82"],
["&#xc4;","&#x1e82;","82"],
["&#xc4;","&#x1e80;","82"],
["&#xc4;","&#x1fe;","41"],
["&#xc4;","&#x178;","123"],
["&#xc4;","&#x176;","123"],
["&#xc4;","&#x174;","82"],
["&#xc4;","&#x164;","143"],
["&#xc4;","&#x21a;","143"],
["&#xc4;","&#x152;","41"],
["&#xc4;","&#x150;","41"],
["&#xc4;","&#x14e;","41"],
["&#xc4;","&#x14c;","41"],
["&#xc4;","&#x122;","41"],
["&#xc4;","&#x120;","41"],
["&#xc4;","&#x11e;","41"],
["&#xc4;","&#x11c;","41"],
["&#xc4;","&#x10c;","41"],
["&#xc4;","&#x10a;","41"],
["&#xc4;","&#x108;","41"],
["&#xc4;","&#x106;","41"],
["&#xc4;","&#xdd;","123"],
["&#xc4;","&#xd8;","41"],
["&#xc4;","&#xd6;","41"],
["&#xc4;","&#xd5;","41"],
["&#xc4;","&#xd4;","41"],
["&#xc4;","&#xd3;","41"],
["&#xc4;","&#xd2;","41"],
["&#xc4;","&#xc7;","41"],
["&#xc4;","Y","123"],
["&#xc4;","W","82"],
["&#xc4;","V","82"],
["&#xc4;","T","143"],
["&#xc4;","Q","41"],
["&#xc4;","O","41"],
["&#xc4;","J","-266"],
["&#xc4;","G","41"],
["&#xc4;","C","41"],
["&#xc4;","&#x27;","143"],
["&#xc4;","&#x22;","143"],
["&#xc5;","&#x162;","143"],
["&#xc5;","&#x1ef8;","123"],
["&#xc5;","&#x1ef6;","123"],
["&#xc5;","&#x1ef4;","123"],
["&#xc5;","&#x1ee2;","41"],
["&#xc5;","&#x1ee0;","41"],
["&#xc5;","&#x1ede;","41"],
["&#xc5;","&#x1edc;","41"],
["&#xc5;","&#x1eda;","41"],
["&#xc5;","&#x1ed8;","41"],
["&#xc5;","&#x1ed6;","41"],
["&#xc5;","&#x1ed4;","41"],
["&#xc5;","&#x1ed2;","41"],
["&#xc5;","&#x1ed0;","41"],
["&#xc5;","&#x1ece;","41"],
["&#xc5;","&#x1ecc;","41"],
["&#xc5;","&#x1a0;","41"],
["&#xc5;","&#x201d;","143"],
["&#xc5;","&#x2019;","143"],
["&#xc5;","&#x1ef2;","123"],
["&#xc5;","&#x1e84;","82"],
["&#xc5;","&#x1e82;","82"],
["&#xc5;","&#x1e80;","82"],
["&#xc5;","&#x1fe;","41"],
["&#xc5;","&#x178;","123"],
["&#xc5;","&#x176;","123"],
["&#xc5;","&#x174;","82"],
["&#xc5;","&#x164;","143"],
["&#xc5;","&#x21a;","143"],
["&#xc5;","&#x152;","41"],
["&#xc5;","&#x150;","41"],
["&#xc5;","&#x14e;","41"],
["&#xc5;","&#x14c;","41"],
["&#xc5;","&#x122;","41"],
["&#xc5;","&#x120;","41"],
["&#xc5;","&#x11e;","41"],
["&#xc5;","&#x11c;","41"],
["&#xc5;","&#x10c;","41"],
["&#xc5;","&#x10a;","41"],
["&#xc5;","&#x108;","41"],
["&#xc5;","&#x106;","41"],
["&#xc5;","&#xdd;","123"],
["&#xc5;","&#xd8;","41"],
["&#xc5;","&#xd6;","41"],
["&#xc5;","&#xd5;","41"],
["&#xc5;","&#xd4;","41"],
["&#xc5;","&#xd3;","41"],
["&#xc5;","&#xd2;","41"],
["&#xc5;","&#xc7;","41"],
["&#xc5;","Y","123"],
["&#xc5;","W","82"],
["&#xc5;","V","82"],
["&#xc5;","T","143"],
["&#xc5;","Q","41"],
["&#xc5;","O","41"],
["&#xc5;","J","-266"],
["&#xc5;","G","41"],
["&#xc5;","C","41"],
["&#xc5;","&#x27;","143"],
["&#xc5;","&#x22;","143"],
["&#xc6;","J","-123"],
["&#xc7;","&#x1ee2;","41"],
["&#xc7;","&#x1ee0;","41"],
["&#xc7;","&#x1ede;","41"],
["&#xc7;","&#x1edc;","41"],
["&#xc7;","&#x1eda;","41"],
["&#xc7;","&#x1ed8;","41"],
["&#xc7;","&#x1ed6;","41"],
["&#xc7;","&#x1ed4;","41"],
["&#xc7;","&#x1ed2;","41"],
["&#xc7;","&#x1ed0;","41"],
["&#xc7;","&#x1ece;","41"],
["&#xc7;","&#x1ecc;","41"],
["&#xc7;","&#x1a0;","41"],
["&#xc7;","&#x1fe;","41"],
["&#xc7;","&#x152;","41"],
["&#xc7;","&#x150;","41"],
["&#xc7;","&#x14e;","41"],
["&#xc7;","&#x14c;","41"],
["&#xc7;","&#x122;","41"],
["&#xc7;","&#x120;","41"],
["&#xc7;","&#x11e;","41"],
["&#xc7;","&#x11c;","41"],
["&#xc7;","&#x10c;","41"],
["&#xc7;","&#x10a;","41"],
["&#xc7;","&#x108;","41"],
["&#xc7;","&#x106;","41"],
["&#xc7;","&#xd8;","41"],
["&#xc7;","&#xd6;","41"],
["&#xc7;","&#xd5;","41"],
["&#xc7;","&#xd4;","41"],
["&#xc7;","&#xd3;","41"],
["&#xc7;","&#xd2;","41"],
["&#xc7;","&#xc7;","41"],
["&#xc7;","Q","41"],
["&#xc7;","O","41"],
["&#xc7;","G","41"],
["&#xc7;","C","41"],
["&#xc8;","J","-123"],
["&#xc9;","J","-123"],
["&#xca;","J","-123"],
["&#xcb;","J","-123"],
["&#xd0;","&#x162;","61"],
["&#xd0;","&#x1ef8;","20"],
["&#xd0;","&#x1ef6;","20"],
["&#xd0;","&#x1ef4;","20"],
["&#xd0;","&#x1eb6;","41"],
["&#xd0;","&#x1eb4;","41"],
["&#xd0;","&#x1eb2;","41"],
["&#xd0;","&#x1eb0;","41"],
["&#xd0;","&#x1eae;","41"],
["&#xd0;","&#x1eac;","41"],
["&#xd0;","&#x1eaa;","41"],
["&#xd0;","&#x1ea8;","41"],
["&#xd0;","&#x1ea6;","41"],
["&#xd0;","&#x1ea4;","41"],
["&#xd0;","&#x1ea2;","41"],
["&#xd0;","&#x1ea0;","41"],
["&#xd0;","&#x1e00;","41"],
["&#xd0;","&#x201e;","82"],
["&#xd0;","&#x201a;","82"],
["&#xd0;","&#x1ef2;","20"],
["&#xd0;","&#x1e84;","20"],
["&#xd0;","&#x1e82;","20"],
["&#xd0;","&#x1e80;","20"],
["&#xd0;","&#x405;","20"],
["&#xd0;","&#x1fa;","41"],
["&#xd0;","&#x17d;","20"],
["&#xd0;","&#x17b;","20"],
["&#xd0;","&#x179;","20"],
["&#xd0;","&#x178;","20"],
["&#xd0;","&#x176;","20"],
["&#xd0;","&#x174;","20"],
["&#xd0;","&#x164;","61"],
["&#xd0;","&#x21a;","61"],
["&#xd0;","&#x104;","41"],
["&#xd0;","&#x102;","41"],
["&#xd0;","&#x100;","41"],
["&#xd0;","&#xdd;","20"],
["&#xd0;","&#xc5;","41"],
["&#xd0;","&#xc4;","41"],
["&#xd0;","&#xc3;","41"],
["&#xd0;","&#xc2;","41"],
["&#xd0;","&#xc1;","41"],
["&#xd0;","&#xc0;","41"],
["&#xd0;","Z","20"],
["&#xd0;","Y","20"],
["&#xd0;","X","41"],
["&#xd0;","W","20"],
["&#xd0;","V","20"],
["&#xd0;","T","61"],
["&#xd0;","A","41"],
["&#xd0;","&#x2e;","82"],
["&#xd0;","&#x2c;","82"],
["&#xd2;","&#x162;","61"],
["&#xd2;","&#x1ef8;","20"],
["&#xd2;","&#x1ef6;","20"],
["&#xd2;","&#x1ef4;","20"],
["&#xd2;","&#x1eb6;","41"],
["&#xd2;","&#x1eb4;","41"],
["&#xd2;","&#x1eb2;","41"],
["&#xd2;","&#x1eb0;","41"],
["&#xd2;","&#x1eae;","41"],
["&#xd2;","&#x1eac;","41"],
["&#xd2;","&#x1eaa;","41"],
["&#xd2;","&#x1ea8;","41"],
["&#xd2;","&#x1ea6;","41"],
["&#xd2;","&#x1ea4;","41"],
["&#xd2;","&#x1ea2;","41"],
["&#xd2;","&#x1ea0;","41"],
["&#xd2;","&#x1e00;","41"],
["&#xd2;","&#x201e;","82"],
["&#xd2;","&#x201a;","82"],
["&#xd2;","&#x1ef2;","20"],
["&#xd2;","&#x1e84;","20"],
["&#xd2;","&#x1e82;","20"],
["&#xd2;","&#x1e80;","20"],
["&#xd2;","&#x405;","20"],
["&#xd2;","&#x1fa;","41"],
["&#xd2;","&#x17d;","20"],
["&#xd2;","&#x17b;","20"],
["&#xd2;","&#x179;","20"],
["&#xd2;","&#x178;","20"],
["&#xd2;","&#x176;","20"],
["&#xd2;","&#x174;","20"],
["&#xd2;","&#x164;","61"],
["&#xd2;","&#x21a;","61"],
["&#xd2;","&#x104;","41"],
["&#xd2;","&#x102;","41"],
["&#xd2;","&#x100;","41"],
["&#xd2;","&#xdd;","20"],
["&#xd2;","&#xc5;","41"],
["&#xd2;","&#xc4;","41"],
["&#xd2;","&#xc3;","41"],
["&#xd2;","&#xc2;","41"],
["&#xd2;","&#xc1;","41"],
["&#xd2;","&#xc0;","41"],
["&#xd2;","Z","20"],
["&#xd2;","Y","20"],
["&#xd2;","X","41"],
["&#xd2;","W","20"],
["&#xd2;","V","20"],
["&#xd2;","T","61"],
["&#xd2;","A","41"],
["&#xd2;","&#x2e;","82"],
["&#xd2;","&#x2c;","82"],
["&#xd3;","&#x162;","61"],
["&#xd3;","&#x1ef8;","20"],
["&#xd3;","&#x1ef6;","20"],
["&#xd3;","&#x1ef4;","20"],
["&#xd3;","&#x1eb6;","41"],
["&#xd3;","&#x1eb4;","41"],
["&#xd3;","&#x1eb2;","41"],
["&#xd3;","&#x1eb0;","41"],
["&#xd3;","&#x1eae;","41"],
["&#xd3;","&#x1eac;","41"],
["&#xd3;","&#x1eaa;","41"],
["&#xd3;","&#x1ea8;","41"],
["&#xd3;","&#x1ea6;","41"],
["&#xd3;","&#x1ea4;","41"],
["&#xd3;","&#x1ea2;","41"],
["&#xd3;","&#x1ea0;","41"],
["&#xd3;","&#x1e00;","41"],
["&#xd3;","&#x201e;","82"],
["&#xd3;","&#x201a;","82"],
["&#xd3;","&#x1ef2;","20"],
["&#xd3;","&#x1e84;","20"],
["&#xd3;","&#x1e82;","20"],
["&#xd3;","&#x1e80;","20"],
["&#xd3;","&#x405;","20"],
["&#xd3;","&#x1fa;","41"],
["&#xd3;","&#x17d;","20"],
["&#xd3;","&#x17b;","20"],
["&#xd3;","&#x179;","20"],
["&#xd3;","&#x178;","20"],
["&#xd3;","&#x176;","20"],
["&#xd3;","&#x174;","20"],
["&#xd3;","&#x164;","61"],
["&#xd3;","&#x21a;","61"],
["&#xd3;","&#x104;","41"],
["&#xd3;","&#x102;","41"],
["&#xd3;","&#x100;","41"],
["&#xd3;","&#xdd;","20"],
["&#xd3;","&#xc5;","41"],
["&#xd3;","&#xc4;","41"],
["&#xd3;","&#xc3;","41"],
["&#xd3;","&#xc2;","41"],
["&#xd3;","&#xc1;","41"],
["&#xd3;","&#xc0;","41"],
["&#xd3;","Z","20"],
["&#xd3;","Y","20"],
["&#xd3;","X","41"],
["&#xd3;","W","20"],
["&#xd3;","V","20"],
["&#xd3;","T","61"],
["&#xd3;","A","41"],
["&#xd3;","&#x2e;","82"],
["&#xd3;","&#x2c;","82"],
["&#xd4;","&#x162;","61"],
["&#xd4;","&#x1ef8;","20"],
["&#xd4;","&#x1ef6;","20"],
["&#xd4;","&#x1ef4;","20"],
["&#xd4;","&#x1eb6;","41"],
["&#xd4;","&#x1eb4;","41"],
["&#xd4;","&#x1eb2;","41"],
["&#xd4;","&#x1eb0;","41"],
["&#xd4;","&#x1eae;","41"],
["&#xd4;","&#x1eac;","41"],
["&#xd4;","&#x1eaa;","41"],
["&#xd4;","&#x1ea8;","41"],
["&#xd4;","&#x1ea6;","41"],
["&#xd4;","&#x1ea4;","41"],
["&#xd4;","&#x1ea2;","41"],
["&#xd4;","&#x1ea0;","41"],
["&#xd4;","&#x1e00;","41"],
["&#xd4;","&#x201e;","82"],
["&#xd4;","&#x201a;","82"],
["&#xd4;","&#x1ef2;","20"],
["&#xd4;","&#x1e84;","20"],
["&#xd4;","&#x1e82;","20"],
["&#xd4;","&#x1e80;","20"],
["&#xd4;","&#x405;","20"],
["&#xd4;","&#x1fa;","41"],
["&#xd4;","&#x17d;","20"],
["&#xd4;","&#x17b;","20"],
["&#xd4;","&#x179;","20"],
["&#xd4;","&#x178;","20"],
["&#xd4;","&#x176;","20"],
["&#xd4;","&#x174;","20"],
["&#xd4;","&#x164;","61"],
["&#xd4;","&#x21a;","61"],
["&#xd4;","&#x104;","41"],
["&#xd4;","&#x102;","41"],
["&#xd4;","&#x100;","41"],
["&#xd4;","&#xdd;","20"],
["&#xd4;","&#xc5;","41"],
["&#xd4;","&#xc4;","41"],
["&#xd4;","&#xc3;","41"],
["&#xd4;","&#xc2;","41"],
["&#xd4;","&#xc1;","41"],
["&#xd4;","&#xc0;","41"],
["&#xd4;","Z","20"],
["&#xd4;","Y","20"],
["&#xd4;","X","41"],
["&#xd4;","W","20"],
["&#xd4;","V","20"],
["&#xd4;","T","61"],
["&#xd4;","A","41"],
["&#xd4;","&#x2e;","82"],
["&#xd4;","&#x2c;","82"],
["&#xd5;","&#x162;","61"],
["&#xd5;","&#x1ef8;","20"],
["&#xd5;","&#x1ef6;","20"],
["&#xd5;","&#x1ef4;","20"],
["&#xd5;","&#x1eb6;","41"],
["&#xd5;","&#x1eb4;","41"],
["&#xd5;","&#x1eb2;","41"],
["&#xd5;","&#x1eb0;","41"],
["&#xd5;","&#x1eae;","41"],
["&#xd5;","&#x1eac;","41"],
["&#xd5;","&#x1eaa;","41"],
["&#xd5;","&#x1ea8;","41"],
["&#xd5;","&#x1ea6;","41"],
["&#xd5;","&#x1ea4;","41"],
["&#xd5;","&#x1ea2;","41"],
["&#xd5;","&#x1ea0;","41"],
["&#xd5;","&#x1e00;","41"],
["&#xd5;","&#x201e;","82"],
["&#xd5;","&#x201a;","82"],
["&#xd5;","&#x1ef2;","20"],
["&#xd5;","&#x1e84;","20"],
["&#xd5;","&#x1e82;","20"],
["&#xd5;","&#x1e80;","20"],
["&#xd5;","&#x405;","20"],
["&#xd5;","&#x1fa;","41"],
["&#xd5;","&#x17d;","20"],
["&#xd5;","&#x17b;","20"],
["&#xd5;","&#x179;","20"],
["&#xd5;","&#x178;","20"],
["&#xd5;","&#x176;","20"],
["&#xd5;","&#x174;","20"],
["&#xd5;","&#x164;","61"],
["&#xd5;","&#x21a;","61"],
["&#xd5;","&#x104;","41"],
["&#xd5;","&#x102;","41"],
["&#xd5;","&#x100;","41"],
["&#xd5;","&#xdd;","20"],
["&#xd5;","&#xc5;","41"],
["&#xd5;","&#xc4;","41"],
["&#xd5;","&#xc3;","41"],
["&#xd5;","&#xc2;","41"],
["&#xd5;","&#xc1;","41"],
["&#xd5;","&#xc0;","41"],
["&#xd5;","Z","20"],
["&#xd5;","Y","20"],
["&#xd5;","X","41"],
["&#xd5;","W","20"],
["&#xd5;","V","20"],
["&#xd5;","T","61"],
["&#xd5;","A","41"],
["&#xd5;","&#x2e;","82"],
["&#xd5;","&#x2c;","82"],
["&#xd6;","&#x162;","61"],
["&#xd6;","&#x1ef8;","20"],
["&#xd6;","&#x1ef6;","20"],
["&#xd6;","&#x1ef4;","20"],
["&#xd6;","&#x1eb6;","41"],
["&#xd6;","&#x1eb4;","41"],
["&#xd6;","&#x1eb2;","41"],
["&#xd6;","&#x1eb0;","41"],
["&#xd6;","&#x1eae;","41"],
["&#xd6;","&#x1eac;","41"],
["&#xd6;","&#x1eaa;","41"],
["&#xd6;","&#x1ea8;","41"],
["&#xd6;","&#x1ea6;","41"],
["&#xd6;","&#x1ea4;","41"],
["&#xd6;","&#x1ea2;","41"],
["&#xd6;","&#x1ea0;","41"],
["&#xd6;","&#x1e00;","41"],
["&#xd6;","&#x201e;","82"],
["&#xd6;","&#x201a;","82"],
["&#xd6;","&#x1ef2;","20"],
["&#xd6;","&#x1e84;","20"],
["&#xd6;","&#x1e82;","20"],
["&#xd6;","&#x1e80;","20"],
["&#xd6;","&#x405;","20"],
["&#xd6;","&#x1fa;","41"],
["&#xd6;","&#x17d;","20"],
["&#xd6;","&#x17b;","20"],
["&#xd6;","&#x179;","20"],
["&#xd6;","&#x178;","20"],
["&#xd6;","&#x176;","20"],
["&#xd6;","&#x174;","20"],
["&#xd6;","&#x164;","61"],
["&#xd6;","&#x21a;","61"],
["&#xd6;","&#x104;","41"],
["&#xd6;","&#x102;","41"],
["&#xd6;","&#x100;","41"],
["&#xd6;","&#xdd;","20"],
["&#xd6;","&#xc5;","41"],
["&#xd6;","&#xc4;","41"],
["&#xd6;","&#xc3;","41"],
["&#xd6;","&#xc2;","41"],
["&#xd6;","&#xc1;","41"],
["&#xd6;","&#xc0;","41"],
["&#xd6;","Z","20"],
["&#xd6;","Y","20"],
["&#xd6;","X","41"],
["&#xd6;","W","20"],
["&#xd6;","V","20"],
["&#xd6;","T","61"],
["&#xd6;","A","41"],
["&#xd6;","&#x2e;","82"],
["&#xd6;","&#x2c;","82"],
["&#xd8;","&#x162;","61"],
["&#xd8;","&#x1ef8;","20"],
["&#xd8;","&#x1ef6;","20"],
["&#xd8;","&#x1ef4;","20"],
["&#xd8;","&#x1eb6;","41"],
["&#xd8;","&#x1eb4;","41"],
["&#xd8;","&#x1eb2;","41"],
["&#xd8;","&#x1eb0;","41"],
["&#xd8;","&#x1eae;","41"],
["&#xd8;","&#x1eac;","41"],
["&#xd8;","&#x1eaa;","41"],
["&#xd8;","&#x1ea8;","41"],
["&#xd8;","&#x1ea6;","41"],
["&#xd8;","&#x1ea4;","41"],
["&#xd8;","&#x1ea2;","41"],
["&#xd8;","&#x1ea0;","41"],
["&#xd8;","&#x1e00;","41"],
["&#xd8;","&#x201e;","82"],
["&#xd8;","&#x201a;","82"],
["&#xd8;","&#x1ef2;","20"],
["&#xd8;","&#x1e84;","20"],
["&#xd8;","&#x1e82;","20"],
["&#xd8;","&#x1e80;","20"],
["&#xd8;","&#x405;","20"],
["&#xd8;","&#x1fa;","41"],
["&#xd8;","&#x17d;","20"],
["&#xd8;","&#x17b;","20"],
["&#xd8;","&#x179;","20"],
["&#xd8;","&#x178;","20"],
["&#xd8;","&#x176;","20"],
["&#xd8;","&#x174;","20"],
["&#xd8;","&#x164;","61"],
["&#xd8;","&#x21a;","61"],
["&#xd8;","&#x104;","41"],
["&#xd8;","&#x102;","41"],
["&#xd8;","&#x100;","41"],
["&#xd8;","&#xdd;","20"],
["&#xd8;","&#xc5;","41"],
["&#xd8;","&#xc4;","41"],
["&#xd8;","&#xc3;","41"],
["&#xd8;","&#xc2;","41"],
["&#xd8;","&#xc1;","41"],
["&#xd8;","&#xc0;","41"],
["&#xd8;","Z","20"],
["&#xd8;","Y","20"],
["&#xd8;","X","41"],
["&#xd8;","W","20"],
["&#xd8;","V","20"],
["&#xd8;","T","61"],
["&#xd8;","A","41"],
["&#xd8;","&#x2e;","82"],
["&#xd8;","&#x2c;","82"],
["&#xd9;","&#x1eb6;","20"],
["&#xd9;","&#x1eb4;","20"],
["&#xd9;","&#x1eb2;","20"],
["&#xd9;","&#x1eb0;","20"],
["&#xd9;","&#x1eae;","20"],
["&#xd9;","&#x1eac;","20"],
["&#xd9;","&#x1eaa;","20"],
["&#xd9;","&#x1ea8;","20"],
["&#xd9;","&#x1ea6;","20"],
["&#xd9;","&#x1ea4;","20"],
["&#xd9;","&#x1ea2;","20"],
["&#xd9;","&#x1ea0;","20"],
["&#xd9;","&#x1e00;","20"],
["&#xd9;","&#x201e;","41"],
["&#xd9;","&#x201a;","41"],
["&#xd9;","&#x1fa;","20"],
["&#xd9;","&#x104;","20"],
["&#xd9;","&#x102;","20"],
["&#xd9;","&#x100;","20"],
["&#xd9;","&#xc5;","20"],
["&#xd9;","&#xc4;","20"],
["&#xd9;","&#xc3;","20"],
["&#xd9;","&#xc2;","20"],
["&#xd9;","&#xc1;","20"],
["&#xd9;","&#xc0;","20"],
["&#xd9;","A","20"],
["&#xd9;","&#x2e;","41"],
["&#xd9;","&#x2c;","41"],
["&#xda;","&#x1eb6;","20"],
["&#xda;","&#x1eb4;","20"],
["&#xda;","&#x1eb2;","20"],
["&#xda;","&#x1eb0;","20"],
["&#xda;","&#x1eae;","20"],
["&#xda;","&#x1eac;","20"],
["&#xda;","&#x1eaa;","20"],
["&#xda;","&#x1ea8;","20"],
["&#xda;","&#x1ea6;","20"],
["&#xda;","&#x1ea4;","20"],
["&#xda;","&#x1ea2;","20"],
["&#xda;","&#x1ea0;","20"],
["&#xda;","&#x1e00;","20"],
["&#xda;","&#x201e;","41"],
["&#xda;","&#x201a;","41"],
["&#xda;","&#x1fa;","20"],
["&#xda;","&#x104;","20"],
["&#xda;","&#x102;","20"],
["&#xda;","&#x100;","20"],
["&#xda;","&#xc5;","20"],
["&#xda;","&#xc4;","20"],
["&#xda;","&#xc3;","20"],
["&#xda;","&#xc2;","20"],
["&#xda;","&#xc1;","20"],
["&#xda;","&#xc0;","20"],
["&#xda;","A","20"],
["&#xda;","&#x2e;","41"],
["&#xda;","&#x2c;","41"],
["&#xdb;","&#x1eb6;","20"],
["&#xdb;","&#x1eb4;","20"],
["&#xdb;","&#x1eb2;","20"],
["&#xdb;","&#x1eb0;","20"],
["&#xdb;","&#x1eae;","20"],
["&#xdb;","&#x1eac;","20"],
["&#xdb;","&#x1eaa;","20"],
["&#xdb;","&#x1ea8;","20"],
["&#xdb;","&#x1ea6;","20"],
["&#xdb;","&#x1ea4;","20"],
["&#xdb;","&#x1ea2;","20"],
["&#xdb;","&#x1ea0;","20"],
["&#xdb;","&#x1e00;","20"],
["&#xdb;","&#x201e;","41"],
["&#xdb;","&#x201a;","41"],
["&#xdb;","&#x1fa;","20"],
["&#xdb;","&#x104;","20"],
["&#xdb;","&#x102;","20"],
["&#xdb;","&#x100;","20"],
["&#xdb;","&#xc5;","20"],
["&#xdb;","&#xc4;","20"],
["&#xdb;","&#xc3;","20"],
["&#xdb;","&#xc2;","20"],
["&#xdb;","&#xc1;","20"],
["&#xdb;","&#xc0;","20"],
["&#xdb;","A","20"],
["&#xdb;","&#x2e;","41"],
["&#xdb;","&#x2c;","41"],
["&#xdc;","&#x1eb6;","20"],
["&#xdc;","&#x1eb4;","20"],
["&#xdc;","&#x1eb2;","20"],
["&#xdc;","&#x1eb0;","20"],
["&#xdc;","&#x1eae;","20"],
["&#xdc;","&#x1eac;","20"],
["&#xdc;","&#x1eaa;","20"],
["&#xdc;","&#x1ea8;","20"],
["&#xdc;","&#x1ea6;","20"],
["&#xdc;","&#x1ea4;","20"],
["&#xdc;","&#x1ea2;","20"],
["&#xdc;","&#x1ea0;","20"],
["&#xdc;","&#x1e00;","20"],
["&#xdc;","&#x201e;","41"],
["&#xdc;","&#x201a;","41"],
["&#xdc;","&#x1fa;","20"],
["&#xdc;","&#x104;","20"],
["&#xdc;","&#x102;","20"],
["&#xdc;","&#x100;","20"],
["&#xdc;","&#xc5;","20"],
["&#xdc;","&#xc4;","20"],
["&#xdc;","&#xc3;","20"],
["&#xdc;","&#xc2;","20"],
["&#xdc;","&#xc1;","20"],
["&#xdc;","&#xc0;","20"],
["&#xdc;","A","20"],
["&#xdc;","&#x2e;","41"],
["&#xdc;","&#x2c;","41"],
["&#xdd;","&#x1ef1;","61"],
["&#xdd;","&#x1eef;","61"],
["&#xdd;","&#x1eed;","61"],
["&#xdd;","&#x1eeb;","61"],
["&#xdd;","&#x1ee9;","61"],
["&#xdd;","&#x1ee7;","61"],
["&#xdd;","&#x1ee5;","61"],
["&#xdd;","&#x1ee3;","102"],
["&#xdd;","&#x1ee2;","41"],
["&#xdd;","&#x1ee1;","102"],
["&#xdd;","&#x1ee0;","41"],
["&#xdd;","&#x1edf;","102"],
["&#xdd;","&#x1ede;","41"],
["&#xdd;","&#x1edd;","102"],
["&#xdd;","&#x1edc;","41"],
["&#xdd;","&#x1edb;","102"],
["&#xdd;","&#x1eda;","41"],
["&#xdd;","&#x1ed9;","102"],
["&#xdd;","&#x1ed8;","41"],
["&#xdd;","&#x1ed7;","102"],
["&#xdd;","&#x1ed6;","41"],
["&#xdd;","&#x1ed5;","102"],
["&#xdd;","&#x1ed4;","41"],
["&#xdd;","&#x1ed2;","41"],
["&#xdd;","&#x1ed1;","102"],
["&#xdd;","&#x1ed0;","41"],
["&#xdd;","&#x1ecf;","102"],
["&#xdd;","&#x1ece;","41"],
["&#xdd;","&#x1ecd;","102"],
["&#xdd;","&#x1ecc;","41"],
["&#xdd;","&#x1ec7;","102"],
["&#xdd;","&#x1ec5;","102"],
["&#xdd;","&#x1ec3;","102"],
["&#xdd;","&#x1ebf;","102"],
["&#xdd;","&#x1ebd;","102"],
["&#xdd;","&#x1ebb;","102"],
["&#xdd;","&#x1eb9;","102"],
["&#xdd;","&#x1eb7;","102"],
["&#xdd;","&#x1eb6;","123"],
["&#xdd;","&#x1eb5;","102"],
["&#xdd;","&#x1eb4;","123"],
["&#xdd;","&#x1eb3;","102"],
["&#xdd;","&#x1eb2;","123"],
["&#xdd;","&#x1eb1;","102"],
["&#xdd;","&#x1eb0;","123"],
["&#xdd;","&#x1eaf;","102"],
["&#xdd;","&#x1eae;","123"],
["&#xdd;","&#x1ead;","102"],
["&#xdd;","&#x1eac;","123"],
["&#xdd;","&#x1eab;","102"],
["&#xdd;","&#x1eaa;","123"],
["&#xdd;","&#x1ea9;","102"],
["&#xdd;","&#x1ea8;","123"],
["&#xdd;","&#x1ea6;","123"],
["&#xdd;","&#x1ea5;","102"],
["&#xdd;","&#x1ea4;","123"],
["&#xdd;","&#x1ea3;","102"],
["&#xdd;","&#x1ea2;","123"],
["&#xdd;","&#x1ea1;","102"],
["&#xdd;","&#x1ea0;","123"],
["&#xdd;","&#x1b0;","61"],
["&#xdd;","&#x1a1;","102"],
["&#xdd;","&#x1a0;","41"],
["&#xdd;","&#x1e01;","102"],
["&#xdd;","&#x1e00;","123"],
["&#xdd;","&#x1e3f;","61"],
["&#xdd;","&#x201e;","123"],
["&#xdd;","&#x201a;","123"],
["&#xdd;","&#x219;","82"],
["&#xdd;","&#x1ff;","102"],
["&#xdd;","&#x1fe;","41"],
["&#xdd;","&#x1fd;","102"],
["&#xdd;","&#x1fb;","102"],
["&#xdd;","&#x1fa;","123"],
["&#xdd;","&#x17e;","41"],
["&#xdd;","&#x17c;","41"],
["&#xdd;","&#x17a;","41"],
["&#xdd;","&#x173;","61"],
["&#xdd;","&#x171;","61"],
["&#xdd;","&#x16f;","61"],
["&#xdd;","&#x16d;","61"],
["&#xdd;","&#x16b;","61"],
["&#xdd;","&#x169;","61"],
["&#xdd;","&#x15f;","82"],
["&#xdd;","&#x15b;","82"],
["&#xdd;","&#x157;","61"],
["&#xdd;","&#x155;","61"],
["&#xdd;","&#x153;","102"],
["&#xdd;","&#x152;","41"],
["&#xdd;","&#x151;","102"],
["&#xdd;","&#x150;","41"],
["&#xdd;","&#x14f;","102"],
["&#xdd;","&#x14e;","41"],
["&#xdd;","&#x14d;","102"],
["&#xdd;","&#x14c;","41"],
["&#xdd;","&#x14b;","61"],
["&#xdd;","&#x146;","61"],
["&#xdd;","&#x144;","61"],
["&#xdd;","&#x138;","61"],
["&#xdd;","&#x123;","41"],
["&#xdd;","&#x122;","41"],
["&#xdd;","&#x121;","41"],
["&#xdd;","&#x120;","41"],
["&#xdd;","&#x11f;","41"],
["&#xdd;","&#x11e;","41"],
["&#xdd;","&#x11d;","41"],
["&#xdd;","&#x11c;","41"],
["&#xdd;","&#x11b;","102"],
["&#xdd;","&#x119;","102"],
["&#xdd;","&#x117;","102"],
["&#xdd;","&#x115;","102"],
["&#xdd;","&#x113;","102"],
["&#xdd;","&#x111;","102"],
["&#xdd;","&#x10f;","102"],
["&#xdd;","&#x10d;","102"],
["&#xdd;","&#x10c;","41"],
["&#xdd;","&#x10b;","102"],
["&#xdd;","&#x10a;","41"],
["&#xdd;","&#x109;","102"],
["&#xdd;","&#x108;","41"],
["&#xdd;","&#x107;","102"],
["&#xdd;","&#x106;","41"],
["&#xdd;","&#x105;","102"],
["&#xdd;","&#x104;","123"],
["&#xdd;","&#x103;","102"],
["&#xdd;","&#x102;","123"],
["&#xdd;","&#x101;","102"],
["&#xdd;","&#x100;","123"],
["&#xdd;","&#xfc;","61"],
["&#xdd;","&#xfb;","61"],
["&#xdd;","&#xfa;","61"],
["&#xdd;","&#xf9;","61"],
["&#xdd;","&#xf8;","102"],
["&#xdd;","&#xf6;","102"],
["&#xdd;","&#xf5;","102"],
["&#xdd;","&#xf4;","102"],
["&#xdd;","&#xf3;","102"],
["&#xdd;","&#xf2;","102"],
["&#xdd;","&#xeb;","102"],
["&#xdd;","&#xea;","102"],
["&#xdd;","&#xe9;","102"],
["&#xdd;","&#xe8;","102"],
["&#xdd;","&#xe7;","102"],
["&#xdd;","&#xe6;","102"],
["&#xdd;","&#xe5;","102"],
["&#xdd;","&#xe4;","102"],
["&#xdd;","&#xe3;","102"],
["&#xdd;","&#xe2;","102"],
["&#xdd;","&#xe1;","102"],
["&#xdd;","&#xe0;","102"],
["&#xdd;","&#xd8;","41"],
["&#xdd;","&#xd6;","41"],
["&#xdd;","&#xd5;","41"],
["&#xdd;","&#xd4;","41"],
["&#xdd;","&#xd3;","41"],
["&#xdd;","&#xd2;","41"],
["&#xdd;","&#xc7;","41"],
["&#xdd;","&#xc5;","123"],
["&#xdd;","&#xc4;","123"],
["&#xdd;","&#xc3;","123"],
["&#xdd;","&#xc2;","123"],
["&#xdd;","&#xc1;","123"],
["&#xdd;","&#xc0;","123"],
["&#xdd;","z","41"],
["&#xdd;","u","61"],
["&#xdd;","s","82"],
["&#xdd;","r","61"],
["&#xdd;","q","102"],
["&#xdd;","p","61"],
["&#xdd;","o","102"],
["&#xdd;","n","61"],
["&#xdd;","m","61"],
["&#xdd;","g","41"],
["&#xdd;","e","102"],
["&#xdd;","d","102"],
["&#xdd;","c","102"],
["&#xdd;","a","102"],
["&#xdd;","Q","41"],
["&#xdd;","O","41"],
["&#xdd;","G","41"],
["&#xdd;","C","41"],
["&#xdd;","A","123"],
["&#xdd;","&#x3f;","-41"],
["&#xdd;","&#x2e;","123"],
["&#xdd;","&#x2c;","123"],
["&#xde;","&#x1eb6;","102"],
["&#xde;","&#x1eb4;","102"],
["&#xde;","&#x1eb2;","102"],
["&#xde;","&#x1eb0;","102"],
["&#xde;","&#x1eae;","102"],
["&#xde;","&#x1eac;","102"],
["&#xde;","&#x1eaa;","102"],
["&#xde;","&#x1ea8;","102"],
["&#xde;","&#x1ea6;","102"],
["&#xde;","&#x1ea4;","102"],
["&#xde;","&#x1ea2;","102"],
["&#xde;","&#x1ea0;","102"],
["&#xde;","&#x1e00;","102"],
["&#xde;","&#x201e;","266"],
["&#xde;","&#x201a;","266"],
["&#xde;","&#x1fa;","102"],
["&#xde;","&#x17d;","20"],
["&#xde;","&#x17b;","20"],
["&#xde;","&#x179;","20"],
["&#xde;","&#x104;","102"],
["&#xde;","&#x102;","102"],
["&#xde;","&#x100;","102"],
["&#xde;","&#xc5;","102"],
["&#xde;","&#xc4;","102"],
["&#xde;","&#xc3;","102"],
["&#xde;","&#xc2;","102"],
["&#xde;","&#xc1;","102"],
["&#xde;","&#xc0;","102"],
["&#xde;","Z","20"],
["&#xde;","X","41"],
["&#xde;","A","102"],
["&#xde;","&#x2e;","266"],
["&#xde;","&#x2c;","266"],
["&#xe0;","&#x201d;","20"],
["&#xe0;","&#x2019;","20"],
["&#xe0;","&#x27;","20"],
["&#xe0;","&#x22;","20"],
["&#xe1;","&#x201d;","20"],
["&#xe1;","&#x2019;","20"],
["&#xe1;","&#x27;","20"],
["&#xe1;","&#x22;","20"],
["&#xe2;","&#x201d;","20"],
["&#xe2;","&#x2019;","20"],
["&#xe2;","&#x27;","20"],
["&#xe2;","&#x22;","20"],
["&#xe3;","&#x201d;","20"],
["&#xe3;","&#x2019;","20"],
["&#xe3;","&#x27;","20"],
["&#xe3;","&#x22;","20"],
["&#xe4;","&#x201d;","20"],
["&#xe4;","&#x2019;","20"],
["&#xe4;","&#x27;","20"],
["&#xe4;","&#x22;","20"],
["&#xe5;","&#x201d;","20"],
["&#xe5;","&#x2019;","20"],
["&#xe5;","&#x27;","20"],
["&#xe5;","&#x22;","20"],
["&#xe8;","&#x1ef5;","41"],
["&#xe8;","&#x201d;","20"],
["&#xe8;","&#x2019;","20"],
["&#xe8;","&#x1e83;","41"],
["&#xe8;","&#x1e81;","41"],
["&#xe8;","&#x17e;","20"],
["&#xe8;","&#x17c;","20"],
["&#xe8;","&#x17a;","20"],
["&#xe8;","&#x175;","41"],
["&#xe8;","&#xfd;","41"],
["&#xe8;","z","20"],
["&#xe8;","y","41"],
["&#xe8;","x","41"],
["&#xe8;","w","41"],
["&#xe8;","v","41"],
["&#xe8;","&#x27;","20"],
["&#xe8;","&#x22;","20"],
["&#xe9;","&#x1ef5;","41"],
["&#xe9;","&#x201d;","20"],
["&#xe9;","&#x2019;","20"],
["&#xe9;","&#x1e83;","41"],
["&#xe9;","&#x1e81;","41"],
["&#xe9;","&#x17e;","20"],
["&#xe9;","&#x17c;","20"],
["&#xe9;","&#x17a;","20"],
["&#xe9;","&#x175;","41"],
["&#xe9;","&#xfd;","41"],
["&#xe9;","z","20"],
["&#xe9;","y","41"],
["&#xe9;","x","41"],
["&#xe9;","w","41"],
["&#xe9;","v","41"],
["&#xe9;","&#x27;","20"],
["&#xe9;","&#x22;","20"],
["&#xea;","&#x1ef5;","41"],
["&#xea;","&#x201d;","20"],
["&#xea;","&#x2019;","20"],
["&#xea;","&#x1e83;","41"],
["&#xea;","&#x1e81;","41"],
["&#xea;","&#x17e;","20"],
["&#xea;","&#x17c;","20"],
["&#xea;","&#x17a;","20"],
["&#xea;","&#x175;","41"],
["&#xea;","&#xfd;","41"],
["&#xea;","z","20"],
["&#xea;","y","41"],
["&#xea;","x","41"],
["&#xea;","w","41"],
["&#xea;","v","41"],
["&#xea;","&#x27;","20"],
["&#xea;","&#x22;","20"],
["&#xeb;","&#x1ef5;","41"],
["&#xeb;","&#x201d;","20"],
["&#xeb;","&#x2019;","20"],
["&#xeb;","&#x1e83;","41"],
["&#xeb;","&#x1e81;","41"],
["&#xeb;","&#x17e;","20"],
["&#xeb;","&#x17c;","20"],
["&#xeb;","&#x17a;","20"],
["&#xeb;","&#x175;","41"],
["&#xeb;","&#xfd;","41"],
["&#xeb;","z","20"],
["&#xeb;","y","41"],
["&#xeb;","x","41"],
["&#xeb;","w","41"],
["&#xeb;","v","41"],
["&#xeb;","&#x27;","20"],
["&#xeb;","&#x22;","20"],
["&#xf0;","&#x1ef5;","41"],
["&#xf0;","&#x201d;","20"],
["&#xf0;","&#x2019;","20"],
["&#xf0;","&#x1e83;","41"],
["&#xf0;","&#x1e81;","41"],
["&#xf0;","&#x17e;","20"],
["&#xf0;","&#x17c;","20"],
["&#xf0;","&#x17a;","20"],
["&#xf0;","&#x175;","41"],
["&#xf0;","&#xfd;","41"],
["&#xf0;","z","20"],
["&#xf0;","y","41"],
["&#xf0;","x","41"],
["&#xf0;","w","41"],
["&#xf0;","v","41"],
["&#xf0;","&#x27;","20"],
["&#xf0;","&#x22;","20"],
["&#xf2;","&#x1ef5;","41"],
["&#xf2;","&#x201d;","20"],
["&#xf2;","&#x2019;","20"],
["&#xf2;","&#x1e83;","41"],
["&#xf2;","&#x1e81;","41"],
["&#xf2;","&#x17e;","20"],
["&#xf2;","&#x17c;","20"],
["&#xf2;","&#x17a;","20"],
["&#xf2;","&#x175;","41"],
["&#xf2;","&#xfd;","41"],
["&#xf2;","z","20"],
["&#xf2;","y","41"],
["&#xf2;","x","41"],
["&#xf2;","w","41"],
["&#xf2;","v","41"],
["&#xf2;","&#x27;","20"],
["&#xf2;","&#x22;","20"],
["&#xf3;","&#x1ef5;","41"],
["&#xf3;","&#x201d;","20"],
["&#xf3;","&#x2019;","20"],
["&#xf3;","&#x1e83;","41"],
["&#xf3;","&#x1e81;","41"],
["&#xf3;","&#x17e;","20"],
["&#xf3;","&#x17c;","20"],
["&#xf3;","&#x17a;","20"],
["&#xf3;","&#x175;","41"],
["&#xf3;","&#xfd;","41"],
["&#xf3;","z","20"],
["&#xf3;","y","41"],
["&#xf3;","x","41"],
["&#xf3;","w","41"],
["&#xf3;","v","41"],
["&#xf3;","&#x27;","20"],
["&#xf3;","&#x22;","20"],
["&#xf4;","&#x1ef5;","41"],
["&#xf4;","&#x201d;","20"],
["&#xf4;","&#x2019;","20"],
["&#xf4;","&#x1e83;","41"],
["&#xf4;","&#x1e81;","41"],
["&#xf4;","&#x17e;","20"],
["&#xf4;","&#x17c;","20"],
["&#xf4;","&#x17a;","20"],
["&#xf4;","&#x175;","41"],
["&#xf4;","&#xfd;","41"],
["&#xf4;","z","20"],
["&#xf4;","y","41"],
["&#xf4;","x","41"],
["&#xf4;","w","41"],
["&#xf4;","v","41"],
["&#xf4;","&#x27;","20"],
["&#xf4;","&#x22;","20"],
["&#xf6;","&#x201d;","41"],
["&#xf6;","&#x2019;","41"],
["&#xf6;","&#x27;","41"],
["&#xf6;","&#x22;","41"],
["&#xf8;","&#x1ef5;","41"],
["&#xf8;","&#x201d;","20"],
["&#xf8;","&#x2019;","20"],
["&#xf8;","&#x1e83;","41"],
["&#xf8;","&#x1e81;","41"],
["&#xf8;","&#x17e;","20"],
["&#xf8;","&#x17c;","20"],
["&#xf8;","&#x17a;","20"],
["&#xf8;","&#x175;","41"],
["&#xf8;","&#xfd;","41"],
["&#xf8;","z","20"],
["&#xf8;","y","41"],
["&#xf8;","x","41"],
["&#xf8;","w","41"],
["&#xf8;","v","41"],
["&#xf8;","&#x27;","20"],
["&#xf8;","&#x22;","20"],
["&#xfd;","&#x201e;","82"],
["&#xfd;","&#x201d;","-82"],
["&#xfd;","&#x201a;","82"],
["&#xfd;","&#x2019;","-82"],
["&#xfd;","&#x3f;","-41"],
["&#xfd;","&#x2e;","82"],
["&#xfd;","&#x2c;","82"],
["&#xfd;","&#x27;","-82"],
["&#xfd;","&#x22;","-82"],
["&#xfe;","&#x1ef5;","41"],
["&#xfe;","&#x201d;","20"],
["&#xfe;","&#x2019;","20"],
["&#xfe;","&#x1e83;","41"],
["&#xfe;","&#x1e81;","41"],
["&#xfe;","&#x17e;","20"],
["&#xfe;","&#x17c;","20"],
["&#xfe;","&#x17a;","20"],
["&#xfe;","&#x175;","41"],
["&#xfe;","&#xfd;","41"],
["&#xfe;","z","20"],
["&#xfe;","y","41"],
["&#xfe;","x","41"],
["&#xfe;","w","41"],
["&#xfe;","v","41"],
["&#xfe;","&#x27;","20"],
["&#xfe;","&#x22;","20"],
["&#xff;","&#x201e;","82"],
["&#xff;","&#x201d;","-82"],
["&#xff;","&#x201a;","82"],
["&#xff;","&#x2019;","-82"],
["&#xff;","&#x3f;","-41"],
["&#xff;","&#x2e;","82"],
["&#xff;","&#x2c;","82"],
["&#xff;","&#x27;","-82"],
["&#xff;","&#x22;","-82"],
["&#x100;","&#x162;","143"],
["&#x100;","&#x1ef8;","123"],
["&#x100;","&#x1ef6;","123"],
["&#x100;","&#x1ef4;","123"],
["&#x100;","&#x1ee2;","41"],
["&#x100;","&#x1ee0;","41"],
["&#x100;","&#x1ede;","41"],
["&#x100;","&#x1edc;","41"],
["&#x100;","&#x1eda;","41"],
["&#x100;","&#x1ed8;","41"],
["&#x100;","&#x1ed6;","41"],
["&#x100;","&#x1ed4;","41"],
["&#x100;","&#x1ed2;","41"],
["&#x100;","&#x1ed0;","41"],
["&#x100;","&#x1ece;","41"],
["&#x100;","&#x1ecc;","41"],
["&#x100;","&#x1a0;","41"],
["&#x100;","&#x201d;","143"],
["&#x100;","&#x2019;","143"],
["&#x100;","&#x1ef2;","123"],
["&#x100;","&#x1e84;","82"],
["&#x100;","&#x1e82;","82"],
["&#x100;","&#x1e80;","82"],
["&#x100;","&#x1fe;","41"],
["&#x100;","&#x178;","123"],
["&#x100;","&#x176;","123"],
["&#x100;","&#x174;","82"],
["&#x100;","&#x164;","143"],
["&#x100;","&#x21a;","143"],
["&#x100;","&#x152;","41"],
["&#x100;","&#x150;","41"],
["&#x100;","&#x14e;","41"],
["&#x100;","&#x14c;","41"],
["&#x100;","&#x122;","41"],
["&#x100;","&#x120;","41"],
["&#x100;","&#x11e;","41"],
["&#x100;","&#x11c;","41"],
["&#x100;","&#x10c;","41"],
["&#x100;","&#x10a;","41"],
["&#x100;","&#x108;","41"],
["&#x100;","&#x106;","41"],
["&#x100;","&#xdd;","123"],
["&#x100;","&#xd8;","41"],
["&#x100;","&#xd6;","41"],
["&#x100;","&#xd5;","41"],
["&#x100;","&#xd4;","41"],
["&#x100;","&#xd3;","41"],
["&#x100;","&#xd2;","41"],
["&#x100;","&#xc7;","41"],
["&#x100;","Y","123"],
["&#x100;","W","82"],
["&#x100;","V","82"],
["&#x100;","T","143"],
["&#x100;","Q","41"],
["&#x100;","O","41"],
["&#x100;","J","-266"],
["&#x100;","G","41"],
["&#x100;","C","41"],
["&#x100;","&#x27;","143"],
["&#x100;","&#x22;","143"],
["&#x101;","&#x201d;","20"],
["&#x101;","&#x2019;","20"],
["&#x101;","&#x27;","20"],
["&#x101;","&#x22;","20"],
["&#x102;","&#x162;","143"],
["&#x102;","&#x1ef8;","123"],
["&#x102;","&#x1ef6;","123"],
["&#x102;","&#x1ef4;","123"],
["&#x102;","&#x1ee2;","41"],
["&#x102;","&#x1ee0;","41"],
["&#x102;","&#x1ede;","41"],
["&#x102;","&#x1edc;","41"],
["&#x102;","&#x1eda;","41"],
["&#x102;","&#x1ed8;","41"],
["&#x102;","&#x1ed6;","41"],
["&#x102;","&#x1ed4;","41"],
["&#x102;","&#x1ed2;","41"],
["&#x102;","&#x1ed0;","41"],
["&#x102;","&#x1ece;","41"],
["&#x102;","&#x1ecc;","41"],
["&#x102;","&#x1a0;","41"],
["&#x102;","&#x201d;","143"],
["&#x102;","&#x2019;","143"],
["&#x102;","&#x1ef2;","123"],
["&#x102;","&#x1e84;","82"],
["&#x102;","&#x1e82;","82"],
["&#x102;","&#x1e80;","82"],
["&#x102;","&#x1fe;","41"],
["&#x102;","&#x178;","123"],
["&#x102;","&#x176;","123"],
["&#x102;","&#x174;","82"],
["&#x102;","&#x164;","143"],
["&#x102;","&#x21a;","143"],
["&#x102;","&#x152;","41"],
["&#x102;","&#x150;","41"],
["&#x102;","&#x14e;","41"],
["&#x102;","&#x14c;","41"],
["&#x102;","&#x122;","41"],
["&#x102;","&#x120;","41"],
["&#x102;","&#x11e;","41"],
["&#x102;","&#x11c;","41"],
["&#x102;","&#x10c;","41"],
["&#x102;","&#x10a;","41"],
["&#x102;","&#x108;","41"],
["&#x102;","&#x106;","41"],
["&#x102;","&#xdd;","123"],
["&#x102;","&#xd8;","41"],
["&#x102;","&#xd6;","41"],
["&#x102;","&#xd5;","41"],
["&#x102;","&#xd4;","41"],
["&#x102;","&#xd3;","41"],
["&#x102;","&#xd2;","41"],
["&#x102;","&#xc7;","41"],
["&#x102;","Y","123"],
["&#x102;","W","82"],
["&#x102;","V","82"],
["&#x102;","T","143"],
["&#x102;","Q","41"],
["&#x102;","O","41"],
["&#x102;","J","-266"],
["&#x102;","G","41"],
["&#x102;","C","41"],
["&#x102;","&#x27;","143"],
["&#x102;","&#x22;","143"],
["&#x103;","&#x201d;","20"],
["&#x103;","&#x2019;","20"],
["&#x103;","&#x27;","20"],
["&#x103;","&#x22;","20"],
["&#x104;","&#x162;","143"],
["&#x104;","&#x1ef8;","123"],
["&#x104;","&#x1ef6;","123"],
["&#x104;","&#x1ef4;","123"],
["&#x104;","&#x1ee2;","41"],
["&#x104;","&#x1ee0;","41"],
["&#x104;","&#x1ede;","41"],
["&#x104;","&#x1edc;","41"],
["&#x104;","&#x1eda;","41"],
["&#x104;","&#x1ed8;","41"],
["&#x104;","&#x1ed6;","41"],
["&#x104;","&#x1ed4;","41"],
["&#x104;","&#x1ed2;","41"],
["&#x104;","&#x1ed0;","41"],
["&#x104;","&#x1ece;","41"],
["&#x104;","&#x1ecc;","41"],
["&#x104;","&#x1a0;","41"],
["&#x104;","&#x201d;","143"],
["&#x104;","&#x2019;","143"],
["&#x104;","&#x1ef2;","123"],
["&#x104;","&#x1e84;","82"],
["&#x104;","&#x1e82;","82"],
["&#x104;","&#x1e80;","82"],
["&#x104;","&#x1fe;","41"],
["&#x104;","&#x178;","123"],
["&#x104;","&#x176;","123"],
["&#x104;","&#x174;","82"],
["&#x104;","&#x164;","143"],
["&#x104;","&#x21a;","143"],
["&#x104;","&#x152;","41"],
["&#x104;","&#x150;","41"],
["&#x104;","&#x14e;","41"],
["&#x104;","&#x14c;","41"],
["&#x104;","&#x122;","41"],
["&#x104;","&#x120;","41"],
["&#x104;","&#x11e;","41"],
["&#x104;","&#x11c;","41"],
["&#x104;","&#x10c;","41"],
["&#x104;","&#x10a;","41"],
["&#x104;","&#x108;","41"],
["&#x104;","&#x106;","41"],
["&#x104;","&#xdd;","123"],
["&#x104;","&#xd8;","41"],
["&#x104;","&#xd6;","41"],
["&#x104;","&#xd5;","41"],
["&#x104;","&#xd4;","41"],
["&#x104;","&#xd3;","41"],
["&#x104;","&#xd2;","41"],
["&#x104;","&#xc7;","41"],
["&#x104;","Y","123"],
["&#x104;","W","82"],
["&#x104;","V","82"],
["&#x104;","T","143"],
["&#x104;","Q","41"],
["&#x104;","O","41"],
["&#x104;","J","-266"],
["&#x104;","G","41"],
["&#x104;","C","41"],
["&#x104;","&#x27;","143"],
["&#x104;","&#x22;","143"],
["&#x105;","&#x201d;","20"],
["&#x105;","&#x2019;","20"],
["&#x105;","&#x27;","20"],
["&#x105;","&#x22;","20"],
["&#x106;","&#x1ee2;","41"],
["&#x106;","&#x1ee0;","41"],
["&#x106;","&#x1ede;","41"],
["&#x106;","&#x1edc;","41"],
["&#x106;","&#x1eda;","41"],
["&#x106;","&#x1ed8;","41"],
["&#x106;","&#x1ed6;","41"],
["&#x106;","&#x1ed4;","41"],
["&#x106;","&#x1ed2;","41"],
["&#x106;","&#x1ed0;","41"],
["&#x106;","&#x1ece;","41"],
["&#x106;","&#x1ecc;","41"],
["&#x106;","&#x1a0;","41"],
["&#x106;","&#x1fe;","41"],
["&#x106;","&#x152;","41"],
["&#x106;","&#x150;","41"],
["&#x106;","&#x14e;","41"],
["&#x106;","&#x14c;","41"],
["&#x106;","&#x122;","41"],
["&#x106;","&#x120;","41"],
["&#x106;","&#x11e;","41"],
["&#x106;","&#x11c;","41"],
["&#x106;","&#x10c;","41"],
["&#x106;","&#x10a;","41"],
["&#x106;","&#x108;","41"],
["&#x106;","&#x106;","41"],
["&#x106;","&#xd8;","41"],
["&#x106;","&#xd6;","41"],
["&#x106;","&#xd5;","41"],
["&#x106;","&#xd4;","41"],
["&#x106;","&#xd3;","41"],
["&#x106;","&#xd2;","41"],
["&#x106;","&#xc7;","41"],
["&#x106;","Q","41"],
["&#x106;","O","41"],
["&#x106;","G","41"],
["&#x106;","C","41"],
["&#x108;","&#x1ee2;","41"],
["&#x108;","&#x1ee0;","41"],
["&#x108;","&#x1ede;","41"],
["&#x108;","&#x1edc;","41"],
["&#x108;","&#x1eda;","41"],
["&#x108;","&#x1ed8;","41"],
["&#x108;","&#x1ed6;","41"],
["&#x108;","&#x1ed4;","41"],
["&#x108;","&#x1ed2;","41"],
["&#x108;","&#x1ed0;","41"],
["&#x108;","&#x1ece;","41"],
["&#x108;","&#x1ecc;","41"],
["&#x108;","&#x1a0;","41"],
["&#x108;","&#x1fe;","41"],
["&#x108;","&#x152;","41"],
["&#x108;","&#x150;","41"],
["&#x108;","&#x14e;","41"],
["&#x108;","&#x14c;","41"],
["&#x108;","&#x122;","41"],
["&#x108;","&#x120;","41"],
["&#x108;","&#x11e;","41"],
["&#x108;","&#x11c;","41"],
["&#x108;","&#x10c;","41"],
["&#x108;","&#x10a;","41"],
["&#x108;","&#x108;","41"],
["&#x108;","&#x106;","41"],
["&#x108;","&#xd8;","41"],
["&#x108;","&#xd6;","41"],
["&#x108;","&#xd5;","41"],
["&#x108;","&#xd4;","41"],
["&#x108;","&#xd3;","41"],
["&#x108;","&#xd2;","41"],
["&#x108;","&#xc7;","41"],
["&#x108;","Q","41"],
["&#x108;","O","41"],
["&#x108;","G","41"],
["&#x108;","C","41"],
["&#x10a;","&#x1ee2;","41"],
["&#x10a;","&#x1ee0;","41"],
["&#x10a;","&#x1ede;","41"],
["&#x10a;","&#x1edc;","41"],
["&#x10a;","&#x1eda;","41"],
["&#x10a;","&#x1ed8;","41"],
["&#x10a;","&#x1ed6;","41"],
["&#x10a;","&#x1ed4;","41"],
["&#x10a;","&#x1ed2;","41"],
["&#x10a;","&#x1ed0;","41"],
["&#x10a;","&#x1ece;","41"],
["&#x10a;","&#x1ecc;","41"],
["&#x10a;","&#x1a0;","41"],
["&#x10a;","&#x1fe;","41"],
["&#x10a;","&#x152;","41"],
["&#x10a;","&#x150;","41"],
["&#x10a;","&#x14e;","41"],
["&#x10a;","&#x14c;","41"],
["&#x10a;","&#x122;","41"],
["&#x10a;","&#x120;","41"],
["&#x10a;","&#x11e;","41"],
["&#x10a;","&#x11c;","41"],
["&#x10a;","&#x10c;","41"],
["&#x10a;","&#x10a;","41"],
["&#x10a;","&#x108;","41"],
["&#x10a;","&#x106;","41"],
["&#x10a;","&#xd8;","41"],
["&#x10a;","&#xd6;","41"],
["&#x10a;","&#xd5;","41"],
["&#x10a;","&#xd4;","41"],
["&#x10a;","&#xd3;","41"],
["&#x10a;","&#xd2;","41"],
["&#x10a;","&#xc7;","41"],
["&#x10a;","Q","41"],
["&#x10a;","O","41"],
["&#x10a;","G","41"],
["&#x10a;","C","41"],
["&#x10c;","&#x1ee2;","41"],
["&#x10c;","&#x1ee0;","41"],
["&#x10c;","&#x1ede;","41"],
["&#x10c;","&#x1edc;","41"],
["&#x10c;","&#x1eda;","41"],
["&#x10c;","&#x1ed8;","41"],
["&#x10c;","&#x1ed6;","41"],
["&#x10c;","&#x1ed4;","41"],
["&#x10c;","&#x1ed2;","41"],
["&#x10c;","&#x1ed0;","41"],
["&#x10c;","&#x1ece;","41"],
["&#x10c;","&#x1ecc;","41"],
["&#x10c;","&#x1a0;","41"],
["&#x10c;","&#x1fe;","41"],
["&#x10c;","&#x152;","41"],
["&#x10c;","&#x150;","41"],
["&#x10c;","&#x14e;","41"],
["&#x10c;","&#x14c;","41"],
["&#x10c;","&#x122;","41"],
["&#x10c;","&#x120;","41"],
["&#x10c;","&#x11e;","41"],
["&#x10c;","&#x11c;","41"],
["&#x10c;","&#x10c;","41"],
["&#x10c;","&#x10a;","41"],
["&#x10c;","&#x108;","41"],
["&#x10c;","&#x106;","41"],
["&#x10c;","&#xd8;","41"],
["&#x10c;","&#xd6;","41"],
["&#x10c;","&#xd5;","41"],
["&#x10c;","&#xd4;","41"],
["&#x10c;","&#xd3;","41"],
["&#x10c;","&#xd2;","41"],
["&#x10c;","&#xc7;","41"],
["&#x10c;","Q","41"],
["&#x10c;","O","41"],
["&#x10c;","G","41"],
["&#x10c;","C","41"],
["&#x10e;","&#x162;","61"],
["&#x10e;","&#x1ef8;","20"],
["&#x10e;","&#x1ef6;","20"],
["&#x10e;","&#x1ef4;","20"],
["&#x10e;","&#x1eb6;","41"],
["&#x10e;","&#x1eb4;","41"],
["&#x10e;","&#x1eb2;","41"],
["&#x10e;","&#x1eb0;","41"],
["&#x10e;","&#x1eae;","41"],
["&#x10e;","&#x1eac;","41"],
["&#x10e;","&#x1eaa;","41"],
["&#x10e;","&#x1ea8;","41"],
["&#x10e;","&#x1ea6;","41"],
["&#x10e;","&#x1ea4;","41"],
["&#x10e;","&#x1ea2;","41"],
["&#x10e;","&#x1ea0;","41"],
["&#x10e;","&#x1e00;","41"],
["&#x10e;","&#x201e;","82"],
["&#x10e;","&#x201a;","82"],
["&#x10e;","&#x1ef2;","20"],
["&#x10e;","&#x1e84;","20"],
["&#x10e;","&#x1e82;","20"],
["&#x10e;","&#x1e80;","20"],
["&#x10e;","&#x405;","20"],
["&#x10e;","&#x1fa;","41"],
["&#x10e;","&#x17d;","20"],
["&#x10e;","&#x17b;","20"],
["&#x10e;","&#x179;","20"],
["&#x10e;","&#x178;","20"],
["&#x10e;","&#x176;","20"],
["&#x10e;","&#x174;","20"],
["&#x10e;","&#x164;","61"],
["&#x10e;","&#x21a;","61"],
["&#x10e;","&#x104;","41"],
["&#x10e;","&#x102;","41"],
["&#x10e;","&#x100;","41"],
["&#x10e;","&#xdd;","20"],
["&#x10e;","&#xc5;","41"],
["&#x10e;","&#xc4;","41"],
["&#x10e;","&#xc3;","41"],
["&#x10e;","&#xc2;","41"],
["&#x10e;","&#xc1;","41"],
["&#x10e;","&#xc0;","41"],
["&#x10e;","Z","20"],
["&#x10e;","Y","20"],
["&#x10e;","X","41"],
["&#x10e;","W","20"],
["&#x10e;","V","20"],
["&#x10e;","T","61"],
["&#x10e;","A","41"],
["&#x10e;","&#x2e;","82"],
["&#x10e;","&#x2c;","82"],
["&#x10f;","&#x201d;","-82"],
["&#x10f;","&#x2019;","-82"],
["&#x10f;","&#x127;","-123"],
["&#x10f;","&#x125;","-61"],
["&#x10f;","&#x7d;","-143"],
["&#x10f;","l","-61"],
["&#x10f;","k","-61"],
["&#x10f;","h","-61"],
["&#x10f;","b","-61"],
["&#x10f;","]","-143"],
["&#x10f;","&#x3f;","-164"],
["&#x10f;","&#x29;","-143"],
["&#x10f;","&#x27;","-82"],
["&#x10f;","&#x22;","-82"],
["&#x110;","&#x162;","61"],
["&#x110;","&#x1ef8;","20"],
["&#x110;","&#x1ef6;","20"],
["&#x110;","&#x1ef4;","20"],
["&#x110;","&#x1eb6;","41"],
["&#x110;","&#x1eb4;","41"],
["&#x110;","&#x1eb2;","41"],
["&#x110;","&#x1eb0;","41"],
["&#x110;","&#x1eae;","41"],
["&#x110;","&#x1eac;","41"],
["&#x110;","&#x1eaa;","41"],
["&#x110;","&#x1ea8;","41"],
["&#x110;","&#x1ea6;","41"],
["&#x110;","&#x1ea4;","41"],
["&#x110;","&#x1ea2;","41"],
["&#x110;","&#x1ea0;","41"],
["&#x110;","&#x1e00;","41"],
["&#x110;","&#x201e;","82"],
["&#x110;","&#x201a;","82"],
["&#x110;","&#x1ef2;","20"],
["&#x110;","&#x1e84;","20"],
["&#x110;","&#x1e82;","20"],
["&#x110;","&#x1e80;","20"],
["&#x110;","&#x405;","20"],
["&#x110;","&#x1fa;","41"],
["&#x110;","&#x17d;","20"],
["&#x110;","&#x17b;","20"],
["&#x110;","&#x179;","20"],
["&#x110;","&#x178;","20"],
["&#x110;","&#x176;","20"],
["&#x110;","&#x174;","20"],
["&#x110;","&#x164;","61"],
["&#x110;","&#x21a;","61"],
["&#x110;","&#x104;","41"],
["&#x110;","&#x102;","41"],
["&#x110;","&#x100;","41"],
["&#x110;","&#xdd;","20"],
["&#x110;","&#xc5;","41"],
["&#x110;","&#xc4;","41"],
["&#x110;","&#xc3;","41"],
["&#x110;","&#xc2;","41"],
["&#x110;","&#xc1;","41"],
["&#x110;","&#xc0;","41"],
["&#x110;","Z","20"],
["&#x110;","Y","20"],
["&#x110;","X","41"],
["&#x110;","W","20"],
["&#x110;","V","20"],
["&#x110;","T","61"],
["&#x110;","A","41"],
["&#x110;","&#x2e;","82"],
["&#x110;","&#x2c;","82"],
["&#x112;","J","-123"],
["&#x113;","&#x1ef5;","41"],
["&#x113;","&#x201d;","20"],
["&#x113;","&#x2019;","20"],
["&#x113;","&#x1e83;","41"],
["&#x113;","&#x1e81;","41"],
["&#x113;","&#x17e;","20"],
["&#x113;","&#x17c;","20"],
["&#x113;","&#x17a;","20"],
["&#x113;","&#x175;","41"],
["&#x113;","&#xfd;","41"],
["&#x113;","z","20"],
["&#x113;","y","41"],
["&#x113;","x","41"],
["&#x113;","w","41"],
["&#x113;","v","41"],
["&#x113;","&#x27;","20"],
["&#x113;","&#x22;","20"],
["&#x114;","J","-123"],
["&#x115;","&#x1ef5;","41"],
["&#x115;","&#x201d;","20"],
["&#x115;","&#x2019;","20"],
["&#x115;","&#x1e83;","41"],
["&#x115;","&#x1e81;","41"],
["&#x115;","&#x17e;","20"],
["&#x115;","&#x17c;","20"],
["&#x115;","&#x17a;","20"],
["&#x115;","&#x175;","41"],
["&#x115;","&#xfd;","41"],
["&#x115;","z","20"],
["&#x115;","y","41"],
["&#x115;","x","41"],
["&#x115;","w","41"],
["&#x115;","v","41"],
["&#x115;","&#x27;","20"],
["&#x115;","&#x22;","20"],
["&#x116;","J","-123"],
["&#x117;","&#x1ef5;","41"],
["&#x117;","&#x201d;","20"],
["&#x117;","&#x2019;","20"],
["&#x117;","&#x1e83;","41"],
["&#x117;","&#x1e81;","41"],
["&#x117;","&#x17e;","20"],
["&#x117;","&#x17c;","20"],
["&#x117;","&#x17a;","20"],
["&#x117;","&#x175;","41"],
["&#x117;","&#xfd;","41"],
["&#x117;","z","20"],
["&#x117;","y","41"],
["&#x117;","x","41"],
["&#x117;","w","41"],
["&#x117;","v","41"],
["&#x117;","&#x27;","20"],
["&#x117;","&#x22;","20"],
["&#x118;","J","-123"],
["&#x119;","&#x1ef5;","41"],
["&#x119;","&#x201d;","20"],
["&#x119;","&#x2019;","20"],
["&#x119;","&#x1e83;","41"],
["&#x119;","&#x1e81;","41"],
["&#x119;","&#x17e;","20"],
["&#x119;","&#x17c;","20"],
["&#x119;","&#x17a;","20"],
["&#x119;","&#x175;","41"],
["&#x119;","&#xfd;","41"],
["&#x119;","z","20"],
["&#x119;","y","41"],
["&#x119;","x","41"],
["&#x119;","w","41"],
["&#x119;","v","41"],
["&#x119;","&#x27;","20"],
["&#x119;","&#x22;","20"],
["&#x11a;","J","-123"],
["&#x11b;","&#x1ef5;","41"],
["&#x11b;","&#x201d;","20"],
["&#x11b;","&#x2019;","20"],
["&#x11b;","&#x1e83;","41"],
["&#x11b;","&#x1e81;","41"],
["&#x11b;","&#x17e;","20"],
["&#x11b;","&#x17c;","20"],
["&#x11b;","&#x17a;","20"],
["&#x11b;","&#x175;","41"],
["&#x11b;","&#xfd;","41"],
["&#x11b;","z","20"],
["&#x11b;","y","41"],
["&#x11b;","x","41"],
["&#x11b;","w","41"],
["&#x11b;","v","41"],
["&#x11b;","&#x27;","20"],
["&#x11b;","&#x22;","20"],
["&#x125;","&#x201d;","20"],
["&#x125;","&#x2019;","20"],
["&#x125;","&#x27;","20"],
["&#x125;","&#x22;","20"],
["&#x136;","&#x1ee2;","41"],
["&#x136;","&#x1ee0;","41"],
["&#x136;","&#x1ede;","41"],
["&#x136;","&#x1edc;","41"],
["&#x136;","&#x1eda;","41"],
["&#x136;","&#x1ed8;","41"],
["&#x136;","&#x1ed6;","41"],
["&#x136;","&#x1ed4;","41"],
["&#x136;","&#x1ed2;","41"],
["&#x136;","&#x1ed0;","41"],
["&#x136;","&#x1ece;","41"],
["&#x136;","&#x1ecc;","41"],
["&#x136;","&#x1a0;","41"],
["&#x136;","&#x1fe;","41"],
["&#x136;","&#x152;","41"],
["&#x136;","&#x150;","41"],
["&#x136;","&#x14e;","41"],
["&#x136;","&#x14c;","41"],
["&#x136;","&#x122;","41"],
["&#x136;","&#x120;","41"],
["&#x136;","&#x11e;","41"],
["&#x136;","&#x11c;","41"],
["&#x136;","&#x10c;","41"],
["&#x136;","&#x10a;","41"],
["&#x136;","&#x108;","41"],
["&#x136;","&#x106;","41"],
["&#x136;","&#xd8;","41"],
["&#x136;","&#xd6;","41"],
["&#x136;","&#xd5;","41"],
["&#x136;","&#xd4;","41"],
["&#x136;","&#xd3;","41"],
["&#x136;","&#xd2;","41"],
["&#x136;","&#xc7;","41"],
["&#x136;","Q","41"],
["&#x136;","O","41"],
["&#x136;","G","41"],
["&#x136;","C","41"],
["&#x137;","&#x1ee3;","41"],
["&#x137;","&#x1ee1;","41"],
["&#x137;","&#x1edf;","41"],
["&#x137;","&#x1edd;","41"],
["&#x137;","&#x1edb;","41"],
["&#x137;","&#x1ed9;","41"],
["&#x137;","&#x1ed7;","41"],
["&#x137;","&#x1ed5;","41"],
["&#x137;","&#x1ed1;","41"],
["&#x137;","&#x1ecf;","41"],
["&#x137;","&#x1ecd;","41"],
["&#x137;","&#x1ec7;","41"],
["&#x137;","&#x1ec5;","41"],
["&#x137;","&#x1ec3;","41"],
["&#x137;","&#x1ebf;","41"],
["&#x137;","&#x1ebd;","41"],
["&#x137;","&#x1ebb;","41"],
["&#x137;","&#x1eb9;","41"],
["&#x137;","&#x1a1;","41"],
["&#x137;","&#x1ff;","41"],
["&#x137;","&#x153;","41"],
["&#x137;","&#x151;","41"],
["&#x137;","&#x14f;","41"],
["&#x137;","&#x14d;","41"],
["&#x137;","&#x11b;","41"],
["&#x137;","&#x119;","41"],
["&#x137;","&#x117;","41"],
["&#x137;","&#x115;","41"],
["&#x137;","&#x113;","41"],
["&#x137;","&#x111;","41"],
["&#x137;","&#x10f;","41"],
["&#x137;","&#x10d;","41"],
["&#x137;","&#x10b;","41"],
["&#x137;","&#x109;","41"],
["&#x137;","&#x107;","41"],
["&#x137;","&#xf8;","41"],
["&#x137;","&#xf6;","41"],
["&#x137;","&#xf5;","41"],
["&#x137;","&#xf4;","41"],
["&#x137;","&#xf3;","41"],
["&#x137;","&#xf2;","41"],
["&#x137;","&#xeb;","41"],
["&#x137;","&#xea;","41"],
["&#x137;","&#xe9;","41"],
["&#x137;","&#xe8;","41"],
["&#x137;","&#xe7;","41"],
["&#x137;","&#xe0;","41"],
["&#x137;","q","41"],
["&#x137;","o","41"],
["&#x137;","e","41"],
["&#x137;","d","41"],
["&#x137;","c","41"],
["&#x138;","&#x1ee3;","41"],
["&#x138;","&#x1ee1;","41"],
["&#x138;","&#x1edf;","41"],
["&#x138;","&#x1edd;","41"],
["&#x138;","&#x1edb;","41"],
["&#x138;","&#x1ed9;","41"],
["&#x138;","&#x1ed7;","41"],
["&#x138;","&#x1ed5;","41"],
["&#x138;","&#x1ed1;","41"],
["&#x138;","&#x1ecf;","41"],
["&#x138;","&#x1ecd;","41"],
["&#x138;","&#x1ec7;","41"],
["&#x138;","&#x1ec5;","41"],
["&#x138;","&#x1ec3;","41"],
["&#x138;","&#x1ebf;","41"],
["&#x138;","&#x1ebd;","41"],
["&#x138;","&#x1ebb;","41"],
["&#x138;","&#x1eb9;","41"],
["&#x138;","&#x1a1;","41"],
["&#x138;","&#x1ff;","41"],
["&#x138;","&#x153;","41"],
["&#x138;","&#x151;","41"],
["&#x138;","&#x14f;","41"],
["&#x138;","&#x14d;","41"],
["&#x138;","&#x11b;","41"],
["&#x138;","&#x119;","41"],
["&#x138;","&#x117;","41"],
["&#x138;","&#x115;","41"],
["&#x138;","&#x113;","41"],
["&#x138;","&#x111;","41"],
["&#x138;","&#x10f;","41"],
["&#x138;","&#x10d;","41"],
["&#x138;","&#x10b;","41"],
["&#x138;","&#x109;","41"],
["&#x138;","&#x107;","41"],
["&#x138;","&#xf8;","41"],
["&#x138;","&#xf6;","41"],
["&#x138;","&#xf5;","41"],
["&#x138;","&#xf4;","41"],
["&#x138;","&#xf3;","41"],
["&#x138;","&#xf2;","41"],
["&#x138;","&#xeb;","41"],
["&#x138;","&#xea;","41"],
["&#x138;","&#xe9;","41"],
["&#x138;","&#xe8;","41"],
["&#x138;","&#xe7;","41"],
["&#x138;","&#xe0;","41"],
["&#x138;","q","41"],
["&#x138;","o","41"],
["&#x138;","e","41"],
["&#x138;","d","41"],
["&#x138;","c","41"],
["&#x139;","&#x162;","41"],
["&#x139;","&#x1ef8;","61"],
["&#x139;","&#x1ef6;","61"],
["&#x139;","&#x1ef4;","61"],
["&#x139;","&#x1ef0;","20"],
["&#x139;","&#x1eee;","20"],
["&#x139;","&#x1eec;","20"],
["&#x139;","&#x1eea;","20"],
["&#x139;","&#x1ee8;","20"],
["&#x139;","&#x1ee6;","20"],
["&#x139;","&#x1ee4;","20"],
["&#x139;","&#x1ee2;","41"],
["&#x139;","&#x1ee0;","41"],
["&#x139;","&#x1ede;","41"],
["&#x139;","&#x1edc;","41"],
["&#x139;","&#x1eda;","41"],
["&#x139;","&#x1ed8;","41"],
["&#x139;","&#x1ed6;","41"],
["&#x139;","&#x1ed4;","41"],
["&#x139;","&#x1ed2;","41"],
["&#x139;","&#x1ed0;","41"],
["&#x139;","&#x1ece;","41"],
["&#x139;","&#x1ecc;","41"],
["&#x139;","&#x1af;","20"],
["&#x139;","&#x1a0;","41"],
["&#x139;","&#x201d;","164"],
["&#x139;","&#x2019;","164"],
["&#x139;","&#x1ef2;","61"],
["&#x139;","&#x1e84;","41"],
["&#x139;","&#x1e82;","41"],
["&#x139;","&#x1e80;","41"],
["&#x139;","&#x1fe;","41"],
["&#x139;","&#x178;","61"],
["&#x139;","&#x176;","61"],
["&#x139;","&#x174;","41"],
["&#x139;","&#x172;","20"],
["&#x139;","&#x170;","20"],
["&#x139;","&#x16e;","20"],
["&#x139;","&#x16c;","20"],
["&#x139;","&#x16a;","20"],
["&#x139;","&#x168;","20"],
["&#x139;","&#x164;","41"],
["&#x139;","&#x21a;","41"],
["&#x139;","&#x152;","41"],
["&#x139;","&#x150;","41"],
["&#x139;","&#x14e;","41"],
["&#x139;","&#x14c;","41"],
["&#x139;","&#x122;","41"],
["&#x139;","&#x120;","41"],
["&#x139;","&#x11e;","41"],
["&#x139;","&#x11c;","41"],
["&#x139;","&#x10c;","41"],
["&#x139;","&#x10a;","41"],
["&#x139;","&#x108;","41"],
["&#x139;","&#x106;","41"],
["&#x139;","&#xdd;","61"],
["&#x139;","&#xdc;","20"],
["&#x139;","&#xdb;","20"],
["&#x139;","&#xda;","20"],
["&#x139;","&#xd9;","20"],
["&#x139;","&#xd8;","41"],
["&#x139;","&#xd6;","41"],
["&#x139;","&#xd5;","41"],
["&#x139;","&#xd4;","41"],
["&#x139;","&#xd3;","41"],
["&#x139;","&#xd2;","41"],
["&#x139;","&#xc7;","41"],
["&#x139;","Y","61"],
["&#x139;","W","41"],
["&#x139;","V","41"],
["&#x139;","U","20"],
["&#x139;","T","41"],
["&#x139;","Q","41"],
["&#x139;","O","41"],
["&#x139;","G","41"],
["&#x139;","C","41"],
["&#x139;","&#x27;","164"],
["&#x139;","&#x22;","164"],
["&#x13b;","&#x162;","41"],
["&#x13b;","&#x1ef8;","61"],
["&#x13b;","&#x1ef6;","61"],
["&#x13b;","&#x1ef4;","61"],
["&#x13b;","&#x1ef0;","20"],
["&#x13b;","&#x1eee;","20"],
["&#x13b;","&#x1eec;","20"],
["&#x13b;","&#x1eea;","20"],
["&#x13b;","&#x1ee8;","20"],
["&#x13b;","&#x1ee6;","20"],
["&#x13b;","&#x1ee4;","20"],
["&#x13b;","&#x1ee2;","41"],
["&#x13b;","&#x1ee0;","41"],
["&#x13b;","&#x1ede;","41"],
["&#x13b;","&#x1edc;","41"],
["&#x13b;","&#x1eda;","41"],
["&#x13b;","&#x1ed8;","41"],
["&#x13b;","&#x1ed6;","41"],
["&#x13b;","&#x1ed4;","41"],
["&#x13b;","&#x1ed2;","41"],
["&#x13b;","&#x1ed0;","41"],
["&#x13b;","&#x1ece;","41"],
["&#x13b;","&#x1ecc;","41"],
["&#x13b;","&#x1af;","20"],
["&#x13b;","&#x1a0;","41"],
["&#x13b;","&#x201d;","164"],
["&#x13b;","&#x2019;","164"],
["&#x13b;","&#x1ef2;","61"],
["&#x13b;","&#x1e84;","41"],
["&#x13b;","&#x1e82;","41"],
["&#x13b;","&#x1e80;","41"],
["&#x13b;","&#x1fe;","41"],
["&#x13b;","&#x178;","61"],
["&#x13b;","&#x176;","61"],
["&#x13b;","&#x174;","41"],
["&#x13b;","&#x172;","20"],
["&#x13b;","&#x170;","20"],
["&#x13b;","&#x16e;","20"],
["&#x13b;","&#x16c;","20"],
["&#x13b;","&#x16a;","20"],
["&#x13b;","&#x168;","20"],
["&#x13b;","&#x164;","41"],
["&#x13b;","&#x21a;","41"],
["&#x13b;","&#x152;","41"],
["&#x13b;","&#x150;","41"],
["&#x13b;","&#x14e;","41"],
["&#x13b;","&#x14c;","41"],
["&#x13b;","&#x122;","41"],
["&#x13b;","&#x120;","41"],
["&#x13b;","&#x11e;","41"],
["&#x13b;","&#x11c;","41"],
["&#x13b;","&#x10c;","41"],
["&#x13b;","&#x10a;","41"],
["&#x13b;","&#x108;","41"],
["&#x13b;","&#x106;","41"],
["&#x13b;","&#xdd;","61"],
["&#x13b;","&#xdc;","20"],
["&#x13b;","&#xdb;","20"],
["&#x13b;","&#xda;","20"],
["&#x13b;","&#xd9;","20"],
["&#x13b;","&#xd8;","41"],
["&#x13b;","&#xd6;","41"],
["&#x13b;","&#xd5;","41"],
["&#x13b;","&#xd4;","41"],
["&#x13b;","&#xd3;","41"],
["&#x13b;","&#xd2;","41"],
["&#x13b;","&#xc7;","41"],
["&#x13b;","Y","61"],
["&#x13b;","W","41"],
["&#x13b;","V","41"],
["&#x13b;","U","20"],
["&#x13b;","T","41"],
["&#x13b;","Q","41"],
["&#x13b;","O","41"],
["&#x13b;","G","41"],
["&#x13b;","C","41"],
["&#x13b;","&#x27;","164"],
["&#x13b;","&#x22;","164"],
["&#x13d;","&#x162;","41"],
["&#x13d;","&#x1ef8;","61"],
["&#x13d;","&#x1ef6;","61"],
["&#x13d;","&#x1ef4;","61"],
["&#x13d;","&#x1ef0;","20"],
["&#x13d;","&#x1eee;","20"],
["&#x13d;","&#x1eec;","20"],
["&#x13d;","&#x1eea;","20"],
["&#x13d;","&#x1ee8;","20"],
["&#x13d;","&#x1ee6;","20"],
["&#x13d;","&#x1ee4;","20"],
["&#x13d;","&#x1ee2;","41"],
["&#x13d;","&#x1ee0;","41"],
["&#x13d;","&#x1ede;","41"],
["&#x13d;","&#x1edc;","41"],
["&#x13d;","&#x1eda;","41"],
["&#x13d;","&#x1ed8;","41"],
["&#x13d;","&#x1ed6;","41"],
["&#x13d;","&#x1ed4;","41"],
["&#x13d;","&#x1ed2;","41"],
["&#x13d;","&#x1ed0;","41"],
["&#x13d;","&#x1ece;","41"],
["&#x13d;","&#x1ecc;","41"],
["&#x13d;","&#x1af;","20"],
["&#x13d;","&#x1a0;","41"],
["&#x13d;","&#x201d;","164"],
["&#x13d;","&#x2019;","164"],
["&#x13d;","&#x1ef2;","61"],
["&#x13d;","&#x1e84;","41"],
["&#x13d;","&#x1e82;","41"],
["&#x13d;","&#x1e80;","41"],
["&#x13d;","&#x1fe;","41"],
["&#x13d;","&#x178;","61"],
["&#x13d;","&#x176;","61"],
["&#x13d;","&#x174;","41"],
["&#x13d;","&#x172;","20"],
["&#x13d;","&#x170;","20"],
["&#x13d;","&#x16e;","20"],
["&#x13d;","&#x16c;","20"],
["&#x13d;","&#x16a;","20"],
["&#x13d;","&#x168;","20"],
["&#x13d;","&#x164;","41"],
["&#x13d;","&#x21a;","41"],
["&#x13d;","&#x152;","41"],
["&#x13d;","&#x150;","41"],
["&#x13d;","&#x14e;","41"],
["&#x13d;","&#x14c;","41"],
["&#x13d;","&#x122;","41"],
["&#x13d;","&#x120;","41"],
["&#x13d;","&#x11e;","41"],
["&#x13d;","&#x11c;","41"],
["&#x13d;","&#x10c;","41"],
["&#x13d;","&#x10a;","41"],
["&#x13d;","&#x108;","41"],
["&#x13d;","&#x106;","41"],
["&#x13d;","&#xdd;","61"],
["&#x13d;","&#xdc;","20"],
["&#x13d;","&#xdb;","20"],
["&#x13d;","&#xda;","20"],
["&#x13d;","&#xd9;","20"],
["&#x13d;","&#xd8;","41"],
["&#x13d;","&#xd6;","41"],
["&#x13d;","&#xd5;","41"],
["&#x13d;","&#xd4;","41"],
["&#x13d;","&#xd3;","41"],
["&#x13d;","&#xd2;","41"],
["&#x13d;","&#xc7;","41"],
["&#x13d;","Y","61"],
["&#x13d;","W","41"],
["&#x13d;","V","41"],
["&#x13d;","U","20"],
["&#x13d;","T","41"],
["&#x13d;","Q","41"],
["&#x13d;","O","41"],
["&#x13d;","G","41"],
["&#x13d;","C","41"],
["&#x13d;","&#x27;","164"],
["&#x13d;","&#x22;","164"],
["&#x13e;","&#x201d;","-82"],
["&#x13e;","&#x2019;","-82"],
["&#x13e;","&#x127;","-143"],
["&#x13e;","&#x125;","-61"],
["&#x13e;","&#x7d;","-143"],
["&#x13e;","l","-61"],
["&#x13e;","k","-61"],
["&#x13e;","h","-61"],
["&#x13e;","b","-61"],
["&#x13e;","]","-143"],
["&#x13e;","&#x3f;","-143"],
["&#x13e;","&#x29;","-143"],
["&#x13e;","&#x27;","-82"],
["&#x13e;","&#x22;","-82"],
["&#x13f;","&#x162;","41"],
["&#x13f;","&#x1ef8;","61"],
["&#x13f;","&#x1ef6;","61"],
["&#x13f;","&#x1ef4;","61"],
["&#x13f;","&#x1ef0;","20"],
["&#x13f;","&#x1eee;","20"],
["&#x13f;","&#x1eec;","20"],
["&#x13f;","&#x1eea;","20"],
["&#x13f;","&#x1ee8;","20"],
["&#x13f;","&#x1ee6;","20"],
["&#x13f;","&#x1ee4;","20"],
["&#x13f;","&#x1ee2;","41"],
["&#x13f;","&#x1ee0;","41"],
["&#x13f;","&#x1ede;","41"],
["&#x13f;","&#x1edc;","41"],
["&#x13f;","&#x1eda;","41"],
["&#x13f;","&#x1ed8;","41"],
["&#x13f;","&#x1ed6;","41"],
["&#x13f;","&#x1ed4;","41"],
["&#x13f;","&#x1ed2;","41"],
["&#x13f;","&#x1ed0;","41"],
["&#x13f;","&#x1ece;","41"],
["&#x13f;","&#x1ecc;","41"],
["&#x13f;","&#x1af;","20"],
["&#x13f;","&#x1a0;","41"],
["&#x13f;","&#x201d;","164"],
["&#x13f;","&#x2019;","164"],
["&#x13f;","&#x1ef2;","61"],
["&#x13f;","&#x1e84;","41"],
["&#x13f;","&#x1e82;","41"],
["&#x13f;","&#x1e80;","41"],
["&#x13f;","&#x1fe;","41"],
["&#x13f;","&#x178;","61"],
["&#x13f;","&#x176;","61"],
["&#x13f;","&#x174;","41"],
["&#x13f;","&#x172;","20"],
["&#x13f;","&#x170;","20"],
["&#x13f;","&#x16e;","20"],
["&#x13f;","&#x16c;","20"],
["&#x13f;","&#x16a;","20"],
["&#x13f;","&#x168;","20"],
["&#x13f;","&#x164;","41"],
["&#x13f;","&#x21a;","41"],
["&#x13f;","&#x152;","41"],
["&#x13f;","&#x150;","41"],
["&#x13f;","&#x14e;","41"],
["&#x13f;","&#x14c;","41"],
["&#x13f;","&#x122;","41"],
["&#x13f;","&#x120;","41"],
["&#x13f;","&#x11e;","41"],
["&#x13f;","&#x11c;","41"],
["&#x13f;","&#x10c;","41"],
["&#x13f;","&#x10a;","41"],
["&#x13f;","&#x108;","41"],
["&#x13f;","&#x106;","41"],
["&#x13f;","&#xdd;","61"],
["&#x13f;","&#xdc;","20"],
["&#x13f;","&#xdb;","20"],
["&#x13f;","&#xda;","20"],
["&#x13f;","&#xd9;","20"],
["&#x13f;","&#xd8;","41"],
["&#x13f;","&#xd6;","41"],
["&#x13f;","&#xd5;","41"],
["&#x13f;","&#xd4;","41"],
["&#x13f;","&#xd3;","41"],
["&#x13f;","&#xd2;","41"],
["&#x13f;","&#xc7;","41"],
["&#x13f;","Y","61"],
["&#x13f;","W","41"],
["&#x13f;","V","41"],
["&#x13f;","U","20"],
["&#x13f;","T","41"],
["&#x13f;","Q","41"],
["&#x13f;","O","41"],
["&#x13f;","G","41"],
["&#x13f;","C","41"],
["&#x13f;","&#x27;","164"],
["&#x13f;","&#x22;","164"],
["&#x141;","&#x162;","41"],
["&#x141;","&#x1ef8;","61"],
["&#x141;","&#x1ef6;","61"],
["&#x141;","&#x1ef4;","61"],
["&#x141;","&#x1ef0;","20"],
["&#x141;","&#x1eee;","20"],
["&#x141;","&#x1eec;","20"],
["&#x141;","&#x1eea;","20"],
["&#x141;","&#x1ee8;","20"],
["&#x141;","&#x1ee6;","20"],
["&#x141;","&#x1ee4;","20"],
["&#x141;","&#x1ee2;","41"],
["&#x141;","&#x1ee0;","41"],
["&#x141;","&#x1ede;","41"],
["&#x141;","&#x1edc;","41"],
["&#x141;","&#x1eda;","41"],
["&#x141;","&#x1ed8;","41"],
["&#x141;","&#x1ed6;","41"],
["&#x141;","&#x1ed4;","41"],
["&#x141;","&#x1ed2;","41"],
["&#x141;","&#x1ed0;","41"],
["&#x141;","&#x1ece;","41"],
["&#x141;","&#x1ecc;","41"],
["&#x141;","&#x1af;","20"],
["&#x141;","&#x1a0;","41"],
["&#x141;","&#x201d;","164"],
["&#x141;","&#x2019;","164"],
["&#x141;","&#x1ef2;","61"],
["&#x141;","&#x1e84;","41"],
["&#x141;","&#x1e82;","41"],
["&#x141;","&#x1e80;","41"],
["&#x141;","&#x1fe;","41"],
["&#x141;","&#x178;","61"],
["&#x141;","&#x176;","61"],
["&#x141;","&#x174;","41"],
["&#x141;","&#x172;","20"],
["&#x141;","&#x170;","20"],
["&#x141;","&#x16e;","20"],
["&#x141;","&#x16c;","20"],
["&#x141;","&#x16a;","20"],
["&#x141;","&#x168;","20"],
["&#x141;","&#x164;","41"],
["&#x141;","&#x21a;","41"],
["&#x141;","&#x152;","41"],
["&#x141;","&#x150;","41"],
["&#x141;","&#x14e;","41"],
["&#x141;","&#x14c;","41"],
["&#x141;","&#x122;","41"],
["&#x141;","&#x120;","41"],
["&#x141;","&#x11e;","41"],
["&#x141;","&#x11c;","41"],
["&#x141;","&#x10c;","41"],
["&#x141;","&#x10a;","41"],
["&#x141;","&#x108;","41"],
["&#x141;","&#x106;","41"],
["&#x141;","&#xdd;","61"],
["&#x141;","&#xdc;","20"],
["&#x141;","&#xdb;","20"],
["&#x141;","&#xda;","20"],
["&#x141;","&#xd9;","20"],
["&#x141;","&#xd8;","41"],
["&#x141;","&#xd6;","41"],
["&#x141;","&#xd5;","41"],
["&#x141;","&#xd4;","41"],
["&#x141;","&#xd3;","41"],
["&#x141;","&#xd2;","41"],
["&#x141;","&#xc7;","41"],
["&#x141;","Y","61"],
["&#x141;","W","41"],
["&#x141;","V","41"],
["&#x141;","U","20"],
["&#x141;","T","41"],
["&#x141;","Q","41"],
["&#x141;","O","41"],
["&#x141;","G","41"],
["&#x141;","C","41"],
["&#x141;","&#x27;","164"],
["&#x141;","&#x22;","164"],
["&#x146;","&#x201d;","20"],
["&#x146;","&#x2019;","20"],
["&#x146;","&#x27;","20"],
["&#x146;","&#x22;","20"],
["&#x14c;","&#x162;","61"],
["&#x14c;","&#x1ef8;","20"],
["&#x14c;","&#x1ef6;","20"],
["&#x14c;","&#x1ef4;","20"],
["&#x14c;","&#x1eb6;","41"],
["&#x14c;","&#x1eb4;","41"],
["&#x14c;","&#x1eb2;","41"],
["&#x14c;","&#x1eb0;","41"],
["&#x14c;","&#x1eae;","41"],
["&#x14c;","&#x1eac;","41"],
["&#x14c;","&#x1eaa;","41"],
["&#x14c;","&#x1ea8;","41"],
["&#x14c;","&#x1ea6;","41"],
["&#x14c;","&#x1ea4;","41"],
["&#x14c;","&#x1ea2;","41"],
["&#x14c;","&#x1ea0;","41"],
["&#x14c;","&#x1e00;","41"],
["&#x14c;","&#x201e;","82"],
["&#x14c;","&#x201a;","82"],
["&#x14c;","&#x1ef2;","20"],
["&#x14c;","&#x1e84;","20"],
["&#x14c;","&#x1e82;","20"],
["&#x14c;","&#x1e80;","20"],
["&#x14c;","&#x405;","20"],
["&#x14c;","&#x1fa;","41"],
["&#x14c;","&#x17d;","20"],
["&#x14c;","&#x17b;","20"],
["&#x14c;","&#x179;","20"],
["&#x14c;","&#x178;","20"],
["&#x14c;","&#x176;","20"],
["&#x14c;","&#x174;","20"],
["&#x14c;","&#x164;","61"],
["&#x14c;","&#x21a;","61"],
["&#x14c;","&#x104;","41"],
["&#x14c;","&#x102;","41"],
["&#x14c;","&#x100;","41"],
["&#x14c;","&#xdd;","20"],
["&#x14c;","&#xc5;","41"],
["&#x14c;","&#xc4;","41"],
["&#x14c;","&#xc3;","41"],
["&#x14c;","&#xc2;","41"],
["&#x14c;","&#xc1;","41"],
["&#x14c;","&#xc0;","41"],
["&#x14c;","Z","20"],
["&#x14c;","Y","20"],
["&#x14c;","X","41"],
["&#x14c;","W","20"],
["&#x14c;","V","20"],
["&#x14c;","T","61"],
["&#x14c;","A","41"],
["&#x14c;","&#x2e;","82"],
["&#x14c;","&#x2c;","82"],
["&#x14e;","&#x162;","61"],
["&#x14e;","&#x1ef8;","20"],
["&#x14e;","&#x1ef6;","20"],
["&#x14e;","&#x1ef4;","20"],
["&#x14e;","&#x1eb6;","41"],
["&#x14e;","&#x1eb4;","41"],
["&#x14e;","&#x1eb2;","41"],
["&#x14e;","&#x1eb0;","41"],
["&#x14e;","&#x1eae;","41"],
["&#x14e;","&#x1eac;","41"],
["&#x14e;","&#x1eaa;","41"],
["&#x14e;","&#x1ea8;","41"],
["&#x14e;","&#x1ea6;","41"],
["&#x14e;","&#x1ea4;","41"],
["&#x14e;","&#x1ea2;","41"],
["&#x14e;","&#x1ea0;","41"],
["&#x14e;","&#x1e00;","41"],
["&#x14e;","&#x201e;","82"],
["&#x14e;","&#x201a;","82"],
["&#x14e;","&#x1ef2;","20"],
["&#x14e;","&#x1e84;","20"],
["&#x14e;","&#x1e82;","20"],
["&#x14e;","&#x1e80;","20"],
["&#x14e;","&#x405;","20"],
["&#x14e;","&#x1fa;","41"],
["&#x14e;","&#x17d;","20"],
["&#x14e;","&#x17b;","20"],
["&#x14e;","&#x179;","20"],
["&#x14e;","&#x178;","20"],
["&#x14e;","&#x176;","20"],
["&#x14e;","&#x174;","20"],
["&#x14e;","&#x164;","61"],
["&#x14e;","&#x21a;","61"],
["&#x14e;","&#x104;","41"],
["&#x14e;","&#x102;","41"],
["&#x14e;","&#x100;","41"],
["&#x14e;","&#xdd;","20"],
["&#x14e;","&#xc5;","41"],
["&#x14e;","&#xc4;","41"],
["&#x14e;","&#xc3;","41"],
["&#x14e;","&#xc2;","41"],
["&#x14e;","&#xc1;","41"],
["&#x14e;","&#xc0;","41"],
["&#x14e;","Z","20"],
["&#x14e;","Y","20"],
["&#x14e;","X","41"],
["&#x14e;","W","20"],
["&#x14e;","V","20"],
["&#x14e;","T","61"],
["&#x14e;","A","41"],
["&#x14e;","&#x2e;","82"],
["&#x14e;","&#x2c;","82"],
["&#x150;","&#x162;","61"],
["&#x150;","&#x1ef8;","20"],
["&#x150;","&#x1ef6;","20"],
["&#x150;","&#x1ef4;","20"],
["&#x150;","&#x1eb6;","41"],
["&#x150;","&#x1eb4;","41"],
["&#x150;","&#x1eb2;","41"],
["&#x150;","&#x1eb0;","41"],
["&#x150;","&#x1eae;","41"],
["&#x150;","&#x1eac;","41"],
["&#x150;","&#x1eaa;","41"],
["&#x150;","&#x1ea8;","41"],
["&#x150;","&#x1ea6;","41"],
["&#x150;","&#x1ea4;","41"],
["&#x150;","&#x1ea2;","41"],
["&#x150;","&#x1ea0;","41"],
["&#x150;","&#x1e00;","41"],
["&#x150;","&#x201e;","82"],
["&#x150;","&#x201a;","82"],
["&#x150;","&#x1ef2;","20"],
["&#x150;","&#x1e84;","20"],
["&#x150;","&#x1e82;","20"],
["&#x150;","&#x1e80;","20"],
["&#x150;","&#x405;","20"],
["&#x150;","&#x1fa;","41"],
["&#x150;","&#x17d;","20"],
["&#x150;","&#x17b;","20"],
["&#x150;","&#x179;","20"],
["&#x150;","&#x178;","20"],
["&#x150;","&#x176;","20"],
["&#x150;","&#x174;","20"],
["&#x150;","&#x164;","61"],
["&#x150;","&#x21a;","61"],
["&#x150;","&#x104;","41"],
["&#x150;","&#x102;","41"],
["&#x150;","&#x100;","41"],
["&#x150;","&#xdd;","20"],
["&#x150;","&#xc5;","41"],
["&#x150;","&#xc4;","41"],
["&#x150;","&#xc3;","41"],
["&#x150;","&#xc2;","41"],
["&#x150;","&#xc1;","41"],
["&#x150;","&#xc0;","41"],
["&#x150;","Z","20"],
["&#x150;","Y","20"],
["&#x150;","X","41"],
["&#x150;","W","20"],
["&#x150;","V","20"],
["&#x150;","T","61"],
["&#x150;","A","41"],
["&#x150;","&#x2e;","82"],
["&#x150;","&#x2c;","82"],
["&#x152;","J","-123"],
["&#x155;","&#x1ee3;","41"],
["&#x155;","&#x1ee1;","41"],
["&#x155;","&#x1edf;","41"],
["&#x155;","&#x1edd;","41"],
["&#x155;","&#x1edb;","41"],
["&#x155;","&#x1ed9;","41"],
["&#x155;","&#x1ed7;","41"],
["&#x155;","&#x1ed5;","41"],
["&#x155;","&#x1ed1;","41"],
["&#x155;","&#x1ecf;","41"],
["&#x155;","&#x1ecd;","41"],
["&#x155;","&#x1ec7;","41"],
["&#x155;","&#x1ec5;","41"],
["&#x155;","&#x1ec3;","41"],
["&#x155;","&#x1ebf;","41"],
["&#x155;","&#x1ebd;","41"],
["&#x155;","&#x1ebb;","41"],
["&#x155;","&#x1eb9;","41"],
["&#x155;","&#x1eb7;","41"],
["&#x155;","&#x1eb5;","41"],
["&#x155;","&#x1eb3;","41"],
["&#x155;","&#x1eb1;","41"],
["&#x155;","&#x1eaf;","41"],
["&#x155;","&#x1ead;","41"],
["&#x155;","&#x1eab;","41"],
["&#x155;","&#x1ea9;","41"],
["&#x155;","&#x1ea5;","41"],
["&#x155;","&#x1ea3;","41"],
["&#x155;","&#x1ea1;","41"],
["&#x155;","&#x1a1;","41"],
["&#x155;","&#x1e01;","41"],
["&#x155;","&#x201d;","-82"],
["&#x155;","&#x2019;","-82"],
["&#x155;","&#x1ff;","41"],
["&#x155;","&#x1fd;","41"],
["&#x155;","&#x1fb;","41"],
["&#x155;","&#x153;","41"],
["&#x155;","&#x151;","41"],
["&#x155;","&#x14f;","41"],
["&#x155;","&#x14d;","41"],
["&#x155;","&#x123;","20"],
["&#x155;","&#x121;","20"],
["&#x155;","&#x11f;","20"],
["&#x155;","&#x11d;","20"],
["&#x155;","&#x11b;","41"],
["&#x155;","&#x119;","41"],
["&#x155;","&#x117;","41"],
["&#x155;","&#x115;","41"],
["&#x155;","&#x113;","41"],
["&#x155;","&#x111;","41"],
["&#x155;","&#x10f;","41"],
["&#x155;","&#x10d;","41"],
["&#x155;","&#x10b;","41"],
["&#x155;","&#x109;","41"],
["&#x155;","&#x107;","41"],
["&#x155;","&#x105;","41"],
["&#x155;","&#x103;","41"],
["&#x155;","&#x101;","41"],
["&#x155;","&#xf8;","41"],
["&#x155;","&#xf6;","41"],
["&#x155;","&#xf5;","41"],
["&#x155;","&#xf4;","41"],
["&#x155;","&#xf3;","41"],
["&#x155;","&#xf2;","41"],
["&#x155;","&#xeb;","41"],
["&#x155;","&#xea;","41"],
["&#x155;","&#xe9;","41"],
["&#x155;","&#xe8;","41"],
["&#x155;","&#xe7;","41"],
["&#x155;","&#xe6;","41"],
["&#x155;","&#xe5;","41"],
["&#x155;","&#xe4;","41"],
["&#x155;","&#xe3;","41"],
["&#x155;","&#xe2;","41"],
["&#x155;","&#xe1;","41"],
["&#x155;","&#xe0;","41"],
["&#x155;","q","41"],
["&#x155;","o","41"],
["&#x155;","g","20"],
["&#x155;","e","41"],
["&#x155;","d","41"],
["&#x155;","c","41"],
["&#x155;","a","41"],
["&#x155;","&#x27;","-82"],
["&#x155;","&#x22;","-82"],
["&#x157;","&#x1ee3;","41"],
["&#x157;","&#x1ee1;","41"],
["&#x157;","&#x1edf;","41"],
["&#x157;","&#x1edd;","41"],
["&#x157;","&#x1edb;","41"],
["&#x157;","&#x1ed9;","41"],
["&#x157;","&#x1ed7;","41"],
["&#x157;","&#x1ed5;","41"],
["&#x157;","&#x1ed1;","41"],
["&#x157;","&#x1ecf;","41"],
["&#x157;","&#x1ecd;","41"],
["&#x157;","&#x1ec7;","41"],
["&#x157;","&#x1ec5;","41"],
["&#x157;","&#x1ec3;","41"],
["&#x157;","&#x1ebf;","41"],
["&#x157;","&#x1ebd;","41"],
["&#x157;","&#x1ebb;","41"],
["&#x157;","&#x1eb9;","41"],
["&#x157;","&#x1eb7;","41"],
["&#x157;","&#x1eb5;","41"],
["&#x157;","&#x1eb3;","41"],
["&#x157;","&#x1eb1;","41"],
["&#x157;","&#x1eaf;","41"],
["&#x157;","&#x1ead;","41"],
["&#x157;","&#x1eab;","41"],
["&#x157;","&#x1ea9;","41"],
["&#x157;","&#x1ea5;","41"],
["&#x157;","&#x1ea3;","41"],
["&#x157;","&#x1ea1;","41"],
["&#x157;","&#x1a1;","41"],
["&#x157;","&#x1e01;","41"],
["&#x157;","&#x201d;","-82"],
["&#x157;","&#x2019;","-82"],
["&#x157;","&#x1ff;","41"],
["&#x157;","&#x1fd;","41"],
["&#x157;","&#x1fb;","41"],
["&#x157;","&#x153;","41"],
["&#x157;","&#x151;","41"],
["&#x157;","&#x14f;","41"],
["&#x157;","&#x14d;","41"],
["&#x157;","&#x123;","20"],
["&#x157;","&#x121;","20"],
["&#x157;","&#x11f;","20"],
["&#x157;","&#x11d;","20"],
["&#x157;","&#x11b;","41"],
["&#x157;","&#x119;","41"],
["&#x157;","&#x117;","41"],
["&#x157;","&#x115;","41"],
["&#x157;","&#x113;","41"],
["&#x157;","&#x111;","41"],
["&#x157;","&#x10f;","41"],
["&#x157;","&#x10d;","41"],
["&#x157;","&#x10b;","41"],
["&#x157;","&#x109;","41"],
["&#x157;","&#x107;","41"],
["&#x157;","&#x105;","41"],
["&#x157;","&#x103;","41"],
["&#x157;","&#x101;","41"],
["&#x157;","&#xf8;","41"],
["&#x157;","&#xf6;","41"],
["&#x157;","&#xf5;","41"],
["&#x157;","&#xf4;","41"],
["&#x157;","&#xf3;","41"],
["&#x157;","&#xf2;","41"],
["&#x157;","&#xeb;","41"],
["&#x157;","&#xea;","41"],
["&#x157;","&#xe9;","41"],
["&#x157;","&#xe8;","41"],
["&#x157;","&#xe7;","41"],
["&#x157;","&#xe6;","41"],
["&#x157;","&#xe5;","41"],
["&#x157;","&#xe4;","41"],
["&#x157;","&#xe3;","41"],
["&#x157;","&#xe2;","41"],
["&#x157;","&#xe1;","41"],
["&#x157;","&#xe0;","41"],
["&#x157;","q","41"],
["&#x157;","o","41"],
["&#x157;","g","20"],
["&#x157;","e","41"],
["&#x157;","d","41"],
["&#x157;","c","41"],
["&#x157;","a","41"],
["&#x157;","&#x27;","-82"],
["&#x157;","&#x22;","-82"],
["&#x159;","&#x1ee3;","41"],
["&#x159;","&#x1ee1;","41"],
["&#x159;","&#x1edf;","41"],
["&#x159;","&#x1edd;","41"],
["&#x159;","&#x1edb;","41"],
["&#x159;","&#x1ed9;","41"],
["&#x159;","&#x1ed7;","41"],
["&#x159;","&#x1ed5;","41"],
["&#x159;","&#x1ed1;","41"],
["&#x159;","&#x1ecf;","41"],
["&#x159;","&#x1ecd;","41"],
["&#x159;","&#x1ec7;","41"],
["&#x159;","&#x1ec5;","41"],
["&#x159;","&#x1ec3;","41"],
["&#x159;","&#x1ebf;","41"],
["&#x159;","&#x1ebd;","41"],
["&#x159;","&#x1ebb;","41"],
["&#x159;","&#x1eb9;","41"],
["&#x159;","&#x1eb7;","41"],
["&#x159;","&#x1eb5;","41"],
["&#x159;","&#x1eb3;","41"],
["&#x159;","&#x1eb1;","41"],
["&#x159;","&#x1eaf;","41"],
["&#x159;","&#x1ead;","41"],
["&#x159;","&#x1eab;","41"],
["&#x159;","&#x1ea9;","41"],
["&#x159;","&#x1ea5;","41"],
["&#x159;","&#x1ea3;","41"],
["&#x159;","&#x1ea1;","41"],
["&#x159;","&#x1a1;","41"],
["&#x159;","&#x1e01;","41"],
["&#x159;","&#x201d;","-82"],
["&#x159;","&#x2019;","-82"],
["&#x159;","&#x1ff;","41"],
["&#x159;","&#x1fd;","41"],
["&#x159;","&#x1fb;","41"],
["&#x159;","&#x153;","41"],
["&#x159;","&#x151;","41"],
["&#x159;","&#x14f;","41"],
["&#x159;","&#x14d;","41"],
["&#x159;","&#x123;","20"],
["&#x159;","&#x121;","20"],
["&#x159;","&#x11f;","20"],
["&#x159;","&#x11d;","20"],
["&#x159;","&#x11b;","41"],
["&#x159;","&#x119;","41"],
["&#x159;","&#x117;","41"],
["&#x159;","&#x115;","41"],
["&#x159;","&#x113;","41"],
["&#x159;","&#x111;","41"],
["&#x159;","&#x10f;","41"],
["&#x159;","&#x10d;","41"],
["&#x159;","&#x10b;","41"],
["&#x159;","&#x109;","41"],
["&#x159;","&#x107;","41"],
["&#x159;","&#x105;","41"],
["&#x159;","&#x103;","41"],
["&#x159;","&#x101;","41"],
["&#x159;","&#xf8;","41"],
["&#x159;","&#xf6;","41"],
["&#x159;","&#xf5;","41"],
["&#x159;","&#xf4;","41"],
["&#x159;","&#xf3;","41"],
["&#x159;","&#xf2;","41"],
["&#x159;","&#xeb;","41"],
["&#x159;","&#xea;","41"],
["&#x159;","&#xe9;","41"],
["&#x159;","&#xe8;","41"],
["&#x159;","&#xe7;","41"],
["&#x159;","&#xe6;","41"],
["&#x159;","&#xe5;","41"],
["&#x159;","&#xe4;","41"],
["&#x159;","&#xe3;","41"],
["&#x159;","&#xe2;","41"],
["&#x159;","&#xe1;","41"],
["&#x159;","&#xe0;","41"],
["&#x159;","q","41"],
["&#x159;","o","41"],
["&#x159;","g","20"],
["&#x159;","e","41"],
["&#x159;","d","41"],
["&#x159;","c","41"],
["&#x159;","a","41"],
["&#x159;","&#x27;","-82"],
["&#x159;","&#x22;","-82"],
["&#x21a;","&#x162;","-41"],
["&#x21a;","&#x1ef5;","41"],
["&#x21a;","&#x1ef1;","102"],
["&#x21a;","&#x1eef;","102"],
["&#x21a;","&#x1eed;","102"],
["&#x21a;","&#x1eeb;","102"],
["&#x21a;","&#x1ee9;","102"],
["&#x21a;","&#x1ee7;","102"],
["&#x21a;","&#x1ee5;","102"],
["&#x21a;","&#x1ee3;","143"],
["&#x21a;","&#x1ee2;","41"],
["&#x21a;","&#x1ee1;","143"],
["&#x21a;","&#x1ee0;","41"],
["&#x21a;","&#x1edf;","143"],
["&#x21a;","&#x1ede;","41"],
["&#x21a;","&#x1edd;","143"],
["&#x21a;","&#x1edc;","41"],
["&#x21a;","&#x1edb;","143"],
["&#x21a;","&#x1eda;","41"],
["&#x21a;","&#x1ed9;","143"],
["&#x21a;","&#x1ed8;","41"],
["&#x21a;","&#x1ed7;","143"],
["&#x21a;","&#x1ed6;","41"],
["&#x21a;","&#x1ed5;","143"],
["&#x21a;","&#x1ed4;","41"],
["&#x21a;","&#x1ed2;","41"],
["&#x21a;","&#x1ed1;","143"],
["&#x21a;","&#x1ed0;","41"],
["&#x21a;","&#x1ecf;","143"],
["&#x21a;","&#x1ece;","41"],
["&#x21a;","&#x1ecd;","143"],
["&#x21a;","&#x1ecc;","41"],
["&#x21a;","&#x1ec7;","143"],
["&#x21a;","&#x1ec5;","143"],
["&#x21a;","&#x1ec3;","143"],
["&#x21a;","&#x1ebf;","143"],
["&#x21a;","&#x1ebd;","143"],
["&#x21a;","&#x1ebb;","143"],
["&#x21a;","&#x1eb9;","143"],
["&#x21a;","&#x1eb7;","164"],
["&#x21a;","&#x1eb6;","143"],
["&#x21a;","&#x1eb5;","164"],
["&#x21a;","&#x1eb4;","143"],
["&#x21a;","&#x1eb3;","164"],
["&#x21a;","&#x1eb2;","143"],
["&#x21a;","&#x1eb1;","164"],
["&#x21a;","&#x1eb0;","143"],
["&#x21a;","&#x1eaf;","164"],
["&#x21a;","&#x1eae;","143"],
["&#x21a;","&#x1ead;","164"],
["&#x21a;","&#x1eac;","143"],
["&#x21a;","&#x1eab;","164"],
["&#x21a;","&#x1eaa;","143"],
["&#x21a;","&#x1ea9;","164"],
["&#x21a;","&#x1ea8;","143"],
["&#x21a;","&#x1ea6;","143"],
["&#x21a;","&#x1ea5;","164"],
["&#x21a;","&#x1ea4;","143"],
["&#x21a;","&#x1ea3;","164"],
["&#x21a;","&#x1ea2;","143"],
["&#x21a;","&#x1ea1;","164"],
["&#x21a;","&#x1ea0;","143"],
["&#x21a;","&#x1b0;","102"],
["&#x21a;","&#x1a1;","143"],
["&#x21a;","&#x1a0;","41"],
["&#x21a;","&#x1e01;","164"],
["&#x21a;","&#x1e00;","143"],
["&#x21a;","&#x1e3f;","102"],
["&#x21a;","&#x201e;","123"],
["&#x21a;","&#x201a;","123"],
["&#x21a;","&#x2015;","82"],
["&#x21a;","&#x2014;","82"],
["&#x21a;","&#x2013;","82"],
["&#x21a;","&#x1e83;","41"],
["&#x21a;","&#x1e81;","41"],
["&#x21a;","&#x219;","123"],
["&#x21a;","&#x1ff;","143"],
["&#x21a;","&#x1fe;","41"],
["&#x21a;","&#x1fd;","164"],
["&#x21a;","&#x1fb;","164"],
["&#x21a;","&#x1fa;","143"],
["&#x21a;","&#x17e;","82"],
["&#x21a;","&#x17c;","82"],
["&#x21a;","&#x17a;","82"],
["&#x21a;","&#x175;","41"],
["&#x21a;","&#x173;","102"],
["&#x21a;","&#x171;","102"],
["&#x21a;","&#x16f;","102"],
["&#x21a;","&#x16d;","102"],
["&#x21a;","&#x16b;","102"],
["&#x21a;","&#x169;","102"],
["&#x21a;","&#x164;","-41"],
["&#x21a;","&#x21a;","-41"],
["&#x21a;","&#x15f;","123"],
["&#x21a;","&#x15b;","123"],
["&#x21a;","&#x157;","102"],
["&#x21a;","&#x155;","102"],
["&#x21a;","&#x153;","143"],
["&#x21a;","&#x152;","41"],
["&#x21a;","&#x151;","143"],
["&#x21a;","&#x150;","41"],
["&#x21a;","&#x14f;","143"],
["&#x21a;","&#x14e;","41"],
["&#x21a;","&#x14d;","143"],
["&#x21a;","&#x14c;","41"],
["&#x21a;","&#x14b;","102"],
["&#x21a;","&#x146;","102"],
["&#x21a;","&#x144;","102"],
["&#x21a;","&#x138;","102"],
["&#x21a;","&#x123;","143"],
["&#x21a;","&#x122;","41"],
["&#x21a;","&#x121;","143"],
["&#x21a;","&#x120;","41"],
["&#x21a;","&#x11f;","143"],
["&#x21a;","&#x11e;","41"],
["&#x21a;","&#x11d;","143"],
["&#x21a;","&#x11c;","41"],
["&#x21a;","&#x11b;","143"],
["&#x21a;","&#x119;","143"],
["&#x21a;","&#x117;","143"],
["&#x21a;","&#x115;","143"],
["&#x21a;","&#x113;","143"],
["&#x21a;","&#x111;","143"],
["&#x21a;","&#x10f;","143"],
["&#x21a;","&#x10d;","143"],
["&#x21a;","&#x10c;","41"],
["&#x21a;","&#x10b;","143"],
["&#x21a;","&#x10a;","41"],
["&#x21a;","&#x109;","143"],
["&#x21a;","&#x108;","41"],
["&#x21a;","&#x107;","143"],
["&#x21a;","&#x106;","41"],
["&#x21a;","&#x105;","164"],
["&#x21a;","&#x104;","143"],
["&#x21a;","&#x103;","164"],
["&#x21a;","&#x102;","143"],
["&#x21a;","&#x101;","164"],
["&#x21a;","&#x100;","143"],
["&#x21a;","&#xfd;","41"],
["&#x21a;","&#xfc;","102"],
["&#x21a;","&#xfb;","102"],
["&#x21a;","&#xfa;","102"],
["&#x21a;","&#xf9;","102"],
["&#x21a;","&#xf8;","143"],
["&#x21a;","&#xf6;","143"],
["&#x21a;","&#xf5;","143"],
["&#x21a;","&#xf4;","143"],
["&#x21a;","&#xf3;","143"],
["&#x21a;","&#xf2;","143"],
["&#x21a;","&#xeb;","143"],
["&#x21a;","&#xea;","143"],
["&#x21a;","&#xe9;","143"],
["&#x21a;","&#xe8;","143"],
["&#x21a;","&#xe7;","143"],
["&#x21a;","&#xe6;","164"],
["&#x21a;","&#xe5;","164"],
["&#x21a;","&#xe4;","164"],
["&#x21a;","&#xe3;","164"],
["&#x21a;","&#xe2;","164"],
["&#x21a;","&#xe1;","164"],
["&#x21a;","&#xe0;","143"],
["&#x21a;","&#xd8;","41"],
["&#x21a;","&#xd6;","41"],
["&#x21a;","&#xd5;","41"],
["&#x21a;","&#xd4;","41"],
["&#x21a;","&#xd3;","41"],
["&#x21a;","&#xd2;","41"],
["&#x21a;","&#xc7;","41"],
["&#x21a;","&#xc5;","143"],
["&#x21a;","&#xc4;","143"],
["&#x21a;","&#xc3;","143"],
["&#x21a;","&#xc2;","143"],
["&#x21a;","&#xc1;","143"],
["&#x21a;","&#xc0;","143"],
["&#x21a;","z","82"],
["&#x21a;","y","41"],
["&#x21a;","x","41"],
["&#x21a;","w","41"],
["&#x21a;","v","41"],
["&#x21a;","u","102"],
["&#x21a;","s","123"],
["&#x21a;","r","102"],
["&#x21a;","q","143"],
["&#x21a;","p","102"],
["&#x21a;","o","143"],
["&#x21a;","n","102"],
["&#x21a;","m","102"],
["&#x21a;","g","143"],
["&#x21a;","e","143"],
["&#x21a;","d","143"],
["&#x21a;","c","143"],
["&#x21a;","a","164"],
["&#x21a;","T","-41"],
["&#x21a;","Q","41"],
["&#x21a;","O","41"],
["&#x21a;","G","41"],
["&#x21a;","C","41"],
["&#x21a;","A","143"],
["&#x21a;","&#x3f;","-41"],
["&#x21a;","&#x2e;","123"],
["&#x21a;","&#x2d;","82"],
["&#x21a;","&#x2c;","123"],
["&#x21b;","&#x201d;","-41"],
["&#x21b;","&#x2019;","-41"],
["&#x21b;","&#x27;","-41"],
["&#x21b;","&#x22;","-41"],
["&#x164;","&#x162;","-41"],
["&#x164;","&#x1ef5;","41"],
["&#x164;","&#x1ef1;","102"],
["&#x164;","&#x1eef;","102"],
["&#x164;","&#x1eed;","102"],
["&#x164;","&#x1eeb;","102"],
["&#x164;","&#x1ee9;","102"],
["&#x164;","&#x1ee7;","102"],
["&#x164;","&#x1ee5;","102"],
["&#x164;","&#x1ee3;","143"],
["&#x164;","&#x1ee2;","41"],
["&#x164;","&#x1ee1;","143"],
["&#x164;","&#x1ee0;","41"],
["&#x164;","&#x1edf;","143"],
["&#x164;","&#x1ede;","41"],
["&#x164;","&#x1edd;","143"],
["&#x164;","&#x1edc;","41"],
["&#x164;","&#x1edb;","143"],
["&#x164;","&#x1eda;","41"],
["&#x164;","&#x1ed9;","143"],
["&#x164;","&#x1ed8;","41"],
["&#x164;","&#x1ed7;","143"],
["&#x164;","&#x1ed6;","41"],
["&#x164;","&#x1ed5;","143"],
["&#x164;","&#x1ed4;","41"],
["&#x164;","&#x1ed2;","41"],
["&#x164;","&#x1ed1;","143"],
["&#x164;","&#x1ed0;","41"],
["&#x164;","&#x1ecf;","143"],
["&#x164;","&#x1ece;","41"],
["&#x164;","&#x1ecd;","143"],
["&#x164;","&#x1ecc;","41"],
["&#x164;","&#x1ec7;","143"],
["&#x164;","&#x1ec5;","143"],
["&#x164;","&#x1ec3;","143"],
["&#x164;","&#x1ebf;","143"],
["&#x164;","&#x1ebd;","143"],
["&#x164;","&#x1ebb;","143"],
["&#x164;","&#x1eb9;","143"],
["&#x164;","&#x1eb7;","164"],
["&#x164;","&#x1eb6;","143"],
["&#x164;","&#x1eb5;","164"],
["&#x164;","&#x1eb4;","143"],
["&#x164;","&#x1eb3;","164"],
["&#x164;","&#x1eb2;","143"],
["&#x164;","&#x1eb1;","164"],
["&#x164;","&#x1eb0;","143"],
["&#x164;","&#x1eaf;","164"],
["&#x164;","&#x1eae;","143"],
["&#x164;","&#x1ead;","164"],
["&#x164;","&#x1eac;","143"],
["&#x164;","&#x1eab;","164"],
["&#x164;","&#x1eaa;","143"],
["&#x164;","&#x1ea9;","164"],
["&#x164;","&#x1ea8;","143"],
["&#x164;","&#x1ea6;","143"],
["&#x164;","&#x1ea5;","164"],
["&#x164;","&#x1ea4;","143"],
["&#x164;","&#x1ea3;","164"],
["&#x164;","&#x1ea2;","143"],
["&#x164;","&#x1ea1;","164"],
["&#x164;","&#x1ea0;","143"],
["&#x164;","&#x1b0;","102"],
["&#x164;","&#x1a1;","143"],
["&#x164;","&#x1a0;","41"],
["&#x164;","&#x1e01;","164"],
["&#x164;","&#x1e00;","143"],
["&#x164;","&#x1e3f;","102"],
["&#x164;","&#x201e;","123"],
["&#x164;","&#x201a;","123"],
["&#x164;","&#x2015;","82"],
["&#x164;","&#x2014;","82"],
["&#x164;","&#x2013;","82"],
["&#x164;","&#x1e83;","41"],
["&#x164;","&#x1e81;","41"],
["&#x164;","&#x219;","123"],
["&#x164;","&#x1ff;","143"],
["&#x164;","&#x1fe;","41"],
["&#x164;","&#x1fd;","164"],
["&#x164;","&#x1fb;","164"],
["&#x164;","&#x1fa;","143"],
["&#x164;","&#x17e;","82"],
["&#x164;","&#x17c;","82"],
["&#x164;","&#x17a;","82"],
["&#x164;","&#x175;","41"],
["&#x164;","&#x173;","102"],
["&#x164;","&#x171;","102"],
["&#x164;","&#x16f;","102"],
["&#x164;","&#x16d;","102"],
["&#x164;","&#x16b;","102"],
["&#x164;","&#x169;","102"],
["&#x164;","&#x164;","-41"],
["&#x164;","&#x21a;","-41"],
["&#x164;","&#x15f;","123"],
["&#x164;","&#x15b;","123"],
["&#x164;","&#x157;","102"],
["&#x164;","&#x155;","102"],
["&#x164;","&#x153;","143"],
["&#x164;","&#x152;","41"],
["&#x164;","&#x151;","143"],
["&#x164;","&#x150;","41"],
["&#x164;","&#x14f;","143"],
["&#x164;","&#x14e;","41"],
["&#x164;","&#x14d;","143"],
["&#x164;","&#x14c;","41"],
["&#x164;","&#x14b;","102"],
["&#x164;","&#x146;","102"],
["&#x164;","&#x144;","102"],
["&#x164;","&#x138;","102"],
["&#x164;","&#x123;","143"],
["&#x164;","&#x122;","41"],
["&#x164;","&#x121;","143"],
["&#x164;","&#x120;","41"],
["&#x164;","&#x11f;","143"],
["&#x164;","&#x11e;","41"],
["&#x164;","&#x11d;","143"],
["&#x164;","&#x11c;","41"],
["&#x164;","&#x11b;","143"],
["&#x164;","&#x119;","143"],
["&#x164;","&#x117;","143"],
["&#x164;","&#x115;","143"],
["&#x164;","&#x113;","143"],
["&#x164;","&#x111;","143"],
["&#x164;","&#x10f;","143"],
["&#x164;","&#x10d;","143"],
["&#x164;","&#x10c;","41"],
["&#x164;","&#x10b;","143"],
["&#x164;","&#x10a;","41"],
["&#x164;","&#x109;","143"],
["&#x164;","&#x108;","41"],
["&#x164;","&#x107;","143"],
["&#x164;","&#x106;","41"],
["&#x164;","&#x105;","164"],
["&#x164;","&#x104;","143"],
["&#x164;","&#x103;","164"],
["&#x164;","&#x102;","143"],
["&#x164;","&#x101;","164"],
["&#x164;","&#x100;","143"],
["&#x164;","&#xfd;","41"],
["&#x164;","&#xfc;","102"],
["&#x164;","&#xfb;","102"],
["&#x164;","&#xfa;","102"],
["&#x164;","&#xf9;","102"],
["&#x164;","&#xf8;","143"],
["&#x164;","&#xf6;","143"],
["&#x164;","&#xf5;","143"],
["&#x164;","&#xf4;","143"],
["&#x164;","&#xf3;","143"],
["&#x164;","&#xf2;","143"],
["&#x164;","&#xeb;","143"],
["&#x164;","&#xea;","143"],
["&#x164;","&#xe9;","143"],
["&#x164;","&#xe8;","143"],
["&#x164;","&#xe7;","143"],
["&#x164;","&#xe6;","164"],
["&#x164;","&#xe5;","164"],
["&#x164;","&#xe4;","164"],
["&#x164;","&#xe3;","164"],
["&#x164;","&#xe2;","164"],
["&#x164;","&#xe1;","164"],
["&#x164;","&#xe0;","143"],
["&#x164;","&#xd8;","41"],
["&#x164;","&#xd6;","41"],
["&#x164;","&#xd5;","41"],
["&#x164;","&#xd4;","41"],
["&#x164;","&#xd3;","41"],
["&#x164;","&#xd2;","41"],
["&#x164;","&#xc7;","41"],
["&#x164;","&#xc5;","143"],
["&#x164;","&#xc4;","143"],
["&#x164;","&#xc3;","143"],
["&#x164;","&#xc2;","143"],
["&#x164;","&#xc1;","143"],
["&#x164;","&#xc0;","143"],
["&#x164;","z","82"],
["&#x164;","y","41"],
["&#x164;","x","41"],
["&#x164;","w","41"],
["&#x164;","v","41"],
["&#x164;","u","102"],
["&#x164;","s","123"],
["&#x164;","r","102"],
["&#x164;","q","143"],
["&#x164;","p","102"],
["&#x164;","o","143"],
["&#x164;","n","102"],
["&#x164;","m","102"],
["&#x164;","g","143"],
["&#x164;","e","143"],
["&#x164;","d","143"],
["&#x164;","c","143"],
["&#x164;","a","164"],
["&#x164;","T","-41"],
["&#x164;","Q","41"],
["&#x164;","O","41"],
["&#x164;","G","41"],
["&#x164;","C","41"],
["&#x164;","A","143"],
["&#x164;","&#x3f;","-41"],
["&#x164;","&#x2e;","123"],
["&#x164;","&#x2d;","82"],
["&#x164;","&#x2c;","123"],
["&#x165;","&#x201d;","-41"],
["&#x165;","&#x2019;","-41"],
["&#x165;","&#x27;","-41"],
["&#x165;","&#x22;","-41"],
["&#x166;","&#x162;","-41"],
["&#x166;","&#x1ef5;","41"],
["&#x166;","&#x1ef1;","102"],
["&#x166;","&#x1eef;","102"],
["&#x166;","&#x1eed;","102"],
["&#x166;","&#x1eeb;","102"],
["&#x166;","&#x1ee9;","102"],
["&#x166;","&#x1ee7;","102"],
["&#x166;","&#x1ee5;","102"],
["&#x166;","&#x1ee3;","143"],
["&#x166;","&#x1ee2;","41"],
["&#x166;","&#x1ee1;","143"],
["&#x166;","&#x1ee0;","41"],
["&#x166;","&#x1edf;","143"],
["&#x166;","&#x1ede;","41"],
["&#x166;","&#x1edd;","143"],
["&#x166;","&#x1edc;","41"],
["&#x166;","&#x1edb;","143"],
["&#x166;","&#x1eda;","41"],
["&#x166;","&#x1ed9;","143"],
["&#x166;","&#x1ed8;","41"],
["&#x166;","&#x1ed7;","143"],
["&#x166;","&#x1ed6;","41"],
["&#x166;","&#x1ed5;","143"],
["&#x166;","&#x1ed4;","41"],
["&#x166;","&#x1ed2;","41"],
["&#x166;","&#x1ed1;","143"],
["&#x166;","&#x1ed0;","41"],
["&#x166;","&#x1ecf;","143"],
["&#x166;","&#x1ece;","41"],
["&#x166;","&#x1ecd;","143"],
["&#x166;","&#x1ecc;","41"],
["&#x166;","&#x1ec7;","143"],
["&#x166;","&#x1ec5;","143"],
["&#x166;","&#x1ec3;","143"],
["&#x166;","&#x1ebf;","143"],
["&#x166;","&#x1ebd;","143"],
["&#x166;","&#x1ebb;","143"],
["&#x166;","&#x1eb9;","143"],
["&#x166;","&#x1eb7;","164"],
["&#x166;","&#x1eb6;","143"],
["&#x166;","&#x1eb5;","164"],
["&#x166;","&#x1eb4;","143"],
["&#x166;","&#x1eb3;","164"],
["&#x166;","&#x1eb2;","143"],
["&#x166;","&#x1eb1;","164"],
["&#x166;","&#x1eb0;","143"],
["&#x166;","&#x1eaf;","164"],
["&#x166;","&#x1eae;","143"],
["&#x166;","&#x1ead;","164"],
["&#x166;","&#x1eac;","143"],
["&#x166;","&#x1eab;","164"],
["&#x166;","&#x1eaa;","143"],
["&#x166;","&#x1ea9;","164"],
["&#x166;","&#x1ea8;","143"],
["&#x166;","&#x1ea6;","143"],
["&#x166;","&#x1ea5;","164"],
["&#x166;","&#x1ea4;","143"],
["&#x166;","&#x1ea3;","164"],
["&#x166;","&#x1ea2;","143"],
["&#x166;","&#x1ea1;","164"],
["&#x166;","&#x1ea0;","143"],
["&#x166;","&#x1b0;","102"],
["&#x166;","&#x1a1;","143"],
["&#x166;","&#x1a0;","41"],
["&#x166;","&#x1e01;","164"],
["&#x166;","&#x1e00;","143"],
["&#x166;","&#x1e3f;","102"],
["&#x166;","&#x201e;","123"],
["&#x166;","&#x201a;","123"],
["&#x166;","&#x2015;","82"],
["&#x166;","&#x2014;","82"],
["&#x166;","&#x2013;","82"],
["&#x166;","&#x1e83;","41"],
["&#x166;","&#x1e81;","41"],
["&#x166;","&#x219;","123"],
["&#x166;","&#x1ff;","143"],
["&#x166;","&#x1fe;","41"],
["&#x166;","&#x1fd;","164"],
["&#x166;","&#x1fb;","164"],
["&#x166;","&#x1fa;","143"],
["&#x166;","&#x17e;","82"],
["&#x166;","&#x17c;","82"],
["&#x166;","&#x17a;","82"],
["&#x166;","&#x175;","41"],
["&#x166;","&#x173;","102"],
["&#x166;","&#x171;","102"],
["&#x166;","&#x16f;","102"],
["&#x166;","&#x16d;","102"],
["&#x166;","&#x16b;","102"],
["&#x166;","&#x169;","102"],
["&#x166;","&#x164;","-41"],
["&#x166;","&#x21a;","-41"],
["&#x166;","&#x15f;","123"],
["&#x166;","&#x15b;","123"],
["&#x166;","&#x157;","102"],
["&#x166;","&#x155;","102"],
["&#x166;","&#x153;","143"],
["&#x166;","&#x152;","41"],
["&#x166;","&#x151;","143"],
["&#x166;","&#x150;","41"],
["&#x166;","&#x14f;","143"],
["&#x166;","&#x14e;","41"],
["&#x166;","&#x14d;","143"],
["&#x166;","&#x14c;","41"],
["&#x166;","&#x14b;","102"],
["&#x166;","&#x146;","102"],
["&#x166;","&#x144;","102"],
["&#x166;","&#x138;","102"],
["&#x166;","&#x123;","143"],
["&#x166;","&#x122;","41"],
["&#x166;","&#x121;","143"],
["&#x166;","&#x120;","41"],
["&#x166;","&#x11f;","143"],
["&#x166;","&#x11e;","41"],
["&#x166;","&#x11d;","143"],
["&#x166;","&#x11c;","41"],
["&#x166;","&#x11b;","143"],
["&#x166;","&#x119;","143"],
["&#x166;","&#x117;","143"],
["&#x166;","&#x115;","143"],
["&#x166;","&#x113;","143"],
["&#x166;","&#x111;","143"],
["&#x166;","&#x10f;","143"],
["&#x166;","&#x10d;","143"],
["&#x166;","&#x10c;","41"],
["&#x166;","&#x10b;","143"],
["&#x166;","&#x10a;","41"],
["&#x166;","&#x109;","143"],
["&#x166;","&#x108;","41"],
["&#x166;","&#x107;","143"],
["&#x166;","&#x106;","41"],
["&#x166;","&#x105;","164"],
["&#x166;","&#x104;","143"],
["&#x166;","&#x103;","164"],
["&#x166;","&#x102;","143"],
["&#x166;","&#x101;","164"],
["&#x166;","&#x100;","143"],
["&#x166;","&#xfd;","41"],
["&#x166;","&#xfc;","102"],
["&#x166;","&#xfb;","102"],
["&#x166;","&#xfa;","102"],
["&#x166;","&#xf9;","102"],
["&#x166;","&#xf8;","143"],
["&#x166;","&#xf6;","143"],
["&#x166;","&#xf5;","143"],
["&#x166;","&#xf4;","143"],
["&#x166;","&#xf3;","143"],
["&#x166;","&#xf2;","143"],
["&#x166;","&#xeb;","143"],
["&#x166;","&#xea;","143"],
["&#x166;","&#xe9;","143"],
["&#x166;","&#xe8;","143"],
["&#x166;","&#xe7;","143"],
["&#x166;","&#xe6;","164"],
["&#x166;","&#xe5;","164"],
["&#x166;","&#xe4;","164"],
["&#x166;","&#xe3;","164"],
["&#x166;","&#xe2;","164"],
["&#x166;","&#xe1;","164"],
["&#x166;","&#xe0;","143"],
["&#x166;","&#xd8;","41"],
["&#x166;","&#xd6;","41"],
["&#x166;","&#xd5;","41"],
["&#x166;","&#xd4;","41"],
["&#x166;","&#xd3;","41"],
["&#x166;","&#xd2;","41"],
["&#x166;","&#xc7;","41"],
["&#x166;","&#xc5;","143"],
["&#x166;","&#xc4;","143"],
["&#x166;","&#xc3;","143"],
["&#x166;","&#xc2;","143"],
["&#x166;","&#xc1;","143"],
["&#x166;","&#xc0;","143"],
["&#x166;","z","82"],
["&#x166;","y","41"],
["&#x166;","x","41"],
["&#x166;","w","41"],
["&#x166;","v","41"],
["&#x166;","u","102"],
["&#x166;","s","123"],
["&#x166;","r","102"],
["&#x166;","q","143"],
["&#x166;","p","102"],
["&#x166;","o","143"],
["&#x166;","n","102"],
["&#x166;","m","102"],
["&#x166;","g","143"],
["&#x166;","e","143"],
["&#x166;","d","143"],
["&#x166;","c","143"],
["&#x166;","a","164"],
["&#x166;","T","-41"],
["&#x166;","Q","41"],
["&#x166;","O","41"],
["&#x166;","G","41"],
["&#x166;","C","41"],
["&#x166;","A","143"],
["&#x166;","&#x3f;","-41"],
["&#x166;","&#x2e;","123"],
["&#x166;","&#x2d;","82"],
["&#x166;","&#x2c;","123"],
["&#x168;","&#x1eb6;","20"],
["&#x168;","&#x1eb4;","20"],
["&#x168;","&#x1eb2;","20"],
["&#x168;","&#x1eb0;","20"],
["&#x168;","&#x1eae;","20"],
["&#x168;","&#x1eac;","20"],
["&#x168;","&#x1eaa;","20"],
["&#x168;","&#x1ea8;","20"],
["&#x168;","&#x1ea6;","20"],
["&#x168;","&#x1ea4;","20"],
["&#x168;","&#x1ea2;","20"],
["&#x168;","&#x1ea0;","20"],
["&#x168;","&#x1e00;","20"],
["&#x168;","&#x201e;","41"],
["&#x168;","&#x201a;","41"],
["&#x168;","&#x1fa;","20"],
["&#x168;","&#x104;","20"],
["&#x168;","&#x102;","20"],
["&#x168;","&#x100;","20"],
["&#x168;","&#xc5;","20"],
["&#x168;","&#xc4;","20"],
["&#x168;","&#xc3;","20"],
["&#x168;","&#xc2;","20"],
["&#x168;","&#xc1;","20"],
["&#x168;","&#xc0;","20"],
["&#x168;","A","20"],
["&#x168;","&#x2e;","41"],
["&#x168;","&#x2c;","41"],
["&#x16a;","&#x1eb6;","20"],
["&#x16a;","&#x1eb4;","20"],
["&#x16a;","&#x1eb2;","20"],
["&#x16a;","&#x1eb0;","20"],
["&#x16a;","&#x1eae;","20"],
["&#x16a;","&#x1eac;","20"],
["&#x16a;","&#x1eaa;","20"],
["&#x16a;","&#x1ea8;","20"],
["&#x16a;","&#x1ea6;","20"],
["&#x16a;","&#x1ea4;","20"],
["&#x16a;","&#x1ea2;","20"],
["&#x16a;","&#x1ea0;","20"],
["&#x16a;","&#x1e00;","20"],
["&#x16a;","&#x201e;","41"],
["&#x16a;","&#x201a;","41"],
["&#x16a;","&#x1fa;","20"],
["&#x16a;","&#x104;","20"],
["&#x16a;","&#x102;","20"],
["&#x16a;","&#x100;","20"],
["&#x16a;","&#xc5;","20"],
["&#x16a;","&#xc4;","20"],
["&#x16a;","&#xc3;","20"],
["&#x16a;","&#xc2;","20"],
["&#x16a;","&#xc1;","20"],
["&#x16a;","&#xc0;","20"],
["&#x16a;","A","20"],
["&#x16a;","&#x2e;","41"],
["&#x16a;","&#x2c;","41"],
["&#x16c;","&#x1eb6;","20"],
["&#x16c;","&#x1eb4;","20"],
["&#x16c;","&#x1eb2;","20"],
["&#x16c;","&#x1eb0;","20"],
["&#x16c;","&#x1eae;","20"],
["&#x16c;","&#x1eac;","20"],
["&#x16c;","&#x1eaa;","20"],
["&#x16c;","&#x1ea8;","20"],
["&#x16c;","&#x1ea6;","20"],
["&#x16c;","&#x1ea4;","20"],
["&#x16c;","&#x1ea2;","20"],
["&#x16c;","&#x1ea0;","20"],
["&#x16c;","&#x1e00;","20"],
["&#x16c;","&#x201e;","41"],
["&#x16c;","&#x201a;","41"],
["&#x16c;","&#x1fa;","20"],
["&#x16c;","&#x104;","20"],
["&#x16c;","&#x102;","20"],
["&#x16c;","&#x100;","20"],
["&#x16c;","&#xc5;","20"],
["&#x16c;","&#xc4;","20"],
["&#x16c;","&#xc3;","20"],
["&#x16c;","&#xc2;","20"],
["&#x16c;","&#xc1;","20"],
["&#x16c;","&#xc0;","20"],
["&#x16c;","A","20"],
["&#x16c;","&#x2e;","41"],
["&#x16c;","&#x2c;","41"],
["&#x16e;","&#x1eb6;","20"],
["&#x16e;","&#x1eb4;","20"],
["&#x16e;","&#x1eb2;","20"],
["&#x16e;","&#x1eb0;","20"],
["&#x16e;","&#x1eae;","20"],
["&#x16e;","&#x1eac;","20"],
["&#x16e;","&#x1eaa;","20"],
["&#x16e;","&#x1ea8;","20"],
["&#x16e;","&#x1ea6;","20"],
["&#x16e;","&#x1ea4;","20"],
["&#x16e;","&#x1ea2;","20"],
["&#x16e;","&#x1ea0;","20"],
["&#x16e;","&#x1e00;","20"],
["&#x16e;","&#x201e;","41"],
["&#x16e;","&#x201a;","41"],
["&#x16e;","&#x1fa;","20"],
["&#x16e;","&#x104;","20"],
["&#x16e;","&#x102;","20"],
["&#x16e;","&#x100;","20"],
["&#x16e;","&#xc5;","20"],
["&#x16e;","&#xc4;","20"],
["&#x16e;","&#xc3;","20"],
["&#x16e;","&#xc2;","20"],
["&#x16e;","&#xc1;","20"],
["&#x16e;","&#xc0;","20"],
["&#x16e;","A","20"],
["&#x16e;","&#x2e;","41"],
["&#x16e;","&#x2c;","41"],
["&#x170;","&#x1eb6;","20"],
["&#x170;","&#x1eb4;","20"],
["&#x170;","&#x1eb2;","20"],
["&#x170;","&#x1eb0;","20"],
["&#x170;","&#x1eae;","20"],
["&#x170;","&#x1eac;","20"],
["&#x170;","&#x1eaa;","20"],
["&#x170;","&#x1ea8;","20"],
["&#x170;","&#x1ea6;","20"],
["&#x170;","&#x1ea4;","20"],
["&#x170;","&#x1ea2;","20"],
["&#x170;","&#x1ea0;","20"],
["&#x170;","&#x1e00;","20"],
["&#x170;","&#x201e;","41"],
["&#x170;","&#x201a;","41"],
["&#x170;","&#x1fa;","20"],
["&#x170;","&#x104;","20"],
["&#x170;","&#x102;","20"],
["&#x170;","&#x100;","20"],
["&#x170;","&#xc5;","20"],
["&#x170;","&#xc4;","20"],
["&#x170;","&#xc3;","20"],
["&#x170;","&#xc2;","20"],
["&#x170;","&#xc1;","20"],
["&#x170;","&#xc0;","20"],
["&#x170;","A","20"],
["&#x170;","&#x2e;","41"],
["&#x170;","&#x2c;","41"],
["&#x172;","&#x1eb6;","20"],
["&#x172;","&#x1eb4;","20"],
["&#x172;","&#x1eb2;","20"],
["&#x172;","&#x1eb0;","20"],
["&#x172;","&#x1eae;","20"],
["&#x172;","&#x1eac;","20"],
["&#x172;","&#x1eaa;","20"],
["&#x172;","&#x1ea8;","20"],
["&#x172;","&#x1ea6;","20"],
["&#x172;","&#x1ea4;","20"],
["&#x172;","&#x1ea2;","20"],
["&#x172;","&#x1ea0;","20"],
["&#x172;","&#x1e00;","20"],
["&#x172;","&#x201e;","41"],
["&#x172;","&#x201a;","41"],
["&#x172;","&#x1fa;","20"],
["&#x172;","&#x104;","20"],
["&#x172;","&#x102;","20"],
["&#x172;","&#x100;","20"],
["&#x172;","&#xc5;","20"],
["&#x172;","&#xc4;","20"],
["&#x172;","&#xc3;","20"],
["&#x172;","&#xc2;","20"],
["&#x172;","&#xc1;","20"],
["&#x172;","&#xc0;","20"],
["&#x172;","A","20"],
["&#x172;","&#x2e;","41"],
["&#x172;","&#x2c;","41"],
["&#x174;","&#x1ef1;","20"],
["&#x174;","&#x1eef;","20"],
["&#x174;","&#x1eed;","20"],
["&#x174;","&#x1eeb;","20"],
["&#x174;","&#x1ee9;","20"],
["&#x174;","&#x1ee7;","20"],
["&#x174;","&#x1ee5;","20"],
["&#x174;","&#x1ee3;","41"],
["&#x174;","&#x1ee2;","20"],
["&#x174;","&#x1ee1;","41"],
["&#x174;","&#x1ee0;","20"],
["&#x174;","&#x1edf;","41"],
["&#x174;","&#x1ede;","20"],
["&#x174;","&#x1edd;","41"],
["&#x174;","&#x1edc;","20"],
["&#x174;","&#x1edb;","41"],
["&#x174;","&#x1eda;","20"],
["&#x174;","&#x1ed9;","41"],
["&#x174;","&#x1ed8;","20"],
["&#x174;","&#x1ed7;","41"],
["&#x174;","&#x1ed6;","20"],
["&#x174;","&#x1ed5;","41"],
["&#x174;","&#x1ed4;","20"],
["&#x174;","&#x1ed2;","20"],
["&#x174;","&#x1ed1;","41"],
["&#x174;","&#x1ed0;","20"],
["&#x174;","&#x1ecf;","41"],
["&#x174;","&#x1ece;","20"],
["&#x174;","&#x1ecd;","41"],
["&#x174;","&#x1ecc;","20"],
["&#x174;","&#x1ec7;","41"],
["&#x174;","&#x1ec5;","41"],
["&#x174;","&#x1ec3;","41"],
["&#x174;","&#x1ebf;","41"],
["&#x174;","&#x1ebd;","41"],
["&#x174;","&#x1ebb;","41"],
["&#x174;","&#x1eb9;","41"],
["&#x174;","&#x1eb7;","41"],
["&#x174;","&#x1eb6;","82"],
["&#x174;","&#x1eb5;","41"],
["&#x174;","&#x1eb4;","82"],
["&#x174;","&#x1eb3;","41"],
["&#x174;","&#x1eb2;","82"],
["&#x174;","&#x1eb1;","41"],
["&#x174;","&#x1eb0;","82"],
["&#x174;","&#x1eaf;","41"],
["&#x174;","&#x1eae;","82"],
["&#x174;","&#x1ead;","41"],
["&#x174;","&#x1eac;","82"],
["&#x174;","&#x1eab;","41"],
["&#x174;","&#x1eaa;","82"],
["&#x174;","&#x1ea9;","41"],
["&#x174;","&#x1ea8;","82"],
["&#x174;","&#x1ea6;","82"],
["&#x174;","&#x1ea5;","41"],
["&#x174;","&#x1ea4;","82"],
["&#x174;","&#x1ea3;","41"],
["&#x174;","&#x1ea2;","82"],
["&#x174;","&#x1ea1;","41"],
["&#x174;","&#x1ea0;","82"],
["&#x174;","&#x1b0;","20"],
["&#x174;","&#x1a1;","41"],
["&#x174;","&#x1a0;","20"],
["&#x174;","&#x1e01;","41"],
["&#x174;","&#x1e00;","82"],
["&#x174;","&#x1e3f;","20"],
["&#x174;","&#x201e;","102"],
["&#x174;","&#x201a;","102"],
["&#x174;","&#x219;","20"],
["&#x174;","&#x1ff;","41"],
["&#x174;","&#x1fe;","20"],
["&#x174;","&#x1fd;","41"],
["&#x174;","&#x1fb;","41"],
["&#x174;","&#x1fa;","82"],
["&#x174;","&#x173;","20"],
["&#x174;","&#x171;","20"],
["&#x174;","&#x16f;","20"],
["&#x174;","&#x16d;","20"],
["&#x174;","&#x16b;","20"],
["&#x174;","&#x169;","20"],
["&#x174;","&#x15f;","20"],
["&#x174;","&#x15b;","20"],
["&#x174;","&#x157;","20"],
["&#x174;","&#x155;","20"],
["&#x174;","&#x153;","41"],
["&#x174;","&#x152;","20"],
["&#x174;","&#x151;","41"],
["&#x174;","&#x150;","20"],
["&#x174;","&#x14f;","41"],
["&#x174;","&#x14e;","20"],
["&#x174;","&#x14d;","41"],
["&#x174;","&#x14c;","20"],
["&#x174;","&#x14b;","20"],
["&#x174;","&#x146;","20"],
["&#x174;","&#x144;","20"],
["&#x174;","&#x138;","20"],
["&#x174;","&#x123;","20"],
["&#x174;","&#x122;","20"],
["&#x174;","&#x121;","20"],
["&#x174;","&#x120;","20"],
["&#x174;","&#x11f;","20"],
["&#x174;","&#x11e;","20"],
["&#x174;","&#x11d;","20"],
["&#x174;","&#x11c;","20"],
["&#x174;","&#x11b;","41"],
["&#x174;","&#x119;","41"],
["&#x174;","&#x117;","41"],
["&#x174;","&#x115;","41"],
["&#x174;","&#x113;","41"],
["&#x174;","&#x111;","41"],
["&#x174;","&#x10f;","41"],
["&#x174;","&#x10d;","41"],
["&#x174;","&#x10c;","20"],
["&#x174;","&#x10b;","41"],
["&#x174;","&#x10a;","20"],
["&#x174;","&#x109;","41"],
["&#x174;","&#x108;","20"],
["&#x174;","&#x107;","41"],
["&#x174;","&#x106;","20"],
["&#x174;","&#x105;","41"],
["&#x174;","&#x104;","82"],
["&#x174;","&#x103;","41"],
["&#x174;","&#x102;","82"],
["&#x174;","&#x101;","41"],
["&#x174;","&#x100;","82"],
["&#x174;","&#xfc;","20"],
["&#x174;","&#xfb;","20"],
["&#x174;","&#xfa;","20"],
["&#x174;","&#xf9;","20"],
["&#x174;","&#xf8;","41"],
["&#x174;","&#xf6;","41"],
["&#x174;","&#xf5;","41"],
["&#x174;","&#xf4;","41"],
["&#x174;","&#xf3;","41"],
["&#x174;","&#xf2;","41"],
["&#x174;","&#xeb;","41"],
["&#x174;","&#xea;","41"],
["&#x174;","&#xe9;","41"],
["&#x174;","&#xe8;","41"],
["&#x174;","&#xe7;","41"],
["&#x174;","&#xe6;","41"],
["&#x174;","&#xe5;","41"],
["&#x174;","&#xe4;","41"],
["&#x174;","&#xe3;","41"],
["&#x174;","&#xe2;","41"],
["&#x174;","&#xe1;","41"],
["&#x174;","&#xe0;","41"],
["&#x174;","&#xd8;","20"],
["&#x174;","&#xd6;","20"],
["&#x174;","&#xd5;","20"],
["&#x174;","&#xd4;","20"],
["&#x174;","&#xd3;","20"],
["&#x174;","&#xd2;","20"],
["&#x174;","&#xc7;","20"],
["&#x174;","&#xc5;","82"],
["&#x174;","&#xc4;","82"],
["&#x174;","&#xc3;","82"],
["&#x174;","&#xc2;","82"],
["&#x174;","&#xc1;","82"],
["&#x174;","&#xc0;","82"],
["&#x174;","u","20"],
["&#x174;","s","20"],
["&#x174;","r","20"],
["&#x174;","q","41"],
["&#x174;","p","20"],
["&#x174;","o","41"],
["&#x174;","n","20"],
["&#x174;","m","20"],
["&#x174;","g","20"],
["&#x174;","e","41"],
["&#x174;","d","41"],
["&#x174;","c","41"],
["&#x174;","a","41"],
["&#x174;","Q","20"],
["&#x174;","O","20"],
["&#x174;","G","20"],
["&#x174;","C","20"],
["&#x174;","A","82"],
["&#x174;","&#x3f;","-41"],
["&#x174;","&#x2e;","102"],
["&#x174;","&#x2c;","102"],
["&#x175;","&#x201e;","82"],
["&#x175;","&#x201d;","-82"],
["&#x175;","&#x201a;","82"],
["&#x175;","&#x2019;","-82"],
["&#x175;","&#x3f;","-41"],
["&#x175;","&#x2e;","82"],
["&#x175;","&#x2c;","82"],
["&#x175;","&#x27;","-82"],
["&#x175;","&#x22;","-82"],
["&#x176;","&#x1ef1;","61"],
["&#x176;","&#x1eef;","61"],
["&#x176;","&#x1eed;","61"],
["&#x176;","&#x1eeb;","61"],
["&#x176;","&#x1ee9;","61"],
["&#x176;","&#x1ee7;","61"],
["&#x176;","&#x1ee5;","61"],
["&#x176;","&#x1ee3;","102"],
["&#x176;","&#x1ee2;","41"],
["&#x176;","&#x1ee1;","102"],
["&#x176;","&#x1ee0;","41"],
["&#x176;","&#x1edf;","102"],
["&#x176;","&#x1ede;","41"],
["&#x176;","&#x1edd;","102"],
["&#x176;","&#x1edc;","41"],
["&#x176;","&#x1edb;","102"],
["&#x176;","&#x1eda;","41"],
["&#x176;","&#x1ed9;","102"],
["&#x176;","&#x1ed8;","41"],
["&#x176;","&#x1ed7;","102"],
["&#x176;","&#x1ed6;","41"],
["&#x176;","&#x1ed5;","102"],
["&#x176;","&#x1ed4;","41"],
["&#x176;","&#x1ed2;","41"],
["&#x176;","&#x1ed1;","102"],
["&#x176;","&#x1ed0;","41"],
["&#x176;","&#x1ecf;","102"],
["&#x176;","&#x1ece;","41"],
["&#x176;","&#x1ecd;","102"],
["&#x176;","&#x1ecc;","41"],
["&#x176;","&#x1ec7;","102"],
["&#x176;","&#x1ec5;","102"],
["&#x176;","&#x1ec3;","102"],
["&#x176;","&#x1ebf;","102"],
["&#x176;","&#x1ebd;","102"],
["&#x176;","&#x1ebb;","102"],
["&#x176;","&#x1eb9;","102"],
["&#x176;","&#x1eb7;","102"],
["&#x176;","&#x1eb6;","123"],
["&#x176;","&#x1eb5;","102"],
["&#x176;","&#x1eb4;","123"],
["&#x176;","&#x1eb3;","102"],
["&#x176;","&#x1eb2;","123"],
["&#x176;","&#x1eb1;","102"],
["&#x176;","&#x1eb0;","123"],
["&#x176;","&#x1eaf;","102"],
["&#x176;","&#x1eae;","123"],
["&#x176;","&#x1ead;","102"],
["&#x176;","&#x1eac;","123"],
["&#x176;","&#x1eab;","102"],
["&#x176;","&#x1eaa;","123"],
["&#x176;","&#x1ea9;","102"],
["&#x176;","&#x1ea8;","123"],
["&#x176;","&#x1ea6;","123"],
["&#x176;","&#x1ea5;","102"],
["&#x176;","&#x1ea4;","123"],
["&#x176;","&#x1ea3;","102"],
["&#x176;","&#x1ea2;","123"],
["&#x176;","&#x1ea1;","102"],
["&#x176;","&#x1ea0;","123"],
["&#x176;","&#x1b0;","61"],
["&#x176;","&#x1a1;","102"],
["&#x176;","&#x1a0;","41"],
["&#x176;","&#x1e01;","102"],
["&#x176;","&#x1e00;","123"],
["&#x176;","&#x1e3f;","61"],
["&#x176;","&#x201e;","123"],
["&#x176;","&#x201a;","123"],
["&#x176;","&#x219;","82"],
["&#x176;","&#x1ff;","102"],
["&#x176;","&#x1fe;","41"],
["&#x176;","&#x1fd;","102"],
["&#x176;","&#x1fb;","102"],
["&#x176;","&#x1fa;","123"],
["&#x176;","&#x17e;","41"],
["&#x176;","&#x17c;","41"],
["&#x176;","&#x17a;","41"],
["&#x176;","&#x173;","61"],
["&#x176;","&#x171;","61"],
["&#x176;","&#x16f;","61"],
["&#x176;","&#x16d;","61"],
["&#x176;","&#x16b;","61"],
["&#x176;","&#x169;","61"],
["&#x176;","&#x15f;","82"],
["&#x176;","&#x15b;","82"],
["&#x176;","&#x157;","61"],
["&#x176;","&#x155;","61"],
["&#x176;","&#x153;","102"],
["&#x176;","&#x152;","41"],
["&#x176;","&#x151;","102"],
["&#x176;","&#x150;","41"],
["&#x176;","&#x14f;","102"],
["&#x176;","&#x14e;","41"],
["&#x176;","&#x14d;","102"],
["&#x176;","&#x14c;","41"],
["&#x176;","&#x14b;","61"],
["&#x176;","&#x146;","61"],
["&#x176;","&#x144;","61"],
["&#x176;","&#x138;","61"],
["&#x176;","&#x123;","41"],
["&#x176;","&#x122;","41"],
["&#x176;","&#x121;","41"],
["&#x176;","&#x120;","41"],
["&#x176;","&#x11f;","41"],
["&#x176;","&#x11e;","41"],
["&#x176;","&#x11d;","41"],
["&#x176;","&#x11c;","41"],
["&#x176;","&#x11b;","102"],
["&#x176;","&#x119;","102"],
["&#x176;","&#x117;","102"],
["&#x176;","&#x115;","102"],
["&#x176;","&#x113;","102"],
["&#x176;","&#x111;","102"],
["&#x176;","&#x10f;","102"],
["&#x176;","&#x10d;","102"],
["&#x176;","&#x10c;","41"],
["&#x176;","&#x10b;","102"],
["&#x176;","&#x10a;","41"],
["&#x176;","&#x109;","102"],
["&#x176;","&#x108;","41"],
["&#x176;","&#x107;","102"],
["&#x176;","&#x106;","41"],
["&#x176;","&#x105;","102"],
["&#x176;","&#x104;","123"],
["&#x176;","&#x103;","102"],
["&#x176;","&#x102;","123"],
["&#x176;","&#x101;","102"],
["&#x176;","&#x100;","123"],
["&#x176;","&#xfc;","61"],
["&#x176;","&#xfb;","61"],
["&#x176;","&#xfa;","61"],
["&#x176;","&#xf9;","61"],
["&#x176;","&#xf8;","102"],
["&#x176;","&#xf6;","102"],
["&#x176;","&#xf5;","102"],
["&#x176;","&#xf4;","102"],
["&#x176;","&#xf3;","102"],
["&#x176;","&#xf2;","102"],
["&#x176;","&#xeb;","102"],
["&#x176;","&#xea;","102"],
["&#x176;","&#xe9;","102"],
["&#x176;","&#xe8;","102"],
["&#x176;","&#xe7;","102"],
["&#x176;","&#xe6;","102"],
["&#x176;","&#xe5;","102"],
["&#x176;","&#xe4;","102"],
["&#x176;","&#xe3;","102"],
["&#x176;","&#xe2;","102"],
["&#x176;","&#xe1;","102"],
["&#x176;","&#xe0;","102"],
["&#x176;","&#xd8;","41"],
["&#x176;","&#xd6;","41"],
["&#x176;","&#xd5;","41"],
["&#x176;","&#xd4;","41"],
["&#x176;","&#xd3;","41"],
["&#x176;","&#xd2;","41"],
["&#x176;","&#xc7;","41"],
["&#x176;","&#xc5;","123"],
["&#x176;","&#xc4;","123"],
["&#x176;","&#xc3;","123"],
["&#x176;","&#xc2;","123"],
["&#x176;","&#xc1;","123"],
["&#x176;","&#xc0;","123"],
["&#x176;","z","41"],
["&#x176;","u","61"],
["&#x176;","s","82"],
["&#x176;","r","61"],
["&#x176;","q","102"],
["&#x176;","p","61"],
["&#x176;","o","102"],
["&#x176;","n","61"],
["&#x176;","m","61"],
["&#x176;","g","41"],
["&#x176;","e","102"],
["&#x176;","d","102"],
["&#x176;","c","102"],
["&#x176;","a","102"],
["&#x176;","Q","41"],
["&#x176;","O","41"],
["&#x176;","G","41"],
["&#x176;","C","41"],
["&#x176;","A","123"],
["&#x176;","&#x3f;","-41"],
["&#x176;","&#x2e;","123"],
["&#x176;","&#x2c;","123"],
["&#x177;","&#x201e;","82"],
["&#x177;","&#x201d;","-82"],
["&#x177;","&#x201a;","82"],
["&#x177;","&#x2019;","-82"],
["&#x177;","&#x3f;","-41"],
["&#x177;","&#x2e;","82"],
["&#x177;","&#x2c;","82"],
["&#x177;","&#x27;","-82"],
["&#x177;","&#x22;","-82"],
["&#x178;","&#x1ef1;","61"],
["&#x178;","&#x1eef;","61"],
["&#x178;","&#x1eed;","61"],
["&#x178;","&#x1eeb;","61"],
["&#x178;","&#x1ee9;","61"],
["&#x178;","&#x1ee7;","61"],
["&#x178;","&#x1ee5;","61"],
["&#x178;","&#x1ee3;","102"],
["&#x178;","&#x1ee2;","41"],
["&#x178;","&#x1ee1;","102"],
["&#x178;","&#x1ee0;","41"],
["&#x178;","&#x1edf;","102"],
["&#x178;","&#x1ede;","41"],
["&#x178;","&#x1edd;","102"],
["&#x178;","&#x1edc;","41"],
["&#x178;","&#x1edb;","102"],
["&#x178;","&#x1eda;","41"],
["&#x178;","&#x1ed9;","102"],
["&#x178;","&#x1ed8;","41"],
["&#x178;","&#x1ed7;","102"],
["&#x178;","&#x1ed6;","41"],
["&#x178;","&#x1ed5;","102"],
["&#x178;","&#x1ed4;","41"],
["&#x178;","&#x1ed2;","41"],
["&#x178;","&#x1ed1;","102"],
["&#x178;","&#x1ed0;","41"],
["&#x178;","&#x1ecf;","102"],
["&#x178;","&#x1ece;","41"],
["&#x178;","&#x1ecd;","102"],
["&#x178;","&#x1ecc;","41"],
["&#x178;","&#x1ec7;","102"],
["&#x178;","&#x1ec5;","102"],
["&#x178;","&#x1ec3;","102"],
["&#x178;","&#x1ebf;","102"],
["&#x178;","&#x1ebd;","102"],
["&#x178;","&#x1ebb;","102"],
["&#x178;","&#x1eb9;","102"],
["&#x178;","&#x1eb7;","102"],
["&#x178;","&#x1eb6;","123"],
["&#x178;","&#x1eb5;","102"],
["&#x178;","&#x1eb4;","123"],
["&#x178;","&#x1eb3;","102"],
["&#x178;","&#x1eb2;","123"],
["&#x178;","&#x1eb1;","102"],
["&#x178;","&#x1eb0;","123"],
["&#x178;","&#x1eaf;","102"],
["&#x178;","&#x1eae;","123"],
["&#x178;","&#x1ead;","102"],
["&#x178;","&#x1eac;","123"],
["&#x178;","&#x1eab;","102"],
["&#x178;","&#x1eaa;","123"],
["&#x178;","&#x1ea9;","102"],
["&#x178;","&#x1ea8;","123"],
["&#x178;","&#x1ea6;","123"],
["&#x178;","&#x1ea5;","102"],
["&#x178;","&#x1ea4;","123"],
["&#x178;","&#x1ea3;","102"],
["&#x178;","&#x1ea2;","123"],
["&#x178;","&#x1ea1;","102"],
["&#x178;","&#x1ea0;","123"],
["&#x178;","&#x1b0;","61"],
["&#x178;","&#x1a1;","102"],
["&#x178;","&#x1a0;","41"],
["&#x178;","&#x1e01;","102"],
["&#x178;","&#x1e00;","123"],
["&#x178;","&#x1e3f;","61"],
["&#x178;","&#x201e;","123"],
["&#x178;","&#x201a;","123"],
["&#x178;","&#x219;","82"],
["&#x178;","&#x1ff;","102"],
["&#x178;","&#x1fe;","41"],
["&#x178;","&#x1fd;","102"],
["&#x178;","&#x1fb;","102"],
["&#x178;","&#x1fa;","123"],
["&#x178;","&#x17e;","41"],
["&#x178;","&#x17c;","41"],
["&#x178;","&#x17a;","41"],
["&#x178;","&#x173;","61"],
["&#x178;","&#x171;","61"],
["&#x178;","&#x16f;","61"],
["&#x178;","&#x16d;","61"],
["&#x178;","&#x16b;","61"],
["&#x178;","&#x169;","61"],
["&#x178;","&#x15f;","82"],
["&#x178;","&#x15b;","82"],
["&#x178;","&#x157;","61"],
["&#x178;","&#x155;","61"],
["&#x178;","&#x153;","102"],
["&#x178;","&#x152;","41"],
["&#x178;","&#x151;","102"],
["&#x178;","&#x150;","41"],
["&#x178;","&#x14f;","102"],
["&#x178;","&#x14e;","41"],
["&#x178;","&#x14d;","102"],
["&#x178;","&#x14c;","41"],
["&#x178;","&#x14b;","61"],
["&#x178;","&#x146;","61"],
["&#x178;","&#x144;","61"],
["&#x178;","&#x138;","61"],
["&#x178;","&#x123;","41"],
["&#x178;","&#x122;","41"],
["&#x178;","&#x121;","41"],
["&#x178;","&#x120;","41"],
["&#x178;","&#x11f;","41"],
["&#x178;","&#x11e;","41"],
["&#x178;","&#x11d;","41"],
["&#x178;","&#x11c;","41"],
["&#x178;","&#x11b;","102"],
["&#x178;","&#x119;","102"],
["&#x178;","&#x117;","102"],
["&#x178;","&#x115;","102"],
["&#x178;","&#x113;","102"],
["&#x178;","&#x111;","102"],
["&#x178;","&#x10f;","102"],
["&#x178;","&#x10d;","102"],
["&#x178;","&#x10c;","41"],
["&#x178;","&#x10b;","102"],
["&#x178;","&#x10a;","41"],
["&#x178;","&#x109;","102"],
["&#x178;","&#x108;","41"],
["&#x178;","&#x107;","102"],
["&#x178;","&#x106;","41"],
["&#x178;","&#x105;","102"],
["&#x178;","&#x104;","123"],
["&#x178;","&#x103;","102"],
["&#x178;","&#x102;","123"],
["&#x178;","&#x101;","102"],
["&#x178;","&#x100;","123"],
["&#x178;","&#xfc;","61"],
["&#x178;","&#xfb;","61"],
["&#x178;","&#xfa;","61"],
["&#x178;","&#xf9;","61"],
["&#x178;","&#xf8;","102"],
["&#x178;","&#xf6;","102"],
["&#x178;","&#xf5;","102"],
["&#x178;","&#xf4;","102"],
["&#x178;","&#xf3;","102"],
["&#x178;","&#xf2;","102"],
["&#x178;","&#xeb;","102"],
["&#x178;","&#xea;","102"],
["&#x178;","&#xe9;","102"],
["&#x178;","&#xe8;","102"],
["&#x178;","&#xe7;","102"],
["&#x178;","&#xe6;","102"],
["&#x178;","&#xe5;","102"],
["&#x178;","&#xe4;","102"],
["&#x178;","&#xe3;","102"],
["&#x178;","&#xe2;","102"],
["&#x178;","&#xe1;","102"],
["&#x178;","&#xe0;","102"],
["&#x178;","&#xd8;","41"],
["&#x178;","&#xd6;","41"],
["&#x178;","&#xd5;","41"],
["&#x178;","&#xd4;","41"],
["&#x178;","&#xd3;","41"],
["&#x178;","&#xd2;","41"],
["&#x178;","&#xc7;","41"],
["&#x178;","&#xc5;","123"],
["&#x178;","&#xc4;","123"],
["&#x178;","&#xc3;","123"],
["&#x178;","&#xc2;","123"],
["&#x178;","&#xc1;","123"],
["&#x178;","&#xc0;","123"],
["&#x178;","z","41"],
["&#x178;","u","61"],
["&#x178;","s","82"],
["&#x178;","r","61"],
["&#x178;","q","102"],
["&#x178;","p","61"],
["&#x178;","o","102"],
["&#x178;","n","61"],
["&#x178;","m","61"],
["&#x178;","g","41"],
["&#x178;","e","102"],
["&#x178;","d","102"],
["&#x178;","c","102"],
["&#x178;","a","102"],
["&#x178;","Q","41"],
["&#x178;","O","41"],
["&#x178;","G","41"],
["&#x178;","C","41"],
["&#x178;","A","123"],
["&#x178;","&#x3f;","-41"],
["&#x178;","&#x2e;","123"],
["&#x178;","&#x2c;","123"],
["&#x179;","&#x1ee2;","20"],
["&#x179;","&#x1ee0;","20"],
["&#x179;","&#x1ede;","20"],
["&#x179;","&#x1edc;","20"],
["&#x179;","&#x1eda;","20"],
["&#x179;","&#x1ed8;","20"],
["&#x179;","&#x1ed6;","20"],
["&#x179;","&#x1ed4;","20"],
["&#x179;","&#x1ed2;","20"],
["&#x179;","&#x1ed0;","20"],
["&#x179;","&#x1ece;","20"],
["&#x179;","&#x1ecc;","20"],
["&#x179;","&#x1a0;","20"],
["&#x179;","&#x1fe;","20"],
["&#x179;","&#x152;","20"],
["&#x179;","&#x150;","20"],
["&#x179;","&#x14e;","20"],
["&#x179;","&#x14c;","20"],
["&#x179;","&#x122;","20"],
["&#x179;","&#x120;","20"],
["&#x179;","&#x11e;","20"],
["&#x179;","&#x11c;","20"],
["&#x179;","&#x10c;","20"],
["&#x179;","&#x10a;","20"],
["&#x179;","&#x108;","20"],
["&#x179;","&#x106;","20"],
["&#x179;","&#xd8;","20"],
["&#x179;","&#xd6;","20"],
["&#x179;","&#xd5;","20"],
["&#x179;","&#xd4;","20"],
["&#x179;","&#xd3;","20"],
["&#x179;","&#xd2;","20"],
["&#x179;","&#xc7;","20"],
["&#x179;","Q","20"],
["&#x179;","O","20"],
["&#x179;","G","20"],
["&#x179;","C","20"],
["&#x17b;","&#x1ee2;","20"],
["&#x17b;","&#x1ee0;","20"],
["&#x17b;","&#x1ede;","20"],
["&#x17b;","&#x1edc;","20"],
["&#x17b;","&#x1eda;","20"],
["&#x17b;","&#x1ed8;","20"],
["&#x17b;","&#x1ed6;","20"],
["&#x17b;","&#x1ed4;","20"],
["&#x17b;","&#x1ed2;","20"],
["&#x17b;","&#x1ed0;","20"],
["&#x17b;","&#x1ece;","20"],
["&#x17b;","&#x1ecc;","20"],
["&#x17b;","&#x1a0;","20"],
["&#x17b;","&#x1fe;","20"],
["&#x17b;","&#x152;","20"],
["&#x17b;","&#x150;","20"],
["&#x17b;","&#x14e;","20"],
["&#x17b;","&#x14c;","20"],
["&#x17b;","&#x122;","20"],
["&#x17b;","&#x120;","20"],
["&#x17b;","&#x11e;","20"],
["&#x17b;","&#x11c;","20"],
["&#x17b;","&#x10c;","20"],
["&#x17b;","&#x10a;","20"],
["&#x17b;","&#x108;","20"],
["&#x17b;","&#x106;","20"],
["&#x17b;","&#xd8;","20"],
["&#x17b;","&#xd6;","20"],
["&#x17b;","&#xd5;","20"],
["&#x17b;","&#xd4;","20"],
["&#x17b;","&#xd3;","20"],
["&#x17b;","&#xd2;","20"],
["&#x17b;","&#xc7;","20"],
["&#x17b;","Q","20"],
["&#x17b;","O","20"],
["&#x17b;","G","20"],
["&#x17b;","C","20"],
["&#x17d;","&#x1ee2;","20"],
["&#x17d;","&#x1ee0;","20"],
["&#x17d;","&#x1ede;","20"],
["&#x17d;","&#x1edc;","20"],
["&#x17d;","&#x1eda;","20"],
["&#x17d;","&#x1ed8;","20"],
["&#x17d;","&#x1ed6;","20"],
["&#x17d;","&#x1ed4;","20"],
["&#x17d;","&#x1ed2;","20"],
["&#x17d;","&#x1ed0;","20"],
["&#x17d;","&#x1ece;","20"],
["&#x17d;","&#x1ecc;","20"],
["&#x17d;","&#x1a0;","20"],
["&#x17d;","&#x1fe;","20"],
["&#x17d;","&#x152;","20"],
["&#x17d;","&#x150;","20"],
["&#x17d;","&#x14e;","20"],
["&#x17d;","&#x14c;","20"],
["&#x17d;","&#x122;","20"],
["&#x17d;","&#x120;","20"],
["&#x17d;","&#x11e;","20"],
["&#x17d;","&#x11c;","20"],
["&#x17d;","&#x10c;","20"],
["&#x17d;","&#x10a;","20"],
["&#x17d;","&#x108;","20"],
["&#x17d;","&#x106;","20"],
["&#x17d;","&#xd8;","20"],
["&#x17d;","&#xd6;","20"],
["&#x17d;","&#xd5;","20"],
["&#x17d;","&#xd4;","20"],
["&#x17d;","&#xd3;","20"],
["&#x17d;","&#xd2;","20"],
["&#x17d;","&#xc7;","20"],
["&#x17d;","Q","20"],
["&#x17d;","O","20"],
["&#x17d;","G","20"],
["&#x17d;","C","20"],
["&#x1fa;","&#x162;","143"],
["&#x1fa;","&#x1ef8;","123"],
["&#x1fa;","&#x1ef6;","123"],
["&#x1fa;","&#x1ef4;","123"],
["&#x1fa;","&#x1ee2;","41"],
["&#x1fa;","&#x1ee0;","41"],
["&#x1fa;","&#x1ede;","41"],
["&#x1fa;","&#x1edc;","41"],
["&#x1fa;","&#x1eda;","41"],
["&#x1fa;","&#x1ed8;","41"],
["&#x1fa;","&#x1ed6;","41"],
["&#x1fa;","&#x1ed4;","41"],
["&#x1fa;","&#x1ed2;","41"],
["&#x1fa;","&#x1ed0;","41"],
["&#x1fa;","&#x1ece;","41"],
["&#x1fa;","&#x1ecc;","41"],
["&#x1fa;","&#x1a0;","41"],
["&#x1fa;","&#x201d;","143"],
["&#x1fa;","&#x2019;","143"],
["&#x1fa;","&#x1ef2;","123"],
["&#x1fa;","&#x1e84;","82"],
["&#x1fa;","&#x1e82;","82"],
["&#x1fa;","&#x1e80;","82"],
["&#x1fa;","&#x1fe;","41"],
["&#x1fa;","&#x178;","123"],
["&#x1fa;","&#x176;","123"],
["&#x1fa;","&#x174;","82"],
["&#x1fa;","&#x164;","143"],
["&#x1fa;","&#x21a;","143"],
["&#x1fa;","&#x152;","41"],
["&#x1fa;","&#x150;","41"],
["&#x1fa;","&#x14e;","41"],
["&#x1fa;","&#x14c;","41"],
["&#x1fa;","&#x122;","41"],
["&#x1fa;","&#x120;","41"],
["&#x1fa;","&#x11e;","41"],
["&#x1fa;","&#x11c;","41"],
["&#x1fa;","&#x10c;","41"],
["&#x1fa;","&#x10a;","41"],
["&#x1fa;","&#x108;","41"],
["&#x1fa;","&#x106;","41"],
["&#x1fa;","&#xdd;","123"],
["&#x1fa;","&#xd8;","41"],
["&#x1fa;","&#xd6;","41"],
["&#x1fa;","&#xd5;","41"],
["&#x1fa;","&#xd4;","41"],
["&#x1fa;","&#xd3;","41"],
["&#x1fa;","&#xd2;","41"],
["&#x1fa;","&#xc7;","41"],
["&#x1fa;","Y","123"],
["&#x1fa;","W","82"],
["&#x1fa;","V","82"],
["&#x1fa;","T","143"],
["&#x1fa;","Q","41"],
["&#x1fa;","O","41"],
["&#x1fa;","J","-266"],
["&#x1fa;","G","41"],
["&#x1fa;","C","41"],
["&#x1fa;","&#x27;","143"],
["&#x1fa;","&#x22;","143"],
["&#x1fb;","&#x201d;","20"],
["&#x1fb;","&#x2019;","20"],
["&#x1fb;","&#x27;","20"],
["&#x1fb;","&#x22;","20"],
["&#x1fc;","J","-123"],
["&#x1fe;","&#x162;","61"],
["&#x1fe;","&#x1ef8;","20"],
["&#x1fe;","&#x1ef6;","20"],
["&#x1fe;","&#x1ef4;","20"],
["&#x1fe;","&#x1eb6;","41"],
["&#x1fe;","&#x1eb4;","41"],
["&#x1fe;","&#x1eb2;","41"],
["&#x1fe;","&#x1eb0;","41"],
["&#x1fe;","&#x1eae;","41"],
["&#x1fe;","&#x1eac;","41"],
["&#x1fe;","&#x1eaa;","41"],
["&#x1fe;","&#x1ea8;","41"],
["&#x1fe;","&#x1ea6;","41"],
["&#x1fe;","&#x1ea4;","41"],
["&#x1fe;","&#x1ea2;","41"],
["&#x1fe;","&#x1ea0;","41"],
["&#x1fe;","&#x1e00;","41"],
["&#x1fe;","&#x201e;","82"],
["&#x1fe;","&#x201a;","82"],
["&#x1fe;","&#x1ef2;","20"],
["&#x1fe;","&#x1e84;","20"],
["&#x1fe;","&#x1e82;","20"],
["&#x1fe;","&#x1e80;","20"],
["&#x1fe;","&#x405;","20"],
["&#x1fe;","&#x1fa;","41"],
["&#x1fe;","&#x17d;","20"],
["&#x1fe;","&#x17b;","20"],
["&#x1fe;","&#x179;","20"],
["&#x1fe;","&#x178;","20"],
["&#x1fe;","&#x176;","20"],
["&#x1fe;","&#x174;","20"],
["&#x1fe;","&#x164;","61"],
["&#x1fe;","&#x21a;","61"],
["&#x1fe;","&#x104;","41"],
["&#x1fe;","&#x102;","41"],
["&#x1fe;","&#x100;","41"],
["&#x1fe;","&#xdd;","20"],
["&#x1fe;","&#xc5;","41"],
["&#x1fe;","&#xc4;","41"],
["&#x1fe;","&#xc3;","41"],
["&#x1fe;","&#xc2;","41"],
["&#x1fe;","&#xc1;","41"],
["&#x1fe;","&#xc0;","41"],
["&#x1fe;","Z","20"],
["&#x1fe;","Y","20"],
["&#x1fe;","X","41"],
["&#x1fe;","W","20"],
["&#x1fe;","V","20"],
["&#x1fe;","T","61"],
["&#x1fe;","A","41"],
["&#x1fe;","&#x2e;","82"],
["&#x1fe;","&#x2c;","82"],
["&#x386;","&#x3d2;","123"],
["&#x386;","&#x201d;","143"],
["&#x386;","&#x2019;","143"],
["&#x386;","&#x3ab;","123"],
["&#x386;","&#x3a8;","82"],
["&#x386;","&#x3a6;","41"],
["&#x386;","&#x3a5;","123"],
["&#x386;","&#x3a4;","143"],
["&#x386;","&#x39f;","41"],
["&#x386;","&#x398;","41"],
["&#x386;","&#x27;","143"],
["&#x386;","&#x22;","143"],
["&#x38c;","&#x3d2;","20"],
["&#x38c;","&#x201e;","82"],
["&#x38c;","&#x201a;","82"],
["&#x38c;","&#x3bb;","20"],
["&#x38c;","&#x3ab;","20"],
["&#x38c;","&#x3a8;","20"],
["&#x38c;","&#x3a7;","41"],
["&#x38c;","&#x3a5;","20"],
["&#x38c;","&#x3a4;","61"],
["&#x38c;","&#x3a3;","20"],
["&#x38c;","&#x39b;","41"],
["&#x38c;","&#x396;","20"],
["&#x38c;","&#x394;","41"],
["&#x38c;","&#x391;","41"],
["&#x38c;","&#x386;","41"],
["&#x38c;","&#x2e;","82"],
["&#x38c;","&#x2c;","82"],
["&#x38e;","&#x2126;","20"],
["&#x38e;","&#x201e;","123"],
["&#x38e;","&#x201a;","123"],
["&#x38e;","&#x3ce;","61"],
["&#x38e;","&#x3cd;","61"],
["&#x38e;","&#x3cc;","102"],
["&#x38e;","&#x3cb;","61"],
["&#x38e;","&#x3c9;","61"],
["&#x38e;","&#x3c8;","61"],
["&#x38e;","&#x3c6;","102"],
["&#x38e;","&#x3c5;","61"],
["&#x38e;","&#x3c3;","102"],
["&#x38e;","&#x3c2;","102"],
["&#x38e;","&#x3c1;","102"],
["&#x38e;","&#x3bf;","102"],
["&#x38e;","&#x3bc;","61"],
["&#x38e;","&#x3ba;","61"],
["&#x38e;","&#x3b9;","61"],
["&#x38e;","&#x3b7;","61"],
["&#x38e;","&#x3b5;","82"],
["&#x38e;","&#x3b4;","61"],
["&#x38e;","&#x3b1;","102"],
["&#x38e;","&#x3b0;","61"],
["&#x38e;","&#x3af;","61"],
["&#x38e;","&#x3ae;","61"],
["&#x38e;","&#x3ad;","82"],
["&#x38e;","&#x3ac;","102"],
["&#x38e;","&#x3a9;","20"],
["&#x38e;","&#x3a6;","61"],
["&#x38e;","&#x39f;","41"],
["&#x38e;","&#x39b;","123"],
["&#x38e;","&#x398;","41"],
["&#x38e;","&#x394;","123"],
["&#x38e;","&#x391;","123"],
["&#x38e;","&#x386;","123"],
["&#x38e;","&#x2e;","123"],
["&#x38e;","&#x2c;","123"],
["&#x38f;","&#x3d2;","20"],
["&#x38f;","&#x3ab;","20"],
["&#x38f;","&#x3a5;","20"],
["&#x38f;","&#x3a4;","41"],
["&#x390;","&#x201d;","41"],
["&#x390;","&#x2019;","41"],
["&#x390;","&#x27;","41"],
["&#x390;","&#x22;","41"],
["&#x391;","&#x3d2;","123"],
["&#x391;","&#x201d;","143"],
["&#x391;","&#x2019;","143"],
["&#x391;","&#x3ab;","123"],
["&#x391;","&#x3a8;","82"],
["&#x391;","&#x3a6;","41"],
["&#x391;","&#x3a5;","123"],
["&#x391;","&#x3a4;","143"],
["&#x391;","&#x39f;","41"],
["&#x391;","&#x398;","41"],
["&#x391;","&#x27;","143"],
["&#x391;","&#x22;","143"],
["&#x392;","&#x201e;","82"],
["&#x392;","&#x201a;","82"],
["&#x392;","&#x3a7;","41"],
["&#x392;","&#x39b;","41"],
["&#x392;","&#x394;","41"],
["&#x392;","&#x391;","41"],
["&#x392;","&#x386;","41"],
["&#x392;","&#x2e;","82"],
["&#x392;","&#x2c;","82"],
["&#x393;","&#x3d1;","41"],
["&#x393;","&#x2126;","61"],
["&#x393;","&#x201e;","123"],
["&#x393;","&#x201a;","123"],
["&#x393;","&#x2015;","82"],
["&#x393;","&#x2014;","82"],
["&#x393;","&#x2013;","82"],
["&#x393;","&#x3ce;","102"],
["&#x393;","&#x3cd;","102"],
["&#x393;","&#x3cc;","143"],
["&#x393;","&#x3cb;","102"],
["&#x393;","&#x3c9;","102"],
["&#x393;","&#x3c8;","102"],
["&#x393;","&#x3c7;","41"],
["&#x393;","&#x3c6;","143"],
["&#x393;","&#x3c5;","102"],
["&#x393;","&#x3c3;","143"],
["&#x393;","&#x3c2;","143"],
["&#x393;","&#x3c1;","102"],
["&#x393;","&#x3bf;","143"],
["&#x393;","&#x3bd;","41"],
["&#x393;","&#x3bc;","102"],
["&#x393;","&#x3ba;","102"],
["&#x393;","&#x3b9;","82"],
["&#x393;","&#x3b7;","102"],
["&#x393;","&#x3b5;","102"],
["&#x393;","&#x3b4;","61"],
["&#x393;","&#x3b3;","41"],
["&#x393;","&#x3b1;","143"],
["&#x393;","&#x3b0;","102"],
["&#x393;","&#x3af;","82"],
["&#x393;","&#x3ae;","102"],
["&#x393;","&#x3ad;","102"],
["&#x393;","&#x3ac;","143"],
["&#x393;","&#x3a9;","61"],
["&#x393;","&#x3a6;","102"],
["&#x393;","&#x39f;","61"],
["&#x393;","&#x39b;","164"],
["&#x393;","&#x398;","61"],
["&#x393;","&#x394;","164"],
["&#x393;","&#x391;","164"],
["&#x393;","&#x386;","164"],
["&#x393;","&#x2e;","123"],
["&#x393;","&#x2d;","82"],
["&#x393;","&#x2c;","123"],
["&#x394;","&#x3d2;","123"],
["&#x394;","&#x201d;","143"],
["&#x394;","&#x2019;","143"],
["&#x394;","&#x3ab;","123"],
["&#x394;","&#x3a8;","82"],
["&#x394;","&#x3a6;","41"],
["&#x394;","&#x3a5;","123"],
["&#x394;","&#x3a4;","143"],
["&#x394;","&#x39f;","41"],
["&#x394;","&#x398;","41"],
["&#x394;","&#x27;","143"],
["&#x394;","&#x22;","143"],
["&#x396;","&#x3a6;","61"],
["&#x396;","&#x39f;","20"],
["&#x396;","&#x398;","20"],
["&#x398;","&#x3d2;","20"],
["&#x398;","&#x201e;","82"],
["&#x398;","&#x201a;","82"],
["&#x398;","&#x3bb;","20"],
["&#x398;","&#x3ab;","20"],
["&#x398;","&#x3a8;","20"],
["&#x398;","&#x3a7;","41"],
["&#x398;","&#x3a5;","20"],
["&#x398;","&#x3a4;","61"],
["&#x398;","&#x3a3;","20"],
["&#x398;","&#x39b;","41"],
["&#x398;","&#x396;","20"],
["&#x398;","&#x394;","41"],
["&#x398;","&#x391;","41"],
["&#x398;","&#x386;","41"],
["&#x398;","&#x2e;","82"],
["&#x398;","&#x2c;","82"],
["&#x39a;","&#x3c4;","20"],
["&#x39a;","&#x3c0;","20"],
["&#x39a;","&#x3a6;","61"],
["&#x39a;","&#x39f;","41"],
["&#x39a;","&#x398;","41"],
["&#x39b;","&#x3d2;","123"],
["&#x39b;","&#x201d;","143"],
["&#x39b;","&#x2019;","143"],
["&#x39b;","&#x3ab;","123"],
["&#x39b;","&#x3a8;","82"],
["&#x39b;","&#x3a6;","41"],
["&#x39b;","&#x3a5;","123"],
["&#x39b;","&#x3a4;","143"],
["&#x39b;","&#x39f;","41"],
["&#x39b;","&#x398;","41"],
["&#x39b;","&#x27;","143"],
["&#x39b;","&#x22;","143"],
["&#x39f;","&#x3d2;","20"],
["&#x39f;","&#x201e;","82"],
["&#x39f;","&#x201a;","82"],
["&#x39f;","&#x3bb;","20"],
["&#x39f;","&#x3ab;","20"],
["&#x39f;","&#x3a8;","20"],
["&#x39f;","&#x3a7;","41"],
["&#x39f;","&#x3a5;","20"],
["&#x39f;","&#x3a4;","61"],
["&#x39f;","&#x3a3;","20"],
["&#x39f;","&#x39b;","41"],
["&#x39f;","&#x396;","20"],
["&#x39f;","&#x394;","41"],
["&#x39f;","&#x391;","41"],
["&#x39f;","&#x386;","41"],
["&#x39f;","&#x2e;","82"],
["&#x39f;","&#x2c;","82"],
["&#x3a1;","&#x201e;","266"],
["&#x3a1;","&#x201a;","266"],
["&#x3a1;","&#x3bb;","41"],
["&#x3a1;","&#x3a7;","41"],
["&#x3a1;","&#x39b;","102"],
["&#x3a1;","&#x396;","20"],
["&#x3a1;","&#x394;","102"],
["&#x3a1;","&#x391;","102"],
["&#x3a1;","&#x386;","102"],
["&#x3a1;","&#x2e;","266"],
["&#x3a1;","&#x2c;","266"],
["&#x3a4;","&#x3d1;","41"],
["&#x3a4;","&#x2126;","61"],
["&#x3a4;","&#x201e;","123"],
["&#x3a4;","&#x201a;","123"],
["&#x3a4;","&#x2015;","82"],
["&#x3a4;","&#x2014;","82"],
["&#x3a4;","&#x2013;","82"],
["&#x3a4;","&#x3ce;","102"],
["&#x3a4;","&#x3cd;","102"],
["&#x3a4;","&#x3cc;","143"],
["&#x3a4;","&#x3cb;","102"],
["&#x3a4;","&#x3c9;","102"],
["&#x3a4;","&#x3c8;","102"],
["&#x3a4;","&#x3c7;","41"],
["&#x3a4;","&#x3c6;","143"],
["&#x3a4;","&#x3c5;","102"],
["&#x3a4;","&#x3c3;","143"],
["&#x3a4;","&#x3c2;","143"],
["&#x3a4;","&#x3c1;","102"],
["&#x3a4;","&#x3bf;","143"],
["&#x3a4;","&#x3bd;","41"],
["&#x3a4;","&#x3bc;","102"],
["&#x3a4;","&#x3ba;","102"],
["&#x3a4;","&#x3b9;","82"],
["&#x3a4;","&#x3b7;","102"],
["&#x3a4;","&#x3b5;","102"],
["&#x3a4;","&#x3b4;","61"],
["&#x3a4;","&#x3b3;","41"],
["&#x3a4;","&#x3b1;","143"],
["&#x3a4;","&#x3b0;","102"],
["&#x3a4;","&#x3af;","82"],
["&#x3a4;","&#x3ae;","102"],
["&#x3a4;","&#x3ad;","102"],
["&#x3a4;","&#x3ac;","143"],
["&#x3a4;","&#x3a9;","61"],
["&#x3a4;","&#x3a6;","102"],
["&#x3a4;","&#x39f;","61"],
["&#x3a4;","&#x39b;","164"],
["&#x3a4;","&#x398;","61"],
["&#x3a4;","&#x394;","164"],
["&#x3a4;","&#x391;","164"],
["&#x3a4;","&#x386;","164"],
["&#x3a4;","&#x2e;","123"],
["&#x3a4;","&#x2d;","82"],
["&#x3a4;","&#x2c;","123"],
["&#x3a5;","&#x2126;","20"],
["&#x3a5;","&#x201e;","123"],
["&#x3a5;","&#x201a;","123"],
["&#x3a5;","&#x3ce;","61"],
["&#x3a5;","&#x3cd;","61"],
["&#x3a5;","&#x3cc;","102"],
["&#x3a5;","&#x3cb;","61"],
["&#x3a5;","&#x3c9;","61"],
["&#x3a5;","&#x3c8;","61"],
["&#x3a5;","&#x3c6;","102"],
["&#x3a5;","&#x3c5;","61"],
["&#x3a5;","&#x3c3;","102"],
["&#x3a5;","&#x3c2;","102"],
["&#x3a5;","&#x3c1;","102"],
["&#x3a5;","&#x3bf;","102"],
["&#x3a5;","&#x3bc;","61"],
["&#x3a5;","&#x3ba;","61"],
["&#x3a5;","&#x3b9;","61"],
["&#x3a5;","&#x3b7;","61"],
["&#x3a5;","&#x3b5;","82"],
["&#x3a5;","&#x3b4;","61"],
["&#x3a5;","&#x3b1;","102"],
["&#x3a5;","&#x3b0;","61"],
["&#x3a5;","&#x3af;","61"],
["&#x3a5;","&#x3ae;","61"],
["&#x3a5;","&#x3ad;","82"],
["&#x3a5;","&#x3ac;","102"],
["&#x3a5;","&#x3a9;","20"],
["&#x3a5;","&#x3a6;","61"],
["&#x3a5;","&#x39f;","41"],
["&#x3a5;","&#x39b;","123"],
["&#x3a5;","&#x398;","41"],
["&#x3a5;","&#x394;","123"],
["&#x3a5;","&#x391;","123"],
["&#x3a5;","&#x386;","123"],
["&#x3a5;","&#x2e;","123"],
["&#x3a5;","&#x2c;","123"],
["&#x3a6;","&#x3d2;","61"],
["&#x3a6;","&#x201e;","102"],
["&#x3a6;","&#x201a;","102"],
["&#x3a6;","&#x3bb;","20"],
["&#x3a6;","&#x3ab;","61"],
["&#x3a6;","&#x3a7;","20"],
["&#x3a6;","&#x3a5;","61"],
["&#x3a6;","&#x3a4;","82"],
["&#x3a6;","&#x3a3;","20"],
["&#x3a6;","&#x39b;","41"],
["&#x3a6;","&#x396;","61"],
["&#x3a6;","&#x394;","41"],
["&#x3a6;","&#x391;","41"],
["&#x3a6;","&#x386;","41"],
["&#x3a6;","&#x2e;","102"],
["&#x3a6;","&#x2c;","102"],
["&#x3a7;","&#x3c4;","20"],
["&#x3a7;","&#x3c0;","20"],
["&#x3a7;","&#x3a6;","61"],
["&#x3a7;","&#x39f;","41"],
["&#x3a7;","&#x398;","41"],
["&#x3a8;","&#x201e;","123"],
["&#x3a8;","&#x201a;","123"],
["&#x3a8;","&#x39f;","20"],
["&#x3a8;","&#x39b;","82"],
["&#x3a8;","&#x398;","20"],
["&#x3a8;","&#x394;","82"],
["&#x3a8;","&#x391;","82"],
["&#x3a8;","&#x386;","82"],
["&#x3a8;","&#x2e;","123"],
["&#x3a8;","&#x2c;","123"],
["&#x3a9;","&#x3d2;","20"],
["&#x3a9;","&#x3ab;","20"],
["&#x3a9;","&#x3a5;","20"],
["&#x3a9;","&#x3a4;","41"],
["&#x3ab;","&#x2126;","20"],
["&#x3ab;","&#x201e;","123"],
["&#x3ab;","&#x201a;","123"],
["&#x3ab;","&#x3ce;","61"],
["&#x3ab;","&#x3cd;","61"],
["&#x3ab;","&#x3cc;","102"],
["&#x3ab;","&#x3cb;","61"],
["&#x3ab;","&#x3c9;","61"],
["&#x3ab;","&#x3c8;","61"],
["&#x3ab;","&#x3c6;","102"],
["&#x3ab;","&#x3c5;","61"],
["&#x3ab;","&#x3c3;","102"],
["&#x3ab;","&#x3c2;","102"],
["&#x3ab;","&#x3c1;","102"],
["&#x3ab;","&#x3bf;","102"],
["&#x3ab;","&#x3bc;","61"],
["&#x3ab;","&#x3ba;","61"],
["&#x3ab;","&#x3b9;","61"],
["&#x3ab;","&#x3b7;","61"],
["&#x3ab;","&#x3b5;","82"],
["&#x3ab;","&#x3b4;","61"],
["&#x3ab;","&#x3b1;","102"],
["&#x3ab;","&#x3b0;","61"],
["&#x3ab;","&#x3af;","61"],
["&#x3ab;","&#x3ae;","61"],
["&#x3ab;","&#x3ad;","82"],
["&#x3ab;","&#x3ac;","102"],
["&#x3ab;","&#x3a9;","20"],
["&#x3ab;","&#x3a6;","61"],
["&#x3ab;","&#x39f;","41"],
["&#x3ab;","&#x39b;","123"],
["&#x3ab;","&#x398;","41"],
["&#x3ab;","&#x394;","123"],
["&#x3ab;","&#x391;","123"],
["&#x3ab;","&#x386;","123"],
["&#x3ab;","&#x2e;","123"],
["&#x3ab;","&#x2c;","123"],
["&#x3ac;","&#x3bb;","-41"],
["&#x3ae;","&#x201d;","20"],
["&#x3ae;","&#x2019;","20"],
["&#x3ae;","&#x27;","20"],
["&#x3ae;","&#x22;","20"],
["&#x3af;","&#x201d;","82"],
["&#x3af;","&#x2019;","82"],
["&#x3af;","&#x3c4;","20"],
["&#x3af;","&#x3c0;","20"],
["&#x3af;","&#x27;","82"],
["&#x3af;","&#x22;","82"],
["&#x3b1;","&#x3bb;","-41"],
["&#x3b3;","&#x201e;","82"],
["&#x3b3;","&#x201a;","82"],
["&#x3b3;","&#x3bb;","20"],
["&#x3b3;","&#x2e;","82"],
["&#x3b3;","&#x2c;","82"],
["&#x3b6;","&#x2015;","102"],
["&#x3b6;","&#x2014;","102"],
["&#x3b6;","&#x2013;","102"],
["&#x3b6;","&#x3cc;","41"],
["&#x3b6;","&#x3c6;","41"],
["&#x3b6;","&#x3c4;","41"],
["&#x3b6;","&#x3c3;","41"],
["&#x3b6;","&#x3c2;","41"],
["&#x3b6;","&#x3c0;","41"],
["&#x3b6;","&#x3bf;","41"],
["&#x3b6;","&#x3b4;","41"],
["&#x3b6;","&#x3b1;","41"],
["&#x3b6;","&#x3ac;","41"],
["&#x3b6;","&#x2d;","102"],
["&#x3b7;","&#x201d;","20"],
["&#x3b7;","&#x2019;","20"],
["&#x3b7;","&#x27;","20"],
["&#x3b7;","&#x22;","20"],
["&#x3b8;","&#x201e;","41"],
["&#x3b8;","&#x201a;","41"],
["&#x3b8;","&#x2e;","41"],
["&#x3b8;","&#x2c;","41"],
["&#x3b9;","&#x201d;","82"],
["&#x3b9;","&#x2019;","82"],
["&#x3b9;","&#x3c4;","20"],
["&#x3b9;","&#x3c0;","20"],
["&#x3b9;","&#x27;","82"],
["&#x3b9;","&#x22;","82"],
["&#x3ba;","&#x3cc;","41"],
["&#x3ba;","&#x3c6;","41"],
["&#x3ba;","&#x3c3;","41"],
["&#x3ba;","&#x3c2;","41"],
["&#x3ba;","&#x3bf;","41"],
["&#x3ba;","&#x3b1;","41"],
["&#x3ba;","&#x3ac;","41"],
["&#x3bb;","&#x201d;","123"],
["&#x3bb;","&#x2019;","123"],
["&#x3bb;","&#x3cc;","20"],
["&#x3bb;","&#x3c6;","20"],
["&#x3bb;","&#x3c4;","41"],
["&#x3bb;","&#x3c3;","20"],
["&#x3bb;","&#x3c2;","20"],
["&#x3bb;","&#x3c0;","41"],
["&#x3bb;","&#x3bf;","20"],
["&#x3bb;","&#x3bd;","41"],
["&#x3bb;","&#x3b3;","41"],
["&#x3bb;","&#x3b1;","20"],
["&#x3bb;","&#x3ac;","20"],
["&#x3bb;","&#x27;","123"],
["&#x3bb;","&#x22;","123"],
["&#x3bd;","&#x201e;","82"],
["&#x3bd;","&#x201a;","82"],
["&#x3bd;","&#x3bb;","20"],
["&#x3bd;","&#x2e;","82"],
["&#x3bd;","&#x2c;","82"],
["&#x3bf;","&#x201d;","20"],
["&#x3bf;","&#x2019;","20"],
["&#x3bf;","&#x3bd;","41"],
["&#x3bf;","&#x3b3;","41"],
["&#x3bf;","&#x27;","20"],
["&#x3bf;","&#x22;","20"],
["&#x3c1;","&#x201d;","20"],
["&#x3c1;","&#x2019;","20"],
["&#x3c1;","&#x3bd;","41"],
["&#x3c1;","&#x3b3;","41"],
["&#x3c1;","&#x27;","20"],
["&#x3c1;","&#x22;","20"],
["&#x3c3;","&#x201e;","20"],
["&#x3c3;","&#x201a;","20"],
["&#x3c3;","&#x2e;","20"],
["&#x3c3;","&#x2c;","20"],
["&#x3c6;","&#x201d;","20"],
["&#x3c6;","&#x2019;","20"],
["&#x3c6;","&#x3bd;","41"],
["&#x3c6;","&#x3b3;","41"],
["&#x3c6;","&#x27;","20"],
["&#x3c6;","&#x22;","20"],
["&#x3c7;","&#x201e;","61"],
["&#x3c7;","&#x201a;","61"],
["&#x3c7;","&#x2015;","41"],
["&#x3c7;","&#x2014;","41"],
["&#x3c7;","&#x2013;","41"],
["&#x3c7;","&#x3cc;","41"],
["&#x3c7;","&#x3c6;","41"],
["&#x3c7;","&#x3c3;","41"],
["&#x3c7;","&#x3c2;","41"],
["&#x3c7;","&#x3bf;","41"],
["&#x3c7;","&#x3b4;","41"],
["&#x3c7;","&#x3b1;","41"],
["&#x3c7;","&#x3ac;","41"],
["&#x3c7;","&#x2e;","61"],
["&#x3c7;","&#x2d;","41"],
["&#x3c7;","&#x2c;","61"],
["&#x3ca;","&#x201d;","41"],
["&#x3ca;","&#x2019;","41"],
["&#x3ca;","&#x27;","41"],
["&#x3ca;","&#x22;","41"],
["&#x3cc;","&#x201d;","20"],
["&#x3cc;","&#x2019;","20"],
["&#x3cc;","&#x3bd;","41"],
["&#x3cc;","&#x3b3;","41"],
["&#x3cc;","&#x27;","20"],
["&#x3cc;","&#x22;","20"],
["&#x402;","&#x50f;","41"],
["&#x402;","&#x50e;","123"],
["&#x402;","&#x507;","61"],
["&#x402;","&#x506;","102"],
["&#x402;","&#x505;","61"],
["&#x402;","&#x504;","102"],
["&#x402;","&#x4fa;","82"],
["&#x402;","&#x4f5;","41"],
["&#x402;","&#x4f4;","102"],
["&#x402;","&#x4f3;","41"],
["&#x402;","&#x4f2;","41"],
["&#x402;","&#x4f1;","41"],
["&#x402;","&#x4f0;","41"],
["&#x402;","&#x4ef;","41"],
["&#x402;","&#x4ee;","41"],
["&#x402;","&#x4cc;","41"],
["&#x402;","&#x4cb;","102"],
["&#x402;","&#x4b9;","41"],
["&#x402;","&#x4b8;","102"],
["&#x402;","&#x4b7;","41"],
["&#x402;","&#x4b6;","102"],
["&#x402;","&#x4b5;","41"],
["&#x402;","&#x4b4;","123"],
["&#x402;","&#x4b1;","41"],
["&#x402;","&#x4b0;","102"],
["&#x402;","&#x4af;","41"],
["&#x402;","&#x4ae;","102"],
["&#x402;","&#x4ad;","41"],
["&#x402;","&#x4ac;","102"],
["&#x402;","&#x4a1;","41"],
["&#x402;","&#x4a0;","123"],
["&#x402;","&#x49e;","82"],
["&#x402;","&#x492;","82"],
["&#x402;","&#x48c;","82"],
["&#x402;","&#x476;","82"],
["&#x402;","&#x474;","82"],
["&#x402;","&#x470;","102"],
["&#x402;","&#x462;","82"],
["&#x402;","&#x201d;","82"],
["&#x402;","&#x2019;","82"],
["&#x402;","&#x45e;","41"],
["&#x402;","&#x44a;","41"],
["&#x402;","&#x447;","41"],
["&#x402;","&#x443;","41"],
["&#x402;","&#x442;","41"],
["&#x402;","&#x42a;","123"],
["&#x402;","&#x427;","102"],
["&#x402;","&#x423;","41"],
["&#x402;","&#x422;","102"],
["&#x402;","&#x40e;","41"],
["&#x402;","&#x40b;","123"],
["&#x402;","&#x402;","123"],
["&#x402;","&#x27;","82"],
["&#x402;","&#x22;","82"],
["&#x403;","&#x513;","123"],
["&#x403;","&#x512;","102"],
["&#x403;","&#x511;","143"],
["&#x403;","&#x50f;","82"],
["&#x403;","&#x50d;","143"],
["&#x403;","&#x50c;","41"],
["&#x403;","&#x50b;","102"],
["&#x403;","&#x509;","123"],
["&#x403;","&#x508;","102"],
["&#x403;","&#x507;","102"],
["&#x403;","&#x505;","102"],
["&#x403;","&#x503;","143"],
["&#x403;","&#x502;","143"],
["&#x403;","&#x501;","143"],
["&#x403;","&#x500;","143"],
["&#x403;","&#x4ff;","41"],
["&#x403;","&#x4fd;","41"],
["&#x403;","&#x4f9;","102"],
["&#x403;","&#x4f7;","102"],
["&#x403;","&#x4f5;","102"],
["&#x403;","&#x4f3;","82"],
["&#x403;","&#x4f1;","82"],
["&#x403;","&#x4ef;","82"],
["&#x403;","&#x4ed;","41"],
["&#x403;","&#x4eb;","143"],
["&#x403;","&#x4ea;","41"],
["&#x403;","&#x4e9;","143"],
["&#x403;","&#x4e8;","41"],
["&#x403;","&#x4e7;","143"],
["&#x403;","&#x4e6;","41"],
["&#x403;","&#x4e5;","102"],
["&#x403;","&#x4e3;","102"],
["&#x403;","&#x4e1;","61"],
["&#x403;","&#x4df;","41"],
["&#x403;","&#x4dd;","41"],
["&#x403;","&#x4d7;","143"],
["&#x403;","&#x4d4;","143"],
["&#x403;","&#x4d2;","143"],
["&#x403;","&#x4d0;","143"],
["&#x403;","&#x4ce;","102"],
["&#x403;","&#x4cc;","102"],
["&#x403;","&#x4ca;","102"],
["&#x403;","&#x4c8;","102"],
["&#x403;","&#x4c6;","123"],
["&#x403;","&#x4c5;","102"],
["&#x403;","&#x4c4;","102"],
["&#x403;","&#x4c2;","41"],
["&#x403;","&#x4bf;","143"],
["&#x403;","&#x4be;","102"],
["&#x403;","&#x4bd;","143"],
["&#x403;","&#x4bc;","102"],
["&#x403;","&#x4bb;","102"],
["&#x403;","&#x4b9;","102"],
["&#x403;","&#x4b7;","102"],
["&#x403;","&#x4b5;","82"],
["&#x403;","&#x4b3;","41"],
["&#x403;","&#x4b1;","82"],
["&#x403;","&#x4af;","82"],
["&#x403;","&#x4ad;","82"],
["&#x403;","&#x4ac;","-41"],
["&#x403;","&#x4ab;","143"],
["&#x403;","&#x4aa;","41"],
["&#x403;","&#x4a9;","143"],
["&#x403;","&#x4a8;","41"],
["&#x403;","&#x4a7;","102"],
["&#x403;","&#x4a5;","102"],
["&#x403;","&#x4a3;","102"],
["&#x403;","&#x4a1;","82"],
["&#x403;","&#x49d;","102"],
["&#x403;","&#x49b;","102"],
["&#x403;","&#x499;","41"],
["&#x403;","&#x497;","41"],
["&#x403;","&#x495;","102"],
["&#x403;","&#x48f;","102"],
["&#x403;","&#x48b;","102"],
["&#x403;","&#x481;","143"],
["&#x403;","&#x480;","41"],
["&#x403;","&#x47f;","41"],
["&#x403;","&#x47e;","41"],
["&#x403;","&#x47d;","143"],
["&#x403;","&#x47c;","41"],
["&#x403;","&#x47b;","143"],
["&#x403;","&#x47a;","41"],
["&#x403;","&#x479;","143"],
["&#x403;","&#x478;","41"],
["&#x403;","&#x477;","41"],
["&#x403;","&#x475;","41"],
["&#x403;","&#x473;","143"],
["&#x403;","&#x472;","41"],
["&#x403;","&#x471;","102"],
["&#x403;","&#x46d;","102"],
["&#x403;","&#x46b;","102"],
["&#x403;","&#x469;","102"],
["&#x403;","&#x467;","123"],
["&#x403;","&#x466;","143"],
["&#x403;","&#x465;","102"],
["&#x403;","&#x461;","41"],
["&#x403;","&#x460;","41"],
["&#x403;","&#x45d;","102"],
["&#x403;","&#x450;","143"],
["&#x403;","&#x201e;","123"],
["&#x403;","&#x201a;","123"],
["&#x403;","&#x2015;","82"],
["&#x403;","&#x2014;","82"],
["&#x403;","&#x2013;","82"],
["&#x403;","&#x491;","102"],
["&#x403;","&#x45f;","102"],
["&#x403;","&#x45e;","82"],
["&#x403;","&#x45c;","102"],
["&#x403;","&#x45a;","102"],
["&#x403;","&#x459;","123"],
["&#x403;","&#x455;","123"],
["&#x403;","&#x454;","143"],
["&#x403;","&#x453;","102"],
["&#x403;","&#x451;","143"],
["&#x403;","&#x44f;","61"],
["&#x403;","&#x44e;","102"],
["&#x403;","&#x44d;","41"],
["&#x403;","&#x44c;","102"],
["&#x403;","&#x44b;","102"],
["&#x403;","&#x44a;","82"],
["&#x403;","&#x449;","102"],
["&#x403;","&#x448;","102"],
["&#x403;","&#x447;","102"],
["&#x403;","&#x446;","102"],
["&#x403;","&#x445;","41"],
["&#x403;","&#x444;","143"],
["&#x403;","&#x443;","82"],
["&#x403;","&#x442;","82"],
["&#x403;","&#x441;","143"],
["&#x403;","&#x440;","102"],
["&#x403;","&#x43f;","102"],
["&#x403;","&#x43e;","143"],
["&#x403;","&#x43d;","102"],
["&#x403;","&#x43c;","102"],
["&#x403;","&#x43b;","123"],
["&#x403;","&#x43a;","102"],
["&#x403;","&#x439;","102"],
["&#x403;","&#x438;","102"],
["&#x403;","&#x437;","41"],
["&#x403;","&#x436;","41"],
["&#x403;","&#x435;","143"],
["&#x403;","&#x434;","123"],
["&#x403;","&#x433;","102"],
["&#x403;","&#x432;","102"],
["&#x403;","&#x424;","82"],
["&#x403;","&#x422;","-41"],
["&#x403;","&#x421;","41"],
["&#x403;","&#x41e;","41"],
["&#x403;","&#x41b;","102"],
["&#x403;","&#x414;","102"],
["&#x403;","&#x410;","143"],
["&#x403;","&#x409;","102"],
["&#x403;","&#x404;","41"],
["&#x403;","&#x2e;","123"],
["&#x403;","&#x2d;","82"],
["&#x403;","&#x2c;","123"],
["&#x404;","&#x50c;","41"],
["&#x404;","&#x507;","41"],
["&#x404;","&#x505;","41"],
["&#x404;","&#x502;","41"],
["&#x404;","&#x500;","41"],
["&#x404;","&#x4f5;","41"],
["&#x404;","&#x4ea;","41"],
["&#x404;","&#x4e8;","41"],
["&#x404;","&#x4e6;","41"],
["&#x404;","&#x4cc;","41"],
["&#x404;","&#x4be;","41"],
["&#x404;","&#x4bc;","41"],
["&#x404;","&#x4b9;","41"],
["&#x404;","&#x4b7;","41"],
["&#x404;","&#x4aa;","41"],
["&#x404;","&#x4a8;","41"],
["&#x404;","&#x480;","41"],
["&#x404;","&#x47e;","41"],
["&#x404;","&#x47c;","41"],
["&#x404;","&#x47a;","41"],
["&#x404;","&#x478;","41"],
["&#x404;","&#x472;","41"],
["&#x404;","&#x460;","41"],
["&#x404;","&#x447;","41"],
["&#x404;","&#x424;","41"],
["&#x404;","&#x421;","41"],
["&#x404;","&#x41e;","41"],
["&#x404;","&#x404;","41"],
["&#x405;","&#x507;","41"],
["&#x405;","&#x505;","41"],
["&#x409;","&#x50f;","41"],
["&#x409;","&#x50e;","123"],
["&#x409;","&#x507;","61"],
["&#x409;","&#x506;","102"],
["&#x409;","&#x505;","61"],
["&#x409;","&#x504;","102"],
["&#x409;","&#x4fa;","82"],
["&#x409;","&#x4f5;","41"],
["&#x409;","&#x4f4;","102"],
["&#x409;","&#x4f3;","41"],
["&#x409;","&#x4f2;","41"],
["&#x409;","&#x4f1;","41"],
["&#x409;","&#x4f0;","41"],
["&#x409;","&#x4ef;","41"],
["&#x409;","&#x4ee;","41"],
["&#x409;","&#x4cc;","41"],
["&#x409;","&#x4cb;","102"],
["&#x409;","&#x4b9;","41"],
["&#x409;","&#x4b8;","102"],
["&#x409;","&#x4b7;","41"],
["&#x409;","&#x4b6;","102"],
["&#x409;","&#x4b5;","41"],
["&#x409;","&#x4b4;","123"],
["&#x409;","&#x4b1;","41"],
["&#x409;","&#x4b0;","102"],
["&#x409;","&#x4af;","41"],
["&#x409;","&#x4ae;","102"],
["&#x409;","&#x4ad;","41"],
["&#x409;","&#x4ac;","102"],
["&#x409;","&#x4a1;","41"],
["&#x409;","&#x4a0;","123"],
["&#x409;","&#x49e;","82"],
["&#x409;","&#x492;","82"],
["&#x409;","&#x48c;","82"],
["&#x409;","&#x476;","82"],
["&#x409;","&#x474;","82"],
["&#x409;","&#x470;","102"],
["&#x409;","&#x462;","82"],
["&#x409;","&#x201d;","82"],
["&#x409;","&#x2019;","82"],
["&#x409;","&#x45e;","41"],
["&#x409;","&#x44a;","41"],
["&#x409;","&#x447;","41"],
["&#x409;","&#x443;","41"],
["&#x409;","&#x442;","41"],
["&#x409;","&#x42a;","123"],
["&#x409;","&#x427;","102"],
["&#x409;","&#x423;","41"],
["&#x409;","&#x422;","102"],
["&#x409;","&#x40e;","41"],
["&#x409;","&#x40b;","123"],
["&#x409;","&#x402;","123"],
["&#x409;","&#x27;","82"],
["&#x409;","&#x22;","82"],
["&#x40a;","&#x50f;","41"],
["&#x40a;","&#x50e;","123"],
["&#x40a;","&#x507;","61"],
["&#x40a;","&#x506;","102"],
["&#x40a;","&#x505;","61"],
["&#x40a;","&#x504;","102"],
["&#x40a;","&#x4fa;","82"],
["&#x40a;","&#x4f5;","41"],
["&#x40a;","&#x4f4;","102"],
["&#x40a;","&#x4f3;","41"],
["&#x40a;","&#x4f2;","41"],
["&#x40a;","&#x4f1;","41"],
["&#x40a;","&#x4f0;","41"],
["&#x40a;","&#x4ef;","41"],
["&#x40a;","&#x4ee;","41"],
["&#x40a;","&#x4cc;","41"],
["&#x40a;","&#x4cb;","102"],
["&#x40a;","&#x4b9;","41"],
["&#x40a;","&#x4b8;","102"],
["&#x40a;","&#x4b7;","41"],
["&#x40a;","&#x4b6;","102"],
["&#x40a;","&#x4b5;","41"],
["&#x40a;","&#x4b4;","123"],
["&#x40a;","&#x4b1;","41"],
["&#x40a;","&#x4b0;","102"],
["&#x40a;","&#x4af;","41"],
["&#x40a;","&#x4ae;","102"],
["&#x40a;","&#x4ad;","41"],
["&#x40a;","&#x4ac;","102"],
["&#x40a;","&#x4a1;","41"],
["&#x40a;","&#x4a0;","123"],
["&#x40a;","&#x49e;","82"],
["&#x40a;","&#x492;","82"],
["&#x40a;","&#x48c;","82"],
["&#x40a;","&#x476;","82"],
["&#x40a;","&#x474;","82"],
["&#x40a;","&#x470;","102"],
["&#x40a;","&#x462;","82"],
["&#x40a;","&#x201d;","82"],
["&#x40a;","&#x2019;","82"],
["&#x40a;","&#x45e;","41"],
["&#x40a;","&#x44a;","41"],
["&#x40a;","&#x447;","41"],
["&#x40a;","&#x443;","41"],
["&#x40a;","&#x442;","41"],
["&#x40a;","&#x42a;","123"],
["&#x40a;","&#x427;","102"],
["&#x40a;","&#x423;","41"],
["&#x40a;","&#x422;","102"],
["&#x40a;","&#x40e;","41"],
["&#x40a;","&#x40b;","123"],
["&#x40a;","&#x402;","123"],
["&#x40a;","&#x27;","82"],
["&#x40a;","&#x22;","82"],
["&#x40b;","&#x50f;","41"],
["&#x40b;","&#x50e;","123"],
["&#x40b;","&#x507;","61"],
["&#x40b;","&#x506;","102"],
["&#x40b;","&#x505;","61"],
["&#x40b;","&#x504;","102"],
["&#x40b;","&#x4fa;","82"],
["&#x40b;","&#x4f5;","41"],
["&#x40b;","&#x4f4;","102"],
["&#x40b;","&#x4f3;","41"],
["&#x40b;","&#x4f2;","41"],
["&#x40b;","&#x4f1;","41"],
["&#x40b;","&#x4f0;","41"],
["&#x40b;","&#x4ef;","41"],
["&#x40b;","&#x4ee;","41"],
["&#x40b;","&#x4cc;","41"],
["&#x40b;","&#x4cb;","102"],
["&#x40b;","&#x4b9;","41"],
["&#x40b;","&#x4b8;","102"],
["&#x40b;","&#x4b7;","41"],
["&#x40b;","&#x4b6;","102"],
["&#x40b;","&#x4b5;","41"],
["&#x40b;","&#x4b4;","123"],
["&#x40b;","&#x4b1;","41"],
["&#x40b;","&#x4b0;","102"],
["&#x40b;","&#x4af;","41"],
["&#x40b;","&#x4ae;","102"],
["&#x40b;","&#x4ad;","41"],
["&#x40b;","&#x4ac;","102"],
["&#x40b;","&#x4a1;","41"],
["&#x40b;","&#x4a0;","123"],
["&#x40b;","&#x49e;","82"],
["&#x40b;","&#x492;","82"],
["&#x40b;","&#x48c;","82"],
["&#x40b;","&#x476;","82"],
["&#x40b;","&#x474;","82"],
["&#x40b;","&#x470;","102"],
["&#x40b;","&#x462;","82"],
["&#x40b;","&#x201d;","82"],
["&#x40b;","&#x2019;","82"],
["&#x40b;","&#x45e;","41"],
["&#x40b;","&#x44a;","41"],
["&#x40b;","&#x447;","41"],
["&#x40b;","&#x443;","41"],
["&#x40b;","&#x442;","41"],
["&#x40b;","&#x42a;","123"],
["&#x40b;","&#x427;","102"],
["&#x40b;","&#x423;","41"],
["&#x40b;","&#x422;","102"],
["&#x40b;","&#x40e;","41"],
["&#x40b;","&#x40b;","123"],
["&#x40b;","&#x402;","123"],
["&#x40b;","&#x27;","82"],
["&#x40b;","&#x22;","82"],
["&#x40c;","&#x510;","20"],
["&#x40c;","&#x50c;","41"],
["&#x40c;","&#x507;","41"],
["&#x40c;","&#x505;","41"],
["&#x40c;","&#x502;","41"],
["&#x40c;","&#x500;","41"],
["&#x40c;","&#x4f5;","41"],
["&#x40c;","&#x4f4;","41"],
["&#x40c;","&#x4ea;","41"],
["&#x40c;","&#x4e8;","41"],
["&#x40c;","&#x4e6;","41"],
["&#x40c;","&#x4cc;","41"],
["&#x40c;","&#x4cb;","41"],
["&#x40c;","&#x4be;","102"],
["&#x40c;","&#x4bc;","102"],
["&#x40c;","&#x4b9;","41"],
["&#x40c;","&#x4b8;","41"],
["&#x40c;","&#x4b7;","41"],
["&#x40c;","&#x4b6;","41"],
["&#x40c;","&#x4aa;","41"],
["&#x40c;","&#x4a8;","41"],
["&#x40c;","&#x480;","41"],
["&#x40c;","&#x47e;","41"],
["&#x40c;","&#x47c;","41"],
["&#x40c;","&#x47a;","41"],
["&#x40c;","&#x478;","41"],
["&#x40c;","&#x472;","41"],
["&#x40c;","&#x470;","41"],
["&#x40c;","&#x460;","41"],
["&#x40c;","&#x447;","41"],
["&#x40c;","&#x427;","41"],
["&#x40c;","&#x424;","41"],
["&#x40c;","&#x421;","41"],
["&#x40c;","&#x41e;","41"],
["&#x40c;","&#x404;","41"],
["&#x40e;","&#x513;","82"],
["&#x40e;","&#x512;","102"],
["&#x40e;","&#x511;","41"],
["&#x40e;","&#x50d;","41"],
["&#x40e;","&#x50c;","20"],
["&#x40e;","&#x509;","82"],
["&#x40e;","&#x508;","102"],
["&#x40e;","&#x503;","41"],
["&#x40e;","&#x502;","143"],
["&#x40e;","&#x501;","41"],
["&#x40e;","&#x500;","143"],
["&#x40e;","&#x4f5;","41"],
["&#x40e;","&#x4eb;","41"],
["&#x40e;","&#x4ea;","20"],
["&#x40e;","&#x4e9;","41"],
["&#x40e;","&#x4e8;","20"],
["&#x40e;","&#x4e7;","41"],
["&#x40e;","&#x4e6;","20"],
["&#x40e;","&#x4d7;","41"],
["&#x40e;","&#x4d4;","143"],
["&#x40e;","&#x4d2;","143"],
["&#x40e;","&#x4d0;","143"],
["&#x40e;","&#x4cc;","41"],
["&#x40e;","&#x4c6;","82"],
["&#x40e;","&#x4c5;","102"],
["&#x40e;","&#x4bf;","61"],
["&#x40e;","&#x4be;","41"],
["&#x40e;","&#x4bd;","61"],
["&#x40e;","&#x4bc;","41"],
["&#x40e;","&#x4b9;","41"],
["&#x40e;","&#x4b7;","41"],
["&#x40e;","&#x4ab;","41"],
["&#x40e;","&#x4aa;","20"],
["&#x40e;","&#x4a9;","41"],
["&#x40e;","&#x4a8;","20"],
["&#x40e;","&#x49f;","-102"],
["&#x40e;","&#x48d;","-102"],
["&#x40e;","&#x481;","41"],
["&#x40e;","&#x480;","20"],
["&#x40e;","&#x47e;","20"],
["&#x40e;","&#x47d;","41"],
["&#x40e;","&#x47c;","20"],
["&#x40e;","&#x47b;","41"],
["&#x40e;","&#x47a;","20"],
["&#x40e;","&#x479;","41"],
["&#x40e;","&#x478;","20"],
["&#x40e;","&#x473;","41"],
["&#x40e;","&#x472;","20"],
["&#x40e;","&#x467;","82"],
["&#x40e;","&#x466;","143"],
["&#x40e;","&#x460;","20"],
["&#x40e;","&#x450;","41"],
["&#x40e;","&#x201e;","123"],
["&#x40e;","&#x201a;","123"],
["&#x40e;","&#x45b;","-102"],
["&#x40e;","&#x459;","82"],
["&#x40e;","&#x455;","20"],
["&#x40e;","&#x454;","41"],
["&#x40e;","&#x452;","-102"],
["&#x40e;","&#x451;","41"],
["&#x40e;","&#x447;","41"],
["&#x40e;","&#x444;","41"],
["&#x40e;","&#x441;","41"],
["&#x40e;","&#x43e;","41"],
["&#x40e;","&#x43b;","82"],
["&#x40e;","&#x435;","41"],
["&#x40e;","&#x434;","82"],
["&#x40e;","&#x42f;","20"],
["&#x40e;","&#x424;","61"],
["&#x40e;","&#x421;","20"],
["&#x40e;","&#x41e;","20"],
["&#x40e;","&#x41b;","102"],
["&#x40e;","&#x414;","102"],
["&#x40e;","&#x410;","143"],
["&#x40e;","&#x409;","102"],
["&#x40e;","&#x404;","20"],
["&#x40e;","&#x2e;","123"],
["&#x40e;","&#x2c;","123"],
["&#x410;","&#x50f;","41"],
["&#x410;","&#x50e;","102"],
["&#x410;","&#x507;","41"],
["&#x410;","&#x506;","143"],
["&#x410;","&#x505;","41"],
["&#x410;","&#x504;","143"],
["&#x410;","&#x4fa;","41"],
["&#x410;","&#x4f5;","41"],
["&#x410;","&#x4f4;","102"],
["&#x410;","&#x4da;","41"],
["&#x410;","&#x4d8;","41"],
["&#x410;","&#x4cc;","41"],
["&#x410;","&#x4cb;","102"],
["&#x410;","&#x4be;","102"],
["&#x410;","&#x4bc;","102"],
["&#x410;","&#x4b9;","41"],
["&#x410;","&#x4b8;","102"],
["&#x410;","&#x4b7;","41"],
["&#x410;","&#x4b6;","102"],
["&#x410;","&#x4b5;","41"],
["&#x410;","&#x4b4;","102"],
["&#x410;","&#x4b0;","123"],
["&#x410;","&#x4ae;","123"],
["&#x410;","&#x4ad;","41"],
["&#x410;","&#x4ac;","143"],
["&#x410;","&#x4a1;","41"],
["&#x410;","&#x4a0;","102"],
["&#x410;","&#x49e;","41"],
["&#x410;","&#x492;","41"],
["&#x410;","&#x48c;","41"],
["&#x410;","&#x476;","82"],
["&#x410;","&#x474;","82"],
["&#x410;","&#x470;","102"],
["&#x410;","&#x462;","41"],
["&#x410;","&#x201d;","143"],
["&#x410;","&#x2019;","143"],
["&#x410;","&#x44a;","41"],
["&#x410;","&#x447;","41"],
["&#x410;","&#x442;","41"],
["&#x410;","&#x42a;","102"],
["&#x410;","&#x427;","102"],
["&#x410;","&#x424;","41"],
["&#x410;","&#x422;","143"],
["&#x410;","&#x40b;","102"],
["&#x410;","&#x402;","102"],
["&#x410;","&#x27;","143"],
["&#x410;","&#x22;","143"],
["&#x411;","&#x4f4;","41"],
["&#x411;","&#x4d4;","20"],
["&#x411;","&#x4d2;","20"],
["&#x411;","&#x4d0;","20"],
["&#x411;","&#x4cb;","41"],
["&#x411;","&#x4be;","41"],
["&#x411;","&#x4bc;","41"],
["&#x411;","&#x4b8;","41"],
["&#x411;","&#x4b6;","41"],
["&#x411;","&#x470;","41"],
["&#x411;","&#x466;","20"],
["&#x411;","&#x201d;","41"],
["&#x411;","&#x2019;","41"],
["&#x411;","&#x427;","41"],
["&#x411;","&#x410;","20"],
["&#x411;","&#x27;","41"],
["&#x411;","&#x22;","41"],
["&#x412;","&#x506;","41"],
["&#x412;","&#x504;","41"],
["&#x412;","&#x4b0;","20"],
["&#x412;","&#x4ae;","20"],
["&#x412;","&#x476;","20"],
["&#x412;","&#x474;","20"],
["&#x412;","&#x201e;","82"],
["&#x412;","&#x201a;","82"],
["&#x412;","&#x2e;","82"],
["&#x412;","&#x2c;","82"],
["&#x413;","&#x513;","123"],
["&#x413;","&#x512;","102"],
["&#x413;","&#x511;","143"],
["&#x413;","&#x50f;","82"],
["&#x413;","&#x50d;","143"],
["&#x413;","&#x50c;","41"],
["&#x413;","&#x50b;","102"],
["&#x413;","&#x509;","123"],
["&#x413;","&#x508;","102"],
["&#x413;","&#x507;","102"],
["&#x413;","&#x505;","102"],
["&#x413;","&#x503;","143"],
["&#x413;","&#x502;","143"],
["&#x413;","&#x501;","143"],
["&#x413;","&#x500;","143"],
["&#x413;","&#x4ff;","41"],
["&#x413;","&#x4fd;","41"],
["&#x413;","&#x4f9;","102"],
["&#x413;","&#x4f7;","102"],
["&#x413;","&#x4f5;","102"],
["&#x413;","&#x4f3;","82"],
["&#x413;","&#x4f1;","82"],
["&#x413;","&#x4ef;","82"],
["&#x413;","&#x4ed;","41"],
["&#x413;","&#x4eb;","143"],
["&#x413;","&#x4ea;","41"],
["&#x413;","&#x4e9;","143"],
["&#x413;","&#x4e8;","41"],
["&#x413;","&#x4e7;","143"],
["&#x413;","&#x4e6;","41"],
["&#x413;","&#x4e5;","102"],
["&#x413;","&#x4e3;","102"],
["&#x413;","&#x4e1;","61"],
["&#x413;","&#x4df;","41"],
["&#x413;","&#x4dd;","41"],
["&#x413;","&#x4d7;","143"],
["&#x413;","&#x4d4;","143"],
["&#x413;","&#x4d2;","143"],
["&#x413;","&#x4d0;","143"],
["&#x413;","&#x4ce;","102"],
["&#x413;","&#x4cc;","102"],
["&#x413;","&#x4ca;","102"],
["&#x413;","&#x4c8;","102"],
["&#x413;","&#x4c6;","123"],
["&#x413;","&#x4c5;","102"],
["&#x413;","&#x4c4;","102"],
["&#x413;","&#x4c2;","41"],
["&#x413;","&#x4bf;","143"],
["&#x413;","&#x4be;","102"],
["&#x413;","&#x4bd;","143"],
["&#x413;","&#x4bc;","102"],
["&#x413;","&#x4bb;","102"],
["&#x413;","&#x4b9;","102"],
["&#x413;","&#x4b7;","102"],
["&#x413;","&#x4b5;","82"],
["&#x413;","&#x4b3;","41"],
["&#x413;","&#x4b1;","82"],
["&#x413;","&#x4af;","82"],
["&#x413;","&#x4ad;","82"],
["&#x413;","&#x4ac;","-41"],
["&#x413;","&#x4ab;","143"],
["&#x413;","&#x4aa;","41"],
["&#x413;","&#x4a9;","143"],
["&#x413;","&#x4a8;","41"],
["&#x413;","&#x4a7;","102"],
["&#x413;","&#x4a5;","102"],
["&#x413;","&#x4a3;","102"],
["&#x413;","&#x4a1;","82"],
["&#x413;","&#x49d;","102"],
["&#x413;","&#x49b;","102"],
["&#x413;","&#x499;","41"],
["&#x413;","&#x497;","41"],
["&#x413;","&#x495;","102"],
["&#x413;","&#x48f;","102"],
["&#x413;","&#x48b;","102"],
["&#x413;","&#x481;","143"],
["&#x413;","&#x480;","41"],
["&#x413;","&#x47f;","41"],
["&#x413;","&#x47e;","41"],
["&#x413;","&#x47d;","143"],
["&#x413;","&#x47c;","41"],
["&#x413;","&#x47b;","143"],
["&#x413;","&#x47a;","41"],
["&#x413;","&#x479;","143"],
["&#x413;","&#x478;","41"],
["&#x413;","&#x477;","41"],
["&#x413;","&#x475;","41"],
["&#x413;","&#x473;","143"],
["&#x413;","&#x472;","41"],
["&#x413;","&#x471;","102"],
["&#x413;","&#x46d;","102"],
["&#x413;","&#x46b;","102"],
["&#x413;","&#x469;","102"],
["&#x413;","&#x467;","123"],
["&#x413;","&#x466;","143"],
["&#x413;","&#x465;","102"],
["&#x413;","&#x461;","41"],
["&#x413;","&#x460;","41"],
["&#x413;","&#x45d;","102"],
["&#x413;","&#x450;","143"],
["&#x413;","&#x201e;","123"],
["&#x413;","&#x201a;","123"],
["&#x413;","&#x2015;","82"],
["&#x413;","&#x2014;","82"],
["&#x413;","&#x2013;","82"],
["&#x413;","&#x491;","102"],
["&#x413;","&#x45f;","102"],
["&#x413;","&#x45e;","82"],
["&#x413;","&#x45c;","102"],
["&#x413;","&#x45a;","102"],
["&#x413;","&#x459;","123"],
["&#x413;","&#x455;","123"],
["&#x413;","&#x454;","143"],
["&#x413;","&#x453;","102"],
["&#x413;","&#x451;","143"],
["&#x413;","&#x44f;","61"],
["&#x413;","&#x44e;","102"],
["&#x413;","&#x44d;","41"],
["&#x413;","&#x44c;","102"],
["&#x413;","&#x44b;","102"],
["&#x413;","&#x44a;","82"],
["&#x413;","&#x449;","102"],
["&#x413;","&#x448;","102"],
["&#x413;","&#x447;","102"],
["&#x413;","&#x446;","102"],
["&#x413;","&#x445;","41"],
["&#x413;","&#x444;","143"],
["&#x413;","&#x443;","82"],
["&#x413;","&#x442;","82"],
["&#x413;","&#x441;","143"],
["&#x413;","&#x440;","102"],
["&#x413;","&#x43f;","102"],
["&#x413;","&#x43e;","143"],
["&#x413;","&#x43d;","102"],
["&#x413;","&#x43c;","102"],
["&#x413;","&#x43b;","123"],
["&#x413;","&#x43a;","102"],
["&#x413;","&#x439;","102"],
["&#x413;","&#x438;","102"],
["&#x413;","&#x437;","41"],
["&#x413;","&#x436;","41"],
["&#x413;","&#x435;","143"],
["&#x413;","&#x434;","123"],
["&#x413;","&#x433;","102"],
["&#x413;","&#x432;","102"],
["&#x413;","&#x424;","82"],
["&#x413;","&#x422;","-41"],
["&#x413;","&#x421;","41"],
["&#x413;","&#x41e;","41"],
["&#x413;","&#x41b;","102"],
["&#x413;","&#x414;","102"],
["&#x413;","&#x410;","143"],
["&#x413;","&#x409;","102"],
["&#x413;","&#x404;","41"],
["&#x413;","&#x2e;","123"],
["&#x413;","&#x2d;","82"],
["&#x413;","&#x2c;","123"],
["&#x414;","&#x507;","41"],
["&#x414;","&#x505;","41"],
["&#x414;","&#x4e1;","-41"],
["&#x414;","&#x408;","-225"],
["&#x416;","&#x510;","20"],
["&#x416;","&#x50c;","41"],
["&#x416;","&#x507;","41"],
["&#x416;","&#x505;","41"],
["&#x416;","&#x502;","41"],
["&#x416;","&#x500;","41"],
["&#x416;","&#x4f5;","41"],
["&#x416;","&#x4f4;","41"],
["&#x416;","&#x4ea;","41"],
["&#x416;","&#x4e8;","41"],
["&#x416;","&#x4e6;","41"],
["&#x416;","&#x4cc;","41"],
["&#x416;","&#x4cb;","41"],
["&#x416;","&#x4be;","102"],
["&#x416;","&#x4bc;","102"],
["&#x416;","&#x4b9;","41"],
["&#x416;","&#x4b8;","41"],
["&#x416;","&#x4b7;","41"],
["&#x416;","&#x4b6;","41"],
["&#x416;","&#x4aa;","41"],
["&#x416;","&#x4a8;","41"],
["&#x416;","&#x480;","41"],
["&#x416;","&#x47e;","41"],
["&#x416;","&#x47c;","41"],
["&#x416;","&#x47a;","41"],
["&#x416;","&#x478;","41"],
["&#x416;","&#x472;","41"],
["&#x416;","&#x470;","41"],
["&#x416;","&#x460;","41"],
["&#x416;","&#x447;","41"],
["&#x416;","&#x427;","41"],
["&#x416;","&#x424;","41"],
["&#x416;","&#x421;","41"],
["&#x416;","&#x41e;","41"],
["&#x416;","&#x404;","41"],
["&#x417;","&#x506;","41"],
["&#x417;","&#x504;","41"],
["&#x417;","&#x4b0;","20"],
["&#x417;","&#x4ae;","20"],
["&#x417;","&#x476;","20"],
["&#x417;","&#x474;","20"],
["&#x417;","&#x201e;","82"],
["&#x417;","&#x201a;","82"],
["&#x417;","&#x2e;","82"],
["&#x417;","&#x2c;","82"],
["&#x41a;","&#x510;","20"],
["&#x41a;","&#x50c;","41"],
["&#x41a;","&#x507;","41"],
["&#x41a;","&#x505;","41"],
["&#x41a;","&#x502;","41"],
["&#x41a;","&#x500;","41"],
["&#x41a;","&#x4f5;","41"],
["&#x41a;","&#x4f4;","41"],
["&#x41a;","&#x4ea;","41"],
["&#x41a;","&#x4e8;","41"],
["&#x41a;","&#x4e6;","41"],
["&#x41a;","&#x4cc;","41"],
["&#x41a;","&#x4cb;","41"],
["&#x41a;","&#x4be;","102"],
["&#x41a;","&#x4bc;","102"],
["&#x41a;","&#x4b9;","41"],
["&#x41a;","&#x4b8;","41"],
["&#x41a;","&#x4b7;","41"],
["&#x41a;","&#x4b6;","41"],
["&#x41a;","&#x4aa;","41"],
["&#x41a;","&#x4a8;","41"],
["&#x41a;","&#x480;","41"],
["&#x41a;","&#x47e;","41"],
["&#x41a;","&#x47c;","41"],
["&#x41a;","&#x47a;","41"],
["&#x41a;","&#x478;","41"],
["&#x41a;","&#x472;","41"],
["&#x41a;","&#x470;","41"],
["&#x41a;","&#x460;","41"],
["&#x41a;","&#x447;","41"],
["&#x41a;","&#x427;","41"],
["&#x41a;","&#x424;","41"],
["&#x41a;","&#x421;","41"],
["&#x41a;","&#x41e;","41"],
["&#x41a;","&#x404;","41"],
["&#x41e;","&#x513;","20"],
["&#x41e;","&#x512;","41"],
["&#x41e;","&#x50e;","20"],
["&#x41e;","&#x509;","20"],
["&#x41e;","&#x508;","41"],
["&#x41e;","&#x506;","41"],
["&#x41e;","&#x504;","41"],
["&#x41e;","&#x4fe;","41"],
["&#x41e;","&#x4fc;","41"],
["&#x41e;","&#x4f4;","41"],
["&#x41e;","&#x4f2;","41"],
["&#x41e;","&#x4f0;","41"],
["&#x41e;","&#x4ee;","41"],
["&#x41e;","&#x4ec;","20"],
["&#x41e;","&#x4de;","20"],
["&#x41e;","&#x4dc;","41"],
["&#x41e;","&#x4d4;","41"],
["&#x41e;","&#x4d2;","41"],
["&#x41e;","&#x4d0;","41"],
["&#x41e;","&#x4cb;","41"],
["&#x41e;","&#x4c6;","20"],
["&#x41e;","&#x4c5;","41"],
["&#x41e;","&#x4c1;","41"],
["&#x41e;","&#x4b8;","41"],
["&#x41e;","&#x4b6;","41"],
["&#x41e;","&#x4b4;","20"],
["&#x41e;","&#x4b2;","41"],
["&#x41e;","&#x4b0;","20"],
["&#x41e;","&#x4ae;","20"],
["&#x41e;","&#x4ac;","61"],
["&#x41e;","&#x4a0;","20"],
["&#x41e;","&#x498;","20"],
["&#x41e;","&#x496;","41"],
["&#x41e;","&#x476;","20"],
["&#x41e;","&#x474;","20"],
["&#x41e;","&#x470;","41"],
["&#x41e;","&#x46e;","20"],
["&#x41e;","&#x467;","20"],
["&#x41e;","&#x466;","41"],
["&#x41e;","&#x201e;","82"],
["&#x41e;","&#x201a;","82"],
["&#x41e;","&#x459;","20"],
["&#x41e;","&#x43b;","20"],
["&#x41e;","&#x434;","20"],
["&#x41e;","&#x42d;","20"],
["&#x41e;","&#x42a;","20"],
["&#x41e;","&#x427;","41"],
["&#x41e;","&#x425;","41"],
["&#x41e;","&#x423;","41"],
["&#x41e;","&#x422;","61"],
["&#x41e;","&#x41b;","41"],
["&#x41e;","&#x417;","20"],
["&#x41e;","&#x416;","41"],
["&#x41e;","&#x414;","41"],
["&#x41e;","&#x410;","41"],
["&#x41e;","&#x40e;","41"],
["&#x41e;","&#x40b;","20"],
["&#x41e;","&#x409;","41"],
["&#x41e;","&#x402;","20"],
["&#x41e;","&#x2e;","82"],
["&#x41e;","&#x2c;","82"],
["&#x420;","&#x513;","102"],
["&#x420;","&#x512;","123"],
["&#x420;","&#x509;","102"],
["&#x420;","&#x508;","123"],
["&#x420;","&#x502;","82"],
["&#x420;","&#x500;","82"],
["&#x420;","&#x4fe;","41"],
["&#x420;","&#x4fc;","41"],
["&#x420;","&#x4dc;","41"],
["&#x420;","&#x4d4;","102"],
["&#x420;","&#x4d2;","102"],
["&#x420;","&#x4d0;","102"],
["&#x420;","&#x4c6;","102"],
["&#x420;","&#x4c5;","123"],
["&#x420;","&#x4c1;","41"],
["&#x420;","&#x4b2;","41"],
["&#x420;","&#x496;","41"],
["&#x420;","&#x46a;","20"],
["&#x420;","&#x467;","102"],
["&#x420;","&#x466;","102"],
["&#x420;","&#x201e;","266"],
["&#x420;","&#x201a;","266"],
["&#x420;","&#x459;","102"],
["&#x420;","&#x43b;","102"],
["&#x420;","&#x434;","102"],
["&#x420;","&#x425;","41"],
["&#x420;","&#x41b;","123"],
["&#x420;","&#x416;","41"],
["&#x420;","&#x414;","123"],
["&#x420;","&#x410;","102"],
["&#x420;","&#x409;","123"],
["&#x420;","&#x2e;","266"],
["&#x420;","&#x2c;","266"],
["&#x421;","&#x50c;","41"],
["&#x421;","&#x507;","41"],
["&#x421;","&#x505;","41"],
["&#x421;","&#x502;","41"],
["&#x421;","&#x500;","41"],
["&#x421;","&#x4f5;","41"],
["&#x421;","&#x4ea;","41"],
["&#x421;","&#x4e8;","41"],
["&#x421;","&#x4e6;","41"],
["&#x421;","&#x4cc;","41"],
["&#x421;","&#x4be;","41"],
["&#x421;","&#x4bc;","41"],
["&#x421;","&#x4b9;","41"],
["&#x421;","&#x4b7;","41"],
["&#x421;","&#x4aa;","41"],
["&#x421;","&#x4a8;","41"],
["&#x421;","&#x480;","41"],
["&#x421;","&#x47e;","41"],
["&#x421;","&#x47c;","41"],
["&#x421;","&#x47a;","41"],
["&#x421;","&#x478;","41"],
["&#x421;","&#x472;","41"],
["&#x421;","&#x460;","41"],
["&#x421;","&#x447;","41"],
["&#x421;","&#x424;","41"],
["&#x421;","&#x421;","41"],
["&#x421;","&#x41e;","41"],
["&#x421;","&#x404;","41"],
["&#x422;","&#x513;","123"],
["&#x422;","&#x512;","102"],
["&#x422;","&#x511;","143"],
["&#x422;","&#x50f;","82"],
["&#x422;","&#x50d;","143"],
["&#x422;","&#x50c;","41"],
["&#x422;","&#x50b;","102"],
["&#x422;","&#x509;","123"],
["&#x422;","&#x508;","102"],
["&#x422;","&#x507;","102"],
["&#x422;","&#x505;","102"],
["&#x422;","&#x503;","143"],
["&#x422;","&#x502;","143"],
["&#x422;","&#x501;","143"],
["&#x422;","&#x500;","143"],
["&#x422;","&#x4ff;","41"],
["&#x422;","&#x4fd;","41"],
["&#x422;","&#x4f9;","102"],
["&#x422;","&#x4f7;","102"],
["&#x422;","&#x4f5;","102"],
["&#x422;","&#x4f3;","82"],
["&#x422;","&#x4f1;","82"],
["&#x422;","&#x4ef;","82"],
["&#x422;","&#x4ed;","41"],
["&#x422;","&#x4eb;","143"],
["&#x422;","&#x4ea;","41"],
["&#x422;","&#x4e9;","143"],
["&#x422;","&#x4e8;","41"],
["&#x422;","&#x4e7;","143"],
["&#x422;","&#x4e6;","41"],
["&#x422;","&#x4e5;","102"],
["&#x422;","&#x4e3;","102"],
["&#x422;","&#x4e1;","61"],
["&#x422;","&#x4df;","41"],
["&#x422;","&#x4dd;","41"],
["&#x422;","&#x4d7;","143"],
["&#x422;","&#x4d4;","143"],
["&#x422;","&#x4d2;","143"],
["&#x422;","&#x4d0;","143"],
["&#x422;","&#x4ce;","102"],
["&#x422;","&#x4cc;","102"],
["&#x422;","&#x4ca;","102"],
["&#x422;","&#x4c8;","102"],
["&#x422;","&#x4c6;","123"],
["&#x422;","&#x4c5;","102"],
["&#x422;","&#x4c4;","102"],
["&#x422;","&#x4c2;","41"],
["&#x422;","&#x4bf;","143"],
["&#x422;","&#x4be;","102"],
["&#x422;","&#x4bd;","143"],
["&#x422;","&#x4bc;","102"],
["&#x422;","&#x4bb;","102"],
["&#x422;","&#x4b9;","102"],
["&#x422;","&#x4b7;","102"],
["&#x422;","&#x4b5;","82"],
["&#x422;","&#x4b3;","41"],
["&#x422;","&#x4b1;","82"],
["&#x422;","&#x4af;","82"],
["&#x422;","&#x4ad;","82"],
["&#x422;","&#x4ac;","-41"],
["&#x422;","&#x4ab;","143"],
["&#x422;","&#x4aa;","41"],
["&#x422;","&#x4a9;","143"],
["&#x422;","&#x4a8;","41"],
["&#x422;","&#x4a7;","102"],
["&#x422;","&#x4a5;","102"],
["&#x422;","&#x4a3;","102"],
["&#x422;","&#x4a1;","82"],
["&#x422;","&#x49d;","102"],
["&#x422;","&#x49b;","102"],
["&#x422;","&#x499;","41"],
["&#x422;","&#x497;","41"],
["&#x422;","&#x495;","102"],
["&#x422;","&#x48f;","102"],
["&#x422;","&#x48b;","102"],
["&#x422;","&#x481;","143"],
["&#x422;","&#x480;","41"],
["&#x422;","&#x47f;","41"],
["&#x422;","&#x47e;","41"],
["&#x422;","&#x47d;","143"],
["&#x422;","&#x47c;","41"],
["&#x422;","&#x47b;","143"],
["&#x422;","&#x47a;","41"],
["&#x422;","&#x479;","143"],
["&#x422;","&#x478;","41"],
["&#x422;","&#x477;","41"],
["&#x422;","&#x475;","41"],
["&#x422;","&#x473;","143"],
["&#x422;","&#x472;","41"],
["&#x422;","&#x471;","102"],
["&#x422;","&#x46d;","102"],
["&#x422;","&#x46b;","102"],
["&#x422;","&#x469;","102"],
["&#x422;","&#x467;","123"],
["&#x422;","&#x466;","143"],
["&#x422;","&#x465;","102"],
["&#x422;","&#x461;","41"],
["&#x422;","&#x460;","41"],
["&#x422;","&#x45d;","102"],
["&#x422;","&#x450;","143"],
["&#x422;","&#x201e;","123"],
["&#x422;","&#x201a;","123"],
["&#x422;","&#x2015;","82"],
["&#x422;","&#x2014;","82"],
["&#x422;","&#x2013;","82"],
["&#x422;","&#x491;","102"],
["&#x422;","&#x45f;","102"],
["&#x422;","&#x45e;","82"],
["&#x422;","&#x45c;","102"],
["&#x422;","&#x45a;","102"],
["&#x422;","&#x459;","123"],
["&#x422;","&#x455;","123"],
["&#x422;","&#x454;","143"],
["&#x422;","&#x453;","102"],
["&#x422;","&#x451;","143"],
["&#x422;","&#x44f;","61"],
["&#x422;","&#x44e;","102"],
["&#x422;","&#x44d;","41"],
["&#x422;","&#x44c;","102"],
["&#x422;","&#x44b;","102"],
["&#x422;","&#x44a;","82"],
["&#x422;","&#x449;","102"],
["&#x422;","&#x448;","102"],
["&#x422;","&#x447;","102"],
["&#x422;","&#x446;","102"],
["&#x422;","&#x445;","41"],
["&#x422;","&#x444;","143"],
["&#x422;","&#x443;","82"],
["&#x422;","&#x442;","82"],
["&#x422;","&#x441;","143"],
["&#x422;","&#x440;","102"],
["&#x422;","&#x43f;","102"],
["&#x422;","&#x43e;","143"],
["&#x422;","&#x43d;","102"],
["&#x422;","&#x43c;","102"],
["&#x422;","&#x43b;","123"],
["&#x422;","&#x43a;","102"],
["&#x422;","&#x439;","102"],
["&#x422;","&#x438;","102"],
["&#x422;","&#x437;","41"],
["&#x422;","&#x436;","41"],
["&#x422;","&#x435;","143"],
["&#x422;","&#x434;","123"],
["&#x422;","&#x433;","102"],
["&#x422;","&#x432;","102"],
["&#x422;","&#x424;","82"],
["&#x422;","&#x422;","-41"],
["&#x422;","&#x421;","41"],
["&#x422;","&#x41e;","41"],
["&#x422;","&#x41b;","102"],
["&#x422;","&#x414;","102"],
["&#x422;","&#x410;","143"],
["&#x422;","&#x409;","102"],
["&#x422;","&#x404;","41"],
["&#x422;","&#x2e;","123"],
["&#x422;","&#x2d;","82"],
["&#x422;","&#x2c;","123"],
["&#x423;","&#x513;","82"],
["&#x423;","&#x512;","102"],
["&#x423;","&#x511;","41"],
["&#x423;","&#x50d;","41"],
["&#x423;","&#x50c;","20"],
["&#x423;","&#x509;","82"],
["&#x423;","&#x508;","102"],
["&#x423;","&#x503;","41"],
["&#x423;","&#x502;","143"],
["&#x423;","&#x501;","41"],
["&#x423;","&#x500;","143"],
["&#x423;","&#x4f5;","41"],
["&#x423;","&#x4eb;","41"],
["&#x423;","&#x4ea;","20"],
["&#x423;","&#x4e9;","41"],
["&#x423;","&#x4e8;","20"],
["&#x423;","&#x4e7;","41"],
["&#x423;","&#x4e6;","20"],
["&#x423;","&#x4d7;","41"],
["&#x423;","&#x4d4;","143"],
["&#x423;","&#x4d2;","143"],
["&#x423;","&#x4d0;","143"],
["&#x423;","&#x4cc;","41"],
["&#x423;","&#x4c6;","82"],
["&#x423;","&#x4c5;","102"],
["&#x423;","&#x4bf;","61"],
["&#x423;","&#x4be;","41"],
["&#x423;","&#x4bd;","61"],
["&#x423;","&#x4bc;","41"],
["&#x423;","&#x4b9;","41"],
["&#x423;","&#x4b7;","41"],
["&#x423;","&#x4ab;","41"],
["&#x423;","&#x4aa;","20"],
["&#x423;","&#x4a9;","41"],
["&#x423;","&#x4a8;","20"],
["&#x423;","&#x49f;","-102"],
["&#x423;","&#x48d;","-102"],
["&#x423;","&#x481;","41"],
["&#x423;","&#x480;","20"],
["&#x423;","&#x47e;","20"],
["&#x423;","&#x47d;","41"],
["&#x423;","&#x47c;","20"],
["&#x423;","&#x47b;","41"],
["&#x423;","&#x47a;","20"],
["&#x423;","&#x479;","41"],
["&#x423;","&#x478;","20"],
["&#x423;","&#x473;","41"],
["&#x423;","&#x472;","20"],
["&#x423;","&#x467;","82"],
["&#x423;","&#x466;","143"],
["&#x423;","&#x460;","20"],
["&#x423;","&#x450;","41"],
["&#x423;","&#x201e;","123"],
["&#x423;","&#x201a;","123"],
["&#x423;","&#x45b;","-102"],
["&#x423;","&#x459;","82"],
["&#x423;","&#x455;","20"],
["&#x423;","&#x454;","41"],
["&#x423;","&#x452;","-102"],
["&#x423;","&#x451;","41"],
["&#x423;","&#x447;","41"],
["&#x423;","&#x444;","41"],
["&#x423;","&#x441;","41"],
["&#x423;","&#x43e;","41"],
["&#x423;","&#x43b;","82"],
["&#x423;","&#x435;","41"],
["&#x423;","&#x434;","82"],
["&#x423;","&#x42f;","20"],
["&#x423;","&#x424;","61"],
["&#x423;","&#x421;","20"],
["&#x423;","&#x41e;","20"],
["&#x423;","&#x41b;","102"],
["&#x423;","&#x414;","102"],
["&#x423;","&#x410;","143"],
["&#x423;","&#x409;","102"],
["&#x423;","&#x404;","20"],
["&#x423;","&#x2e;","123"],
["&#x423;","&#x2c;","123"],
["&#x424;","&#x513;","20"],
["&#x424;","&#x512;","41"],
["&#x424;","&#x50e;","41"],
["&#x424;","&#x509;","20"],
["&#x424;","&#x508;","41"],
["&#x424;","&#x506;","41"],
["&#x424;","&#x504;","41"],
["&#x424;","&#x4fe;","41"],
["&#x424;","&#x4fc;","41"],
["&#x424;","&#x4f2;","61"],
["&#x424;","&#x4f0;","61"],
["&#x424;","&#x4ee;","61"],
["&#x424;","&#x4ec;","41"],
["&#x424;","&#x4de;","41"],
["&#x424;","&#x4dc;","41"],
["&#x424;","&#x4d4;","41"],
["&#x424;","&#x4d2;","41"],
["&#x424;","&#x4d0;","41"],
["&#x424;","&#x4c6;","20"],
["&#x424;","&#x4c5;","41"],
["&#x424;","&#x4c1;","41"],
["&#x424;","&#x4b4;","41"],
["&#x424;","&#x4b2;","41"],
["&#x424;","&#x4b0;","61"],
["&#x424;","&#x4ae;","61"],
["&#x424;","&#x4ac;","61"],
["&#x424;","&#x4a0;","41"],
["&#x424;","&#x498;","41"],
["&#x424;","&#x496;","41"],
["&#x424;","&#x476;","20"],
["&#x424;","&#x474;","20"],
["&#x424;","&#x46e;","41"],
["&#x424;","&#x467;","20"],
["&#x424;","&#x466;","41"],
["&#x424;","&#x201e;","82"],
["&#x424;","&#x201a;","82"],
["&#x424;","&#x459;","20"],
["&#x424;","&#x43b;","20"],
["&#x424;","&#x434;","20"],
["&#x424;","&#x42d;","41"],
["&#x424;","&#x42a;","41"],
["&#x424;","&#x425;","41"],
["&#x424;","&#x423;","61"],
["&#x424;","&#x422;","61"],
["&#x424;","&#x41b;","41"],
["&#x424;","&#x417;","41"],
["&#x424;","&#x416;","41"],
["&#x424;","&#x414;","41"],
["&#x424;","&#x410;","41"],
["&#x424;","&#x40e;","61"],
["&#x424;","&#x40b;","41"],
["&#x424;","&#x409;","41"],
["&#x424;","&#x402;","41"],
["&#x424;","&#x2e;","82"],
["&#x424;","&#x2c;","82"],
["&#x425;","&#x510;","20"],
["&#x425;","&#x50c;","41"],
["&#x425;","&#x507;","41"],
["&#x425;","&#x505;","41"],
["&#x425;","&#x502;","41"],
["&#x425;","&#x500;","41"],
["&#x425;","&#x4f5;","41"],
["&#x425;","&#x4f4;","41"],
["&#x425;","&#x4ea;","41"],
["&#x425;","&#x4e8;","41"],
["&#x425;","&#x4e6;","41"],
["&#x425;","&#x4cc;","41"],
["&#x425;","&#x4cb;","41"],
["&#x425;","&#x4be;","102"],
["&#x425;","&#x4bc;","102"],
["&#x425;","&#x4b9;","41"],
["&#x425;","&#x4b8;","41"],
["&#x425;","&#x4b7;","41"],
["&#x425;","&#x4b6;","41"],
["&#x425;","&#x4aa;","41"],
["&#x425;","&#x4a8;","41"],
["&#x425;","&#x480;","41"],
["&#x425;","&#x47e;","41"],
["&#x425;","&#x47c;","41"],
["&#x425;","&#x47a;","41"],
["&#x425;","&#x478;","41"],
["&#x425;","&#x472;","41"],
["&#x425;","&#x470;","41"],
["&#x425;","&#x460;","41"],
["&#x425;","&#x447;","41"],
["&#x425;","&#x427;","41"],
["&#x425;","&#x424;","41"],
["&#x425;","&#x421;","41"],
["&#x425;","&#x41e;","41"],
["&#x425;","&#x404;","41"],
["&#x426;","&#x507;","41"],
["&#x426;","&#x505;","41"],
["&#x426;","&#x4e1;","-41"],
["&#x426;","&#x408;","-225"],
["&#x429;","&#x507;","41"],
["&#x429;","&#x505;","41"],
["&#x429;","&#x4e1;","-41"],
["&#x429;","&#x408;","-225"],
["&#x42a;","&#x50f;","41"],
["&#x42a;","&#x50e;","123"],
["&#x42a;","&#x507;","61"],
["&#x42a;","&#x506;","102"],
["&#x42a;","&#x505;","61"],
["&#x42a;","&#x504;","102"],
["&#x42a;","&#x4fa;","82"],
["&#x42a;","&#x4f5;","41"],
["&#x42a;","&#x4f4;","102"],
["&#x42a;","&#x4f3;","41"],
["&#x42a;","&#x4f2;","41"],
["&#x42a;","&#x4f1;","41"],
["&#x42a;","&#x4f0;","41"],
["&#x42a;","&#x4ef;","41"],
["&#x42a;","&#x4ee;","41"],
["&#x42a;","&#x4cc;","41"],
["&#x42a;","&#x4cb;","102"],
["&#x42a;","&#x4b9;","41"],
["&#x42a;","&#x4b8;","102"],
["&#x42a;","&#x4b7;","41"],
["&#x42a;","&#x4b6;","102"],
["&#x42a;","&#x4b5;","41"],
["&#x42a;","&#x4b4;","123"],
["&#x42a;","&#x4b1;","41"],
["&#x42a;","&#x4b0;","102"],
["&#x42a;","&#x4af;","41"],
["&#x42a;","&#x4ae;","102"],
["&#x42a;","&#x4ad;","41"],
["&#x42a;","&#x4ac;","102"],
["&#x42a;","&#x4a1;","41"],
["&#x42a;","&#x4a0;","123"],
["&#x42a;","&#x49e;","82"],
["&#x42a;","&#x492;","82"],
["&#x42a;","&#x48c;","82"],
["&#x42a;","&#x476;","82"],
["&#x42a;","&#x474;","82"],
["&#x42a;","&#x470;","102"],
["&#x42a;","&#x462;","82"],
["&#x42a;","&#x201d;","82"],
["&#x42a;","&#x2019;","82"],
["&#x42a;","&#x45e;","41"],
["&#x42a;","&#x44a;","41"],
["&#x42a;","&#x447;","41"],
["&#x42a;","&#x443;","41"],
["&#x42a;","&#x442;","41"],
["&#x42a;","&#x42a;","123"],
["&#x42a;","&#x427;","102"],
["&#x42a;","&#x423;","41"],
["&#x42a;","&#x422;","102"],
["&#x42a;","&#x40e;","41"],
["&#x42a;","&#x40b;","123"],
["&#x42a;","&#x402;","123"],
["&#x42a;","&#x27;","82"],
["&#x42a;","&#x22;","82"],
["&#x42c;","&#x50f;","41"],
["&#x42c;","&#x50e;","123"],
["&#x42c;","&#x507;","61"],
["&#x42c;","&#x506;","102"],
["&#x42c;","&#x505;","61"],
["&#x42c;","&#x504;","102"],
["&#x42c;","&#x4fa;","82"],
["&#x42c;","&#x4f5;","41"],
["&#x42c;","&#x4f4;","102"],
["&#x42c;","&#x4f3;","41"],
["&#x42c;","&#x4f2;","41"],
["&#x42c;","&#x4f1;","41"],
["&#x42c;","&#x4f0;","41"],
["&#x42c;","&#x4ef;","41"],
["&#x42c;","&#x4ee;","41"],
["&#x42c;","&#x4cc;","41"],
["&#x42c;","&#x4cb;","102"],
["&#x42c;","&#x4b9;","41"],
["&#x42c;","&#x4b8;","102"],
["&#x42c;","&#x4b7;","41"],
["&#x42c;","&#x4b6;","102"],
["&#x42c;","&#x4b5;","41"],
["&#x42c;","&#x4b4;","123"],
["&#x42c;","&#x4b1;","41"],
["&#x42c;","&#x4b0;","102"],
["&#x42c;","&#x4af;","41"],
["&#x42c;","&#x4ae;","102"],
["&#x42c;","&#x4ad;","41"],
["&#x42c;","&#x4ac;","102"],
["&#x42c;","&#x4a1;","41"],
["&#x42c;","&#x4a0;","123"],
["&#x42c;","&#x49e;","82"],
["&#x42c;","&#x492;","82"],
["&#x42c;","&#x48c;","82"],
["&#x42c;","&#x476;","82"],
["&#x42c;","&#x474;","82"],
["&#x42c;","&#x470;","102"],
["&#x42c;","&#x462;","82"],
["&#x42c;","&#x201d;","82"],
["&#x42c;","&#x2019;","82"],
["&#x42c;","&#x45e;","41"],
["&#x42c;","&#x44a;","41"],
["&#x42c;","&#x447;","41"],
["&#x42c;","&#x443;","41"],
["&#x42c;","&#x442;","41"],
["&#x42c;","&#x42a;","123"],
["&#x42c;","&#x427;","102"],
["&#x42c;","&#x423;","41"],
["&#x42c;","&#x422;","102"],
["&#x42c;","&#x40e;","41"],
["&#x42c;","&#x40b;","123"],
["&#x42c;","&#x402;","123"],
["&#x42c;","&#x27;","82"],
["&#x42c;","&#x22;","82"],
["&#x42d;","&#x513;","20"],
["&#x42d;","&#x512;","41"],
["&#x42d;","&#x50e;","20"],
["&#x42d;","&#x509;","20"],
["&#x42d;","&#x508;","41"],
["&#x42d;","&#x506;","41"],
["&#x42d;","&#x504;","41"],
["&#x42d;","&#x4fe;","41"],
["&#x42d;","&#x4fc;","41"],
["&#x42d;","&#x4f4;","41"],
["&#x42d;","&#x4f2;","41"],
["&#x42d;","&#x4f0;","41"],
["&#x42d;","&#x4ee;","41"],
["&#x42d;","&#x4ec;","20"],
["&#x42d;","&#x4de;","20"],
["&#x42d;","&#x4dc;","41"],
["&#x42d;","&#x4d4;","41"],
["&#x42d;","&#x4d2;","41"],
["&#x42d;","&#x4d0;","41"],
["&#x42d;","&#x4cb;","41"],
["&#x42d;","&#x4c6;","20"],
["&#x42d;","&#x4c5;","41"],
["&#x42d;","&#x4c1;","41"],
["&#x42d;","&#x4b8;","41"],
["&#x42d;","&#x4b6;","41"],
["&#x42d;","&#x4b4;","20"],
["&#x42d;","&#x4b2;","41"],
["&#x42d;","&#x4b0;","20"],
["&#x42d;","&#x4ae;","20"],
["&#x42d;","&#x4ac;","61"],
["&#x42d;","&#x4a0;","20"],
["&#x42d;","&#x498;","20"],
["&#x42d;","&#x496;","41"],
["&#x42d;","&#x476;","20"],
["&#x42d;","&#x474;","20"],
["&#x42d;","&#x470;","41"],
["&#x42d;","&#x46e;","20"],
["&#x42d;","&#x467;","20"],
["&#x42d;","&#x466;","41"],
["&#x42d;","&#x201e;","82"],
["&#x42d;","&#x201a;","82"],
["&#x42d;","&#x459;","20"],
["&#x42d;","&#x43b;","20"],
["&#x42d;","&#x434;","20"],
["&#x42d;","&#x42d;","20"],
["&#x42d;","&#x42a;","20"],
["&#x42d;","&#x427;","41"],
["&#x42d;","&#x425;","41"],
["&#x42d;","&#x423;","41"],
["&#x42d;","&#x422;","61"],
["&#x42d;","&#x41b;","41"],
["&#x42d;","&#x417;","20"],
["&#x42d;","&#x416;","41"],
["&#x42d;","&#x414;","41"],
["&#x42d;","&#x410;","41"],
["&#x42d;","&#x40e;","41"],
["&#x42d;","&#x40b;","20"],
["&#x42d;","&#x409;","41"],
["&#x42d;","&#x402;","20"],
["&#x42d;","&#x2e;","82"],
["&#x42d;","&#x2c;","82"],
["&#x42e;","&#x513;","20"],
["&#x42e;","&#x512;","41"],
["&#x42e;","&#x50e;","20"],
["&#x42e;","&#x509;","20"],
["&#x42e;","&#x508;","41"],
["&#x42e;","&#x506;","41"],
["&#x42e;","&#x504;","41"],
["&#x42e;","&#x4fe;","41"],
["&#x42e;","&#x4fc;","41"],
["&#x42e;","&#x4f4;","41"],
["&#x42e;","&#x4f2;","41"],
["&#x42e;","&#x4f0;","41"],
["&#x42e;","&#x4ee;","41"],
["&#x42e;","&#x4ec;","20"],
["&#x42e;","&#x4de;","20"],
["&#x42e;","&#x4dc;","41"],
["&#x42e;","&#x4d4;","41"],
["&#x42e;","&#x4d2;","41"],
["&#x42e;","&#x4d0;","41"],
["&#x42e;","&#x4cb;","41"],
["&#x42e;","&#x4c6;","20"],
["&#x42e;","&#x4c5;","41"],
["&#x42e;","&#x4c1;","41"],
["&#x42e;","&#x4b8;","41"],
["&#x42e;","&#x4b6;","41"],
["&#x42e;","&#x4b4;","20"],
["&#x42e;","&#x4b2;","41"],
["&#x42e;","&#x4b0;","20"],
["&#x42e;","&#x4ae;","20"],
["&#x42e;","&#x4ac;","61"],
["&#x42e;","&#x4a0;","20"],
["&#x42e;","&#x498;","20"],
["&#x42e;","&#x496;","41"],
["&#x42e;","&#x476;","20"],
["&#x42e;","&#x474;","20"],
["&#x42e;","&#x470;","41"],
["&#x42e;","&#x46e;","20"],
["&#x42e;","&#x467;","20"],
["&#x42e;","&#x466;","41"],
["&#x42e;","&#x201e;","82"],
["&#x42e;","&#x201a;","82"],
["&#x42e;","&#x459;","20"],
["&#x42e;","&#x43b;","20"],
["&#x42e;","&#x434;","20"],
["&#x42e;","&#x42d;","20"],
["&#x42e;","&#x42a;","20"],
["&#x42e;","&#x427;","41"],
["&#x42e;","&#x425;","41"],
["&#x42e;","&#x423;","41"],
["&#x42e;","&#x422;","61"],
["&#x42e;","&#x41b;","41"],
["&#x42e;","&#x417;","20"],
["&#x42e;","&#x416;","41"],
["&#x42e;","&#x414;","41"],
["&#x42e;","&#x410;","41"],
["&#x42e;","&#x40e;","41"],
["&#x42e;","&#x40b;","20"],
["&#x42e;","&#x409;","41"],
["&#x42e;","&#x402;","20"],
["&#x42e;","&#x2e;","82"],
["&#x42e;","&#x2c;","82"],
["&#x430;","&#x201d;","20"],
["&#x430;","&#x2019;","20"],
["&#x430;","&#x27;","20"],
["&#x430;","&#x22;","20"],
["&#x432;","&#x44f;","-41"],
["&#x433;","&#x513;","61"],
["&#x433;","&#x511;","20"],
["&#x433;","&#x50d;","20"],
["&#x433;","&#x509;","61"],
["&#x433;","&#x503;","20"],
["&#x433;","&#x501;","20"],
["&#x433;","&#x4eb;","20"],
["&#x433;","&#x4e9;","20"],
["&#x433;","&#x4e7;","20"],
["&#x433;","&#x4d7;","20"],
["&#x433;","&#x4c6;","61"],
["&#x433;","&#x4ab;","20"],
["&#x433;","&#x4a9;","20"],
["&#x433;","&#x481;","20"],
["&#x433;","&#x47d;","20"],
["&#x433;","&#x47b;","20"],
["&#x433;","&#x479;","20"],
["&#x433;","&#x473;","20"],
["&#x433;","&#x467;","61"],
["&#x433;","&#x450;","20"],
["&#x433;","&#x201e;","102"],
["&#x433;","&#x201a;","102"],
["&#x433;","&#x2015;","41"],
["&#x433;","&#x2014;","41"],
["&#x433;","&#x2013;","41"],
["&#x433;","&#x459;","61"],
["&#x433;","&#x454;","20"],
["&#x433;","&#x451;","20"],
["&#x433;","&#x444;","20"],
["&#x433;","&#x441;","20"],
["&#x433;","&#x43e;","20"],
["&#x433;","&#x43b;","61"],
["&#x433;","&#x435;","20"],
["&#x433;","&#x434;","61"],
["&#x433;","&#x2e;","102"],
["&#x433;","&#x2d;","41"],
["&#x433;","&#x2c;","102"],
["&#x434;","&#x201d;","20"],
["&#x434;","&#x2019;","20"],
["&#x434;","&#x27;","20"],
["&#x434;","&#x22;","20"],
["&#x435;","&#x201d;","20"],
["&#x435;","&#x2019;","20"],
["&#x435;","&#x27;","20"],
["&#x435;","&#x22;","20"],
["&#x436;","&#x511;","41"],
["&#x436;","&#x50d;","41"],
["&#x436;","&#x503;","41"],
["&#x436;","&#x501;","41"],
["&#x436;","&#x4f5;","41"],
["&#x436;","&#x4eb;","41"],
["&#x436;","&#x4e9;","41"],
["&#x436;","&#x4e7;","41"],
["&#x436;","&#x4d7;","41"],
["&#x436;","&#x4cc;","41"],
["&#x436;","&#x4bf;","41"],
["&#x436;","&#x4bd;","41"],
["&#x436;","&#x4b9;","41"],
["&#x436;","&#x4b7;","41"],
["&#x436;","&#x4ab;","41"],
["&#x436;","&#x4a9;","41"],
["&#x436;","&#x481;","41"],
["&#x436;","&#x47d;","41"],
["&#x436;","&#x47b;","41"],
["&#x436;","&#x479;","41"],
["&#x436;","&#x473;","41"],
["&#x436;","&#x450;","41"],
["&#x436;","&#x454;","41"],
["&#x436;","&#x451;","41"],
["&#x436;","&#x447;","41"],
["&#x436;","&#x444;","41"],
["&#x436;","&#x441;","41"],
["&#x436;","&#x43e;","41"],
["&#x436;","&#x435;","41"],
["&#x437;","&#x44f;","-41"],
["&#x43a;","&#x511;","41"],
["&#x43a;","&#x50d;","41"],
["&#x43a;","&#x503;","41"],
["&#x43a;","&#x501;","41"],
["&#x43a;","&#x4f5;","41"],
["&#x43a;","&#x4eb;","41"],
["&#x43a;","&#x4e9;","41"],
["&#x43a;","&#x4e7;","41"],
["&#x43a;","&#x4d7;","41"],
["&#x43a;","&#x4cc;","41"],
["&#x43a;","&#x4bf;","41"],
["&#x43a;","&#x4bd;","41"],
["&#x43a;","&#x4b9;","41"],
["&#x43a;","&#x4b7;","41"],
["&#x43a;","&#x4ab;","41"],
["&#x43a;","&#x4a9;","41"],
["&#x43a;","&#x481;","41"],
["&#x43a;","&#x47d;","41"],
["&#x43a;","&#x47b;","41"],
["&#x43a;","&#x479;","41"],
["&#x43a;","&#x473;","41"],
["&#x43a;","&#x450;","41"],
["&#x43a;","&#x454;","41"],
["&#x43a;","&#x451;","41"],
["&#x43a;","&#x447;","41"],
["&#x43a;","&#x444;","41"],
["&#x43a;","&#x441;","41"],
["&#x43a;","&#x43e;","41"],
["&#x43a;","&#x435;","41"],
["&#x43e;","&#x50f;","20"],
["&#x43e;","&#x507;","20"],
["&#x43e;","&#x505;","20"],
["&#x43e;","&#x4ff;","41"],
["&#x43e;","&#x4fd;","41"],
["&#x43e;","&#x4f5;","20"],
["&#x43e;","&#x4f3;","20"],
["&#x43e;","&#x4f1;","20"],
["&#x43e;","&#x4ef;","20"],
["&#x43e;","&#x4dd;","41"],
["&#x43e;","&#x4cc;","20"],
["&#x43e;","&#x4c2;","41"],
["&#x43e;","&#x4b9;","20"],
["&#x43e;","&#x4b7;","20"],
["&#x43e;","&#x4b5;","20"],
["&#x43e;","&#x4b3;","41"],
["&#x43e;","&#x4ad;","20"],
["&#x43e;","&#x4a1;","20"],
["&#x43e;","&#x497;","41"],
["&#x43e;","&#x201d;","20"],
["&#x43e;","&#x2019;","20"],
["&#x43e;","&#x45e;","20"],
["&#x43e;","&#x44a;","20"],
["&#x43e;","&#x447;","20"],
["&#x43e;","&#x445;","41"],
["&#x43e;","&#x443;","20"],
["&#x43e;","&#x442;","20"],
["&#x43e;","&#x436;","41"],
["&#x43e;","&#x27;","20"],
["&#x43e;","&#x22;","20"],
["&#x440;","&#x50f;","20"],
["&#x440;","&#x507;","20"],
["&#x440;","&#x505;","20"],
["&#x440;","&#x4ff;","41"],
["&#x440;","&#x4fd;","41"],
["&#x440;","&#x4f5;","20"],
["&#x440;","&#x4f3;","20"],
["&#x440;","&#x4f1;","20"],
["&#x440;","&#x4ef;","20"],
["&#x440;","&#x4dd;","41"],
["&#x440;","&#x4cc;","20"],
["&#x440;","&#x4c2;","41"],
["&#x440;","&#x4b9;","20"],
["&#x440;","&#x4b7;","20"],
["&#x440;","&#x4b5;","20"],
["&#x440;","&#x4b3;","41"],
["&#x440;","&#x4ad;","20"],
["&#x440;","&#x4a1;","20"],
["&#x440;","&#x497;","41"],
["&#x440;","&#x201d;","20"],
["&#x440;","&#x2019;","20"],
["&#x440;","&#x45e;","20"],
["&#x440;","&#x44a;","20"],
["&#x440;","&#x447;","20"],
["&#x440;","&#x445;","41"],
["&#x440;","&#x443;","20"],
["&#x440;","&#x442;","20"],
["&#x440;","&#x436;","41"],
["&#x440;","&#x27;","20"],
["&#x440;","&#x22;","20"],
["&#x442;","&#x513;","61"],
["&#x442;","&#x511;","20"],
["&#x442;","&#x50d;","20"],
["&#x442;","&#x509;","61"],
["&#x442;","&#x503;","20"],
["&#x442;","&#x501;","20"],
["&#x442;","&#x4eb;","20"],
["&#x442;","&#x4e9;","20"],
["&#x442;","&#x4e7;","20"],
["&#x442;","&#x4d7;","20"],
["&#x442;","&#x4c6;","61"],
["&#x442;","&#x4ab;","20"],
["&#x442;","&#x4a9;","20"],
["&#x442;","&#x481;","20"],
["&#x442;","&#x47d;","20"],
["&#x442;","&#x47b;","20"],
["&#x442;","&#x479;","20"],
["&#x442;","&#x473;","20"],
["&#x442;","&#x467;","61"],
["&#x442;","&#x450;","20"],
["&#x442;","&#x201e;","102"],
["&#x442;","&#x201a;","102"],
["&#x442;","&#x2015;","41"],
["&#x442;","&#x2014;","41"],
["&#x442;","&#x2013;","41"],
["&#x442;","&#x459;","61"],
["&#x442;","&#x454;","20"],
["&#x442;","&#x451;","20"],
["&#x442;","&#x444;","20"],
["&#x442;","&#x441;","20"],
["&#x442;","&#x43e;","20"],
["&#x442;","&#x43b;","61"],
["&#x442;","&#x435;","20"],
["&#x442;","&#x434;","61"],
["&#x442;","&#x2e;","102"],
["&#x442;","&#x2d;","41"],
["&#x442;","&#x2c;","102"],
["&#x443;","&#x513;","41"],
["&#x443;","&#x509;","41"],
["&#x443;","&#x4c6;","41"],
["&#x443;","&#x467;","41"],
["&#x443;","&#x201e;","82"],
["&#x443;","&#x201a;","82"],
["&#x443;","&#x459;","41"],
["&#x443;","&#x43b;","41"],
["&#x443;","&#x434;","41"],
["&#x443;","&#x2e;","82"],
["&#x443;","&#x2c;","82"],
["&#x444;","&#x50f;","20"],
["&#x444;","&#x507;","20"],
["&#x444;","&#x505;","20"],
["&#x444;","&#x4ff;","41"],
["&#x444;","&#x4fd;","41"],
["&#x444;","&#x4f5;","20"],
["&#x444;","&#x4f3;","20"],
["&#x444;","&#x4f1;","20"],
["&#x444;","&#x4ef;","20"],
["&#x444;","&#x4dd;","41"],
["&#x444;","&#x4cc;","20"],
["&#x444;","&#x4c2;","41"],
["&#x444;","&#x4b9;","20"],
["&#x444;","&#x4b7;","20"],
["&#x444;","&#x4b5;","20"],
["&#x444;","&#x4b3;","41"],
["&#x444;","&#x4ad;","20"],
["&#x444;","&#x4a1;","20"],
["&#x444;","&#x497;","41"],
["&#x444;","&#x201d;","20"],
["&#x444;","&#x2019;","20"],
["&#x444;","&#x45e;","20"],
["&#x444;","&#x44a;","20"],
["&#x444;","&#x447;","20"],
["&#x444;","&#x445;","41"],
["&#x444;","&#x443;","20"],
["&#x444;","&#x442;","20"],
["&#x444;","&#x436;","41"],
["&#x444;","&#x27;","20"],
["&#x444;","&#x22;","20"],
["&#x445;","&#x511;","41"],
["&#x445;","&#x50d;","41"],
["&#x445;","&#x503;","41"],
["&#x445;","&#x501;","41"],
["&#x445;","&#x4f5;","41"],
["&#x445;","&#x4eb;","41"],
["&#x445;","&#x4e9;","41"],
["&#x445;","&#x4e7;","41"],
["&#x445;","&#x4d7;","41"],
["&#x445;","&#x4cc;","41"],
["&#x445;","&#x4bf;","41"],
["&#x445;","&#x4bd;","41"],
["&#x445;","&#x4b9;","41"],
["&#x445;","&#x4b7;","41"],
["&#x445;","&#x4ab;","41"],
["&#x445;","&#x4a9;","41"],
["&#x445;","&#x481;","41"],
["&#x445;","&#x47d;","41"],
["&#x445;","&#x47b;","41"],
["&#x445;","&#x479;","41"],
["&#x445;","&#x473;","41"],
["&#x445;","&#x450;","41"],
["&#x445;","&#x454;","41"],
["&#x445;","&#x451;","41"],
["&#x445;","&#x447;","41"],
["&#x445;","&#x444;","41"],
["&#x445;","&#x441;","41"],
["&#x445;","&#x43e;","41"],
["&#x445;","&#x435;","41"],
["&#x446;","&#x201d;","20"],
["&#x446;","&#x2019;","20"],
["&#x446;","&#x27;","20"],
["&#x446;","&#x22;","20"],
["&#x449;","&#x201d;","20"],
["&#x449;","&#x2019;","20"],
["&#x449;","&#x27;","20"],
["&#x449;","&#x22;","20"],
["&#x44a;","&#x50f;","102"],
["&#x44a;","&#x507;","102"],
["&#x44a;","&#x505;","102"],
["&#x44a;","&#x4ff;","41"],
["&#x44a;","&#x4fd;","41"],
["&#x44a;","&#x4f5;","82"],
["&#x44a;","&#x4f3;","61"],
["&#x44a;","&#x4f1;","61"],
["&#x44a;","&#x4ef;","61"],
["&#x44a;","&#x4e1;","41"],
["&#x44a;","&#x4dd;","41"],
["&#x44a;","&#x4cc;","82"],
["&#x44a;","&#x4c2;","41"],
["&#x44a;","&#x4bf;","41"],
["&#x44a;","&#x4bd;","41"],
["&#x44a;","&#x4b9;","82"],
["&#x44a;","&#x4b7;","82"],
["&#x44a;","&#x4b5;","102"],
["&#x44a;","&#x4b3;","41"],
["&#x44a;","&#x4b1;","61"],
["&#x44a;","&#x4af;","61"],
["&#x44a;","&#x4ad;","102"],
["&#x44a;","&#x4a1;","102"],
["&#x44a;","&#x497;","41"],
["&#x44a;","&#x47f;","41"],
["&#x44a;","&#x477;","41"],
["&#x44a;","&#x475;","41"],
["&#x44a;","&#x461;","41"],
["&#x44a;","&#x201d;","123"],
["&#x44a;","&#x2019;","123"],
["&#x44a;","&#x45e;","61"],
["&#x44a;","&#x44a;","102"],
["&#x44a;","&#x447;","82"],
["&#x44a;","&#x445;","41"],
["&#x44a;","&#x443;","61"],
["&#x44a;","&#x442;","102"],
["&#x44a;","&#x436;","41"],
["&#x44a;","&#x27;","123"],
["&#x44a;","&#x22;","123"],
["&#x44c;","&#x50f;","102"],
["&#x44c;","&#x507;","102"],
["&#x44c;","&#x505;","102"],
["&#x44c;","&#x4ff;","41"],
["&#x44c;","&#x4fd;","41"],
["&#x44c;","&#x4f5;","82"],
["&#x44c;","&#x4f3;","61"],
["&#x44c;","&#x4f1;","61"],
["&#x44c;","&#x4ef;","61"],
["&#x44c;","&#x4e1;","41"],
["&#x44c;","&#x4dd;","41"],
["&#x44c;","&#x4cc;","82"],
["&#x44c;","&#x4c2;","41"],
["&#x44c;","&#x4bf;","41"],
["&#x44c;","&#x4bd;","41"],
["&#x44c;","&#x4b9;","82"],
["&#x44c;","&#x4b7;","82"],
["&#x44c;","&#x4b5;","102"],
["&#x44c;","&#x4b3;","41"],
["&#x44c;","&#x4b1;","61"],
["&#x44c;","&#x4af;","61"],
["&#x44c;","&#x4ad;","102"],
["&#x44c;","&#x4a1;","102"],
["&#x44c;","&#x497;","41"],
["&#x44c;","&#x47f;","41"],
["&#x44c;","&#x477;","41"],
["&#x44c;","&#x475;","41"],
["&#x44c;","&#x461;","41"],
["&#x44c;","&#x201d;","123"],
["&#x44c;","&#x2019;","123"],
["&#x44c;","&#x45e;","61"],
["&#x44c;","&#x44a;","102"],
["&#x44c;","&#x447;","82"],
["&#x44c;","&#x445;","41"],
["&#x44c;","&#x443;","61"],
["&#x44c;","&#x442;","102"],
["&#x44c;","&#x436;","41"],
["&#x44c;","&#x27;","123"],
["&#x44c;","&#x22;","123"],
["&#x44d;","&#x50f;","20"],
["&#x44d;","&#x507;","20"],
["&#x44d;","&#x505;","20"],
["&#x44d;","&#x4ff;","41"],
["&#x44d;","&#x4fd;","41"],
["&#x44d;","&#x4f5;","20"],
["&#x44d;","&#x4f3;","20"],
["&#x44d;","&#x4f1;","20"],
["&#x44d;","&#x4ef;","20"],
["&#x44d;","&#x4dd;","41"],
["&#x44d;","&#x4cc;","20"],
["&#x44d;","&#x4c2;","41"],
["&#x44d;","&#x4b9;","20"],
["&#x44d;","&#x4b7;","20"],
["&#x44d;","&#x4b5;","20"],
["&#x44d;","&#x4b3;","41"],
["&#x44d;","&#x4ad;","20"],
["&#x44d;","&#x4a1;","20"],
["&#x44d;","&#x497;","41"],
["&#x44d;","&#x201d;","20"],
["&#x44d;","&#x2019;","20"],
["&#x44d;","&#x45e;","20"],
["&#x44d;","&#x44a;","20"],
["&#x44d;","&#x447;","20"],
["&#x44d;","&#x445;","41"],
["&#x44d;","&#x443;","20"],
["&#x44d;","&#x442;","20"],
["&#x44d;","&#x436;","41"],
["&#x44d;","&#x27;","20"],
["&#x44d;","&#x22;","20"],
["&#x44e;","&#x50f;","20"],
["&#x44e;","&#x507;","20"],
["&#x44e;","&#x505;","20"],
["&#x44e;","&#x4ff;","41"],
["&#x44e;","&#x4fd;","41"],
["&#x44e;","&#x4f5;","20"],
["&#x44e;","&#x4f3;","20"],
["&#x44e;","&#x4f1;","20"],
["&#x44e;","&#x4ef;","20"],
["&#x44e;","&#x4dd;","41"],
["&#x44e;","&#x4cc;","20"],
["&#x44e;","&#x4c2;","41"],
["&#x44e;","&#x4b9;","20"],
["&#x44e;","&#x4b7;","20"],
["&#x44e;","&#x4b5;","20"],
["&#x44e;","&#x4b3;","41"],
["&#x44e;","&#x4ad;","20"],
["&#x44e;","&#x4a1;","20"],
["&#x44e;","&#x497;","41"],
["&#x44e;","&#x201d;","20"],
["&#x44e;","&#x2019;","20"],
["&#x44e;","&#x45e;","20"],
["&#x44e;","&#x44a;","20"],
["&#x44e;","&#x447;","20"],
["&#x44e;","&#x445;","41"],
["&#x44e;","&#x443;","20"],
["&#x44e;","&#x442;","20"],
["&#x44e;","&#x436;","41"],
["&#x44e;","&#x27;","20"],
["&#x44e;","&#x22;","20"],
["&#x451;","&#x201d;","20"],
["&#x451;","&#x2019;","20"],
["&#x451;","&#x27;","20"],
["&#x451;","&#x22;","20"],
["&#x452;","&#x507;","41"],
["&#x452;","&#x505;","41"],
["&#x452;","&#x201d;","20"],
["&#x452;","&#x2019;","20"],
["&#x452;","&#x27;","20"],
["&#x452;","&#x22;","20"],
["&#x453;","&#x513;","61"],
["&#x453;","&#x511;","20"],
["&#x453;","&#x50d;","20"],
["&#x453;","&#x509;","61"],
["&#x453;","&#x503;","20"],
["&#x453;","&#x501;","20"],
["&#x453;","&#x4eb;","20"],
["&#x453;","&#x4e9;","20"],
["&#x453;","&#x4e7;","20"],
["&#x453;","&#x4d7;","20"],
["&#x453;","&#x4c6;","61"],
["&#x453;","&#x4ab;","20"],
["&#x453;","&#x4a9;","20"],
["&#x453;","&#x481;","20"],
["&#x453;","&#x47d;","20"],
["&#x453;","&#x47b;","20"],
["&#x453;","&#x479;","20"],
["&#x453;","&#x473;","20"],
["&#x453;","&#x467;","61"],
["&#x453;","&#x450;","20"],
["&#x453;","&#x201e;","102"],
["&#x453;","&#x201a;","102"],
["&#x453;","&#x2015;","41"],
["&#x453;","&#x2014;","41"],
["&#x453;","&#x2013;","41"],
["&#x453;","&#x459;","61"],
["&#x453;","&#x454;","20"],
["&#x453;","&#x451;","20"],
["&#x453;","&#x444;","20"],
["&#x453;","&#x441;","20"],
["&#x453;","&#x43e;","20"],
["&#x453;","&#x43b;","61"],
["&#x453;","&#x435;","20"],
["&#x453;","&#x434;","61"],
["&#x453;","&#x2e;","102"],
["&#x453;","&#x2d;","41"],
["&#x453;","&#x2c;","102"],
["&#x459;","&#x50f;","102"],
["&#x459;","&#x507;","102"],
["&#x459;","&#x505;","102"],
["&#x459;","&#x4ff;","41"],
["&#x459;","&#x4fd;","41"],
["&#x459;","&#x4f5;","82"],
["&#x459;","&#x4f3;","61"],
["&#x459;","&#x4f1;","61"],
["&#x459;","&#x4ef;","61"],
["&#x459;","&#x4e1;","41"],
["&#x459;","&#x4dd;","41"],
["&#x459;","&#x4cc;","82"],
["&#x459;","&#x4c2;","41"],
["&#x459;","&#x4bf;","41"],
["&#x459;","&#x4bd;","41"],
["&#x459;","&#x4b9;","82"],
["&#x459;","&#x4b7;","82"],
["&#x459;","&#x4b5;","102"],
["&#x459;","&#x4b3;","41"],
["&#x459;","&#x4b1;","61"],
["&#x459;","&#x4af;","61"],
["&#x459;","&#x4ad;","102"],
["&#x459;","&#x4a1;","102"],
["&#x459;","&#x497;","41"],
["&#x459;","&#x47f;","41"],
["&#x459;","&#x477;","41"],
["&#x459;","&#x475;","41"],
["&#x459;","&#x461;","41"],
["&#x459;","&#x201d;","123"],
["&#x459;","&#x2019;","123"],
["&#x459;","&#x45e;","61"],
["&#x459;","&#x44a;","102"],
["&#x459;","&#x447;","82"],
["&#x459;","&#x445;","41"],
["&#x459;","&#x443;","61"],
["&#x459;","&#x442;","102"],
["&#x459;","&#x436;","41"],
["&#x459;","&#x27;","123"],
["&#x459;","&#x22;","123"],
["&#x45a;","&#x50f;","102"],
["&#x45a;","&#x507;","102"],
["&#x45a;","&#x505;","102"],
["&#x45a;","&#x4ff;","41"],
["&#x45a;","&#x4fd;","41"],
["&#x45a;","&#x4f5;","82"],
["&#x45a;","&#x4f3;","61"],
["&#x45a;","&#x4f1;","61"],
["&#x45a;","&#x4ef;","61"],
["&#x45a;","&#x4e1;","41"],
["&#x45a;","&#x4dd;","41"],
["&#x45a;","&#x4cc;","82"],
["&#x45a;","&#x4c2;","41"],
["&#x45a;","&#x4bf;","41"],
["&#x45a;","&#x4bd;","41"],
["&#x45a;","&#x4b9;","82"],
["&#x45a;","&#x4b7;","82"],
["&#x45a;","&#x4b5;","102"],
["&#x45a;","&#x4b3;","41"],
["&#x45a;","&#x4b1;","61"],
["&#x45a;","&#x4af;","61"],
["&#x45a;","&#x4ad;","102"],
["&#x45a;","&#x4a1;","102"],
["&#x45a;","&#x497;","41"],
["&#x45a;","&#x47f;","41"],
["&#x45a;","&#x477;","41"],
["&#x45a;","&#x475;","41"],
["&#x45a;","&#x461;","41"],
["&#x45a;","&#x201d;","123"],
["&#x45a;","&#x2019;","123"],
["&#x45a;","&#x45e;","61"],
["&#x45a;","&#x44a;","102"],
["&#x45a;","&#x447;","82"],
["&#x45a;","&#x445;","41"],
["&#x45a;","&#x443;","61"],
["&#x45a;","&#x442;","102"],
["&#x45a;","&#x436;","41"],
["&#x45a;","&#x27;","123"],
["&#x45a;","&#x22;","123"],
["&#x45b;","&#x507;","41"],
["&#x45b;","&#x505;","41"],
["&#x45b;","&#x201d;","20"],
["&#x45b;","&#x2019;","20"],
["&#x45b;","&#x27;","20"],
["&#x45b;","&#x22;","20"],
["&#x45c;","&#x511;","41"],
["&#x45c;","&#x50d;","41"],
["&#x45c;","&#x503;","41"],
["&#x45c;","&#x501;","41"],
["&#x45c;","&#x4f5;","41"],
["&#x45c;","&#x4eb;","41"],
["&#x45c;","&#x4e9;","41"],
["&#x45c;","&#x4e7;","41"],
["&#x45c;","&#x4d7;","41"],
["&#x45c;","&#x4cc;","41"],
["&#x45c;","&#x4bf;","41"],
["&#x45c;","&#x4bd;","41"],
["&#x45c;","&#x4b9;","41"],
["&#x45c;","&#x4b7;","41"],
["&#x45c;","&#x4ab;","41"],
["&#x45c;","&#x4a9;","41"],
["&#x45c;","&#x481;","41"],
["&#x45c;","&#x47d;","41"],
["&#x45c;","&#x47b;","41"],
["&#x45c;","&#x479;","41"],
["&#x45c;","&#x473;","41"],
["&#x45c;","&#x450;","41"],
["&#x45c;","&#x454;","41"],
["&#x45c;","&#x451;","41"],
["&#x45c;","&#x447;","41"],
["&#x45c;","&#x444;","41"],
["&#x45c;","&#x441;","41"],
["&#x45c;","&#x43e;","41"],
["&#x45c;","&#x435;","41"],
["&#x45e;","&#x513;","41"],
["&#x45e;","&#x509;","41"],
["&#x45e;","&#x4c6;","41"],
["&#x45e;","&#x467;","41"],
["&#x45e;","&#x201e;","82"],
["&#x45e;","&#x201a;","82"],
["&#x45e;","&#x459;","41"],
["&#x45e;","&#x43b;","41"],
["&#x45e;","&#x434;","41"],
["&#x45e;","&#x2e;","82"],
["&#x45e;","&#x2c;","82"],
["&#x490;","&#x513;","123"],
["&#x490;","&#x512;","102"],
["&#x490;","&#x511;","143"],
["&#x490;","&#x50f;","82"],
["&#x490;","&#x50d;","143"],
["&#x490;","&#x50c;","41"],
["&#x490;","&#x50b;","102"],
["&#x490;","&#x509;","123"],
["&#x490;","&#x508;","102"],
["&#x490;","&#x507;","102"],
["&#x490;","&#x505;","102"],
["&#x490;","&#x503;","143"],
["&#x490;","&#x502;","143"],
["&#x490;","&#x501;","143"],
["&#x490;","&#x500;","143"],
["&#x490;","&#x4ff;","41"],
["&#x490;","&#x4fd;","41"],
["&#x490;","&#x4f9;","102"],
["&#x490;","&#x4f7;","102"],
["&#x490;","&#x4f5;","102"],
["&#x490;","&#x4f3;","82"],
["&#x490;","&#x4f1;","82"],
["&#x490;","&#x4ef;","82"],
["&#x490;","&#x4ed;","41"],
["&#x490;","&#x4eb;","143"],
["&#x490;","&#x4ea;","41"],
["&#x490;","&#x4e9;","143"],
["&#x490;","&#x4e8;","41"],
["&#x490;","&#x4e7;","143"],
["&#x490;","&#x4e6;","41"],
["&#x490;","&#x4e5;","102"],
["&#x490;","&#x4e3;","102"],
["&#x490;","&#x4e1;","61"],
["&#x490;","&#x4df;","41"],
["&#x490;","&#x4dd;","41"],
["&#x490;","&#x4d7;","143"],
["&#x490;","&#x4d4;","143"],
["&#x490;","&#x4d2;","143"],
["&#x490;","&#x4d0;","143"],
["&#x490;","&#x4ce;","102"],
["&#x490;","&#x4cc;","102"],
["&#x490;","&#x4ca;","102"],
["&#x490;","&#x4c8;","102"],
["&#x490;","&#x4c6;","123"],
["&#x490;","&#x4c5;","102"],
["&#x490;","&#x4c4;","102"],
["&#x490;","&#x4c2;","41"],
["&#x490;","&#x4bf;","143"],
["&#x490;","&#x4be;","102"],
["&#x490;","&#x4bd;","143"],
["&#x490;","&#x4bc;","102"],
["&#x490;","&#x4bb;","102"],
["&#x490;","&#x4b9;","102"],
["&#x490;","&#x4b7;","102"],
["&#x490;","&#x4b5;","82"],
["&#x490;","&#x4b3;","41"],
["&#x490;","&#x4b1;","82"],
["&#x490;","&#x4af;","82"],
["&#x490;","&#x4ad;","82"],
["&#x490;","&#x4ac;","-41"],
["&#x490;","&#x4ab;","143"],
["&#x490;","&#x4aa;","41"],
["&#x490;","&#x4a9;","143"],
["&#x490;","&#x4a8;","41"],
["&#x490;","&#x4a7;","102"],
["&#x490;","&#x4a5;","102"],
["&#x490;","&#x4a3;","102"],
["&#x490;","&#x4a1;","82"],
["&#x490;","&#x49d;","102"],
["&#x490;","&#x49b;","102"],
["&#x490;","&#x499;","41"],
["&#x490;","&#x497;","41"],
["&#x490;","&#x495;","102"],
["&#x490;","&#x48f;","102"],
["&#x490;","&#x48b;","102"],
["&#x490;","&#x481;","143"],
["&#x490;","&#x480;","41"],
["&#x490;","&#x47f;","41"],
["&#x490;","&#x47e;","41"],
["&#x490;","&#x47d;","143"],
["&#x490;","&#x47c;","41"],
["&#x490;","&#x47b;","143"],
["&#x490;","&#x47a;","41"],
["&#x490;","&#x479;","143"],
["&#x490;","&#x478;","41"],
["&#x490;","&#x477;","41"],
["&#x490;","&#x475;","41"],
["&#x490;","&#x473;","143"],
["&#x490;","&#x472;","41"],
["&#x490;","&#x471;","102"],
["&#x490;","&#x46d;","102"],
["&#x490;","&#x46b;","102"],
["&#x490;","&#x469;","102"],
["&#x490;","&#x467;","123"],
["&#x490;","&#x466;","143"],
["&#x490;","&#x465;","102"],
["&#x490;","&#x461;","41"],
["&#x490;","&#x460;","41"],
["&#x490;","&#x45d;","102"],
["&#x490;","&#x450;","143"],
["&#x490;","&#x201e;","123"],
["&#x490;","&#x201a;","123"],
["&#x490;","&#x2015;","82"],
["&#x490;","&#x2014;","82"],
["&#x490;","&#x2013;","82"],
["&#x490;","&#x491;","102"],
["&#x490;","&#x45f;","102"],
["&#x490;","&#x45e;","82"],
["&#x490;","&#x45c;","102"],
["&#x490;","&#x45a;","102"],
["&#x490;","&#x459;","123"],
["&#x490;","&#x455;","123"],
["&#x490;","&#x454;","143"],
["&#x490;","&#x453;","102"],
["&#x490;","&#x451;","143"],
["&#x490;","&#x44f;","61"],
["&#x490;","&#x44e;","102"],
["&#x490;","&#x44d;","41"],
["&#x490;","&#x44c;","102"],
["&#x490;","&#x44b;","102"],
["&#x490;","&#x44a;","82"],
["&#x490;","&#x449;","102"],
["&#x490;","&#x448;","102"],
["&#x490;","&#x447;","102"],
["&#x490;","&#x446;","102"],
["&#x490;","&#x445;","41"],
["&#x490;","&#x444;","143"],
["&#x490;","&#x443;","82"],
["&#x490;","&#x442;","82"],
["&#x490;","&#x441;","143"],
["&#x490;","&#x440;","102"],
["&#x490;","&#x43f;","102"],
["&#x490;","&#x43e;","143"],
["&#x490;","&#x43d;","102"],
["&#x490;","&#x43c;","102"],
["&#x490;","&#x43b;","123"],
["&#x490;","&#x43a;","102"],
["&#x490;","&#x439;","102"],
["&#x490;","&#x438;","102"],
["&#x490;","&#x437;","41"],
["&#x490;","&#x436;","41"],
["&#x490;","&#x435;","143"],
["&#x490;","&#x434;","123"],
["&#x490;","&#x433;","102"],
["&#x490;","&#x432;","102"],
["&#x490;","&#x424;","82"],
["&#x490;","&#x422;","-41"],
["&#x490;","&#x421;","41"],
["&#x490;","&#x41e;","41"],
["&#x490;","&#x41b;","102"],
["&#x490;","&#x414;","102"],
["&#x490;","&#x410;","143"],
["&#x490;","&#x409;","102"],
["&#x490;","&#x404;","41"],
["&#x490;","&#x2e;","123"],
["&#x490;","&#x2d;","82"],
["&#x490;","&#x2c;","123"],
["&#x491;","&#x513;","61"],
["&#x491;","&#x511;","20"],
["&#x491;","&#x50d;","20"],
["&#x491;","&#x509;","61"],
["&#x491;","&#x503;","20"],
["&#x491;","&#x501;","20"],
["&#x491;","&#x4eb;","20"],
["&#x491;","&#x4e9;","20"],
["&#x491;","&#x4e7;","20"],
["&#x491;","&#x4d7;","20"],
["&#x491;","&#x4c6;","61"],
["&#x491;","&#x4ab;","20"],
["&#x491;","&#x4a9;","20"],
["&#x491;","&#x481;","20"],
["&#x491;","&#x47d;","20"],
["&#x491;","&#x47b;","20"],
["&#x491;","&#x479;","20"],
["&#x491;","&#x473;","20"],
["&#x491;","&#x467;","61"],
["&#x491;","&#x450;","20"],
["&#x491;","&#x201e;","102"],
["&#x491;","&#x201a;","102"],
["&#x491;","&#x2015;","41"],
["&#x491;","&#x2014;","41"],
["&#x491;","&#x2013;","41"],
["&#x491;","&#x459;","61"],
["&#x491;","&#x454;","20"],
["&#x491;","&#x451;","20"],
["&#x491;","&#x444;","20"],
["&#x491;","&#x441;","20"],
["&#x491;","&#x43e;","20"],
["&#x491;","&#x43b;","61"],
["&#x491;","&#x435;","20"],
["&#x491;","&#x434;","61"],
["&#x491;","&#x2e;","102"],
["&#x491;","&#x2d;","41"],
["&#x491;","&#x2c;","102"],
["&#x1e80;","&#x1ef1;","20"],
["&#x1e80;","&#x1eef;","20"],
["&#x1e80;","&#x1eed;","20"],
["&#x1e80;","&#x1eeb;","20"],
["&#x1e80;","&#x1ee9;","20"],
["&#x1e80;","&#x1ee7;","20"],
["&#x1e80;","&#x1ee5;","20"],
["&#x1e80;","&#x1ee3;","41"],
["&#x1e80;","&#x1ee2;","20"],
["&#x1e80;","&#x1ee1;","41"],
["&#x1e80;","&#x1ee0;","20"],
["&#x1e80;","&#x1edf;","41"],
["&#x1e80;","&#x1ede;","20"],
["&#x1e80;","&#x1edd;","41"],
["&#x1e80;","&#x1edc;","20"],
["&#x1e80;","&#x1edb;","41"],
["&#x1e80;","&#x1eda;","20"],
["&#x1e80;","&#x1ed9;","41"],
["&#x1e80;","&#x1ed8;","20"],
["&#x1e80;","&#x1ed7;","41"],
["&#x1e80;","&#x1ed6;","20"],
["&#x1e80;","&#x1ed5;","41"],
["&#x1e80;","&#x1ed4;","20"],
["&#x1e80;","&#x1ed2;","20"],
["&#x1e80;","&#x1ed1;","41"],
["&#x1e80;","&#x1ed0;","20"],
["&#x1e80;","&#x1ecf;","41"],
["&#x1e80;","&#x1ece;","20"],
["&#x1e80;","&#x1ecd;","41"],
["&#x1e80;","&#x1ecc;","20"],
["&#x1e80;","&#x1ec7;","41"],
["&#x1e80;","&#x1ec5;","41"],
["&#x1e80;","&#x1ec3;","41"],
["&#x1e80;","&#x1ebf;","41"],
["&#x1e80;","&#x1ebd;","41"],
["&#x1e80;","&#x1ebb;","41"],
["&#x1e80;","&#x1eb9;","41"],
["&#x1e80;","&#x1eb7;","41"],
["&#x1e80;","&#x1eb6;","82"],
["&#x1e80;","&#x1eb5;","41"],
["&#x1e80;","&#x1eb4;","82"],
["&#x1e80;","&#x1eb3;","41"],
["&#x1e80;","&#x1eb2;","82"],
["&#x1e80;","&#x1eb1;","41"],
["&#x1e80;","&#x1eb0;","82"],
["&#x1e80;","&#x1eaf;","41"],
["&#x1e80;","&#x1eae;","82"],
["&#x1e80;","&#x1ead;","41"],
["&#x1e80;","&#x1eac;","82"],
["&#x1e80;","&#x1eab;","41"],
["&#x1e80;","&#x1eaa;","82"],
["&#x1e80;","&#x1ea9;","41"],
["&#x1e80;","&#x1ea8;","82"],
["&#x1e80;","&#x1ea6;","82"],
["&#x1e80;","&#x1ea5;","41"],
["&#x1e80;","&#x1ea4;","82"],
["&#x1e80;","&#x1ea3;","41"],
["&#x1e80;","&#x1ea2;","82"],
["&#x1e80;","&#x1ea1;","41"],
["&#x1e80;","&#x1ea0;","82"],
["&#x1e80;","&#x1b0;","20"],
["&#x1e80;","&#x1a1;","41"],
["&#x1e80;","&#x1a0;","20"],
["&#x1e80;","&#x1e01;","41"],
["&#x1e80;","&#x1e00;","82"],
["&#x1e80;","&#x1e3f;","20"],
["&#x1e80;","&#x201e;","102"],
["&#x1e80;","&#x201a;","102"],
["&#x1e80;","&#x219;","20"],
["&#x1e80;","&#x1ff;","41"],
["&#x1e80;","&#x1fe;","20"],
["&#x1e80;","&#x1fd;","41"],
["&#x1e80;","&#x1fb;","41"],
["&#x1e80;","&#x1fa;","82"],
["&#x1e80;","&#x173;","20"],
["&#x1e80;","&#x171;","20"],
["&#x1e80;","&#x16f;","20"],
["&#x1e80;","&#x16d;","20"],
["&#x1e80;","&#x16b;","20"],
["&#x1e80;","&#x169;","20"],
["&#x1e80;","&#x15f;","20"],
["&#x1e80;","&#x15b;","20"],
["&#x1e80;","&#x157;","20"],
["&#x1e80;","&#x155;","20"],
["&#x1e80;","&#x153;","41"],
["&#x1e80;","&#x152;","20"],
["&#x1e80;","&#x151;","41"],
["&#x1e80;","&#x150;","20"],
["&#x1e80;","&#x14f;","41"],
["&#x1e80;","&#x14e;","20"],
["&#x1e80;","&#x14d;","41"],
["&#x1e80;","&#x14c;","20"],
["&#x1e80;","&#x14b;","20"],
["&#x1e80;","&#x146;","20"],
["&#x1e80;","&#x144;","20"],
["&#x1e80;","&#x138;","20"],
["&#x1e80;","&#x123;","20"],
["&#x1e80;","&#x122;","20"],
["&#x1e80;","&#x121;","20"],
["&#x1e80;","&#x120;","20"],
["&#x1e80;","&#x11f;","20"],
["&#x1e80;","&#x11e;","20"],
["&#x1e80;","&#x11d;","20"],
["&#x1e80;","&#x11c;","20"],
["&#x1e80;","&#x11b;","41"],
["&#x1e80;","&#x119;","41"],
["&#x1e80;","&#x117;","41"],
["&#x1e80;","&#x115;","41"],
["&#x1e80;","&#x113;","41"],
["&#x1e80;","&#x111;","41"],
["&#x1e80;","&#x10f;","41"],
["&#x1e80;","&#x10d;","41"],
["&#x1e80;","&#x10c;","20"],
["&#x1e80;","&#x10b;","41"],
["&#x1e80;","&#x10a;","20"],
["&#x1e80;","&#x109;","41"],
["&#x1e80;","&#x108;","20"],
["&#x1e80;","&#x107;","41"],
["&#x1e80;","&#x106;","20"],
["&#x1e80;","&#x105;","41"],
["&#x1e80;","&#x104;","82"],
["&#x1e80;","&#x103;","41"],
["&#x1e80;","&#x102;","82"],
["&#x1e80;","&#x101;","41"],
["&#x1e80;","&#x100;","82"],
["&#x1e80;","&#xfc;","20"],
["&#x1e80;","&#xfb;","20"],
["&#x1e80;","&#xfa;","20"],
["&#x1e80;","&#xf9;","20"],
["&#x1e80;","&#xf8;","41"],
["&#x1e80;","&#xf6;","41"],
["&#x1e80;","&#xf5;","41"],
["&#x1e80;","&#xf4;","41"],
["&#x1e80;","&#xf3;","41"],
["&#x1e80;","&#xf2;","41"],
["&#x1e80;","&#xeb;","41"],
["&#x1e80;","&#xea;","41"],
["&#x1e80;","&#xe9;","41"],
["&#x1e80;","&#xe8;","41"],
["&#x1e80;","&#xe7;","41"],
["&#x1e80;","&#xe6;","41"],
["&#x1e80;","&#xe5;","41"],
["&#x1e80;","&#xe4;","41"],
["&#x1e80;","&#xe3;","41"],
["&#x1e80;","&#xe2;","41"],
["&#x1e80;","&#xe1;","41"],
["&#x1e80;","&#xe0;","41"],
["&#x1e80;","&#xd8;","20"],
["&#x1e80;","&#xd6;","20"],
["&#x1e80;","&#xd5;","20"],
["&#x1e80;","&#xd4;","20"],
["&#x1e80;","&#xd3;","20"],
["&#x1e80;","&#xd2;","20"],
["&#x1e80;","&#xc7;","20"],
["&#x1e80;","&#xc5;","82"],
["&#x1e80;","&#xc4;","82"],
["&#x1e80;","&#xc3;","82"],
["&#x1e80;","&#xc2;","82"],
["&#x1e80;","&#xc1;","82"],
["&#x1e80;","&#xc0;","82"],
["&#x1e80;","u","20"],
["&#x1e80;","s","20"],
["&#x1e80;","r","20"],
["&#x1e80;","q","41"],
["&#x1e80;","p","20"],
["&#x1e80;","o","41"],
["&#x1e80;","n","20"],
["&#x1e80;","m","20"],
["&#x1e80;","g","20"],
["&#x1e80;","e","41"],
["&#x1e80;","d","41"],
["&#x1e80;","c","41"],
["&#x1e80;","a","41"],
["&#x1e80;","Q","20"],
["&#x1e80;","O","20"],
["&#x1e80;","G","20"],
["&#x1e80;","C","20"],
["&#x1e80;","A","82"],
["&#x1e80;","&#x3f;","-41"],
["&#x1e80;","&#x2e;","102"],
["&#x1e80;","&#x2c;","102"],
["&#x1e81;","&#x201e;","82"],
["&#x1e81;","&#x201d;","-82"],
["&#x1e81;","&#x201a;","82"],
["&#x1e81;","&#x2019;","-82"],
["&#x1e81;","&#x3f;","-41"],
["&#x1e81;","&#x2e;","82"],
["&#x1e81;","&#x2c;","82"],
["&#x1e81;","&#x27;","-82"],
["&#x1e81;","&#x22;","-82"],
["&#x1e82;","&#x1ef1;","20"],
["&#x1e82;","&#x1eef;","20"],
["&#x1e82;","&#x1eed;","20"],
["&#x1e82;","&#x1eeb;","20"],
["&#x1e82;","&#x1ee9;","20"],
["&#x1e82;","&#x1ee7;","20"],
["&#x1e82;","&#x1ee5;","20"],
["&#x1e82;","&#x1ee3;","41"],
["&#x1e82;","&#x1ee2;","20"],
["&#x1e82;","&#x1ee1;","41"],
["&#x1e82;","&#x1ee0;","20"],
["&#x1e82;","&#x1edf;","41"],
["&#x1e82;","&#x1ede;","20"],
["&#x1e82;","&#x1edd;","41"],
["&#x1e82;","&#x1edc;","20"],
["&#x1e82;","&#x1edb;","41"],
["&#x1e82;","&#x1eda;","20"],
["&#x1e82;","&#x1ed9;","41"],
["&#x1e82;","&#x1ed8;","20"],
["&#x1e82;","&#x1ed7;","41"],
["&#x1e82;","&#x1ed6;","20"],
["&#x1e82;","&#x1ed5;","41"],
["&#x1e82;","&#x1ed4;","20"],
["&#x1e82;","&#x1ed2;","20"],
["&#x1e82;","&#x1ed1;","41"],
["&#x1e82;","&#x1ed0;","20"],
["&#x1e82;","&#x1ecf;","41"],
["&#x1e82;","&#x1ece;","20"],
["&#x1e82;","&#x1ecd;","41"],
["&#x1e82;","&#x1ecc;","20"],
["&#x1e82;","&#x1ec7;","41"],
["&#x1e82;","&#x1ec5;","41"],
["&#x1e82;","&#x1ec3;","41"],
["&#x1e82;","&#x1ebf;","41"],
["&#x1e82;","&#x1ebd;","41"],
["&#x1e82;","&#x1ebb;","41"],
["&#x1e82;","&#x1eb9;","41"],
["&#x1e82;","&#x1eb7;","41"],
["&#x1e82;","&#x1eb6;","82"],
["&#x1e82;","&#x1eb5;","41"],
["&#x1e82;","&#x1eb4;","82"],
["&#x1e82;","&#x1eb3;","41"],
["&#x1e82;","&#x1eb2;","82"],
["&#x1e82;","&#x1eb1;","41"],
["&#x1e82;","&#x1eb0;","82"],
["&#x1e82;","&#x1eaf;","41"],
["&#x1e82;","&#x1eae;","82"],
["&#x1e82;","&#x1ead;","41"],
["&#x1e82;","&#x1eac;","82"],
["&#x1e82;","&#x1eab;","41"],
["&#x1e82;","&#x1eaa;","82"],
["&#x1e82;","&#x1ea9;","41"],
["&#x1e82;","&#x1ea8;","82"],
["&#x1e82;","&#x1ea6;","82"],
["&#x1e82;","&#x1ea5;","41"],
["&#x1e82;","&#x1ea4;","82"],
["&#x1e82;","&#x1ea3;","41"],
["&#x1e82;","&#x1ea2;","82"],
["&#x1e82;","&#x1ea1;","41"],
["&#x1e82;","&#x1ea0;","82"],
["&#x1e82;","&#x1b0;","20"],
["&#x1e82;","&#x1a1;","41"],
["&#x1e82;","&#x1a0;","20"],
["&#x1e82;","&#x1e01;","41"],
["&#x1e82;","&#x1e00;","82"],
["&#x1e82;","&#x1e3f;","20"],
["&#x1e82;","&#x201e;","102"],
["&#x1e82;","&#x201a;","102"],
["&#x1e82;","&#x219;","20"],
["&#x1e82;","&#x1ff;","41"],
["&#x1e82;","&#x1fe;","20"],
["&#x1e82;","&#x1fd;","41"],
["&#x1e82;","&#x1fb;","41"],
["&#x1e82;","&#x1fa;","82"],
["&#x1e82;","&#x173;","20"],
["&#x1e82;","&#x171;","20"],
["&#x1e82;","&#x16f;","20"],
["&#x1e82;","&#x16d;","20"],
["&#x1e82;","&#x16b;","20"],
["&#x1e82;","&#x169;","20"],
["&#x1e82;","&#x15f;","20"],
["&#x1e82;","&#x15b;","20"],
["&#x1e82;","&#x157;","20"],
["&#x1e82;","&#x155;","20"],
["&#x1e82;","&#x153;","41"],
["&#x1e82;","&#x152;","20"],
["&#x1e82;","&#x151;","41"],
["&#x1e82;","&#x150;","20"],
["&#x1e82;","&#x14f;","41"],
["&#x1e82;","&#x14e;","20"],
["&#x1e82;","&#x14d;","41"],
["&#x1e82;","&#x14c;","20"],
["&#x1e82;","&#x14b;","20"],
["&#x1e82;","&#x146;","20"],
["&#x1e82;","&#x144;","20"],
["&#x1e82;","&#x138;","20"],
["&#x1e82;","&#x123;","20"],
["&#x1e82;","&#x122;","20"],
["&#x1e82;","&#x121;","20"],
["&#x1e82;","&#x120;","20"],
["&#x1e82;","&#x11f;","20"],
["&#x1e82;","&#x11e;","20"],
["&#x1e82;","&#x11d;","20"],
["&#x1e82;","&#x11c;","20"],
["&#x1e82;","&#x11b;","41"],
["&#x1e82;","&#x119;","41"],
["&#x1e82;","&#x117;","41"],
["&#x1e82;","&#x115;","41"],
["&#x1e82;","&#x113;","41"],
["&#x1e82;","&#x111;","41"],
["&#x1e82;","&#x10f;","41"],
["&#x1e82;","&#x10d;","41"],
["&#x1e82;","&#x10c;","20"],
["&#x1e82;","&#x10b;","41"],
["&#x1e82;","&#x10a;","20"],
["&#x1e82;","&#x109;","41"],
["&#x1e82;","&#x108;","20"],
["&#x1e82;","&#x107;","41"],
["&#x1e82;","&#x106;","20"],
["&#x1e82;","&#x105;","41"],
["&#x1e82;","&#x104;","82"],
["&#x1e82;","&#x103;","41"],
["&#x1e82;","&#x102;","82"],
["&#x1e82;","&#x101;","41"],
["&#x1e82;","&#x100;","82"],
["&#x1e82;","&#xfc;","20"],
["&#x1e82;","&#xfb;","20"],
["&#x1e82;","&#xfa;","20"],
["&#x1e82;","&#xf9;","20"],
["&#x1e82;","&#xf8;","41"],
["&#x1e82;","&#xf6;","41"],
["&#x1e82;","&#xf5;","41"],
["&#x1e82;","&#xf4;","41"],
["&#x1e82;","&#xf3;","41"],
["&#x1e82;","&#xf2;","41"],
["&#x1e82;","&#xeb;","41"],
["&#x1e82;","&#xea;","41"],
["&#x1e82;","&#xe9;","41"],
["&#x1e82;","&#xe8;","41"],
["&#x1e82;","&#xe7;","41"],
["&#x1e82;","&#xe6;","41"],
["&#x1e82;","&#xe5;","41"],
["&#x1e82;","&#xe4;","41"],
["&#x1e82;","&#xe3;","41"],
["&#x1e82;","&#xe2;","41"],
["&#x1e82;","&#xe1;","41"],
["&#x1e82;","&#xe0;","41"],
["&#x1e82;","&#xd8;","20"],
["&#x1e82;","&#xd6;","20"],
["&#x1e82;","&#xd5;","20"],
["&#x1e82;","&#xd4;","20"],
["&#x1e82;","&#xd3;","20"],
["&#x1e82;","&#xd2;","20"],
["&#x1e82;","&#xc7;","20"],
["&#x1e82;","&#xc5;","82"],
["&#x1e82;","&#xc4;","82"],
["&#x1e82;","&#xc3;","82"],
["&#x1e82;","&#xc2;","82"],
["&#x1e82;","&#xc1;","82"],
["&#x1e82;","&#xc0;","82"],
["&#x1e82;","u","20"],
["&#x1e82;","s","20"],
["&#x1e82;","r","20"],
["&#x1e82;","q","41"],
["&#x1e82;","p","20"],
["&#x1e82;","o","41"],
["&#x1e82;","n","20"],
["&#x1e82;","m","20"],
["&#x1e82;","g","20"],
["&#x1e82;","e","41"],
["&#x1e82;","d","41"],
["&#x1e82;","c","41"],
["&#x1e82;","a","41"],
["&#x1e82;","Q","20"],
["&#x1e82;","O","20"],
["&#x1e82;","G","20"],
["&#x1e82;","C","20"],
["&#x1e82;","A","82"],
["&#x1e82;","&#x3f;","-41"],
["&#x1e82;","&#x2e;","102"],
["&#x1e82;","&#x2c;","102"],
["&#x1e83;","&#x201e;","82"],
["&#x1e83;","&#x201d;","-82"],
["&#x1e83;","&#x201a;","82"],
["&#x1e83;","&#x2019;","-82"],
["&#x1e83;","&#x3f;","-41"],
["&#x1e83;","&#x2e;","82"],
["&#x1e83;","&#x2c;","82"],
["&#x1e83;","&#x27;","-82"],
["&#x1e83;","&#x22;","-82"],
["&#x1e84;","&#x1ef1;","20"],
["&#x1e84;","&#x1eef;","20"],
["&#x1e84;","&#x1eed;","20"],
["&#x1e84;","&#x1eeb;","20"],
["&#x1e84;","&#x1ee9;","20"],
["&#x1e84;","&#x1ee7;","20"],
["&#x1e84;","&#x1ee5;","20"],
["&#x1e84;","&#x1ee3;","41"],
["&#x1e84;","&#x1ee2;","20"],
["&#x1e84;","&#x1ee1;","41"],
["&#x1e84;","&#x1ee0;","20"],
["&#x1e84;","&#x1edf;","41"],
["&#x1e84;","&#x1ede;","20"],
["&#x1e84;","&#x1edd;","41"],
["&#x1e84;","&#x1edc;","20"],
["&#x1e84;","&#x1edb;","41"],
["&#x1e84;","&#x1eda;","20"],
["&#x1e84;","&#x1ed9;","41"],
["&#x1e84;","&#x1ed8;","20"],
["&#x1e84;","&#x1ed7;","41"],
["&#x1e84;","&#x1ed6;","20"],
["&#x1e84;","&#x1ed5;","41"],
["&#x1e84;","&#x1ed4;","20"],
["&#x1e84;","&#x1ed2;","20"],
["&#x1e84;","&#x1ed1;","41"],
["&#x1e84;","&#x1ed0;","20"],
["&#x1e84;","&#x1ecf;","41"],
["&#x1e84;","&#x1ece;","20"],
["&#x1e84;","&#x1ecd;","41"],
["&#x1e84;","&#x1ecc;","20"],
["&#x1e84;","&#x1ec7;","41"],
["&#x1e84;","&#x1ec5;","41"],
["&#x1e84;","&#x1ec3;","41"],
["&#x1e84;","&#x1ebf;","41"],
["&#x1e84;","&#x1ebd;","41"],
["&#x1e84;","&#x1ebb;","41"],
["&#x1e84;","&#x1eb9;","41"],
["&#x1e84;","&#x1eb7;","41"],
["&#x1e84;","&#x1eb6;","82"],
["&#x1e84;","&#x1eb5;","41"],
["&#x1e84;","&#x1eb4;","82"],
["&#x1e84;","&#x1eb3;","41"],
["&#x1e84;","&#x1eb2;","82"],
["&#x1e84;","&#x1eb1;","41"],
["&#x1e84;","&#x1eb0;","82"],
["&#x1e84;","&#x1eaf;","41"],
["&#x1e84;","&#x1eae;","82"],
["&#x1e84;","&#x1ead;","41"],
["&#x1e84;","&#x1eac;","82"],
["&#x1e84;","&#x1eab;","41"],
["&#x1e84;","&#x1eaa;","82"],
["&#x1e84;","&#x1ea9;","41"],
["&#x1e84;","&#x1ea8;","82"],
["&#x1e84;","&#x1ea6;","82"],
["&#x1e84;","&#x1ea5;","41"],
["&#x1e84;","&#x1ea4;","82"],
["&#x1e84;","&#x1ea3;","41"],
["&#x1e84;","&#x1ea2;","82"],
["&#x1e84;","&#x1ea1;","41"],
["&#x1e84;","&#x1ea0;","82"],
["&#x1e84;","&#x1b0;","20"],
["&#x1e84;","&#x1a1;","41"],
["&#x1e84;","&#x1a0;","20"],
["&#x1e84;","&#x1e01;","41"],
["&#x1e84;","&#x1e00;","82"],
["&#x1e84;","&#x1e3f;","20"],
["&#x1e84;","&#x201e;","102"],
["&#x1e84;","&#x201a;","102"],
["&#x1e84;","&#x219;","20"],
["&#x1e84;","&#x1ff;","41"],
["&#x1e84;","&#x1fe;","20"],
["&#x1e84;","&#x1fd;","41"],
["&#x1e84;","&#x1fb;","41"],
["&#x1e84;","&#x1fa;","82"],
["&#x1e84;","&#x173;","20"],
["&#x1e84;","&#x171;","20"],
["&#x1e84;","&#x16f;","20"],
["&#x1e84;","&#x16d;","20"],
["&#x1e84;","&#x16b;","20"],
["&#x1e84;","&#x169;","20"],
["&#x1e84;","&#x15f;","20"],
["&#x1e84;","&#x15b;","20"],
["&#x1e84;","&#x157;","20"],
["&#x1e84;","&#x155;","20"],
["&#x1e84;","&#x153;","41"],
["&#x1e84;","&#x152;","20"],
["&#x1e84;","&#x151;","41"],
["&#x1e84;","&#x150;","20"],
["&#x1e84;","&#x14f;","41"],
["&#x1e84;","&#x14e;","20"],
["&#x1e84;","&#x14d;","41"],
["&#x1e84;","&#x14c;","20"],
["&#x1e84;","&#x14b;","20"],
["&#x1e84;","&#x146;","20"],
["&#x1e84;","&#x144;","20"],
["&#x1e84;","&#x138;","20"],
["&#x1e84;","&#x123;","20"],
["&#x1e84;","&#x122;","20"],
["&#x1e84;","&#x121;","20"],
["&#x1e84;","&#x120;","20"],
["&#x1e84;","&#x11f;","20"],
["&#x1e84;","&#x11e;","20"],
["&#x1e84;","&#x11d;","20"],
["&#x1e84;","&#x11c;","20"],
["&#x1e84;","&#x11b;","41"],
["&#x1e84;","&#x119;","41"],
["&#x1e84;","&#x117;","41"],
["&#x1e84;","&#x115;","41"],
["&#x1e84;","&#x113;","41"],
["&#x1e84;","&#x111;","41"],
["&#x1e84;","&#x10f;","41"],
["&#x1e84;","&#x10d;","41"],
["&#x1e84;","&#x10c;","20"],
["&#x1e84;","&#x10b;","41"],
["&#x1e84;","&#x10a;","20"],
["&#x1e84;","&#x109;","41"],
["&#x1e84;","&#x108;","20"],
["&#x1e84;","&#x107;","41"],
["&#x1e84;","&#x106;","20"],
["&#x1e84;","&#x105;","41"],
["&#x1e84;","&#x104;","82"],
["&#x1e84;","&#x103;","41"],
["&#x1e84;","&#x102;","82"],
["&#x1e84;","&#x101;","41"],
["&#x1e84;","&#x100;","82"],
["&#x1e84;","&#xfc;","20"],
["&#x1e84;","&#xfb;","20"],
["&#x1e84;","&#xfa;","20"],
["&#x1e84;","&#xf9;","20"],
["&#x1e84;","&#xf8;","41"],
["&#x1e84;","&#xf6;","41"],
["&#x1e84;","&#xf5;","41"],
["&#x1e84;","&#xf4;","41"],
["&#x1e84;","&#xf3;","41"],
["&#x1e84;","&#xf2;","41"],
["&#x1e84;","&#xeb;","41"],
["&#x1e84;","&#xea;","41"],
["&#x1e84;","&#xe9;","41"],
["&#x1e84;","&#xe8;","41"],
["&#x1e84;","&#xe7;","41"],
["&#x1e84;","&#xe6;","41"],
["&#x1e84;","&#xe5;","41"],
["&#x1e84;","&#xe4;","41"],
["&#x1e84;","&#xe3;","41"],
["&#x1e84;","&#xe2;","41"],
["&#x1e84;","&#xe1;","41"],
["&#x1e84;","&#xe0;","41"],
["&#x1e84;","&#xd8;","20"],
["&#x1e84;","&#xd6;","20"],
["&#x1e84;","&#xd5;","20"],
["&#x1e84;","&#xd4;","20"],
["&#x1e84;","&#xd3;","20"],
["&#x1e84;","&#xd2;","20"],
["&#x1e84;","&#xc7;","20"],
["&#x1e84;","&#xc5;","82"],
["&#x1e84;","&#xc4;","82"],
["&#x1e84;","&#xc3;","82"],
["&#x1e84;","&#xc2;","82"],
["&#x1e84;","&#xc1;","82"],
["&#x1e84;","&#xc0;","82"],
["&#x1e84;","u","20"],
["&#x1e84;","s","20"],
["&#x1e84;","r","20"],
["&#x1e84;","q","41"],
["&#x1e84;","p","20"],
["&#x1e84;","o","41"],
["&#x1e84;","n","20"],
["&#x1e84;","m","20"],
["&#x1e84;","g","20"],
["&#x1e84;","e","41"],
["&#x1e84;","d","41"],
["&#x1e84;","c","41"],
["&#x1e84;","a","41"],
["&#x1e84;","Q","20"],
["&#x1e84;","O","20"],
["&#x1e84;","G","20"],
["&#x1e84;","C","20"],
["&#x1e84;","A","82"],
["&#x1e84;","&#x3f;","-41"],
["&#x1e84;","&#x2e;","102"],
["&#x1e84;","&#x2c;","102"],
["&#x1e85;","&#x201e;","82"],
["&#x1e85;","&#x201d;","-82"],
["&#x1e85;","&#x201a;","82"],
["&#x1e85;","&#x2019;","-82"],
["&#x1e85;","&#x3f;","-41"],
["&#x1e85;","&#x2e;","82"],
["&#x1e85;","&#x2c;","82"],
["&#x1e85;","&#x27;","-82"],
["&#x1e85;","&#x22;","-82"],
["&#x1ef2;","&#x1ef1;","61"],
["&#x1ef2;","&#x1eef;","61"],
["&#x1ef2;","&#x1eed;","61"],
["&#x1ef2;","&#x1eeb;","61"],
["&#x1ef2;","&#x1ee9;","61"],
["&#x1ef2;","&#x1ee7;","61"],
["&#x1ef2;","&#x1ee5;","61"],
["&#x1ef2;","&#x1ee3;","102"],
["&#x1ef2;","&#x1ee2;","41"],
["&#x1ef2;","&#x1ee1;","102"],
["&#x1ef2;","&#x1ee0;","41"],
["&#x1ef2;","&#x1edf;","102"],
["&#x1ef2;","&#x1ede;","41"],
["&#x1ef2;","&#x1edd;","102"],
["&#x1ef2;","&#x1edc;","41"],
["&#x1ef2;","&#x1edb;","102"],
["&#x1ef2;","&#x1eda;","41"],
["&#x1ef2;","&#x1ed9;","102"],
["&#x1ef2;","&#x1ed8;","41"],
["&#x1ef2;","&#x1ed7;","102"],
["&#x1ef2;","&#x1ed6;","41"],
["&#x1ef2;","&#x1ed5;","102"],
["&#x1ef2;","&#x1ed4;","41"],
["&#x1ef2;","&#x1ed2;","41"],
["&#x1ef2;","&#x1ed1;","102"],
["&#x1ef2;","&#x1ed0;","41"],
["&#x1ef2;","&#x1ecf;","102"],
["&#x1ef2;","&#x1ece;","41"],
["&#x1ef2;","&#x1ecd;","102"],
["&#x1ef2;","&#x1ecc;","41"],
["&#x1ef2;","&#x1ec7;","102"],
["&#x1ef2;","&#x1ec5;","102"],
["&#x1ef2;","&#x1ec3;","102"],
["&#x1ef2;","&#x1ebf;","102"],
["&#x1ef2;","&#x1ebd;","102"],
["&#x1ef2;","&#x1ebb;","102"],
["&#x1ef2;","&#x1eb9;","102"],
["&#x1ef2;","&#x1eb7;","102"],
["&#x1ef2;","&#x1eb6;","123"],
["&#x1ef2;","&#x1eb5;","102"],
["&#x1ef2;","&#x1eb4;","123"],
["&#x1ef2;","&#x1eb3;","102"],
["&#x1ef2;","&#x1eb2;","123"],
["&#x1ef2;","&#x1eb1;","102"],
["&#x1ef2;","&#x1eb0;","123"],
["&#x1ef2;","&#x1eaf;","102"],
["&#x1ef2;","&#x1eae;","123"],
["&#x1ef2;","&#x1ead;","102"],
["&#x1ef2;","&#x1eac;","123"],
["&#x1ef2;","&#x1eab;","102"],
["&#x1ef2;","&#x1eaa;","123"],
["&#x1ef2;","&#x1ea9;","102"],
["&#x1ef2;","&#x1ea8;","123"],
["&#x1ef2;","&#x1ea6;","123"],
["&#x1ef2;","&#x1ea5;","102"],
["&#x1ef2;","&#x1ea4;","123"],
["&#x1ef2;","&#x1ea3;","102"],
["&#x1ef2;","&#x1ea2;","123"],
["&#x1ef2;","&#x1ea1;","102"],
["&#x1ef2;","&#x1ea0;","123"],
["&#x1ef2;","&#x1b0;","61"],
["&#x1ef2;","&#x1a1;","102"],
["&#x1ef2;","&#x1a0;","41"],
["&#x1ef2;","&#x1e01;","102"],
["&#x1ef2;","&#x1e00;","123"],
["&#x1ef2;","&#x1e3f;","61"],
["&#x1ef2;","&#x201e;","123"],
["&#x1ef2;","&#x201a;","123"],
["&#x1ef2;","&#x219;","82"],
["&#x1ef2;","&#x1ff;","102"],
["&#x1ef2;","&#x1fe;","41"],
["&#x1ef2;","&#x1fd;","102"],
["&#x1ef2;","&#x1fb;","102"],
["&#x1ef2;","&#x1fa;","123"],
["&#x1ef2;","&#x17e;","41"],
["&#x1ef2;","&#x17c;","41"],
["&#x1ef2;","&#x17a;","41"],
["&#x1ef2;","&#x173;","61"],
["&#x1ef2;","&#x171;","61"],
["&#x1ef2;","&#x16f;","61"],
["&#x1ef2;","&#x16d;","61"],
["&#x1ef2;","&#x16b;","61"],
["&#x1ef2;","&#x169;","61"],
["&#x1ef2;","&#x15f;","82"],
["&#x1ef2;","&#x15b;","82"],
["&#x1ef2;","&#x157;","61"],
["&#x1ef2;","&#x155;","61"],
["&#x1ef2;","&#x153;","102"],
["&#x1ef2;","&#x152;","41"],
["&#x1ef2;","&#x151;","102"],
["&#x1ef2;","&#x150;","41"],
["&#x1ef2;","&#x14f;","102"],
["&#x1ef2;","&#x14e;","41"],
["&#x1ef2;","&#x14d;","102"],
["&#x1ef2;","&#x14c;","41"],
["&#x1ef2;","&#x14b;","61"],
["&#x1ef2;","&#x146;","61"],
["&#x1ef2;","&#x144;","61"],
["&#x1ef2;","&#x138;","61"],
["&#x1ef2;","&#x123;","41"],
["&#x1ef2;","&#x122;","41"],
["&#x1ef2;","&#x121;","41"],
["&#x1ef2;","&#x120;","41"],
["&#x1ef2;","&#x11f;","41"],
["&#x1ef2;","&#x11e;","41"],
["&#x1ef2;","&#x11d;","41"],
["&#x1ef2;","&#x11c;","41"],
["&#x1ef2;","&#x11b;","102"],
["&#x1ef2;","&#x119;","102"],
["&#x1ef2;","&#x117;","102"],
["&#x1ef2;","&#x115;","102"],
["&#x1ef2;","&#x113;","102"],
["&#x1ef2;","&#x111;","102"],
["&#x1ef2;","&#x10f;","102"],
["&#x1ef2;","&#x10d;","102"],
["&#x1ef2;","&#x10c;","41"],
["&#x1ef2;","&#x10b;","102"],
["&#x1ef2;","&#x10a;","41"],
["&#x1ef2;","&#x109;","102"],
["&#x1ef2;","&#x108;","41"],
["&#x1ef2;","&#x107;","102"],
["&#x1ef2;","&#x106;","41"],
["&#x1ef2;","&#x105;","102"],
["&#x1ef2;","&#x104;","123"],
["&#x1ef2;","&#x103;","102"],
["&#x1ef2;","&#x102;","123"],
["&#x1ef2;","&#x101;","102"],
["&#x1ef2;","&#x100;","123"],
["&#x1ef2;","&#xfc;","61"],
["&#x1ef2;","&#xfb;","61"],
["&#x1ef2;","&#xfa;","61"],
["&#x1ef2;","&#xf9;","61"],
["&#x1ef2;","&#xf8;","102"],
["&#x1ef2;","&#xf6;","102"],
["&#x1ef2;","&#xf5;","102"],
["&#x1ef2;","&#xf4;","102"],
["&#x1ef2;","&#xf3;","102"],
["&#x1ef2;","&#xf2;","102"],
["&#x1ef2;","&#xeb;","102"],
["&#x1ef2;","&#xea;","102"],
["&#x1ef2;","&#xe9;","102"],
["&#x1ef2;","&#xe8;","102"],
["&#x1ef2;","&#xe7;","102"],
["&#x1ef2;","&#xe6;","102"],
["&#x1ef2;","&#xe5;","102"],
["&#x1ef2;","&#xe4;","102"],
["&#x1ef2;","&#xe3;","102"],
["&#x1ef2;","&#xe2;","102"],
["&#x1ef2;","&#xe1;","102"],
["&#x1ef2;","&#xe0;","102"],
["&#x1ef2;","&#xd8;","41"],
["&#x1ef2;","&#xd6;","41"],
["&#x1ef2;","&#xd5;","41"],
["&#x1ef2;","&#xd4;","41"],
["&#x1ef2;","&#xd3;","41"],
["&#x1ef2;","&#xd2;","41"],
["&#x1ef2;","&#xc7;","41"],
["&#x1ef2;","&#xc5;","123"],
["&#x1ef2;","&#xc4;","123"],
["&#x1ef2;","&#xc3;","123"],
["&#x1ef2;","&#xc2;","123"],
["&#x1ef2;","&#xc1;","123"],
["&#x1ef2;","&#xc0;","123"],
["&#x1ef2;","z","41"],
["&#x1ef2;","u","61"],
["&#x1ef2;","s","82"],
["&#x1ef2;","r","61"],
["&#x1ef2;","q","102"],
["&#x1ef2;","p","61"],
["&#x1ef2;","o","102"],
["&#x1ef2;","n","61"],
["&#x1ef2;","m","61"],
["&#x1ef2;","g","41"],
["&#x1ef2;","e","102"],
["&#x1ef2;","d","102"],
["&#x1ef2;","c","102"],
["&#x1ef2;","a","102"],
["&#x1ef2;","Q","41"],
["&#x1ef2;","O","41"],
["&#x1ef2;","G","41"],
["&#x1ef2;","C","41"],
["&#x1ef2;","A","123"],
["&#x1ef2;","&#x3f;","-41"],
["&#x1ef2;","&#x2e;","123"],
["&#x1ef2;","&#x2c;","123"],
["&#x1ef3;","&#x201e;","82"],
["&#x1ef3;","&#x201d;","-82"],
["&#x1ef3;","&#x201a;","82"],
["&#x1ef3;","&#x2019;","-82"],
["&#x1ef3;","&#x3f;","-41"],
["&#x1ef3;","&#x2e;","82"],
["&#x1ef3;","&#x2c;","82"],
["&#x1ef3;","&#x27;","-82"],
["&#x1ef3;","&#x22;","-82"],
["&#x2013;","&#x162;","82"],
["&#x2013;","&#x50f;","41"],
["&#x2013;","&#x50e;","82"],
["&#x2013;","&#x4b5;","41"],
["&#x2013;","&#x4b4;","82"],
["&#x2013;","&#x4ad;","41"],
["&#x2013;","&#x4ac;","82"],
["&#x2013;","&#x4a1;","41"],
["&#x2013;","&#x4a0;","82"],
["&#x2013;","&#x44a;","41"],
["&#x2013;","&#x442;","41"],
["&#x2013;","&#x42a;","82"],
["&#x2013;","&#x422;","82"],
["&#x2013;","&#x40b;","82"],
["&#x2013;","&#x402;","82"],
["&#x2013;","&#x3a4;","82"],
["&#x2013;","&#x164;","82"],
["&#x2013;","&#x21a;","82"],
["&#x2013;","T","82"],
["&#x2014;","&#x162;","82"],
["&#x2014;","&#x50f;","41"],
["&#x2014;","&#x50e;","82"],
["&#x2014;","&#x4b5;","41"],
["&#x2014;","&#x4b4;","82"],
["&#x2014;","&#x4ad;","41"],
["&#x2014;","&#x4ac;","82"],
["&#x2014;","&#x4a1;","41"],
["&#x2014;","&#x4a0;","82"],
["&#x2014;","&#x44a;","41"],
["&#x2014;","&#x442;","41"],
["&#x2014;","&#x42a;","82"],
["&#x2014;","&#x422;","82"],
["&#x2014;","&#x40b;","82"],
["&#x2014;","&#x402;","82"],
["&#x2014;","&#x3a4;","82"],
["&#x2014;","&#x164;","82"],
["&#x2014;","&#x21a;","82"],
["&#x2014;","T","82"],
["&#x2015;","&#x162;","82"],
["&#x2015;","&#x50f;","41"],
["&#x2015;","&#x50e;","82"],
["&#x2015;","&#x4b5;","41"],
["&#x2015;","&#x4b4;","82"],
["&#x2015;","&#x4ad;","41"],
["&#x2015;","&#x4ac;","82"],
["&#x2015;","&#x4a1;","41"],
["&#x2015;","&#x4a0;","82"],
["&#x2015;","&#x44a;","41"],
["&#x2015;","&#x442;","41"],
["&#x2015;","&#x42a;","82"],
["&#x2015;","&#x422;","82"],
["&#x2015;","&#x40b;","82"],
["&#x2015;","&#x402;","82"],
["&#x2015;","&#x3a4;","82"],
["&#x2015;","&#x164;","82"],
["&#x2015;","&#x21a;","82"],
["&#x2015;","T","82"],
["&#x2018;","&#x162;","-41"],
["&#x2018;","&#x1ef8;","-20"],
["&#x2018;","&#x1ef6;","-20"],
["&#x2018;","&#x1ef4;","-20"],
["&#x2018;","&#x1ef1;","61"],
["&#x2018;","&#x1eef;","61"],
["&#x2018;","&#x1eed;","61"],
["&#x2018;","&#x1eeb;","61"],
["&#x2018;","&#x1ee9;","61"],
["&#x2018;","&#x1ee7;","61"],
["&#x2018;","&#x1ee5;","61"],
["&#x2018;","&#x1ee3;","123"],
["&#x2018;","&#x1ee1;","123"],
["&#x2018;","&#x1edf;","123"],
["&#x2018;","&#x1edd;","123"],
["&#x2018;","&#x1edb;","123"],
["&#x2018;","&#x1ed9;","123"],
["&#x2018;","&#x1ed7;","123"],
["&#x2018;","&#x1ed5;","123"],
["&#x2018;","&#x1ed1;","123"],
["&#x2018;","&#x1ecf;","123"],
["&#x2018;","&#x1ecd;","123"],
["&#x2018;","&#x1ec7;","123"],
["&#x2018;","&#x1ec5;","123"],
["&#x2018;","&#x1ec3;","123"],
["&#x2018;","&#x1ebf;","123"],
["&#x2018;","&#x1ebd;","123"],
["&#x2018;","&#x1ebb;","123"],
["&#x2018;","&#x1eb9;","123"],
["&#x2018;","&#x1eb7;","82"],
["&#x2018;","&#x1eb6;","143"],
["&#x2018;","&#x1eb5;","82"],
["&#x2018;","&#x1eb4;","143"],
["&#x2018;","&#x1eb3;","82"],
["&#x2018;","&#x1eb2;","143"],
["&#x2018;","&#x1eb1;","82"],
["&#x2018;","&#x1eb0;","143"],
["&#x2018;","&#x1eaf;","82"],
["&#x2018;","&#x1eae;","143"],
["&#x2018;","&#x1ead;","82"],
["&#x2018;","&#x1eac;","143"],
["&#x2018;","&#x1eab;","82"],
["&#x2018;","&#x1eaa;","143"],
["&#x2018;","&#x1ea9;","82"],
["&#x2018;","&#x1ea8;","143"],
["&#x2018;","&#x1ea6;","143"],
["&#x2018;","&#x1ea5;","82"],
["&#x2018;","&#x1ea4;","143"],
["&#x2018;","&#x1ea3;","82"],
["&#x2018;","&#x1ea2;","143"],
["&#x2018;","&#x1ea1;","82"],
["&#x2018;","&#x1ea0;","143"],
["&#x2018;","&#x513;","143"],
["&#x2018;","&#x512;","123"],
["&#x2018;","&#x511;","123"],
["&#x2018;","&#x50d;","123"],
["&#x2018;","&#x509;","143"],
["&#x2018;","&#x508;","123"],
["&#x2018;","&#x503;","123"],
["&#x2018;","&#x502;","143"],
["&#x2018;","&#x501;","123"],
["&#x2018;","&#x500;","143"],
["&#x2018;","&#x4eb;","123"],
["&#x2018;","&#x4e9;","123"],
["&#x2018;","&#x4e7;","123"],
["&#x2018;","&#x4db;","41"],
["&#x2018;","&#x4d9;","41"],
["&#x2018;","&#x4d7;","123"],
["&#x2018;","&#x4d5;","41"],
["&#x2018;","&#x4d4;","143"],
["&#x2018;","&#x4d3;","41"],
["&#x2018;","&#x4d2;","143"],
["&#x2018;","&#x4d1;","41"],
["&#x2018;","&#x4d0;","143"],
["&#x2018;","&#x4c6;","143"],
["&#x2018;","&#x4c5;","123"],
["&#x2018;","&#x4ab;","123"],
["&#x2018;","&#x4a9;","123"],
["&#x2018;","&#x481;","123"],
["&#x2018;","&#x47d;","123"],
["&#x2018;","&#x47b;","123"],
["&#x2018;","&#x479;","123"],
["&#x2018;","&#x473;","123"],
["&#x2018;","&#x471;","20"],
["&#x2018;","&#x467;","143"],
["&#x2018;","&#x466;","143"],
["&#x2018;","&#x450;","123"],
["&#x2018;","&#x1b0;","61"],
["&#x2018;","&#x1a1;","123"],
["&#x2018;","&#x1e01;","82"],
["&#x2018;","&#x1e00;","143"],
["&#x2018;","&#x1e3f;","61"],
["&#x2018;","&#x1ef2;","-20"],
["&#x2018;","&#x1e84;","-41"],
["&#x2018;","&#x1e82;","-41"],
["&#x2018;","&#x1e80;","-41"],
["&#x2018;","&#x459;","143"],
["&#x2018;","&#x455;","61"],
["&#x2018;","&#x454;","123"],
["&#x2018;","&#x451;","123"],
["&#x2018;","&#x444;","123"],
["&#x2018;","&#x441;","123"],
["&#x2018;","&#x43e;","123"],
["&#x2018;","&#x43b;","143"],
["&#x2018;","&#x435;","123"],
["&#x2018;","&#x434;","143"],
["&#x2018;","&#x430;","41"],
["&#x2018;","&#x41b;","123"],
["&#x2018;","&#x414;","123"],
["&#x2018;","&#x410;","143"],
["&#x2018;","&#x409;","123"],
["&#x2018;","&#x3cc;","82"],
["&#x2018;","&#x3c6;","82"],
["&#x2018;","&#x3c3;","82"],
["&#x2018;","&#x3c2;","82"],
["&#x2018;","&#x3c1;","61"],
["&#x2018;","&#x3bf;","82"],
["&#x2018;","&#x3bc;","41"],
["&#x2018;","&#x3ba;","41"],
["&#x2018;","&#x3b7;","41"],
["&#x2018;","&#x3b6;","41"],
["&#x2018;","&#x3b5;","41"],
["&#x2018;","&#x3b4;","61"],
["&#x2018;","&#x3b1;","82"],
["&#x2018;","&#x3ae;","41"],
["&#x2018;","&#x3ad;","41"],
["&#x2018;","&#x3ac;","82"],
["&#x2018;","&#x39b;","143"],
["&#x2018;","&#x394;","143"],
["&#x2018;","&#x391;","143"],
["&#x2018;","&#x386;","143"],
["&#x2018;","&#x219;","61"],
["&#x2018;","&#x1ff;","123"],
["&#x2018;","&#x1fd;","82"],
["&#x2018;","&#x1fb;","82"],
["&#x2018;","&#x1fa;","143"],
["&#x2018;","&#x178;","-20"],
["&#x2018;","&#x176;","-20"],
["&#x2018;","&#x174;","-41"],
["&#x2018;","&#x173;","61"],
["&#x2018;","&#x171;","61"],
["&#x2018;","&#x16f;","61"],
["&#x2018;","&#x16d;","61"],
["&#x2018;","&#x16b;","61"],
["&#x2018;","&#x169;","61"],
["&#x2018;","&#x164;","-41"],
["&#x2018;","&#x21a;","-41"],
["&#x2018;","&#x15f;","61"],
["&#x2018;","&#x15b;","61"],
["&#x2018;","&#x157;","61"],
["&#x2018;","&#x155;","61"],
["&#x2018;","&#x153;","123"],
["&#x2018;","&#x151;","123"],
["&#x2018;","&#x14f;","123"],
["&#x2018;","&#x14d;","123"],
["&#x2018;","&#x14b;","61"],
["&#x2018;","&#x146;","61"],
["&#x2018;","&#x144;","61"],
["&#x2018;","&#x138;","61"],
["&#x2018;","&#x123;","61"],
["&#x2018;","&#x121;","61"],
["&#x2018;","&#x11f;","61"],
["&#x2018;","&#x11d;","61"],
["&#x2018;","&#x11b;","123"],
["&#x2018;","&#x119;","123"],
["&#x2018;","&#x117;","123"],
["&#x2018;","&#x115;","123"],
["&#x2018;","&#x113;","123"],
["&#x2018;","&#x111;","123"],
["&#x2018;","&#x10f;","123"],
["&#x2018;","&#x10d;","123"],
["&#x2018;","&#x10b;","123"],
["&#x2018;","&#x109;","123"],
["&#x2018;","&#x107;","123"],
["&#x2018;","&#x105;","82"],
["&#x2018;","&#x104;","143"],
["&#x2018;","&#x103;","82"],
["&#x2018;","&#x102;","143"],
["&#x2018;","&#x101;","82"],
["&#x2018;","&#x100;","143"],
["&#x2018;","&#xfc;","61"],
["&#x2018;","&#xfb;","61"],
["&#x2018;","&#xfa;","61"],
["&#x2018;","&#xf9;","61"],
["&#x2018;","&#xf8;","123"],
["&#x2018;","&#xf6;","123"],
["&#x2018;","&#xf5;","123"],
["&#x2018;","&#xf4;","123"],
["&#x2018;","&#xf3;","123"],
["&#x2018;","&#xf2;","123"],
["&#x2018;","&#xeb;","123"],
["&#x2018;","&#xea;","123"],
["&#x2018;","&#xe9;","123"],
["&#x2018;","&#xe8;","123"],
["&#x2018;","&#xe7;","123"],
["&#x2018;","&#xe6;","82"],
["&#x2018;","&#xe5;","82"],
["&#x2018;","&#xe4;","82"],
["&#x2018;","&#xe3;","82"],
["&#x2018;","&#xe2;","82"],
["&#x2018;","&#xe1;","82"],
["&#x2018;","&#xe0;","123"],
["&#x2018;","&#xdd;","-20"],
["&#x2018;","&#xc5;","143"],
["&#x2018;","&#xc4;","143"],
["&#x2018;","&#xc3;","143"],
["&#x2018;","&#xc2;","143"],
["&#x2018;","&#xc1;","143"],
["&#x2018;","&#xc0;","143"],
["&#x2018;","u","61"],
["&#x2018;","s","61"],
["&#x2018;","r","61"],
["&#x2018;","q","123"],
["&#x2018;","p","61"],
["&#x2018;","o","123"],
["&#x2018;","n","61"],
["&#x2018;","m","61"],
["&#x2018;","g","61"],
["&#x2018;","e","123"],
["&#x2018;","d","123"],
["&#x2018;","c","123"],
["&#x2018;","a","82"],
["&#x2018;","Y","-20"],
["&#x2018;","W","-41"],
["&#x2018;","V","-41"],
["&#x2018;","T","-41"],
["&#x2018;","A","143"],
["&#x2019;","&#x162;","-41"],
["&#x2019;","&#x1ef8;","-20"],
["&#x2019;","&#x1ef6;","-20"],
["&#x2019;","&#x1ef4;","-20"],
["&#x2019;","&#x1ef1;","61"],
["&#x2019;","&#x1eef;","61"],
["&#x2019;","&#x1eed;","61"],
["&#x2019;","&#x1eeb;","61"],
["&#x2019;","&#x1ee9;","61"],
["&#x2019;","&#x1ee7;","61"],
["&#x2019;","&#x1ee5;","61"],
["&#x2019;","&#x1ee3;","123"],
["&#x2019;","&#x1ee1;","123"],
["&#x2019;","&#x1edf;","123"],
["&#x2019;","&#x1edd;","123"],
["&#x2019;","&#x1edb;","123"],
["&#x2019;","&#x1ed9;","123"],
["&#x2019;","&#x1ed7;","123"],
["&#x2019;","&#x1ed5;","123"],
["&#x2019;","&#x1ed1;","123"],
["&#x2019;","&#x1ecf;","123"],
["&#x2019;","&#x1ecd;","123"],
["&#x2019;","&#x1ec7;","123"],
["&#x2019;","&#x1ec5;","123"],
["&#x2019;","&#x1ec3;","123"],
["&#x2019;","&#x1ebf;","123"],
["&#x2019;","&#x1ebd;","123"],
["&#x2019;","&#x1ebb;","123"],
["&#x2019;","&#x1eb9;","123"],
["&#x2019;","&#x1eb7;","82"],
["&#x2019;","&#x1eb6;","143"],
["&#x2019;","&#x1eb5;","82"],
["&#x2019;","&#x1eb4;","143"],
["&#x2019;","&#x1eb3;","82"],
["&#x2019;","&#x1eb2;","143"],
["&#x2019;","&#x1eb1;","82"],
["&#x2019;","&#x1eb0;","143"],
["&#x2019;","&#x1eaf;","82"],
["&#x2019;","&#x1eae;","143"],
["&#x2019;","&#x1ead;","82"],
["&#x2019;","&#x1eac;","143"],
["&#x2019;","&#x1eab;","82"],
["&#x2019;","&#x1eaa;","143"],
["&#x2019;","&#x1ea9;","82"],
["&#x2019;","&#x1ea8;","143"],
["&#x2019;","&#x1ea6;","143"],
["&#x2019;","&#x1ea5;","82"],
["&#x2019;","&#x1ea4;","143"],
["&#x2019;","&#x1ea3;","82"],
["&#x2019;","&#x1ea2;","143"],
["&#x2019;","&#x1ea1;","82"],
["&#x2019;","&#x1ea0;","143"],
["&#x2019;","&#x513;","143"],
["&#x2019;","&#x512;","123"],
["&#x2019;","&#x511;","123"],
["&#x2019;","&#x50d;","123"],
["&#x2019;","&#x509;","143"],
["&#x2019;","&#x508;","123"],
["&#x2019;","&#x503;","123"],
["&#x2019;","&#x502;","143"],
["&#x2019;","&#x501;","123"],
["&#x2019;","&#x500;","143"],
["&#x2019;","&#x4eb;","123"],
["&#x2019;","&#x4e9;","123"],
["&#x2019;","&#x4e7;","123"],
["&#x2019;","&#x4db;","41"],
["&#x2019;","&#x4d9;","41"],
["&#x2019;","&#x4d7;","123"],
["&#x2019;","&#x4d5;","41"],
["&#x2019;","&#x4d4;","143"],
["&#x2019;","&#x4d3;","41"],
["&#x2019;","&#x4d2;","143"],
["&#x2019;","&#x4d1;","41"],
["&#x2019;","&#x4d0;","143"],
["&#x2019;","&#x4c6;","143"],
["&#x2019;","&#x4c5;","123"],
["&#x2019;","&#x4ab;","123"],
["&#x2019;","&#x4a9;","123"],
["&#x2019;","&#x481;","123"],
["&#x2019;","&#x47d;","123"],
["&#x2019;","&#x47b;","123"],
["&#x2019;","&#x479;","123"],
["&#x2019;","&#x473;","123"],
["&#x2019;","&#x471;","20"],
["&#x2019;","&#x467;","143"],
["&#x2019;","&#x466;","143"],
["&#x2019;","&#x450;","123"],
["&#x2019;","&#x1b0;","61"],
["&#x2019;","&#x1a1;","123"],
["&#x2019;","&#x1e01;","82"],
["&#x2019;","&#x1e00;","143"],
["&#x2019;","&#x1e3f;","61"],
["&#x2019;","&#x1ef2;","-20"],
["&#x2019;","&#x1e84;","-41"],
["&#x2019;","&#x1e82;","-41"],
["&#x2019;","&#x1e80;","-41"],
["&#x2019;","&#x459;","143"],
["&#x2019;","&#x455;","61"],
["&#x2019;","&#x454;","123"],
["&#x2019;","&#x451;","123"],
["&#x2019;","&#x444;","123"],
["&#x2019;","&#x441;","123"],
["&#x2019;","&#x43e;","123"],
["&#x2019;","&#x43b;","143"],
["&#x2019;","&#x435;","123"],
["&#x2019;","&#x434;","143"],
["&#x2019;","&#x430;","41"],
["&#x2019;","&#x41b;","123"],
["&#x2019;","&#x414;","123"],
["&#x2019;","&#x410;","143"],
["&#x2019;","&#x409;","123"],
["&#x2019;","&#x3cc;","82"],
["&#x2019;","&#x3c6;","82"],
["&#x2019;","&#x3c3;","82"],
["&#x2019;","&#x3c2;","82"],
["&#x2019;","&#x3c1;","61"],
["&#x2019;","&#x3bf;","82"],
["&#x2019;","&#x3bc;","41"],
["&#x2019;","&#x3ba;","41"],
["&#x2019;","&#x3b7;","41"],
["&#x2019;","&#x3b6;","41"],
["&#x2019;","&#x3b5;","41"],
["&#x2019;","&#x3b4;","61"],
["&#x2019;","&#x3b1;","82"],
["&#x2019;","&#x3ae;","41"],
["&#x2019;","&#x3ad;","41"],
["&#x2019;","&#x3ac;","82"],
["&#x2019;","&#x39b;","143"],
["&#x2019;","&#x394;","143"],
["&#x2019;","&#x391;","143"],
["&#x2019;","&#x386;","143"],
["&#x2019;","&#x219;","61"],
["&#x2019;","&#x1ff;","123"],
["&#x2019;","&#x1fd;","82"],
["&#x2019;","&#x1fb;","82"],
["&#x2019;","&#x1fa;","143"],
["&#x2019;","&#x178;","-20"],
["&#x2019;","&#x176;","-20"],
["&#x2019;","&#x174;","-41"],
["&#x2019;","&#x173;","61"],
["&#x2019;","&#x171;","61"],
["&#x2019;","&#x16f;","61"],
["&#x2019;","&#x16d;","61"],
["&#x2019;","&#x16b;","61"],
["&#x2019;","&#x169;","61"],
["&#x2019;","&#x164;","-41"],
["&#x2019;","&#x21a;","-41"],
["&#x2019;","&#x15f;","61"],
["&#x2019;","&#x15b;","61"],
["&#x2019;","&#x157;","61"],
["&#x2019;","&#x155;","61"],
["&#x2019;","&#x153;","123"],
["&#x2019;","&#x151;","123"],
["&#x2019;","&#x14f;","123"],
["&#x2019;","&#x14d;","123"],
["&#x2019;","&#x14b;","61"],
["&#x2019;","&#x146;","61"],
["&#x2019;","&#x144;","61"],
["&#x2019;","&#x138;","61"],
["&#x2019;","&#x123;","61"],
["&#x2019;","&#x121;","61"],
["&#x2019;","&#x11f;","61"],
["&#x2019;","&#x11d;","61"],
["&#x2019;","&#x11b;","123"],
["&#x2019;","&#x119;","123"],
["&#x2019;","&#x117;","123"],
["&#x2019;","&#x115;","123"],
["&#x2019;","&#x113;","123"],
["&#x2019;","&#x111;","123"],
["&#x2019;","&#x10f;","123"],
["&#x2019;","&#x10d;","123"],
["&#x2019;","&#x10b;","123"],
["&#x2019;","&#x109;","123"],
["&#x2019;","&#x107;","123"],
["&#x2019;","&#x105;","82"],
["&#x2019;","&#x104;","143"],
["&#x2019;","&#x103;","82"],
["&#x2019;","&#x102;","143"],
["&#x2019;","&#x101;","82"],
["&#x2019;","&#x100;","143"],
["&#x2019;","&#xfc;","61"],
["&#x2019;","&#xfb;","61"],
["&#x2019;","&#xfa;","61"],
["&#x2019;","&#xf9;","61"],
["&#x2019;","&#xf8;","123"],
["&#x2019;","&#xf6;","123"],
["&#x2019;","&#xf5;","123"],
["&#x2019;","&#xf4;","123"],
["&#x2019;","&#xf3;","123"],
["&#x2019;","&#xf2;","123"],
["&#x2019;","&#xeb;","123"],
["&#x2019;","&#xea;","123"],
["&#x2019;","&#xe9;","123"],
["&#x2019;","&#xe8;","123"],
["&#x2019;","&#xe7;","123"],
["&#x2019;","&#xe6;","82"],
["&#x2019;","&#xe5;","82"],
["&#x2019;","&#xe4;","82"],
["&#x2019;","&#xe3;","82"],
["&#x2019;","&#xe2;","82"],
["&#x2019;","&#xe1;","82"],
["&#x2019;","&#xe0;","123"],
["&#x2019;","&#xdd;","-20"],
["&#x2019;","&#xc5;","143"],
["&#x2019;","&#xc4;","143"],
["&#x2019;","&#xc3;","143"],
["&#x2019;","&#xc2;","143"],
["&#x2019;","&#xc1;","143"],
["&#x2019;","&#xc0;","143"],
["&#x2019;","u","61"],
["&#x2019;","s","61"],
["&#x2019;","r","61"],
["&#x2019;","q","123"],
["&#x2019;","p","61"],
["&#x2019;","o","123"],
["&#x2019;","n","61"],
["&#x2019;","m","61"],
["&#x2019;","g","61"],
["&#x2019;","e","123"],
["&#x2019;","d","123"],
["&#x2019;","c","123"],
["&#x2019;","a","82"],
["&#x2019;","Y","-20"],
["&#x2019;","W","-41"],
["&#x2019;","V","-41"],
["&#x2019;","T","-41"],
["&#x2019;","A","143"],
["&#x201a;","&#x162;","143"],
["&#x201a;","&#x1ef8;","123"],
["&#x201a;","&#x1ef6;","123"],
["&#x201a;","&#x1ef4;","123"],
["&#x201a;","&#x1ef0;","41"],
["&#x201a;","&#x1eee;","41"],
["&#x201a;","&#x1eec;","41"],
["&#x201a;","&#x1eea;","41"],
["&#x201a;","&#x1ee8;","41"],
["&#x201a;","&#x1ee6;","41"],
["&#x201a;","&#x1ee4;","41"],
["&#x201a;","&#x1ee2;","102"],
["&#x201a;","&#x1ee0;","102"],
["&#x201a;","&#x1ede;","102"],
["&#x201a;","&#x1edc;","102"],
["&#x201a;","&#x1eda;","102"],
["&#x201a;","&#x1ed8;","102"],
["&#x201a;","&#x1ed6;","102"],
["&#x201a;","&#x1ed4;","102"],
["&#x201a;","&#x1ed2;","102"],
["&#x201a;","&#x1ed0;","102"],
["&#x201a;","&#x1ece;","102"],
["&#x201a;","&#x1ecc;","102"],
["&#x201a;","&#x50f;","102"],
["&#x201a;","&#x50e;","143"],
["&#x201a;","&#x50c;","102"],
["&#x201a;","&#x507;","102"],
["&#x201a;","&#x506;","123"],
["&#x201a;","&#x505;","102"],
["&#x201a;","&#x504;","123"],
["&#x201a;","&#x4f5;","123"],
["&#x201a;","&#x4f4;","164"],
["&#x201a;","&#x4ea;","102"],
["&#x201a;","&#x4e8;","102"],
["&#x201a;","&#x4e6;","102"],
["&#x201a;","&#x4cc;","123"],
["&#x201a;","&#x4cb;","164"],
["&#x201a;","&#x4be;","123"],
["&#x201a;","&#x4bc;","123"],
["&#x201a;","&#x4b9;","123"],
["&#x201a;","&#x4b8;","164"],
["&#x201a;","&#x4b7;","123"],
["&#x201a;","&#x4b6;","164"],
["&#x201a;","&#x4b5;","102"],
["&#x201a;","&#x4b4;","143"],
["&#x201a;","&#x4b0;","123"],
["&#x201a;","&#x4ae;","123"],
["&#x201a;","&#x4ad;","102"],
["&#x201a;","&#x4ac;","143"],
["&#x201a;","&#x4aa;","102"],
["&#x201a;","&#x4a8;","102"],
["&#x201a;","&#x4a1;","102"],
["&#x201a;","&#x4a0;","143"],
["&#x201a;","&#x480;","102"],
["&#x201a;","&#x47e;","102"],
["&#x201a;","&#x47c;","102"],
["&#x201a;","&#x47a;","102"],
["&#x201a;","&#x478;","102"],
["&#x201a;","&#x476;","123"],
["&#x201a;","&#x474;","123"],
["&#x201a;","&#x472;","102"],
["&#x201a;","&#x470;","164"],
["&#x201a;","&#x460;","102"],
["&#x201a;","&#x1af;","41"],
["&#x201a;","&#x1a0;","102"],
["&#x201a;","&#x3d2;","123"],
["&#x201a;","&#x1ef2;","123"],
["&#x201a;","&#x1e84;","123"],
["&#x201a;","&#x1e82;","123"],
["&#x201a;","&#x1e80;","123"],
["&#x201a;","&#x44a;","102"],
["&#x201a;","&#x447;","123"],
["&#x201a;","&#x442;","102"],
["&#x201a;","&#x42a;","143"],
["&#x201a;","&#x427;","164"],
["&#x201a;","&#x424;","82"],
["&#x201a;","&#x422;","143"],
["&#x201a;","&#x421;","102"],
["&#x201a;","&#x41e;","102"],
["&#x201a;","&#x40b;","143"],
["&#x201a;","&#x404;","102"],
["&#x201a;","&#x402;","143"],
["&#x201a;","&#x3b8;","41"],
["&#x201a;","&#x3ab;","123"],
["&#x201a;","&#x3a8;","123"],
["&#x201a;","&#x3a6;","102"],
["&#x201a;","&#x3a5;","123"],
["&#x201a;","&#x3a4;","143"],
["&#x201a;","&#x39f;","82"],
["&#x201a;","&#x398;","82"],
["&#x201a;","&#x1fe;","102"],
["&#x201a;","&#x178;","123"],
["&#x201a;","&#x176;","123"],
["&#x201a;","&#x174;","123"],
["&#x201a;","&#x172;","41"],
["&#x201a;","&#x170;","41"],
["&#x201a;","&#x16e;","41"],
["&#x201a;","&#x16c;","41"],
["&#x201a;","&#x16a;","41"],
["&#x201a;","&#x168;","41"],
["&#x201a;","&#x164;","143"],
["&#x201a;","&#x21a;","143"],
["&#x201a;","&#x152;","102"],
["&#x201a;","&#x150;","102"],
["&#x201a;","&#x14e;","102"],
["&#x201a;","&#x14c;","102"],
["&#x201a;","&#x122;","102"],
["&#x201a;","&#x120;","102"],
["&#x201a;","&#x11e;","102"],
["&#x201a;","&#x11c;","102"],
["&#x201a;","&#x10c;","102"],
["&#x201a;","&#x10a;","102"],
["&#x201a;","&#x108;","102"],
["&#x201a;","&#x106;","102"],
["&#x201a;","&#xdd;","123"],
["&#x201a;","&#xdc;","41"],
["&#x201a;","&#xdb;","41"],
["&#x201a;","&#xda;","41"],
["&#x201a;","&#xd9;","41"],
["&#x201a;","&#xd8;","102"],
["&#x201a;","&#xd6;","102"],
["&#x201a;","&#xd5;","102"],
["&#x201a;","&#xd4;","102"],
["&#x201a;","&#xd3;","102"],
["&#x201a;","&#xd2;","102"],
["&#x201a;","&#xc7;","102"],
["&#x201a;","Y","123"],
["&#x201a;","W","123"],
["&#x201a;","V","123"],
["&#x201a;","U","41"],
["&#x201a;","T","143"],
["&#x201a;","Q","102"],
["&#x201a;","O","102"],
["&#x201a;","G","102"],
["&#x201a;","C","102"],
["&#x201c;","&#x162;","-41"],
["&#x201c;","&#x1ef8;","-20"],
["&#x201c;","&#x1ef6;","-20"],
["&#x201c;","&#x1ef4;","-20"],
["&#x201c;","&#x1ef1;","61"],
["&#x201c;","&#x1eef;","61"],
["&#x201c;","&#x1eed;","61"],
["&#x201c;","&#x1eeb;","61"],
["&#x201c;","&#x1ee9;","61"],
["&#x201c;","&#x1ee7;","61"],
["&#x201c;","&#x1ee5;","61"],
["&#x201c;","&#x1ee3;","123"],
["&#x201c;","&#x1ee1;","123"],
["&#x201c;","&#x1edf;","123"],
["&#x201c;","&#x1edd;","123"],
["&#x201c;","&#x1edb;","123"],
["&#x201c;","&#x1ed9;","123"],
["&#x201c;","&#x1ed7;","123"],
["&#x201c;","&#x1ed5;","123"],
["&#x201c;","&#x1ed1;","123"],
["&#x201c;","&#x1ecf;","123"],
["&#x201c;","&#x1ecd;","123"],
["&#x201c;","&#x1ec7;","123"],
["&#x201c;","&#x1ec5;","123"],
["&#x201c;","&#x1ec3;","123"],
["&#x201c;","&#x1ebf;","123"],
["&#x201c;","&#x1ebd;","123"],
["&#x201c;","&#x1ebb;","123"],
["&#x201c;","&#x1eb9;","123"],
["&#x201c;","&#x1eb7;","82"],
["&#x201c;","&#x1eb6;","143"],
["&#x201c;","&#x1eb5;","82"],
["&#x201c;","&#x1eb4;","143"],
["&#x201c;","&#x1eb3;","82"],
["&#x201c;","&#x1eb2;","143"],
["&#x201c;","&#x1eb1;","82"],
["&#x201c;","&#x1eb0;","143"],
["&#x201c;","&#x1eaf;","82"],
["&#x201c;","&#x1eae;","143"],
["&#x201c;","&#x1ead;","82"],
["&#x201c;","&#x1eac;","143"],
["&#x201c;","&#x1eab;","82"],
["&#x201c;","&#x1eaa;","143"],
["&#x201c;","&#x1ea9;","82"],
["&#x201c;","&#x1ea8;","143"],
["&#x201c;","&#x1ea6;","143"],
["&#x201c;","&#x1ea5;","82"],
["&#x201c;","&#x1ea4;","143"],
["&#x201c;","&#x1ea3;","82"],
["&#x201c;","&#x1ea2;","143"],
["&#x201c;","&#x1ea1;","82"],
["&#x201c;","&#x1ea0;","143"],
["&#x201c;","&#x513;","143"],
["&#x201c;","&#x512;","123"],
["&#x201c;","&#x511;","123"],
["&#x201c;","&#x50d;","123"],
["&#x201c;","&#x509;","143"],
["&#x201c;","&#x508;","123"],
["&#x201c;","&#x503;","123"],
["&#x201c;","&#x502;","143"],
["&#x201c;","&#x501;","123"],
["&#x201c;","&#x500;","143"],
["&#x201c;","&#x4eb;","123"],
["&#x201c;","&#x4e9;","123"],
["&#x201c;","&#x4e7;","123"],
["&#x201c;","&#x4db;","41"],
["&#x201c;","&#x4d9;","41"],
["&#x201c;","&#x4d7;","123"],
["&#x201c;","&#x4d5;","41"],
["&#x201c;","&#x4d4;","143"],
["&#x201c;","&#x4d3;","41"],
["&#x201c;","&#x4d2;","143"],
["&#x201c;","&#x4d1;","41"],
["&#x201c;","&#x4d0;","143"],
["&#x201c;","&#x4c6;","143"],
["&#x201c;","&#x4c5;","123"],
["&#x201c;","&#x4ab;","123"],
["&#x201c;","&#x4a9;","123"],
["&#x201c;","&#x481;","123"],
["&#x201c;","&#x47d;","123"],
["&#x201c;","&#x47b;","123"],
["&#x201c;","&#x479;","123"],
["&#x201c;","&#x473;","123"],
["&#x201c;","&#x471;","20"],
["&#x201c;","&#x467;","143"],
["&#x201c;","&#x466;","143"],
["&#x201c;","&#x450;","123"],
["&#x201c;","&#x1b0;","61"],
["&#x201c;","&#x1a1;","123"],
["&#x201c;","&#x1e01;","82"],
["&#x201c;","&#x1e00;","143"],
["&#x201c;","&#x1e3f;","61"],
["&#x201c;","&#x1ef2;","-20"],
["&#x201c;","&#x1e84;","-41"],
["&#x201c;","&#x1e82;","-41"],
["&#x201c;","&#x1e80;","-41"],
["&#x201c;","&#x459;","143"],
["&#x201c;","&#x455;","61"],
["&#x201c;","&#x454;","123"],
["&#x201c;","&#x451;","123"],
["&#x201c;","&#x444;","123"],
["&#x201c;","&#x441;","123"],
["&#x201c;","&#x43e;","123"],
["&#x201c;","&#x43b;","143"],
["&#x201c;","&#x435;","123"],
["&#x201c;","&#x434;","143"],
["&#x201c;","&#x430;","41"],
["&#x201c;","&#x41b;","123"],
["&#x201c;","&#x414;","123"],
["&#x201c;","&#x410;","143"],
["&#x201c;","&#x409;","123"],
["&#x201c;","&#x3cc;","82"],
["&#x201c;","&#x3c6;","82"],
["&#x201c;","&#x3c3;","82"],
["&#x201c;","&#x3c2;","82"],
["&#x201c;","&#x3c1;","61"],
["&#x201c;","&#x3bf;","82"],
["&#x201c;","&#x3bc;","41"],
["&#x201c;","&#x3ba;","41"],
["&#x201c;","&#x3b7;","41"],
["&#x201c;","&#x3b6;","41"],
["&#x201c;","&#x3b5;","41"],
["&#x201c;","&#x3b4;","61"],
["&#x201c;","&#x3b1;","82"],
["&#x201c;","&#x3ae;","41"],
["&#x201c;","&#x3ad;","41"],
["&#x201c;","&#x3ac;","82"],
["&#x201c;","&#x39b;","143"],
["&#x201c;","&#x394;","143"],
["&#x201c;","&#x391;","143"],
["&#x201c;","&#x386;","143"],
["&#x201c;","&#x219;","61"],
["&#x201c;","&#x1ff;","123"],
["&#x201c;","&#x1fd;","82"],
["&#x201c;","&#x1fb;","82"],
["&#x201c;","&#x1fa;","143"],
["&#x201c;","&#x178;","-20"],
["&#x201c;","&#x176;","-20"],
["&#x201c;","&#x174;","-41"],
["&#x201c;","&#x173;","61"],
["&#x201c;","&#x171;","61"],
["&#x201c;","&#x16f;","61"],
["&#x201c;","&#x16d;","61"],
["&#x201c;","&#x16b;","61"],
["&#x201c;","&#x169;","61"],
["&#x201c;","&#x164;","-41"],
["&#x201c;","&#x21a;","-41"],
["&#x201c;","&#x15f;","61"],
["&#x201c;","&#x15b;","61"],
["&#x201c;","&#x157;","61"],
["&#x201c;","&#x155;","61"],
["&#x201c;","&#x153;","123"],
["&#x201c;","&#x151;","123"],
["&#x201c;","&#x14f;","123"],
["&#x201c;","&#x14d;","123"],
["&#x201c;","&#x14b;","61"],
["&#x201c;","&#x146;","61"],
["&#x201c;","&#x144;","61"],
["&#x201c;","&#x138;","61"],
["&#x201c;","&#x123;","61"],
["&#x201c;","&#x121;","61"],
["&#x201c;","&#x11f;","61"],
["&#x201c;","&#x11d;","61"],
["&#x201c;","&#x11b;","123"],
["&#x201c;","&#x119;","123"],
["&#x201c;","&#x117;","123"],
["&#x201c;","&#x115;","123"],
["&#x201c;","&#x113;","123"],
["&#x201c;","&#x111;","123"],
["&#x201c;","&#x10f;","123"],
["&#x201c;","&#x10d;","123"],
["&#x201c;","&#x10b;","123"],
["&#x201c;","&#x109;","123"],
["&#x201c;","&#x107;","123"],
["&#x201c;","&#x105;","82"],
["&#x201c;","&#x104;","143"],
["&#x201c;","&#x103;","82"],
["&#x201c;","&#x102;","143"],
["&#x201c;","&#x101;","82"],
["&#x201c;","&#x100;","143"],
["&#x201c;","&#xfc;","61"],
["&#x201c;","&#xfb;","61"],
["&#x201c;","&#xfa;","61"],
["&#x201c;","&#xf9;","61"],
["&#x201c;","&#xf8;","123"],
["&#x201c;","&#xf6;","123"],
["&#x201c;","&#xf5;","123"],
["&#x201c;","&#xf4;","123"],
["&#x201c;","&#xf3;","123"],
["&#x201c;","&#xf2;","123"],
["&#x201c;","&#xeb;","123"],
["&#x201c;","&#xea;","123"],
["&#x201c;","&#xe9;","123"],
["&#x201c;","&#xe8;","123"],
["&#x201c;","&#xe7;","123"],
["&#x201c;","&#xe6;","82"],
["&#x201c;","&#xe5;","82"],
["&#x201c;","&#xe4;","82"],
["&#x201c;","&#xe3;","82"],
["&#x201c;","&#xe2;","82"],
["&#x201c;","&#xe1;","82"],
["&#x201c;","&#xe0;","123"],
["&#x201c;","&#xdd;","-20"],
["&#x201c;","&#xc5;","143"],
["&#x201c;","&#xc4;","143"],
["&#x201c;","&#xc3;","143"],
["&#x201c;","&#xc2;","143"],
["&#x201c;","&#xc1;","143"],
["&#x201c;","&#xc0;","143"],
["&#x201c;","u","61"],
["&#x201c;","s","61"],
["&#x201c;","r","61"],
["&#x201c;","q","123"],
["&#x201c;","p","61"],
["&#x201c;","o","123"],
["&#x201c;","n","61"],
["&#x201c;","m","61"],
["&#x201c;","g","61"],
["&#x201c;","e","123"],
["&#x201c;","d","123"],
["&#x201c;","c","123"],
["&#x201c;","a","82"],
["&#x201c;","Y","-20"],
["&#x201c;","W","-41"],
["&#x201c;","V","-41"],
["&#x201c;","T","-41"],
["&#x201c;","A","143"],
["&#x201e;","&#x162;","143"],
["&#x201e;","&#x1ef8;","123"],
["&#x201e;","&#x1ef6;","123"],
["&#x201e;","&#x1ef4;","123"],
["&#x201e;","&#x1ef0;","41"],
["&#x201e;","&#x1eee;","41"],
["&#x201e;","&#x1eec;","41"],
["&#x201e;","&#x1eea;","41"],
["&#x201e;","&#x1ee8;","41"],
["&#x201e;","&#x1ee6;","41"],
["&#x201e;","&#x1ee4;","41"],
["&#x201e;","&#x1ee2;","102"],
["&#x201e;","&#x1ee0;","102"],
["&#x201e;","&#x1ede;","102"],
["&#x201e;","&#x1edc;","102"],
["&#x201e;","&#x1eda;","102"],
["&#x201e;","&#x1ed8;","102"],
["&#x201e;","&#x1ed6;","102"],
["&#x201e;","&#x1ed4;","102"],
["&#x201e;","&#x1ed2;","102"],
["&#x201e;","&#x1ed0;","102"],
["&#x201e;","&#x1ece;","102"],
["&#x201e;","&#x1ecc;","102"],
["&#x201e;","&#x50f;","102"],
["&#x201e;","&#x50e;","143"],
["&#x201e;","&#x50c;","102"],
["&#x201e;","&#x507;","102"],
["&#x201e;","&#x506;","123"],
["&#x201e;","&#x505;","102"],
["&#x201e;","&#x504;","123"],
["&#x201e;","&#x4f5;","123"],
["&#x201e;","&#x4f4;","164"],
["&#x201e;","&#x4ea;","102"],
["&#x201e;","&#x4e8;","102"],
["&#x201e;","&#x4e6;","102"],
["&#x201e;","&#x4cc;","123"],
["&#x201e;","&#x4cb;","164"],
["&#x201e;","&#x4be;","123"],
["&#x201e;","&#x4bc;","123"],
["&#x201e;","&#x4b9;","123"],
["&#x201e;","&#x4b8;","164"],
["&#x201e;","&#x4b7;","123"],
["&#x201e;","&#x4b6;","164"],
["&#x201e;","&#x4b5;","102"],
["&#x201e;","&#x4b4;","143"],
["&#x201e;","&#x4b0;","123"],
["&#x201e;","&#x4ae;","123"],
["&#x201e;","&#x4ad;","102"],
["&#x201e;","&#x4ac;","143"],
["&#x201e;","&#x4aa;","102"],
["&#x201e;","&#x4a8;","102"],
["&#x201e;","&#x4a1;","102"],
["&#x201e;","&#x4a0;","143"],
["&#x201e;","&#x480;","102"],
["&#x201e;","&#x47e;","102"],
["&#x201e;","&#x47c;","102"],
["&#x201e;","&#x47a;","102"],
["&#x201e;","&#x478;","102"],
["&#x201e;","&#x476;","123"],
["&#x201e;","&#x474;","123"],
["&#x201e;","&#x472;","102"],
["&#x201e;","&#x470;","164"],
["&#x201e;","&#x460;","102"],
["&#x201e;","&#x1af;","41"],
["&#x201e;","&#x1a0;","102"],
["&#x201e;","&#x3d2;","123"],
["&#x201e;","&#x1ef2;","123"],
["&#x201e;","&#x1e84;","123"],
["&#x201e;","&#x1e82;","123"],
["&#x201e;","&#x1e80;","123"],
["&#x201e;","&#x44a;","102"],
["&#x201e;","&#x447;","123"],
["&#x201e;","&#x442;","102"],
["&#x201e;","&#x42a;","143"],
["&#x201e;","&#x427;","164"],
["&#x201e;","&#x424;","82"],
["&#x201e;","&#x422;","143"],
["&#x201e;","&#x421;","102"],
["&#x201e;","&#x41e;","102"],
["&#x201e;","&#x40b;","143"],
["&#x201e;","&#x404;","102"],
["&#x201e;","&#x402;","143"],
["&#x201e;","&#x3b8;","41"],
["&#x201e;","&#x3ab;","123"],
["&#x201e;","&#x3a8;","123"],
["&#x201e;","&#x3a6;","102"],
["&#x201e;","&#x3a5;","123"],
["&#x201e;","&#x3a4;","143"],
["&#x201e;","&#x39f;","82"],
["&#x201e;","&#x398;","82"],
["&#x201e;","&#x1fe;","102"],
["&#x201e;","&#x178;","123"],
["&#x201e;","&#x176;","123"],
["&#x201e;","&#x174;","123"],
["&#x201e;","&#x172;","41"],
["&#x201e;","&#x170;","41"],
["&#x201e;","&#x16e;","41"],
["&#x201e;","&#x16c;","41"],
["&#x201e;","&#x16a;","41"],
["&#x201e;","&#x168;","41"],
["&#x201e;","&#x164;","143"],
["&#x201e;","&#x21a;","143"],
["&#x201e;","&#x152;","102"],
["&#x201e;","&#x150;","102"],
["&#x201e;","&#x14e;","102"],
["&#x201e;","&#x14c;","102"],
["&#x201e;","&#x122;","102"],
["&#x201e;","&#x120;","102"],
["&#x201e;","&#x11e;","102"],
["&#x201e;","&#x11c;","102"],
["&#x201e;","&#x10c;","102"],
["&#x201e;","&#x10a;","102"],
["&#x201e;","&#x108;","102"],
["&#x201e;","&#x106;","102"],
["&#x201e;","&#xdd;","123"],
["&#x201e;","&#xdc;","41"],
["&#x201e;","&#xdb;","41"],
["&#x201e;","&#xda;","41"],
["&#x201e;","&#xd9;","41"],
["&#x201e;","&#xd8;","102"],
["&#x201e;","&#xd6;","102"],
["&#x201e;","&#xd5;","102"],
["&#x201e;","&#xd4;","102"],
["&#x201e;","&#xd3;","102"],
["&#x201e;","&#xd2;","102"],
["&#x201e;","&#xc7;","102"],
["&#x201e;","Y","123"],
["&#x201e;","W","123"],
["&#x201e;","V","123"],
["&#x201e;","U","41"],
["&#x201e;","T","143"],
["&#x201e;","Q","102"],
["&#x201e;","O","102"],
["&#x201e;","G","102"],
["&#x201e;","C","102"],
["&#x2126;","&#x3d2;","20"],
["&#x2126;","&#x3ab;","20"],
["&#x2126;","&#x3a5;","20"],
["&#x2126;","&#x3a4;","41"],
["&#x3d1;","&#x201e;","61"],
["&#x3d1;","&#x201a;","61"],
["&#x3d1;","&#x2e;","61"],
["&#x3d1;","&#x2c;","61"],
["&#x3d2;","&#x2126;","20"],
["&#x3d2;","&#x201e;","123"],
["&#x3d2;","&#x201a;","123"],
["&#x3d2;","&#x3ce;","61"],
["&#x3d2;","&#x3cd;","61"],
["&#x3d2;","&#x3cc;","102"],
["&#x3d2;","&#x3cb;","61"],
["&#x3d2;","&#x3c9;","61"],
["&#x3d2;","&#x3c8;","61"],
["&#x3d2;","&#x3c6;","102"],
["&#x3d2;","&#x3c5;","61"],
["&#x3d2;","&#x3c3;","102"],
["&#x3d2;","&#x3c2;","102"],
["&#x3d2;","&#x3c1;","102"],
["&#x3d2;","&#x3bf;","102"],
["&#x3d2;","&#x3bc;","61"],
["&#x3d2;","&#x3ba;","61"],
["&#x3d2;","&#x3b9;","61"],
["&#x3d2;","&#x3b7;","61"],
["&#x3d2;","&#x3b5;","82"],
["&#x3d2;","&#x3b4;","61"],
["&#x3d2;","&#x3b1;","102"],
["&#x3d2;","&#x3b0;","61"],
["&#x3d2;","&#x3af;","61"],
["&#x3d2;","&#x3ae;","61"],
["&#x3d2;","&#x3ad;","82"],
["&#x3d2;","&#x3ac;","102"],
["&#x3d2;","&#x3a9;","20"],
["&#x3d2;","&#x3a6;","61"],
["&#x3d2;","&#x39f;","41"],
["&#x3d2;","&#x39b;","123"],
["&#x3d2;","&#x398;","41"],
["&#x3d2;","&#x394;","123"],
["&#x3d2;","&#x391;","123"],
["&#x3d2;","&#x386;","123"],
["&#x3d2;","&#x2e;","123"],
["&#x3d2;","&#x2c;","123"],
["&#x1e00;","&#x162;","143"],
["&#x1e00;","&#x1ef8;","123"],
["&#x1e00;","&#x1ef6;","123"],
["&#x1e00;","&#x1ef4;","123"],
["&#x1e00;","&#x1ee2;","41"],
["&#x1e00;","&#x1ee0;","41"],
["&#x1e00;","&#x1ede;","41"],
["&#x1e00;","&#x1edc;","41"],
["&#x1e00;","&#x1eda;","41"],
["&#x1e00;","&#x1ed8;","41"],
["&#x1e00;","&#x1ed6;","41"],
["&#x1e00;","&#x1ed4;","41"],
["&#x1e00;","&#x1ed2;","41"],
["&#x1e00;","&#x1ed0;","41"],
["&#x1e00;","&#x1ece;","41"],
["&#x1e00;","&#x1ecc;","41"],
["&#x1e00;","&#x1a0;","41"],
["&#x1e00;","&#x201d;","143"],
["&#x1e00;","&#x2019;","143"],
["&#x1e00;","&#x1ef2;","123"],
["&#x1e00;","&#x1e84;","82"],
["&#x1e00;","&#x1e82;","82"],
["&#x1e00;","&#x1e80;","82"],
["&#x1e00;","&#x1fe;","41"],
["&#x1e00;","&#x178;","123"],
["&#x1e00;","&#x176;","123"],
["&#x1e00;","&#x174;","82"],
["&#x1e00;","&#x164;","143"],
["&#x1e00;","&#x21a;","143"],
["&#x1e00;","&#x152;","41"],
["&#x1e00;","&#x150;","41"],
["&#x1e00;","&#x14e;","41"],
["&#x1e00;","&#x14c;","41"],
["&#x1e00;","&#x122;","41"],
["&#x1e00;","&#x120;","41"],
["&#x1e00;","&#x11e;","41"],
["&#x1e00;","&#x11c;","41"],
["&#x1e00;","&#x10c;","41"],
["&#x1e00;","&#x10a;","41"],
["&#x1e00;","&#x108;","41"],
["&#x1e00;","&#x106;","41"],
["&#x1e00;","&#xdd;","123"],
["&#x1e00;","&#xd8;","41"],
["&#x1e00;","&#xd6;","41"],
["&#x1e00;","&#xd5;","41"],
["&#x1e00;","&#xd4;","41"],
["&#x1e00;","&#xd3;","41"],
["&#x1e00;","&#xd2;","41"],
["&#x1e00;","&#xc7;","41"],
["&#x1e00;","Y","123"],
["&#x1e00;","W","82"],
["&#x1e00;","V","82"],
["&#x1e00;","T","143"],
["&#x1e00;","Q","41"],
["&#x1e00;","O","41"],
["&#x1e00;","J","-266"],
["&#x1e00;","G","41"],
["&#x1e00;","C","41"],
["&#x1e00;","&#x27;","143"],
["&#x1e00;","&#x22;","143"],
["&#x1e01;","&#x201d;","20"],
["&#x1e01;","&#x2019;","20"],
["&#x1e01;","&#x27;","20"],
["&#x1e01;","&#x22;","20"],
["&#x1f4d;","&#x3d2;","20"],
["&#x1f4d;","&#x201e;","82"],
["&#x1f4d;","&#x201a;","82"],
["&#x1f4d;","&#x3bb;","20"],
["&#x1f4d;","&#x3ab;","20"],
["&#x1f4d;","&#x3a8;","20"],
["&#x1f4d;","&#x3a7;","41"],
["&#x1f4d;","&#x3a5;","20"],
["&#x1f4d;","&#x3a4;","61"],
["&#x1f4d;","&#x3a3;","20"],
["&#x1f4d;","&#x39b;","41"],
["&#x1f4d;","&#x396;","20"],
["&#x1f4d;","&#x394;","41"],
["&#x1f4d;","&#x391;","41"],
["&#x1f4d;","&#x386;","41"],
["&#x1f4d;","&#x2e;","82"],
["&#x1f4d;","&#x2c;","82"],
["&#x1a1;","&#x163;","-82"],
["&#x1a1;" g2="ff","-82"],
["&#x1a1;","&#x1ef5;","-102"],
["&#x1a1;" g2="uniFB04","-82"],
["&#x1a1;" g2="uniFB03","-82"],
["&#x1a1;" g2="uniFB02","-82"],
["&#x1a1;" g2="uniFB01","-82"],
["&#x1a1;","&#x1e83;","-102"],
["&#x1a1;","&#x1e81;","-102"],
["&#x1a1;","&#x175;","-102"],
["&#x1a1;","&#x165;","-82"],
["&#x1a1;","&#x21b;","-82"],
["&#x1a1;","&#xfd;","-102"],
["&#x1a1;","y","-102"],
["&#x1a1;","x","-102"],
["&#x1a1;","w","-102"],
["&#x1a1;","v","-102"],
["&#x1a1;","t","-82"],
["&#x1a1;","f","-82"],
["&#x1b0;","&#x163;","-102"],
["&#x1b0;" g2="ff","-102"],
["&#x1b0;","&#x1ef5;","-102"],
["&#x1b0;" g2="uniFB04","-102"],
["&#x1b0;" g2="uniFB03","-102"],
["&#x1b0;" g2="uniFB02","-102"],
["&#x1b0;" g2="uniFB01","-102"],
["&#x1b0;","&#x1e83;","-102"],
["&#x1b0;","&#x1e81;","-102"],
["&#x1b0;","&#x175;","-102"],
["&#x1b0;","&#x165;","-102"],
["&#x1b0;","&#x21b;","-102"],
["&#x1b0;","&#xfd;","-102"],
["&#x1b0;","y","-102"],
["&#x1b0;","x","-102"],
["&#x1b0;","w","-102"],
["&#x1b0;","v","-102"],
["&#x1b0;","t","-102"],
["&#x1b0;","f","-102"],
["&#x450;","&#x201d;","20"],
["&#x450;","&#x2019;","20"],
["&#x450;","&#x27;","20"],
["&#x450;","&#x22;","20"],
["&#x460;","&#x513;","20"],
["&#x460;","&#x512;","41"],
["&#x460;","&#x50e;","20"],
["&#x460;","&#x509;","20"],
["&#x460;","&#x508;","41"],
["&#x460;","&#x506;","41"],
["&#x460;","&#x504;","41"],
["&#x460;","&#x4fe;","41"],
["&#x460;","&#x4fc;","41"],
["&#x460;","&#x4f4;","41"],
["&#x460;","&#x4f2;","41"],
["&#x460;","&#x4f0;","41"],
["&#x460;","&#x4ee;","41"],
["&#x460;","&#x4ec;","20"],
["&#x460;","&#x4de;","20"],
["&#x460;","&#x4dc;","41"],
["&#x460;","&#x4d4;","41"],
["&#x460;","&#x4d2;","41"],
["&#x460;","&#x4d0;","41"],
["&#x460;","&#x4cb;","41"],
["&#x460;","&#x4c6;","20"],
["&#x460;","&#x4c5;","41"],
["&#x460;","&#x4c1;","41"],
["&#x460;","&#x4b8;","41"],
["&#x460;","&#x4b6;","41"],
["&#x460;","&#x4b4;","20"],
["&#x460;","&#x4b2;","41"],
["&#x460;","&#x4b0;","20"],
["&#x460;","&#x4ae;","20"],
["&#x460;","&#x4ac;","61"],
["&#x460;","&#x4a0;","20"],
["&#x460;","&#x498;","20"],
["&#x460;","&#x496;","41"],
["&#x460;","&#x476;","20"],
["&#x460;","&#x474;","20"],
["&#x460;","&#x470;","41"],
["&#x460;","&#x46e;","20"],
["&#x460;","&#x467;","20"],
["&#x460;","&#x466;","41"],
["&#x460;","&#x201e;","82"],
["&#x460;","&#x201a;","82"],
["&#x460;","&#x459;","20"],
["&#x460;","&#x43b;","20"],
["&#x460;","&#x434;","20"],
["&#x460;","&#x42d;","20"],
["&#x460;","&#x42a;","20"],
["&#x460;","&#x427;","41"],
["&#x460;","&#x425;","41"],
["&#x460;","&#x423;","41"],
["&#x460;","&#x422;","61"],
["&#x460;","&#x41b;","41"],
["&#x460;","&#x417;","20"],
["&#x460;","&#x416;","41"],
["&#x460;","&#x414;","41"],
["&#x460;","&#x410;","41"],
["&#x460;","&#x40e;","41"],
["&#x460;","&#x40b;","20"],
["&#x460;","&#x409;","41"],
["&#x460;","&#x402;","20"],
["&#x460;","&#x2e;","82"],
["&#x460;","&#x2c;","82"],
["&#x461;","&#x513;","41"],
["&#x461;","&#x509;","41"],
["&#x461;","&#x4c6;","41"],
["&#x461;","&#x467;","41"],
["&#x461;","&#x201e;","82"],
["&#x461;","&#x201a;","82"],
["&#x461;","&#x459;","41"],
["&#x461;","&#x43b;","41"],
["&#x461;","&#x434;","41"],
["&#x461;","&#x2e;","82"],
["&#x461;","&#x2c;","82"],
["&#x462;","&#x50f;","41"],
["&#x462;","&#x50e;","41"],
["&#x462;","&#x506;","102"],
["&#x462;","&#x504;","102"],
["&#x462;","&#x4f4;","82"],
["&#x462;","&#x4cb;","82"],
["&#x462;","&#x4b8;","82"],
["&#x462;","&#x4b6;","82"],
["&#x462;","&#x4b5;","41"],
["&#x462;","&#x4b4;","41"],
["&#x462;","&#x4b0;","61"],
["&#x462;","&#x4ae;","61"],
["&#x462;","&#x4ad;","41"],
["&#x462;","&#x4ac;","82"],
["&#x462;","&#x4a1;","41"],
["&#x462;","&#x4a0;","41"],
["&#x462;","&#x476;","61"],
["&#x462;","&#x474;","61"],
["&#x462;","&#x470;","82"],
["&#x462;","&#x201d;","82"],
["&#x462;","&#x2019;","82"],
["&#x462;","&#x44a;","41"],
["&#x462;","&#x442;","41"],
["&#x462;","&#x42a;","41"],
["&#x462;","&#x427;","82"],
["&#x462;","&#x422;","82"],
["&#x462;","&#x40b;","41"],
["&#x462;","&#x402;","41"],
["&#x462;","&#x27;","82"],
["&#x462;","&#x22;","82"],
["&#x463;","&#x50f;","102"],
["&#x463;","&#x507;","102"],
["&#x463;","&#x505;","102"],
["&#x463;","&#x4ff;","41"],
["&#x463;","&#x4fd;","41"],
["&#x463;","&#x4f5;","82"],
["&#x463;","&#x4f3;","61"],
["&#x463;","&#x4f1;","61"],
["&#x463;","&#x4ef;","61"],
["&#x463;","&#x4e1;","41"],
["&#x463;","&#x4dd;","41"],
["&#x463;","&#x4cc;","82"],
["&#x463;","&#x4c2;","41"],
["&#x463;","&#x4bf;","41"],
["&#x463;","&#x4bd;","41"],
["&#x463;","&#x4b9;","82"],
["&#x463;","&#x4b7;","82"],
["&#x463;","&#x4b5;","102"],
["&#x463;","&#x4b3;","41"],
["&#x463;","&#x4b1;","61"],
["&#x463;","&#x4af;","61"],
["&#x463;","&#x4ad;","102"],
["&#x463;","&#x4a1;","102"],
["&#x463;","&#x497;","41"],
["&#x463;","&#x47f;","41"],
["&#x463;","&#x477;","41"],
["&#x463;","&#x475;","41"],
["&#x463;","&#x461;","41"],
["&#x463;","&#x201d;","123"],
["&#x463;","&#x2019;","123"],
["&#x463;","&#x45e;","61"],
["&#x463;","&#x44a;","102"],
["&#x463;","&#x447;","82"],
["&#x463;","&#x445;","41"],
["&#x463;","&#x443;","61"],
["&#x463;","&#x442;","102"],
["&#x463;","&#x436;","41"],
["&#x463;","&#x27;","123"],
["&#x463;","&#x22;","123"],
["&#x464;","&#x50c;","41"],
["&#x464;","&#x507;","41"],
["&#x464;","&#x505;","41"],
["&#x464;","&#x502;","41"],
["&#x464;","&#x500;","41"],
["&#x464;","&#x4f5;","41"],
["&#x464;","&#x4ea;","41"],
["&#x464;","&#x4e8;","41"],
["&#x464;","&#x4e6;","41"],
["&#x464;","&#x4cc;","41"],
["&#x464;","&#x4be;","41"],
["&#x464;","&#x4bc;","41"],
["&#x464;","&#x4b9;","41"],
["&#x464;","&#x4b7;","41"],
["&#x464;","&#x4aa;","41"],
["&#x464;","&#x4a8;","41"],
["&#x464;","&#x480;","41"],
["&#x464;","&#x47e;","41"],
["&#x464;","&#x47c;","41"],
["&#x464;","&#x47a;","41"],
["&#x464;","&#x478;","41"],
["&#x464;","&#x472;","41"],
["&#x464;","&#x460;","41"],
["&#x464;","&#x447;","41"],
["&#x464;","&#x424;","41"],
["&#x464;","&#x421;","41"],
["&#x464;","&#x41e;","41"],
["&#x464;","&#x404;","41"],
["&#x466;","&#x50f;","41"],
["&#x466;","&#x50e;","102"],
["&#x466;","&#x507;","41"],
["&#x466;","&#x506;","143"],
["&#x466;","&#x505;","41"],
["&#x466;","&#x504;","143"],
["&#x466;","&#x4fa;","41"],
["&#x466;","&#x4f5;","41"],
["&#x466;","&#x4f4;","102"],
["&#x466;","&#x4da;","41"],
["&#x466;","&#x4d8;","41"],
["&#x466;","&#x4cc;","41"],
["&#x466;","&#x4cb;","102"],
["&#x466;","&#x4be;","102"],
["&#x466;","&#x4bc;","102"],
["&#x466;","&#x4b9;","41"],
["&#x466;","&#x4b8;","102"],
["&#x466;","&#x4b7;","41"],
["&#x466;","&#x4b6;","102"],
["&#x466;","&#x4b5;","41"],
["&#x466;","&#x4b4;","102"],
["&#x466;","&#x4b0;","123"],
["&#x466;","&#x4ae;","123"],
["&#x466;","&#x4ad;","41"],
["&#x466;","&#x4ac;","143"],
["&#x466;","&#x4a1;","41"],
["&#x466;","&#x4a0;","102"],
["&#x466;","&#x49e;","41"],
["&#x466;","&#x492;","41"],
["&#x466;","&#x48c;","41"],
["&#x466;","&#x476;","82"],
["&#x466;","&#x474;","82"],
["&#x466;","&#x470;","102"],
["&#x466;","&#x462;","41"],
["&#x466;","&#x201d;","143"],
["&#x466;","&#x2019;","143"],
["&#x466;","&#x44a;","41"],
["&#x466;","&#x447;","41"],
["&#x466;","&#x442;","41"],
["&#x466;","&#x42a;","102"],
["&#x466;","&#x427;","102"],
["&#x466;","&#x424;","41"],
["&#x466;","&#x422;","143"],
["&#x466;","&#x40b;","102"],
["&#x466;","&#x402;","102"],
["&#x466;","&#x27;","143"],
["&#x466;","&#x22;","143"],
["&#x467;","&#x511;","41"],
["&#x467;","&#x50f;","102"],
["&#x467;","&#x50d;","41"],
["&#x467;","&#x507;","123"],
["&#x467;","&#x505;","123"],
["&#x467;","&#x503;","41"],
["&#x467;","&#x501;","41"],
["&#x467;","&#x4f5;","61"],
["&#x467;","&#x4f3;","61"],
["&#x467;","&#x4f1;","61"],
["&#x467;","&#x4ef;","61"],
["&#x467;","&#x4eb;","41"],
["&#x467;","&#x4e9;","41"],
["&#x467;","&#x4e7;","41"],
["&#x467;","&#x4d7;","41"],
["&#x467;","&#x4cc;","61"],
["&#x467;","&#x4bf;","41"],
["&#x467;","&#x4bd;","41"],
["&#x467;","&#x4b9;","61"],
["&#x467;","&#x4b7;","61"],
["&#x467;","&#x4b5;","102"],
["&#x467;","&#x4b1;","41"],
["&#x467;","&#x4af;","41"],
["&#x467;","&#x4ad;","102"],
["&#x467;","&#x4ab;","41"],
["&#x467;","&#x4a9;","41"],
["&#x467;","&#x4a1;","102"],
["&#x467;","&#x481;","41"],
["&#x467;","&#x47f;","41"],
["&#x467;","&#x47d;","41"],
["&#x467;","&#x47b;","41"],
["&#x467;","&#x479;","41"],
["&#x467;","&#x477;","41"],
["&#x467;","&#x475;","41"],
["&#x467;","&#x473;","41"],
["&#x467;","&#x471;","20"],
["&#x467;","&#x461;","41"],
["&#x467;","&#x450;","41"],
["&#x467;","&#x201d;","143"],
["&#x467;","&#x2019;","143"],
["&#x467;","&#x45e;","61"],
["&#x467;","&#x454;","41"],
["&#x467;","&#x451;","41"],
["&#x467;","&#x44a;","102"],
["&#x467;","&#x447;","61"],
["&#x467;","&#x444;","41"],
["&#x467;","&#x443;","61"],
["&#x467;","&#x442;","102"],
["&#x467;","&#x441;","41"],
["&#x467;","&#x43e;","41"],
["&#x467;","&#x435;","41"],
["&#x467;","&#x27;","143"],
["&#x467;","&#x22;","143"],
["&#x468;","&#x50f;","41"],
["&#x468;","&#x50e;","102"],
["&#x468;","&#x507;","41"],
["&#x468;","&#x506;","143"],
["&#x468;","&#x505;","41"],
["&#x468;","&#x504;","143"],
["&#x468;","&#x4fa;","41"],
["&#x468;","&#x4f5;","41"],
["&#x468;","&#x4f4;","102"],
["&#x468;","&#x4da;","41"],
["&#x468;","&#x4d8;","41"],
["&#x468;","&#x4cc;","41"],
["&#x468;","&#x4cb;","102"],
["&#x468;","&#x4be;","102"],
["&#x468;","&#x4bc;","102"],
["&#x468;","&#x4b9;","41"],
["&#x468;","&#x4b8;","102"],
["&#x468;","&#x4b7;","41"],
["&#x468;","&#x4b6;","102"],
["&#x468;","&#x4b5;","41"],
["&#x468;","&#x4b4;","102"],
["&#x468;","&#x4b0;","123"],
["&#x468;","&#x4ae;","123"],
["&#x468;","&#x4ad;","41"],
["&#x468;","&#x4ac;","143"],
["&#x468;","&#x4a1;","41"],
["&#x468;","&#x4a0;","102"],
["&#x468;","&#x49e;","41"],
["&#x468;","&#x492;","41"],
["&#x468;","&#x48c;","41"],
["&#x468;","&#x476;","82"],
["&#x468;","&#x474;","82"],
["&#x468;","&#x470;","102"],
["&#x468;","&#x462;","41"],
["&#x468;","&#x201d;","143"],
["&#x468;","&#x2019;","143"],
["&#x468;","&#x44a;","41"],
["&#x468;","&#x447;","41"],
["&#x468;","&#x442;","41"],
["&#x468;","&#x42a;","102"],
["&#x468;","&#x427;","102"],
["&#x468;","&#x424;","41"],
["&#x468;","&#x422;","143"],
["&#x468;","&#x40b;","102"],
["&#x468;","&#x402;","102"],
["&#x468;","&#x27;","143"],
["&#x468;","&#x22;","143"],
["&#x469;","&#x511;","41"],
["&#x469;","&#x50f;","102"],
["&#x469;","&#x50d;","41"],
["&#x469;","&#x507;","123"],
["&#x469;","&#x505;","123"],
["&#x469;","&#x503;","41"],
["&#x469;","&#x501;","41"],
["&#x469;","&#x4f5;","61"],
["&#x469;","&#x4f3;","61"],
["&#x469;","&#x4f1;","61"],
["&#x469;","&#x4ef;","61"],
["&#x469;","&#x4eb;","41"],
["&#x469;","&#x4e9;","41"],
["&#x469;","&#x4e7;","41"],
["&#x469;","&#x4d7;","41"],
["&#x469;","&#x4cc;","61"],
["&#x469;","&#x4bf;","41"],
["&#x469;","&#x4bd;","41"],
["&#x469;","&#x4b9;","61"],
["&#x469;","&#x4b7;","61"],
["&#x469;","&#x4b5;","102"],
["&#x469;","&#x4b1;","41"],
["&#x469;","&#x4af;","41"],
["&#x469;","&#x4ad;","102"],
["&#x469;","&#x4ab;","41"],
["&#x469;","&#x4a9;","41"],
["&#x469;","&#x4a1;","102"],
["&#x469;","&#x481;","41"],
["&#x469;","&#x47f;","41"],
["&#x469;","&#x47d;","41"],
["&#x469;","&#x47b;","41"],
["&#x469;","&#x479;","41"],
["&#x469;","&#x477;","41"],
["&#x469;","&#x475;","41"],
["&#x469;","&#x473;","41"],
["&#x469;","&#x471;","20"],
["&#x469;","&#x461;","41"],
["&#x469;","&#x450;","41"],
["&#x469;","&#x201d;","143"],
["&#x469;","&#x2019;","143"],
["&#x469;","&#x45e;","61"],
["&#x469;","&#x454;","41"],
["&#x469;","&#x451;","41"],
["&#x469;","&#x44a;","102"],
["&#x469;","&#x447;","61"],
["&#x469;","&#x444;","41"],
["&#x469;","&#x443;","61"],
["&#x469;","&#x442;","102"],
["&#x469;","&#x441;","41"],
["&#x469;","&#x43e;","41"],
["&#x469;","&#x435;","41"],
["&#x469;","&#x27;","143"],
["&#x469;","&#x22;","143"],
["&#x46a;","&#x506;","20"],
["&#x46a;","&#x504;","20"],
["&#x46c;","&#x506;","20"],
["&#x46c;","&#x504;","20"],
["&#x46e;","&#x506;","41"],
["&#x46e;","&#x504;","41"],
["&#x46e;","&#x4b0;","20"],
["&#x46e;","&#x4ae;","20"],
["&#x46e;","&#x476;","20"],
["&#x46e;","&#x474;","20"],
["&#x46e;","&#x201e;","82"],
["&#x46e;","&#x201a;","82"],
["&#x46e;","&#x2e;","82"],
["&#x46e;","&#x2c;","82"],
["&#x470;","&#x513;","41"],
["&#x470;","&#x512;","61"],
["&#x470;","&#x509;","41"],
["&#x470;","&#x508;","61"],
["&#x470;","&#x502;","82"],
["&#x470;","&#x500;","82"],
["&#x470;","&#x4d4;","82"],
["&#x470;","&#x4d2;","82"],
["&#x470;","&#x4d0;","82"],
["&#x470;","&#x4c6;","41"],
["&#x470;","&#x4c5;","61"],
["&#x470;","&#x467;","41"],
["&#x470;","&#x466;","82"],
["&#x470;","&#x201e;","143"],
["&#x470;","&#x201a;","143"],
["&#x470;","&#x459;","41"],
["&#x470;","&#x43b;","41"],
["&#x470;","&#x434;","41"],
["&#x470;","&#x41b;","61"],
["&#x470;","&#x414;","61"],
["&#x470;","&#x410;","82"],
["&#x470;","&#x409;","61"],
["&#x470;","&#x2e;","143"],
["&#x470;","&#x2c;","143"],
["&#x471;","&#x50f;","20"],
["&#x471;","&#x507;","20"],
["&#x471;","&#x505;","20"],
["&#x471;","&#x4ff;","41"],
["&#x471;","&#x4fd;","41"],
["&#x471;","&#x4f5;","20"],
["&#x471;","&#x4f3;","20"],
["&#x471;","&#x4f1;","20"],
["&#x471;","&#x4ef;","20"],
["&#x471;","&#x4dd;","41"],
["&#x471;","&#x4cc;","20"],
["&#x471;","&#x4c2;","41"],
["&#x471;","&#x4b9;","20"],
["&#x471;","&#x4b7;","20"],
["&#x471;","&#x4b5;","20"],
["&#x471;","&#x4b3;","41"],
["&#x471;","&#x4ad;","20"],
["&#x471;","&#x4a1;","20"],
["&#x471;","&#x497;","41"],
["&#x471;","&#x201d;","20"],
["&#x471;","&#x2019;","20"],
["&#x471;","&#x45e;","20"],
["&#x471;","&#x44a;","20"],
["&#x471;","&#x447;","20"],
["&#x471;","&#x445;","41"],
["&#x471;","&#x443;","20"],
["&#x471;","&#x442;","20"],
["&#x471;","&#x436;","41"],
["&#x471;","&#x27;","20"],
["&#x471;","&#x22;","20"],
["&#x472;","&#x513;","20"],
["&#x472;","&#x512;","41"],
["&#x472;","&#x50e;","20"],
["&#x472;","&#x509;","20"],
["&#x472;","&#x508;","41"],
["&#x472;","&#x506;","41"],
["&#x472;","&#x504;","41"],
["&#x472;","&#x4fe;","41"],
["&#x472;","&#x4fc;","41"],
["&#x472;","&#x4f4;","41"],
["&#x472;","&#x4f2;","41"],
["&#x472;","&#x4f0;","41"],
["&#x472;","&#x4ee;","41"],
["&#x472;","&#x4ec;","20"],
["&#x472;","&#x4de;","20"],
["&#x472;","&#x4dc;","41"],
["&#x472;","&#x4d4;","41"],
["&#x472;","&#x4d2;","41"],
["&#x472;","&#x4d0;","41"],
["&#x472;","&#x4cb;","41"],
["&#x472;","&#x4c6;","20"],
["&#x472;","&#x4c5;","41"],
["&#x472;","&#x4c1;","41"],
["&#x472;","&#x4b8;","41"],
["&#x472;","&#x4b6;","41"],
["&#x472;","&#x4b4;","20"],
["&#x472;","&#x4b2;","41"],
["&#x472;","&#x4b0;","20"],
["&#x472;","&#x4ae;","20"],
["&#x472;","&#x4ac;","61"],
["&#x472;","&#x4a0;","20"],
["&#x472;","&#x498;","20"],
["&#x472;","&#x496;","41"],
["&#x472;","&#x476;","20"],
["&#x472;","&#x474;","20"],
["&#x472;","&#x470;","41"],
["&#x472;","&#x46e;","20"],
["&#x472;","&#x467;","20"],
["&#x472;","&#x466;","41"],
["&#x472;","&#x201e;","82"],
["&#x472;","&#x201a;","82"],
["&#x472;","&#x459;","20"],
["&#x472;","&#x43b;","20"],
["&#x472;","&#x434;","20"],
["&#x472;","&#x42d;","20"],
["&#x472;","&#x42a;","20"],
["&#x472;","&#x427;","41"],
["&#x472;","&#x425;","41"],
["&#x472;","&#x423;","41"],
["&#x472;","&#x422;","61"],
["&#x472;","&#x41b;","41"],
["&#x472;","&#x417;","20"],
["&#x472;","&#x416;","41"],
["&#x472;","&#x414;","41"],
["&#x472;","&#x410;","41"],
["&#x472;","&#x40e;","41"],
["&#x472;","&#x40b;","20"],
["&#x472;","&#x409;","41"],
["&#x472;","&#x402;","20"],
["&#x472;","&#x2e;","82"],
["&#x472;","&#x2c;","82"],
["&#x473;","&#x50f;","20"],
["&#x473;","&#x507;","20"],
["&#x473;","&#x505;","20"],
["&#x473;","&#x4ff;","41"],
["&#x473;","&#x4fd;","41"],
["&#x473;","&#x4f5;","20"],
["&#x473;","&#x4f3;","20"],
["&#x473;","&#x4f1;","20"],
["&#x473;","&#x4ef;","20"],
["&#x473;","&#x4dd;","41"],
["&#x473;","&#x4cc;","20"],
["&#x473;","&#x4c2;","41"],
["&#x473;","&#x4b9;","20"],
["&#x473;","&#x4b7;","20"],
["&#x473;","&#x4b5;","20"],
["&#x473;","&#x4b3;","41"],
["&#x473;","&#x4ad;","20"],
["&#x473;","&#x4a1;","20"],
["&#x473;","&#x497;","41"],
["&#x473;","&#x201d;","20"],
["&#x473;","&#x2019;","20"],
["&#x473;","&#x45e;","20"],
["&#x473;","&#x44a;","20"],
["&#x473;","&#x447;","20"],
["&#x473;","&#x445;","41"],
["&#x473;","&#x443;","20"],
["&#x473;","&#x442;","20"],
["&#x473;","&#x436;","41"],
["&#x473;","&#x27;","20"],
["&#x473;","&#x22;","20"],
["&#x474;","&#x513;","82"],
["&#x474;","&#x512;","102"],
["&#x474;","&#x511;","41"],
["&#x474;","&#x50d;","41"],
["&#x474;","&#x50c;","20"],
["&#x474;","&#x509;","82"],
["&#x474;","&#x508;","102"],
["&#x474;","&#x503;","41"],
["&#x474;","&#x502;","143"],
["&#x474;","&#x501;","41"],
["&#x474;","&#x500;","143"],
["&#x474;","&#x4f5;","41"],
["&#x474;","&#x4eb;","41"],
["&#x474;","&#x4ea;","20"],
["&#x474;","&#x4e9;","41"],
["&#x474;","&#x4e8;","20"],
["&#x474;","&#x4e7;","41"],
["&#x474;","&#x4e6;","20"],
["&#x474;","&#x4d7;","41"],
["&#x474;","&#x4d4;","143"],
["&#x474;","&#x4d2;","143"],
["&#x474;","&#x4d0;","143"],
["&#x474;","&#x4cc;","41"],
["&#x474;","&#x4c6;","82"],
["&#x474;","&#x4c5;","102"],
["&#x474;","&#x4bf;","61"],
["&#x474;","&#x4be;","41"],
["&#x474;","&#x4bd;","61"],
["&#x474;","&#x4bc;","41"],
["&#x474;","&#x4b9;","41"],
["&#x474;","&#x4b7;","41"],
["&#x474;","&#x4ab;","41"],
["&#x474;","&#x4aa;","20"],
["&#x474;","&#x4a9;","41"],
["&#x474;","&#x4a8;","20"],
["&#x474;","&#x49f;","-102"],
["&#x474;","&#x48d;","-102"],
["&#x474;","&#x481;","41"],
["&#x474;","&#x480;","20"],
["&#x474;","&#x47e;","20"],
["&#x474;","&#x47d;","41"],
["&#x474;","&#x47c;","20"],
["&#x474;","&#x47b;","41"],
["&#x474;","&#x47a;","20"],
["&#x474;","&#x479;","41"],
["&#x474;","&#x478;","20"],
["&#x474;","&#x473;","41"],
["&#x474;","&#x472;","20"],
["&#x474;","&#x467;","82"],
["&#x474;","&#x466;","143"],
["&#x474;","&#x460;","20"],
["&#x474;","&#x450;","41"],
["&#x474;","&#x201e;","123"],
["&#x474;","&#x201a;","123"],
["&#x474;","&#x45b;","-102"],
["&#x474;","&#x459;","82"],
["&#x474;","&#x455;","20"],
["&#x474;","&#x454;","41"],
["&#x474;","&#x452;","-102"],
["&#x474;","&#x451;","41"],
["&#x474;","&#x447;","41"],
["&#x474;","&#x444;","41"],
["&#x474;","&#x441;","41"],
["&#x474;","&#x43e;","41"],
["&#x474;","&#x43b;","82"],
["&#x474;","&#x435;","41"],
["&#x474;","&#x434;","82"],
["&#x474;","&#x42f;","20"],
["&#x474;","&#x424;","61"],
["&#x474;","&#x421;","20"],
["&#x474;","&#x41e;","20"],
["&#x474;","&#x41b;","102"],
["&#x474;","&#x414;","102"],
["&#x474;","&#x410;","143"],
["&#x474;","&#x409;","102"],
["&#x474;","&#x404;","20"],
["&#x474;","&#x2e;","123"],
["&#x474;","&#x2c;","123"],
["&#x475;","&#x513;","41"],
["&#x475;","&#x509;","41"],
["&#x475;","&#x4c6;","41"],
["&#x475;","&#x467;","41"],
["&#x475;","&#x201e;","82"],
["&#x475;","&#x201a;","82"],
["&#x475;","&#x459;","41"],
["&#x475;","&#x43b;","41"],
["&#x475;","&#x434;","41"],
["&#x475;","&#x2e;","82"],
["&#x475;","&#x2c;","82"],
["&#x476;","&#x513;","82"],
["&#x476;","&#x512;","102"],
["&#x476;","&#x511;","41"],
["&#x476;","&#x50d;","41"],
["&#x476;","&#x50c;","20"],
["&#x476;","&#x509;","82"],
["&#x476;","&#x508;","102"],
["&#x476;","&#x503;","41"],
["&#x476;","&#x502;","143"],
["&#x476;","&#x501;","41"],
["&#x476;","&#x500;","143"],
["&#x476;","&#x4f5;","41"],
["&#x476;","&#x4eb;","41"],
["&#x476;","&#x4ea;","20"],
["&#x476;","&#x4e9;","41"],
["&#x476;","&#x4e8;","20"],
["&#x476;","&#x4e7;","41"],
["&#x476;","&#x4e6;","20"],
["&#x476;","&#x4d7;","41"],
["&#x476;","&#x4d4;","143"],
["&#x476;","&#x4d2;","143"],
["&#x476;","&#x4d0;","143"],
["&#x476;","&#x4cc;","41"],
["&#x476;","&#x4c6;","82"],
["&#x476;","&#x4c5;","102"],
["&#x476;","&#x4bf;","61"],
["&#x476;","&#x4be;","41"],
["&#x476;","&#x4bd;","61"],
["&#x476;","&#x4bc;","41"],
["&#x476;","&#x4b9;","41"],
["&#x476;","&#x4b7;","41"],
["&#x476;","&#x4ab;","41"],
["&#x476;","&#x4aa;","20"],
["&#x476;","&#x4a9;","41"],
["&#x476;","&#x4a8;","20"],
["&#x476;","&#x49f;","-102"],
["&#x476;","&#x48d;","-102"],
["&#x476;","&#x481;","41"],
["&#x476;","&#x480;","20"],
["&#x476;","&#x47e;","20"],
["&#x476;","&#x47d;","41"],
["&#x476;","&#x47c;","20"],
["&#x476;","&#x47b;","41"],
["&#x476;","&#x47a;","20"],
["&#x476;","&#x479;","41"],
["&#x476;","&#x478;","20"],
["&#x476;","&#x473;","41"],
["&#x476;","&#x472;","20"],
["&#x476;","&#x467;","82"],
["&#x476;","&#x466;","143"],
["&#x476;","&#x460;","20"],
["&#x476;","&#x450;","41"],
["&#x476;","&#x201e;","123"],
["&#x476;","&#x201a;","123"],
["&#x476;","&#x45b;","-102"],
["&#x476;","&#x459;","82"],
["&#x476;","&#x455;","20"],
["&#x476;","&#x454;","41"],
["&#x476;","&#x452;","-102"],
["&#x476;","&#x451;","41"],
["&#x476;","&#x447;","41"],
["&#x476;","&#x444;","41"],
["&#x476;","&#x441;","41"],
["&#x476;","&#x43e;","41"],
["&#x476;","&#x43b;","82"],
["&#x476;","&#x435;","41"],
["&#x476;","&#x434;","82"],
["&#x476;","&#x42f;","20"],
["&#x476;","&#x424;","61"],
["&#x476;","&#x421;","20"],
["&#x476;","&#x41e;","20"],
["&#x476;","&#x41b;","102"],
["&#x476;","&#x414;","102"],
["&#x476;","&#x410;","143"],
["&#x476;","&#x409;","102"],
["&#x476;","&#x404;","20"],
["&#x476;","&#x2e;","123"],
["&#x476;","&#x2c;","123"],
["&#x477;","&#x513;","41"],
["&#x477;","&#x509;","41"],
["&#x477;","&#x4c6;","41"],
["&#x477;","&#x467;","41"],
["&#x477;","&#x201e;","82"],
["&#x477;","&#x201a;","82"],
["&#x477;","&#x459;","41"],
["&#x477;","&#x43b;","41"],
["&#x477;","&#x434;","41"],
["&#x477;","&#x2e;","82"],
["&#x477;","&#x2c;","82"],
["&#x478;","&#x513;","41"],
["&#x478;","&#x509;","41"],
["&#x478;","&#x4c6;","41"],
["&#x478;","&#x467;","41"],
["&#x478;","&#x201e;","82"],
["&#x478;","&#x201a;","82"],
["&#x478;","&#x459;","41"],
["&#x478;","&#x43b;","41"],
["&#x478;","&#x434;","41"],
["&#x478;","&#x2e;","82"],
["&#x478;","&#x2c;","82"],
["&#x479;","&#x513;","41"],
["&#x479;","&#x509;","41"],
["&#x479;","&#x4c6;","41"],
["&#x479;","&#x467;","41"],
["&#x479;","&#x201e;","82"],
["&#x479;","&#x201a;","82"],
["&#x479;","&#x459;","41"],
["&#x479;","&#x43b;","41"],
["&#x479;","&#x434;","41"],
["&#x479;","&#x2e;","82"],
["&#x479;","&#x2c;","82"],
["&#x47a;","&#x513;","20"],
["&#x47a;","&#x512;","41"],
["&#x47a;","&#x50e;","20"],
["&#x47a;","&#x509;","20"],
["&#x47a;","&#x508;","41"],
["&#x47a;","&#x506;","41"],
["&#x47a;","&#x504;","41"],
["&#x47a;","&#x4fe;","41"],
["&#x47a;","&#x4fc;","41"],
["&#x47a;","&#x4f4;","41"],
["&#x47a;","&#x4f2;","41"],
["&#x47a;","&#x4f0;","41"],
["&#x47a;","&#x4ee;","41"],
["&#x47a;","&#x4ec;","20"],
["&#x47a;","&#x4de;","20"],
["&#x47a;","&#x4dc;","41"],
["&#x47a;","&#x4d4;","41"],
["&#x47a;","&#x4d2;","41"],
["&#x47a;","&#x4d0;","41"],
["&#x47a;","&#x4cb;","41"],
["&#x47a;","&#x4c6;","20"],
["&#x47a;","&#x4c5;","41"],
["&#x47a;","&#x4c1;","41"],
["&#x47a;","&#x4b8;","41"],
["&#x47a;","&#x4b6;","41"],
["&#x47a;","&#x4b4;","20"],
["&#x47a;","&#x4b2;","41"],
["&#x47a;","&#x4b0;","20"],
["&#x47a;","&#x4ae;","20"],
["&#x47a;","&#x4ac;","61"],
["&#x47a;","&#x4a0;","20"],
["&#x47a;","&#x498;","20"],
["&#x47a;","&#x496;","41"],
["&#x47a;","&#x476;","20"],
["&#x47a;","&#x474;","20"],
["&#x47a;","&#x470;","41"],
["&#x47a;","&#x46e;","20"],
["&#x47a;","&#x467;","20"],
["&#x47a;","&#x466;","41"],
["&#x47a;","&#x201e;","82"],
["&#x47a;","&#x201a;","82"],
["&#x47a;","&#x459;","20"],
["&#x47a;","&#x43b;","20"],
["&#x47a;","&#x434;","20"],
["&#x47a;","&#x42d;","20"],
["&#x47a;","&#x42a;","20"],
["&#x47a;","&#x427;","41"],
["&#x47a;","&#x425;","41"],
["&#x47a;","&#x423;","41"],
["&#x47a;","&#x422;","61"],
["&#x47a;","&#x41b;","41"],
["&#x47a;","&#x417;","20"],
["&#x47a;","&#x416;","41"],
["&#x47a;","&#x414;","41"],
["&#x47a;","&#x410;","41"],
["&#x47a;","&#x40e;","41"],
["&#x47a;","&#x40b;","20"],
["&#x47a;","&#x409;","41"],
["&#x47a;","&#x402;","20"],
["&#x47a;","&#x2e;","82"],
["&#x47a;","&#x2c;","82"],
["&#x47b;","&#x50f;","20"],
["&#x47b;","&#x507;","20"],
["&#x47b;","&#x505;","20"],
["&#x47b;","&#x4ff;","41"],
["&#x47b;","&#x4fd;","41"],
["&#x47b;","&#x4f5;","20"],
["&#x47b;","&#x4f3;","20"],
["&#x47b;","&#x4f1;","20"],
["&#x47b;","&#x4ef;","20"],
["&#x47b;","&#x4dd;","41"],
["&#x47b;","&#x4cc;","20"],
["&#x47b;","&#x4c2;","41"],
["&#x47b;","&#x4b9;","20"],
["&#x47b;","&#x4b7;","20"],
["&#x47b;","&#x4b5;","20"],
["&#x47b;","&#x4b3;","41"],
["&#x47b;","&#x4ad;","20"],
["&#x47b;","&#x4a1;","20"],
["&#x47b;","&#x497;","41"],
["&#x47b;","&#x201d;","20"],
["&#x47b;","&#x2019;","20"],
["&#x47b;","&#x45e;","20"],
["&#x47b;","&#x44a;","20"],
["&#x47b;","&#x447;","20"],
["&#x47b;","&#x445;","41"],
["&#x47b;","&#x443;","20"],
["&#x47b;","&#x442;","20"],
["&#x47b;","&#x436;","41"],
["&#x47b;","&#x27;","20"],
["&#x47b;","&#x22;","20"],
["&#x47c;","&#x513;","20"],
["&#x47c;","&#x512;","41"],
["&#x47c;","&#x50e;","20"],
["&#x47c;","&#x509;","20"],
["&#x47c;","&#x508;","41"],
["&#x47c;","&#x506;","41"],
["&#x47c;","&#x504;","41"],
["&#x47c;","&#x4fe;","41"],
["&#x47c;","&#x4fc;","41"],
["&#x47c;","&#x4f4;","41"],
["&#x47c;","&#x4f2;","41"],
["&#x47c;","&#x4f0;","41"],
["&#x47c;","&#x4ee;","41"],
["&#x47c;","&#x4ec;","20"],
["&#x47c;","&#x4de;","20"],
["&#x47c;","&#x4dc;","41"],
["&#x47c;","&#x4d4;","41"],
["&#x47c;","&#x4d2;","41"],
["&#x47c;","&#x4d0;","41"],
["&#x47c;","&#x4cb;","41"],
["&#x47c;","&#x4c6;","20"],
["&#x47c;","&#x4c5;","41"],
["&#x47c;","&#x4c1;","41"],
["&#x47c;","&#x4b8;","41"],
["&#x47c;","&#x4b6;","41"],
["&#x47c;","&#x4b4;","20"],
["&#x47c;","&#x4b2;","41"],
["&#x47c;","&#x4b0;","20"],
["&#x47c;","&#x4ae;","20"],
["&#x47c;","&#x4ac;","61"],
["&#x47c;","&#x4a0;","20"],
["&#x47c;","&#x498;","20"],
["&#x47c;","&#x496;","41"],
["&#x47c;","&#x476;","20"],
["&#x47c;","&#x474;","20"],
["&#x47c;","&#x470;","41"],
["&#x47c;","&#x46e;","20"],
["&#x47c;","&#x467;","20"],
["&#x47c;","&#x466;","41"],
["&#x47c;","&#x201e;","82"],
["&#x47c;","&#x201a;","82"],
["&#x47c;","&#x459;","20"],
["&#x47c;","&#x43b;","20"],
["&#x47c;","&#x434;","20"],
["&#x47c;","&#x42d;","20"],
["&#x47c;","&#x42a;","20"],
["&#x47c;","&#x427;","41"],
["&#x47c;","&#x425;","41"],
["&#x47c;","&#x423;","41"],
["&#x47c;","&#x422;","61"],
["&#x47c;","&#x41b;","41"],
["&#x47c;","&#x417;","20"],
["&#x47c;","&#x416;","41"],
["&#x47c;","&#x414;","41"],
["&#x47c;","&#x410;","41"],
["&#x47c;","&#x40e;","41"],
["&#x47c;","&#x40b;","20"],
["&#x47c;","&#x409;","41"],
["&#x47c;","&#x402;","20"],
["&#x47c;","&#x2e;","82"],
["&#x47c;","&#x2c;","82"],
["&#x47d;","&#x50f;","20"],
["&#x47d;","&#x507;","20"],
["&#x47d;","&#x505;","20"],
["&#x47d;","&#x4ff;","41"],
["&#x47d;","&#x4fd;","41"],
["&#x47d;","&#x4f5;","20"],
["&#x47d;","&#x4f3;","20"],
["&#x47d;","&#x4f1;","20"],
["&#x47d;","&#x4ef;","20"],
["&#x47d;","&#x4dd;","41"],
["&#x47d;","&#x4cc;","20"],
["&#x47d;","&#x4c2;","41"],
["&#x47d;","&#x4b9;","20"],
["&#x47d;","&#x4b7;","20"],
["&#x47d;","&#x4b5;","20"],
["&#x47d;","&#x4b3;","41"],
["&#x47d;","&#x4ad;","20"],
["&#x47d;","&#x4a1;","20"],
["&#x47d;","&#x497;","41"],
["&#x47d;","&#x201d;","20"],
["&#x47d;","&#x2019;","20"],
["&#x47d;","&#x45e;","20"],
["&#x47d;","&#x44a;","20"],
["&#x47d;","&#x447;","20"],
["&#x47d;","&#x445;","41"],
["&#x47d;","&#x443;","20"],
["&#x47d;","&#x442;","20"],
["&#x47d;","&#x436;","41"],
["&#x47d;","&#x27;","20"],
["&#x47d;","&#x22;","20"],
["&#x47e;","&#x513;","20"],
["&#x47e;","&#x512;","41"],
["&#x47e;","&#x50e;","20"],
["&#x47e;","&#x509;","20"],
["&#x47e;","&#x508;","41"],
["&#x47e;","&#x506;","41"],
["&#x47e;","&#x504;","41"],
["&#x47e;","&#x4fe;","41"],
["&#x47e;","&#x4fc;","41"],
["&#x47e;","&#x4f4;","41"],
["&#x47e;","&#x4f2;","41"],
["&#x47e;","&#x4f0;","41"],
["&#x47e;","&#x4ee;","41"],
["&#x47e;","&#x4ec;","20"],
["&#x47e;","&#x4de;","20"],
["&#x47e;","&#x4dc;","41"],
["&#x47e;","&#x4d4;","41"],
["&#x47e;","&#x4d2;","41"],
["&#x47e;","&#x4d0;","41"],
["&#x47e;","&#x4cb;","41"],
["&#x47e;","&#x4c6;","20"],
["&#x47e;","&#x4c5;","41"],
["&#x47e;","&#x4c1;","41"],
["&#x47e;","&#x4b8;","41"],
["&#x47e;","&#x4b6;","41"],
["&#x47e;","&#x4b4;","20"],
["&#x47e;","&#x4b2;","41"],
["&#x47e;","&#x4b0;","20"],
["&#x47e;","&#x4ae;","20"],
["&#x47e;","&#x4ac;","61"],
["&#x47e;","&#x4a0;","20"],
["&#x47e;","&#x498;","20"],
["&#x47e;","&#x496;","41"],
["&#x47e;","&#x476;","20"],
["&#x47e;","&#x474;","20"],
["&#x47e;","&#x470;","41"],
["&#x47e;","&#x46e;","20"],
["&#x47e;","&#x467;","20"],
["&#x47e;","&#x466;","41"],
["&#x47e;","&#x201e;","82"],
["&#x47e;","&#x201a;","82"],
["&#x47e;","&#x459;","20"],
["&#x47e;","&#x43b;","20"],
["&#x47e;","&#x434;","20"],
["&#x47e;","&#x42d;","20"],
["&#x47e;","&#x42a;","20"],
["&#x47e;","&#x427;","41"],
["&#x47e;","&#x425;","41"],
["&#x47e;","&#x423;","41"],
["&#x47e;","&#x422;","61"],
["&#x47e;","&#x41b;","41"],
["&#x47e;","&#x417;","20"],
["&#x47e;","&#x416;","41"],
["&#x47e;","&#x414;","41"],
["&#x47e;","&#x410;","41"],
["&#x47e;","&#x40e;","41"],
["&#x47e;","&#x40b;","20"],
["&#x47e;","&#x409;","41"],
["&#x47e;","&#x402;","20"],
["&#x47e;","&#x2e;","82"],
["&#x47e;","&#x2c;","82"],
["&#x47f;","&#x513;","41"],
["&#x47f;","&#x509;","41"],
["&#x47f;","&#x4c6;","41"],
["&#x47f;","&#x467;","41"],
["&#x47f;","&#x201e;","82"],
["&#x47f;","&#x201a;","82"],
["&#x47f;","&#x459;","41"],
["&#x47f;","&#x43b;","41"],
["&#x47f;","&#x434;","41"],
["&#x47f;","&#x2e;","82"],
["&#x47f;","&#x2c;","82"],
["&#x480;","&#x50c;","41"],
["&#x480;","&#x507;","41"],
["&#x480;","&#x505;","41"],
["&#x480;","&#x502;","41"],
["&#x480;","&#x500;","41"],
["&#x480;","&#x4f5;","41"],
["&#x480;","&#x4ea;","41"],
["&#x480;","&#x4e8;","41"],
["&#x480;","&#x4e6;","41"],
["&#x480;","&#x4cc;","41"],
["&#x480;","&#x4be;","41"],
["&#x480;","&#x4bc;","41"],
["&#x480;","&#x4b9;","41"],
["&#x480;","&#x4b7;","41"],
["&#x480;","&#x4aa;","41"],
["&#x480;","&#x4a8;","41"],
["&#x480;","&#x480;","41"],
["&#x480;","&#x47e;","41"],
["&#x480;","&#x47c;","41"],
["&#x480;","&#x47a;","41"],
["&#x480;","&#x478;","41"],
["&#x480;","&#x472;","41"],
["&#x480;","&#x460;","41"],
["&#x480;","&#x447;","41"],
["&#x480;","&#x424;","41"],
["&#x480;","&#x421;","41"],
["&#x480;","&#x41e;","41"],
["&#x480;","&#x404;","41"],
["&#x48a;","&#x507;","41"],
["&#x48a;","&#x505;","41"],
["&#x48a;","&#x4e1;","-41"],
["&#x48a;","&#x408;","-225"],
["&#x48b;","&#x201d;","20"],
["&#x48b;","&#x2019;","20"],
["&#x48b;","&#x27;","20"],
["&#x48b;","&#x22;","20"],
["&#x48c;","&#x50f;","41"],
["&#x48c;","&#x50e;","41"],
["&#x48c;","&#x506;","102"],
["&#x48c;","&#x504;","102"],
["&#x48c;","&#x4f4;","82"],
["&#x48c;","&#x4cb;","82"],
["&#x48c;","&#x4b8;","82"],
["&#x48c;","&#x4b6;","82"],
["&#x48c;","&#x4b5;","41"],
["&#x48c;","&#x4b4;","41"],
["&#x48c;","&#x4b0;","61"],
["&#x48c;","&#x4ae;","61"],
["&#x48c;","&#x4ad;","41"],
["&#x48c;","&#x4ac;","82"],
["&#x48c;","&#x4a1;","41"],
["&#x48c;","&#x4a0;","41"],
["&#x48c;","&#x476;","61"],
["&#x48c;","&#x474;","61"],
["&#x48c;","&#x470;","82"],
["&#x48c;","&#x201d;","82"],
["&#x48c;","&#x2019;","82"],
["&#x48c;","&#x44a;","41"],
["&#x48c;","&#x442;","41"],
["&#x48c;","&#x42a;","41"],
["&#x48c;","&#x427;","82"],
["&#x48c;","&#x422;","82"],
["&#x48c;","&#x40b;","41"],
["&#x48c;","&#x402;","41"],
["&#x48c;","&#x27;","82"],
["&#x48c;","&#x22;","82"],
["&#x48d;","&#x50f;","102"],
["&#x48d;","&#x507;","102"],
["&#x48d;","&#x505;","102"],
["&#x48d;","&#x4ff;","41"],
["&#x48d;","&#x4fd;","41"],
["&#x48d;","&#x4f5;","82"],
["&#x48d;","&#x4f3;","61"],
["&#x48d;","&#x4f1;","61"],
["&#x48d;","&#x4ef;","61"],
["&#x48d;","&#x4e1;","41"],
["&#x48d;","&#x4dd;","41"],
["&#x48d;","&#x4cc;","82"],
["&#x48d;","&#x4c2;","41"],
["&#x48d;","&#x4bf;","41"],
["&#x48d;","&#x4bd;","41"],
["&#x48d;","&#x4b9;","82"],
["&#x48d;","&#x4b7;","82"],
["&#x48d;","&#x4b5;","102"],
["&#x48d;","&#x4b3;","41"],
["&#x48d;","&#x4b1;","61"],
["&#x48d;","&#x4af;","61"],
["&#x48d;","&#x4ad;","102"],
["&#x48d;","&#x4a1;","102"],
["&#x48d;","&#x497;","41"],
["&#x48d;","&#x47f;","41"],
["&#x48d;","&#x477;","41"],
["&#x48d;","&#x475;","41"],
["&#x48d;","&#x461;","41"],
["&#x48d;","&#x201d;","123"],
["&#x48d;","&#x2019;","123"],
["&#x48d;","&#x45e;","61"],
["&#x48d;","&#x44a;","102"],
["&#x48d;","&#x447;","82"],
["&#x48d;","&#x445;","41"],
["&#x48d;","&#x443;","61"],
["&#x48d;","&#x442;","102"],
["&#x48d;","&#x436;","41"],
["&#x48d;","&#x27;","123"],
["&#x48d;","&#x22;","123"],
["&#x48e;","&#x513;","102"],
["&#x48e;","&#x512;","123"],
["&#x48e;","&#x509;","102"],
["&#x48e;","&#x508;","123"],
["&#x48e;","&#x502;","82"],
["&#x48e;","&#x500;","82"],
["&#x48e;","&#x4fe;","41"],
["&#x48e;","&#x4fc;","41"],
["&#x48e;","&#x4dc;","41"],
["&#x48e;","&#x4d4;","102"],
["&#x48e;","&#x4d2;","102"],
["&#x48e;","&#x4d0;","102"],
["&#x48e;","&#x4c6;","102"],
["&#x48e;","&#x4c5;","123"],
["&#x48e;","&#x4c1;","41"],
["&#x48e;","&#x4b2;","41"],
["&#x48e;","&#x496;","41"],
["&#x48e;","&#x46a;","20"],
["&#x48e;","&#x467;","102"],
["&#x48e;","&#x466;","102"],
["&#x48e;","&#x201e;","266"],
["&#x48e;","&#x201a;","266"],
["&#x48e;","&#x459;","102"],
["&#x48e;","&#x43b;","102"],
["&#x48e;","&#x434;","102"],
["&#x48e;","&#x425;","41"],
["&#x48e;","&#x41b;","123"],
["&#x48e;","&#x416;","41"],
["&#x48e;","&#x414;","123"],
["&#x48e;","&#x410;","102"],
["&#x48e;","&#x409;","123"],
["&#x48e;","&#x2e;","266"],
["&#x48e;","&#x2c;","266"],
["&#x48f;","&#x50f;","20"],
["&#x48f;","&#x507;","20"],
["&#x48f;","&#x505;","20"],
["&#x48f;","&#x4ff;","41"],
["&#x48f;","&#x4fd;","41"],
["&#x48f;","&#x4f5;","20"],
["&#x48f;","&#x4f3;","20"],
["&#x48f;","&#x4f1;","20"],
["&#x48f;","&#x4ef;","20"],
["&#x48f;","&#x4dd;","41"],
["&#x48f;","&#x4cc;","20"],
["&#x48f;","&#x4c2;","41"],
["&#x48f;","&#x4b9;","20"],
["&#x48f;","&#x4b7;","20"],
["&#x48f;","&#x4b5;","20"],
["&#x48f;","&#x4b3;","41"],
["&#x48f;","&#x4ad;","20"],
["&#x48f;","&#x4a1;","20"],
["&#x48f;","&#x497;","41"],
["&#x48f;","&#x201d;","20"],
["&#x48f;","&#x2019;","20"],
["&#x48f;","&#x45e;","20"],
["&#x48f;","&#x44a;","20"],
["&#x48f;","&#x447;","20"],
["&#x48f;","&#x445;","41"],
["&#x48f;","&#x443;","20"],
["&#x48f;","&#x442;","20"],
["&#x48f;","&#x436;","41"],
["&#x48f;","&#x27;","20"],
["&#x48f;","&#x22;","20"],
["&#x492;","&#x513;","102"],
["&#x492;","&#x512;","82"],
["&#x492;","&#x511;","82"],
["&#x492;","&#x50e;","-41"],
["&#x492;","&#x50d;","82"],
["&#x492;","&#x50c;","41"],
["&#x492;","&#x50b;","61"],
["&#x492;","&#x509;","102"],
["&#x492;","&#x508;","82"],
["&#x492;","&#x507;","41"],
["&#x492;","&#x505;","41"],
["&#x492;","&#x503;","82"],
["&#x492;","&#x502;","102"],
["&#x492;","&#x501;","82"],
["&#x492;","&#x500;","102"],
["&#x492;","&#x4ff;","41"],
["&#x492;","&#x4fd;","41"],
["&#x492;","&#x4f9;","61"],
["&#x492;","&#x4f7;","61"],
["&#x492;","&#x4f5;","102"],
["&#x492;","&#x4ed;","41"],
["&#x492;","&#x4eb;","82"],
["&#x492;","&#x4ea;","41"],
["&#x492;","&#x4e9;","82"],
["&#x492;","&#x4e8;","41"],
["&#x492;","&#x4e7;","82"],
["&#x492;","&#x4e6;","41"],
["&#x492;","&#x4e5;","61"],
["&#x492;","&#x4e3;","61"],
["&#x492;","&#x4df;","41"],
["&#x492;","&#x4dd;","41"],
["&#x492;","&#x4d7;","82"],
["&#x492;","&#x4d4;","123"],
["&#x492;","&#x4d2;","123"],
["&#x492;","&#x4d0;","123"],
["&#x492;","&#x4ce;","61"],
["&#x492;","&#x4cc;","102"],
["&#x492;","&#x4ca;","61"],
["&#x492;","&#x4c8;","61"],
["&#x492;","&#x4c6;","102"],
["&#x492;","&#x4c5;","82"],
["&#x492;","&#x4c4;","61"],
["&#x492;","&#x4c2;","41"],
["&#x492;","&#x4bf;","61"],
["&#x492;","&#x4be;","41"],
["&#x492;","&#x4bd;","61"],
["&#x492;","&#x4bc;","41"],
["&#x492;","&#x4bb;","61"],
["&#x492;","&#x4b9;","102"],
["&#x492;","&#x4b7;","102"],
["&#x492;","&#x4b4;","-41"],
["&#x492;","&#x4b3;","41"],
["&#x492;","&#x4ac;","-41"],
["&#x492;","&#x4ab;","82"],
["&#x492;","&#x4aa;","41"],
["&#x492;","&#x4a9;","82"],
["&#x492;","&#x4a8;","41"],
["&#x492;","&#x4a7;","61"],
["&#x492;","&#x4a5;","61"],
["&#x492;","&#x4a3;","61"],
["&#x492;","&#x4a0;","-41"],
["&#x492;","&#x49f;","-41"],
["&#x492;","&#x49d;","61"],
["&#x492;","&#x49b;","61"],
["&#x492;","&#x499;","41"],
["&#x492;","&#x497;","41"],
["&#x492;","&#x495;","61"],
["&#x492;","&#x48f;","61"],
["&#x492;","&#x48d;","-41"],
["&#x492;","&#x48b;","61"],
["&#x492;","&#x481;","82"],
["&#x492;","&#x480;","41"],
["&#x492;","&#x47e;","41"],
["&#x492;","&#x47d;","82"],
["&#x492;","&#x47c;","41"],
["&#x492;","&#x47b;","82"],
["&#x492;","&#x47a;","41"],
["&#x492;","&#x479;","82"],
["&#x492;","&#x478;","41"],
["&#x492;","&#x473;","82"],
["&#x492;","&#x472;","41"],
["&#x492;","&#x471;","61"],
["&#x492;","&#x46d;","61"],
["&#x492;","&#x46b;","41"],
["&#x492;","&#x469;","61"],
["&#x492;","&#x467;","102"],
["&#x492;","&#x466;","123"],
["&#x492;","&#x465;","61"],
["&#x492;","&#x460;","41"],
["&#x492;","&#x45d;","61"],
["&#x492;","&#x450;","82"],
["&#x492;","&#x201e;","102"],
["&#x492;","&#x201a;","102"],
["&#x492;","&#x2015;","41"],
["&#x492;","&#x2014;","41"],
["&#x492;","&#x2013;","41"],
["&#x492;","&#x491;","61"],
["&#x492;","&#x45f;","61"],
["&#x492;","&#x45c;","61"],
["&#x492;","&#x45b;","-41"],
["&#x492;","&#x45a;","61"],
["&#x492;","&#x459;","102"],
["&#x492;","&#x455;","61"],
["&#x492;","&#x454;","82"],
["&#x492;","&#x453;","61"],
["&#x492;","&#x452;","-41"],
["&#x492;","&#x451;","82"],
["&#x492;","&#x44e;","61"],
["&#x492;","&#x44d;","41"],
["&#x492;","&#x44c;","61"],
["&#x492;","&#x44b;","61"],
["&#x492;","&#x449;","61"],
["&#x492;","&#x448;","61"],
["&#x492;","&#x447;","102"],
["&#x492;","&#x446;","61"],
["&#x492;","&#x445;","41"],
["&#x492;","&#x444;","82"],
["&#x492;","&#x441;","82"],
["&#x492;","&#x440;","61"],
["&#x492;","&#x43f;","61"],
["&#x492;","&#x43e;","82"],
["&#x492;","&#x43d;","61"],
["&#x492;","&#x43c;","61"],
["&#x492;","&#x43b;","102"],
["&#x492;","&#x43a;","61"],
["&#x492;","&#x439;","61"],
["&#x492;","&#x438;","61"],
["&#x492;","&#x437;","41"],
["&#x492;","&#x436;","41"],
["&#x492;","&#x435;","82"],
["&#x492;","&#x434;","102"],
["&#x492;","&#x433;","61"],
["&#x492;","&#x432;","61"],
["&#x492;","&#x42a;","-41"],
["&#x492;","&#x424;","61"],
["&#x492;","&#x422;","-41"],
["&#x492;","&#x421;","41"],
["&#x492;","&#x41e;","41"],
["&#x492;","&#x41b;","82"],
["&#x492;","&#x414;","82"],
["&#x492;","&#x410;","123"],
["&#x492;","&#x40b;","-41"],
["&#x492;","&#x409;","82"],
["&#x492;","&#x404;","41"],
["&#x492;","&#x402;","-41"],
["&#x492;","&#x2e;","102"],
["&#x492;","&#x2d;","41"],
["&#x492;","&#x2c;","102"],
["&#x493;","&#x513;","61"],
["&#x493;","&#x511;","41"],
["&#x493;","&#x50d;","41"],
["&#x493;","&#x509;","61"],
["&#x493;","&#x503;","41"],
["&#x493;","&#x501;","41"],
["&#x493;","&#x4eb;","41"],
["&#x493;","&#x4e9;","41"],
["&#x493;","&#x4e7;","41"],
["&#x493;","&#x4d7;","41"],
["&#x493;","&#x4c6;","61"],
["&#x493;","&#x4ab;","41"],
["&#x493;","&#x4a9;","41"],
["&#x493;","&#x481;","41"],
["&#x493;","&#x47d;","41"],
["&#x493;","&#x47b;","41"],
["&#x493;","&#x479;","41"],
["&#x493;","&#x473;","41"],
["&#x493;","&#x467;","61"],
["&#x493;","&#x450;","41"],
["&#x493;","&#x201e;","61"],
["&#x493;","&#x201a;","61"],
["&#x493;","&#x459;","61"],
["&#x493;","&#x454;","41"],
["&#x493;","&#x451;","41"],
["&#x493;","&#x444;","41"],
["&#x493;","&#x441;","41"],
["&#x493;","&#x43e;","41"],
["&#x493;","&#x43b;","61"],
["&#x493;","&#x435;","41"],
["&#x493;","&#x434;","61"],
["&#x493;","&#x2e;","61"],
["&#x493;","&#x2c;","61"],
["&#x494;","&#x50f;","41"],
["&#x494;","&#x50e;","61"],
["&#x494;","&#x507;","61"],
["&#x494;","&#x506;","41"],
["&#x494;","&#x505;","61"],
["&#x494;","&#x504;","41"],
["&#x494;","&#x4f5;","41"],
["&#x494;","&#x4f4;","82"],
["&#x494;","&#x4cc;","41"],
["&#x494;","&#x4cb;","82"],
["&#x494;","&#x4b9;","41"],
["&#x494;","&#x4b8;","82"],
["&#x494;","&#x4b7;","41"],
["&#x494;","&#x4b6;","82"],
["&#x494;","&#x4b5;","41"],
["&#x494;","&#x4b4;","61"],
["&#x494;","&#x4b0;","41"],
["&#x494;","&#x4ae;","41"],
["&#x494;","&#x4ad;","41"],
["&#x494;","&#x4ac;","61"],
["&#x494;","&#x4a1;","41"],
["&#x494;","&#x4a0;","61"],
["&#x494;","&#x476;","61"],
["&#x494;","&#x474;","61"],
["&#x494;","&#x470;","82"],
["&#x494;","&#x201d;","61"],
["&#x494;","&#x2019;","61"],
["&#x494;","&#x44a;","41"],
["&#x494;","&#x447;","41"],
["&#x494;","&#x442;","41"],
["&#x494;","&#x42a;","61"],
["&#x494;","&#x427;","82"],
["&#x494;","&#x422;","61"],
["&#x494;","&#x40b;","61"],
["&#x494;","&#x408;","-102"],
["&#x494;","&#x402;","61"],
["&#x494;","&#x27;","61"],
["&#x494;","&#x22;","61"],
["&#x495;","&#x507;","41"],
["&#x495;","&#x505;","41"],
["&#x495;","&#x201d;","61"],
["&#x495;","&#x2019;","61"],
["&#x495;","&#x27;","61"],
["&#x495;","&#x22;","61"],
["&#x496;","&#x50f;","41"],
["&#x496;","&#x50c;","41"],
["&#x496;","&#x507;","41"],
["&#x496;","&#x505;","41"],
["&#x496;","&#x4f5;","82"],
["&#x496;","&#x4ea;","41"],
["&#x496;","&#x4e8;","41"],
["&#x496;","&#x4e6;","41"],
["&#x496;","&#x4cc;","82"],
["&#x496;","&#x4bf;","41"],
["&#x496;","&#x4be;","61"],
["&#x496;","&#x4bd;","41"],
["&#x496;","&#x4bc;","61"],
["&#x496;","&#x4b9;","82"],
["&#x496;","&#x4b7;","82"],
["&#x496;","&#x4b5;","41"],
["&#x496;","&#x4ad;","41"],
["&#x496;","&#x4aa;","41"],
["&#x496;","&#x4a8;","41"],
["&#x496;","&#x4a1;","41"],
["&#x496;","&#x480;","41"],
["&#x496;","&#x47e;","41"],
["&#x496;","&#x47c;","41"],
["&#x496;","&#x47a;","41"],
["&#x496;","&#x478;","41"],
["&#x496;","&#x472;","41"],
["&#x496;","&#x471;","20"],
["&#x496;","&#x46f;","-61"],
["&#x496;","&#x460;","41"],
["&#x496;","&#x44a;","41"],
["&#x496;","&#x447;","82"],
["&#x496;","&#x442;","41"],
["&#x496;","&#x424;","61"],
["&#x496;","&#x421;","41"],
["&#x496;","&#x41e;","41"],
["&#x496;","&#x408;","-225"],
["&#x496;","&#x404;","41"],
["&#x497;","&#x511;","20"],
["&#x497;","&#x50d;","20"],
["&#x497;","&#x507;","41"],
["&#x497;","&#x505;","41"],
["&#x497;","&#x503;","20"],
["&#x497;","&#x501;","20"],
["&#x497;","&#x4f5;","20"],
["&#x497;","&#x4eb;","20"],
["&#x497;","&#x4e9;","20"],
["&#x497;","&#x4e7;","20"],
["&#x497;","&#x4d7;","20"],
["&#x497;","&#x4cc;","20"],
["&#x497;","&#x4b9;","20"],
["&#x497;","&#x4b7;","20"],
["&#x497;","&#x4ab;","20"],
["&#x497;","&#x4a9;","20"],
["&#x497;","&#x481;","20"],
["&#x497;","&#x47d;","20"],
["&#x497;","&#x47b;","20"],
["&#x497;","&#x479;","20"],
["&#x497;","&#x473;","20"],
["&#x497;","&#x450;","20"],
["&#x497;","&#x454;","20"],
["&#x497;","&#x451;","20"],
["&#x497;","&#x447;","20"],
["&#x497;","&#x444;","20"],
["&#x497;","&#x441;","20"],
["&#x497;","&#x43e;","20"],
["&#x497;","&#x435;","20"],
["&#x498;","&#x506;","41"],
["&#x498;","&#x504;","41"],
["&#x498;","&#x4b0;","20"],
["&#x498;","&#x4ae;","20"],
["&#x498;","&#x476;","20"],
["&#x498;","&#x474;","20"],
["&#x498;","&#x201e;","82"],
["&#x498;","&#x201a;","82"],
["&#x498;","&#x2e;","82"],
["&#x498;","&#x2c;","82"],
["&#x499;","&#x44f;","-41"],
["&#x49a;","&#x50f;","41"],
["&#x49a;","&#x50c;","41"],
["&#x49a;","&#x507;","41"],
["&#x49a;","&#x505;","41"],
["&#x49a;","&#x4f5;","82"],
["&#x49a;","&#x4ea;","41"],
["&#x49a;","&#x4e8;","41"],
["&#x49a;","&#x4e6;","41"],
["&#x49a;","&#x4cc;","82"],
["&#x49a;","&#x4bf;","41"],
["&#x49a;","&#x4be;","61"],
["&#x49a;","&#x4bd;","41"],
["&#x49a;","&#x4bc;","61"],
["&#x49a;","&#x4b9;","82"],
["&#x49a;","&#x4b7;","82"],
["&#x49a;","&#x4b5;","41"],
["&#x49a;","&#x4ad;","41"],
["&#x49a;","&#x4aa;","41"],
["&#x49a;","&#x4a8;","41"],
["&#x49a;","&#x4a1;","41"],
["&#x49a;","&#x480;","41"],
["&#x49a;","&#x47e;","41"],
["&#x49a;","&#x47c;","41"],
["&#x49a;","&#x47a;","41"],
["&#x49a;","&#x478;","41"],
["&#x49a;","&#x472;","41"],
["&#x49a;","&#x471;","20"],
["&#x49a;","&#x46f;","-61"],
["&#x49a;","&#x460;","41"],
["&#x49a;","&#x44a;","41"],
["&#x49a;","&#x447;","82"],
["&#x49a;","&#x442;","41"],
["&#x49a;","&#x424;","61"],
["&#x49a;","&#x421;","41"],
["&#x49a;","&#x41e;","41"],
["&#x49a;","&#x408;","-225"],
["&#x49a;","&#x404;","41"],
["&#x49b;","&#x511;","20"],
["&#x49b;","&#x50d;","20"],
["&#x49b;","&#x507;","41"],
["&#x49b;","&#x505;","41"],
["&#x49b;","&#x503;","20"],
["&#x49b;","&#x501;","20"],
["&#x49b;","&#x4f5;","20"],
["&#x49b;","&#x4eb;","20"],
["&#x49b;","&#x4e9;","20"],
["&#x49b;","&#x4e7;","20"],
["&#x49b;","&#x4d7;","20"],
["&#x49b;","&#x4cc;","20"],
["&#x49b;","&#x4b9;","20"],
["&#x49b;","&#x4b7;","20"],
["&#x49b;","&#x4ab;","20"],
["&#x49b;","&#x4a9;","20"],
["&#x49b;","&#x481;","20"],
["&#x49b;","&#x47d;","20"],
["&#x49b;","&#x47b;","20"],
["&#x49b;","&#x479;","20"],
["&#x49b;","&#x473;","20"],
["&#x49b;","&#x450;","20"],
["&#x49b;","&#x454;","20"],
["&#x49b;","&#x451;","20"],
["&#x49b;","&#x447;","20"],
["&#x49b;","&#x444;","20"],
["&#x49b;","&#x441;","20"],
["&#x49b;","&#x43e;","20"],
["&#x49b;","&#x435;","20"],
["&#x49c;","&#x510;","20"],
["&#x49c;","&#x50c;","41"],
["&#x49c;","&#x507;","41"],
["&#x49c;","&#x505;","41"],
["&#x49c;","&#x502;","41"],
["&#x49c;","&#x500;","41"],
["&#x49c;","&#x4f5;","41"],
["&#x49c;","&#x4f4;","41"],
["&#x49c;","&#x4ea;","41"],
["&#x49c;","&#x4e8;","41"],
["&#x49c;","&#x4e6;","41"],
["&#x49c;","&#x4cc;","41"],
["&#x49c;","&#x4cb;","41"],
["&#x49c;","&#x4be;","102"],
["&#x49c;","&#x4bc;","102"],
["&#x49c;","&#x4b9;","41"],
["&#x49c;","&#x4b8;","41"],
["&#x49c;","&#x4b7;","41"],
["&#x49c;","&#x4b6;","41"],
["&#x49c;","&#x4aa;","41"],
["&#x49c;","&#x4a8;","41"],
["&#x49c;","&#x480;","41"],
["&#x49c;","&#x47e;","41"],
["&#x49c;","&#x47c;","41"],
["&#x49c;","&#x47a;","41"],
["&#x49c;","&#x478;","41"],
["&#x49c;","&#x472;","41"],
["&#x49c;","&#x470;","41"],
["&#x49c;","&#x460;","41"],
["&#x49c;","&#x447;","41"],
["&#x49c;","&#x427;","41"],
["&#x49c;","&#x424;","41"],
["&#x49c;","&#x421;","41"],
["&#x49c;","&#x41e;","41"],
["&#x49c;","&#x404;","41"],
["&#x49d;","&#x511;","41"],
["&#x49d;","&#x50d;","41"],
["&#x49d;","&#x503;","41"],
["&#x49d;","&#x501;","41"],
["&#x49d;","&#x4f5;","41"],
["&#x49d;","&#x4eb;","41"],
["&#x49d;","&#x4e9;","41"],
["&#x49d;","&#x4e7;","41"],
["&#x49d;","&#x4d7;","41"],
["&#x49d;","&#x4cc;","41"],
["&#x49d;","&#x4bf;","41"],
["&#x49d;","&#x4bd;","41"],
["&#x49d;","&#x4b9;","41"],
["&#x49d;","&#x4b7;","41"],
["&#x49d;","&#x4ab;","41"],
["&#x49d;","&#x4a9;","41"],
["&#x49d;","&#x481;","41"],
["&#x49d;","&#x47d;","41"],
["&#x49d;","&#x47b;","41"],
["&#x49d;","&#x479;","41"],
["&#x49d;","&#x473;","41"],
["&#x49d;","&#x450;","41"],
["&#x49d;","&#x454;","41"],
["&#x49d;","&#x451;","41"],
["&#x49d;","&#x447;","41"],
["&#x49d;","&#x444;","41"],
["&#x49d;","&#x441;","41"],
["&#x49d;","&#x43e;","41"],
["&#x49d;","&#x435;","41"],
["&#x49e;","&#x510;","20"],
["&#x49e;","&#x50c;","41"],
["&#x49e;","&#x507;","41"],
["&#x49e;","&#x505;","41"],
["&#x49e;","&#x502;","41"],
["&#x49e;","&#x500;","41"],
["&#x49e;","&#x4f5;","41"],
["&#x49e;","&#x4f4;","41"],
["&#x49e;","&#x4ea;","41"],
["&#x49e;","&#x4e8;","41"],
["&#x49e;","&#x4e6;","41"],
["&#x49e;","&#x4cc;","41"],
["&#x49e;","&#x4cb;","41"],
["&#x49e;","&#x4be;","102"],
["&#x49e;","&#x4bc;","102"],
["&#x49e;","&#x4b9;","41"],
["&#x49e;","&#x4b8;","41"],
["&#x49e;","&#x4b7;","41"],
["&#x49e;","&#x4b6;","41"],
["&#x49e;","&#x4aa;","41"],
["&#x49e;","&#x4a8;","41"],
["&#x49e;","&#x480;","41"],
["&#x49e;","&#x47e;","41"],
["&#x49e;","&#x47c;","41"],
["&#x49e;","&#x47a;","41"],
["&#x49e;","&#x478;","41"],
["&#x49e;","&#x472;","41"],
["&#x49e;","&#x470;","41"],
["&#x49e;","&#x460;","41"],
["&#x49e;","&#x447;","41"],
["&#x49e;","&#x427;","41"],
["&#x49e;","&#x424;","41"],
["&#x49e;","&#x421;","41"],
["&#x49e;","&#x41e;","41"],
["&#x49e;","&#x404;","41"],
["&#x49f;","&#x511;","41"],
["&#x49f;","&#x50d;","41"],
["&#x49f;","&#x503;","41"],
["&#x49f;","&#x501;","41"],
["&#x49f;","&#x4f5;","41"],
["&#x49f;","&#x4eb;","41"],
["&#x49f;","&#x4e9;","41"],
["&#x49f;","&#x4e7;","41"],
["&#x49f;","&#x4d7;","41"],
["&#x49f;","&#x4cc;","41"],
["&#x49f;","&#x4bf;","41"],
["&#x49f;","&#x4bd;","41"],
["&#x49f;","&#x4b9;","41"],
["&#x49f;","&#x4b7;","41"],
["&#x49f;","&#x4ab;","41"],
["&#x49f;","&#x4a9;","41"],
["&#x49f;","&#x481;","41"],
["&#x49f;","&#x47d;","41"],
["&#x49f;","&#x47b;","41"],
["&#x49f;","&#x479;","41"],
["&#x49f;","&#x473;","41"],
["&#x49f;","&#x450;","41"],
["&#x49f;","&#x454;","41"],
["&#x49f;","&#x451;","41"],
["&#x49f;","&#x447;","41"],
["&#x49f;","&#x444;","41"],
["&#x49f;","&#x441;","41"],
["&#x49f;","&#x43e;","41"],
["&#x49f;","&#x435;","41"],
["&#x4a0;","&#x510;","20"],
["&#x4a0;","&#x50c;","41"],
["&#x4a0;","&#x507;","41"],
["&#x4a0;","&#x505;","41"],
["&#x4a0;","&#x502;","41"],
["&#x4a0;","&#x500;","41"],
["&#x4a0;","&#x4f5;","41"],
["&#x4a0;","&#x4f4;","41"],
["&#x4a0;","&#x4ea;","41"],
["&#x4a0;","&#x4e8;","41"],
["&#x4a0;","&#x4e6;","41"],
["&#x4a0;","&#x4cc;","41"],
["&#x4a0;","&#x4cb;","41"],
["&#x4a0;","&#x4be;","102"],
["&#x4a0;","&#x4bc;","102"],
["&#x4a0;","&#x4b9;","41"],
["&#x4a0;","&#x4b8;","41"],
["&#x4a0;","&#x4b7;","41"],
["&#x4a0;","&#x4b6;","41"],
["&#x4a0;","&#x4aa;","41"],
["&#x4a0;","&#x4a8;","41"],
["&#x4a0;","&#x480;","41"],
["&#x4a0;","&#x47e;","41"],
["&#x4a0;","&#x47c;","41"],
["&#x4a0;","&#x47a;","41"],
["&#x4a0;","&#x478;","41"],
["&#x4a0;","&#x472;","41"],
["&#x4a0;","&#x470;","41"],
["&#x4a0;","&#x460;","41"],
["&#x4a0;","&#x447;","41"],
["&#x4a0;","&#x427;","41"],
["&#x4a0;","&#x424;","41"],
["&#x4a0;","&#x421;","41"],
["&#x4a0;","&#x41e;","41"],
["&#x4a0;","&#x404;","41"],
["&#x4a1;","&#x511;","41"],
["&#x4a1;","&#x50d;","41"],
["&#x4a1;","&#x503;","41"],
["&#x4a1;","&#x501;","41"],
["&#x4a1;","&#x4f5;","41"],
["&#x4a1;","&#x4eb;","41"],
["&#x4a1;","&#x4e9;","41"],
["&#x4a1;","&#x4e7;","41"],
["&#x4a1;","&#x4d7;","41"],
["&#x4a1;","&#x4cc;","41"],
["&#x4a1;","&#x4bf;","41"],
["&#x4a1;","&#x4bd;","41"],
["&#x4a1;","&#x4b9;","41"],
["&#x4a1;","&#x4b7;","41"],
["&#x4a1;","&#x4ab;","41"],
["&#x4a1;","&#x4a9;","41"],
["&#x4a1;","&#x481;","41"],
["&#x4a1;","&#x47d;","41"],
["&#x4a1;","&#x47b;","41"],
["&#x4a1;","&#x479;","41"],
["&#x4a1;","&#x473;","41"],
["&#x4a1;","&#x450;","41"],
["&#x4a1;","&#x454;","41"],
["&#x4a1;","&#x451;","41"],
["&#x4a1;","&#x447;","41"],
["&#x4a1;","&#x444;","41"],
["&#x4a1;","&#x441;","41"],
["&#x4a1;","&#x43e;","41"],
["&#x4a1;","&#x435;","41"],
["&#x4a2;","&#x507;","41"],
["&#x4a2;","&#x505;","41"],
["&#x4a2;","&#x4e1;","-41"],
["&#x4a2;","&#x408;","-225"],
["&#x4a3;","&#x201d;","20"],
["&#x4a3;","&#x2019;","20"],
["&#x4a3;","&#x27;","20"],
["&#x4a3;","&#x22;","20"],
["&#x4a4;","&#x513;","102"],
["&#x4a4;","&#x512;","82"],
["&#x4a4;","&#x511;","82"],
["&#x4a4;","&#x50e;","-41"],
["&#x4a4;","&#x50d;","82"],
["&#x4a4;","&#x50c;","41"],
["&#x4a4;","&#x50b;","61"],
["&#x4a4;","&#x509;","102"],
["&#x4a4;","&#x508;","82"],
["&#x4a4;","&#x507;","41"],
["&#x4a4;","&#x505;","41"],
["&#x4a4;","&#x503;","82"],
["&#x4a4;","&#x502;","102"],
["&#x4a4;","&#x501;","82"],
["&#x4a4;","&#x500;","102"],
["&#x4a4;","&#x4ff;","41"],
["&#x4a4;","&#x4fd;","41"],
["&#x4a4;","&#x4f9;","61"],
["&#x4a4;","&#x4f7;","61"],
["&#x4a4;","&#x4f5;","102"],
["&#x4a4;","&#x4ed;","41"],
["&#x4a4;","&#x4eb;","82"],
["&#x4a4;","&#x4ea;","41"],
["&#x4a4;","&#x4e9;","82"],
["&#x4a4;","&#x4e8;","41"],
["&#x4a4;","&#x4e7;","82"],
["&#x4a4;","&#x4e6;","41"],
["&#x4a4;","&#x4e5;","61"],
["&#x4a4;","&#x4e3;","61"],
["&#x4a4;","&#x4df;","41"],
["&#x4a4;","&#x4dd;","41"],
["&#x4a4;","&#x4d7;","82"],
["&#x4a4;","&#x4d4;","123"],
["&#x4a4;","&#x4d2;","123"],
["&#x4a4;","&#x4d0;","123"],
["&#x4a4;","&#x4ce;","61"],
["&#x4a4;","&#x4cc;","102"],
["&#x4a4;","&#x4ca;","61"],
["&#x4a4;","&#x4c8;","61"],
["&#x4a4;","&#x4c6;","102"],
["&#x4a4;","&#x4c5;","82"],
["&#x4a4;","&#x4c4;","61"],
["&#x4a4;","&#x4c2;","41"],
["&#x4a4;","&#x4bf;","61"],
["&#x4a4;","&#x4be;","41"],
["&#x4a4;","&#x4bd;","61"],
["&#x4a4;","&#x4bc;","41"],
["&#x4a4;","&#x4bb;","61"],
["&#x4a4;","&#x4b9;","102"],
["&#x4a4;","&#x4b7;","102"],
["&#x4a4;","&#x4b4;","-41"],
["&#x4a4;","&#x4b3;","41"],
["&#x4a4;","&#x4ac;","-41"],
["&#x4a4;","&#x4ab;","82"],
["&#x4a4;","&#x4aa;","41"],
["&#x4a4;","&#x4a9;","82"],
["&#x4a4;","&#x4a8;","41"],
["&#x4a4;","&#x4a7;","61"],
["&#x4a4;","&#x4a5;","61"],
["&#x4a4;","&#x4a3;","61"],
["&#x4a4;","&#x4a0;","-41"],
["&#x4a4;","&#x49f;","-41"],
["&#x4a4;","&#x49d;","61"],
["&#x4a4;","&#x49b;","61"],
["&#x4a4;","&#x499;","41"],
["&#x4a4;","&#x497;","41"],
["&#x4a4;","&#x495;","61"],
["&#x4a4;","&#x48f;","61"],
["&#x4a4;","&#x48d;","-41"],
["&#x4a4;","&#x48b;","61"],
["&#x4a4;","&#x481;","82"],
["&#x4a4;","&#x480;","41"],
["&#x4a4;","&#x47e;","41"],
["&#x4a4;","&#x47d;","82"],
["&#x4a4;","&#x47c;","41"],
["&#x4a4;","&#x47b;","82"],
["&#x4a4;","&#x47a;","41"],
["&#x4a4;","&#x479;","82"],
["&#x4a4;","&#x478;","41"],
["&#x4a4;","&#x473;","82"],
["&#x4a4;","&#x472;","41"],
["&#x4a4;","&#x471;","61"],
["&#x4a4;","&#x46d;","61"],
["&#x4a4;","&#x46b;","41"],
["&#x4a4;","&#x469;","61"],
["&#x4a4;","&#x467;","102"],
["&#x4a4;","&#x466;","123"],
["&#x4a4;","&#x465;","61"],
["&#x4a4;","&#x460;","41"],
["&#x4a4;","&#x45d;","61"],
["&#x4a4;","&#x450;","82"],
["&#x4a4;","&#x201e;","102"],
["&#x4a4;","&#x201a;","102"],
["&#x4a4;","&#x2015;","41"],
["&#x4a4;","&#x2014;","41"],
["&#x4a4;","&#x2013;","41"],
["&#x4a4;","&#x491;","61"],
["&#x4a4;","&#x45f;","61"],
["&#x4a4;","&#x45c;","61"],
["&#x4a4;","&#x45b;","-41"],
["&#x4a4;","&#x45a;","61"],
["&#x4a4;","&#x459;","102"],
["&#x4a4;","&#x455;","61"],
["&#x4a4;","&#x454;","82"],
["&#x4a4;","&#x453;","61"],
["&#x4a4;","&#x452;","-41"],
["&#x4a4;","&#x451;","82"],
["&#x4a4;","&#x44e;","61"],
["&#x4a4;","&#x44d;","41"],
["&#x4a4;","&#x44c;","61"],
["&#x4a4;","&#x44b;","61"],
["&#x4a4;","&#x449;","61"],
["&#x4a4;","&#x448;","61"],
["&#x4a4;","&#x447;","102"],
["&#x4a4;","&#x446;","61"],
["&#x4a4;","&#x445;","41"],
["&#x4a4;","&#x444;","82"],
["&#x4a4;","&#x441;","82"],
["&#x4a4;","&#x440;","61"],
["&#x4a4;","&#x43f;","61"],
["&#x4a4;","&#x43e;","82"],
["&#x4a4;","&#x43d;","61"],
["&#x4a4;","&#x43c;","61"],
["&#x4a4;","&#x43b;","102"],
["&#x4a4;","&#x43a;","61"],
["&#x4a4;","&#x439;","61"],
["&#x4a4;","&#x438;","61"],
["&#x4a4;","&#x437;","41"],
["&#x4a4;","&#x436;","41"],
["&#x4a4;","&#x435;","82"],
["&#x4a4;","&#x434;","102"],
["&#x4a4;","&#x433;","61"],
["&#x4a4;","&#x432;","61"],
["&#x4a4;","&#x42a;","-41"],
["&#x4a4;","&#x424;","61"],
["&#x4a4;","&#x422;","-41"],
["&#x4a4;","&#x421;","41"],
["&#x4a4;","&#x41e;","41"],
["&#x4a4;","&#x41b;","82"],
["&#x4a4;","&#x414;","82"],
["&#x4a4;","&#x410;","123"],
["&#x4a4;","&#x40b;","-41"],
["&#x4a4;","&#x409;","82"],
["&#x4a4;","&#x404;","41"],
["&#x4a4;","&#x402;","-41"],
["&#x4a4;","&#x2e;","102"],
["&#x4a4;","&#x2d;","41"],
["&#x4a4;","&#x2c;","102"],
["&#x4a5;","&#x513;","61"],
["&#x4a5;","&#x511;","20"],
["&#x4a5;","&#x50d;","20"],
["&#x4a5;","&#x509;","61"],
["&#x4a5;","&#x503;","20"],
["&#x4a5;","&#x501;","20"],
["&#x4a5;","&#x4eb;","20"],
["&#x4a5;","&#x4e9;","20"],
["&#x4a5;","&#x4e7;","20"],
["&#x4a5;","&#x4d7;","20"],
["&#x4a5;","&#x4c6;","61"],
["&#x4a5;","&#x4ab;","20"],
["&#x4a5;","&#x4a9;","20"],
["&#x4a5;","&#x481;","20"],
["&#x4a5;","&#x47d;","20"],
["&#x4a5;","&#x47b;","20"],
["&#x4a5;","&#x479;","20"],
["&#x4a5;","&#x473;","20"],
["&#x4a5;","&#x467;","61"],
["&#x4a5;","&#x450;","20"],
["&#x4a5;","&#x201e;","102"],
["&#x4a5;","&#x201a;","102"],
["&#x4a5;","&#x2015;","41"],
["&#x4a5;","&#x2014;","41"],
["&#x4a5;","&#x2013;","41"],
["&#x4a5;","&#x459;","61"],
["&#x4a5;","&#x454;","20"],
["&#x4a5;","&#x451;","20"],
["&#x4a5;","&#x444;","20"],
["&#x4a5;","&#x441;","20"],
["&#x4a5;","&#x43e;","20"],
["&#x4a5;","&#x43b;","61"],
["&#x4a5;","&#x435;","20"],
["&#x4a5;","&#x434;","61"],
["&#x4a5;","&#x2e;","102"],
["&#x4a5;","&#x2d;","41"],
["&#x4a5;","&#x2c;","102"],
["&#x4a6;","&#x50f;","82"],
["&#x4a6;","&#x50e;","102"],
["&#x4a6;","&#x507;","82"],
["&#x4a6;","&#x506;","184"],
["&#x4a6;","&#x505;","82"],
["&#x4a6;","&#x504;","184"],
["&#x4a6;","&#x4f5;","41"],
["&#x4a6;","&#x4f4;","123"],
["&#x4a6;","&#x4cc;","41"],
["&#x4a6;","&#x4cb;","123"],
["&#x4a6;","&#x4bf;","41"],
["&#x4a6;","&#x4be;","61"],
["&#x4a6;","&#x4bd;","41"],
["&#x4a6;","&#x4bc;","61"],
["&#x4a6;","&#x4b9;","41"],
["&#x4a6;","&#x4b8;","123"],
["&#x4a6;","&#x4b7;","41"],
["&#x4a6;","&#x4b6;","123"],
["&#x4a6;","&#x4b5;","82"],
["&#x4a6;","&#x4b4;","102"],
["&#x4a6;","&#x4b0;","102"],
["&#x4a6;","&#x4ae;","102"],
["&#x4a6;","&#x4ad;","82"],
["&#x4a6;","&#x4ac;","184"],
["&#x4a6;","&#x4a1;","82"],
["&#x4a6;","&#x4a0;","102"],
["&#x4a6;","&#x476;","143"],
["&#x4a6;","&#x474;","143"],
["&#x4a6;","&#x470;","123"],
["&#x4a6;","&#x201d;","164"],
["&#x4a6;","&#x2019;","164"],
["&#x4a6;","&#x44a;","82"],
["&#x4a6;","&#x447;","41"],
["&#x4a6;","&#x442;","82"],
["&#x4a6;","&#x42a;","102"],
["&#x4a6;","&#x427;","123"],
["&#x4a6;","&#x422;","184"],
["&#x4a6;","&#x40b;","102"],
["&#x4a6;","&#x408;","-102"],
["&#x4a6;","&#x402;","102"],
["&#x4a6;","&#x27;","164"],
["&#x4a6;","&#x22;","164"],
["&#x4a7;","&#x50f;","102"],
["&#x4a7;","&#x507;","143"],
["&#x4a7;","&#x505;","143"],
["&#x4a7;","&#x4f5;","41"],
["&#x4a7;","&#x4cc;","41"],
["&#x4a7;","&#x4bf;","41"],
["&#x4a7;","&#x4bd;","41"],
["&#x4a7;","&#x4b9;","41"],
["&#x4a7;","&#x4b7;","41"],
["&#x4a7;","&#x4b5;","102"],
["&#x4a7;","&#x4b1;","41"],
["&#x4a7;","&#x4af;","41"],
["&#x4a7;","&#x4ad;","102"],
["&#x4a7;","&#x4a1;","102"],
["&#x4a7;","&#x47f;","41"],
["&#x4a7;","&#x477;","41"],
["&#x4a7;","&#x475;","41"],
["&#x4a7;","&#x461;","41"],
["&#x4a7;","&#x201d;","143"],
["&#x4a7;","&#x2019;","143"],
["&#x4a7;","&#x44a;","102"],
["&#x4a7;","&#x447;","41"],
["&#x4a7;","&#x442;","102"],
["&#x4a7;","&#x27;","143"],
["&#x4a7;","&#x22;","143"],
["&#x4a8;","&#x50e;","41"],
["&#x4a8;","&#x506;","41"],
["&#x4a8;","&#x504;","41"],
["&#x4a8;","&#x4b4;","41"],
["&#x4a8;","&#x4b0;","20"],
["&#x4a8;","&#x4ae;","20"],
["&#x4a8;","&#x4ac;","61"],
["&#x4a8;","&#x4a0;","41"],
["&#x4a8;","&#x476;","20"],
["&#x4a8;","&#x474;","20"],
["&#x4a8;","&#x42a;","41"],
["&#x4a8;","&#x422;","61"],
["&#x4a8;","&#x40b;","41"],
["&#x4a8;","&#x402;","41"],
["&#x4a9;","&#x50f;","20"],
["&#x4a9;","&#x507;","20"],
["&#x4a9;","&#x505;","20"],
["&#x4a9;","&#x4ff;","41"],
["&#x4a9;","&#x4fd;","41"],
["&#x4a9;","&#x4f5;","20"],
["&#x4a9;","&#x4f3;","20"],
["&#x4a9;","&#x4f1;","20"],
["&#x4a9;","&#x4ef;","20"],
["&#x4a9;","&#x4dd;","41"],
["&#x4a9;","&#x4cc;","20"],
["&#x4a9;","&#x4c2;","41"],
["&#x4a9;","&#x4b9;","20"],
["&#x4a9;","&#x4b7;","20"],
["&#x4a9;","&#x4b5;","20"],
["&#x4a9;","&#x4b3;","41"],
["&#x4a9;","&#x4ad;","20"],
["&#x4a9;","&#x4a1;","20"],
["&#x4a9;","&#x497;","41"],
["&#x4a9;","&#x201d;","20"],
["&#x4a9;","&#x2019;","20"],
["&#x4a9;","&#x45e;","20"],
["&#x4a9;","&#x44a;","20"],
["&#x4a9;","&#x447;","20"],
["&#x4a9;","&#x445;","41"],
["&#x4a9;","&#x443;","20"],
["&#x4a9;","&#x442;","20"],
["&#x4a9;","&#x436;","41"],
["&#x4a9;","&#x27;","20"],
["&#x4a9;","&#x22;","20"],
["&#x4aa;","&#x50c;","41"],
["&#x4aa;","&#x507;","41"],
["&#x4aa;","&#x505;","41"],
["&#x4aa;","&#x502;","41"],
["&#x4aa;","&#x500;","41"],
["&#x4aa;","&#x4f5;","41"],
["&#x4aa;","&#x4ea;","41"],
["&#x4aa;","&#x4e8;","41"],
["&#x4aa;","&#x4e6;","41"],
["&#x4aa;","&#x4cc;","41"],
["&#x4aa;","&#x4be;","41"],
["&#x4aa;","&#x4bc;","41"],
["&#x4aa;","&#x4b9;","41"],
["&#x4aa;","&#x4b7;","41"],
["&#x4aa;","&#x4aa;","41"],
["&#x4aa;","&#x4a8;","41"],
["&#x4aa;","&#x480;","41"],
["&#x4aa;","&#x47e;","41"],
["&#x4aa;","&#x47c;","41"],
["&#x4aa;","&#x47a;","41"],
["&#x4aa;","&#x478;","41"],
["&#x4aa;","&#x472;","41"],
["&#x4aa;","&#x460;","41"],
["&#x4aa;","&#x447;","41"],
["&#x4aa;","&#x424;","41"],
["&#x4aa;","&#x421;","41"],
["&#x4aa;","&#x41e;","41"],
["&#x4aa;","&#x404;","41"],
["&#x4ac;","&#x513;","123"],
["&#x4ac;","&#x512;","102"],
["&#x4ac;","&#x511;","143"],
["&#x4ac;","&#x50f;","82"],
["&#x4ac;","&#x50d;","143"],
["&#x4ac;","&#x50c;","41"],
["&#x4ac;","&#x50b;","102"],
["&#x4ac;","&#x509;","123"],
["&#x4ac;","&#x508;","102"],
["&#x4ac;","&#x507;","102"],
["&#x4ac;","&#x505;","102"],
["&#x4ac;","&#x503;","143"],
["&#x4ac;","&#x502;","143"],
["&#x4ac;","&#x501;","143"],
["&#x4ac;","&#x500;","143"],
["&#x4ac;","&#x4ff;","41"],
["&#x4ac;","&#x4fd;","41"],
["&#x4ac;","&#x4f9;","102"],
["&#x4ac;","&#x4f7;","102"],
["&#x4ac;","&#x4f5;","102"],
["&#x4ac;","&#x4f3;","82"],
["&#x4ac;","&#x4f1;","82"],
["&#x4ac;","&#x4ef;","82"],
["&#x4ac;","&#x4ed;","41"],
["&#x4ac;","&#x4eb;","143"],
["&#x4ac;","&#x4ea;","41"],
["&#x4ac;","&#x4e9;","143"],
["&#x4ac;","&#x4e8;","41"],
["&#x4ac;","&#x4e7;","143"],
["&#x4ac;","&#x4e6;","41"],
["&#x4ac;","&#x4e5;","102"],
["&#x4ac;","&#x4e3;","102"],
["&#x4ac;","&#x4e1;","61"],
["&#x4ac;","&#x4df;","41"],
["&#x4ac;","&#x4dd;","41"],
["&#x4ac;","&#x4d7;","143"],
["&#x4ac;","&#x4d4;","143"],
["&#x4ac;","&#x4d2;","143"],
["&#x4ac;","&#x4d0;","143"],
["&#x4ac;","&#x4ce;","102"],
["&#x4ac;","&#x4cc;","102"],
["&#x4ac;","&#x4ca;","102"],
["&#x4ac;","&#x4c8;","102"],
["&#x4ac;","&#x4c6;","123"],
["&#x4ac;","&#x4c5;","102"],
["&#x4ac;","&#x4c4;","102"],
["&#x4ac;","&#x4c2;","41"],
["&#x4ac;","&#x4bf;","143"],
["&#x4ac;","&#x4be;","102"],
["&#x4ac;","&#x4bd;","143"],
["&#x4ac;","&#x4bc;","102"],
["&#x4ac;","&#x4bb;","102"],
["&#x4ac;","&#x4b9;","102"],
["&#x4ac;","&#x4b7;","102"],
["&#x4ac;","&#x4b5;","82"],
["&#x4ac;","&#x4b3;","41"],
["&#x4ac;","&#x4b1;","82"],
["&#x4ac;","&#x4af;","82"],
["&#x4ac;","&#x4ad;","82"],
["&#x4ac;","&#x4ac;","-41"],
["&#x4ac;","&#x4ab;","143"],
["&#x4ac;","&#x4aa;","41"],
["&#x4ac;","&#x4a9;","143"],
["&#x4ac;","&#x4a8;","41"],
["&#x4ac;","&#x4a7;","102"],
["&#x4ac;","&#x4a5;","102"],
["&#x4ac;","&#x4a3;","102"],
["&#x4ac;","&#x4a1;","82"],
["&#x4ac;","&#x49d;","102"],
["&#x4ac;","&#x49b;","102"],
["&#x4ac;","&#x499;","41"],
["&#x4ac;","&#x497;","41"],
["&#x4ac;","&#x495;","102"],
["&#x4ac;","&#x48f;","102"],
["&#x4ac;","&#x48b;","102"],
["&#x4ac;","&#x481;","143"],
["&#x4ac;","&#x480;","41"],
["&#x4ac;","&#x47f;","41"],
["&#x4ac;","&#x47e;","41"],
["&#x4ac;","&#x47d;","143"],
["&#x4ac;","&#x47c;","41"],
["&#x4ac;","&#x47b;","143"],
["&#x4ac;","&#x47a;","41"],
["&#x4ac;","&#x479;","143"],
["&#x4ac;","&#x478;","41"],
["&#x4ac;","&#x477;","41"],
["&#x4ac;","&#x475;","41"],
["&#x4ac;","&#x473;","143"],
["&#x4ac;","&#x472;","41"],
["&#x4ac;","&#x471;","102"],
["&#x4ac;","&#x46d;","102"],
["&#x4ac;","&#x46b;","102"],
["&#x4ac;","&#x469;","102"],
["&#x4ac;","&#x467;","123"],
["&#x4ac;","&#x466;","143"],
["&#x4ac;","&#x465;","102"],
["&#x4ac;","&#x461;","41"],
["&#x4ac;","&#x460;","41"],
["&#x4ac;","&#x45d;","102"],
["&#x4ac;","&#x450;","143"],
["&#x4ac;","&#x201e;","123"],
["&#x4ac;","&#x201a;","123"],
["&#x4ac;","&#x2015;","82"],
["&#x4ac;","&#x2014;","82"],
["&#x4ac;","&#x2013;","82"],
["&#x4ac;","&#x491;","102"],
["&#x4ac;","&#x45f;","102"],
["&#x4ac;","&#x45e;","82"],
["&#x4ac;","&#x45c;","102"],
["&#x4ac;","&#x45a;","102"],
["&#x4ac;","&#x459;","123"],
["&#x4ac;","&#x455;","123"],
["&#x4ac;","&#x454;","143"],
["&#x4ac;","&#x453;","102"],
["&#x4ac;","&#x451;","143"],
["&#x4ac;","&#x44f;","61"],
["&#x4ac;","&#x44e;","102"],
["&#x4ac;","&#x44d;","41"],
["&#x4ac;","&#x44c;","102"],
["&#x4ac;","&#x44b;","102"],
["&#x4ac;","&#x44a;","82"],
["&#x4ac;","&#x449;","102"],
["&#x4ac;","&#x448;","102"],
["&#x4ac;","&#x447;","102"],
["&#x4ac;","&#x446;","102"],
["&#x4ac;","&#x445;","41"],
["&#x4ac;","&#x444;","143"],
["&#x4ac;","&#x443;","82"],
["&#x4ac;","&#x442;","82"],
["&#x4ac;","&#x441;","143"],
["&#x4ac;","&#x440;","102"],
["&#x4ac;","&#x43f;","102"],
["&#x4ac;","&#x43e;","143"],
["&#x4ac;","&#x43d;","102"],
["&#x4ac;","&#x43c;","102"],
["&#x4ac;","&#x43b;","123"],
["&#x4ac;","&#x43a;","102"],
["&#x4ac;","&#x439;","102"],
["&#x4ac;","&#x438;","102"],
["&#x4ac;","&#x437;","41"],
["&#x4ac;","&#x436;","41"],
["&#x4ac;","&#x435;","143"],
["&#x4ac;","&#x434;","123"],
["&#x4ac;","&#x433;","102"],
["&#x4ac;","&#x432;","102"],
["&#x4ac;","&#x424;","82"],
["&#x4ac;","&#x422;","-41"],
["&#x4ac;","&#x421;","41"],
["&#x4ac;","&#x41e;","41"],
["&#x4ac;","&#x41b;","102"],
["&#x4ac;","&#x414;","102"],
["&#x4ac;","&#x410;","143"],
["&#x4ac;","&#x409;","102"],
["&#x4ac;","&#x404;","41"],
["&#x4ac;","&#x2e;","123"],
["&#x4ac;","&#x2d;","82"],
["&#x4ac;","&#x2c;","123"],
["&#x4ad;","&#x513;","61"],
["&#x4ad;","&#x511;","20"],
["&#x4ad;","&#x50d;","20"],
["&#x4ad;","&#x509;","61"],
["&#x4ad;","&#x503;","20"],
["&#x4ad;","&#x501;","20"],
["&#x4ad;","&#x4eb;","20"],
["&#x4ad;","&#x4e9;","20"],
["&#x4ad;","&#x4e7;","20"],
["&#x4ad;","&#x4d7;","20"],
["&#x4ad;","&#x4c6;","61"],
["&#x4ad;","&#x4ab;","20"],
["&#x4ad;","&#x4a9;","20"],
["&#x4ad;","&#x481;","20"],
["&#x4ad;","&#x47d;","20"],
["&#x4ad;","&#x47b;","20"],
["&#x4ad;","&#x479;","20"],
["&#x4ad;","&#x473;","20"],
["&#x4ad;","&#x467;","61"],
["&#x4ad;","&#x450;","20"],
["&#x4ad;","&#x201e;","102"],
["&#x4ad;","&#x201a;","102"],
["&#x4ad;","&#x2015;","41"],
["&#x4ad;","&#x2014;","41"],
["&#x4ad;","&#x2013;","41"],
["&#x4ad;","&#x459;","61"],
["&#x4ad;","&#x454;","20"],
["&#x4ad;","&#x451;","20"],
["&#x4ad;","&#x444;","20"],
["&#x4ad;","&#x441;","20"],
["&#x4ad;","&#x43e;","20"],
["&#x4ad;","&#x43b;","61"],
["&#x4ad;","&#x435;","20"],
["&#x4ad;","&#x434;","61"],
["&#x4ad;","&#x2e;","102"],
["&#x4ad;","&#x2d;","41"],
["&#x4ad;","&#x2c;","102"],
["&#x4ae;","&#x513;","102"],
["&#x4ae;","&#x512;","82"],
["&#x4ae;","&#x511;","102"],
["&#x4ae;","&#x510;","20"],
["&#x4ae;","&#x50d;","102"],
["&#x4ae;","&#x50c;","41"],
["&#x4ae;","&#x50b;","61"],
["&#x4ae;","&#x509;","102"],
["&#x4ae;","&#x508;","82"],
["&#x4ae;","&#x507;","41"],
["&#x4ae;","&#x505;","41"],
["&#x4ae;","&#x503;","102"],
["&#x4ae;","&#x502;","82"],
["&#x4ae;","&#x501;","102"],
["&#x4ae;","&#x500;","82"],
["&#x4ae;","&#x4f9;","61"],
["&#x4ae;","&#x4f7;","61"],
["&#x4ae;","&#x4f5;","82"],
["&#x4ae;","&#x4eb;","102"],
["&#x4ae;","&#x4ea;","41"],
["&#x4ae;","&#x4e9;","102"],
["&#x4ae;","&#x4e8;","41"],
["&#x4ae;","&#x4e7;","102"],
["&#x4ae;","&#x4e6;","41"],
["&#x4ae;","&#x4e5;","61"],
["&#x4ae;","&#x4e3;","61"],
["&#x4ae;","&#x4db;","82"],
["&#x4ae;","&#x4da;","20"],
["&#x4ae;","&#x4d9;","82"],
["&#x4ae;","&#x4d8;","20"],
["&#x4ae;","&#x4d7;","102"],
["&#x4ae;","&#x4d5;","82"],
["&#x4ae;","&#x4d4;","123"],
["&#x4ae;","&#x4d3;","82"],
["&#x4ae;","&#x4d2;","123"],
["&#x4ae;","&#x4d1;","82"],
["&#x4ae;","&#x4d0;","123"],
["&#x4ae;","&#x4ce;","61"],
["&#x4ae;","&#x4cc;","82"],
["&#x4ae;","&#x4ca;","61"],
["&#x4ae;","&#x4c8;","61"],
["&#x4ae;","&#x4c6;","102"],
["&#x4ae;","&#x4c5;","82"],
["&#x4ae;","&#x4c4;","61"],
["&#x4ae;","&#x4bf;","82"],
["&#x4ae;","&#x4bd;","82"],
["&#x4ae;","&#x4bb;","61"],
["&#x4ae;","&#x4b9;","82"],
["&#x4ae;","&#x4b7;","82"],
["&#x4ae;","&#x4ab;","102"],
["&#x4ae;","&#x4aa;","41"],
["&#x4ae;","&#x4a9;","102"],
["&#x4ae;","&#x4a8;","41"],
["&#x4ae;","&#x4a7;","61"],
["&#x4ae;","&#x4a5;","61"],
["&#x4ae;","&#x4a3;","61"],
["&#x4ae;","&#x49f;","-41"],
["&#x4ae;","&#x49d;","61"],
["&#x4ae;","&#x49b;","61"],
["&#x4ae;","&#x495;","61"],
["&#x4ae;","&#x48f;","61"],
["&#x4ae;","&#x48d;","-41"],
["&#x4ae;","&#x48b;","61"],
["&#x4ae;","&#x481;","102"],
["&#x4ae;","&#x480;","41"],
["&#x4ae;","&#x47e;","41"],
["&#x4ae;","&#x47d;","102"],
["&#x4ae;","&#x47c;","41"],
["&#x4ae;","&#x47b;","102"],
["&#x4ae;","&#x47a;","41"],
["&#x4ae;","&#x479;","102"],
["&#x4ae;","&#x478;","41"],
["&#x4ae;","&#x473;","102"],
["&#x4ae;","&#x472;","41"],
["&#x4ae;","&#x471;","41"],
["&#x4ae;","&#x46d;","61"],
["&#x4ae;","&#x46b;","41"],
["&#x4ae;","&#x469;","61"],
["&#x4ae;","&#x467;","102"],
["&#x4ae;","&#x466;","123"],
["&#x4ae;","&#x465;","61"],
["&#x4ae;","&#x460;","41"],
["&#x4ae;","&#x45d;","61"],
["&#x4ae;","&#x450;","102"],
["&#x4ae;","&#x201e;","123"],
["&#x4ae;","&#x201a;","123"],
["&#x4ae;","&#x491;","61"],
["&#x4ae;","&#x45f;","61"],
["&#x4ae;","&#x45c;","61"],
["&#x4ae;","&#x45b;","-41"],
["&#x4ae;","&#x45a;","61"],
["&#x4ae;","&#x459;","102"],
["&#x4ae;","&#x455;","82"],
["&#x4ae;","&#x454;","102"],
["&#x4ae;","&#x453;","61"],
["&#x4ae;","&#x452;","-41"],
["&#x4ae;","&#x451;","102"],
["&#x4ae;","&#x44f;","41"],
["&#x4ae;","&#x44e;","61"],
["&#x4ae;","&#x44c;","61"],
["&#x4ae;","&#x44b;","61"],
["&#x4ae;","&#x449;","61"],
["&#x4ae;","&#x448;","61"],
["&#x4ae;","&#x447;","82"],
["&#x4ae;","&#x446;","61"],
["&#x4ae;","&#x444;","102"],
["&#x4ae;","&#x441;","102"],
["&#x4ae;","&#x440;","61"],
["&#x4ae;","&#x43f;","61"],
["&#x4ae;","&#x43e;","102"],
["&#x4ae;","&#x43d;","61"],
["&#x4ae;","&#x43c;","61"],
["&#x4ae;","&#x43b;","102"],
["&#x4ae;","&#x43a;","61"],
["&#x4ae;","&#x439;","61"],
["&#x4ae;","&#x438;","61"],
["&#x4ae;","&#x435;","102"],
["&#x4ae;","&#x434;","102"],
["&#x4ae;","&#x433;","61"],
["&#x4ae;","&#x432;","61"],
["&#x4ae;","&#x430;","82"],
["&#x4ae;","&#x424;","61"],
["&#x4ae;","&#x421;","41"],
["&#x4ae;","&#x41e;","41"],
["&#x4ae;","&#x41b;","82"],
["&#x4ae;","&#x414;","82"],
["&#x4ae;","&#x410;","123"],
["&#x4ae;","&#x409;","82"],
["&#x4ae;","&#x404;","41"],
["&#x4ae;","&#x2e;","123"],
["&#x4ae;","&#x2c;","123"],
["&#x4af;","&#x513;","20"],
["&#x4af;","&#x509;","20"],
["&#x4af;","&#x4c6;","20"],
["&#x4af;","&#x467;","20"],
["&#x4af;","&#x201e;","82"],
["&#x4af;","&#x201a;","82"],
["&#x4af;","&#x459;","20"],
["&#x4af;","&#x43b;","20"],
["&#x4af;","&#x434;","20"],
["&#x4af;","&#x2e;","82"],
["&#x4af;","&#x2c;","82"],
["&#x4b0;","&#x513;","102"],
["&#x4b0;","&#x512;","82"],
["&#x4b0;","&#x511;","102"],
["&#x4b0;","&#x510;","20"],
["&#x4b0;","&#x50d;","102"],
["&#x4b0;","&#x50c;","41"],
["&#x4b0;","&#x50b;","61"],
["&#x4b0;","&#x509;","102"],
["&#x4b0;","&#x508;","82"],
["&#x4b0;","&#x507;","41"],
["&#x4b0;","&#x505;","41"],
["&#x4b0;","&#x503;","102"],
["&#x4b0;","&#x502;","82"],
["&#x4b0;","&#x501;","102"],
["&#x4b0;","&#x500;","82"],
["&#x4b0;","&#x4f9;","61"],
["&#x4b0;","&#x4f7;","61"],
["&#x4b0;","&#x4f5;","82"],
["&#x4b0;","&#x4eb;","102"],
["&#x4b0;","&#x4ea;","41"],
["&#x4b0;","&#x4e9;","102"],
["&#x4b0;","&#x4e8;","41"],
["&#x4b0;","&#x4e7;","102"],
["&#x4b0;","&#x4e6;","41"],
["&#x4b0;","&#x4e5;","61"],
["&#x4b0;","&#x4e3;","61"],
["&#x4b0;","&#x4db;","82"],
["&#x4b0;","&#x4da;","20"],
["&#x4b0;","&#x4d9;","82"],
["&#x4b0;","&#x4d8;","20"],
["&#x4b0;","&#x4d7;","102"],
["&#x4b0;","&#x4d5;","82"],
["&#x4b0;","&#x4d4;","123"],
["&#x4b0;","&#x4d3;","82"],
["&#x4b0;","&#x4d2;","123"],
["&#x4b0;","&#x4d1;","82"],
["&#x4b0;","&#x4d0;","123"],
["&#x4b0;","&#x4ce;","61"],
["&#x4b0;","&#x4cc;","82"],
["&#x4b0;","&#x4ca;","61"],
["&#x4b0;","&#x4c8;","61"],
["&#x4b0;","&#x4c6;","102"],
["&#x4b0;","&#x4c5;","82"],
["&#x4b0;","&#x4c4;","61"],
["&#x4b0;","&#x4bf;","82"],
["&#x4b0;","&#x4bd;","82"],
["&#x4b0;","&#x4bb;","61"],
["&#x4b0;","&#x4b9;","82"],
["&#x4b0;","&#x4b7;","82"],
["&#x4b0;","&#x4ab;","102"],
["&#x4b0;","&#x4aa;","41"],
["&#x4b0;","&#x4a9;","102"],
["&#x4b0;","&#x4a8;","41"],
["&#x4b0;","&#x4a7;","61"],
["&#x4b0;","&#x4a5;","61"],
["&#x4b0;","&#x4a3;","61"],
["&#x4b0;","&#x49f;","-41"],
["&#x4b0;","&#x49d;","61"],
["&#x4b0;","&#x49b;","61"],
["&#x4b0;","&#x495;","61"],
["&#x4b0;","&#x48f;","61"],
["&#x4b0;","&#x48d;","-41"],
["&#x4b0;","&#x48b;","61"],
["&#x4b0;","&#x481;","102"],
["&#x4b0;","&#x480;","41"],
["&#x4b0;","&#x47e;","41"],
["&#x4b0;","&#x47d;","102"],
["&#x4b0;","&#x47c;","41"],
["&#x4b0;","&#x47b;","102"],
["&#x4b0;","&#x47a;","41"],
["&#x4b0;","&#x479;","102"],
["&#x4b0;","&#x478;","41"],
["&#x4b0;","&#x473;","102"],
["&#x4b0;","&#x472;","41"],
["&#x4b0;","&#x471;","41"],
["&#x4b0;","&#x46d;","61"],
["&#x4b0;","&#x46b;","41"],
["&#x4b0;","&#x469;","61"],
["&#x4b0;","&#x467;","102"],
["&#x4b0;","&#x466;","123"],
["&#x4b0;","&#x465;","61"],
["&#x4b0;","&#x460;","41"],
["&#x4b0;","&#x45d;","61"],
["&#x4b0;","&#x450;","102"],
["&#x4b0;","&#x201e;","123"],
["&#x4b0;","&#x201a;","123"],
["&#x4b0;","&#x491;","61"],
["&#x4b0;","&#x45f;","61"],
["&#x4b0;","&#x45c;","61"],
["&#x4b0;","&#x45b;","-41"],
["&#x4b0;","&#x45a;","61"],
["&#x4b0;","&#x459;","102"],
["&#x4b0;","&#x455;","82"],
["&#x4b0;","&#x454;","102"],
["&#x4b0;","&#x453;","61"],
["&#x4b0;","&#x452;","-41"],
["&#x4b0;","&#x451;","102"],
["&#x4b0;","&#x44f;","41"],
["&#x4b0;","&#x44e;","61"],
["&#x4b0;","&#x44c;","61"],
["&#x4b0;","&#x44b;","61"],
["&#x4b0;","&#x449;","61"],
["&#x4b0;","&#x448;","61"],
["&#x4b0;","&#x447;","82"],
["&#x4b0;","&#x446;","61"],
["&#x4b0;","&#x444;","102"],
["&#x4b0;","&#x441;","102"],
["&#x4b0;","&#x440;","61"],
["&#x4b0;","&#x43f;","61"],
["&#x4b0;","&#x43e;","102"],
["&#x4b0;","&#x43d;","61"],
["&#x4b0;","&#x43c;","61"],
["&#x4b0;","&#x43b;","102"],
["&#x4b0;","&#x43a;","61"],
["&#x4b0;","&#x439;","61"],
["&#x4b0;","&#x438;","61"],
["&#x4b0;","&#x435;","102"],
["&#x4b0;","&#x434;","102"],
["&#x4b0;","&#x433;","61"],
["&#x4b0;","&#x432;","61"],
["&#x4b0;","&#x430;","82"],
["&#x4b0;","&#x424;","61"],
["&#x4b0;","&#x421;","41"],
["&#x4b0;","&#x41e;","41"],
["&#x4b0;","&#x41b;","82"],
["&#x4b0;","&#x414;","82"],
["&#x4b0;","&#x410;","123"],
["&#x4b0;","&#x409;","82"],
["&#x4b0;","&#x404;","41"],
["&#x4b0;","&#x2e;","123"],
["&#x4b0;","&#x2c;","123"],
["&#x4b1;","&#x513;","20"],
["&#x4b1;","&#x509;","20"],
["&#x4b1;","&#x4c6;","20"],
["&#x4b1;","&#x467;","20"],
["&#x4b1;","&#x201e;","82"],
["&#x4b1;","&#x201a;","82"],
["&#x4b1;","&#x459;","20"],
["&#x4b1;","&#x43b;","20"],
["&#x4b1;","&#x434;","20"],
["&#x4b1;","&#x2e;","82"],
["&#x4b1;","&#x2c;","82"],
["&#x4b2;","&#x50f;","41"],
["&#x4b2;","&#x50c;","41"],
["&#x4b2;","&#x507;","41"],
["&#x4b2;","&#x505;","41"],
["&#x4b2;","&#x4f5;","82"],
["&#x4b2;","&#x4ea;","41"],
["&#x4b2;","&#x4e8;","41"],
["&#x4b2;","&#x4e6;","41"],
["&#x4b2;","&#x4cc;","82"],
["&#x4b2;","&#x4bf;","41"],
["&#x4b2;","&#x4be;","61"],
["&#x4b2;","&#x4bd;","41"],
["&#x4b2;","&#x4bc;","61"],
["&#x4b2;","&#x4b9;","82"],
["&#x4b2;","&#x4b7;","82"],
["&#x4b2;","&#x4b5;","41"],
["&#x4b2;","&#x4ad;","41"],
["&#x4b2;","&#x4aa;","41"],
["&#x4b2;","&#x4a8;","41"],
["&#x4b2;","&#x4a1;","41"],
["&#x4b2;","&#x480;","41"],
["&#x4b2;","&#x47e;","41"],
["&#x4b2;","&#x47c;","41"],
["&#x4b2;","&#x47a;","41"],
["&#x4b2;","&#x478;","41"],
["&#x4b2;","&#x472;","41"],
["&#x4b2;","&#x471;","20"],
["&#x4b2;","&#x46f;","-61"],
["&#x4b2;","&#x460;","41"],
["&#x4b2;","&#x44a;","41"],
["&#x4b2;","&#x447;","82"],
["&#x4b2;","&#x442;","41"],
["&#x4b2;","&#x424;","61"],
["&#x4b2;","&#x421;","41"],
["&#x4b2;","&#x41e;","41"],
["&#x4b2;","&#x408;","-225"],
["&#x4b2;","&#x404;","41"],
["&#x4b3;","&#x511;","20"],
["&#x4b3;","&#x50d;","20"],
["&#x4b3;","&#x507;","41"],
["&#x4b3;","&#x505;","41"],
["&#x4b3;","&#x503;","20"],
["&#x4b3;","&#x501;","20"],
["&#x4b3;","&#x4f5;","20"],
["&#x4b3;","&#x4eb;","20"],
["&#x4b3;","&#x4e9;","20"],
["&#x4b3;","&#x4e7;","20"],
["&#x4b3;","&#x4d7;","20"],
["&#x4b3;","&#x4cc;","20"],
["&#x4b3;","&#x4b9;","20"],
["&#x4b3;","&#x4b7;","20"],
["&#x4b3;","&#x4ab;","20"],
["&#x4b3;","&#x4a9;","20"],
["&#x4b3;","&#x481;","20"],
["&#x4b3;","&#x47d;","20"],
["&#x4b3;","&#x47b;","20"],
["&#x4b3;","&#x479;","20"],
["&#x4b3;","&#x473;","20"],
["&#x4b3;","&#x450;","20"],
["&#x4b3;","&#x454;","20"],
["&#x4b3;","&#x451;","20"],
["&#x4b3;","&#x447;","20"],
["&#x4b3;","&#x444;","20"],
["&#x4b3;","&#x441;","20"],
["&#x4b3;","&#x43e;","20"],
["&#x4b3;","&#x435;","20"],
["&#x4b4;","&#x507;","41"],
["&#x4b4;","&#x505;","41"],
["&#x4b4;","&#x4e1;","-41"],
["&#x4b4;","&#x408;","-225"],
["&#x4b5;","&#x201d;","20"],
["&#x4b5;","&#x2019;","20"],
["&#x4b5;","&#x27;","20"],
["&#x4b5;","&#x22;","20"],
["&#x4b6;","&#x507;","41"],
["&#x4b6;","&#x505;","41"],
["&#x4b6;","&#x4e1;","-41"],
["&#x4b6;","&#x408;","-225"],
["&#x4b7;","&#x201d;","20"],
["&#x4b7;","&#x2019;","20"],
["&#x4b7;","&#x27;","20"],
["&#x4b7;","&#x22;","20"],
["&#x4ba;","&#x50f;","41"],
["&#x4ba;","&#x50e;","41"],
["&#x4ba;","&#x507;","41"],
["&#x4ba;","&#x506;","82"],
["&#x4ba;","&#x505;","41"],
["&#x4ba;","&#x504;","82"],
["&#x4ba;","&#x4f5;","20"],
["&#x4ba;","&#x4f4;","82"],
["&#x4ba;","&#x4f3;","20"],
["&#x4ba;","&#x4f1;","20"],
["&#x4ba;","&#x4ef;","20"],
["&#x4ba;","&#x4cc;","20"],
["&#x4ba;","&#x4cb;","82"],
["&#x4ba;","&#x4b9;","20"],
["&#x4ba;","&#x4b8;","82"],
["&#x4ba;","&#x4b7;","20"],
["&#x4ba;","&#x4b6;","82"],
["&#x4ba;","&#x4b5;","41"],
["&#x4ba;","&#x4b4;","41"],
["&#x4ba;","&#x4b0;","102"],
["&#x4ba;","&#x4ae;","102"],
["&#x4ba;","&#x4ad;","41"],
["&#x4ba;","&#x4ac;","123"],
["&#x4ba;","&#x4a1;","41"],
["&#x4ba;","&#x4a0;","41"],
["&#x4ba;","&#x476;","61"],
["&#x4ba;","&#x474;","61"],
["&#x4ba;","&#x470;","82"],
["&#x4ba;","&#x201d;","61"],
["&#x4ba;","&#x2019;","61"],
["&#x4ba;","&#x45e;","20"],
["&#x4ba;","&#x44a;","41"],
["&#x4ba;","&#x447;","20"],
["&#x4ba;","&#x443;","20"],
["&#x4ba;","&#x442;","41"],
["&#x4ba;","&#x42a;","41"],
["&#x4ba;","&#x427;","82"],
["&#x4ba;","&#x422;","123"],
["&#x4ba;","&#x40b;","41"],
["&#x4ba;","&#x402;","41"],
["&#x4ba;","&#x27;","61"],
["&#x4ba;","&#x22;","61"],
["&#x4bb;","&#x50f;","41"],
["&#x4bb;","&#x507;","82"],
["&#x4bb;","&#x505;","82"],
["&#x4bb;","&#x4f3;","41"],
["&#x4bb;","&#x4f1;","41"],
["&#x4bb;","&#x4ef;","41"],
["&#x4bb;","&#x4b5;","41"],
["&#x4bb;","&#x4b1;","41"],
["&#x4bb;","&#x4af;","41"],
["&#x4bb;","&#x4ad;","41"],
["&#x4bb;","&#x4a1;","41"],
["&#x4bb;","&#x201d;","102"],
["&#x4bb;","&#x2019;","102"],
["&#x4bb;","&#x45e;","41"],
["&#x4bb;","&#x44a;","41"],
["&#x4bb;","&#x443;","41"],
["&#x4bb;","&#x442;","41"],
["&#x4bb;","&#x27;","102"],
["&#x4bb;","&#x22;","102"],
["&#x4bc;","&#x506;","20"],
["&#x4bc;","&#x504;","20"],
["&#x4bc;","&#x4b0;","20"],
["&#x4bc;","&#x4ae;","20"],
["&#x4bc;","&#x4ac;","41"],
["&#x4bc;","&#x476;","20"],
["&#x4bc;","&#x474;","20"],
["&#x4bc;","&#x422;","41"],
["&#x4bd;","&#x201d;","20"],
["&#x4bd;","&#x2019;","20"],
["&#x4bd;","&#x27;","20"],
["&#x4bd;","&#x22;","20"],
["&#x4be;","&#x506;","20"],
["&#x4be;","&#x504;","20"],
["&#x4be;","&#x4b0;","20"],
["&#x4be;","&#x4ae;","20"],
["&#x4be;","&#x4ac;","41"],
["&#x4be;","&#x476;","20"],
["&#x4be;","&#x474;","20"],
["&#x4be;","&#x422;","41"],
["&#x4bf;","&#x201d;","20"],
["&#x4bf;","&#x2019;","20"],
["&#x4bf;","&#x27;","20"],
["&#x4bf;","&#x22;","20"],
["&#x4c1;","&#x510;","20"],
["&#x4c1;","&#x50c;","41"],
["&#x4c1;","&#x507;","41"],
["&#x4c1;","&#x505;","41"],
["&#x4c1;","&#x502;","41"],
["&#x4c1;","&#x500;","41"],
["&#x4c1;","&#x4f5;","41"],
["&#x4c1;","&#x4f4;","41"],
["&#x4c1;","&#x4ea;","41"],
["&#x4c1;","&#x4e8;","41"],
["&#x4c1;","&#x4e6;","41"],
["&#x4c1;","&#x4cc;","41"],
["&#x4c1;","&#x4cb;","41"],
["&#x4c1;","&#x4be;","102"],
["&#x4c1;","&#x4bc;","102"],
["&#x4c1;","&#x4b9;","41"],
["&#x4c1;","&#x4b8;","41"],
["&#x4c1;","&#x4b7;","41"],
["&#x4c1;","&#x4b6;","41"],
["&#x4c1;","&#x4aa;","41"],
["&#x4c1;","&#x4a8;","41"],
["&#x4c1;","&#x480;","41"],
["&#x4c1;","&#x47e;","41"],
["&#x4c1;","&#x47c;","41"],
["&#x4c1;","&#x47a;","41"],
["&#x4c1;","&#x478;","41"],
["&#x4c1;","&#x472;","41"],
["&#x4c1;","&#x470;","41"],
["&#x4c1;","&#x460;","41"],
["&#x4c1;","&#x447;","41"],
["&#x4c1;","&#x427;","41"],
["&#x4c1;","&#x424;","41"],
["&#x4c1;","&#x421;","41"],
["&#x4c1;","&#x41e;","41"],
["&#x4c1;","&#x404;","41"],
["&#x4c2;","&#x511;","41"],
["&#x4c2;","&#x50d;","41"],
["&#x4c2;","&#x503;","41"],
["&#x4c2;","&#x501;","41"],
["&#x4c2;","&#x4f5;","41"],
["&#x4c2;","&#x4eb;","41"],
["&#x4c2;","&#x4e9;","41"],
["&#x4c2;","&#x4e7;","41"],
["&#x4c2;","&#x4d7;","41"],
["&#x4c2;","&#x4cc;","41"],
["&#x4c2;","&#x4bf;","41"],
["&#x4c2;","&#x4bd;","41"],
["&#x4c2;","&#x4b9;","41"],
["&#x4c2;","&#x4b7;","41"],
["&#x4c2;","&#x4ab;","41"],
["&#x4c2;","&#x4a9;","41"],
["&#x4c2;","&#x481;","41"],
["&#x4c2;","&#x47d;","41"],
["&#x4c2;","&#x47b;","41"],
["&#x4c2;","&#x479;","41"],
["&#x4c2;","&#x473;","41"],
["&#x4c2;","&#x450;","41"],
["&#x4c2;","&#x454;","41"],
["&#x4c2;","&#x451;","41"],
["&#x4c2;","&#x447;","41"],
["&#x4c2;","&#x444;","41"],
["&#x4c2;","&#x441;","41"],
["&#x4c2;","&#x43e;","41"],
["&#x4c2;","&#x435;","41"],
["&#x4c3;","&#x50f;","61"],
["&#x4c3;","&#x507;","61"],
["&#x4c3;","&#x506;","41"],
["&#x4c3;","&#x505;","61"],
["&#x4c3;","&#x504;","41"],
["&#x4c3;","&#x4f5;","41"],
["&#x4c3;","&#x4f4;","82"],
["&#x4c3;","&#x4cc;","41"],
["&#x4c3;","&#x4cb;","82"],
["&#x4c3;","&#x4bf;","41"],
["&#x4c3;","&#x4be;","61"],
["&#x4c3;","&#x4bd;","41"],
["&#x4c3;","&#x4bc;","61"],
["&#x4c3;","&#x4b9;","41"],
["&#x4c3;","&#x4b8;","82"],
["&#x4c3;","&#x4b7;","41"],
["&#x4c3;","&#x4b6;","82"],
["&#x4c3;","&#x4b5;","61"],
["&#x4c3;","&#x4b1;","20"],
["&#x4c3;","&#x4b0;","41"],
["&#x4c3;","&#x4af;","20"],
["&#x4c3;","&#x4ae;","41"],
["&#x4c3;","&#x4ad;","61"],
["&#x4c3;","&#x4ac;","41"],
["&#x4c3;","&#x4a1;","61"],
["&#x4c3;","&#x47f;","20"],
["&#x4c3;","&#x477;","20"],
["&#x4c3;","&#x476;","41"],
["&#x4c3;","&#x475;","20"],
["&#x4c3;","&#x474;","41"],
["&#x4c3;","&#x470;","82"],
["&#x4c3;","&#x461;","20"],
["&#x4c3;","&#x201d;","61"],
["&#x4c3;","&#x2019;","61"],
["&#x4c3;","&#x44a;","61"],
["&#x4c3;","&#x447;","41"],
["&#x4c3;","&#x442;","61"],
["&#x4c3;","&#x427;","82"],
["&#x4c3;","&#x424;","41"],
["&#x4c3;","&#x422;","41"],
["&#x4c3;","&#x408;","-102"],
["&#x4c3;","&#x27;","61"],
["&#x4c3;","&#x22;","61"],
["&#x4c4;","&#x4f5;","41"],
["&#x4c4;","&#x4cc;","41"],
["&#x4c4;","&#x4b9;","41"],
["&#x4c4;","&#x4b7;","41"],
["&#x4c4;","&#x447;","41"],
["&#x4c5;","&#x507;","41"],
["&#x4c5;","&#x505;","41"],
["&#x4c5;","&#x4e1;","-41"],
["&#x4c5;","&#x408;","-225"],
["&#x4c6;","&#x201d;","20"],
["&#x4c6;","&#x2019;","20"],
["&#x4c6;","&#x27;","20"],
["&#x4c6;","&#x22;","20"],
["&#x4c9;","&#x507;","41"],
["&#x4c9;","&#x505;","41"],
["&#x4c9;","&#x4e1;","-41"],
["&#x4c9;","&#x408;","-225"],
["&#x4ca;","&#x201d;","20"],
["&#x4ca;","&#x2019;","20"],
["&#x4ca;","&#x27;","20"],
["&#x4ca;","&#x22;","20"],
["&#x4cd;","&#x507;","41"],
["&#x4cd;","&#x505;","41"],
["&#x4cd;","&#x4e1;","-41"],
["&#x4cd;","&#x408;","-225"],
["&#x4ce;","&#x201d;","20"],
["&#x4ce;","&#x2019;","20"],
["&#x4ce;","&#x27;","20"],
["&#x4ce;","&#x22;","20"],
["&#x4d0;","&#x50f;","41"],
["&#x4d0;","&#x50e;","102"],
["&#x4d0;","&#x507;","41"],
["&#x4d0;","&#x506;","143"],
["&#x4d0;","&#x505;","41"],
["&#x4d0;","&#x504;","143"],
["&#x4d0;","&#x4fa;","41"],
["&#x4d0;","&#x4f5;","41"],
["&#x4d0;","&#x4f4;","102"],
["&#x4d0;","&#x4da;","41"],
["&#x4d0;","&#x4d8;","41"],
["&#x4d0;","&#x4cc;","41"],
["&#x4d0;","&#x4cb;","102"],
["&#x4d0;","&#x4be;","102"],
["&#x4d0;","&#x4bc;","102"],
["&#x4d0;","&#x4b9;","41"],
["&#x4d0;","&#x4b8;","102"],
["&#x4d0;","&#x4b7;","41"],
["&#x4d0;","&#x4b6;","102"],
["&#x4d0;","&#x4b5;","41"],
["&#x4d0;","&#x4b4;","102"],
["&#x4d0;","&#x4b0;","123"],
["&#x4d0;","&#x4ae;","123"],
["&#x4d0;","&#x4ad;","41"],
["&#x4d0;","&#x4ac;","143"],
["&#x4d0;","&#x4a1;","41"],
["&#x4d0;","&#x4a0;","102"],
["&#x4d0;","&#x49e;","41"],
["&#x4d0;","&#x492;","41"],
["&#x4d0;","&#x48c;","41"],
["&#x4d0;","&#x476;","82"],
["&#x4d0;","&#x474;","82"],
["&#x4d0;","&#x470;","102"],
["&#x4d0;","&#x462;","41"],
["&#x4d0;","&#x201d;","143"],
["&#x4d0;","&#x2019;","143"],
["&#x4d0;","&#x44a;","41"],
["&#x4d0;","&#x447;","41"],
["&#x4d0;","&#x442;","41"],
["&#x4d0;","&#x42a;","102"],
["&#x4d0;","&#x427;","102"],
["&#x4d0;","&#x424;","41"],
["&#x4d0;","&#x422;","143"],
["&#x4d0;","&#x40b;","102"],
["&#x4d0;","&#x402;","102"],
["&#x4d0;","&#x27;","143"],
["&#x4d0;","&#x22;","143"],
["&#x4d1;","&#x201d;","20"],
["&#x4d1;","&#x2019;","20"],
["&#x4d1;","&#x27;","20"],
["&#x4d1;","&#x22;","20"],
["&#x4d2;","&#x50f;","41"],
["&#x4d2;","&#x50e;","102"],
["&#x4d2;","&#x507;","41"],
["&#x4d2;","&#x506;","143"],
["&#x4d2;","&#x505;","41"],
["&#x4d2;","&#x504;","143"],
["&#x4d2;","&#x4fa;","41"],
["&#x4d2;","&#x4f5;","41"],
["&#x4d2;","&#x4f4;","102"],
["&#x4d2;","&#x4da;","41"],
["&#x4d2;","&#x4d8;","41"],
["&#x4d2;","&#x4cc;","41"],
["&#x4d2;","&#x4cb;","102"],
["&#x4d2;","&#x4be;","102"],
["&#x4d2;","&#x4bc;","102"],
["&#x4d2;","&#x4b9;","41"],
["&#x4d2;","&#x4b8;","102"],
["&#x4d2;","&#x4b7;","41"],
["&#x4d2;","&#x4b6;","102"],
["&#x4d2;","&#x4b5;","41"],
["&#x4d2;","&#x4b4;","102"],
["&#x4d2;","&#x4b0;","123"],
["&#x4d2;","&#x4ae;","123"],
["&#x4d2;","&#x4ad;","41"],
["&#x4d2;","&#x4ac;","143"],
["&#x4d2;","&#x4a1;","41"],
["&#x4d2;","&#x4a0;","102"],
["&#x4d2;","&#x49e;","41"],
["&#x4d2;","&#x492;","41"],
["&#x4d2;","&#x48c;","41"],
["&#x4d2;","&#x476;","82"],
["&#x4d2;","&#x474;","82"],
["&#x4d2;","&#x470;","102"],
["&#x4d2;","&#x462;","41"],
["&#x4d2;","&#x201d;","143"],
["&#x4d2;","&#x2019;","143"],
["&#x4d2;","&#x44a;","41"],
["&#x4d2;","&#x447;","41"],
["&#x4d2;","&#x442;","41"],
["&#x4d2;","&#x42a;","102"],
["&#x4d2;","&#x427;","102"],
["&#x4d2;","&#x424;","41"],
["&#x4d2;","&#x422;","143"],
["&#x4d2;","&#x40b;","102"],
["&#x4d2;","&#x402;","102"],
["&#x4d2;","&#x27;","143"],
["&#x4d2;","&#x22;","143"],
["&#x4d3;","&#x201d;","20"],
["&#x4d3;","&#x2019;","20"],
["&#x4d3;","&#x27;","20"],
["&#x4d3;","&#x22;","20"],
["&#x4d5;","&#x201d;","20"],
["&#x4d5;","&#x2019;","20"],
["&#x4d5;","&#x27;","20"],
["&#x4d5;","&#x22;","20"],
["&#x4d7;","&#x201d;","20"],
["&#x4d7;","&#x2019;","20"],
["&#x4d7;","&#x27;","20"],
["&#x4d7;","&#x22;","20"],
["&#x4d8;","&#x513;","20"],
["&#x4d8;","&#x512;","41"],
["&#x4d8;","&#x50e;","20"],
["&#x4d8;","&#x509;","20"],
["&#x4d8;","&#x508;","41"],
["&#x4d8;","&#x506;","41"],
["&#x4d8;","&#x504;","41"],
["&#x4d8;","&#x4fe;","41"],
["&#x4d8;","&#x4fc;","41"],
["&#x4d8;","&#x4f4;","41"],
["&#x4d8;","&#x4f2;","41"],
["&#x4d8;","&#x4f0;","41"],
["&#x4d8;","&#x4ee;","41"],
["&#x4d8;","&#x4ec;","20"],
["&#x4d8;","&#x4de;","20"],
["&#x4d8;","&#x4dc;","41"],
["&#x4d8;","&#x4d4;","41"],
["&#x4d8;","&#x4d2;","41"],
["&#x4d8;","&#x4d0;","41"],
["&#x4d8;","&#x4cb;","41"],
["&#x4d8;","&#x4c6;","20"],
["&#x4d8;","&#x4c5;","41"],
["&#x4d8;","&#x4c1;","41"],
["&#x4d8;","&#x4b8;","41"],
["&#x4d8;","&#x4b6;","41"],
["&#x4d8;","&#x4b4;","20"],
["&#x4d8;","&#x4b2;","41"],
["&#x4d8;","&#x4b0;","20"],
["&#x4d8;","&#x4ae;","20"],
["&#x4d8;","&#x4ac;","61"],
["&#x4d8;","&#x4a0;","20"],
["&#x4d8;","&#x498;","20"],
["&#x4d8;","&#x496;","41"],
["&#x4d8;","&#x476;","20"],
["&#x4d8;","&#x474;","20"],
["&#x4d8;","&#x470;","41"],
["&#x4d8;","&#x46e;","20"],
["&#x4d8;","&#x467;","20"],
["&#x4d8;","&#x466;","41"],
["&#x4d8;","&#x201e;","82"],
["&#x4d8;","&#x201a;","82"],
["&#x4d8;","&#x459;","20"],
["&#x4d8;","&#x43b;","20"],
["&#x4d8;","&#x434;","20"],
["&#x4d8;","&#x42d;","20"],
["&#x4d8;","&#x42a;","20"],
["&#x4d8;","&#x427;","41"],
["&#x4d8;","&#x425;","41"],
["&#x4d8;","&#x423;","41"],
["&#x4d8;","&#x422;","61"],
["&#x4d8;","&#x41b;","41"],
["&#x4d8;","&#x417;","20"],
["&#x4d8;","&#x416;","41"],
["&#x4d8;","&#x414;","41"],
["&#x4d8;","&#x410;","41"],
["&#x4d8;","&#x40e;","41"],
["&#x4d8;","&#x40b;","20"],
["&#x4d8;","&#x409;","41"],
["&#x4d8;","&#x402;","20"],
["&#x4d8;","&#x2e;","82"],
["&#x4d8;","&#x2c;","82"],
["&#x4d9;","&#x50f;","20"],
["&#x4d9;","&#x507;","20"],
["&#x4d9;","&#x505;","20"],
["&#x4d9;","&#x4ff;","41"],
["&#x4d9;","&#x4fd;","41"],
["&#x4d9;","&#x4f5;","20"],
["&#x4d9;","&#x4f3;","20"],
["&#x4d9;","&#x4f1;","20"],
["&#x4d9;","&#x4ef;","20"],
["&#x4d9;","&#x4dd;","41"],
["&#x4d9;","&#x4cc;","20"],
["&#x4d9;","&#x4c2;","41"],
["&#x4d9;","&#x4b9;","20"],
["&#x4d9;","&#x4b7;","20"],
["&#x4d9;","&#x4b5;","20"],
["&#x4d9;","&#x4b3;","41"],
["&#x4d9;","&#x4ad;","20"],
["&#x4d9;","&#x4a1;","20"],
["&#x4d9;","&#x497;","41"],
["&#x4d9;","&#x201d;","20"],
["&#x4d9;","&#x2019;","20"],
["&#x4d9;","&#x45e;","20"],
["&#x4d9;","&#x44a;","20"],
["&#x4d9;","&#x447;","20"],
["&#x4d9;","&#x445;","41"],
["&#x4d9;","&#x443;","20"],
["&#x4d9;","&#x442;","20"],
["&#x4d9;","&#x436;","41"],
["&#x4d9;","&#x27;","20"],
["&#x4d9;","&#x22;","20"],
["&#x4da;","&#x513;","20"],
["&#x4da;","&#x512;","41"],
["&#x4da;","&#x50e;","20"],
["&#x4da;","&#x509;","20"],
["&#x4da;","&#x508;","41"],
["&#x4da;","&#x506;","41"],
["&#x4da;","&#x504;","41"],
["&#x4da;","&#x4fe;","41"],
["&#x4da;","&#x4fc;","41"],
["&#x4da;","&#x4f4;","41"],
["&#x4da;","&#x4f2;","41"],
["&#x4da;","&#x4f0;","41"],
["&#x4da;","&#x4ee;","41"],
["&#x4da;","&#x4ec;","20"],
["&#x4da;","&#x4de;","20"],
["&#x4da;","&#x4dc;","41"],
["&#x4da;","&#x4d4;","41"],
["&#x4da;","&#x4d2;","41"],
["&#x4da;","&#x4d0;","41"],
["&#x4da;","&#x4cb;","41"],
["&#x4da;","&#x4c6;","20"],
["&#x4da;","&#x4c5;","41"],
["&#x4da;","&#x4c1;","41"],
["&#x4da;","&#x4b8;","41"],
["&#x4da;","&#x4b6;","41"],
["&#x4da;","&#x4b4;","20"],
["&#x4da;","&#x4b2;","41"],
["&#x4da;","&#x4b0;","20"],
["&#x4da;","&#x4ae;","20"],
["&#x4da;","&#x4ac;","61"],
["&#x4da;","&#x4a0;","20"],
["&#x4da;","&#x498;","20"],
["&#x4da;","&#x496;","41"],
["&#x4da;","&#x476;","20"],
["&#x4da;","&#x474;","20"],
["&#x4da;","&#x470;","41"],
["&#x4da;","&#x46e;","20"],
["&#x4da;","&#x467;","20"],
["&#x4da;","&#x466;","41"],
["&#x4da;","&#x201e;","82"],
["&#x4da;","&#x201a;","82"],
["&#x4da;","&#x459;","20"],
["&#x4da;","&#x43b;","20"],
["&#x4da;","&#x434;","20"],
["&#x4da;","&#x42d;","20"],
["&#x4da;","&#x42a;","20"],
["&#x4da;","&#x427;","41"],
["&#x4da;","&#x425;","41"],
["&#x4da;","&#x423;","41"],
["&#x4da;","&#x422;","61"],
["&#x4da;","&#x41b;","41"],
["&#x4da;","&#x417;","20"],
["&#x4da;","&#x416;","41"],
["&#x4da;","&#x414;","41"],
["&#x4da;","&#x410;","41"],
["&#x4da;","&#x40e;","41"],
["&#x4da;","&#x40b;","20"],
["&#x4da;","&#x409;","41"],
["&#x4da;","&#x402;","20"],
["&#x4da;","&#x2e;","82"],
["&#x4da;","&#x2c;","82"],
["&#x4db;","&#x50f;","20"],
["&#x4db;","&#x507;","20"],
["&#x4db;","&#x505;","20"],
["&#x4db;","&#x4ff;","41"],
["&#x4db;","&#x4fd;","41"],
["&#x4db;","&#x4f5;","20"],
["&#x4db;","&#x4f3;","20"],
["&#x4db;","&#x4f1;","20"],
["&#x4db;","&#x4ef;","20"],
["&#x4db;","&#x4dd;","41"],
["&#x4db;","&#x4cc;","20"],
["&#x4db;","&#x4c2;","41"],
["&#x4db;","&#x4b9;","20"],
["&#x4db;","&#x4b7;","20"],
["&#x4db;","&#x4b5;","20"],
["&#x4db;","&#x4b3;","41"],
["&#x4db;","&#x4ad;","20"],
["&#x4db;","&#x4a1;","20"],
["&#x4db;","&#x497;","41"],
["&#x4db;","&#x201d;","20"],
["&#x4db;","&#x2019;","20"],
["&#x4db;","&#x45e;","20"],
["&#x4db;","&#x44a;","20"],
["&#x4db;","&#x447;","20"],
["&#x4db;","&#x445;","41"],
["&#x4db;","&#x443;","20"],
["&#x4db;","&#x442;","20"],
["&#x4db;","&#x436;","41"],
["&#x4db;","&#x27;","20"],
["&#x4db;","&#x22;","20"],
["&#x4dc;","&#x510;","20"],
["&#x4dc;","&#x50c;","41"],
["&#x4dc;","&#x507;","41"],
["&#x4dc;","&#x505;","41"],
["&#x4dc;","&#x502;","41"],
["&#x4dc;","&#x500;","41"],
["&#x4dc;","&#x4f5;","41"],
["&#x4dc;","&#x4f4;","41"],
["&#x4dc;","&#x4ea;","41"],
["&#x4dc;","&#x4e8;","41"],
["&#x4dc;","&#x4e6;","41"],
["&#x4dc;","&#x4cc;","41"],
["&#x4dc;","&#x4cb;","41"],
["&#x4dc;","&#x4be;","102"],
["&#x4dc;","&#x4bc;","102"],
["&#x4dc;","&#x4b9;","41"],
["&#x4dc;","&#x4b8;","41"],
["&#x4dc;","&#x4b7;","41"],
["&#x4dc;","&#x4b6;","41"],
["&#x4dc;","&#x4aa;","41"],
["&#x4dc;","&#x4a8;","41"],
["&#x4dc;","&#x480;","41"],
["&#x4dc;","&#x47e;","41"],
["&#x4dc;","&#x47c;","41"],
["&#x4dc;","&#x47a;","41"],
["&#x4dc;","&#x478;","41"],
["&#x4dc;","&#x472;","41"],
["&#x4dc;","&#x470;","41"],
["&#x4dc;","&#x460;","41"],
["&#x4dc;","&#x447;","41"],
["&#x4dc;","&#x427;","41"],
["&#x4dc;","&#x424;","41"],
["&#x4dc;","&#x421;","41"],
["&#x4dc;","&#x41e;","41"],
["&#x4dc;","&#x404;","41"],
["&#x4dd;","&#x511;","41"],
["&#x4dd;","&#x50d;","41"],
["&#x4dd;","&#x503;","41"],
["&#x4dd;","&#x501;","41"],
["&#x4dd;","&#x4f5;","41"],
["&#x4dd;","&#x4eb;","41"],
["&#x4dd;","&#x4e9;","41"],
["&#x4dd;","&#x4e7;","41"],
["&#x4dd;","&#x4d7;","41"],
["&#x4dd;","&#x4cc;","41"],
["&#x4dd;","&#x4bf;","41"],
["&#x4dd;","&#x4bd;","41"],
["&#x4dd;","&#x4b9;","41"],
["&#x4dd;","&#x4b7;","41"],
["&#x4dd;","&#x4ab;","41"],
["&#x4dd;","&#x4a9;","41"],
["&#x4dd;","&#x481;","41"],
["&#x4dd;","&#x47d;","41"],
["&#x4dd;","&#x47b;","41"],
["&#x4dd;","&#x479;","41"],
["&#x4dd;","&#x473;","41"],
["&#x4dd;","&#x450;","41"],
["&#x4dd;","&#x454;","41"],
["&#x4dd;","&#x451;","41"],
["&#x4dd;","&#x447;","41"],
["&#x4dd;","&#x444;","41"],
["&#x4dd;","&#x441;","41"],
["&#x4dd;","&#x43e;","41"],
["&#x4dd;","&#x435;","41"],
["&#x4de;","&#x506;","41"],
["&#x4de;","&#x504;","41"],
["&#x4de;","&#x4b0;","20"],
["&#x4de;","&#x4ae;","20"],
["&#x4de;","&#x476;","20"],
["&#x4de;","&#x474;","20"],
["&#x4de;","&#x201e;","82"],
["&#x4de;","&#x201a;","82"],
["&#x4de;","&#x2e;","82"],
["&#x4de;","&#x2c;","82"],
["&#x4df;","&#x44f;","-41"],
["&#x4e0;","&#x507;","41"],
["&#x4e0;","&#x505;","41"],
["&#x4e0;","&#x201d;","20"],
["&#x4e0;","&#x2019;","20"],
["&#x4e0;","&#x27;","20"],
["&#x4e0;","&#x22;","20"],
["&#x4e6;","&#x513;","20"],
["&#x4e6;","&#x512;","41"],
["&#x4e6;","&#x50e;","20"],
["&#x4e6;","&#x509;","20"],
["&#x4e6;","&#x508;","41"],
["&#x4e6;","&#x506;","41"],
["&#x4e6;","&#x504;","41"],
["&#x4e6;","&#x4fe;","41"],
["&#x4e6;","&#x4fc;","41"],
["&#x4e6;","&#x4f4;","41"],
["&#x4e6;","&#x4f2;","41"],
["&#x4e6;","&#x4f0;","41"],
["&#x4e6;","&#x4ee;","41"],
["&#x4e6;","&#x4ec;","20"],
["&#x4e6;","&#x4de;","20"],
["&#x4e6;","&#x4dc;","41"],
["&#x4e6;","&#x4d4;","41"],
["&#x4e6;","&#x4d2;","41"],
["&#x4e6;","&#x4d0;","41"],
["&#x4e6;","&#x4cb;","41"],
["&#x4e6;","&#x4c6;","20"],
["&#x4e6;","&#x4c5;","41"],
["&#x4e6;","&#x4c1;","41"],
["&#x4e6;","&#x4b8;","41"],
["&#x4e6;","&#x4b6;","41"],
["&#x4e6;","&#x4b4;","20"],
["&#x4e6;","&#x4b2;","41"],
["&#x4e6;","&#x4b0;","20"],
["&#x4e6;","&#x4ae;","20"],
["&#x4e6;","&#x4ac;","61"],
["&#x4e6;","&#x4a0;","20"],
["&#x4e6;","&#x498;","20"],
["&#x4e6;","&#x496;","41"],
["&#x4e6;","&#x476;","20"],
["&#x4e6;","&#x474;","20"],
["&#x4e6;","&#x470;","41"],
["&#x4e6;","&#x46e;","20"],
["&#x4e6;","&#x467;","20"],
["&#x4e6;","&#x466;","41"],
["&#x4e6;","&#x201e;","82"],
["&#x4e6;","&#x201a;","82"],
["&#x4e6;","&#x459;","20"],
["&#x4e6;","&#x43b;","20"],
["&#x4e6;","&#x434;","20"],
["&#x4e6;","&#x42d;","20"],
["&#x4e6;","&#x42a;","20"],
["&#x4e6;","&#x427;","41"],
["&#x4e6;","&#x425;","41"],
["&#x4e6;","&#x423;","41"],
["&#x4e6;","&#x422;","61"],
["&#x4e6;","&#x41b;","41"],
["&#x4e6;","&#x417;","20"],
["&#x4e6;","&#x416;","41"],
["&#x4e6;","&#x414;","41"],
["&#x4e6;","&#x410;","41"],
["&#x4e6;","&#x40e;","41"],
["&#x4e6;","&#x40b;","20"],
["&#x4e6;","&#x409;","41"],
["&#x4e6;","&#x402;","20"],
["&#x4e6;","&#x2e;","82"],
["&#x4e6;","&#x2c;","82"],
["&#x4e7;","&#x50f;","20"],
["&#x4e7;","&#x507;","20"],
["&#x4e7;","&#x505;","20"],
["&#x4e7;","&#x4ff;","41"],
["&#x4e7;","&#x4fd;","41"],
["&#x4e7;","&#x4f5;","20"],
["&#x4e7;","&#x4f3;","20"],
["&#x4e7;","&#x4f1;","20"],
["&#x4e7;","&#x4ef;","20"],
["&#x4e7;","&#x4dd;","41"],
["&#x4e7;","&#x4cc;","20"],
["&#x4e7;","&#x4c2;","41"],
["&#x4e7;","&#x4b9;","20"],
["&#x4e7;","&#x4b7;","20"],
["&#x4e7;","&#x4b5;","20"],
["&#x4e7;","&#x4b3;","41"],
["&#x4e7;","&#x4ad;","20"],
["&#x4e7;","&#x4a1;","20"],
["&#x4e7;","&#x497;","41"],
["&#x4e7;","&#x201d;","20"],
["&#x4e7;","&#x2019;","20"],
["&#x4e7;","&#x45e;","20"],
["&#x4e7;","&#x44a;","20"],
["&#x4e7;","&#x447;","20"],
["&#x4e7;","&#x445;","41"],
["&#x4e7;","&#x443;","20"],
["&#x4e7;","&#x442;","20"],
["&#x4e7;","&#x436;","41"],
["&#x4e7;","&#x27;","20"],
["&#x4e7;","&#x22;","20"],
["&#x4e8;","&#x513;","20"],
["&#x4e8;","&#x512;","41"],
["&#x4e8;","&#x50e;","20"],
["&#x4e8;","&#x509;","20"],
["&#x4e8;","&#x508;","41"],
["&#x4e8;","&#x506;","41"],
["&#x4e8;","&#x504;","41"],
["&#x4e8;","&#x4fe;","41"],
["&#x4e8;","&#x4fc;","41"],
["&#x4e8;","&#x4f4;","41"],
["&#x4e8;","&#x4f2;","41"],
["&#x4e8;","&#x4f0;","41"],
["&#x4e8;","&#x4ee;","41"],
["&#x4e8;","&#x4ec;","20"],
["&#x4e8;","&#x4de;","20"],
["&#x4e8;","&#x4dc;","41"],
["&#x4e8;","&#x4d4;","41"],
["&#x4e8;","&#x4d2;","41"],
["&#x4e8;","&#x4d0;","41"],
["&#x4e8;","&#x4cb;","41"],
["&#x4e8;","&#x4c6;","20"],
["&#x4e8;","&#x4c5;","41"],
["&#x4e8;","&#x4c1;","41"],
["&#x4e8;","&#x4b8;","41"],
["&#x4e8;","&#x4b6;","41"],
["&#x4e8;","&#x4b4;","20"],
["&#x4e8;","&#x4b2;","41"],
["&#x4e8;","&#x4b0;","20"],
["&#x4e8;","&#x4ae;","20"],
["&#x4e8;","&#x4ac;","61"],
["&#x4e8;","&#x4a0;","20"],
["&#x4e8;","&#x498;","20"],
["&#x4e8;","&#x496;","41"],
["&#x4e8;","&#x476;","20"],
["&#x4e8;","&#x474;","20"],
["&#x4e8;","&#x470;","41"],
["&#x4e8;","&#x46e;","20"],
["&#x4e8;","&#x467;","20"],
["&#x4e8;","&#x466;","41"],
["&#x4e8;","&#x201e;","82"],
["&#x4e8;","&#x201a;","82"],
["&#x4e8;","&#x459;","20"],
["&#x4e8;","&#x43b;","20"],
["&#x4e8;","&#x434;","20"],
["&#x4e8;","&#x42d;","20"],
["&#x4e8;","&#x42a;","20"],
["&#x4e8;","&#x427;","41"],
["&#x4e8;","&#x425;","41"],
["&#x4e8;","&#x423;","41"],
["&#x4e8;","&#x422;","61"],
["&#x4e8;","&#x41b;","41"],
["&#x4e8;","&#x417;","20"],
["&#x4e8;","&#x416;","41"],
["&#x4e8;","&#x414;","41"],
["&#x4e8;","&#x410;","41"],
["&#x4e8;","&#x40e;","41"],
["&#x4e8;","&#x40b;","20"],
["&#x4e8;","&#x409;","41"],
["&#x4e8;","&#x402;","20"],
["&#x4e8;","&#x2e;","82"],
["&#x4e8;","&#x2c;","82"],
["&#x4e9;","&#x50f;","20"],
["&#x4e9;","&#x507;","20"],
["&#x4e9;","&#x505;","20"],
["&#x4e9;","&#x4ff;","41"],
["&#x4e9;","&#x4fd;","41"],
["&#x4e9;","&#x4f5;","20"],
["&#x4e9;","&#x4f3;","20"],
["&#x4e9;","&#x4f1;","20"],
["&#x4e9;","&#x4ef;","20"],
["&#x4e9;","&#x4dd;","41"],
["&#x4e9;","&#x4cc;","20"],
["&#x4e9;","&#x4c2;","41"],
["&#x4e9;","&#x4b9;","20"],
["&#x4e9;","&#x4b7;","20"],
["&#x4e9;","&#x4b5;","20"],
["&#x4e9;","&#x4b3;","41"],
["&#x4e9;","&#x4ad;","20"],
["&#x4e9;","&#x4a1;","20"],
["&#x4e9;","&#x497;","41"],
["&#x4e9;","&#x201d;","20"],
["&#x4e9;","&#x2019;","20"],
["&#x4e9;","&#x45e;","20"],
["&#x4e9;","&#x44a;","20"],
["&#x4e9;","&#x447;","20"],
["&#x4e9;","&#x445;","41"],
["&#x4e9;","&#x443;","20"],
["&#x4e9;","&#x442;","20"],
["&#x4e9;","&#x436;","41"],
["&#x4e9;","&#x27;","20"],
["&#x4e9;","&#x22;","20"],
["&#x4ea;","&#x513;","20"],
["&#x4ea;","&#x512;","41"],
["&#x4ea;","&#x50e;","20"],
["&#x4ea;","&#x509;","20"],
["&#x4ea;","&#x508;","41"],
["&#x4ea;","&#x506;","41"],
["&#x4ea;","&#x504;","41"],
["&#x4ea;","&#x4fe;","41"],
["&#x4ea;","&#x4fc;","41"],
["&#x4ea;","&#x4f4;","41"],
["&#x4ea;","&#x4f2;","41"],
["&#x4ea;","&#x4f0;","41"],
["&#x4ea;","&#x4ee;","41"],
["&#x4ea;","&#x4ec;","20"],
["&#x4ea;","&#x4de;","20"],
["&#x4ea;","&#x4dc;","41"],
["&#x4ea;","&#x4d4;","41"],
["&#x4ea;","&#x4d2;","41"],
["&#x4ea;","&#x4d0;","41"],
["&#x4ea;","&#x4cb;","41"],
["&#x4ea;","&#x4c6;","20"],
["&#x4ea;","&#x4c5;","41"],
["&#x4ea;","&#x4c1;","41"],
["&#x4ea;","&#x4b8;","41"],
["&#x4ea;","&#x4b6;","41"],
["&#x4ea;","&#x4b4;","20"],
["&#x4ea;","&#x4b2;","41"],
["&#x4ea;","&#x4b0;","20"],
["&#x4ea;","&#x4ae;","20"],
["&#x4ea;","&#x4ac;","61"],
["&#x4ea;","&#x4a0;","20"],
["&#x4ea;","&#x498;","20"],
["&#x4ea;","&#x496;","41"],
["&#x4ea;","&#x476;","20"],
["&#x4ea;","&#x474;","20"],
["&#x4ea;","&#x470;","41"],
["&#x4ea;","&#x46e;","20"],
["&#x4ea;","&#x467;","20"],
["&#x4ea;","&#x466;","41"],
["&#x4ea;","&#x201e;","82"],
["&#x4ea;","&#x201a;","82"],
["&#x4ea;","&#x459;","20"],
["&#x4ea;","&#x43b;","20"],
["&#x4ea;","&#x434;","20"],
["&#x4ea;","&#x42d;","20"],
["&#x4ea;","&#x42a;","20"],
["&#x4ea;","&#x427;","41"],
["&#x4ea;","&#x425;","41"],
["&#x4ea;","&#x423;","41"],
["&#x4ea;","&#x422;","61"],
["&#x4ea;","&#x41b;","41"],
["&#x4ea;","&#x417;","20"],
["&#x4ea;","&#x416;","41"],
["&#x4ea;","&#x414;","41"],
["&#x4ea;","&#x410;","41"],
["&#x4ea;","&#x40e;","41"],
["&#x4ea;","&#x40b;","20"],
["&#x4ea;","&#x409;","41"],
["&#x4ea;","&#x402;","20"],
["&#x4ea;","&#x2e;","82"],
["&#x4ea;","&#x2c;","82"],
["&#x4eb;","&#x50f;","20"],
["&#x4eb;","&#x507;","20"],
["&#x4eb;","&#x505;","20"],
["&#x4eb;","&#x4ff;","41"],
["&#x4eb;","&#x4fd;","41"],
["&#x4eb;","&#x4f5;","20"],
["&#x4eb;","&#x4f3;","20"],
["&#x4eb;","&#x4f1;","20"],
["&#x4eb;","&#x4ef;","20"],
["&#x4eb;","&#x4dd;","41"],
["&#x4eb;","&#x4cc;","20"],
["&#x4eb;","&#x4c2;","41"],
["&#x4eb;","&#x4b9;","20"],
["&#x4eb;","&#x4b7;","20"],
["&#x4eb;","&#x4b5;","20"],
["&#x4eb;","&#x4b3;","41"],
["&#x4eb;","&#x4ad;","20"],
["&#x4eb;","&#x4a1;","20"],
["&#x4eb;","&#x497;","41"],
["&#x4eb;","&#x201d;","20"],
["&#x4eb;","&#x2019;","20"],
["&#x4eb;","&#x45e;","20"],
["&#x4eb;","&#x44a;","20"],
["&#x4eb;","&#x447;","20"],
["&#x4eb;","&#x445;","41"],
["&#x4eb;","&#x443;","20"],
["&#x4eb;","&#x442;","20"],
["&#x4eb;","&#x436;","41"],
["&#x4eb;","&#x27;","20"],
["&#x4eb;","&#x22;","20"],
["&#x4ec;","&#x513;","20"],
["&#x4ec;","&#x512;","41"],
["&#x4ec;","&#x50e;","20"],
["&#x4ec;","&#x509;","20"],
["&#x4ec;","&#x508;","41"],
["&#x4ec;","&#x506;","41"],
["&#x4ec;","&#x504;","41"],
["&#x4ec;","&#x4fe;","41"],
["&#x4ec;","&#x4fc;","41"],
["&#x4ec;","&#x4f4;","41"],
["&#x4ec;","&#x4f2;","41"],
["&#x4ec;","&#x4f0;","41"],
["&#x4ec;","&#x4ee;","41"],
["&#x4ec;","&#x4ec;","20"],
["&#x4ec;","&#x4de;","20"],
["&#x4ec;","&#x4dc;","41"],
["&#x4ec;","&#x4d4;","41"],
["&#x4ec;","&#x4d2;","41"],
["&#x4ec;","&#x4d0;","41"],
["&#x4ec;","&#x4cb;","41"],
["&#x4ec;","&#x4c6;","20"],
["&#x4ec;","&#x4c5;","41"],
["&#x4ec;","&#x4c1;","41"],
["&#x4ec;","&#x4b8;","41"],
["&#x4ec;","&#x4b6;","41"],
["&#x4ec;","&#x4b4;","20"],
["&#x4ec;","&#x4b2;","41"],
["&#x4ec;","&#x4b0;","20"],
["&#x4ec;","&#x4ae;","20"],
["&#x4ec;","&#x4ac;","61"],
["&#x4ec;","&#x4a0;","20"],
["&#x4ec;","&#x498;","20"],
["&#x4ec;","&#x496;","41"],
["&#x4ec;","&#x476;","20"],
["&#x4ec;","&#x474;","20"],
["&#x4ec;","&#x470;","41"],
["&#x4ec;","&#x46e;","20"],
["&#x4ec;","&#x467;","20"],
["&#x4ec;","&#x466;","41"],
["&#x4ec;","&#x201e;","82"],
["&#x4ec;","&#x201a;","82"],
["&#x4ec;","&#x459;","20"],
["&#x4ec;","&#x43b;","20"],
["&#x4ec;","&#x434;","20"],
["&#x4ec;","&#x42d;","20"],
["&#x4ec;","&#x42a;","20"],
["&#x4ec;","&#x427;","41"],
["&#x4ec;","&#x425;","41"],
["&#x4ec;","&#x423;","41"],
["&#x4ec;","&#x422;","61"],
["&#x4ec;","&#x41b;","41"],
["&#x4ec;","&#x417;","20"],
["&#x4ec;","&#x416;","41"],
["&#x4ec;","&#x414;","41"],
["&#x4ec;","&#x410;","41"],
["&#x4ec;","&#x40e;","41"],
["&#x4ec;","&#x40b;","20"],
["&#x4ec;","&#x409;","41"],
["&#x4ec;","&#x402;","20"],
["&#x4ec;","&#x2e;","82"],
["&#x4ec;","&#x2c;","82"],
["&#x4ed;","&#x50f;","20"],
["&#x4ed;","&#x507;","20"],
["&#x4ed;","&#x505;","20"],
["&#x4ed;","&#x4ff;","41"],
["&#x4ed;","&#x4fd;","41"],
["&#x4ed;","&#x4f5;","20"],
["&#x4ed;","&#x4f3;","20"],
["&#x4ed;","&#x4f1;","20"],
["&#x4ed;","&#x4ef;","20"],
["&#x4ed;","&#x4dd;","41"],
["&#x4ed;","&#x4cc;","20"],
["&#x4ed;","&#x4c2;","41"],
["&#x4ed;","&#x4b9;","20"],
["&#x4ed;","&#x4b7;","20"],
["&#x4ed;","&#x4b5;","20"],
["&#x4ed;","&#x4b3;","41"],
["&#x4ed;","&#x4ad;","20"],
["&#x4ed;","&#x4a1;","20"],
["&#x4ed;","&#x497;","41"],
["&#x4ed;","&#x201d;","20"],
["&#x4ed;","&#x2019;","20"],
["&#x4ed;","&#x45e;","20"],
["&#x4ed;","&#x44a;","20"],
["&#x4ed;","&#x447;","20"],
["&#x4ed;","&#x445;","41"],
["&#x4ed;","&#x443;","20"],
["&#x4ed;","&#x442;","20"],
["&#x4ed;","&#x436;","41"],
["&#x4ed;","&#x27;","20"],
["&#x4ed;","&#x22;","20"],
["&#x4ee;","&#x513;","82"],
["&#x4ee;","&#x512;","102"],
["&#x4ee;","&#x511;","41"],
["&#x4ee;","&#x50d;","41"],
["&#x4ee;","&#x50c;","20"],
["&#x4ee;","&#x509;","82"],
["&#x4ee;","&#x508;","102"],
["&#x4ee;","&#x503;","41"],
["&#x4ee;","&#x502;","143"],
["&#x4ee;","&#x501;","41"],
["&#x4ee;","&#x500;","143"],
["&#x4ee;","&#x4f5;","41"],
["&#x4ee;","&#x4eb;","41"],
["&#x4ee;","&#x4ea;","20"],
["&#x4ee;","&#x4e9;","41"],
["&#x4ee;","&#x4e8;","20"],
["&#x4ee;","&#x4e7;","41"],
["&#x4ee;","&#x4e6;","20"],
["&#x4ee;","&#x4d7;","41"],
["&#x4ee;","&#x4d4;","143"],
["&#x4ee;","&#x4d2;","143"],
["&#x4ee;","&#x4d0;","143"],
["&#x4ee;","&#x4cc;","41"],
["&#x4ee;","&#x4c6;","82"],
["&#x4ee;","&#x4c5;","102"],
["&#x4ee;","&#x4bf;","61"],
["&#x4ee;","&#x4be;","41"],
["&#x4ee;","&#x4bd;","61"],
["&#x4ee;","&#x4bc;","41"],
["&#x4ee;","&#x4b9;","41"],
["&#x4ee;","&#x4b7;","41"],
["&#x4ee;","&#x4ab;","41"],
["&#x4ee;","&#x4aa;","20"],
["&#x4ee;","&#x4a9;","41"],
["&#x4ee;","&#x4a8;","20"],
["&#x4ee;","&#x49f;","-102"],
["&#x4ee;","&#x48d;","-102"],
["&#x4ee;","&#x481;","41"],
["&#x4ee;","&#x480;","20"],
["&#x4ee;","&#x47e;","20"],
["&#x4ee;","&#x47d;","41"],
["&#x4ee;","&#x47c;","20"],
["&#x4ee;","&#x47b;","41"],
["&#x4ee;","&#x47a;","20"],
["&#x4ee;","&#x479;","41"],
["&#x4ee;","&#x478;","20"],
["&#x4ee;","&#x473;","41"],
["&#x4ee;","&#x472;","20"],
["&#x4ee;","&#x467;","82"],
["&#x4ee;","&#x466;","143"],
["&#x4ee;","&#x460;","20"],
["&#x4ee;","&#x450;","41"],
["&#x4ee;","&#x201e;","123"],
["&#x4ee;","&#x201a;","123"],
["&#x4ee;","&#x45b;","-102"],
["&#x4ee;","&#x459;","82"],
["&#x4ee;","&#x455;","20"],
["&#x4ee;","&#x454;","41"],
["&#x4ee;","&#x452;","-102"],
["&#x4ee;","&#x451;","41"],
["&#x4ee;","&#x447;","41"],
["&#x4ee;","&#x444;","41"],
["&#x4ee;","&#x441;","41"],
["&#x4ee;","&#x43e;","41"],
["&#x4ee;","&#x43b;","82"],
["&#x4ee;","&#x435;","41"],
["&#x4ee;","&#x434;","82"],
["&#x4ee;","&#x42f;","20"],
["&#x4ee;","&#x424;","61"],
["&#x4ee;","&#x421;","20"],
["&#x4ee;","&#x41e;","20"],
["&#x4ee;","&#x41b;","102"],
["&#x4ee;","&#x414;","102"],
["&#x4ee;","&#x410;","143"],
["&#x4ee;","&#x409;","102"],
["&#x4ee;","&#x404;","20"],
["&#x4ee;","&#x2e;","123"],
["&#x4ee;","&#x2c;","123"],
["&#x4ef;","&#x513;","41"],
["&#x4ef;","&#x509;","41"],
["&#x4ef;","&#x4c6;","41"],
["&#x4ef;","&#x467;","41"],
["&#x4ef;","&#x201e;","82"],
["&#x4ef;","&#x201a;","82"],
["&#x4ef;","&#x459;","41"],
["&#x4ef;","&#x43b;","41"],
["&#x4ef;","&#x434;","41"],
["&#x4ef;","&#x2e;","82"],
["&#x4ef;","&#x2c;","82"],
["&#x4f0;","&#x513;","82"],
["&#x4f0;","&#x512;","102"],
["&#x4f0;","&#x511;","41"],
["&#x4f0;","&#x50d;","41"],
["&#x4f0;","&#x50c;","20"],
["&#x4f0;","&#x509;","82"],
["&#x4f0;","&#x508;","102"],
["&#x4f0;","&#x503;","41"],
["&#x4f0;","&#x502;","143"],
["&#x4f0;","&#x501;","41"],
["&#x4f0;","&#x500;","143"],
["&#x4f0;","&#x4f5;","41"],
["&#x4f0;","&#x4eb;","41"],
["&#x4f0;","&#x4ea;","20"],
["&#x4f0;","&#x4e9;","41"],
["&#x4f0;","&#x4e8;","20"],
["&#x4f0;","&#x4e7;","41"],
["&#x4f0;","&#x4e6;","20"],
["&#x4f0;","&#x4d7;","41"],
["&#x4f0;","&#x4d4;","143"],
["&#x4f0;","&#x4d2;","143"],
["&#x4f0;","&#x4d0;","143"],
["&#x4f0;","&#x4cc;","41"],
["&#x4f0;","&#x4c6;","82"],
["&#x4f0;","&#x4c5;","102"],
["&#x4f0;","&#x4bf;","61"],
["&#x4f0;","&#x4be;","41"],
["&#x4f0;","&#x4bd;","61"],
["&#x4f0;","&#x4bc;","41"],
["&#x4f0;","&#x4b9;","41"],
["&#x4f0;","&#x4b7;","41"],
["&#x4f0;","&#x4ab;","41"],
["&#x4f0;","&#x4aa;","20"],
["&#x4f0;","&#x4a9;","41"],
["&#x4f0;","&#x4a8;","20"],
["&#x4f0;","&#x49f;","-102"],
["&#x4f0;","&#x48d;","-102"],
["&#x4f0;","&#x481;","41"],
["&#x4f0;","&#x480;","20"],
["&#x4f0;","&#x47e;","20"],
["&#x4f0;","&#x47d;","41"],
["&#x4f0;","&#x47c;","20"],
["&#x4f0;","&#x47b;","41"],
["&#x4f0;","&#x47a;","20"],
["&#x4f0;","&#x479;","41"],
["&#x4f0;","&#x478;","20"],
["&#x4f0;","&#x473;","41"],
["&#x4f0;","&#x472;","20"],
["&#x4f0;","&#x467;","82"],
["&#x4f0;","&#x466;","143"],
["&#x4f0;","&#x460;","20"],
["&#x4f0;","&#x450;","41"],
["&#x4f0;","&#x201e;","123"],
["&#x4f0;","&#x201a;","123"],
["&#x4f0;","&#x45b;","-102"],
["&#x4f0;","&#x459;","82"],
["&#x4f0;","&#x455;","20"],
["&#x4f0;","&#x454;","41"],
["&#x4f0;","&#x452;","-102"],
["&#x4f0;","&#x451;","41"],
["&#x4f0;","&#x447;","41"],
["&#x4f0;","&#x444;","41"],
["&#x4f0;","&#x441;","41"],
["&#x4f0;","&#x43e;","41"],
["&#x4f0;","&#x43b;","82"],
["&#x4f0;","&#x435;","41"],
["&#x4f0;","&#x434;","82"],
["&#x4f0;","&#x42f;","20"],
["&#x4f0;","&#x424;","61"],
["&#x4f0;","&#x421;","20"],
["&#x4f0;","&#x41e;","20"],
["&#x4f0;","&#x41b;","102"],
["&#x4f0;","&#x414;","102"],
["&#x4f0;","&#x410;","143"],
["&#x4f0;","&#x409;","102"],
["&#x4f0;","&#x404;","20"],
["&#x4f0;","&#x2e;","123"],
["&#x4f0;","&#x2c;","123"],
["&#x4f1;","&#x513;","41"],
["&#x4f1;","&#x509;","41"],
["&#x4f1;","&#x4c6;","41"],
["&#x4f1;","&#x467;","41"],
["&#x4f1;","&#x201e;","82"],
["&#x4f1;","&#x201a;","82"],
["&#x4f1;","&#x459;","41"],
["&#x4f1;","&#x43b;","41"],
["&#x4f1;","&#x434;","41"],
["&#x4f1;","&#x2e;","82"],
["&#x4f1;","&#x2c;","82"],
["&#x4f2;","&#x513;","82"],
["&#x4f2;","&#x512;","102"],
["&#x4f2;","&#x511;","41"],
["&#x4f2;","&#x50d;","41"],
["&#x4f2;","&#x50c;","20"],
["&#x4f2;","&#x509;","82"],
["&#x4f2;","&#x508;","102"],
["&#x4f2;","&#x503;","41"],
["&#x4f2;","&#x502;","143"],
["&#x4f2;","&#x501;","41"],
["&#x4f2;","&#x500;","143"],
["&#x4f2;","&#x4f5;","41"],
["&#x4f2;","&#x4eb;","41"],
["&#x4f2;","&#x4ea;","20"],
["&#x4f2;","&#x4e9;","41"],
["&#x4f2;","&#x4e8;","20"],
["&#x4f2;","&#x4e7;","41"],
["&#x4f2;","&#x4e6;","20"],
["&#x4f2;","&#x4d7;","41"],
["&#x4f2;","&#x4d4;","143"],
["&#x4f2;","&#x4d2;","143"],
["&#x4f2;","&#x4d0;","143"],
["&#x4f2;","&#x4cc;","41"],
["&#x4f2;","&#x4c6;","82"],
["&#x4f2;","&#x4c5;","102"],
["&#x4f2;","&#x4bf;","61"],
["&#x4f2;","&#x4be;","41"],
["&#x4f2;","&#x4bd;","61"],
["&#x4f2;","&#x4bc;","41"],
["&#x4f2;","&#x4b9;","41"],
["&#x4f2;","&#x4b7;","41"],
["&#x4f2;","&#x4ab;","41"],
["&#x4f2;","&#x4aa;","20"],
["&#x4f2;","&#x4a9;","41"],
["&#x4f2;","&#x4a8;","20"],
["&#x4f2;","&#x49f;","-102"],
["&#x4f2;","&#x48d;","-102"],
["&#x4f2;","&#x481;","41"],
["&#x4f2;","&#x480;","20"],
["&#x4f2;","&#x47e;","20"],
["&#x4f2;","&#x47d;","41"],
["&#x4f2;","&#x47c;","20"],
["&#x4f2;","&#x47b;","41"],
["&#x4f2;","&#x47a;","20"],
["&#x4f2;","&#x479;","41"],
["&#x4f2;","&#x478;","20"],
["&#x4f2;","&#x473;","41"],
["&#x4f2;","&#x472;","20"],
["&#x4f2;","&#x467;","82"],
["&#x4f2;","&#x466;","143"],
["&#x4f2;","&#x460;","20"],
["&#x4f2;","&#x450;","41"],
["&#x4f2;","&#x201e;","123"],
["&#x4f2;","&#x201a;","123"],
["&#x4f2;","&#x45b;","-102"],
["&#x4f2;","&#x459;","82"],
["&#x4f2;","&#x455;","20"],
["&#x4f2;","&#x454;","41"],
["&#x4f2;","&#x452;","-102"],
["&#x4f2;","&#x451;","41"],
["&#x4f2;","&#x447;","41"],
["&#x4f2;","&#x444;","41"],
["&#x4f2;","&#x441;","41"],
["&#x4f2;","&#x43e;","41"],
["&#x4f2;","&#x43b;","82"],
["&#x4f2;","&#x435;","41"],
["&#x4f2;","&#x434;","82"],
["&#x4f2;","&#x42f;","20"],
["&#x4f2;","&#x424;","61"],
["&#x4f2;","&#x421;","20"],
["&#x4f2;","&#x41e;","20"],
["&#x4f2;","&#x41b;","102"],
["&#x4f2;","&#x414;","102"],
["&#x4f2;","&#x410;","143"],
["&#x4f2;","&#x409;","102"],
["&#x4f2;","&#x404;","20"],
["&#x4f2;","&#x2e;","123"],
["&#x4f2;","&#x2c;","123"],
["&#x4f3;","&#x513;","41"],
["&#x4f3;","&#x509;","41"],
["&#x4f3;","&#x4c6;","41"],
["&#x4f3;","&#x467;","41"],
["&#x4f3;","&#x201e;","82"],
["&#x4f3;","&#x201a;","82"],
["&#x4f3;","&#x459;","41"],
["&#x4f3;","&#x43b;","41"],
["&#x4f3;","&#x434;","41"],
["&#x4f3;","&#x2e;","82"],
["&#x4f3;","&#x2c;","82"],
["&#x4f6;","&#x513;","123"],
["&#x4f6;","&#x512;","102"],
["&#x4f6;","&#x511;","143"],
["&#x4f6;","&#x50f;","82"],
["&#x4f6;","&#x50d;","143"],
["&#x4f6;","&#x50c;","41"],
["&#x4f6;","&#x50b;","102"],
["&#x4f6;","&#x509;","123"],
["&#x4f6;","&#x508;","102"],
["&#x4f6;","&#x507;","102"],
["&#x4f6;","&#x505;","102"],
["&#x4f6;","&#x503;","143"],
["&#x4f6;","&#x502;","143"],
["&#x4f6;","&#x501;","143"],
["&#x4f6;","&#x500;","143"],
["&#x4f6;","&#x4ff;","41"],
["&#x4f6;","&#x4fd;","41"],
["&#x4f6;","&#x4f9;","102"],
["&#x4f6;","&#x4f7;","102"],
["&#x4f6;","&#x4f5;","102"],
["&#x4f6;","&#x4f3;","82"],
["&#x4f6;","&#x4f1;","82"],
["&#x4f6;","&#x4ef;","82"],
["&#x4f6;","&#x4ed;","41"],
["&#x4f6;","&#x4eb;","143"],
["&#x4f6;","&#x4ea;","41"],
["&#x4f6;","&#x4e9;","143"],
["&#x4f6;","&#x4e8;","41"],
["&#x4f6;","&#x4e7;","143"],
["&#x4f6;","&#x4e6;","41"],
["&#x4f6;","&#x4e5;","102"],
["&#x4f6;","&#x4e3;","102"],
["&#x4f6;","&#x4e1;","61"],
["&#x4f6;","&#x4df;","41"],
["&#x4f6;","&#x4dd;","41"],
["&#x4f6;","&#x4d7;","143"],
["&#x4f6;","&#x4d4;","143"],
["&#x4f6;","&#x4d2;","143"],
["&#x4f6;","&#x4d0;","143"],
["&#x4f6;","&#x4ce;","102"],
["&#x4f6;","&#x4cc;","102"],
["&#x4f6;","&#x4ca;","102"],
["&#x4f6;","&#x4c8;","102"],
["&#x4f6;","&#x4c6;","123"],
["&#x4f6;","&#x4c5;","102"],
["&#x4f6;","&#x4c4;","102"],
["&#x4f6;","&#x4c2;","41"],
["&#x4f6;","&#x4bf;","143"],
["&#x4f6;","&#x4be;","102"],
["&#x4f6;","&#x4bd;","143"],
["&#x4f6;","&#x4bc;","102"],
["&#x4f6;","&#x4bb;","102"],
["&#x4f6;","&#x4b9;","102"],
["&#x4f6;","&#x4b7;","102"],
["&#x4f6;","&#x4b5;","82"],
["&#x4f6;","&#x4b3;","41"],
["&#x4f6;","&#x4b1;","82"],
["&#x4f6;","&#x4af;","82"],
["&#x4f6;","&#x4ad;","82"],
["&#x4f6;","&#x4ac;","-41"],
["&#x4f6;","&#x4ab;","143"],
["&#x4f6;","&#x4aa;","41"],
["&#x4f6;","&#x4a9;","143"],
["&#x4f6;","&#x4a8;","41"],
["&#x4f6;","&#x4a7;","102"],
["&#x4f6;","&#x4a5;","102"],
["&#x4f6;","&#x4a3;","102"],
["&#x4f6;","&#x4a1;","82"],
["&#x4f6;","&#x49d;","102"],
["&#x4f6;","&#x49b;","102"],
["&#x4f6;","&#x499;","41"],
["&#x4f6;","&#x497;","41"],
["&#x4f6;","&#x495;","102"],
["&#x4f6;","&#x48f;","102"],
["&#x4f6;","&#x48b;","102"],
["&#x4f6;","&#x481;","143"],
["&#x4f6;","&#x480;","41"],
["&#x4f6;","&#x47f;","41"],
["&#x4f6;","&#x47e;","41"],
["&#x4f6;","&#x47d;","143"],
["&#x4f6;","&#x47c;","41"],
["&#x4f6;","&#x47b;","143"],
["&#x4f6;","&#x47a;","41"],
["&#x4f6;","&#x479;","143"],
["&#x4f6;","&#x478;","41"],
["&#x4f6;","&#x477;","41"],
["&#x4f6;","&#x475;","41"],
["&#x4f6;","&#x473;","143"],
["&#x4f6;","&#x472;","41"],
["&#x4f6;","&#x471;","102"],
["&#x4f6;","&#x46d;","102"],
["&#x4f6;","&#x46b;","102"],
["&#x4f6;","&#x469;","102"],
["&#x4f6;","&#x467;","123"],
["&#x4f6;","&#x466;","143"],
["&#x4f6;","&#x465;","102"],
["&#x4f6;","&#x461;","41"],
["&#x4f6;","&#x460;","41"],
["&#x4f6;","&#x45d;","102"],
["&#x4f6;","&#x450;","143"],
["&#x4f6;","&#x201e;","123"],
["&#x4f6;","&#x201a;","123"],
["&#x4f6;","&#x2015;","82"],
["&#x4f6;","&#x2014;","82"],
["&#x4f6;","&#x2013;","82"],
["&#x4f6;","&#x491;","102"],
["&#x4f6;","&#x45f;","102"],
["&#x4f6;","&#x45e;","82"],
["&#x4f6;","&#x45c;","102"],
["&#x4f6;","&#x45a;","102"],
["&#x4f6;","&#x459;","123"],
["&#x4f6;","&#x455;","123"],
["&#x4f6;","&#x454;","143"],
["&#x4f6;","&#x453;","102"],
["&#x4f6;","&#x451;","143"],
["&#x4f6;","&#x44f;","61"],
["&#x4f6;","&#x44e;","102"],
["&#x4f6;","&#x44d;","41"],
["&#x4f6;","&#x44c;","102"],
["&#x4f6;","&#x44b;","102"],
["&#x4f6;","&#x44a;","82"],
["&#x4f6;","&#x449;","102"],
["&#x4f6;","&#x448;","102"],
["&#x4f6;","&#x447;","102"],
["&#x4f6;","&#x446;","102"],
["&#x4f6;","&#x445;","41"],
["&#x4f6;","&#x444;","143"],
["&#x4f6;","&#x443;","82"],
["&#x4f6;","&#x442;","82"],
["&#x4f6;","&#x441;","143"],
["&#x4f6;","&#x440;","102"],
["&#x4f6;","&#x43f;","102"],
["&#x4f6;","&#x43e;","143"],
["&#x4f6;","&#x43d;","102"],
["&#x4f6;","&#x43c;","102"],
["&#x4f6;","&#x43b;","123"],
["&#x4f6;","&#x43a;","102"],
["&#x4f6;","&#x439;","102"],
["&#x4f6;","&#x438;","102"],
["&#x4f6;","&#x437;","41"],
["&#x4f6;","&#x436;","41"],
["&#x4f6;","&#x435;","143"],
["&#x4f6;","&#x434;","123"],
["&#x4f6;","&#x433;","102"],
["&#x4f6;","&#x432;","102"],
["&#x4f6;","&#x424;","82"],
["&#x4f6;","&#x422;","-41"],
["&#x4f6;","&#x421;","41"],
["&#x4f6;","&#x41e;","41"],
["&#x4f6;","&#x41b;","102"],
["&#x4f6;","&#x414;","102"],
["&#x4f6;","&#x410;","143"],
["&#x4f6;","&#x409;","102"],
["&#x4f6;","&#x404;","41"],
["&#x4f6;","&#x2e;","123"],
["&#x4f6;","&#x2d;","82"],
["&#x4f6;","&#x2c;","123"],
["&#x4f7;","&#x513;","61"],
["&#x4f7;","&#x511;","20"],
["&#x4f7;","&#x50d;","20"],
["&#x4f7;","&#x509;","61"],
["&#x4f7;","&#x503;","20"],
["&#x4f7;","&#x501;","20"],
["&#x4f7;","&#x4eb;","20"],
["&#x4f7;","&#x4e9;","20"],
["&#x4f7;","&#x4e7;","20"],
["&#x4f7;","&#x4d7;","20"],
["&#x4f7;","&#x4c6;","61"],
["&#x4f7;","&#x4ab;","20"],
["&#x4f7;","&#x4a9;","20"],
["&#x4f7;","&#x481;","20"],
["&#x4f7;","&#x47d;","20"],
["&#x4f7;","&#x47b;","20"],
["&#x4f7;","&#x479;","20"],
["&#x4f7;","&#x473;","20"],
["&#x4f7;","&#x467;","61"],
["&#x4f7;","&#x450;","20"],
["&#x4f7;","&#x201e;","102"],
["&#x4f7;","&#x201a;","102"],
["&#x4f7;","&#x2015;","41"],
["&#x4f7;","&#x2014;","41"],
["&#x4f7;","&#x2013;","41"],
["&#x4f7;","&#x459;","61"],
["&#x4f7;","&#x454;","20"],
["&#x4f7;","&#x451;","20"],
["&#x4f7;","&#x444;","20"],
["&#x4f7;","&#x441;","20"],
["&#x4f7;","&#x43e;","20"],
["&#x4f7;","&#x43b;","61"],
["&#x4f7;","&#x435;","20"],
["&#x4f7;","&#x434;","61"],
["&#x4f7;","&#x2e;","102"],
["&#x4f7;","&#x2d;","41"],
["&#x4f7;","&#x2c;","102"],
["&#x4fa;","&#x513;","102"],
["&#x4fa;","&#x512;","82"],
["&#x4fa;","&#x511;","82"],
["&#x4fa;","&#x50e;","-41"],
["&#x4fa;","&#x50d;","82"],
["&#x4fa;","&#x50c;","41"],
["&#x4fa;","&#x50b;","61"],
["&#x4fa;","&#x509;","102"],
["&#x4fa;","&#x508;","82"],
["&#x4fa;","&#x507;","41"],
["&#x4fa;","&#x505;","41"],
["&#x4fa;","&#x503;","82"],
["&#x4fa;","&#x502;","102"],
["&#x4fa;","&#x501;","82"],
["&#x4fa;","&#x500;","102"],
["&#x4fa;","&#x4ff;","41"],
["&#x4fa;","&#x4fd;","41"],
["&#x4fa;","&#x4f9;","61"],
["&#x4fa;","&#x4f7;","61"],
["&#x4fa;","&#x4f5;","102"],
["&#x4fa;","&#x4ed;","41"],
["&#x4fa;","&#x4eb;","82"],
["&#x4fa;","&#x4ea;","41"],
["&#x4fa;","&#x4e9;","82"],
["&#x4fa;","&#x4e8;","41"],
["&#x4fa;","&#x4e7;","82"],
["&#x4fa;","&#x4e6;","41"],
["&#x4fa;","&#x4e5;","61"],
["&#x4fa;","&#x4e3;","61"],
["&#x4fa;","&#x4df;","41"],
["&#x4fa;","&#x4dd;","41"],
["&#x4fa;","&#x4d7;","82"],
["&#x4fa;","&#x4d4;","123"],
["&#x4fa;","&#x4d2;","123"],
["&#x4fa;","&#x4d0;","123"],
["&#x4fa;","&#x4ce;","61"],
["&#x4fa;","&#x4cc;","102"],
["&#x4fa;","&#x4ca;","61"],
["&#x4fa;","&#x4c8;","61"],
["&#x4fa;","&#x4c6;","102"],
["&#x4fa;","&#x4c5;","82"],
["&#x4fa;","&#x4c4;","61"],
["&#x4fa;","&#x4c2;","41"],
["&#x4fa;","&#x4bf;","61"],
["&#x4fa;","&#x4be;","41"],
["&#x4fa;","&#x4bd;","61"],
["&#x4fa;","&#x4bc;","41"],
["&#x4fa;","&#x4bb;","61"],
["&#x4fa;","&#x4b9;","102"],
["&#x4fa;","&#x4b7;","102"],
["&#x4fa;","&#x4b4;","-41"],
["&#x4fa;","&#x4b3;","41"],
["&#x4fa;","&#x4ac;","-41"],
["&#x4fa;","&#x4ab;","82"],
["&#x4fa;","&#x4aa;","41"],
["&#x4fa;","&#x4a9;","82"],
["&#x4fa;","&#x4a8;","41"],
["&#x4fa;","&#x4a7;","61"],
["&#x4fa;","&#x4a5;","61"],
["&#x4fa;","&#x4a3;","61"],
["&#x4fa;","&#x4a0;","-41"],
["&#x4fa;","&#x49f;","-41"],
["&#x4fa;","&#x49d;","61"],
["&#x4fa;","&#x49b;","61"],
["&#x4fa;","&#x499;","41"],
["&#x4fa;","&#x497;","41"],
["&#x4fa;","&#x495;","61"],
["&#x4fa;","&#x48f;","61"],
["&#x4fa;","&#x48d;","-41"],
["&#x4fa;","&#x48b;","61"],
["&#x4fa;","&#x481;","82"],
["&#x4fa;","&#x480;","41"],
["&#x4fa;","&#x47e;","41"],
["&#x4fa;","&#x47d;","82"],
["&#x4fa;","&#x47c;","41"],
["&#x4fa;","&#x47b;","82"],
["&#x4fa;","&#x47a;","41"],
["&#x4fa;","&#x479;","82"],
["&#x4fa;","&#x478;","41"],
["&#x4fa;","&#x473;","82"],
["&#x4fa;","&#x472;","41"],
["&#x4fa;","&#x471;","61"],
["&#x4fa;","&#x46d;","61"],
["&#x4fa;","&#x46b;","41"],
["&#x4fa;","&#x469;","61"],
["&#x4fa;","&#x467;","102"],
["&#x4fa;","&#x466;","123"],
["&#x4fa;","&#x465;","61"],
["&#x4fa;","&#x460;","41"],
["&#x4fa;","&#x45d;","61"],
["&#x4fa;","&#x450;","82"],
["&#x4fa;","&#x201e;","102"],
["&#x4fa;","&#x201a;","102"],
["&#x4fa;","&#x2015;","41"],
["&#x4fa;","&#x2014;","41"],
["&#x4fa;","&#x2013;","41"],
["&#x4fa;","&#x491;","61"],
["&#x4fa;","&#x45f;","61"],
["&#x4fa;","&#x45c;","61"],
["&#x4fa;","&#x45b;","-41"],
["&#x4fa;","&#x45a;","61"],
["&#x4fa;","&#x459;","102"],
["&#x4fa;","&#x455;","61"],
["&#x4fa;","&#x454;","82"],
["&#x4fa;","&#x453;","61"],
["&#x4fa;","&#x452;","-41"],
["&#x4fa;","&#x451;","82"],
["&#x4fa;","&#x44e;","61"],
["&#x4fa;","&#x44d;","41"],
["&#x4fa;","&#x44c;","61"],
["&#x4fa;","&#x44b;","61"],
["&#x4fa;","&#x449;","61"],
["&#x4fa;","&#x448;","61"],
["&#x4fa;","&#x447;","102"],
["&#x4fa;","&#x446;","61"],
["&#x4fa;","&#x445;","41"],
["&#x4fa;","&#x444;","82"],
["&#x4fa;","&#x441;","82"],
["&#x4fa;","&#x440;","61"],
["&#x4fa;","&#x43f;","61"],
["&#x4fa;","&#x43e;","82"],
["&#x4fa;","&#x43d;","61"],
["&#x4fa;","&#x43c;","61"],
["&#x4fa;","&#x43b;","102"],
["&#x4fa;","&#x43a;","61"],
["&#x4fa;","&#x439;","61"],
["&#x4fa;","&#x438;","61"],
["&#x4fa;","&#x437;","41"],
["&#x4fa;","&#x436;","41"],
["&#x4fa;","&#x435;","82"],
["&#x4fa;","&#x434;","102"],
["&#x4fa;","&#x433;","61"],
["&#x4fa;","&#x432;","61"],
["&#x4fa;","&#x42a;","-41"],
["&#x4fa;","&#x424;","61"],
["&#x4fa;","&#x422;","-41"],
["&#x4fa;","&#x421;","41"],
["&#x4fa;","&#x41e;","41"],
["&#x4fa;","&#x41b;","82"],
["&#x4fa;","&#x414;","82"],
["&#x4fa;","&#x410;","123"],
["&#x4fa;","&#x40b;","-41"],
["&#x4fa;","&#x409;","82"],
["&#x4fa;","&#x404;","41"],
["&#x4fa;","&#x402;","-41"],
["&#x4fa;","&#x2e;","102"],
["&#x4fa;","&#x2d;","41"],
["&#x4fa;","&#x2c;","102"],
["&#x4fb;","&#x513;","61"],
["&#x4fb;","&#x511;","41"],
["&#x4fb;","&#x50d;","41"],
["&#x4fb;","&#x509;","61"],
["&#x4fb;","&#x503;","41"],
["&#x4fb;","&#x501;","41"],
["&#x4fb;","&#x4eb;","41"],
["&#x4fb;","&#x4e9;","41"],
["&#x4fb;","&#x4e7;","41"],
["&#x4fb;","&#x4d7;","41"],
["&#x4fb;","&#x4c6;","61"],
["&#x4fb;","&#x4ab;","41"],
["&#x4fb;","&#x4a9;","41"],
["&#x4fb;","&#x481;","41"],
["&#x4fb;","&#x47d;","41"],
["&#x4fb;","&#x47b;","41"],
["&#x4fb;","&#x479;","41"],
["&#x4fb;","&#x473;","41"],
["&#x4fb;","&#x467;","61"],
["&#x4fb;","&#x450;","41"],
["&#x4fb;","&#x201e;","61"],
["&#x4fb;","&#x201a;","61"],
["&#x4fb;","&#x459;","61"],
["&#x4fb;","&#x454;","41"],
["&#x4fb;","&#x451;","41"],
["&#x4fb;","&#x444;","41"],
["&#x4fb;","&#x441;","41"],
["&#x4fb;","&#x43e;","41"],
["&#x4fb;","&#x43b;","61"],
["&#x4fb;","&#x435;","41"],
["&#x4fb;","&#x434;","61"],
["&#x4fb;","&#x2e;","61"],
["&#x4fb;","&#x2c;","61"],
["&#x4fc;","&#x50f;","41"],
["&#x4fc;","&#x50c;","41"],
["&#x4fc;","&#x507;","41"],
["&#x4fc;","&#x505;","41"],
["&#x4fc;","&#x4f5;","82"],
["&#x4fc;","&#x4ea;","41"],
["&#x4fc;","&#x4e8;","41"],
["&#x4fc;","&#x4e6;","41"],
["&#x4fc;","&#x4cc;","82"],
["&#x4fc;","&#x4bf;","41"],
["&#x4fc;","&#x4be;","61"],
["&#x4fc;","&#x4bd;","41"],
["&#x4fc;","&#x4bc;","61"],
["&#x4fc;","&#x4b9;","82"],
["&#x4fc;","&#x4b7;","82"],
["&#x4fc;","&#x4b5;","41"],
["&#x4fc;","&#x4ad;","41"],
["&#x4fc;","&#x4aa;","41"],
["&#x4fc;","&#x4a8;","41"],
["&#x4fc;","&#x4a1;","41"],
["&#x4fc;","&#x480;","41"],
["&#x4fc;","&#x47e;","41"],
["&#x4fc;","&#x47c;","41"],
["&#x4fc;","&#x47a;","41"],
["&#x4fc;","&#x478;","41"],
["&#x4fc;","&#x472;","41"],
["&#x4fc;","&#x471;","20"],
["&#x4fc;","&#x46f;","-61"],
["&#x4fc;","&#x460;","41"],
["&#x4fc;","&#x44a;","41"],
["&#x4fc;","&#x447;","82"],
["&#x4fc;","&#x442;","41"],
["&#x4fc;","&#x424;","61"],
["&#x4fc;","&#x421;","41"],
["&#x4fc;","&#x41e;","41"],
["&#x4fc;","&#x408;","-225"],
["&#x4fc;","&#x404;","41"],
["&#x4fd;","&#x511;","20"],
["&#x4fd;","&#x50d;","20"],
["&#x4fd;","&#x507;","41"],
["&#x4fd;","&#x505;","41"],
["&#x4fd;","&#x503;","20"],
["&#x4fd;","&#x501;","20"],
["&#x4fd;","&#x4f5;","20"],
["&#x4fd;","&#x4eb;","20"],
["&#x4fd;","&#x4e9;","20"],
["&#x4fd;","&#x4e7;","20"],
["&#x4fd;","&#x4d7;","20"],
["&#x4fd;","&#x4cc;","20"],
["&#x4fd;","&#x4b9;","20"],
["&#x4fd;","&#x4b7;","20"],
["&#x4fd;","&#x4ab;","20"],
["&#x4fd;","&#x4a9;","20"],
["&#x4fd;","&#x481;","20"],
["&#x4fd;","&#x47d;","20"],
["&#x4fd;","&#x47b;","20"],
["&#x4fd;","&#x479;","20"],
["&#x4fd;","&#x473;","20"],
["&#x4fd;","&#x450;","20"],
["&#x4fd;","&#x454;","20"],
["&#x4fd;","&#x451;","20"],
["&#x4fd;","&#x447;","20"],
["&#x4fd;","&#x444;","20"],
["&#x4fd;","&#x441;","20"],
["&#x4fd;","&#x43e;","20"],
["&#x4fd;","&#x435;","20"],
["&#x4fe;","&#x510;","20"],
["&#x4fe;","&#x50c;","41"],
["&#x4fe;","&#x507;","41"],
["&#x4fe;","&#x505;","41"],
["&#x4fe;","&#x502;","41"],
["&#x4fe;","&#x500;","41"],
["&#x4fe;","&#x4f5;","41"],
["&#x4fe;","&#x4f4;","41"],
["&#x4fe;","&#x4ea;","41"],
["&#x4fe;","&#x4e8;","41"],
["&#x4fe;","&#x4e6;","41"],
["&#x4fe;","&#x4cc;","41"],
["&#x4fe;","&#x4cb;","41"],
["&#x4fe;","&#x4be;","102"],
["&#x4fe;","&#x4bc;","102"],
["&#x4fe;","&#x4b9;","41"],
["&#x4fe;","&#x4b8;","41"],
["&#x4fe;","&#x4b7;","41"],
["&#x4fe;","&#x4b6;","41"],
["&#x4fe;","&#x4aa;","41"],
["&#x4fe;","&#x4a8;","41"],
["&#x4fe;","&#x480;","41"],
["&#x4fe;","&#x47e;","41"],
["&#x4fe;","&#x47c;","41"],
["&#x4fe;","&#x47a;","41"],
["&#x4fe;","&#x478;","41"],
["&#x4fe;","&#x472;","41"],
["&#x4fe;","&#x470;","41"],
["&#x4fe;","&#x460;","41"],
["&#x4fe;","&#x447;","41"],
["&#x4fe;","&#x427;","41"],
["&#x4fe;","&#x424;","41"],
["&#x4fe;","&#x421;","41"],
["&#x4fe;","&#x41e;","41"],
["&#x4fe;","&#x404;","41"],
["&#x4ff;","&#x511;","20"],
["&#x4ff;","&#x50d;","20"],
["&#x4ff;","&#x507;","41"],
["&#x4ff;","&#x505;","41"],
["&#x4ff;","&#x503;","20"],
["&#x4ff;","&#x501;","20"],
["&#x4ff;","&#x4f5;","20"],
["&#x4ff;","&#x4eb;","20"],
["&#x4ff;","&#x4e9;","20"],
["&#x4ff;","&#x4e7;","20"],
["&#x4ff;","&#x4d7;","20"],
["&#x4ff;","&#x4cc;","20"],
["&#x4ff;","&#x4b9;","20"],
["&#x4ff;","&#x4b7;","20"],
["&#x4ff;","&#x4ab;","20"],
["&#x4ff;","&#x4a9;","20"],
["&#x4ff;","&#x481;","20"],
["&#x4ff;","&#x47d;","20"],
["&#x4ff;","&#x47b;","20"],
["&#x4ff;","&#x479;","20"],
["&#x4ff;","&#x473;","20"],
["&#x4ff;","&#x450;","20"],
["&#x4ff;","&#x454;","20"],
["&#x4ff;","&#x451;","20"],
["&#x4ff;","&#x447;","20"],
["&#x4ff;","&#x444;","20"],
["&#x4ff;","&#x441;","20"],
["&#x4ff;","&#x43e;","20"],
["&#x4ff;","&#x435;","20"],
["&#x502;","&#x50f;","61"],
["&#x502;","&#x50e;","82"],
["&#x502;","&#x507;","41"],
["&#x502;","&#x506;","41"],
["&#x502;","&#x505;","41"],
["&#x502;","&#x504;","41"],
["&#x502;","&#x4ff;","41"],
["&#x502;","&#x4fe;","61"],
["&#x502;","&#x4fd;","41"],
["&#x502;","&#x4fc;","61"],
["&#x502;","&#x4f5;","41"],
["&#x502;","&#x4f4;","61"],
["&#x502;","&#x4f2;","61"],
["&#x502;","&#x4f0;","61"],
["&#x502;","&#x4ee;","61"],
["&#x502;","&#x4dd;","41"],
["&#x502;","&#x4dc;","61"],
["&#x502;","&#x4d4;","61"],
["&#x502;","&#x4d2;","61"],
["&#x502;","&#x4d0;","61"],
["&#x502;","&#x4cc;","41"],
["&#x502;","&#x4cb;","61"],
["&#x502;","&#x4c2;","41"],
["&#x502;","&#x4c1;","61"],
["&#x502;","&#x4b9;","41"],
["&#x502;","&#x4b8;","61"],
["&#x502;","&#x4b7;","41"],
["&#x502;","&#x4b6;","61"],
["&#x502;","&#x4b5;","61"],
["&#x502;","&#x4b4;","82"],
["&#x502;","&#x4b3;","41"],
["&#x502;","&#x4b2;","61"],
["&#x502;","&#x4b0;","61"],
["&#x502;","&#x4ae;","61"],
["&#x502;","&#x4ad;","61"],
["&#x502;","&#x4ac;","143"],
["&#x502;","&#x4a1;","61"],
["&#x502;","&#x4a0;","82"],
["&#x502;","&#x497;","41"],
["&#x502;","&#x496;","61"],
["&#x502;","&#x476;","61"],
["&#x502;","&#x474;","61"],
["&#x502;","&#x470;","61"],
["&#x502;","&#x46a;","41"],
["&#x502;","&#x466;","61"],
["&#x502;","&#x201d;","102"],
["&#x502;","&#x2019;","102"],
["&#x502;","&#x44a;","61"],
["&#x502;","&#x447;","41"],
["&#x502;","&#x445;","41"],
["&#x502;","&#x442;","61"],
["&#x502;","&#x436;","41"],
["&#x502;","&#x42a;","82"],
["&#x502;","&#x427;","61"],
["&#x502;","&#x425;","61"],
["&#x502;","&#x423;","61"],
["&#x502;","&#x422;","143"],
["&#x502;","&#x416;","61"],
["&#x502;","&#x410;","61"],
["&#x502;","&#x40e;","61"],
["&#x502;","&#x40b;","82"],
["&#x502;","&#x402;","82"],
["&#x502;","&#x27;","102"],
["&#x502;","&#x22;","102"],
["&#x503;","&#x50f;","61"],
["&#x503;","&#x507;","102"],
["&#x503;","&#x505;","102"],
["&#x503;","&#x4ff;","41"],
["&#x503;","&#x4fd;","41"],
["&#x503;","&#x4f5;","41"],
["&#x503;","&#x4f3;","41"],
["&#x503;","&#x4f1;","41"],
["&#x503;","&#x4ef;","41"],
["&#x503;","&#x4dd;","41"],
["&#x503;","&#x4cc;","41"],
["&#x503;","&#x4c2;","41"],
["&#x503;","&#x4b9;","41"],
["&#x503;","&#x4b7;","41"],
["&#x503;","&#x4b5;","61"],
["&#x503;","&#x4b3;","41"],
["&#x503;","&#x4ad;","61"],
["&#x503;","&#x4a1;","61"],
["&#x503;","&#x497;","41"],
["&#x503;","&#x201d;","102"],
["&#x503;","&#x2019;","102"],
["&#x503;","&#x45e;","41"],
["&#x503;","&#x44a;","61"],
["&#x503;","&#x447;","41"],
["&#x503;","&#x445;","41"],
["&#x503;","&#x443;","41"],
["&#x503;","&#x442;","61"],
["&#x503;","&#x436;","41"],
["&#x503;","&#x27;","102"],
["&#x503;","&#x22;","102"],
["&#x504;","&#x50f;","61"],
["&#x504;","&#x50e;","82"],
["&#x504;","&#x507;","41"],
["&#x504;","&#x506;","41"],
["&#x504;","&#x505;","41"],
["&#x504;","&#x504;","41"],
["&#x504;","&#x4ff;","41"],
["&#x504;","&#x4fe;","61"],
["&#x504;","&#x4fd;","41"],
["&#x504;","&#x4fc;","61"],
["&#x504;","&#x4f5;","41"],
["&#x504;","&#x4f4;","61"],
["&#x504;","&#x4f2;","61"],
["&#x504;","&#x4f0;","61"],
["&#x504;","&#x4ee;","61"],
["&#x504;","&#x4dd;","41"],
["&#x504;","&#x4dc;","61"],
["&#x504;","&#x4d4;","61"],
["&#x504;","&#x4d2;","61"],
["&#x504;","&#x4d0;","61"],
["&#x504;","&#x4cc;","41"],
["&#x504;","&#x4cb;","61"],
["&#x504;","&#x4c2;","41"],
["&#x504;","&#x4c1;","61"],
["&#x504;","&#x4b9;","41"],
["&#x504;","&#x4b8;","61"],
["&#x504;","&#x4b7;","41"],
["&#x504;","&#x4b6;","61"],
["&#x504;","&#x4b5;","61"],
["&#x504;","&#x4b4;","82"],
["&#x504;","&#x4b3;","41"],
["&#x504;","&#x4b2;","61"],
["&#x504;","&#x4b0;","61"],
["&#x504;","&#x4ae;","61"],
["&#x504;","&#x4ad;","61"],
["&#x504;","&#x4ac;","143"],
["&#x504;","&#x4a1;","61"],
["&#x504;","&#x4a0;","82"],
["&#x504;","&#x497;","41"],
["&#x504;","&#x496;","61"],
["&#x504;","&#x476;","61"],
["&#x504;","&#x474;","61"],
["&#x504;","&#x470;","61"],
["&#x504;","&#x46a;","41"],
["&#x504;","&#x466;","61"],
["&#x504;","&#x201d;","102"],
["&#x504;","&#x2019;","102"],
["&#x504;","&#x44a;","61"],
["&#x504;","&#x447;","41"],
["&#x504;","&#x445;","41"],
["&#x504;","&#x442;","61"],
["&#x504;","&#x436;","41"],
["&#x504;","&#x42a;","82"],
["&#x504;","&#x427;","61"],
["&#x504;","&#x425;","61"],
["&#x504;","&#x423;","61"],
["&#x504;","&#x422;","143"],
["&#x504;","&#x416;","61"],
["&#x504;","&#x410;","61"],
["&#x504;","&#x40e;","61"],
["&#x504;","&#x40b;","82"],
["&#x504;","&#x402;","82"],
["&#x504;","&#x27;","102"],
["&#x504;","&#x22;","102"],
["&#x505;","&#x50f;","61"],
["&#x505;","&#x507;","102"],
["&#x505;","&#x505;","102"],
["&#x505;","&#x4ff;","41"],
["&#x505;","&#x4fd;","41"],
["&#x505;","&#x4f5;","41"],
["&#x505;","&#x4f3;","41"],
["&#x505;","&#x4f1;","41"],
["&#x505;","&#x4ef;","41"],
["&#x505;","&#x4dd;","41"],
["&#x505;","&#x4cc;","41"],
["&#x505;","&#x4c2;","41"],
["&#x505;","&#x4b9;","41"],
["&#x505;","&#x4b7;","41"],
["&#x505;","&#x4b5;","61"],
["&#x505;","&#x4b3;","41"],
["&#x505;","&#x4ad;","61"],
["&#x505;","&#x4a1;","61"],
["&#x505;","&#x497;","41"],
["&#x505;","&#x201d;","102"],
["&#x505;","&#x2019;","102"],
["&#x505;","&#x45e;","41"],
["&#x505;","&#x44a;","61"],
["&#x505;","&#x447;","41"],
["&#x505;","&#x445;","41"],
["&#x505;","&#x443;","41"],
["&#x505;","&#x442;","61"],
["&#x505;","&#x436;","41"],
["&#x505;","&#x27;","102"],
["&#x505;","&#x22;","102"],
["&#x506;","&#x507;","41"],
["&#x506;","&#x505;","41"],
["&#x506;","&#x4e1;","-41"],
["&#x506;","&#x408;","-225"],
["&#x507;","&#x201d;","20"],
["&#x507;","&#x2019;","20"],
["&#x507;","&#x27;","20"],
["&#x507;","&#x22;","20"],
["&#x508;","&#x50f;","61"],
["&#x508;","&#x50e;","82"],
["&#x508;","&#x507;","41"],
["&#x508;","&#x506;","41"],
["&#x508;","&#x505;","41"],
["&#x508;","&#x504;","41"],
["&#x508;","&#x4ff;","41"],
["&#x508;","&#x4fe;","61"],
["&#x508;","&#x4fd;","41"],
["&#x508;","&#x4fc;","61"],
["&#x508;","&#x4f5;","41"],
["&#x508;","&#x4f4;","61"],
["&#x508;","&#x4f2;","61"],
["&#x508;","&#x4f0;","61"],
["&#x508;","&#x4ee;","61"],
["&#x508;","&#x4dd;","41"],
["&#x508;","&#x4dc;","61"],
["&#x508;","&#x4d4;","61"],
["&#x508;","&#x4d2;","61"],
["&#x508;","&#x4d0;","61"],
["&#x508;","&#x4cc;","41"],
["&#x508;","&#x4cb;","61"],
["&#x508;","&#x4c2;","41"],
["&#x508;","&#x4c1;","61"],
["&#x508;","&#x4b9;","41"],
["&#x508;","&#x4b8;","61"],
["&#x508;","&#x4b7;","41"],
["&#x508;","&#x4b6;","61"],
["&#x508;","&#x4b5;","61"],
["&#x508;","&#x4b4;","82"],
["&#x508;","&#x4b3;","41"],
["&#x508;","&#x4b2;","61"],
["&#x508;","&#x4b0;","61"],
["&#x508;","&#x4ae;","61"],
["&#x508;","&#x4ad;","61"],
["&#x508;","&#x4ac;","143"],
["&#x508;","&#x4a1;","61"],
["&#x508;","&#x4a0;","82"],
["&#x508;","&#x497;","41"],
["&#x508;","&#x496;","61"],
["&#x508;","&#x476;","61"],
["&#x508;","&#x474;","61"],
["&#x508;","&#x470;","61"],
["&#x508;","&#x46a;","41"],
["&#x508;","&#x466;","61"],
["&#x508;","&#x201d;","102"],
["&#x508;","&#x2019;","102"],
["&#x508;","&#x44a;","61"],
["&#x508;","&#x447;","41"],
["&#x508;","&#x445;","41"],
["&#x508;","&#x442;","61"],
["&#x508;","&#x436;","41"],
["&#x508;","&#x42a;","82"],
["&#x508;","&#x427;","61"],
["&#x508;","&#x425;","61"],
["&#x508;","&#x423;","61"],
["&#x508;","&#x422;","143"],
["&#x508;","&#x416;","61"],
["&#x508;","&#x410;","61"],
["&#x508;","&#x40e;","61"],
["&#x508;","&#x40b;","82"],
["&#x508;","&#x402;","82"],
["&#x508;","&#x27;","102"],
["&#x508;","&#x22;","102"],
["&#x509;","&#x50f;","61"],
["&#x509;","&#x507;","102"],
["&#x509;","&#x505;","102"],
["&#x509;","&#x4ff;","41"],
["&#x509;","&#x4fd;","41"],
["&#x509;","&#x4f5;","41"],
["&#x509;","&#x4f3;","41"],
["&#x509;","&#x4f1;","41"],
["&#x509;","&#x4ef;","41"],
["&#x509;","&#x4dd;","41"],
["&#x509;","&#x4cc;","41"],
["&#x509;","&#x4c2;","41"],
["&#x509;","&#x4b9;","41"],
["&#x509;","&#x4b7;","41"],
["&#x509;","&#x4b5;","61"],
["&#x509;","&#x4b3;","41"],
["&#x509;","&#x4ad;","61"],
["&#x509;","&#x4a1;","61"],
["&#x509;","&#x497;","41"],
["&#x509;","&#x201d;","102"],
["&#x509;","&#x2019;","102"],
["&#x509;","&#x45e;","41"],
["&#x509;","&#x44a;","61"],
["&#x509;","&#x447;","41"],
["&#x509;","&#x445;","41"],
["&#x509;","&#x443;","41"],
["&#x509;","&#x442;","61"],
["&#x509;","&#x436;","41"],
["&#x509;","&#x27;","102"],
["&#x509;","&#x22;","102"],
["&#x50a;","&#x50f;","61"],
["&#x50a;","&#x50e;","82"],
["&#x50a;","&#x507;","41"],
["&#x50a;","&#x506;","41"],
["&#x50a;","&#x505;","41"],
["&#x50a;","&#x504;","41"],
["&#x50a;","&#x4ff;","41"],
["&#x50a;","&#x4fe;","61"],
["&#x50a;","&#x4fd;","41"],
["&#x50a;","&#x4fc;","61"],
["&#x50a;","&#x4f5;","41"],
["&#x50a;","&#x4f4;","61"],
["&#x50a;","&#x4f2;","61"],
["&#x50a;","&#x4f0;","61"],
["&#x50a;","&#x4ee;","61"],
["&#x50a;","&#x4dd;","41"],
["&#x50a;","&#x4dc;","61"],
["&#x50a;","&#x4d4;","61"],
["&#x50a;","&#x4d2;","61"],
["&#x50a;","&#x4d0;","61"],
["&#x50a;","&#x4cc;","41"],
["&#x50a;","&#x4cb;","61"],
["&#x50a;","&#x4c2;","41"],
["&#x50a;","&#x4c1;","61"],
["&#x50a;","&#x4b9;","41"],
["&#x50a;","&#x4b8;","61"],
["&#x50a;","&#x4b7;","41"],
["&#x50a;","&#x4b6;","61"],
["&#x50a;","&#x4b5;","61"],
["&#x50a;","&#x4b4;","82"],
["&#x50a;","&#x4b3;","41"],
["&#x50a;","&#x4b2;","61"],
["&#x50a;","&#x4b0;","61"],
["&#x50a;","&#x4ae;","61"],
["&#x50a;","&#x4ad;","61"],
["&#x50a;","&#x4ac;","143"],
["&#x50a;","&#x4a1;","61"],
["&#x50a;","&#x4a0;","82"],
["&#x50a;","&#x497;","41"],
["&#x50a;","&#x496;","61"],
["&#x50a;","&#x476;","61"],
["&#x50a;","&#x474;","61"],
["&#x50a;","&#x470;","61"],
["&#x50a;","&#x46a;","41"],
["&#x50a;","&#x466;","61"],
["&#x50a;","&#x201d;","102"],
["&#x50a;","&#x2019;","102"],
["&#x50a;","&#x44a;","61"],
["&#x50a;","&#x447;","41"],
["&#x50a;","&#x445;","41"],
["&#x50a;","&#x442;","61"],
["&#x50a;","&#x436;","41"],
["&#x50a;","&#x42a;","82"],
["&#x50a;","&#x427;","61"],
["&#x50a;","&#x425;","61"],
["&#x50a;","&#x423;","61"],
["&#x50a;","&#x422;","143"],
["&#x50a;","&#x416;","61"],
["&#x50a;","&#x410;","61"],
["&#x50a;","&#x40e;","61"],
["&#x50a;","&#x40b;","82"],
["&#x50a;","&#x402;","82"],
["&#x50a;","&#x27;","102"],
["&#x50a;","&#x22;","102"],
["&#x50b;","&#x50f;","61"],
["&#x50b;","&#x507;","102"],
["&#x50b;","&#x505;","102"],
["&#x50b;","&#x4ff;","41"],
["&#x50b;","&#x4fd;","41"],
["&#x50b;","&#x4f5;","41"],
["&#x50b;","&#x4f3;","41"],
["&#x50b;","&#x4f1;","41"],
["&#x50b;","&#x4ef;","41"],
["&#x50b;","&#x4dd;","41"],
["&#x50b;","&#x4cc;","41"],
["&#x50b;","&#x4c2;","41"],
["&#x50b;","&#x4b9;","41"],
["&#x50b;","&#x4b7;","41"],
["&#x50b;","&#x4b5;","61"],
["&#x50b;","&#x4b3;","41"],
["&#x50b;","&#x4ad;","61"],
["&#x50b;","&#x4a1;","61"],
["&#x50b;","&#x497;","41"],
["&#x50b;","&#x201d;","102"],
["&#x50b;","&#x2019;","102"],
["&#x50b;","&#x45e;","41"],
["&#x50b;","&#x44a;","61"],
["&#x50b;","&#x447;","41"],
["&#x50b;","&#x445;","41"],
["&#x50b;","&#x443;","41"],
["&#x50b;","&#x442;","61"],
["&#x50b;","&#x436;","41"],
["&#x50b;","&#x27;","102"],
["&#x50b;","&#x22;","102"],
["&#x50c;","&#x4fe;","41"],
["&#x50c;","&#x4fc;","41"],
["&#x50c;","&#x4dc;","41"],
["&#x50c;","&#x4d4;","20"],
["&#x50c;","&#x4d2;","20"],
["&#x50c;","&#x4d0;","20"],
["&#x50c;","&#x4c1;","41"],
["&#x50c;","&#x4b2;","41"],
["&#x50c;","&#x4b0;","20"],
["&#x50c;","&#x4ae;","20"],
["&#x50c;","&#x4ac;","41"],
["&#x50c;","&#x496;","41"],
["&#x50c;","&#x476;","20"],
["&#x50c;","&#x474;","20"],
["&#x50c;","&#x466;","20"],
["&#x50c;","&#x201e;","82"],
["&#x50c;","&#x201a;","82"],
["&#x50c;","&#x425;","41"],
["&#x50c;","&#x422;","41"],
["&#x50c;","&#x416;","41"],
["&#x50c;","&#x410;","20"],
["&#x50c;","&#x2e;","82"],
["&#x50c;","&#x2c;","82"],
["&#x50d;","&#x507;","41"],
["&#x50d;","&#x505;","41"],
["&#x50d;","&#x4ff;","20"],
["&#x50d;","&#x4fd;","20"],
["&#x50d;","&#x4f3;","20"],
["&#x50d;","&#x4f1;","20"],
["&#x50d;","&#x4ef;","20"],
["&#x50d;","&#x4dd;","20"],
["&#x50d;","&#x4c2;","20"],
["&#x50d;","&#x4b3;","20"],
["&#x50d;","&#x497;","20"],
["&#x50d;","&#x201d;","41"],
["&#x50d;","&#x2019;","41"],
["&#x50d;","&#x45e;","20"],
["&#x50d;","&#x445;","20"],
["&#x50d;","&#x443;","20"],
["&#x50d;","&#x436;","20"],
["&#x50d;","&#x27;","41"],
["&#x50d;","&#x22;","41"],
["&#x50e;","&#x50f;","41"],
["&#x50e;","&#x50e;","61"],
["&#x50e;","&#x506;","41"],
["&#x50e;","&#x504;","41"],
["&#x50e;","&#x4fe;","41"],
["&#x50e;","&#x4fc;","41"],
["&#x50e;","&#x4f4;","41"],
["&#x50e;","&#x4dc;","41"],
["&#x50e;","&#x4d4;","41"],
["&#x50e;","&#x4d2;","41"],
["&#x50e;","&#x4d0;","41"],
["&#x50e;","&#x4cb;","41"],
["&#x50e;","&#x4c1;","41"],
["&#x50e;","&#x4b8;","41"],
["&#x50e;","&#x4b6;","41"],
["&#x50e;","&#x4b5;","41"],
["&#x50e;","&#x4b4;","61"],
["&#x50e;","&#x4b2;","41"],
["&#x50e;","&#x4b0;","41"],
["&#x50e;","&#x4ae;","41"],
["&#x50e;","&#x4ad;","41"],
["&#x50e;","&#x4ac;","61"],
["&#x50e;","&#x4a1;","41"],
["&#x50e;","&#x4a0;","61"],
["&#x50e;","&#x496;","41"],
["&#x50e;","&#x476;","41"],
["&#x50e;","&#x474;","41"],
["&#x50e;","&#x470;","41"],
["&#x50e;","&#x466;","41"],
["&#x50e;","&#x201d;","82"],
["&#x50e;","&#x2019;","82"],
["&#x50e;","&#x44a;","41"],
["&#x50e;","&#x442;","41"],
["&#x50e;","&#x42a;","61"],
["&#x50e;","&#x427;","41"],
["&#x50e;","&#x425;","41"],
["&#x50e;","&#x422;","61"],
["&#x50e;","&#x416;","41"],
["&#x50e;","&#x410;","41"],
["&#x50e;","&#x40b;","61"],
["&#x50e;","&#x402;","61"],
["&#x50e;","&#x27;","82"],
["&#x50e;","&#x22;","82"],
["&#x50f;","&#x50f;","61"],
["&#x50f;","&#x507;","102"],
["&#x50f;","&#x505;","102"],
["&#x50f;","&#x4ff;","41"],
["&#x50f;","&#x4fd;","41"],
["&#x50f;","&#x4f5;","41"],
["&#x50f;","&#x4f3;","41"],
["&#x50f;","&#x4f1;","41"],
["&#x50f;","&#x4ef;","41"],
["&#x50f;","&#x4dd;","41"],
["&#x50f;","&#x4cc;","41"],
["&#x50f;","&#x4c2;","41"],
["&#x50f;","&#x4b9;","41"],
["&#x50f;","&#x4b7;","41"],
["&#x50f;","&#x4b5;","61"],
["&#x50f;","&#x4b3;","41"],
["&#x50f;","&#x4ad;","61"],
["&#x50f;","&#x4a1;","61"],
["&#x50f;","&#x497;","41"],
["&#x50f;","&#x201d;","102"],
["&#x50f;","&#x2019;","102"],
["&#x50f;","&#x45e;","41"],
["&#x50f;","&#x44a;","61"],
["&#x50f;","&#x447;","41"],
["&#x50f;","&#x445;","41"],
["&#x50f;","&#x443;","41"],
["&#x50f;","&#x442;","61"],
["&#x50f;","&#x436;","41"],
["&#x50f;","&#x27;","102"],
["&#x50f;","&#x22;","102"],
["&#x510;","&#x4f5;","41"],
["&#x510;","&#x4cc;","41"],
["&#x510;","&#x4b9;","41"],
["&#x510;","&#x4b7;","41"],
["&#x510;","&#x447;","41"],
["&#x512;","&#x507;","41"],
["&#x512;","&#x505;","41"],
["&#x512;","&#x4e1;","-41"],
["&#x512;","&#x408;","-225"],
["&#x513;","&#x201d;","20"],
["&#x513;","&#x2019;","20"],
["&#x513;","&#x27;","20"],
["&#x513;","&#x22;","20"],
["&#x1ea0;","&#x162;","143"],
["&#x1ea0;","&#x1ef8;","123"],
["&#x1ea0;","&#x1ef6;","123"],
["&#x1ea0;","&#x1ef4;","123"],
["&#x1ea0;","&#x1ee2;","41"],
["&#x1ea0;","&#x1ee0;","41"],
["&#x1ea0;","&#x1ede;","41"],
["&#x1ea0;","&#x1edc;","41"],
["&#x1ea0;","&#x1eda;","41"],
["&#x1ea0;","&#x1ed8;","41"],
["&#x1ea0;","&#x1ed6;","41"],
["&#x1ea0;","&#x1ed4;","41"],
["&#x1ea0;","&#x1ed2;","41"],
["&#x1ea0;","&#x1ed0;","41"],
["&#x1ea0;","&#x1ece;","41"],
["&#x1ea0;","&#x1ecc;","41"],
["&#x1ea0;","&#x1a0;","41"],
["&#x1ea0;","&#x201d;","143"],
["&#x1ea0;","&#x2019;","143"],
["&#x1ea0;","&#x1ef2;","123"],
["&#x1ea0;","&#x1e84;","82"],
["&#x1ea0;","&#x1e82;","82"],
["&#x1ea0;","&#x1e80;","82"],
["&#x1ea0;","&#x1fe;","41"],
["&#x1ea0;","&#x178;","123"],
["&#x1ea0;","&#x176;","123"],
["&#x1ea0;","&#x174;","82"],
["&#x1ea0;","&#x164;","143"],
["&#x1ea0;","&#x21a;","143"],
["&#x1ea0;","&#x152;","41"],
["&#x1ea0;","&#x150;","41"],
["&#x1ea0;","&#x14e;","41"],
["&#x1ea0;","&#x14c;","41"],
["&#x1ea0;","&#x122;","41"],
["&#x1ea0;","&#x120;","41"],
["&#x1ea0;","&#x11e;","41"],
["&#x1ea0;","&#x11c;","41"],
["&#x1ea0;","&#x10c;","41"],
["&#x1ea0;","&#x10a;","41"],
["&#x1ea0;","&#x108;","41"],
["&#x1ea0;","&#x106;","41"],
["&#x1ea0;","&#xdd;","123"],
["&#x1ea0;","&#xd8;","41"],
["&#x1ea0;","&#xd6;","41"],
["&#x1ea0;","&#xd5;","41"],
["&#x1ea0;","&#xd4;","41"],
["&#x1ea0;","&#xd3;","41"],
["&#x1ea0;","&#xd2;","41"],
["&#x1ea0;","&#xc7;","41"],
["&#x1ea0;","Y","123"],
["&#x1ea0;","W","82"],
["&#x1ea0;","V","82"],
["&#x1ea0;","T","143"],
["&#x1ea0;","Q","41"],
["&#x1ea0;","O","41"],
["&#x1ea0;","J","-266"],
["&#x1ea0;","G","41"],
["&#x1ea0;","C","41"],
["&#x1ea0;","&#x27;","143"],
["&#x1ea0;","&#x22;","143"],
["&#x1ea1;","&#x201d;","20"],
["&#x1ea1;","&#x2019;","20"],
["&#x1ea1;","&#x27;","20"],
["&#x1ea1;","&#x22;","20"],
["&#x1ea2;","&#x162;","143"],
["&#x1ea2;","&#x1ef8;","123"],
["&#x1ea2;","&#x1ef6;","123"],
["&#x1ea2;","&#x1ef4;","123"],
["&#x1ea2;","&#x1ee2;","41"],
["&#x1ea2;","&#x1ee0;","41"],
["&#x1ea2;","&#x1ede;","41"],
["&#x1ea2;","&#x1edc;","41"],
["&#x1ea2;","&#x1eda;","41"],
["&#x1ea2;","&#x1ed8;","41"],
["&#x1ea2;","&#x1ed6;","41"],
["&#x1ea2;","&#x1ed4;","41"],
["&#x1ea2;","&#x1ed2;","41"],
["&#x1ea2;","&#x1ed0;","41"],
["&#x1ea2;","&#x1ece;","41"],
["&#x1ea2;","&#x1ecc;","41"],
["&#x1ea2;","&#x1a0;","41"],
["&#x1ea2;","&#x201d;","143"],
["&#x1ea2;","&#x2019;","143"],
["&#x1ea2;","&#x1ef2;","123"],
["&#x1ea2;","&#x1e84;","82"],
["&#x1ea2;","&#x1e82;","82"],
["&#x1ea2;","&#x1e80;","82"],
["&#x1ea2;","&#x1fe;","41"],
["&#x1ea2;","&#x178;","123"],
["&#x1ea2;","&#x176;","123"],
["&#x1ea2;","&#x174;","82"],
["&#x1ea2;","&#x164;","143"],
["&#x1ea2;","&#x21a;","143"],
["&#x1ea2;","&#x152;","41"],
["&#x1ea2;","&#x150;","41"],
["&#x1ea2;","&#x14e;","41"],
["&#x1ea2;","&#x14c;","41"],
["&#x1ea2;","&#x122;","41"],
["&#x1ea2;","&#x120;","41"],
["&#x1ea2;","&#x11e;","41"],
["&#x1ea2;","&#x11c;","41"],
["&#x1ea2;","&#x10c;","41"],
["&#x1ea2;","&#x10a;","41"],
["&#x1ea2;","&#x108;","41"],
["&#x1ea2;","&#x106;","41"],
["&#x1ea2;","&#xdd;","123"],
["&#x1ea2;","&#xd8;","41"],
["&#x1ea2;","&#xd6;","41"],
["&#x1ea2;","&#xd5;","41"],
["&#x1ea2;","&#xd4;","41"],
["&#x1ea2;","&#xd3;","41"],
["&#x1ea2;","&#xd2;","41"],
["&#x1ea2;","&#xc7;","41"],
["&#x1ea2;","Y","123"],
["&#x1ea2;","W","82"],
["&#x1ea2;","V","82"],
["&#x1ea2;","T","143"],
["&#x1ea2;","Q","41"],
["&#x1ea2;","O","41"],
["&#x1ea2;","J","-266"],
["&#x1ea2;","G","41"],
["&#x1ea2;","C","41"],
["&#x1ea2;","&#x27;","143"],
["&#x1ea2;","&#x22;","143"],
["&#x1ea3;","&#x201d;","20"],
["&#x1ea3;","&#x2019;","20"],
["&#x1ea3;","&#x27;","20"],
["&#x1ea3;","&#x22;","20"],
["&#x1ea4;","&#x162;","143"],
["&#x1ea4;","&#x1ef8;","123"],
["&#x1ea4;","&#x1ef6;","123"],
["&#x1ea4;","&#x1ef4;","123"],
["&#x1ea4;","&#x1ee2;","41"],
["&#x1ea4;","&#x1ee0;","41"],
["&#x1ea4;","&#x1ede;","41"],
["&#x1ea4;","&#x1edc;","41"],
["&#x1ea4;","&#x1eda;","41"],
["&#x1ea4;","&#x1ed8;","41"],
["&#x1ea4;","&#x1ed6;","41"],
["&#x1ea4;","&#x1ed4;","41"],
["&#x1ea4;","&#x1ed2;","41"],
["&#x1ea4;","&#x1ed0;","41"],
["&#x1ea4;","&#x1ece;","41"],
["&#x1ea4;","&#x1ecc;","41"],
["&#x1ea4;","&#x1a0;","41"],
["&#x1ea4;","&#x201d;","143"],
["&#x1ea4;","&#x2019;","143"],
["&#x1ea4;","&#x1ef2;","123"],
["&#x1ea4;","&#x1e84;","82"],
["&#x1ea4;","&#x1e82;","82"],
["&#x1ea4;","&#x1e80;","82"],
["&#x1ea4;","&#x1fe;","41"],
["&#x1ea4;","&#x178;","123"],
["&#x1ea4;","&#x176;","123"],
["&#x1ea4;","&#x174;","82"],
["&#x1ea4;","&#x164;","143"],
["&#x1ea4;","&#x21a;","143"],
["&#x1ea4;","&#x152;","41"],
["&#x1ea4;","&#x150;","41"],
["&#x1ea4;","&#x14e;","41"],
["&#x1ea4;","&#x14c;","41"],
["&#x1ea4;","&#x122;","41"],
["&#x1ea4;","&#x120;","41"],
["&#x1ea4;","&#x11e;","41"],
["&#x1ea4;","&#x11c;","41"],
["&#x1ea4;","&#x10c;","41"],
["&#x1ea4;","&#x10a;","41"],
["&#x1ea4;","&#x108;","41"],
["&#x1ea4;","&#x106;","41"],
["&#x1ea4;","&#xdd;","123"],
["&#x1ea4;","&#xd8;","41"],
["&#x1ea4;","&#xd6;","41"],
["&#x1ea4;","&#xd5;","41"],
["&#x1ea4;","&#xd4;","41"],
["&#x1ea4;","&#xd3;","41"],
["&#x1ea4;","&#xd2;","41"],
["&#x1ea4;","&#xc7;","41"],
["&#x1ea4;","Y","123"],
["&#x1ea4;","W","82"],
["&#x1ea4;","V","82"],
["&#x1ea4;","T","143"],
["&#x1ea4;","Q","41"],
["&#x1ea4;","O","41"],
["&#x1ea4;","J","-266"],
["&#x1ea4;","G","41"],
["&#x1ea4;","C","41"],
["&#x1ea4;","&#x27;","143"],
["&#x1ea4;","&#x22;","143"],
["&#x1ea5;","&#x201d;","20"],
["&#x1ea5;","&#x2019;","20"],
["&#x1ea5;","&#x27;","20"],
["&#x1ea5;","&#x22;","20"],
["&#x1ea6;","&#x162;","143"],
["&#x1ea6;","&#x1ef8;","123"],
["&#x1ea6;","&#x1ef6;","123"],
["&#x1ea6;","&#x1ef4;","123"],
["&#x1ea6;","&#x1ee2;","41"],
["&#x1ea6;","&#x1ee0;","41"],
["&#x1ea6;","&#x1ede;","41"],
["&#x1ea6;","&#x1edc;","41"],
["&#x1ea6;","&#x1eda;","41"],
["&#x1ea6;","&#x1ed8;","41"],
["&#x1ea6;","&#x1ed6;","41"],
["&#x1ea6;","&#x1ed4;","41"],
["&#x1ea6;","&#x1ed2;","41"],
["&#x1ea6;","&#x1ed0;","41"],
["&#x1ea6;","&#x1ece;","41"],
["&#x1ea6;","&#x1ecc;","41"],
["&#x1ea6;","&#x1a0;","41"],
["&#x1ea6;","&#x201d;","143"],
["&#x1ea6;","&#x2019;","143"],
["&#x1ea6;","&#x1ef2;","123"],
["&#x1ea6;","&#x1e84;","82"],
["&#x1ea6;","&#x1e82;","82"],
["&#x1ea6;","&#x1e80;","82"],
["&#x1ea6;","&#x1fe;","41"],
["&#x1ea6;","&#x178;","123"],
["&#x1ea6;","&#x176;","123"],
["&#x1ea6;","&#x174;","82"],
["&#x1ea6;","&#x164;","143"],
["&#x1ea6;","&#x21a;","143"],
["&#x1ea6;","&#x152;","41"],
["&#x1ea6;","&#x150;","41"],
["&#x1ea6;","&#x14e;","41"],
["&#x1ea6;","&#x14c;","41"],
["&#x1ea6;","&#x122;","41"],
["&#x1ea6;","&#x120;","41"],
["&#x1ea6;","&#x11e;","41"],
["&#x1ea6;","&#x11c;","41"],
["&#x1ea6;","&#x10c;","41"],
["&#x1ea6;","&#x10a;","41"],
["&#x1ea6;","&#x108;","41"],
["&#x1ea6;","&#x106;","41"],
["&#x1ea6;","&#xdd;","123"],
["&#x1ea6;","&#xd8;","41"],
["&#x1ea6;","&#xd6;","41"],
["&#x1ea6;","&#xd5;","41"],
["&#x1ea6;","&#xd4;","41"],
["&#x1ea6;","&#xd3;","41"],
["&#x1ea6;","&#xd2;","41"],
["&#x1ea6;","&#xc7;","41"],
["&#x1ea6;","Y","123"],
["&#x1ea6;","W","82"],
["&#x1ea6;","V","82"],
["&#x1ea6;","T","143"],
["&#x1ea6;","Q","41"],
["&#x1ea6;","O","41"],
["&#x1ea6;","J","-266"],
["&#x1ea6;","G","41"],
["&#x1ea6;","C","41"],
["&#x1ea6;","&#x27;","143"],
["&#x1ea6;","&#x22;","143"],
["&#x1ea7;","&#x201d;","20"],
["&#x1ea7;","&#x2019;","20"],
["&#x1ea7;","&#x27;","20"],
["&#x1ea7;","&#x22;","20"],
["&#x1ea8;","&#x162;","143"],
["&#x1ea8;","&#x1ef8;","123"],
["&#x1ea8;","&#x1ef6;","123"],
["&#x1ea8;","&#x1ef4;","123"],
["&#x1ea8;","&#x1ee2;","41"],
["&#x1ea8;","&#x1ee0;","41"],
["&#x1ea8;","&#x1ede;","41"],
["&#x1ea8;","&#x1edc;","41"],
["&#x1ea8;","&#x1eda;","41"],
["&#x1ea8;","&#x1ed8;","41"],
["&#x1ea8;","&#x1ed6;","41"],
["&#x1ea8;","&#x1ed4;","41"],
["&#x1ea8;","&#x1ed2;","41"],
["&#x1ea8;","&#x1ed0;","41"],
["&#x1ea8;","&#x1ece;","41"],
["&#x1ea8;","&#x1ecc;","41"],
["&#x1ea8;","&#x1a0;","41"],
["&#x1ea8;","&#x201d;","143"],
["&#x1ea8;","&#x2019;","143"],
["&#x1ea8;","&#x1ef2;","123"],
["&#x1ea8;","&#x1e84;","82"],
["&#x1ea8;","&#x1e82;","82"],
["&#x1ea8;","&#x1e80;","82"],
["&#x1ea8;","&#x1fe;","41"],
["&#x1ea8;","&#x178;","123"],
["&#x1ea8;","&#x176;","123"],
["&#x1ea8;","&#x174;","82"],
["&#x1ea8;","&#x164;","143"],
["&#x1ea8;","&#x21a;","143"],
["&#x1ea8;","&#x152;","41"],
["&#x1ea8;","&#x150;","41"],
["&#x1ea8;","&#x14e;","41"],
["&#x1ea8;","&#x14c;","41"],
["&#x1ea8;","&#x122;","41"],
["&#x1ea8;","&#x120;","41"],
["&#x1ea8;","&#x11e;","41"],
["&#x1ea8;","&#x11c;","41"],
["&#x1ea8;","&#x10c;","41"],
["&#x1ea8;","&#x10a;","41"],
["&#x1ea8;","&#x108;","41"],
["&#x1ea8;","&#x106;","41"],
["&#x1ea8;","&#xdd;","123"],
["&#x1ea8;","&#xd8;","41"],
["&#x1ea8;","&#xd6;","41"],
["&#x1ea8;","&#xd5;","41"],
["&#x1ea8;","&#xd4;","41"],
["&#x1ea8;","&#xd3;","41"],
["&#x1ea8;","&#xd2;","41"],
["&#x1ea8;","&#xc7;","41"],
["&#x1ea8;","Y","123"],
["&#x1ea8;","W","82"],
["&#x1ea8;","V","82"],
["&#x1ea8;","T","143"],
["&#x1ea8;","Q","41"],
["&#x1ea8;","O","41"],
["&#x1ea8;","J","-266"],
["&#x1ea8;","G","41"],
["&#x1ea8;","C","41"],
["&#x1ea8;","&#x27;","143"],
["&#x1ea8;","&#x22;","143"],
["&#x1ea9;","&#x201d;","20"],
["&#x1ea9;","&#x2019;","20"],
["&#x1ea9;","&#x27;","20"],
["&#x1ea9;","&#x22;","20"],
["&#x1eaa;","&#x162;","143"],
["&#x1eaa;","&#x1ef8;","123"],
["&#x1eaa;","&#x1ef6;","123"],
["&#x1eaa;","&#x1ef4;","123"],
["&#x1eaa;","&#x1ee2;","41"],
["&#x1eaa;","&#x1ee0;","41"],
["&#x1eaa;","&#x1ede;","41"],
["&#x1eaa;","&#x1edc;","41"],
["&#x1eaa;","&#x1eda;","41"],
["&#x1eaa;","&#x1ed8;","41"],
["&#x1eaa;","&#x1ed6;","41"],
["&#x1eaa;","&#x1ed4;","41"],
["&#x1eaa;","&#x1ed2;","41"],
["&#x1eaa;","&#x1ed0;","41"],
["&#x1eaa;","&#x1ece;","41"],
["&#x1eaa;","&#x1ecc;","41"],
["&#x1eaa;","&#x1a0;","41"],
["&#x1eaa;","&#x201d;","143"],
["&#x1eaa;","&#x2019;","143"],
["&#x1eaa;","&#x1ef2;","123"],
["&#x1eaa;","&#x1e84;","82"],
["&#x1eaa;","&#x1e82;","82"],
["&#x1eaa;","&#x1e80;","82"],
["&#x1eaa;","&#x1fe;","41"],
["&#x1eaa;","&#x178;","123"],
["&#x1eaa;","&#x176;","123"],
["&#x1eaa;","&#x174;","82"],
["&#x1eaa;","&#x164;","143"],
["&#x1eaa;","&#x21a;","143"],
["&#x1eaa;","&#x152;","41"],
["&#x1eaa;","&#x150;","41"],
["&#x1eaa;","&#x14e;","41"],
["&#x1eaa;","&#x14c;","41"],
["&#x1eaa;","&#x122;","41"],
["&#x1eaa;","&#x120;","41"],
["&#x1eaa;","&#x11e;","41"],
["&#x1eaa;","&#x11c;","41"],
["&#x1eaa;","&#x10c;","41"],
["&#x1eaa;","&#x10a;","41"],
["&#x1eaa;","&#x108;","41"],
["&#x1eaa;","&#x106;","41"],
["&#x1eaa;","&#xdd;","123"],
["&#x1eaa;","&#xd8;","41"],
["&#x1eaa;","&#xd6;","41"],
["&#x1eaa;","&#xd5;","41"],
["&#x1eaa;","&#xd4;","41"],
["&#x1eaa;","&#xd3;","41"],
["&#x1eaa;","&#xd2;","41"],
["&#x1eaa;","&#xc7;","41"],
["&#x1eaa;","Y","123"],
["&#x1eaa;","W","82"],
["&#x1eaa;","V","82"],
["&#x1eaa;","T","143"],
["&#x1eaa;","Q","41"],
["&#x1eaa;","O","41"],
["&#x1eaa;","J","-266"],
["&#x1eaa;","G","41"],
["&#x1eaa;","C","41"],
["&#x1eaa;","&#x27;","143"],
["&#x1eaa;","&#x22;","143"],
["&#x1eab;","&#x201d;","20"],
["&#x1eab;","&#x2019;","20"],
["&#x1eab;","&#x27;","20"],
["&#x1eab;","&#x22;","20"],
["&#x1eac;","&#x162;","143"],
["&#x1eac;","&#x1ef8;","123"],
["&#x1eac;","&#x1ef6;","123"],
["&#x1eac;","&#x1ef4;","123"],
["&#x1eac;","&#x1ee2;","41"],
["&#x1eac;","&#x1ee0;","41"],
["&#x1eac;","&#x1ede;","41"],
["&#x1eac;","&#x1edc;","41"],
["&#x1eac;","&#x1eda;","41"],
["&#x1eac;","&#x1ed8;","41"],
["&#x1eac;","&#x1ed6;","41"],
["&#x1eac;","&#x1ed4;","41"],
["&#x1eac;","&#x1ed2;","41"],
["&#x1eac;","&#x1ed0;","41"],
["&#x1eac;","&#x1ece;","41"],
["&#x1eac;","&#x1ecc;","41"],
["&#x1eac;","&#x1a0;","41"],
["&#x1eac;","&#x201d;","143"],
["&#x1eac;","&#x2019;","143"],
["&#x1eac;","&#x1ef2;","123"],
["&#x1eac;","&#x1e84;","82"],
["&#x1eac;","&#x1e82;","82"],
["&#x1eac;","&#x1e80;","82"],
["&#x1eac;","&#x1fe;","41"],
["&#x1eac;","&#x178;","123"],
["&#x1eac;","&#x176;","123"],
["&#x1eac;","&#x174;","82"],
["&#x1eac;","&#x164;","143"],
["&#x1eac;","&#x21a;","143"],
["&#x1eac;","&#x152;","41"],
["&#x1eac;","&#x150;","41"],
["&#x1eac;","&#x14e;","41"],
["&#x1eac;","&#x14c;","41"],
["&#x1eac;","&#x122;","41"],
["&#x1eac;","&#x120;","41"],
["&#x1eac;","&#x11e;","41"],
["&#x1eac;","&#x11c;","41"],
["&#x1eac;","&#x10c;","41"],
["&#x1eac;","&#x10a;","41"],
["&#x1eac;","&#x108;","41"],
["&#x1eac;","&#x106;","41"],
["&#x1eac;","&#xdd;","123"],
["&#x1eac;","&#xd8;","41"],
["&#x1eac;","&#xd6;","41"],
["&#x1eac;","&#xd5;","41"],
["&#x1eac;","&#xd4;","41"],
["&#x1eac;","&#xd3;","41"],
["&#x1eac;","&#xd2;","41"],
["&#x1eac;","&#xc7;","41"],
["&#x1eac;","Y","123"],
["&#x1eac;","W","82"],
["&#x1eac;","V","82"],
["&#x1eac;","T","143"],
["&#x1eac;","Q","41"],
["&#x1eac;","O","41"],
["&#x1eac;","J","-266"],
["&#x1eac;","G","41"],
["&#x1eac;","C","41"],
["&#x1eac;","&#x27;","143"],
["&#x1eac;","&#x22;","143"],
["&#x1ead;","&#x201d;","20"],
["&#x1ead;","&#x2019;","20"],
["&#x1ead;","&#x27;","20"],
["&#x1ead;","&#x22;","20"],
["&#x1eae;","&#x162;","143"],
["&#x1eae;","&#x1ef8;","123"],
["&#x1eae;","&#x1ef6;","123"],
["&#x1eae;","&#x1ef4;","123"],
["&#x1eae;","&#x1ee2;","41"],
["&#x1eae;","&#x1ee0;","41"],
["&#x1eae;","&#x1ede;","41"],
["&#x1eae;","&#x1edc;","41"],
["&#x1eae;","&#x1eda;","41"],
["&#x1eae;","&#x1ed8;","41"],
["&#x1eae;","&#x1ed6;","41"],
["&#x1eae;","&#x1ed4;","41"],
["&#x1eae;","&#x1ed2;","41"],
["&#x1eae;","&#x1ed0;","41"],
["&#x1eae;","&#x1ece;","41"],
["&#x1eae;","&#x1ecc;","41"],
["&#x1eae;","&#x1a0;","41"],
["&#x1eae;","&#x201d;","143"],
["&#x1eae;","&#x2019;","143"],
["&#x1eae;","&#x1ef2;","123"],
["&#x1eae;","&#x1e84;","82"],
["&#x1eae;","&#x1e82;","82"],
["&#x1eae;","&#x1e80;","82"],
["&#x1eae;","&#x1fe;","41"],
["&#x1eae;","&#x178;","123"],
["&#x1eae;","&#x176;","123"],
["&#x1eae;","&#x174;","82"],
["&#x1eae;","&#x164;","143"],
["&#x1eae;","&#x21a;","143"],
["&#x1eae;","&#x152;","41"],
["&#x1eae;","&#x150;","41"],
["&#x1eae;","&#x14e;","41"],
["&#x1eae;","&#x14c;","41"],
["&#x1eae;","&#x122;","41"],
["&#x1eae;","&#x120;","41"],
["&#x1eae;","&#x11e;","41"],
["&#x1eae;","&#x11c;","41"],
["&#x1eae;","&#x10c;","41"],
["&#x1eae;","&#x10a;","41"],
["&#x1eae;","&#x108;","41"],
["&#x1eae;","&#x106;","41"],
["&#x1eae;","&#xdd;","123"],
["&#x1eae;","&#xd8;","41"],
["&#x1eae;","&#xd6;","41"],
["&#x1eae;","&#xd5;","41"],
["&#x1eae;","&#xd4;","41"],
["&#x1eae;","&#xd3;","41"],
["&#x1eae;","&#xd2;","41"],
["&#x1eae;","&#xc7;","41"],
["&#x1eae;","Y","123"],
["&#x1eae;","W","82"],
["&#x1eae;","V","82"],
["&#x1eae;","T","143"],
["&#x1eae;","Q","41"],
["&#x1eae;","O","41"],
["&#x1eae;","J","-266"],
["&#x1eae;","G","41"],
["&#x1eae;","C","41"],
["&#x1eae;","&#x27;","143"],
["&#x1eae;","&#x22;","143"],
["&#x1eaf;","&#x201d;","20"],
["&#x1eaf;","&#x2019;","20"],
["&#x1eaf;","&#x27;","20"],
["&#x1eaf;","&#x22;","20"],
["&#x1eb0;","&#x162;","143"],
["&#x1eb0;","&#x1ef8;","123"],
["&#x1eb0;","&#x1ef6;","123"],
["&#x1eb0;","&#x1ef4;","123"],
["&#x1eb0;","&#x1ee2;","41"],
["&#x1eb0;","&#x1ee0;","41"],
["&#x1eb0;","&#x1ede;","41"],
["&#x1eb0;","&#x1edc;","41"],
["&#x1eb0;","&#x1eda;","41"],
["&#x1eb0;","&#x1ed8;","41"],
["&#x1eb0;","&#x1ed6;","41"],
["&#x1eb0;","&#x1ed4;","41"],
["&#x1eb0;","&#x1ed2;","41"],
["&#x1eb0;","&#x1ed0;","41"],
["&#x1eb0;","&#x1ece;","41"],
["&#x1eb0;","&#x1ecc;","41"],
["&#x1eb0;","&#x1a0;","41"],
["&#x1eb0;","&#x201d;","143"],
["&#x1eb0;","&#x2019;","143"],
["&#x1eb0;","&#x1ef2;","123"],
["&#x1eb0;","&#x1e84;","82"],
["&#x1eb0;","&#x1e82;","82"],
["&#x1eb0;","&#x1e80;","82"],
["&#x1eb0;","&#x1fe;","41"],
["&#x1eb0;","&#x178;","123"],
["&#x1eb0;","&#x176;","123"],
["&#x1eb0;","&#x174;","82"],
["&#x1eb0;","&#x164;","143"],
["&#x1eb0;","&#x21a;","143"],
["&#x1eb0;","&#x152;","41"],
["&#x1eb0;","&#x150;","41"],
["&#x1eb0;","&#x14e;","41"],
["&#x1eb0;","&#x14c;","41"],
["&#x1eb0;","&#x122;","41"],
["&#x1eb0;","&#x120;","41"],
["&#x1eb0;","&#x11e;","41"],
["&#x1eb0;","&#x11c;","41"],
["&#x1eb0;","&#x10c;","41"],
["&#x1eb0;","&#x10a;","41"],
["&#x1eb0;","&#x108;","41"],
["&#x1eb0;","&#x106;","41"],
["&#x1eb0;","&#xdd;","123"],
["&#x1eb0;","&#xd8;","41"],
["&#x1eb0;","&#xd6;","41"],
["&#x1eb0;","&#xd5;","41"],
["&#x1eb0;","&#xd4;","41"],
["&#x1eb0;","&#xd3;","41"],
["&#x1eb0;","&#xd2;","41"],
["&#x1eb0;","&#xc7;","41"],
["&#x1eb0;","Y","123"],
["&#x1eb0;","W","82"],
["&#x1eb0;","V","82"],
["&#x1eb0;","T","143"],
["&#x1eb0;","Q","41"],
["&#x1eb0;","O","41"],
["&#x1eb0;","J","-266"],
["&#x1eb0;","G","41"],
["&#x1eb0;","C","41"],
["&#x1eb0;","&#x27;","143"],
["&#x1eb0;","&#x22;","143"],
["&#x1eb1;","&#x201d;","20"],
["&#x1eb1;","&#x2019;","20"],
["&#x1eb1;","&#x27;","20"],
["&#x1eb1;","&#x22;","20"],
["&#x1eb2;","&#x162;","143"],
["&#x1eb2;","&#x1ef8;","123"],
["&#x1eb2;","&#x1ef6;","123"],
["&#x1eb2;","&#x1ef4;","123"],
["&#x1eb2;","&#x1ee2;","41"],
["&#x1eb2;","&#x1ee0;","41"],
["&#x1eb2;","&#x1ede;","41"],
["&#x1eb2;","&#x1edc;","41"],
["&#x1eb2;","&#x1eda;","41"],
["&#x1eb2;","&#x1ed8;","41"],
["&#x1eb2;","&#x1ed6;","41"],
["&#x1eb2;","&#x1ed4;","41"],
["&#x1eb2;","&#x1ed2;","41"],
["&#x1eb2;","&#x1ed0;","41"],
["&#x1eb2;","&#x1ece;","41"],
["&#x1eb2;","&#x1ecc;","41"],
["&#x1eb2;","&#x1a0;","41"],
["&#x1eb2;","&#x201d;","143"],
["&#x1eb2;","&#x2019;","143"],
["&#x1eb2;","&#x1ef2;","123"],
["&#x1eb2;","&#x1e84;","82"],
["&#x1eb2;","&#x1e82;","82"],
["&#x1eb2;","&#x1e80;","82"],
["&#x1eb2;","&#x1fe;","41"],
["&#x1eb2;","&#x178;","123"],
["&#x1eb2;","&#x176;","123"],
["&#x1eb2;","&#x174;","82"],
["&#x1eb2;","&#x164;","143"],
["&#x1eb2;","&#x21a;","143"],
["&#x1eb2;","&#x152;","41"],
["&#x1eb2;","&#x150;","41"],
["&#x1eb2;","&#x14e;","41"],
["&#x1eb2;","&#x14c;","41"],
["&#x1eb2;","&#x122;","41"],
["&#x1eb2;","&#x120;","41"],
["&#x1eb2;","&#x11e;","41"],
["&#x1eb2;","&#x11c;","41"],
["&#x1eb2;","&#x10c;","41"],
["&#x1eb2;","&#x10a;","41"],
["&#x1eb2;","&#x108;","41"],
["&#x1eb2;","&#x106;","41"],
["&#x1eb2;","&#xdd;","123"],
["&#x1eb2;","&#xd8;","41"],
["&#x1eb2;","&#xd6;","41"],
["&#x1eb2;","&#xd5;","41"],
["&#x1eb2;","&#xd4;","41"],
["&#x1eb2;","&#xd3;","41"],
["&#x1eb2;","&#xd2;","41"],
["&#x1eb2;","&#xc7;","41"],
["&#x1eb2;","Y","123"],
["&#x1eb2;","W","82"],
["&#x1eb2;","V","82"],
["&#x1eb2;","T","143"],
["&#x1eb2;","Q","41"],
["&#x1eb2;","O","41"],
["&#x1eb2;","J","-266"],
["&#x1eb2;","G","41"],
["&#x1eb2;","C","41"],
["&#x1eb2;","&#x27;","143"],
["&#x1eb2;","&#x22;","143"],
["&#x1eb3;","&#x201d;","20"],
["&#x1eb3;","&#x2019;","20"],
["&#x1eb3;","&#x27;","20"],
["&#x1eb3;","&#x22;","20"],
["&#x1eb4;","&#x162;","143"],
["&#x1eb4;","&#x1ef8;","123"],
["&#x1eb4;","&#x1ef6;","123"],
["&#x1eb4;","&#x1ef4;","123"],
["&#x1eb4;","&#x1ee2;","41"],
["&#x1eb4;","&#x1ee0;","41"],
["&#x1eb4;","&#x1ede;","41"],
["&#x1eb4;","&#x1edc;","41"],
["&#x1eb4;","&#x1eda;","41"],
["&#x1eb4;","&#x1ed8;","41"],
["&#x1eb4;","&#x1ed6;","41"],
["&#x1eb4;","&#x1ed4;","41"],
["&#x1eb4;","&#x1ed2;","41"],
["&#x1eb4;","&#x1ed0;","41"],
["&#x1eb4;","&#x1ece;","41"],
["&#x1eb4;","&#x1ecc;","41"],
["&#x1eb4;","&#x1a0;","41"],
["&#x1eb4;","&#x201d;","143"],
["&#x1eb4;","&#x2019;","143"],
["&#x1eb4;","&#x1ef2;","123"],
["&#x1eb4;","&#x1e84;","82"],
["&#x1eb4;","&#x1e82;","82"],
["&#x1eb4;","&#x1e80;","82"],
["&#x1eb4;","&#x1fe;","41"],
["&#x1eb4;","&#x178;","123"],
["&#x1eb4;","&#x176;","123"],
["&#x1eb4;","&#x174;","82"],
["&#x1eb4;","&#x164;","143"],
["&#x1eb4;","&#x21a;","143"],
["&#x1eb4;","&#x152;","41"],
["&#x1eb4;","&#x150;","41"],
["&#x1eb4;","&#x14e;","41"],
["&#x1eb4;","&#x14c;","41"],
["&#x1eb4;","&#x122;","41"],
["&#x1eb4;","&#x120;","41"],
["&#x1eb4;","&#x11e;","41"],
["&#x1eb4;","&#x11c;","41"],
["&#x1eb4;","&#x10c;","41"],
["&#x1eb4;","&#x10a;","41"],
["&#x1eb4;","&#x108;","41"],
["&#x1eb4;","&#x106;","41"],
["&#x1eb4;","&#xdd;","123"],
["&#x1eb4;","&#xd8;","41"],
["&#x1eb4;","&#xd6;","41"],
["&#x1eb4;","&#xd5;","41"],
["&#x1eb4;","&#xd4;","41"],
["&#x1eb4;","&#xd3;","41"],
["&#x1eb4;","&#xd2;","41"],
["&#x1eb4;","&#xc7;","41"],
["&#x1eb4;","Y","123"],
["&#x1eb4;","W","82"],
["&#x1eb4;","V","82"],
["&#x1eb4;","T","143"],
["&#x1eb4;","Q","41"],
["&#x1eb4;","O","41"],
["&#x1eb4;","J","-266"],
["&#x1eb4;","G","41"],
["&#x1eb4;","C","41"],
["&#x1eb4;","&#x27;","143"],
["&#x1eb4;","&#x22;","143"],
["&#x1eb5;","&#x201d;","20"],
["&#x1eb5;","&#x2019;","20"],
["&#x1eb5;","&#x27;","20"],
["&#x1eb5;","&#x22;","20"],
["&#x1eb6;","&#x162;","143"],
["&#x1eb6;","&#x1ef8;","123"],
["&#x1eb6;","&#x1ef6;","123"],
["&#x1eb6;","&#x1ef4;","123"],
["&#x1eb6;","&#x1ee2;","41"],
["&#x1eb6;","&#x1ee0;","41"],
["&#x1eb6;","&#x1ede;","41"],
["&#x1eb6;","&#x1edc;","41"],
["&#x1eb6;","&#x1eda;","41"],
["&#x1eb6;","&#x1ed8;","41"],
["&#x1eb6;","&#x1ed6;","41"],
["&#x1eb6;","&#x1ed4;","41"],
["&#x1eb6;","&#x1ed2;","41"],
["&#x1eb6;","&#x1ed0;","41"],
["&#x1eb6;","&#x1ece;","41"],
["&#x1eb6;","&#x1ecc;","41"],
["&#x1eb6;","&#x1a0;","41"],
["&#x1eb6;","&#x201d;","143"],
["&#x1eb6;","&#x2019;","143"],
["&#x1eb6;","&#x1ef2;","123"],
["&#x1eb6;","&#x1e84;","82"],
["&#x1eb6;","&#x1e82;","82"],
["&#x1eb6;","&#x1e80;","82"],
["&#x1eb6;","&#x1fe;","41"],
["&#x1eb6;","&#x178;","123"],
["&#x1eb6;","&#x176;","123"],
["&#x1eb6;","&#x174;","82"],
["&#x1eb6;","&#x164;","143"],
["&#x1eb6;","&#x21a;","143"],
["&#x1eb6;","&#x152;","41"],
["&#x1eb6;","&#x150;","41"],
["&#x1eb6;","&#x14e;","41"],
["&#x1eb6;","&#x14c;","41"],
["&#x1eb6;","&#x122;","41"],
["&#x1eb6;","&#x120;","41"],
["&#x1eb6;","&#x11e;","41"],
["&#x1eb6;","&#x11c;","41"],
["&#x1eb6;","&#x10c;","41"],
["&#x1eb6;","&#x10a;","41"],
["&#x1eb6;","&#x108;","41"],
["&#x1eb6;","&#x106;","41"],
["&#x1eb6;","&#xdd;","123"],
["&#x1eb6;","&#xd8;","41"],
["&#x1eb6;","&#xd6;","41"],
["&#x1eb6;","&#xd5;","41"],
["&#x1eb6;","&#xd4;","41"],
["&#x1eb6;","&#xd3;","41"],
["&#x1eb6;","&#xd2;","41"],
["&#x1eb6;","&#xc7;","41"],
["&#x1eb6;","Y","123"],
["&#x1eb6;","W","82"],
["&#x1eb6;","V","82"],
["&#x1eb6;","T","143"],
["&#x1eb6;","Q","41"],
["&#x1eb6;","O","41"],
["&#x1eb6;","J","-266"],
["&#x1eb6;","G","41"],
["&#x1eb6;","C","41"],
["&#x1eb6;","&#x27;","143"],
["&#x1eb6;","&#x22;","143"],
["&#x1eb7;","&#x201d;","20"],
["&#x1eb7;","&#x2019;","20"],
["&#x1eb7;","&#x27;","20"],
["&#x1eb7;","&#x22;","20"],
["&#x1eb8;","J","-123"],
["&#x1eb9;","&#x1ef5;","41"],
["&#x1eb9;","&#x201d;","20"],
["&#x1eb9;","&#x2019;","20"],
["&#x1eb9;","&#x1e83;","41"],
["&#x1eb9;","&#x1e81;","41"],
["&#x1eb9;","&#x17e;","20"],
["&#x1eb9;","&#x17c;","20"],
["&#x1eb9;","&#x17a;","20"],
["&#x1eb9;","&#x175;","41"],
["&#x1eb9;","&#xfd;","41"],
["&#x1eb9;","z","20"],
["&#x1eb9;","y","41"],
["&#x1eb9;","x","41"],
["&#x1eb9;","w","41"],
["&#x1eb9;","v","41"],
["&#x1eb9;","&#x27;","20"],
["&#x1eb9;","&#x22;","20"],
["&#x1eba;","J","-123"],
["&#x1ebb;","&#x1ef5;","41"],
["&#x1ebb;","&#x201d;","20"],
["&#x1ebb;","&#x2019;","20"],
["&#x1ebb;","&#x1e83;","41"],
["&#x1ebb;","&#x1e81;","41"],
["&#x1ebb;","&#x17e;","20"],
["&#x1ebb;","&#x17c;","20"],
["&#x1ebb;","&#x17a;","20"],
["&#x1ebb;","&#x175;","41"],
["&#x1ebb;","&#xfd;","41"],
["&#x1ebb;","z","20"],
["&#x1ebb;","y","41"],
["&#x1ebb;","x","41"],
["&#x1ebb;","w","41"],
["&#x1ebb;","v","41"],
["&#x1ebb;","&#x27;","20"],
["&#x1ebb;","&#x22;","20"],
["&#x1ebc;","J","-123"],
["&#x1ebd;","&#x1ef5;","41"],
["&#x1ebd;","&#x201d;","20"],
["&#x1ebd;","&#x2019;","20"],
["&#x1ebd;","&#x1e83;","41"],
["&#x1ebd;","&#x1e81;","41"],
["&#x1ebd;","&#x17e;","20"],
["&#x1ebd;","&#x17c;","20"],
["&#x1ebd;","&#x17a;","20"],
["&#x1ebd;","&#x175;","41"],
["&#x1ebd;","&#xfd;","41"],
["&#x1ebd;","z","20"],
["&#x1ebd;","y","41"],
["&#x1ebd;","x","41"],
["&#x1ebd;","w","41"],
["&#x1ebd;","v","41"],
["&#x1ebd;","&#x27;","20"],
["&#x1ebd;","&#x22;","20"],
["&#x1ebe;","J","-123"],
["&#x1ebf;","&#x1ef5;","41"],
["&#x1ebf;","&#x201d;","20"],
["&#x1ebf;","&#x2019;","20"],
["&#x1ebf;","&#x1e83;","41"],
["&#x1ebf;","&#x1e81;","41"],
["&#x1ebf;","&#x17e;","20"],
["&#x1ebf;","&#x17c;","20"],
["&#x1ebf;","&#x17a;","20"],
["&#x1ebf;","&#x175;","41"],
["&#x1ebf;","&#xfd;","41"],
["&#x1ebf;","z","20"],
["&#x1ebf;","y","41"],
["&#x1ebf;","x","41"],
["&#x1ebf;","w","41"],
["&#x1ebf;","v","41"],
["&#x1ebf;","&#x27;","20"],
["&#x1ebf;","&#x22;","20"],
["&#x1ec0;","J","-123"],
["&#x1ec1;","&#x1ef5;","41"],
["&#x1ec1;","&#x201d;","20"],
["&#x1ec1;","&#x2019;","20"],
["&#x1ec1;","&#x1e83;","41"],
["&#x1ec1;","&#x1e81;","41"],
["&#x1ec1;","&#x17e;","20"],
["&#x1ec1;","&#x17c;","20"],
["&#x1ec1;","&#x17a;","20"],
["&#x1ec1;","&#x175;","41"],
["&#x1ec1;","&#xfd;","41"],
["&#x1ec1;","z","20"],
["&#x1ec1;","y","41"],
["&#x1ec1;","x","41"],
["&#x1ec1;","w","41"],
["&#x1ec1;","v","41"],
["&#x1ec1;","&#x27;","20"],
["&#x1ec1;","&#x22;","20"],
["&#x1ec2;","J","-123"],
["&#x1ec3;","&#x1ef5;","41"],
["&#x1ec3;","&#x201d;","20"],
["&#x1ec3;","&#x2019;","20"],
["&#x1ec3;","&#x1e83;","41"],
["&#x1ec3;","&#x1e81;","41"],
["&#x1ec3;","&#x17e;","20"],
["&#x1ec3;","&#x17c;","20"],
["&#x1ec3;","&#x17a;","20"],
["&#x1ec3;","&#x175;","41"],
["&#x1ec3;","&#xfd;","41"],
["&#x1ec3;","z","20"],
["&#x1ec3;","y","41"],
["&#x1ec3;","x","41"],
["&#x1ec3;","w","41"],
["&#x1ec3;","v","41"],
["&#x1ec3;","&#x27;","20"],
["&#x1ec3;","&#x22;","20"],
["&#x1ec4;","J","-123"],
["&#x1ec5;","&#x1ef5;","41"],
["&#x1ec5;","&#x201d;","20"],
["&#x1ec5;","&#x2019;","20"],
["&#x1ec5;","&#x1e83;","41"],
["&#x1ec5;","&#x1e81;","41"],
["&#x1ec5;","&#x17e;","20"],
["&#x1ec5;","&#x17c;","20"],
["&#x1ec5;","&#x17a;","20"],
["&#x1ec5;","&#x175;","41"],
["&#x1ec5;","&#xfd;","41"],
["&#x1ec5;","z","20"],
["&#x1ec5;","y","41"],
["&#x1ec5;","x","41"],
["&#x1ec5;","w","41"],
["&#x1ec5;","v","41"],
["&#x1ec5;","&#x27;","20"],
["&#x1ec5;","&#x22;","20"],
["&#x1ec6;","J","-123"],
["&#x1ec7;","&#x1ef5;","41"],
["&#x1ec7;","&#x201d;","20"],
["&#x1ec7;","&#x2019;","20"],
["&#x1ec7;","&#x1e83;","41"],
["&#x1ec7;","&#x1e81;","41"],
["&#x1ec7;","&#x17e;","20"],
["&#x1ec7;","&#x17c;","20"],
["&#x1ec7;","&#x17a;","20"],
["&#x1ec7;","&#x175;","41"],
["&#x1ec7;","&#xfd;","41"],
["&#x1ec7;","z","20"],
["&#x1ec7;","y","41"],
["&#x1ec7;","x","41"],
["&#x1ec7;","w","41"],
["&#x1ec7;","v","41"],
["&#x1ec7;","&#x27;","20"],
["&#x1ec7;","&#x22;","20"],
["&#x1ecc;","&#x162;","61"],
["&#x1ecc;","&#x1ef8;","20"],
["&#x1ecc;","&#x1ef6;","20"],
["&#x1ecc;","&#x1ef4;","20"],
["&#x1ecc;","&#x1eb6;","41"],
["&#x1ecc;","&#x1eb4;","41"],
["&#x1ecc;","&#x1eb2;","41"],
["&#x1ecc;","&#x1eb0;","41"],
["&#x1ecc;","&#x1eae;","41"],
["&#x1ecc;","&#x1eac;","41"],
["&#x1ecc;","&#x1eaa;","41"],
["&#x1ecc;","&#x1ea8;","41"],
["&#x1ecc;","&#x1ea6;","41"],
["&#x1ecc;","&#x1ea4;","41"],
["&#x1ecc;","&#x1ea2;","41"],
["&#x1ecc;","&#x1ea0;","41"],
["&#x1ecc;","&#x1e00;","41"],
["&#x1ecc;","&#x201e;","82"],
["&#x1ecc;","&#x201a;","82"],
["&#x1ecc;","&#x1ef2;","20"],
["&#x1ecc;","&#x1e84;","20"],
["&#x1ecc;","&#x1e82;","20"],
["&#x1ecc;","&#x1e80;","20"],
["&#x1ecc;","&#x405;","20"],
["&#x1ecc;","&#x1fa;","41"],
["&#x1ecc;","&#x17d;","20"],
["&#x1ecc;","&#x17b;","20"],
["&#x1ecc;","&#x179;","20"],
["&#x1ecc;","&#x178;","20"],
["&#x1ecc;","&#x176;","20"],
["&#x1ecc;","&#x174;","20"],
["&#x1ecc;","&#x164;","61"],
["&#x1ecc;","&#x21a;","61"],
["&#x1ecc;","&#x104;","41"],
["&#x1ecc;","&#x102;","41"],
["&#x1ecc;","&#x100;","41"],
["&#x1ecc;","&#xdd;","20"],
["&#x1ecc;","&#xc5;","41"],
["&#x1ecc;","&#xc4;","41"],
["&#x1ecc;","&#xc3;","41"],
["&#x1ecc;","&#xc2;","41"],
["&#x1ecc;","&#xc1;","41"],
["&#x1ecc;","&#xc0;","41"],
["&#x1ecc;","Z","20"],
["&#x1ecc;","Y","20"],
["&#x1ecc;","X","41"],
["&#x1ecc;","W","20"],
["&#x1ecc;","V","20"],
["&#x1ecc;","T","61"],
["&#x1ecc;","A","41"],
["&#x1ecc;","&#x2e;","82"],
["&#x1ecc;","&#x2c;","82"],
["&#x1ecd;","&#x1ef5;","41"],
["&#x1ecd;","&#x201d;","20"],
["&#x1ecd;","&#x2019;","20"],
["&#x1ecd;","&#x1e83;","41"],
["&#x1ecd;","&#x1e81;","41"],
["&#x1ecd;","&#x17e;","20"],
["&#x1ecd;","&#x17c;","20"],
["&#x1ecd;","&#x17a;","20"],
["&#x1ecd;","&#x175;","41"],
["&#x1ecd;","&#xfd;","41"],
["&#x1ecd;","z","20"],
["&#x1ecd;","y","41"],
["&#x1ecd;","x","41"],
["&#x1ecd;","w","41"],
["&#x1ecd;","v","41"],
["&#x1ecd;","&#x27;","20"],
["&#x1ecd;","&#x22;","20"],
["&#x1ece;","&#x162;","61"],
["&#x1ece;","&#x1ef8;","20"],
["&#x1ece;","&#x1ef6;","20"],
["&#x1ece;","&#x1ef4;","20"],
["&#x1ece;","&#x1eb6;","41"],
["&#x1ece;","&#x1eb4;","41"],
["&#x1ece;","&#x1eb2;","41"],
["&#x1ece;","&#x1eb0;","41"],
["&#x1ece;","&#x1eae;","41"],
["&#x1ece;","&#x1eac;","41"],
["&#x1ece;","&#x1eaa;","41"],
["&#x1ece;","&#x1ea8;","41"],
["&#x1ece;","&#x1ea6;","41"],
["&#x1ece;","&#x1ea4;","41"],
["&#x1ece;","&#x1ea2;","41"],
["&#x1ece;","&#x1ea0;","41"],
["&#x1ece;","&#x1e00;","41"],
["&#x1ece;","&#x201e;","82"],
["&#x1ece;","&#x201a;","82"],
["&#x1ece;","&#x1ef2;","20"],
["&#x1ece;","&#x1e84;","20"],
["&#x1ece;","&#x1e82;","20"],
["&#x1ece;","&#x1e80;","20"],
["&#x1ece;","&#x405;","20"],
["&#x1ece;","&#x1fa;","41"],
["&#x1ece;","&#x17d;","20"],
["&#x1ece;","&#x17b;","20"],
["&#x1ece;","&#x179;","20"],
["&#x1ece;","&#x178;","20"],
["&#x1ece;","&#x176;","20"],
["&#x1ece;","&#x174;","20"],
["&#x1ece;","&#x164;","61"],
["&#x1ece;","&#x21a;","61"],
["&#x1ece;","&#x104;","41"],
["&#x1ece;","&#x102;","41"],
["&#x1ece;","&#x100;","41"],
["&#x1ece;","&#xdd;","20"],
["&#x1ece;","&#xc5;","41"],
["&#x1ece;","&#xc4;","41"],
["&#x1ece;","&#xc3;","41"],
["&#x1ece;","&#xc2;","41"],
["&#x1ece;","&#xc1;","41"],
["&#x1ece;","&#xc0;","41"],
["&#x1ece;","Z","20"],
["&#x1ece;","Y","20"],
["&#x1ece;","X","41"],
["&#x1ece;","W","20"],
["&#x1ece;","V","20"],
["&#x1ece;","T","61"],
["&#x1ece;","A","41"],
["&#x1ece;","&#x2e;","82"],
["&#x1ece;","&#x2c;","82"],
["&#x1ecf;","&#x1ef5;","41"],
["&#x1ecf;","&#x201d;","20"],
["&#x1ecf;","&#x2019;","20"],
["&#x1ecf;","&#x1e83;","41"],
["&#x1ecf;","&#x1e81;","41"],
["&#x1ecf;","&#x17e;","20"],
["&#x1ecf;","&#x17c;","20"],
["&#x1ecf;","&#x17a;","20"],
["&#x1ecf;","&#x175;","41"],
["&#x1ecf;","&#xfd;","41"],
["&#x1ecf;","z","20"],
["&#x1ecf;","y","41"],
["&#x1ecf;","x","41"],
["&#x1ecf;","w","41"],
["&#x1ecf;","v","41"],
["&#x1ecf;","&#x27;","20"],
["&#x1ecf;","&#x22;","20"],
["&#x1ed0;","&#x162;","61"],
["&#x1ed0;","&#x1ef8;","20"],
["&#x1ed0;","&#x1ef6;","20"],
["&#x1ed0;","&#x1ef4;","20"],
["&#x1ed0;","&#x1eb6;","41"],
["&#x1ed0;","&#x1eb4;","41"],
["&#x1ed0;","&#x1eb2;","41"],
["&#x1ed0;","&#x1eb0;","41"],
["&#x1ed0;","&#x1eae;","41"],
["&#x1ed0;","&#x1eac;","41"],
["&#x1ed0;","&#x1eaa;","41"],
["&#x1ed0;","&#x1ea8;","41"],
["&#x1ed0;","&#x1ea6;","41"],
["&#x1ed0;","&#x1ea4;","41"],
["&#x1ed0;","&#x1ea2;","41"],
["&#x1ed0;","&#x1ea0;","41"],
["&#x1ed0;","&#x1e00;","41"],
["&#x1ed0;","&#x201e;","82"],
["&#x1ed0;","&#x201a;","82"],
["&#x1ed0;","&#x1ef2;","20"],
["&#x1ed0;","&#x1e84;","20"],
["&#x1ed0;","&#x1e82;","20"],
["&#x1ed0;","&#x1e80;","20"],
["&#x1ed0;","&#x405;","20"],
["&#x1ed0;","&#x1fa;","41"],
["&#x1ed0;","&#x17d;","20"],
["&#x1ed0;","&#x17b;","20"],
["&#x1ed0;","&#x179;","20"],
["&#x1ed0;","&#x178;","20"],
["&#x1ed0;","&#x176;","20"],
["&#x1ed0;","&#x174;","20"],
["&#x1ed0;","&#x164;","61"],
["&#x1ed0;","&#x21a;","61"],
["&#x1ed0;","&#x104;","41"],
["&#x1ed0;","&#x102;","41"],
["&#x1ed0;","&#x100;","41"],
["&#x1ed0;","&#xdd;","20"],
["&#x1ed0;","&#xc5;","41"],
["&#x1ed0;","&#xc4;","41"],
["&#x1ed0;","&#xc3;","41"],
["&#x1ed0;","&#xc2;","41"],
["&#x1ed0;","&#xc1;","41"],
["&#x1ed0;","&#xc0;","41"],
["&#x1ed0;","Z","20"],
["&#x1ed0;","Y","20"],
["&#x1ed0;","X","41"],
["&#x1ed0;","W","20"],
["&#x1ed0;","V","20"],
["&#x1ed0;","T","61"],
["&#x1ed0;","A","41"],
["&#x1ed0;","&#x2e;","82"],
["&#x1ed0;","&#x2c;","82"],
["&#x1ed2;","&#x162;","61"],
["&#x1ed2;","&#x1ef8;","20"],
["&#x1ed2;","&#x1ef6;","20"],
["&#x1ed2;","&#x1ef4;","20"],
["&#x1ed2;","&#x1eb6;","41"],
["&#x1ed2;","&#x1eb4;","41"],
["&#x1ed2;","&#x1eb2;","41"],
["&#x1ed2;","&#x1eb0;","41"],
["&#x1ed2;","&#x1eae;","41"],
["&#x1ed2;","&#x1eac;","41"],
["&#x1ed2;","&#x1eaa;","41"],
["&#x1ed2;","&#x1ea8;","41"],
["&#x1ed2;","&#x1ea6;","41"],
["&#x1ed2;","&#x1ea4;","41"],
["&#x1ed2;","&#x1ea2;","41"],
["&#x1ed2;","&#x1ea0;","41"],
["&#x1ed2;","&#x1e00;","41"],
["&#x1ed2;","&#x201e;","82"],
["&#x1ed2;","&#x201a;","82"],
["&#x1ed2;","&#x1ef2;","20"],
["&#x1ed2;","&#x1e84;","20"],
["&#x1ed2;","&#x1e82;","20"],
["&#x1ed2;","&#x1e80;","20"],
["&#x1ed2;","&#x405;","20"],
["&#x1ed2;","&#x1fa;","41"],
["&#x1ed2;","&#x17d;","20"],
["&#x1ed2;","&#x17b;","20"],
["&#x1ed2;","&#x179;","20"],
["&#x1ed2;","&#x178;","20"],
["&#x1ed2;","&#x176;","20"],
["&#x1ed2;","&#x174;","20"],
["&#x1ed2;","&#x164;","61"],
["&#x1ed2;","&#x21a;","61"],
["&#x1ed2;","&#x104;","41"],
["&#x1ed2;","&#x102;","41"],
["&#x1ed2;","&#x100;","41"],
["&#x1ed2;","&#xdd;","20"],
["&#x1ed2;","&#xc5;","41"],
["&#x1ed2;","&#xc4;","41"],
["&#x1ed2;","&#xc3;","41"],
["&#x1ed2;","&#xc2;","41"],
["&#x1ed2;","&#xc1;","41"],
["&#x1ed2;","&#xc0;","41"],
["&#x1ed2;","Z","20"],
["&#x1ed2;","Y","20"],
["&#x1ed2;","X","41"],
["&#x1ed2;","W","20"],
["&#x1ed2;","V","20"],
["&#x1ed2;","T","61"],
["&#x1ed2;","A","41"],
["&#x1ed2;","&#x2e;","82"],
["&#x1ed2;","&#x2c;","82"],
["&#x1ed4;","&#x162;","61"],
["&#x1ed4;","&#x1ef8;","20"],
["&#x1ed4;","&#x1ef6;","20"],
["&#x1ed4;","&#x1ef4;","20"],
["&#x1ed4;","&#x1eb6;","41"],
["&#x1ed4;","&#x1eb4;","41"],
["&#x1ed4;","&#x1eb2;","41"],
["&#x1ed4;","&#x1eb0;","41"],
["&#x1ed4;","&#x1eae;","41"],
["&#x1ed4;","&#x1eac;","41"],
["&#x1ed4;","&#x1eaa;","41"],
["&#x1ed4;","&#x1ea8;","41"],
["&#x1ed4;","&#x1ea6;","41"],
["&#x1ed4;","&#x1ea4;","41"],
["&#x1ed4;","&#x1ea2;","41"],
["&#x1ed4;","&#x1ea0;","41"],
["&#x1ed4;","&#x1e00;","41"],
["&#x1ed4;","&#x201e;","82"],
["&#x1ed4;","&#x201a;","82"],
["&#x1ed4;","&#x1ef2;","20"],
["&#x1ed4;","&#x1e84;","20"],
["&#x1ed4;","&#x1e82;","20"],
["&#x1ed4;","&#x1e80;","20"],
["&#x1ed4;","&#x405;","20"],
["&#x1ed4;","&#x1fa;","41"],
["&#x1ed4;","&#x17d;","20"],
["&#x1ed4;","&#x17b;","20"],
["&#x1ed4;","&#x179;","20"],
["&#x1ed4;","&#x178;","20"],
["&#x1ed4;","&#x176;","20"],
["&#x1ed4;","&#x174;","20"],
["&#x1ed4;","&#x164;","61"],
["&#x1ed4;","&#x21a;","61"],
["&#x1ed4;","&#x104;","41"],
["&#x1ed4;","&#x102;","41"],
["&#x1ed4;","&#x100;","41"],
["&#x1ed4;","&#xdd;","20"],
["&#x1ed4;","&#xc5;","41"],
["&#x1ed4;","&#xc4;","41"],
["&#x1ed4;","&#xc3;","41"],
["&#x1ed4;","&#xc2;","41"],
["&#x1ed4;","&#xc1;","41"],
["&#x1ed4;","&#xc0;","41"],
["&#x1ed4;","Z","20"],
["&#x1ed4;","Y","20"],
["&#x1ed4;","X","41"],
["&#x1ed4;","W","20"],
["&#x1ed4;","V","20"],
["&#x1ed4;","T","61"],
["&#x1ed4;","A","41"],
["&#x1ed4;","&#x2e;","82"],
["&#x1ed4;","&#x2c;","82"],
["&#x1ed6;","&#x162;","61"],
["&#x1ed6;","&#x1ef8;","20"],
["&#x1ed6;","&#x1ef6;","20"],
["&#x1ed6;","&#x1ef4;","20"],
["&#x1ed6;","&#x1eb6;","41"],
["&#x1ed6;","&#x1eb4;","41"],
["&#x1ed6;","&#x1eb2;","41"],
["&#x1ed6;","&#x1eb0;","41"],
["&#x1ed6;","&#x1eae;","41"],
["&#x1ed6;","&#x1eac;","41"],
["&#x1ed6;","&#x1eaa;","41"],
["&#x1ed6;","&#x1ea8;","41"],
["&#x1ed6;","&#x1ea6;","41"],
["&#x1ed6;","&#x1ea4;","41"],
["&#x1ed6;","&#x1ea2;","41"],
["&#x1ed6;","&#x1ea0;","41"],
["&#x1ed6;","&#x1e00;","41"],
["&#x1ed6;","&#x201e;","82"],
["&#x1ed6;","&#x201a;","82"],
["&#x1ed6;","&#x1ef2;","20"],
["&#x1ed6;","&#x1e84;","20"],
["&#x1ed6;","&#x1e82;","20"],
["&#x1ed6;","&#x1e80;","20"],
["&#x1ed6;","&#x405;","20"],
["&#x1ed6;","&#x1fa;","41"],
["&#x1ed6;","&#x17d;","20"],
["&#x1ed6;","&#x17b;","20"],
["&#x1ed6;","&#x179;","20"],
["&#x1ed6;","&#x178;","20"],
["&#x1ed6;","&#x176;","20"],
["&#x1ed6;","&#x174;","20"],
["&#x1ed6;","&#x164;","61"],
["&#x1ed6;","&#x21a;","61"],
["&#x1ed6;","&#x104;","41"],
["&#x1ed6;","&#x102;","41"],
["&#x1ed6;","&#x100;","41"],
["&#x1ed6;","&#xdd;","20"],
["&#x1ed6;","&#xc5;","41"],
["&#x1ed6;","&#xc4;","41"],
["&#x1ed6;","&#xc3;","41"],
["&#x1ed6;","&#xc2;","41"],
["&#x1ed6;","&#xc1;","41"],
["&#x1ed6;","&#xc0;","41"],
["&#x1ed6;","Z","20"],
["&#x1ed6;","Y","20"],
["&#x1ed6;","X","41"],
["&#x1ed6;","W","20"],
["&#x1ed6;","V","20"],
["&#x1ed6;","T","61"],
["&#x1ed6;","A","41"],
["&#x1ed6;","&#x2e;","82"],
["&#x1ed6;","&#x2c;","82"],
["&#x1ed8;","&#x162;","61"],
["&#x1ed8;","&#x1ef8;","20"],
["&#x1ed8;","&#x1ef6;","20"],
["&#x1ed8;","&#x1ef4;","20"],
["&#x1ed8;","&#x1eb6;","41"],
["&#x1ed8;","&#x1eb4;","41"],
["&#x1ed8;","&#x1eb2;","41"],
["&#x1ed8;","&#x1eb0;","41"],
["&#x1ed8;","&#x1eae;","41"],
["&#x1ed8;","&#x1eac;","41"],
["&#x1ed8;","&#x1eaa;","41"],
["&#x1ed8;","&#x1ea8;","41"],
["&#x1ed8;","&#x1ea6;","41"],
["&#x1ed8;","&#x1ea4;","41"],
["&#x1ed8;","&#x1ea2;","41"],
["&#x1ed8;","&#x1ea0;","41"],
["&#x1ed8;","&#x1e00;","41"],
["&#x1ed8;","&#x201e;","82"],
["&#x1ed8;","&#x201a;","82"],
["&#x1ed8;","&#x1ef2;","20"],
["&#x1ed8;","&#x1e84;","20"],
["&#x1ed8;","&#x1e82;","20"],
["&#x1ed8;","&#x1e80;","20"],
["&#x1ed8;","&#x405;","20"],
["&#x1ed8;","&#x1fa;","41"],
["&#x1ed8;","&#x17d;","20"],
["&#x1ed8;","&#x17b;","20"],
["&#x1ed8;","&#x179;","20"],
["&#x1ed8;","&#x178;","20"],
["&#x1ed8;","&#x176;","20"],
["&#x1ed8;","&#x174;","20"],
["&#x1ed8;","&#x164;","61"],
["&#x1ed8;","&#x21a;","61"],
["&#x1ed8;","&#x104;","41"],
["&#x1ed8;","&#x102;","41"],
["&#x1ed8;","&#x100;","41"],
["&#x1ed8;","&#xdd;","20"],
["&#x1ed8;","&#xc5;","41"],
["&#x1ed8;","&#xc4;","41"],
["&#x1ed8;","&#xc3;","41"],
["&#x1ed8;","&#xc2;","41"],
["&#x1ed8;","&#xc1;","41"],
["&#x1ed8;","&#xc0;","41"],
["&#x1ed8;","Z","20"],
["&#x1ed8;","Y","20"],
["&#x1ed8;","X","41"],
["&#x1ed8;","W","20"],
["&#x1ed8;","V","20"],
["&#x1ed8;","T","61"],
["&#x1ed8;","A","41"],
["&#x1ed8;","&#x2e;","82"],
["&#x1ed8;","&#x2c;","82"],
["&#x1edb;","&#x163;","-82"],
["&#x1edb;" g2="ff","-82"],
["&#x1edb;","&#x1ef5;","-102"],
["&#x1edb;" g2="uniFB04","-82"],
["&#x1edb;" g2="uniFB03","-82"],
["&#x1edb;" g2="uniFB02","-82"],
["&#x1edb;" g2="uniFB01","-82"],
["&#x1edb;","&#x1e83;","-102"],
["&#x1edb;","&#x1e81;","-102"],
["&#x1edb;","&#x175;","-102"],
["&#x1edb;","&#x165;","-82"],
["&#x1edb;","&#x21b;","-82"],
["&#x1edb;","&#xfd;","-102"],
["&#x1edb;","y","-102"],
["&#x1edb;","x","-102"],
["&#x1edb;","w","-102"],
["&#x1edb;","v","-102"],
["&#x1edb;","t","-82"],
["&#x1edb;","f","-82"],
["&#x1edd;","&#x163;","-82"],
["&#x1edd;" g2="ff","-82"],
["&#x1edd;","&#x1ef5;","-102"],
["&#x1edd;" g2="uniFB04","-82"],
["&#x1edd;" g2="uniFB03","-82"],
["&#x1edd;" g2="uniFB02","-82"],
["&#x1edd;" g2="uniFB01","-82"],
["&#x1edd;","&#x1e83;","-102"],
["&#x1edd;","&#x1e81;","-102"],
["&#x1edd;","&#x175;","-102"],
["&#x1edd;","&#x165;","-82"],
["&#x1edd;","&#x21b;","-82"],
["&#x1edd;","&#xfd;","-102"],
["&#x1edd;","y","-102"],
["&#x1edd;","x","-102"],
["&#x1edd;","w","-102"],
["&#x1edd;","v","-102"],
["&#x1edd;","t","-82"],
["&#x1edd;","f","-82"],
["&#x1edf;","&#x163;","-82"],
["&#x1edf;" g2="ff","-82"],
["&#x1edf;","&#x1ef5;","-102"],
["&#x1edf;" g2="uniFB04","-82"],
["&#x1edf;" g2="uniFB03","-82"],
["&#x1edf;" g2="uniFB02","-82"],
["&#x1edf;" g2="uniFB01","-82"],
["&#x1edf;","&#x1e83;","-102"],
["&#x1edf;","&#x1e81;","-102"],
["&#x1edf;","&#x175;","-102"],
["&#x1edf;","&#x165;","-82"],
["&#x1edf;","&#x21b;","-82"],
["&#x1edf;","&#xfd;","-102"],
["&#x1edf;","y","-102"],
["&#x1edf;","x","-102"],
["&#x1edf;","w","-102"],
["&#x1edf;","v","-102"],
["&#x1edf;","t","-82"],
["&#x1edf;","f","-82"],
["&#x1ee1;","&#x163;","-82"],
["&#x1ee1;" g2="ff","-82"],
["&#x1ee1;","&#x1ef5;","-102"],
["&#x1ee1;" g2="uniFB04","-82"],
["&#x1ee1;" g2="uniFB03","-82"],
["&#x1ee1;" g2="uniFB02","-82"],
["&#x1ee1;" g2="uniFB01","-82"],
["&#x1ee1;","&#x1e83;","-102"],
["&#x1ee1;","&#x1e81;","-102"],
["&#x1ee1;","&#x175;","-102"],
["&#x1ee1;","&#x165;","-82"],
["&#x1ee1;","&#x21b;","-82"],
["&#x1ee1;","&#xfd;","-102"],
["&#x1ee1;","y","-102"],
["&#x1ee1;","x","-102"],
["&#x1ee1;","w","-102"],
["&#x1ee1;","v","-102"],
["&#x1ee1;","t","-82"],
["&#x1ee1;","f","-82"],
["&#x1ee3;","&#x163;","-82"],
["&#x1ee3;" g2="ff","-82"],
["&#x1ee3;","&#x1ef5;","-102"],
["&#x1ee3;" g2="uniFB04","-82"],
["&#x1ee3;" g2="uniFB03","-82"],
["&#x1ee3;" g2="uniFB02","-82"],
["&#x1ee3;" g2="uniFB01","-82"],
["&#x1ee3;","&#x1e83;","-102"],
["&#x1ee3;","&#x1e81;","-102"],
["&#x1ee3;","&#x175;","-102"],
["&#x1ee3;","&#x165;","-82"],
["&#x1ee3;","&#x21b;","-82"],
["&#x1ee3;","&#xfd;","-102"],
["&#x1ee3;","y","-102"],
["&#x1ee3;","x","-102"],
["&#x1ee3;","w","-102"],
["&#x1ee3;","v","-102"],
["&#x1ee3;","t","-82"],
["&#x1ee3;","f","-82"],
["&#x1ee4;","&#x1eb6;","20"],
["&#x1ee4;","&#x1eb4;","20"],
["&#x1ee4;","&#x1eb2;","20"],
["&#x1ee4;","&#x1eb0;","20"],
["&#x1ee4;","&#x1eae;","20"],
["&#x1ee4;","&#x1eac;","20"],
["&#x1ee4;","&#x1eaa;","20"],
["&#x1ee4;","&#x1ea8;","20"],
["&#x1ee4;","&#x1ea6;","20"],
["&#x1ee4;","&#x1ea4;","20"],
["&#x1ee4;","&#x1ea2;","20"],
["&#x1ee4;","&#x1ea0;","20"],
["&#x1ee4;","&#x1e00;","20"],
["&#x1ee4;","&#x201e;","41"],
["&#x1ee4;","&#x201a;","41"],
["&#x1ee4;","&#x1fa;","20"],
["&#x1ee4;","&#x104;","20"],
["&#x1ee4;","&#x102;","20"],
["&#x1ee4;","&#x100;","20"],
["&#x1ee4;","&#xc5;","20"],
["&#x1ee4;","&#xc4;","20"],
["&#x1ee4;","&#xc3;","20"],
["&#x1ee4;","&#xc2;","20"],
["&#x1ee4;","&#xc1;","20"],
["&#x1ee4;","&#xc0;","20"],
["&#x1ee4;","A","20"],
["&#x1ee4;","&#x2e;","41"],
["&#x1ee4;","&#x2c;","41"],
["&#x1ee9;","&#x163;","-102"],
["&#x1ee9;" g2="ff","-102"],
["&#x1ee9;","&#x1ef5;","-102"],
["&#x1ee9;" g2="uniFB04","-102"],
["&#x1ee9;" g2="uniFB03","-102"],
["&#x1ee9;" g2="uniFB02","-102"],
["&#x1ee9;" g2="uniFB01","-102"],
["&#x1ee9;","&#x1e83;","-102"],
["&#x1ee9;","&#x1e81;","-102"],
["&#x1ee9;","&#x175;","-102"],
["&#x1ee9;","&#x165;","-102"],
["&#x1ee9;","&#x21b;","-102"],
["&#x1ee9;","&#xfd;","-102"],
["&#x1ee9;","y","-102"],
["&#x1ee9;","x","-102"],
["&#x1ee9;","w","-102"],
["&#x1ee9;","v","-102"],
["&#x1ee9;","t","-102"],
["&#x1ee9;","f","-102"],
["&#x1eeb;","&#x163;","-102"],
["&#x1eeb;" g2="ff","-102"],
["&#x1eeb;","&#x1ef5;","-102"],
["&#x1eeb;" g2="uniFB04","-102"],
["&#x1eeb;" g2="uniFB03","-102"],
["&#x1eeb;" g2="uniFB02","-102"],
["&#x1eeb;" g2="uniFB01","-102"],
["&#x1eeb;","&#x1e83;","-102"],
["&#x1eeb;","&#x1e81;","-102"],
["&#x1eeb;","&#x175;","-102"],
["&#x1eeb;","&#x165;","-102"],
["&#x1eeb;","&#x21b;","-102"],
["&#x1eeb;","&#xfd;","-102"],
["&#x1eeb;","y","-102"],
["&#x1eeb;","x","-102"],
["&#x1eeb;","w","-102"],
["&#x1eeb;","v","-102"],
["&#x1eeb;","t","-102"],
["&#x1eeb;","f","-102"],
["&#x1eed;","&#x163;","-102"],
["&#x1eed;" g2="ff","-102"],
["&#x1eed;","&#x1ef5;","-102"],
["&#x1eed;" g2="uniFB04","-102"],
["&#x1eed;" g2="uniFB03","-102"],
["&#x1eed;" g2="uniFB02","-102"],
["&#x1eed;" g2="uniFB01","-102"],
["&#x1eed;","&#x1e83;","-102"],
["&#x1eed;","&#x1e81;","-102"],
["&#x1eed;","&#x175;","-102"],
["&#x1eed;","&#x165;","-102"],
["&#x1eed;","&#x21b;","-102"],
["&#x1eed;","&#xfd;","-102"],
["&#x1eed;","y","-102"],
["&#x1eed;","x","-102"],
["&#x1eed;","w","-102"],
["&#x1eed;","v","-102"],
["&#x1eed;","t","-102"],
["&#x1eed;","f","-102"],
["&#x1eef;","&#x163;","-102"],
["&#x1eef;" g2="ff","-102"],
["&#x1eef;","&#x1ef5;","-102"],
["&#x1eef;" g2="uniFB04","-102"],
["&#x1eef;" g2="uniFB03","-102"],
["&#x1eef;" g2="uniFB02","-102"],
["&#x1eef;" g2="uniFB01","-102"],
["&#x1eef;","&#x1e83;","-102"],
["&#x1eef;","&#x1e81;","-102"],
["&#x1eef;","&#x175;","-102"],
["&#x1eef;","&#x165;","-102"],
["&#x1eef;","&#x21b;","-102"],
["&#x1eef;","&#xfd;","-102"],
["&#x1eef;","y","-102"],
["&#x1eef;","x","-102"],
["&#x1eef;","w","-102"],
["&#x1eef;","v","-102"],
["&#x1eef;","t","-102"],
["&#x1eef;","f","-102"],
["&#x1ef1;","&#x163;","-102"],
["&#x1ef1;" g2="ff","-102"],
["&#x1ef1;","&#x1ef5;","-102"],
["&#x1ef1;" g2="uniFB04","-102"],
["&#x1ef1;" g2="uniFB03","-102"],
["&#x1ef1;" g2="uniFB02","-102"],
["&#x1ef1;" g2="uniFB01","-102"],
["&#x1ef1;","&#x1e83;","-102"],
["&#x1ef1;","&#x1e81;","-102"],
["&#x1ef1;","&#x175;","-102"],
["&#x1ef1;","&#x165;","-102"],
["&#x1ef1;","&#x21b;","-102"],
["&#x1ef1;","&#xfd;","-102"],
["&#x1ef1;","y","-102"],
["&#x1ef1;","x","-102"],
["&#x1ef1;","w","-102"],
["&#x1ef1;","v","-102"],
["&#x1ef1;","t","-102"],
["&#x1ef1;","f","-102"],
["&#x1ef4;","&#x1ef1;","61"],
["&#x1ef4;","&#x1eef;","61"],
["&#x1ef4;","&#x1eed;","61"],
["&#x1ef4;","&#x1eeb;","61"],
["&#x1ef4;","&#x1ee9;","61"],
["&#x1ef4;","&#x1ee7;","61"],
["&#x1ef4;","&#x1ee5;","61"],
["&#x1ef4;","&#x1ee3;","102"],
["&#x1ef4;","&#x1ee2;","41"],
["&#x1ef4;","&#x1ee1;","102"],
["&#x1ef4;","&#x1ee0;","41"],
["&#x1ef4;","&#x1edf;","102"],
["&#x1ef4;","&#x1ede;","41"],
["&#x1ef4;","&#x1edd;","102"],
["&#x1ef4;","&#x1edc;","41"],
["&#x1ef4;","&#x1edb;","102"],
["&#x1ef4;","&#x1eda;","41"],
["&#x1ef4;","&#x1ed9;","102"],
["&#x1ef4;","&#x1ed8;","41"],
["&#x1ef4;","&#x1ed7;","102"],
["&#x1ef4;","&#x1ed6;","41"],
["&#x1ef4;","&#x1ed5;","102"],
["&#x1ef4;","&#x1ed4;","41"],
["&#x1ef4;","&#x1ed2;","41"],
["&#x1ef4;","&#x1ed1;","102"],
["&#x1ef4;","&#x1ed0;","41"],
["&#x1ef4;","&#x1ecf;","102"],
["&#x1ef4;","&#x1ece;","41"],
["&#x1ef4;","&#x1ecd;","102"],
["&#x1ef4;","&#x1ecc;","41"],
["&#x1ef4;","&#x1ec7;","102"],
["&#x1ef4;","&#x1ec5;","102"],
["&#x1ef4;","&#x1ec3;","102"],
["&#x1ef4;","&#x1ebf;","102"],
["&#x1ef4;","&#x1ebd;","102"],
["&#x1ef4;","&#x1ebb;","102"],
["&#x1ef4;","&#x1eb9;","102"],
["&#x1ef4;","&#x1eb7;","102"],
["&#x1ef4;","&#x1eb6;","123"],
["&#x1ef4;","&#x1eb5;","102"],
["&#x1ef4;","&#x1eb4;","123"],
["&#x1ef4;","&#x1eb3;","102"],
["&#x1ef4;","&#x1eb2;","123"],
["&#x1ef4;","&#x1eb1;","102"],
["&#x1ef4;","&#x1eb0;","123"],
["&#x1ef4;","&#x1eaf;","102"],
["&#x1ef4;","&#x1eae;","123"],
["&#x1ef4;","&#x1ead;","102"],
["&#x1ef4;","&#x1eac;","123"],
["&#x1ef4;","&#x1eab;","102"],
["&#x1ef4;","&#x1eaa;","123"],
["&#x1ef4;","&#x1ea9;","102"],
["&#x1ef4;","&#x1ea8;","123"],
["&#x1ef4;","&#x1ea6;","123"],
["&#x1ef4;","&#x1ea5;","102"],
["&#x1ef4;","&#x1ea4;","123"],
["&#x1ef4;","&#x1ea3;","102"],
["&#x1ef4;","&#x1ea2;","123"],
["&#x1ef4;","&#x1ea1;","102"],
["&#x1ef4;","&#x1ea0;","123"],
["&#x1ef4;","&#x1b0;","61"],
["&#x1ef4;","&#x1a1;","102"],
["&#x1ef4;","&#x1a0;","41"],
["&#x1ef4;","&#x1e01;","102"],
["&#x1ef4;","&#x1e00;","123"],
["&#x1ef4;","&#x1e3f;","61"],
["&#x1ef4;","&#x201e;","123"],
["&#x1ef4;","&#x201a;","123"],
["&#x1ef4;","&#x219;","82"],
["&#x1ef4;","&#x1ff;","102"],
["&#x1ef4;","&#x1fe;","41"],
["&#x1ef4;","&#x1fd;","102"],
["&#x1ef4;","&#x1fb;","102"],
["&#x1ef4;","&#x1fa;","123"],
["&#x1ef4;","&#x17e;","41"],
["&#x1ef4;","&#x17c;","41"],
["&#x1ef4;","&#x17a;","41"],
["&#x1ef4;","&#x173;","61"],
["&#x1ef4;","&#x171;","61"],
["&#x1ef4;","&#x16f;","61"],
["&#x1ef4;","&#x16d;","61"],
["&#x1ef4;","&#x16b;","61"],
["&#x1ef4;","&#x169;","61"],
["&#x1ef4;","&#x15f;","82"],
["&#x1ef4;","&#x15b;","82"],
["&#x1ef4;","&#x157;","61"],
["&#x1ef4;","&#x155;","61"],
["&#x1ef4;","&#x153;","102"],
["&#x1ef4;","&#x152;","41"],
["&#x1ef4;","&#x151;","102"],
["&#x1ef4;","&#x150;","41"],
["&#x1ef4;","&#x14f;","102"],
["&#x1ef4;","&#x14e;","41"],
["&#x1ef4;","&#x14d;","102"],
["&#x1ef4;","&#x14c;","41"],
["&#x1ef4;","&#x14b;","61"],
["&#x1ef4;","&#x146;","61"],
["&#x1ef4;","&#x144;","61"],
["&#x1ef4;","&#x138;","61"],
["&#x1ef4;","&#x123;","41"],
["&#x1ef4;","&#x122;","41"],
["&#x1ef4;","&#x121;","41"],
["&#x1ef4;","&#x120;","41"],
["&#x1ef4;","&#x11f;","41"],
["&#x1ef4;","&#x11e;","41"],
["&#x1ef4;","&#x11d;","41"],
["&#x1ef4;","&#x11c;","41"],
["&#x1ef4;","&#x11b;","102"],
["&#x1ef4;","&#x119;","102"],
["&#x1ef4;","&#x117;","102"],
["&#x1ef4;","&#x115;","102"],
["&#x1ef4;","&#x113;","102"],
["&#x1ef4;","&#x111;","102"],
["&#x1ef4;","&#x10f;","102"],
["&#x1ef4;","&#x10d;","102"],
["&#x1ef4;","&#x10c;","41"],
["&#x1ef4;","&#x10b;","102"],
["&#x1ef4;","&#x10a;","41"],
["&#x1ef4;","&#x109;","102"],
["&#x1ef4;","&#x108;","41"],
["&#x1ef4;","&#x107;","102"],
["&#x1ef4;","&#x106;","41"],
["&#x1ef4;","&#x105;","102"],
["&#x1ef4;","&#x104;","123"],
["&#x1ef4;","&#x103;","102"],
["&#x1ef4;","&#x102;","123"],
["&#x1ef4;","&#x101;","102"],
["&#x1ef4;","&#x100;","123"],
["&#x1ef4;","&#xfc;","61"],
["&#x1ef4;","&#xfb;","61"],
["&#x1ef4;","&#xfa;","61"],
["&#x1ef4;","&#xf9;","61"],
["&#x1ef4;","&#xf8;","102"],
["&#x1ef4;","&#xf6;","102"],
["&#x1ef4;","&#xf5;","102"],
["&#x1ef4;","&#xf4;","102"],
["&#x1ef4;","&#xf3;","102"],
["&#x1ef4;","&#xf2;","102"],
["&#x1ef4;","&#xeb;","102"],
["&#x1ef4;","&#xea;","102"],
["&#x1ef4;","&#xe9;","102"],
["&#x1ef4;","&#xe8;","102"],
["&#x1ef4;","&#xe7;","102"],
["&#x1ef4;","&#xe6;","102"],
["&#x1ef4;","&#xe5;","102"],
["&#x1ef4;","&#xe4;","102"],
["&#x1ef4;","&#xe3;","102"],
["&#x1ef4;","&#xe2;","102"],
["&#x1ef4;","&#xe1;","102"],
["&#x1ef4;","&#xe0;","102"],
["&#x1ef4;","&#xd8;","41"],
["&#x1ef4;","&#xd6;","41"],
["&#x1ef4;","&#xd5;","41"],
["&#x1ef4;","&#xd4;","41"],
["&#x1ef4;","&#xd3;","41"],
["&#x1ef4;","&#xd2;","41"],
["&#x1ef4;","&#xc7;","41"],
["&#x1ef4;","&#xc5;","123"],
["&#x1ef4;","&#xc4;","123"],
["&#x1ef4;","&#xc3;","123"],
["&#x1ef4;","&#xc2;","123"],
["&#x1ef4;","&#xc1;","123"],
["&#x1ef4;","&#xc0;","123"],
["&#x1ef4;","z","41"],
["&#x1ef4;","u","61"],
["&#x1ef4;","s","82"],
["&#x1ef4;","r","61"],
["&#x1ef4;","q","102"],
["&#x1ef4;","p","61"],
["&#x1ef4;","o","102"],
["&#x1ef4;","n","61"],
["&#x1ef4;","m","61"],
["&#x1ef4;","g","41"],
["&#x1ef4;","e","102"],
["&#x1ef4;","d","102"],
["&#x1ef4;","c","102"],
["&#x1ef4;","a","102"],
["&#x1ef4;","Q","41"],
["&#x1ef4;","O","41"],
["&#x1ef4;","G","41"],
["&#x1ef4;","C","41"],
["&#x1ef4;","A","123"],
["&#x1ef4;","&#x3f;","-41"],
["&#x1ef4;","&#x2e;","123"],
["&#x1ef4;","&#x2c;","123"],
["&#x1ef5;","&#x201e;","82"],
["&#x1ef5;","&#x201d;","-82"],
["&#x1ef5;","&#x201a;","82"],
["&#x1ef5;","&#x2019;","-82"],
["&#x1ef5;","&#x3f;","-41"],
["&#x1ef5;","&#x2e;","82"],
["&#x1ef5;","&#x2c;","82"],
["&#x1ef5;","&#x27;","-82"],
["&#x1ef5;","&#x22;","-82"],
["&#x1ef6;","&#x1ef1;","61"],
["&#x1ef6;","&#x1eef;","61"],
["&#x1ef6;","&#x1eed;","61"],
["&#x1ef6;","&#x1eeb;","61"],
["&#x1ef6;","&#x1ee9;","61"],
["&#x1ef6;","&#x1ee7;","61"],
["&#x1ef6;","&#x1ee5;","61"],
["&#x1ef6;","&#x1ee3;","102"],
["&#x1ef6;","&#x1ee2;","41"],
["&#x1ef6;","&#x1ee1;","102"],
["&#x1ef6;","&#x1ee0;","41"],
["&#x1ef6;","&#x1edf;","102"],
["&#x1ef6;","&#x1ede;","41"],
["&#x1ef6;","&#x1edd;","102"],
["&#x1ef6;","&#x1edc;","41"],
["&#x1ef6;","&#x1edb;","102"],
["&#x1ef6;","&#x1eda;","41"],
["&#x1ef6;","&#x1ed9;","102"],
["&#x1ef6;","&#x1ed8;","41"],
["&#x1ef6;","&#x1ed7;","102"],
["&#x1ef6;","&#x1ed6;","41"],
["&#x1ef6;","&#x1ed5;","102"],
["&#x1ef6;","&#x1ed4;","41"],
["&#x1ef6;","&#x1ed2;","41"],
["&#x1ef6;","&#x1ed1;","102"],
["&#x1ef6;","&#x1ed0;","41"],
["&#x1ef6;","&#x1ecf;","102"],
["&#x1ef6;","&#x1ece;","41"],
["&#x1ef6;","&#x1ecd;","102"],
["&#x1ef6;","&#x1ecc;","41"],
["&#x1ef6;","&#x1ec7;","102"],
["&#x1ef6;","&#x1ec5;","102"],
["&#x1ef6;","&#x1ec3;","102"],
["&#x1ef6;","&#x1ebf;","102"],
["&#x1ef6;","&#x1ebd;","102"],
["&#x1ef6;","&#x1ebb;","102"],
["&#x1ef6;","&#x1eb9;","102"],
["&#x1ef6;","&#x1eb7;","102"],
["&#x1ef6;","&#x1eb6;","123"],
["&#x1ef6;","&#x1eb5;","102"],
["&#x1ef6;","&#x1eb4;","123"],
["&#x1ef6;","&#x1eb3;","102"],
["&#x1ef6;","&#x1eb2;","123"],
["&#x1ef6;","&#x1eb1;","102"],
["&#x1ef6;","&#x1eb0;","123"],
["&#x1ef6;","&#x1eaf;","102"],
["&#x1ef6;","&#x1eae;","123"],
["&#x1ef6;","&#x1ead;","102"],
["&#x1ef6;","&#x1eac;","123"],
["&#x1ef6;","&#x1eab;","102"],
["&#x1ef6;","&#x1eaa;","123"],
["&#x1ef6;","&#x1ea9;","102"],
["&#x1ef6;","&#x1ea8;","123"],
["&#x1ef6;","&#x1ea6;","123"],
["&#x1ef6;","&#x1ea5;","102"],
["&#x1ef6;","&#x1ea4;","123"],
["&#x1ef6;","&#x1ea3;","102"],
["&#x1ef6;","&#x1ea2;","123"],
["&#x1ef6;","&#x1ea1;","102"],
["&#x1ef6;","&#x1ea0;","123"],
["&#x1ef6;","&#x1b0;","61"],
["&#x1ef6;","&#x1a1;","102"],
["&#x1ef6;","&#x1a0;","41"],
["&#x1ef6;","&#x1e01;","102"],
["&#x1ef6;","&#x1e00;","123"],
["&#x1ef6;","&#x1e3f;","61"],
["&#x1ef6;","&#x201e;","123"],
["&#x1ef6;","&#x201a;","123"],
["&#x1ef6;","&#x219;","82"],
["&#x1ef6;","&#x1ff;","102"],
["&#x1ef6;","&#x1fe;","41"],
["&#x1ef6;","&#x1fd;","102"],
["&#x1ef6;","&#x1fb;","102"],
["&#x1ef6;","&#x1fa;","123"],
["&#x1ef6;","&#x17e;","41"],
["&#x1ef6;","&#x17c;","41"],
["&#x1ef6;","&#x17a;","41"],
["&#x1ef6;","&#x173;","61"],
["&#x1ef6;","&#x171;","61"],
["&#x1ef6;","&#x16f;","61"],
["&#x1ef6;","&#x16d;","61"],
["&#x1ef6;","&#x16b;","61"],
["&#x1ef6;","&#x169;","61"],
["&#x1ef6;","&#x15f;","82"],
["&#x1ef6;","&#x15b;","82"],
["&#x1ef6;","&#x157;","61"],
["&#x1ef6;","&#x155;","61"],
["&#x1ef6;","&#x153;","102"],
["&#x1ef6;","&#x152;","41"],
["&#x1ef6;","&#x151;","102"],
["&#x1ef6;","&#x150;","41"],
["&#x1ef6;","&#x14f;","102"],
["&#x1ef6;","&#x14e;","41"],
["&#x1ef6;","&#x14d;","102"],
["&#x1ef6;","&#x14c;","41"],
["&#x1ef6;","&#x14b;","61"],
["&#x1ef6;","&#x146;","61"],
["&#x1ef6;","&#x144;","61"],
["&#x1ef6;","&#x138;","61"],
["&#x1ef6;","&#x123;","41"],
["&#x1ef6;","&#x122;","41"],
["&#x1ef6;","&#x121;","41"],
["&#x1ef6;","&#x120;","41"],
["&#x1ef6;","&#x11f;","41"],
["&#x1ef6;","&#x11e;","41"],
["&#x1ef6;","&#x11d;","41"],
["&#x1ef6;","&#x11c;","41"],
["&#x1ef6;","&#x11b;","102"],
["&#x1ef6;","&#x119;","102"],
["&#x1ef6;","&#x117;","102"],
["&#x1ef6;","&#x115;","102"],
["&#x1ef6;","&#x113;","102"],
["&#x1ef6;","&#x111;","102"],
["&#x1ef6;","&#x10f;","102"],
["&#x1ef6;","&#x10d;","102"],
["&#x1ef6;","&#x10c;","41"],
["&#x1ef6;","&#x10b;","102"],
["&#x1ef6;","&#x10a;","41"],
["&#x1ef6;","&#x109;","102"],
["&#x1ef6;","&#x108;","41"],
["&#x1ef6;","&#x107;","102"],
["&#x1ef6;","&#x106;","41"],
["&#x1ef6;","&#x105;","102"],
["&#x1ef6;","&#x104;","123"],
["&#x1ef6;","&#x103;","102"],
["&#x1ef6;","&#x102;","123"],
["&#x1ef6;","&#x101;","102"],
["&#x1ef6;","&#x100;","123"],
["&#x1ef6;","&#xfc;","61"],
["&#x1ef6;","&#xfb;","61"],
["&#x1ef6;","&#xfa;","61"],
["&#x1ef6;","&#xf9;","61"],
["&#x1ef6;","&#xf8;","102"],
["&#x1ef6;","&#xf6;","102"],
["&#x1ef6;","&#xf5;","102"],
["&#x1ef6;","&#xf4;","102"],
["&#x1ef6;","&#xf3;","102"],
["&#x1ef6;","&#xf2;","102"],
["&#x1ef6;","&#xeb;","102"],
["&#x1ef6;","&#xea;","102"],
["&#x1ef6;","&#xe9;","102"],
["&#x1ef6;","&#xe8;","102"],
["&#x1ef6;","&#xe7;","102"],
["&#x1ef6;","&#xe6;","102"],
["&#x1ef6;","&#xe5;","102"],
["&#x1ef6;","&#xe4;","102"],
["&#x1ef6;","&#xe3;","102"],
["&#x1ef6;","&#xe2;","102"],
["&#x1ef6;","&#xe1;","102"],
["&#x1ef6;","&#xe0;","102"],
["&#x1ef6;","&#xd8;","41"],
["&#x1ef6;","&#xd6;","41"],
["&#x1ef6;","&#xd5;","41"],
["&#x1ef6;","&#xd4;","41"],
["&#x1ef6;","&#xd3;","41"],
["&#x1ef6;","&#xd2;","41"],
["&#x1ef6;","&#xc7;","41"],
["&#x1ef6;","&#xc5;","123"],
["&#x1ef6;","&#xc4;","123"],
["&#x1ef6;","&#xc3;","123"],
["&#x1ef6;","&#xc2;","123"],
["&#x1ef6;","&#xc1;","123"],
["&#x1ef6;","&#xc0;","123"],
["&#x1ef6;","z","41"],
["&#x1ef6;","u","61"],
["&#x1ef6;","s","82"],
["&#x1ef6;","r","61"],
["&#x1ef6;","q","102"],
["&#x1ef6;","p","61"],
["&#x1ef6;","o","102"],
["&#x1ef6;","n","61"],
["&#x1ef6;","m","61"],
["&#x1ef6;","g","41"],
["&#x1ef6;","e","102"],
["&#x1ef6;","d","102"],
["&#x1ef6;","c","102"],
["&#x1ef6;","a","102"],
["&#x1ef6;","Q","41"],
["&#x1ef6;","O","41"],
["&#x1ef6;","G","41"],
["&#x1ef6;","C","41"],
["&#x1ef6;","A","123"],
["&#x1ef6;","&#x3f;","-41"],
["&#x1ef6;","&#x2e;","123"],
["&#x1ef6;","&#x2c;","123"],
["&#x1ef7;","&#x201e;","82"],
["&#x1ef7;","&#x201d;","-82"],
["&#x1ef7;","&#x201a;","82"],
["&#x1ef7;","&#x2019;","-82"],
["&#x1ef7;","&#x3f;","-41"],
["&#x1ef7;","&#x2e;","82"],
["&#x1ef7;","&#x2c;","82"],
["&#x1ef7;","&#x27;","-82"],
["&#x1ef7;","&#x22;","-82"],
["&#x1ef8;","&#x1ef1;","61"],
["&#x1ef8;","&#x1eef;","61"],
["&#x1ef8;","&#x1eed;","61"],
["&#x1ef8;","&#x1eeb;","61"],
["&#x1ef8;","&#x1ee9;","61"],
["&#x1ef8;","&#x1ee7;","61"],
["&#x1ef8;","&#x1ee5;","61"],
["&#x1ef8;","&#x1ee3;","102"],
["&#x1ef8;","&#x1ee2;","41"],
["&#x1ef8;","&#x1ee1;","102"],
["&#x1ef8;","&#x1ee0;","41"],
["&#x1ef8;","&#x1edf;","102"],
["&#x1ef8;","&#x1ede;","41"],
["&#x1ef8;","&#x1edd;","102"],
["&#x1ef8;","&#x1edc;","41"],
["&#x1ef8;","&#x1edb;","102"],
["&#x1ef8;","&#x1eda;","41"],
["&#x1ef8;","&#x1ed9;","102"],
["&#x1ef8;","&#x1ed8;","41"],
["&#x1ef8;","&#x1ed7;","102"],
["&#x1ef8;","&#x1ed6;","41"],
["&#x1ef8;","&#x1ed5;","102"],
["&#x1ef8;","&#x1ed4;","41"],
["&#x1ef8;","&#x1ed2;","41"],
["&#x1ef8;","&#x1ed1;","102"],
["&#x1ef8;","&#x1ed0;","41"],
["&#x1ef8;","&#x1ecf;","102"],
["&#x1ef8;","&#x1ece;","41"],
["&#x1ef8;","&#x1ecd;","102"],
["&#x1ef8;","&#x1ecc;","41"],
["&#x1ef8;","&#x1ec7;","102"],
["&#x1ef8;","&#x1ec5;","102"],
["&#x1ef8;","&#x1ec3;","102"],
["&#x1ef8;","&#x1ebf;","102"],
["&#x1ef8;","&#x1ebd;","102"],
["&#x1ef8;","&#x1ebb;","102"],
["&#x1ef8;","&#x1eb9;","102"],
["&#x1ef8;","&#x1eb7;","102"],
["&#x1ef8;","&#x1eb6;","123"],
["&#x1ef8;","&#x1eb5;","102"],
["&#x1ef8;","&#x1eb4;","123"],
["&#x1ef8;","&#x1eb3;","102"],
["&#x1ef8;","&#x1eb2;","123"],
["&#x1ef8;","&#x1eb1;","102"],
["&#x1ef8;","&#x1eb0;","123"],
["&#x1ef8;","&#x1eaf;","102"],
["&#x1ef8;","&#x1eae;","123"],
["&#x1ef8;","&#x1ead;","102"],
["&#x1ef8;","&#x1eac;","123"],
["&#x1ef8;","&#x1eab;","102"],
["&#x1ef8;","&#x1eaa;","123"],
["&#x1ef8;","&#x1ea9;","102"],
["&#x1ef8;","&#x1ea8;","123"],
["&#x1ef8;","&#x1ea6;","123"],
["&#x1ef8;","&#x1ea5;","102"],
["&#x1ef8;","&#x1ea4;","123"],
["&#x1ef8;","&#x1ea3;","102"],
["&#x1ef8;","&#x1ea2;","123"],
["&#x1ef8;","&#x1ea1;","102"],
["&#x1ef8;","&#x1ea0;","123"],
["&#x1ef8;","&#x1b0;","61"],
["&#x1ef8;","&#x1a1;","102"],
["&#x1ef8;","&#x1a0;","41"],
["&#x1ef8;","&#x1e01;","102"],
["&#x1ef8;","&#x1e00;","123"],
["&#x1ef8;","&#x1e3f;","61"],
["&#x1ef8;","&#x201e;","123"],
["&#x1ef8;","&#x201a;","123"],
["&#x1ef8;","&#x219;","82"],
["&#x1ef8;","&#x1ff;","102"],
["&#x1ef8;","&#x1fe;","41"],
["&#x1ef8;","&#x1fd;","102"],
["&#x1ef8;","&#x1fb;","102"],
["&#x1ef8;","&#x1fa;","123"],
["&#x1ef8;","&#x17e;","41"],
["&#x1ef8;","&#x17c;","41"],
["&#x1ef8;","&#x17a;","41"],
["&#x1ef8;","&#x173;","61"],
["&#x1ef8;","&#x171;","61"],
["&#x1ef8;","&#x16f;","61"],
["&#x1ef8;","&#x16d;","61"],
["&#x1ef8;","&#x16b;","61"],
["&#x1ef8;","&#x169;","61"],
["&#x1ef8;","&#x15f;","82"],
["&#x1ef8;","&#x15b;","82"],
["&#x1ef8;","&#x157;","61"],
["&#x1ef8;","&#x155;","61"],
["&#x1ef8;","&#x153;","102"],
["&#x1ef8;","&#x152;","41"],
["&#x1ef8;","&#x151;","102"],
["&#x1ef8;","&#x150;","41"],
["&#x1ef8;","&#x14f;","102"],
["&#x1ef8;","&#x14e;","41"],
["&#x1ef8;","&#x14d;","102"],
["&#x1ef8;","&#x14c;","41"],
["&#x1ef8;","&#x14b;","61"],
["&#x1ef8;","&#x146;","61"],
["&#x1ef8;","&#x144;","61"],
["&#x1ef8;","&#x138;","61"],
["&#x1ef8;","&#x123;","41"],
["&#x1ef8;","&#x122;","41"],
["&#x1ef8;","&#x121;","41"],
["&#x1ef8;","&#x120;","41"],
["&#x1ef8;","&#x11f;","41"],
["&#x1ef8;","&#x11e;","41"],
["&#x1ef8;","&#x11d;","41"],
["&#x1ef8;","&#x11c;","41"],
["&#x1ef8;","&#x11b;","102"],
["&#x1ef8;","&#x119;","102"],
["&#x1ef8;","&#x117;","102"],
["&#x1ef8;","&#x115;","102"],
["&#x1ef8;","&#x113;","102"],
["&#x1ef8;","&#x111;","102"],
["&#x1ef8;","&#x10f;","102"],
["&#x1ef8;","&#x10d;","102"],
["&#x1ef8;","&#x10c;","41"],
["&#x1ef8;","&#x10b;","102"],
["&#x1ef8;","&#x10a;","41"],
["&#x1ef8;","&#x109;","102"],
["&#x1ef8;","&#x108;","41"],
["&#x1ef8;","&#x107;","102"],
["&#x1ef8;","&#x106;","41"],
["&#x1ef8;","&#x105;","102"],
["&#x1ef8;","&#x104;","123"],
["&#x1ef8;","&#x103;","102"],
["&#x1ef8;","&#x102;","123"],
["&#x1ef8;","&#x101;","102"],
["&#x1ef8;","&#x100;","123"],
["&#x1ef8;","&#xfc;","61"],
["&#x1ef8;","&#xfb;","61"],
["&#x1ef8;","&#xfa;","61"],
["&#x1ef8;","&#xf9;","61"],
["&#x1ef8;","&#xf8;","102"],
["&#x1ef8;","&#xf6;","102"],
["&#x1ef8;","&#xf5;","102"],
["&#x1ef8;","&#xf4;","102"],
["&#x1ef8;","&#xf3;","102"],
["&#x1ef8;","&#xf2;","102"],
["&#x1ef8;","&#xeb;","102"],
["&#x1ef8;","&#xea;","102"],
["&#x1ef8;","&#xe9;","102"],
["&#x1ef8;","&#xe8;","102"],
["&#x1ef8;","&#xe7;","102"],
["&#x1ef8;","&#xe6;","102"],
["&#x1ef8;","&#xe5;","102"],
["&#x1ef8;","&#xe4;","102"],
["&#x1ef8;","&#xe3;","102"],
["&#x1ef8;","&#xe2;","102"],
["&#x1ef8;","&#xe1;","102"],
["&#x1ef8;","&#xe0;","102"],
["&#x1ef8;","&#xd8;","41"],
["&#x1ef8;","&#xd6;","41"],
["&#x1ef8;","&#xd5;","41"],
["&#x1ef8;","&#xd4;","41"],
["&#x1ef8;","&#xd3;","41"],
["&#x1ef8;","&#xd2;","41"],
["&#x1ef8;","&#xc7;","41"],
["&#x1ef8;","&#xc5;","123"],
["&#x1ef8;","&#xc4;","123"],
["&#x1ef8;","&#xc3;","123"],
["&#x1ef8;","&#xc2;","123"],
["&#x1ef8;","&#xc1;","123"],
["&#x1ef8;","&#xc0;","123"],
["&#x1ef8;","z","41"],
["&#x1ef8;","u","61"],
["&#x1ef8;","s","82"],
["&#x1ef8;","r","61"],
["&#x1ef8;","q","102"],
["&#x1ef8;","p","61"],
["&#x1ef8;","o","102"],
["&#x1ef8;","n","61"],
["&#x1ef8;","m","61"],
["&#x1ef8;","g","41"],
["&#x1ef8;","e","102"],
["&#x1ef8;","d","102"],
["&#x1ef8;","c","102"],
["&#x1ef8;","a","102"],
["&#x1ef8;","Q","41"],
["&#x1ef8;","O","41"],
["&#x1ef8;","G","41"],
["&#x1ef8;","C","41"],
["&#x1ef8;","A","123"],
["&#x1ef8;","&#x3f;","-41"],
["&#x1ef8;","&#x2e;","123"],
["&#x1ef8;","&#x2c;","123"],
["&#x1ef9;","&#x201e;","82"],
["&#x1ef9;","&#x201d;","-82"],
["&#x1ef9;","&#x201a;","82"],
["&#x1ef9;","&#x2019;","-82"],
["&#x1ef9;","&#x3f;","-41"],
["&#x1ef9;","&#x2e;","82"],
["&#x1ef9;","&#x2c;","82"],
["&#x1ef9;","&#x27;","-82"],
["&#x1ef9;","&#x22;","-82"],
["&#x162;","&#x162;","-41"],
["&#x162;","&#x1ef5;","41"],
["&#x162;","&#x1ef1;","102"],
["&#x162;","&#x1eef;","102"],
["&#x162;","&#x1eed;","102"],
["&#x162;","&#x1eeb;","102"],
["&#x162;","&#x1ee9;","102"],
["&#x162;","&#x1ee7;","102"],
["&#x162;","&#x1ee5;","102"],
["&#x162;","&#x1ee3;","143"],
["&#x162;","&#x1ee2;","41"],
["&#x162;","&#x1ee1;","143"],
["&#x162;","&#x1ee0;","41"],
["&#x162;","&#x1edf;","143"],
["&#x162;","&#x1ede;","41"],
["&#x162;","&#x1edd;","143"],
["&#x162;","&#x1edc;","41"],
["&#x162;","&#x1edb;","143"],
["&#x162;","&#x1eda;","41"],
["&#x162;","&#x1ed9;","143"],
["&#x162;","&#x1ed8;","41"],
["&#x162;","&#x1ed7;","143"],
["&#x162;","&#x1ed6;","41"],
["&#x162;","&#x1ed5;","143"],
["&#x162;","&#x1ed4;","41"],
["&#x162;","&#x1ed2;","41"],
["&#x162;","&#x1ed1;","143"],
["&#x162;","&#x1ed0;","41"],
["&#x162;","&#x1ecf;","143"],
["&#x162;","&#x1ece;","41"],
["&#x162;","&#x1ecd;","143"],
["&#x162;","&#x1ecc;","41"],
["&#x162;","&#x1ec7;","143"],
["&#x162;","&#x1ec5;","143"],
["&#x162;","&#x1ec3;","143"],
["&#x162;","&#x1ebf;","143"],
["&#x162;","&#x1ebd;","143"],
["&#x162;","&#x1ebb;","143"],
["&#x162;","&#x1eb9;","143"],
["&#x162;","&#x1eb7;","164"],
["&#x162;","&#x1eb6;","143"],
["&#x162;","&#x1eb5;","164"],
["&#x162;","&#x1eb4;","143"],
["&#x162;","&#x1eb3;","164"],
["&#x162;","&#x1eb2;","143"],
["&#x162;","&#x1eb1;","164"],
["&#x162;","&#x1eb0;","143"],
["&#x162;","&#x1eaf;","164"],
["&#x162;","&#x1eae;","143"],
["&#x162;","&#x1ead;","164"],
["&#x162;","&#x1eac;","143"],
["&#x162;","&#x1eab;","164"],
["&#x162;","&#x1eaa;","143"],
["&#x162;","&#x1ea9;","164"],
["&#x162;","&#x1ea8;","143"],
["&#x162;","&#x1ea6;","143"],
["&#x162;","&#x1ea5;","164"],
["&#x162;","&#x1ea4;","143"],
["&#x162;","&#x1ea3;","164"],
["&#x162;","&#x1ea2;","143"],
["&#x162;","&#x1ea1;","164"],
["&#x162;","&#x1ea0;","143"],
["&#x162;","&#x1b0;","102"],
["&#x162;","&#x1a1;","143"],
["&#x162;","&#x1a0;","41"],
["&#x162;","&#x1e01;","164"],
["&#x162;","&#x1e00;","143"],
["&#x162;","&#x1e3f;","102"],
["&#x162;","&#x201e;","123"],
["&#x162;","&#x201a;","123"],
["&#x162;","&#x2015;","82"],
["&#x162;","&#x2014;","82"],
["&#x162;","&#x2013;","82"],
["&#x162;","&#x1e83;","41"],
["&#x162;","&#x1e81;","41"],
["&#x162;","&#x219;","123"],
["&#x162;","&#x1ff;","143"],
["&#x162;","&#x1fe;","41"],
["&#x162;","&#x1fd;","164"],
["&#x162;","&#x1fb;","164"],
["&#x162;","&#x1fa;","143"],
["&#x162;","&#x17e;","82"],
["&#x162;","&#x17c;","82"],
["&#x162;","&#x17a;","82"],
["&#x162;","&#x175;","41"],
["&#x162;","&#x173;","102"],
["&#x162;","&#x171;","102"],
["&#x162;","&#x16f;","102"],
["&#x162;","&#x16d;","102"],
["&#x162;","&#x16b;","102"],
["&#x162;","&#x169;","102"],
["&#x162;","&#x164;","-41"],
["&#x162;","&#x21a;","-41"],
["&#x162;","&#x15f;","123"],
["&#x162;","&#x15b;","123"],
["&#x162;","&#x157;","102"],
["&#x162;","&#x155;","102"],
["&#x162;","&#x153;","143"],
["&#x162;","&#x152;","41"],
["&#x162;","&#x151;","143"],
["&#x162;","&#x150;","41"],
["&#x162;","&#x14f;","143"],
["&#x162;","&#x14e;","41"],
["&#x162;","&#x14d;","143"],
["&#x162;","&#x14c;","41"],
["&#x162;","&#x14b;","102"],
["&#x162;","&#x146;","102"],
["&#x162;","&#x144;","102"],
["&#x162;","&#x138;","102"],
["&#x162;","&#x123;","143"],
["&#x162;","&#x122;","41"],
["&#x162;","&#x121;","143"],
["&#x162;","&#x120;","41"],
["&#x162;","&#x11f;","143"],
["&#x162;","&#x11e;","41"],
["&#x162;","&#x11d;","143"],
["&#x162;","&#x11c;","41"],
["&#x162;","&#x11b;","143"],
["&#x162;","&#x119;","143"],
["&#x162;","&#x117;","143"],
["&#x162;","&#x115;","143"],
["&#x162;","&#x113;","143"],
["&#x162;","&#x111;","143"],
["&#x162;","&#x10f;","143"],
["&#x162;","&#x10d;","143"],
["&#x162;","&#x10c;","41"],
["&#x162;","&#x10b;","143"],
["&#x162;","&#x10a;","41"],
["&#x162;","&#x109;","143"],
["&#x162;","&#x108;","41"],
["&#x162;","&#x107;","143"],
["&#x162;","&#x106;","41"],
["&#x162;","&#x105;","164"],
["&#x162;","&#x104;","143"],
["&#x162;","&#x103;","164"],
["&#x162;","&#x102;","143"],
["&#x162;","&#x101;","164"],
["&#x162;","&#x100;","143"],
["&#x162;","&#xfd;","41"],
["&#x162;","&#xfc;","102"],
["&#x162;","&#xfb;","102"],
["&#x162;","&#xfa;","102"],
["&#x162;","&#xf9;","102"],
["&#x162;","&#xf8;","143"],
["&#x162;","&#xf6;","143"],
["&#x162;","&#xf5;","143"],
["&#x162;","&#xf4;","143"],
["&#x162;","&#xf3;","143"],
["&#x162;","&#xf2;","143"],
["&#x162;","&#xeb;","143"],
["&#x162;","&#xea;","143"],
["&#x162;","&#xe9;","143"],
["&#x162;","&#xe8;","143"],
["&#x162;","&#xe7;","143"],
["&#x162;","&#xe6;","164"],
["&#x162;","&#xe5;","164"],
["&#x162;","&#xe4;","164"],
["&#x162;","&#xe3;","164"],
["&#x162;","&#xe2;","164"],
["&#x162;","&#xe1;","164"],
["&#x162;","&#xe0;","143"],
["&#x162;","&#xd8;","41"],
["&#x162;","&#xd6;","41"],
["&#x162;","&#xd5;","41"],
["&#x162;","&#xd4;","41"],
["&#x162;","&#xd3;","41"],
["&#x162;","&#xd2;","41"],
["&#x162;","&#xc7;","41"],
["&#x162;","&#xc5;","143"],
["&#x162;","&#xc4;","143"],
["&#x162;","&#xc3;","143"],
["&#x162;","&#xc2;","143"],
["&#x162;","&#xc1;","143"],
["&#x162;","&#xc0;","143"],
["&#x162;","z","82"],
["&#x162;","y","41"],
["&#x162;","x","41"],
["&#x162;","w","41"],
["&#x162;","v","41"],
["&#x162;","u","102"],
["&#x162;","s","123"],
["&#x162;","r","102"],
["&#x162;","q","143"],
["&#x162;","p","102"],
["&#x162;","o","143"],
["&#x162;","n","102"],
["&#x162;","m","102"],
["&#x162;","g","143"],
["&#x162;","e","143"],
["&#x162;","d","143"],
["&#x162;","c","143"],
["&#x162;","a","164"],
["&#x162;","T","-41"],
["&#x162;","Q","41"],
["&#x162;","O","41"],
["&#x162;","G","41"],
["&#x162;","C","41"],
["&#x162;","A","143"],
["&#x162;","&#x3f;","-41"],
["&#x162;","&#x2e;","123"],
["&#x162;","&#x2d;","82"],
["&#x162;","&#x2c;","123"],
["&#x163;","&#x201d;","-41"],
["&#x163;","&#x2019;","-41"],
["&#x163;","&#x27;","-41"],
["&#x163;","&#x22;","-41"],
];

