/*
  ARCS:

  180 degree arcs between two points can be problematic, rounding errors may make the radius too small to span the distance, non-180 arcs don't suffer this problem, so, if you need a 180, use two 90s when writing path strings, unless you hate yourself...
*/

/*
  IMPORTANT:

  This SVG library has more than reasonable tolerance for garbage in the path-string that it's being fed, but it appears to draw the line at /newline and /return characters. I can live with that.

  Be nice. Please feed it a _single line string_.
*/

/*
  Parse any legal, single line, SVG path-string (SVG "d" parameter) and generate an OpenSCAD points-list and faces for the polygons equivalent to the SVG paths.

  OpenSCAD isn't Inkscape. This does NOT interpret 'stroke' and whatnot.
  Only polygons are formed, and I'm not very likely to change that (or my mind) anytime soon.
*/

/*
  $SVGC is used to pass the value of SVG_Coords (flip image in X-axis).
*/

/*
  *Path* can be given as a string

  SVG("M 5 5 A 3 7 0 0 1 9 11 L 3 4 6 2" )

  or as a tuple of string (commands) and (parameter) values like:

  SVG([
        "M",_Height/2,_Height,
        "A",_Height,_Height,0,0,1,_Height*_MaD,-_Pitch/2,
        "L",_Height*_MiD,-_Pitch/2,
            _Height*_MiD, _Pitch/2
    ])

    Which is jolly nice.

*/
function SVG(Path,SVG_Coords=false,Size=[1,1])=
    let(
        /* Parse the pathstring into something we can work with. */
        PathCommands=SVGParsePath(
            IsString(Path)
            ?   Path
            :   TupleToString(Path," ")
        ),
        /* Generate the points-lists of the path(s), we _know_ the first command because 'SVGParsePath' will force it to be M or m. */
        Result=SVG_M(PathCommands=PathCommands,CC=[0,0,0],Paths=[[]],Calls=1,$SVGC=SVG_Coords),
        Paths=Result[0],
        Calls=Result[1],
        /* Turn the paths into a single array of points for polygon(). Also apply the 'Size' multiplication. */
        PolyPoints=AffineTransform(ScalingMatrix([Size.x,SVG_Coords?-Size.y:Size.y,1]),FlattenArray(Paths)),
        /* Generate the 'paths' parameter for polygon(). This is an array of arrays of points, each listing the points (from the single points-list 'PolyPoints') that form the individual paths. */
        NPaths=Len(Paths),
        PolyPaths=concat( // Main path.
            [
                RangeToTuple([0:Len(Paths[0])])
            ],
            // Additional paths, if present.
            NPaths==0?[]:
            [
                for(Idex=[1:NPaths])
                    ArrayAdd(
                        RangeToTuple([0:Len(Paths[Idex])])
                        ,ArraySum(
                            [
                                for(Jdex=[0:Idex-1])
                                    len(Paths[Jdex])
                            ]
                        )
                    )
            ]
        ),
        Foo=Debug(["SVG: ",len(PolyPoints)," points in ",len(PolyPaths)," paths from ",Calls," command calls."])
    )
    [PolyPoints,PolyPaths]
;


module SVG(Path,SVG_Coords=false,Size=[1,1])
{
    Polygon=SVG(Path,SVG_Coords,Size);
    polygon(Polygon[0],Polygon[1]);
}


