/*
  Add points to the polygon points-list and invoke the next command on the path.
*/
function SVGNextCommand(PathCommands,CC,Paths,Points,LastCommand,Calls)=
    let(
        Path=PathCommands[CC[0]], // current path index
        Command=PathCommands[CC[0]][CC[1]], // current command
        Parameter=CC[2], // NEXT parameter index (increased by previous execution of current command)
        Pdex=Len(Path), // current path last command index
        Cdex=Len(Command), // current command last parameter index
        Odex=Len(Paths), // current vertex-path index

        Ndex=Len(Paths[Odex]), // number of vertices in current vertex-path
        _Paths=(Command[0]=="M"||Command[0]=="m") // is current command a M/move?
        ?   Len(Paths[Odex])<0 // is this the initial *empty* vertex-path?
            ?   [Points] // Points *becomes the initial path*
            :   concat(Paths,[Points]) // Points *becomes an additional path*
        :   Odex==0 // is this the first (initial) vertex-path?
            ?   [concat(Paths[Odex],Points)] // add Points to the current path
            :   [
                    for(Idex=[0:Odex-1])
                        Paths[Idex],
                    concat(Paths[Odex],Points)
                ],
        CC2=CC[2]>Cdex // parameter index beyond current command length?
        ?   1 // reset parameter to go to the next command
        :   CC[2], // keep parameter index
        CC1=CC2==1 // parameter has been reset?
        ?   CC[1]==Pdex // current command is last of current path?
            ?   0 // reset command to go to the next command-path
            :   CC[1]+1 // select next command of current path
        :   CC[1], // keep current command index (i.e: multiple parameter sets)
        CC0=CC1==0 // command has been reset? (i.e.: go to next path)
        ?   CC[0]==Len(PathCommands) // current path is last path?
            ?   undef // we're done!
            :   CC[0]+1 // select next path
        :   CC[0], // keep current path index (i.e.: path is not finished)
        _CC=[CC0,CC1,CC2],
        Next=PathCommands[CC0][CC1][0] // name of next command (iteration) to execute
    )
    undef==Next[0] // are we done? (path is set to 'undef')
    ?   [_Paths,Calls] // we're done, return vertex paths (polygon points) and number of calls
    :   (Next=="A"||Next=="a") // arc
      ?   SVG_A(PathCommands,_CC,_Paths,LastCommand,Calls+1)
      :   (Next=="B"||Next=="b")  // * chamfer
        ?   SVG_B(PathCommands,_CC,_Paths,LastCommand,Calls+1)
        :   (Next=="C"||Next=="c") // cubic Bézier
          ?   SVG_C(PathCommands,_CC,_Paths,LastCommand,Calls+1)
          :   (Next=="E"||Next=="e") // * extend last segment
            ?   SVG_C(PathCommands,_CC,_Paths,LastCommand,Calls+1)
            :   (Next=="F"||Next=="f") // * fillet
              ?   SVG_C(PathCommands,_CC,_Paths,LastCommand,Calls+1)
              :   (Next=="H"||Next=="h") // horizontal line
                ?   SVG_H(PathCommands,_CC,_Paths,LastCommand,Calls+1)
                :   (Next=="L"||Next=="l") // free line
                  ?   SVG_L(PathCommands,_CC,_Paths,LastCommand,Calls+1)
                  :   (Next=="M"||Next=="m") // move
                    ?   SVG_M(PathCommands,_CC,_Paths,LastCommand,Calls+1)
                    :   (Next=="Q"||Next=="q") // quadratic Bézier
                      ?   SVG_Q(PathCommands,_CC,_Paths,LastCommand,Calls+1)
                      :   (Next=="R"||Next=="r") // * radius
                        ?   SVG_R(PathCommands,_CC,_Paths,LastCommand,Calls+1)
                        :   (Next=="S"||Next=="s") // smooth cubic Bézier
                          ?   SVG_S(PathCommands,_CC,_Paths,LastCommand,Calls+1)
                          :   (Next=="T"||Next=="t") // smooth quadratic Bézier
                            ?   SVG_T(PathCommands,_CC,_Paths,LastCommand,Calls+1)
                            :   (Next=="V"||Next=="v") // vertical line
                              ?   SVG_V(PathCommands,_CC,_Paths,LastCommand,Calls+1)
                              :   (Next=="Z"||Next=="z") // close shape (makes no sense for OpenSCAD polygon use)
                                ?   SVG_Z(PathCommands,_CC,_Paths,LastCommand,Calls+1) // not currently implemented
                                :   undef // something is horribly wrong...

    /* Commands marked with an asterisk are not part of the regular SVG syntax. They are part of this library's 'SVG+' syntax. */
;

