/*
  find parameter positions in command (parameter start locations in the string)

  This is where the hard work of path-string parsing is done.

  CommandAscii, array, ascii values of command string
  Idex, scalar, counter, starts at 1 because 0 position is the command letter itself
  DotFlag, boolean, while 'walking' through the array, the first valid parameter character triggers the DotFlag to 'true' so
  Positions, array, result.
*/
function SVGParameterPositions(CommandAscii,Idex=1,DotFlag=false,Positions=[])=
    let(
        Character=CommandAscii[Idex], // ascii value of current character
        ValidCHar=IsInArray(Character,NumericAscii), // Character is a valid parameter character if 'true'
        ValidPreChar=IsInArray(CommandAscii[Idex-1],NumericAscii), // previous character is a valid parameter character if 'true'
        Location=!ValidCHar // Character is *not* a valid parameter character?
        ?   [] // this is not a parameter start location
        /* Character is a valid parameter character: */
        :   45==Character // negative sign?
            ?   [Idex] // this *is* the start of a new parameter
            :   46==Character // decimal?
                ?   DotFlag // dotflag true? (i.e. we're in the middle of a parameter)
                    ?   [] // not a parameter start, it's the decimal of this parameter
                    :   [Idex] // this *is* the start of a new parameter (e.g. '.34')
                // is the *previous* character a valid parameter character
                :   ValidPreChar
                    ?   [] // not a parameter start (i.e. we're in the middle of a parameter)
                    :   [Idex], // this *is* the start of a new parameter (e.g. '3.4')
        // is Character a decimal?
        _DotFlag=46==Character // Character is a decimal?
        ?   false // reset DotFlag, next decimal we find will trigger a parameter start location
        :   []!=Location // are we a valid parameter start?
            ?   true // set DotFlag, the next decimal we find will be this parameter's decimal and will *not* trigger a parameter start location
            /* not a decimal and not a parameter start. */
            :   !ValidCHar // Character is not a valid parameter chatacter?
                ?   false // reset DotFlag, next decimal is a parameter start
                :   DotFlag // we're in the middle of a parameter, leave DotFlag alone
    )
    Idex==Len(CommandAscii) // are we done?
    ?   concat(Positions,Location) // return result
    :   SVGParameterPositions(CommandAscii,Idex+1,_DotFlag,concat(Positions,Location)) // recurse with next character
;

