/*
  IMPORTANT:

  This SVG library is more than reasonable with regards to tolerating garbage in the path-string that it's being fed, but it appears to draw the line at /newline and /return characters. I can live with that, they have no place in an SVG path to begin with.

  * Be nice. Please feed it a _single line string_.
*/

/*
  PathString is the SVG "d" string.
  This this will parse any legal, single line, path-string that conforms to the SVG standard.
  If the first command is _not_ "M" or "m", "M 0,0" will be prepended.
*/
function SVGParsePath(PathString)=
    let(
        /* Initialise PathString with 'move' command if not already present. This is required to mark the start of each path for the following operation. */
        InitString=
            str(
                (PathString[0]=="M"||PathString[0]=="m")
                ?   ""
                :   "M 0,0 "
                ,PathString
            ),
        /* Find all 'move' commands. */
        Moves=SVGPathMovePositions(InitString),
        /* Split into sub-paths at 'move' commands. */
        PathStrings=len(Moves)==1
        /* There is only one path. */
        ?   [InitString]
        /* Create sub-path list. */
        :   [
                for(Idex=[0:1:len(Moves)-2])
                    SubString(InitString,Moves[Idex],Moves[Idex+1]-1),
                    /* The end of the last command is the end of the string. */
                    SubString(InitString,Moves[Len(Moves)],Len(InitString))
        ],
        /* put all the separate paths and commands in an array */
        CommandLists=[
            for(Path=PathStrings)
            let(
                Positions=SVGCommandPositions(Path)
            )
            [
                for(Idex=[0:1:len(Positions)-2])
                    SubString(Path,Positions[Idex],Positions[Idex+1]-1),
                    /* The end of the last command is the end of the string. */
                    SubString(Path,Positions[Len(Positions)],Len(Path))
            ]
        ]
    )
    /* Parse Commands and Parameters. */
    // the shape (path-string)
    [
        for(List=CommandLists)
        // subpaths -------------------
        [
            for(Command=List)
            let(
                /* Find parameter start positions. */
                Parameters=concat(SVGParameterPositions(AsciiMapString(Command)),[len(Command)])
            )
            // commands --------------------
            [
                Command[0],
                // parameters -----------------
                for(Idex=[0:Len(Parameters)-1])
                StringToDecimal(SubString(Command,Parameters[Idex],Parameters[Idex+1]-1))
            ]
        ]
    ]
;

