/*
  Arc: A/a (Rx,Ry,X-Rotation,Large-Arc,Sweep,Nx,Ny)+
*/
function SVG_A(PathCommands,CC,Paths,LastCommand,Calls=1,PointsOnly=false)=
    let(
        Pmr=CC[2], // current parameter
        Command=PathCommands[CC[0]][CC[1]], // current command
        CurrentVertex=Last(LastCommand), // current path's last vertex
        XRadius=Command[Pmr],
        YRadius=Command[Pmr+1],
        Radius=min(XRadius,YRadius), // we are going to scale the ellipse into a circle with the min. of the two radii
        Rotation=Command[Pmr+2],
        LargeArc=Command[Pmr+3],
        Sweep=Command[Pmr+4],
        NextVertex=[Command[Pmr+5],Command[Pmr+6]]+(Command[0]=="a"?CurrentVertex:[0,0]), // endpoint of this arc
    // an ellipse is just a stretched circle, so we're going to un-rotate and un-stretch this ellipse and solve it as a nice and easy circle-arc
    /* Transform ellipse into a circle. */
        NextVertex1=NextVertex-CurrentVertex, // translate to origin
        NextVertex2=AffineTransform(RotationMatrix([0,0,-Rotation]),NextVertex1,true), // rotate ellipse parallel to x-axis
        NextVertex3=AffineTransform(ScalingMatrix([Radius/XRadius,Radius/YRadius,1]),NextVertex2,true), // un-stretch ellipse into a circle

    /* Points and distances needed for center coordinates calcs. */
        MidPoint=NextVertex3/2,
        Delta=Modulus(NextVertex3),
    /* SVG is quite forgiving for non-fitting radii... we'll honour their philosophy, but only within reasonable limits, I'm using 10% here. */
        _Radius=((Radius*2)>=Delta)
        ?   Radius
        :   ((Delta-2*Radius)/Delta)<0.1 // are we within 'forgiveness' limits?
            ?   Delta/2+Alert(["Ellipse axes too small by ",Delta/2-Radius,", Command: ",Command])
            :   Stop(["Ellipse axes too small for vertex distance. CC= ",CC," Current vertex= ",CurrentVertex," Command: ",Command]),
    /* LargeArc causes the large part of _the other fitting ellipse_ to be drawn, for this we need the Apex to flip to the other side of the line connecting Start to End. Sweep needs to do the flip (that's what Sweep does). The whole '(2*abs(LargeArc-Sweep)-1)' was a bit of a cruncher, feel free to figure it out... */
        /* Find the distance between the Start-End line and the circle center */
        Apex=sqrt(pow(_Radius,2)-pow(Delta/2,2))*(2*abs(LargeArc-Sweep)-1),
        /* A little trig gets us the relative center coordinates. */
        RCenter=
            [
                Apex/Delta*NextVertex3.y*-1,
                Apex/Delta*NextVertex3.x
            ],
        /* And the actual center coordinates... */
        ACenter=MidPoint+RCenter,
        StartAngle=SegmentDirection(ACenter,[0,0]).z,
        EndAngle=SegmentDirection(ACenter,NextVertex3).z,
    /* When 'ACenter' lies below the X-axis, 'EndAngle-StartAngle' becomes _negative_, we need this to remain positive so that, looking from Start to End, 'ACenter' lies to the left, and the arc curve to the right ('LargeArc'='Sweep'=0), regardless of relative position of Start and End. */
        Diff=(EndAngle-StartAngle+360)%360,
    /*  Sweep selects direction (ccw/cw) of arc, 'standard' ('LargeArc'='Sweep'=0) is ccw (to the right of the Start-to-End line looking forward). */
        IncludedAngle=Diff-360*(1-Sweep),
    /* If $fn is too small this stumbles without the max(1,...). */
        Steps=max(1,round(abs(IncludedAngle)/360*Segments((XRadius+YRadius)/2))),
        RPoints=[
            for(Idex=[1:Steps])
                [
                    ACenter.x+cos(StartAngle+Idex/Steps*IncludedAngle)*_Radius,
                    ACenter.y+sin(StartAngle+Idex/Steps*IncludedAngle)*_Radius
                ]
        ],

    /*
      For user info, find foci.
    */
        ACenter0=AffineTransform(ScalingMatrix([XRadius/Radius,YRadius/Radius,1]),ACenter,true), // stretch back into the ellipse
        FociDistance=XRadius==YRadius
        ?   0
        :   sqrt(Pow2(max(XRadius,YRadius))-Pow2(min(XRadius,YRadius))),
        Foci2=FociDistance==0
        ?   [ACenter0,ACenter0,ACenter0]
        :   XRadius>YRadius
            ?   [[ACenter0[0]-FociDistance,ACenter0[1]],ACenter0,[ACenter0[0]+FociDistance,ACenter0[1]]]
            :   [[ACenter0[0],ACenter0[1]-FociDistance],ACenter0,[ACenter0[0],ACenter0[1]+FociDistance]],
        // rotate back to original angle
        Foci1=AffineTransform(RotationMatrix([0,0,Rotation]),Foci2,true),
        // translate back into position
        Foci=ArrayAdd(Foci1,CurrentVertex),
    /* During command execution, SVG Coordinates are not yet applied, i.e., we're interpreting positive Y-coordinates as above the X-axis. SVG() will mirror the path-points-arrays in the X-axis if they apply, but we need to publish these values here, correctly, so we grab $SVGC which tells us about the necessity to mirror Y-values, or not. ScaleArray() does the job. */
    Foo=Echo([CC," Foci= ",ScaleArray(Foci,[1,($SVGC?-1:1)])]),

    /* Transform circle back into the ellipse. */
        Points2=AffineTransform(ScalingMatrix([XRadius/Radius,YRadius/Radius,1]),RPoints,true), // stretch back into the ellipse
        Points1=AffineTransform(RotationMatrix([0,0,Rotation]),Points2,true), // rotate back to original angle
        Points=ArrayAdd(Points1,CurrentVertex), // translate back into position
        _LastCommand=[Command[0],NextVertex]
    )
    PointsOnly // is this an 'out of path' call for a points-list only?
    ?   Points // return the points-list
    :   SVGNextCommand(PathCommands,[CC[0],CC[1],CC[2]+7],Paths,Points,_LastCommand,Calls) // hand over to the next command in 'PathCommands'
;
