/*
  Cubic Bézier: C/c (C1x,C1y,C2x,C2y,Nx,Ny)+.
*/
function SVG_C(PathCommands,CC,Paths,LastCommand,Calls=1,PointsOnly=false)=
    let(
        Pmr=CC[2], // current parameter
        Command=PathCommands[CC[0]][CC[1]], // current command
        CurrentVertex=Last(LastCommand), // current path's last vertex
        ControlPoint1=[Command[Pmr],Command[Pmr+1]]+(Command[0]=="c"?CurrentVertex:[0,0]),
        ControlPoint2=[Command[Pmr+2],Command[Pmr+3]]+(Command[0]=="c"?CurrentVertex:[0,0]),
        NextVertex=[Command[Pmr+4],Command[Pmr+5]]+(Command[0]=="c"?CurrentVertex:[0,0]),
        Steps=round(Segments()/3), // 3, probably chosen because expecting more than 120 degrees from a Bézier curve is silly.
        Points=
            [
                for(Idex=[1:Steps]) /* start at 1 because initial point is CurrentVertex */
                    CBezierVertex(
                        [
                            CurrentVertex,
                            ControlPoint1,
                            ControlPoint2,
                            NextVertex
                        ],
                        Idex/Steps
                    )
            ],
        _LastCommand=[Command[0],ControlPoint2,NextVertex]
    )
    PointsOnly // is this an 'out of path' call for a points-list only?
    ?   Points // return the points-list
    :   SVGNextCommand(PathCommands,[CC[0],CC[1],CC[2]+6],Paths,Points,_LastCommand,Calls)
;
