/*
  Horizontal line: H/h (Coord/Dist)+
*/
function SVG_H(PathCommands,CC,Paths,LastCommand,Calls=1,PointsOnly=false)=
    let(
        Command=PathCommands[CC[0]][CC[1]], // current command
        Cdex=Len(Command), // current command length
        CurrentVertex=Last(LastCommand), // current path's last vertex
        Points=Command[0]=="h"
        ?   [
                for(Idex=[1:Cdex])
                    [
                        ArraySum(
                            [
                                for(Jdex=[1:Idex])
                                    Command[Jdex],
                                    CurrentVertex.x
                            ]
                        ),
                        CurrentVertex.y
                    ]
            ]
        :   [
                for(Idex=[1:Cdex])
                    [Command[Idex],CurrentVertex.y]
            ],
        _LastCommand=[Command[0],Last(Points)]
    )
    PointsOnly // is this an 'out of path' call for a points-list only?
    ?   Points // return the points-list
    :   SVGNextCommand(PathCommands,[CC[0],CC[1],len(Command)],Paths,Points,_LastCommand,Calls) // hand over to the next command in 'PathCommands'
;

