/*
  Line to: L/l (Nx,Ny)+
*/
function SVG_L(PathCommands,CC,Paths,LastCommand,Calls=1,PointsOnly=false)=
    let(
        Command=PathCommands[CC[0]][CC[1]], // current command
        Cdex=Len(Command), // current command length
        CurrentVertex=Last(LastCommand), // current path's last vertex
        Points=Command[0]=="l"
        ?   [
                for(Idex=[1:2:Cdex])
                    ArraySum(
                        [
                            for(Jdex=[1:2:Idex])
                                [Command[Jdex],Command[Jdex+1]],
                                CurrentVertex
                        ]
                    )
            ]
        :   [
                for(Idex=[1:2:Cdex])
                    [Command[Idex],Command[Idex+1]]
            ],
        _LastCommand=[Command[0],Last(Points)]
    )
    PointsOnly
    ?   Points
    /* Set Parameter index to last parameter in 'CC' to trigger next command. */
    :   SVGNextCommand(PathCommands,[CC[0],CC[1],len(Command)],Paths,Points,_LastCommand,Calls)
;

