/*
  Smooth Cubic Bézier: S/s (C2x,C2y,Nx,Ny)+.

  This command only makes sense AFTER an initial C/cubic, S/smooth cubic or Q/quadratic Bézier curve, because it needs the last control point of the _previous_ command for the initial direction. It would be possible to get a direction vector from other previous commands, but there would be no _sensible_ length information... Calling this without a preceding C/c/S/s/Q/q will therefore result in a 'Stop' error.
*/
function SVG_S(PathCommands,CC,Paths,LastCommand,Calls=1,PointsOnly=false,$fn=60)=
    let(
        Pmr=CC[2], // current parameter
        Command=PathCommands[CC[0]][CC[1]], // current command
        CurrentVertex=Last(LastCommand), // current path's last vertex
        Foo=CC[1]==0
        ?   Stop(["Smooth Cubic Bézier (S/s) called without preceding command. CC= ",CC])
        :   0,
        LastControlPoint=IsInArray(LastCommand[0],["C","c","S","s","T","t","Q","q"]) // last command is Bézier curve? Outside [] needed because search() treats strings--let's be nice--'peculiarly', so to say...
        ?   LastCommand[Len(LastCommand)-1] // get the last ControlPoint from last command
        :   CurrentVertex+Alert(["Smooth Cubic Bézier (S/s) called without preceding Bézier curve command. CC= ",CC],Value=[0,0]),
        ControlPoint1=2*CurrentVertex-LastControlPoint,
        ControlPoint2=[Command[Pmr],Command[Pmr+1]]+(Command[0]=="s"?CurrentVertex:[0,0]),
        NextVertex=[Command[Pmr+2],Command[Pmr+3]]+(Command[0]=="s"?CurrentVertex:[0,0]),
        Steps=round(Segments()/3), // 3, probably chosen because expecting more than 120 degrees from a Bézier curve is silly.
        Points=
            [
                for(Idex=[1:Steps]) /* start at 1 because initial point is CurrentVertex */
                    CBezierVertex(
                        [
                            CurrentVertex,
                            ControlPoint1,
                            ControlPoint2,
                            NextVertex
                        ],
                        Idex/Steps
                    )
            ],
        _LastCommand=[Command[0],ControlPoint2,NextVertex]
    )
    PointsOnly // is this an 'out of path' call for a points-list only?
    ?   Points // return the points-list
    :   SVGNextCommand(PathCommands,[CC[0],CC[1],CC[2]+4],Paths,Points,_LastCommand,Calls)
;

