/* TODO: Routine that lists all shapes in a collection. */
/*
  Simply call a shape or icon by it's Collection and Name like this:

    SVG_Shape(favIcons,"YinYang");

*/
/* For [points,paths] call the function:  */
function SVG_Shape(Collection,Name,Size=[1,1],Center=false,Home=false)=
    let(
        // Find the named record in the collection.
        Record=search([Name],Collection)[0],
        // Trap non-existing name.
        PTuple=Record==[]
        ?   Stop(["Collection does not contain an SVG shape named '",Name,"'."])
        :   SVG(Collection[Record][1],Collection[Record][2],Size),
        Domain=ArrayDomain(PTuple[0]),
        Move=Center==true
        ?   PadTuple((Domain[0]+Domain[1])/2)
        :   Home==true
            ?   PadTuple(Domain[0])
            :   undef,
        // Echo the size of the shape.
        Foo=Echo([Name," size = ",(Domain[1]-Domain[0])])
    )
    // Return the shape polygon points and paths in a tuple [points,paths].
    Move==undef
    ?   PTuple
    :   [
            AffineTransform(TranslationMatrix(-Move),PTuple[0]),
            PTuple[1]
        ]
;

/* Returns the actual polygon. */
module SVG_Shape(Collection,Name,Size=[1,1],Center=false,Home=false){

    // Get the [points,paths] tuple.
    Polygon=SVG_Shape(Collection,Name,Size,Center,Home);
    // Generate the polygon.
    polygon(Polygon[0],Polygon[1]);

}
