/*
  Smooth Quadratic Bézier: T/t (Nx,Ny)+.

  This command only makes sense AFTER a preceding C/cubic, Q/quadratic or S/smooth cubic Bézier curve. It would be possible to get a direction vector from other previous commands like H/h &c., but there would be no _sensible_ length information... Calling this without a preceding C/c/Q/q/S/s will therefore result in a 'Stop' error.
*/
function SVG_T(PathCommands,CC,Paths,LastCommand,Calls=1,PointsOnly=false)=
    let(
        Pmr=CC[2], // current parameter
        Command=PathCommands[CC[0]][CC[1]], // current command
        CurrentVertex=Last(LastCommand), // current path's last vertex
        Foo=CC[1]==0
        ?   Stop(["Smooth Cubic Bézier (S/s) called without preceding command. CC= ",CC])
        :   0,
        /*
          the control point is the reflection of the last control point of the previous command, if that command is a _non T/t_ Bézier, it will be the last but one parameter of that command
        */
        LastControlPoint=IsInArray(LastCommand[0],["C","c","S","s","T","t","Q","q"]) // last command is Bézier curve? Outside [] needed because search() treats strings--let's be nice--'peculiarly', so to say...
        ?   LastCommand[Len(LastCommand)-1] // get the last ControlPoint from last command
        :   CurrentVertex+Alert(["Smooth Quadratic Bézier (T/t) called without preceding Bézier curve command. CC= ",CC],Value=[0,0]),
        ControlPoint=2*CurrentVertex-LastControlPoint,
        NextVertex=[Command[Pmr],Command[Pmr+1]]+(Command[0]=="t"?CurrentVertex:[0,0]),
        Steps=round(Segments()/3), // 3, probably chosen because expecting more than 120 degrees from a Bézier curve is silly.
        Points=
            [
                for(Idex=[1:Steps]) /* start at 1 because initial point is CurrentVertex */
                    QBezierVertex(
                        [
                            CurrentVertex,
                            ControlPoint,
                            NextVertex
                        ],
                        Idex/Steps
                    )
            ],
        _LastCommand=[Command[0],ControlPoint,NextVertex]
    )
    PointsOnly // is this an 'out of path' call for a points-list only?
    ?   Points // return the points-list
    :   SVGNextCommand(PathCommands,[CC[0],CC[1],CC[2]+2],Paths,Points,_LastCommand,Calls)
;

