/*
  Vertical line: V/v (Coord/Dist)+
*/
function SVG_V(PathCommands,CC,Paths,LastCommand,Calls=1,PointsOnly=false)=
    let(
        Command=PathCommands[CC[0]][CC[1]], // current command
        Cdex=Len(Command), // current command length
        CurrentVertex=Last(LastCommand), // current path's last vertex
        Points=Command[0]=="v"
        ?   [
                for(Idex=[1:Cdex])
                    [
                        CurrentVertex.x,
                        ArraySum(
                            [
                                for(Jdex=[1:Idex])
                                    Command[Jdex],
                                    CurrentVertex.y
                            ]
                        )
                    ]
            ]
        :   [
                for(Idex=[1:Cdex])
                    [CurrentVertex.x,Command[Idex]]
            ],
        _LastCommand=[Command[0],Last(Points)]
    )
    PointsOnly // is this an 'out of path' call for a points-list only?
    ?   Points // return the points-list
    :   SVGNextCommand(PathCommands,[CC[0],CC[1],len(Command)],Paths,Points,_LastCommand,Calls)
;

