/*
  Chamfered rectangle.
*/
function ChamferedRectangle(Width,Length,Chamfer,Centered=true)=
    let(
        W=Width/2,
        L=Length/2,
        C=Chamfer,
        Center=Centered
        ?   [0,0]
        :   [Width/2,Length/2],
        /* An example of an SVG(Array) call. Should all Shapes 'go SVG'? */
        Polygon=SVG([
            "M",W,L-C,
            W-C,L,
            -W+C,L,
            -W,L-C,
            -W,-L+C,
            -W+C,-L,
            W-C,-L,
            W,-L+C
        ])
    )
    [
        ArrayAdd(Polygon[0],Center),
        Polygon[1]
    ]
;



module ChamferedRectangle(Width,Length,Chamfer,Centered=true){
    Polygon=ChamferedRectangle(Width,Length,Chamfer,Centered);
    polygon(Polygon[0],Polygon[1],2);
}

