/*
  Function and module for an ellipse shape.
*/
function Ellipse(Radius1,Radius2,Centered=true)=
   let(
        Step=360/Segments((Radius1+Radius2)/2),
        Center=Centered
        ?   0
        :   1,
        Vertices=
            [
                for (I=[0:$fn-1])
                    [
                        Radius1*(Center+cos(I*Step)),
                        Radius2*(Center+sin(I*Step))
                    ]
            ],
        Faces=
            [
                [ for (I=[0:$fn-1]) I ]
            ]
    )
    [Vertices,Faces]
;
module Ellipse(Radius1,Radius2,Centered=true){
    Foo=Ellipse(Radius1,Radius2,Centered);
    polygon(Foo[0],Foo[1],2);
}

