/*TODO--- lots, centered
  Maybe you were thinking 'circle(r=...,$fn=3);', but this function makes
  dimensional control easier.
  Type  : "Height" places the apex "Size" units above the base.
          "Side" makes the sides "Size" units long.
          "Radius" is the same size as circle(r=...,$fn=3) but with base against Y-axis.
*/
function EquilateralTriangle(Size,Type="Height",Centered=true)=
    let(
        Points=[[sqrt(3),0],[0,1],[0,-1]],
        Vertices="Side"==Type
        ?    [for(Vertex=Points) Vertex*Size/2-(Centered?[Size/2/sqrt(3),0]:[0,0])]
        :   "Height"==Type
            ?    [for(Vertex=Points) Vertex*Size/sqrt(3)-(Centered?[Size/3,0]:[0,0])]
            :   "Radius"==Type
                ?    [for(Vertex=Points) Vertex*Size/2*sqrt(3)-(Centered?[Size/2,0]:[0,0])]
                :   undef
    )
    [Vertices,[[0,1,2]]]
;
module EquilateralTriangle(Size,Type="Height",Centered=true){
    Foo=EquilateralTriangle(Size,Type,Centered);
    polygon(Foo[0],Foo[1],2);
}


