/*
  Generate a regular polygon.
  Yes, this is the same as 'circle(r=...,$fn=...)' but with better control
  over placement when 'Centered=false'.
  An odd sided regular polygon has a lateral dimension that is less than
  2*'Radius', this function takes that into account with 'Offset'.

  An odd-sided regular polygon has a lateral dimension of 2*Offset.x and a
  mesial dimension of Radius+Offset.y.

  Even sided regular polygons have dimensions of 2*Radius through the
  cardinal points.
*/
//TODO NGONRING
function NGon(Sides=3,Radius=1,Centered=true)=
    let(
        Step=360/Sides,
        OffSet=
            IsEven(Sides)
            ?   [Radius,Radius*cos(180/Sides)]
            :   [Radius*cos(180/Sides),Radius*cos(90/Sides)],
        Foo=Echo(["NGon Offset is ",OffSet]),
        Center=
            Centered
            ?   [0,0]
            : OffSet
    )
    [
        [
            for(I=[0:Sides-1])
            Radius*[cos(I*Step),sin(I*Step)]+Center
        ],
        [
            [ for (I=[0:Sides-1]) I ]
        ]

    ]
;
module NGon(Sides,Radius,Centered=true){
    // Prevent multiple echos from the function.
    Foo=NGon(Sides,Radius,Centered);
    polygon(Foo[0],Foo[1],2);
}
/*
  Helper function to quickly access NGon dimensions
*/
function NGonOffset(Sides,Radius)=
    [Radius*cos(180/Sides),Radius*cos(90/Sides)]
;


