/*TODO centered
  Ellipsoid ring.
*/
function OvalRing(Radius1,Radius2,Wall,Centered=true)=
    (Wall>=Radius1||Wall>=Radius2)
    ?   Error(" OvalRing() : Wall thickness too great @ ",Wall)
    :
    let(
        Points1=Ellipse(Radius1,Radius2),
        Points2=Ellipse(Radius1-Wall,Radius2-Wall)
    )
    [
        AffineTransform(
             TranslationMatrix(Vector=Centered?[0,0,0]:[Radius1,Radius2,0])
            ,concat(Points1[0],Points2[0])
        ),
        [
            [for(Index=[0:len(Points1[0])-1])Index],
            [for(Index=[len(Points1[0]):len(Points1[0])+len(Points2[0])-1])Index]
        ]
    ]
;
module OvalRing(Radius1,Radius2,Wall,Centered=true){
    Foo=OvalRing(Radius1,Radius2,Wall,Centered);
    polygon(Foo[0],Foo[1],2);
}


