/*
  Condense a polygon expressed as an array of arrays of vertices into OpenSCAD polygon notation.
  [[verticeslist1],[verticeslist2],...]
  [[allverticeslist],[[path1],[path2],...]
*/

function PathsToPolygon(Paths)=
    let(
        Lens=[for(Path=Paths)len(Path)]
        )
    len(Paths)==1
        ?   [
                Paths[0],
                [
                    RangeToTuple([0:Lens[0]])
                ]
            ]
        :   [
                FlattenArray(Paths),
                [
                    RangeToTuple([0:Lens[0]-1]),
                    for(I=[1:Len(Lens)])
                        RangeToTuple(
                            [
                                ArraySum(Lens,0,I-1):
                                ArraySum(Lens,0,I)-1
                            ]
                        )
                ]
            ]
;

module PathsToPolygon(Paths)
{
    PP=PathsToPolygon(Paths);
    polygon(PP[0],PP[1]);
}
