function RadiusedRectangle(Width,Length,Radius,Centered=true)=
    let(
        Steps=Segments(Radius)/4,
        Step=90/Steps,
        _W=Width/2-Radius,
        _L=Length/2-Radius,
        Center=Centered
        ?   [0,0]
        :   [_W,_L],
        Points=Radius==0
        ?   [
                [_W,_L]+Center,[-_W,_L]+Center,[-_W,-_L]+Center,[_W,-_L]+Center
            ]
        :   [
                for (I=[0:Steps])
                [_W+cos(I*Step)*Radius,_L+sin(I*Step)*Radius]+Center,
                for (I=[0:Steps])
                [-_W+cos(90+I*Step)*Radius,_L+sin(90+I*Step)*Radius]+Center,
                for (I=[0:Steps])
                [-_W+cos(180+I*Step)*Radius,-_L+sin(180+I*Step)*Radius]+Center,
                for (I=[0:Steps])
                [_W+cos(270+I*Step)*Radius,-_L+sin(270+I*Step)*Radius]+Center
            ]
    )
    [
        Points,
        [
            [ for (I=[0:Steps*4+3]) I ]
        ]
    ]
;
module RadiusedRectangle(Width,Length,Radius,Centered=true){
    Foo=RadiusedRectangle(Width,Length,Radius,Centered);
    polygon(Foo[0],Foo[1],2);
}
