function RectangularProfile(Width,Length,Wall,Radius,Centered=true)=
    let(
        Center=Centered
        ?   [0,0]
        :   [Wall,Wall],

        Points1=RadiusedRectangle(Width,Length,Radius,Centered)[0],
        Points2=ArrayAdd(RadiusedRectangle(Width-2*Wall,Length-2*Wall,
                                  max(0,Radius-Wall),Centered)[0],Center),
        Points=concat(Points1,Points2),
        Faces=[
            [for(Index=[0:len(Points1)-1])Index],
            [for(Index=[0:len(Points2)-1])len(Points1)+Index]
        ]
    )
    [Points,Faces]
;
module RectangularProfile(Width,Length,Wall,Radius,Centered=true){
    Foo=RectangularProfile(Width,Length,Wall,Radius,Centered);
    polygon(Foo[0],Foo[1],2);
}
