/*
  Generate a sector, to be used for a intersection() or difference() cut.
*/
function Sector(StartAngle,EndAngle,Radius)=
    let(
        Vertices=concat([[0,0]],Arc(StartAngle,EndAngle,Radius))
    )
        [
            Vertices,
            [[ for (I=[0:Len(Vertices)]) I ]]
        ]
;

module Sector(StartAngle,EndAngle,Radius){
    S=Sector(StartAngle,EndAngle,Radius);
    polygon(S[0],S[1],4);
}
