/*
  Yes, OpenSCAD has a square, but this is a square you can do Cap(Square(2,5)) with (and some other stuff).
*/
function Square(Width,Length,Centered=true)=
    let(
        _W=Width/2,
        _L=Length/2,
        Center=Centered
        ?   [0,0]
        :   [_W,_L],
        Points=
            [
                [_W,_L]+Center,[-_W,_L]+Center,[-_W,-_L]+Center,[_W,-_L]+Center
            ]
    )
    [
        Points,
        [
            [0,1,2,3]
        ]
    ]
;
module Square(Width,Length,Centered=true){
    Foo=Square(Width,Length,Centered);
    polygon(Foo[0],Foo[1],2);
}


