/*
  Returns true if input is a Hex number. You can simultaneously check that is is of a certain length; a leading '#' is ignored.
 */
function IsHex(String,Length)=
    let(
        // Scrub leading '#'.
        _String=String[0]=="#"
        ?   RightString(String,1)
        :   String,
        // Check length is *Length*.
        Fit=Length==undef
        // If no length specified, defaults to _true_.
        ?   true
        :   len(_String)==Length
    )
    // Check all characters are valid hex.
    (_IsHex(_String,Len(_String))&&Fit)
;
/*
  IsHex() recursive helper, walks through 'String' until a character is NOT valid hex and returns 'false', or until all characters check valid, and returns 'true'.
*/
function _IsHex(String,Idex)=
    Idex<0
    ?   true
    :   search(String[Idex],HexCharLow)==[]
        ?   false
        :   _IsHex(String,Idex-1)
;
