/*
  Map a string to codes representative of its characters.

  Returns an array filled with the codes representative of the input string characters.

  echo(Mapstring("bac",[1,2,3],"abc"));
  gives
  ~ECHO: [2,1,3]
*/
function MapString(String,ResultArray=PrintableCodes,SearchString=PrintableCharacters)=
    !IsString(String)
    ?   undef
    :   [ for (Result=search(String,SearchString))
            Result==undef
            ?   undef
            :   ResultArray[Result]
        ]
;
