/*
  Removes all but the first occurrence of an element from an array.

  Also works for strings, but the result will always be an array; if you want to remove identicals from a string and get a string as the result, simply do:

  MyResult=TupletoString(RemoveRepeated(MyString));

  echo(RemoveRepeated("Abracadabra"));
  ECHO: ["A", "b", "r", "a", "c", "d"]

  echo(TupleToString(RemoveRepeated("Abracadabra")));
  ECHO: "Abracd"
*/
function ScrubRepeated(String)=
    let(
        FirstLocations=[
            for(Idex=[0:Len(String)])
                search(String[Idex],String)[0]
        ]
    )
    TupleToString(
        [
            for(Jdex=[0:Len(String)])
                Jdex==FirstLocations[Jdex]
                ?   String[Jdex]
                :   undef
        ]
    )
;
