/*
  Crop numbers for display or echo purposes
  SetDecimals(1.23456,0) => 1
  SetDecimals(1.23456,2) => 1.23
  SetDecimals(1.23,4) => 1.2300
 */
function SetDecimals(Value,Decimals,Padding=0)=
    let(
        Int=floor(Value),
        Rem=str(Value-Int),
        Dec=Rem=="0"
        ?   "."
        :   Decimals<len(Rem)-1
            ?   SubString(Rem,1,Decimals+1)
            :   SubString(Rem,1),
        Fill=len(Dec)<Decimals+1
        ?   TupleToString([for(Index=[0:Decimals-len(Dec)])str(Padding)])
        :   ""
    )
    Decimals>0
    ?   str(Int,Dec,Fill)
    :   str(Int)
;
