/*
  Returns the decimal value of a (base 10) numerical string representing a real number.
*/
function StringToDecimal(String)=
    let(
        _String=ScrubNonNumbers(String),
        Sig=_String[0]=="-"
        ?   -1
        :   1,
        Dec=search(".",_String)[0],
        Mult=Dec==undef
        ?   Sig
        :   Sig/pow(10,Len(_String)-(Dec)),
        Tuple=[
            for(Character=_String)
                if(search(Character,Digits)!=[])
                search(Character,Digits)
        ],
        TN=Len(Tuple)
    )
    ArraySum(
        [
            for(Idex=[0:TN])
                Tuple[TN-Idex]*pow(10,Idex)
        ]
    )[0]*Mult
;

function ScrubNonNumbers(String)=
    TupleToString([
                for(Character=String)
                if(IsInArray(AsciiMapString(Character)[0],NumericAscii))
                    Character
    ])
;
