/*
  Returns characters from start to end, 0-base, inclusive, end can be negative, in which case it means 'x characters from the end'.
*/
// Errortrap
function SubString(String,Begin=0,End=-1)=
    let(
        _Begin=Dex(Begin,Len(String)),
        Foo=Alert(["Begin = ",Begin," and out of range, mapped onto ",_Begin,"."],0,abs(Begin)>Len(String)),
        _End=Dex(End,Len(String)),
        Bar=Alert(["End = ",End," and out of range, mapped onto ",_End,"."],0,abs(End)>Len(String))
    )
    _End<_Begin
    ?   undef
    :   _SubString(String,_Begin,_End-1,String[_End])
;

// Recursive helper.
function _SubString(String,Begin,Index,Result) =
    Index<Begin
    ?   Result
    :   _SubString(String,Begin,Index-1,
            str(String[Index],Result)
        )
;

